from scholarly import scholarly
from scholarly import ProxyGenerator
import json

# Activates proxy because Google Scholar otherwise might block the IP address
pg = ProxyGenerator()
scholarly.use_proxy(pg, pg)

def main(name):
    author = next(scholarly.search_author(name))
    author = scholarly.fill((author),sections = ['publications'])
    json.dump(author, open(f"{name}.json", "w"), indent=4)

if __name__=="__main__":
    main("yunji chen")