# crawler

## update

更新陈老师的文章列表信息`yunjichen.json`，后续`main.py`依赖此文件检索引用文献。

## main

创建`papers.txt`并在其中逐行加入你需要检索的论文标题，不建议输入完整标题，输入部分标题即可，如下所示：

```
Reproducing Concurrency Bugs Using Local Clocks
binary translator with post-optimization
timing error mitigation for hardware neural networks
A Polyvalent Machine Learning Accelerator
```

已爬取过的链接在`urls.txt`中记录，避免重复爬取，`main.py`文件可重复运行，爬取失败建议检查网络连接。

### 2. **运行脚本**

确保你的环境已安装必要依赖（如`pandas`, `openpyxl`, `tqdm`等）。

命令行运行：

```bash
python main.py
```

或 **指定年份**（仅爬取该年份的引用）：

```bash
python main.py --year 2023
```

### 3. **查看结果**

抓取后将在`results/`下生成`citations.xlsx`，每个论文一个表单，包含被引论文的Title、URL、作者信息等。

------

## **参数说明**

- `--year` 指定年份，仅抓取该年度的引用。不加该参数则会爬取**所有年份**的引用信息。

  **用法示例：**

  - 爬取全部（默认）： `python main.py`
  - 仅抓2022年的引用： `python main.py --year 2022`