# Usage:
#   tvm_source_group(<group> GLOB[_RECURSE] <globbing_expression>)
function(tvm_source_group group)
  cmake_parse_arguments(TVM_SOURCE_GROUP "" "" "GLOB;GLOB_RECURSE" ${ARGN})
  if(TVM_SOURCE_GROUP_GLOB)
    file(GLOB srcs1 ${TVM_SOURCE_GROUP_GLOB})
    source_group(${group} FILES ${srcs1})
  endif()

  if(TVM_SOURCE_GROUP_GLOB_RECURSE)
    file(GLOB_RECURSE srcs2 ${TVM_SOURCE_GROUP_GLOB_RECURSE})
    source_group(${group} FILES ${srcs2})
  endif()
endfunction()

#######################################################
# An option that the user can select. Can accept condition to control when option is available for user.
# Usage:
#   tvm_option(<option_variable> "doc string" <initial value or boolean expression> [IF <condition>])
function(tvm_option variable description value)
  set(__value ${value})
  set(__condition "")
  set(__varname "__value")
  foreach(arg ${ARGN})
    if(arg STREQUAL "IF" OR arg STREQUAL "if")
      set(__varname "__condition")
    else()
      list(APPEND ${__varname} ${arg})
    endif()
  endforeach()
  unset(__varname)
  if("${__condition}" STREQUAL "")
    set(__condition 2 GREATER 1)
  endif()

  if(${__condition})
    if("${__value}" MATCHES ";")
      if(${__value})
        option(${variable} "${description}" ON)
      else()
        option(${variable} "${description}" OFF)
      endif()
    elseif(DEFINED ${__value})
      if(${__value})
        option(${variable} "${description}" ON)
      else()
        option(${variable} "${description}" OFF)
      endif()
    else()
      option(${variable} "${description}" ${__value})
    endif()
  else()
    unset(${variable} CACHE)
  endif()
endfunction()