Contributors of TVM
===================
TVM adopts Apache style committer model.
The package is developed and used by the community.

We actively seek committers that come from community contributors who:
- Made substantial contributions to the project.
  - All forms of contributions are valued (see detail in next section).
- Maintain quality standards in contributions
  - e.g. consistently made contributions without requiring extensive
    rewrites prior to being merged.
- Willing to spend time on maintaining and lead the project.

Contributions
-------------
We value all forms of contributions, here is a non-comprehensive
list of contributions that are welcomed

- Documentation and usage examples
- Community participation, answering questions and issues.
- Code readability and developer guide
  - We welcome contributions that add code comments
    to improve readability
  - We also welcome contributions to docs to explain the
    design choices of the internal.
- Test cases to make the codebase more robust
- Tutorials, blog posts, talks that promote the project.

How to Contribute
-----------------
See [Contributor guide](docs/how_to/contribute.md) on tips for contributions.


Committers
----------
Committers are people who have made substantial contribution to the project and granted write access to the project.
- [Tianqi Chen](https://github.com/tqchen), University of Washington
- [Thierry Moreau](http://homes.cs.washington.edu/~moreau/), University of Washington
- [Haichen Shen](http://homes.cs.washington.edu/~haichen/), University of Washington
- [Ziheng Jiang](https://github.com/ZihengJiang), Fudan University

Code Owners
-----------
[Code owners](CODEOWNERS) are people who make substantial contribution to a module
and are qualified to lead development and review changes of the owned module.

- [Aditya Atluri](https://github.com/adityaatluri) ROCM
- [Leyuan Wang](https://github.com/Laurawly) TOPI
- [Yuwei Hu](https://github.com/Huyuwei) TOPI
- [Yizhi Liu](https://github.com/yzhliu) JVM package
- [Zhixun Tan](https://github.com/phisiart) OpenGL/WebGL backend
- [Nick Hynes](https://github.com/nhynes) SGX and secured computing


List of Contributors
--------------------
- [Full List of Contributors](https://github.com/dmlc/tvm/graphs/contributors)
  - To contributors: please add your name to the list.
- [Qiao Zhang](https://github.com/zhangqiaorjc)
- [Jian Weng](https://github.com/were)
- [Masahiro Masuda](https://github.com/masahi)
- [Haolong Zhang](https://github.com/haolongzhangm)
- [Cody Hao Yu](https://github.com/comaniac)
- [Chris Nuernberger](https://github.com/cnuernber)
- [Tatsuya Nishiyama](https://github.com/nishi-t)
- [Kazutaka Morita](https://github.com/kazum)
