<!--- Licensed to the Apache Software Foundation (ASF) under one -->
<!--- or more contributor license agreements.  See the NOTICE file -->
<!--- distributed with this work for additional information -->
<!--- regarding copyright ownership.  The ASF licenses this file -->
<!--- to you under the Apache License, Version 2.0 (the -->
<!--- "License"); you may not use this file except in compliance -->
<!--- with the License.  You may obtain a copy of the License at -->

<!---   http://www.apache.org/licenses/LICENSE-2.0 -->

<!--- Unless required by applicable law or agreed to in writing, -->
<!--- software distributed under the License is distributed on an -->
<!--- "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY -->
<!--- KIND, either express or implied.  See the License for the -->
<!--- specific language governing permissions and limitations -->
<!--- under the License. -->

TVM Contributors
================
TVM adopts the Apache way and governs by merit. We believe that it is important to create an inclusive community where everyone can use,
contribute to, and influence the direction of the project. We actively invite contributors who have earned the merit to be part of the development community.

See the [community structure document](https://tvm.apache.org/docs/contribute/community.html) for the explanation of community structure and contribution guidelines.

## Mentors

TVM is now part of the Apache Incubator.
We are fortunate to have the following mentors.

- Markus Weimer @markusweimer
- Sebastian Schelter @sscdotopen
- Byung-Gon Chun @bgchun
- Henry Saputra @hsaputra
- Timothy Chen @tnachen
- Furkan KAMACI @kamaci

## Committers

We add tag along with committer name to show areas that they are familiar with.
We do encourage everyone to work anything they are interested in.

- [Aditya Atluri](https://github.com/adityaatluri): @adityaatluri - rocm
- [Tianqi Chen](https://github.com/tqchen) (PPMC): @tqchen - topi, compiler, relay, docs
- [Wei Chen](https://github.com/wweic): @wweic - runtime, relay, vm
- [Zhi Chen](https://github.com/zhiics): @zhiics - relay, quantization, pass manager
- [Yuwei Hu](https://github.com/Huyuwei): @Huyuwei - topi, frontends
- [Nick Hynes](https://github.com/nhynes): @nhynes: - sgx, rust
- [Animesh Jain](https://github.com/anijain2305): @anijain2305 - quantization, relay
- [Ziheng Jiang](https://github.com/ZihengJiang) (PPMC): @ZihengJiang - relay, compiler
- [Marisa Kirisame](https://github.com/MarisaKirisame): @MarisaKirisame - relay
- [Wuwei Lin](https://github.com/vinx13): @vinx13 - relay, topi
- [Yizhi Liu](https://github.com/yzhliu) (PPMC): @yzhliu - jvm, topi, relay
- [Hao Lu](https://github.com/hlu1): @hlu1 - nnpack, frontends
- [Masahiro Masuda](https://github.com/masahi): @masahi - topi, relay
- [Thierry Moreau](https://github.com/tmoreau89) (PPMC): @tmoreau89 - vta
- [Kazutaka Morita](https://github.com/kazum): @kazum - frontends, opencl
- [Jared Roesch](https://github.com/jroesch) (PPMC): @jroesch - relay
- [Siva](https://github.com/srkreddy1238): @srkreddy1238 - frontends, golang
- [Haichen Shen](https://github.com/icemelon9) (PPMC): @icemelon9 - relay, topi
- [Zhixun Tan](https://github.com/phisiart): @phisiart - opengl, web
- [Andrew Tulloch](https://github.com/ajtulloch): @ajtulloch - topi, compiler, runtime
- [Leyuan Wang](https://github.com/Laurawly): @Laurawly: - topi
- [Yao Wang](https://github.com/kevinthesun): @kevinthesun: - topi, vision
- [Jian Weng](https://github.com/were): @were: - hybrid script
- [Zhao Wu](https://github.com/FrozenGene): @FrozenGene - runtime, topi, frontends
- [Eddie Yan](https://github.com/eqy) (PPMC): @eqy - runtime, autotvm, rpc, topi
- [Lianmin Zheng](https://github.com/merrymercy) (PPMC): @merrymercy - autotvm, topi, relay

## Reviewers

- [Aditya Atluri](https://github.com/adityaatluri): @adityaatluri
- [Matthew Barrett](https://github.com/mbaret): @mbaret
- [Arnaud Bergeron](https://github.com/abergeron): @abergeron
- [Tianqi Chen](https://github.com/tqchen): @tqchen
- [Liangfu Chen](https://github.com/liangfu): @liangfu
- [Zhi Chen](https://github.com/zhiics): @zhiics
- [Neo Chien](https://github.com/cchung100m): @cchung100m
- [Meghan Cowan](https://github.com/cowanmeg): @cowanmeg
- [Balint Cristian](https://github.com/cbalint13): @cbalint13
- [Josh Fromm](https://github.com/jwfromm): @jwfromm
- [Sergei Grechanik](https://github.com/sgrechanik-h): @sgrechanik-h
- [Hao Lu](https://github.com/hlu1): @hlu1
- [Nick Hynes](https://github.com/nhynes): @nhynes
- [Yuwei Hu](https://github.com/Huyuwei): @Huyuwei
- [Animesh Jain](https://github.com/anijain2305): @anijain2305
- [Hua Jiang](https://github.com/huajsj): @huajsj
- [Yizhi Liu](https://github.com/yzhliu) : @yzhliu
- [Zhixun Tan](https://github.com/phisiart): @phisiart
- [Zhi Chen](https://github.com/zhiics): @zhiics
- [Xiaoqiang Dan](https://github.com/xqdan): @xqdan
- [Ziheng Jiang](https://github.com/ZihengJiang): @ZihengJiang
- [Marisa Kirisame](https://github.com/MarisaKirisame): @MarisaKirisame
- [Wuwei Lin](https://github.com/vinx13): @vinx13
- [Henry Liu](https://github.com/optima2005): @optima2005
- [Steven Lyubomirsky](https://github.com/slyubomirsky): @slyubomirsky
- [Masahiro Masuda](https://github.com/masahi): @masahi
- [Sergey Mironov](https://github.com/grwlf): @grwlf
- [Thierry Moreau](https://github.com/tmoreau89): @tmoreau89
- [Kazutaka Morita](https://github.com/kazum): @kazum
- [Tatsuya Nishiyama](https://github.com/nishi-t): @nishi-t
- [Pariksheet Pinjari](https://github.com/PariksheetPinjari909): @PariksheetPinjari909
- [Josh Pollock](https://github.com/joshpoll): @joshpoll
- [Jared Roesch](https://github.com/jroesch): @jroesch
- [Siva](https://github.com/srkreddy1238): @srkreddy1238
- [Siju Samuel](https://github.com/siju-samuel): @siju-samuel
- [Junru Shao](https://github.com/junrushao1994): @junrushao1994
- [Haichen Shen](https://github.com/icemelon9): @icemelon9
- [Xingjian Shi](https://github.com/sxjscience): @sxjscience
- [Jon Soifer](https://github.com/soiferj): @soiferj
- [Andrew Tulloch](https://github.com/ajtulloch): @ajtulloch
- [Luis Vega](https://github.com/vegaluisjose): @vegaluisjose
- [Alex Weaver](https://github.com/alex-weaver): @alex-weaver
- [Yao Wang](https://github.com/kevinthesun): @kevinthesun
- [Leyuan Wang](https://github.com/Laurawly): @Laurawly
- [Logan Weber](https://github.com/weberlo): @weberlo
- [Jian Weng](https://github.com/were): @were
- [Yong Wu](https://github.com/yongwww): @yongwww
- [Zhao Wu](https://github.com/FrozenGene): @FrozenGene
- [Bing Xu](https://github.com/antinucleon): @antinucleon
- [Eddie Yan](https://github.com/eqy): @eqy
- [Hao Yu](https://github.com/comaniac): @comaniac
- [Joshua Z. Zhang](https://github.com/zhreshold): @zhreshold
- [Lianmin Zheng](https://github.com/merrymercy): @merrymercy

## List of Contributors
- [Full List of Contributors](https://github.com/apache/incubator-tvm/graphs/contributors)
  - To contributors: please add your name to the list.
- [Qiao Zhang](https://github.com/zhangqiaorjc)
- [Haolong Zhang](https://github.com/haolongzhangm)
- [Cody Hao Yu](https://github.com/comaniac)
- [Chris Nuernberger](https://github.com/cnuernber)
- [Shoubhik Bhattacharya](https://github.com/shoubhik)
