/* automatically generated by rust-bindgen for TVM revision 6292c78 */

pub const TVM_VERSION: &'static [u8; 8usize] = b"0.5.dev\0";
pub const DLPACK_VERSION: u32 = 8;
pub const _STDINT_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_ISO_10646__: u32 = 201505;
pub const __STDC_NO_THREADS__: u32 = 1;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 23;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const _BITS_WCHAR_H: u32 = 1;
pub const INT8_MIN: i32 = -128;
pub const INT16_MIN: i32 = -32768;
pub const INT32_MIN: i32 = -2147483648;
pub const INT8_MAX: u32 = 127;
pub const INT16_MAX: u32 = 32767;
pub const INT32_MAX: u32 = 2147483647;
pub const UINT8_MAX: u32 = 255;
pub const UINT16_MAX: u32 = 65535;
pub const UINT32_MAX: u32 = 4294967295;
pub const INT_LEAST8_MIN: i32 = -128;
pub const INT_LEAST16_MIN: i32 = -32768;
pub const INT_LEAST32_MIN: i32 = -2147483648;
pub const INT_LEAST8_MAX: u32 = 127;
pub const INT_LEAST16_MAX: u32 = 32767;
pub const INT_LEAST32_MAX: u32 = 2147483647;
pub const UINT_LEAST8_MAX: u32 = 255;
pub const UINT_LEAST16_MAX: u32 = 65535;
pub const UINT_LEAST32_MAX: u32 = 4294967295;
pub const INT_FAST8_MIN: i32 = -128;
pub const INT_FAST16_MIN: i64 = -9223372036854775808;
pub const INT_FAST32_MIN: i64 = -9223372036854775808;
pub const INT_FAST8_MAX: u32 = 127;
pub const INT_FAST16_MAX: u64 = 9223372036854775807;
pub const INT_FAST32_MAX: u64 = 9223372036854775807;
pub const UINT_FAST8_MAX: u32 = 255;
pub const UINT_FAST16_MAX: i32 = -1;
pub const UINT_FAST32_MAX: i32 = -1;
pub const INTPTR_MIN: i64 = -9223372036854775808;
pub const INTPTR_MAX: u64 = 9223372036854775807;
pub const UINTPTR_MAX: i32 = -1;
pub const PTRDIFF_MIN: i64 = -9223372036854775808;
pub const PTRDIFF_MAX: u64 = 9223372036854775807;
pub const SIG_ATOMIC_MIN: i32 = -2147483648;
pub const SIG_ATOMIC_MAX: u32 = 2147483647;
pub const SIZE_MAX: i32 = -1;
pub const WINT_MIN: u32 = 0;
pub const WINT_MAX: u32 = 4294967295;
pub type int_least8_t = ::std::os::raw::c_schar;
pub type int_least16_t = ::std::os::raw::c_short;
pub type int_least32_t = ::std::os::raw::c_int;
pub type int_least64_t = ::std::os::raw::c_long;
pub type uint_least8_t = ::std::os::raw::c_uchar;
pub type uint_least16_t = ::std::os::raw::c_ushort;
pub type uint_least32_t = ::std::os::raw::c_uint;
pub type uint_least64_t = ::std::os::raw::c_ulong;
pub type int_fast8_t = ::std::os::raw::c_schar;
pub type int_fast16_t = ::std::os::raw::c_long;
pub type int_fast32_t = ::std::os::raw::c_long;
pub type int_fast64_t = ::std::os::raw::c_long;
pub type uint_fast8_t = ::std::os::raw::c_uchar;
pub type uint_fast16_t = ::std::os::raw::c_ulong;
pub type uint_fast32_t = ::std::os::raw::c_ulong;
pub type uint_fast64_t = ::std::os::raw::c_ulong;
pub type intmax_t = ::std::os::raw::c_long;
pub type uintmax_t = ::std::os::raw::c_ulong;
pub type wchar_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct max_align_t {
  pub __clang_max_align_nonce1: ::std::os::raw::c_longlong,
  pub __bindgen_padding_0: u64,
  pub __clang_max_align_nonce2: f64,
}
pub const DLDeviceType_kDLCPU: DLDeviceType = 1;
pub const DLDeviceType_kDLGPU: DLDeviceType = 2;
pub const DLDeviceType_kDLCPUPinned: DLDeviceType = 3;
pub const DLDeviceType_kDLOpenCL: DLDeviceType = 4;
pub const DLDeviceType_kDLMetal: DLDeviceType = 8;
pub const DLDeviceType_kDLVPI: DLDeviceType = 9;
pub const DLDeviceType_kDLROCM: DLDeviceType = 10;
/// \brief The device type in DLContext.
pub type DLDeviceType = u32;
/// \brief A Device context for Tensor and operator.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DLContext {
  /// \brief The device type used in the device.
  pub device_type: DLDeviceType,
  /// \brief The device index
  pub device_id: ::std::os::raw::c_int,
}
pub const DLDataTypeCode_kDLInt: DLDataTypeCode = 0;
pub const DLDataTypeCode_kDLUInt: DLDataTypeCode = 1;
pub const DLDataTypeCode_kDLFloat: DLDataTypeCode = 2;
/// \brief The type code options DLDataType.
pub type DLDataTypeCode = u32;
/// \brief The data type the tensor can hold.
///
/// Examples
/// - float: type_code = 2, bits = 32, lanes=1
/// - float4(vectorized 4 float): type_code = 2, bits = 32, lanes=4
/// - int8: type_code = 0, bits = 8, lanes=1
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DLDataType {
  /// \brief Type code of base types.
  /// We keep it uint8_t instead of DLDataTypeCode for minimal memory
  /// footprint, but the value should be one of DLDataTypeCode enum values.
  ///
  pub code: u8,
  /// \brief Number of bits, common choices are 8, 16, 32.
  pub bits: u8,
  /// \brief Number of lanes in the type, used for vector types.
  pub lanes: u16,
}
/// \brief Plain C Tensor object, does not manage memory.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DLTensor {
  /// \brief The opaque data pointer points to the allocated data.
  /// This will be CUDA device pointer or cl_mem handle in OpenCL.
  /// This pointer is always aligns to 256 bytes as in CUDA.
  pub data: *mut ::std::os::raw::c_void,
  /// \brief The device context of the tensor
  pub ctx: DLContext,
  /// \brief Number of dimensions
  pub ndim: ::std::os::raw::c_int,
  /// \brief The data type of the pointer
  pub dtype: DLDataType,
  /// \brief The shape of the tensor
  pub shape: *mut i64,
  /// \brief strides of the tensor,
  /// can be NULL, indicating tensor is compact.
  pub strides: *mut i64,
  /// \brief The offset in bytes to the beginning pointer to data
  pub byte_offset: u64,
}
/// \brief C Tensor object, manage memory of DLTensor. This data structure is
/// intended to faciliate the borrowing of DLTensor by another framework. It is
/// not meant to transfer the tensor. When the borrowing framework doesn't need
/// the tensor, it should call the deleter to notify the host that the resource
/// is no longer needed.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct DLManagedTensor {
  /// \brief DLTensor which is being memory managed
  pub dl_tensor: DLTensor,
  /// \brief the context of the original host framework of DLManagedTensor in
  /// which DLManagedTensor is used in the framework. It can also be NULL.
  pub manager_ctx: *mut ::std::os::raw::c_void,
  /// \brief Destructor signature void (*)(void*) - this should be called
  /// to destruct manager_ctx which holds the DLManagedTensor. It can be NULL
  /// if there is no way for the caller to provide a reasonable destructor.
  pub deleter: ::std::option::Option<unsafe extern "C" fn(self_: *mut DLManagedTensor)>,
}
/// \brief type of array index.
pub type tvm_index_t = i64;
pub const TVMDeviceExtType_kDLAOCL: TVMDeviceExtType = 5;
pub const TVMDeviceExtType_kDLSDAccel: TVMDeviceExtType = 6;
pub const TVMDeviceExtType_kDLVulkan: TVMDeviceExtType = 7;
pub const TVMDeviceExtType_kOpenGL: TVMDeviceExtType = 11;
pub const TVMDeviceExtType_kExtDev: TVMDeviceExtType = 12;
/// \brief Extension device types in TVM
pub type TVMDeviceExtType = u32;
pub const TVMTypeCode_kHandle: TVMTypeCode = 3;
pub const TVMTypeCode_kNull: TVMTypeCode = 4;
pub const TVMTypeCode_kTVMType: TVMTypeCode = 5;
pub const TVMTypeCode_kTVMContext: TVMTypeCode = 6;
pub const TVMTypeCode_kArrayHandle: TVMTypeCode = 7;
pub const TVMTypeCode_kNodeHandle: TVMTypeCode = 8;
pub const TVMTypeCode_kModuleHandle: TVMTypeCode = 9;
pub const TVMTypeCode_kFuncHandle: TVMTypeCode = 10;
pub const TVMTypeCode_kStr: TVMTypeCode = 11;
pub const TVMTypeCode_kBytes: TVMTypeCode = 12;
pub const TVMTypeCode_kNDArrayContainer: TVMTypeCode = 13;
pub const TVMTypeCode_kExtBegin: TVMTypeCode = 15;
pub const TVMTypeCode_kNNVMFirst: TVMTypeCode = 16;
pub const TVMTypeCode_kNNVMLast: TVMTypeCode = 20;
pub const TVMTypeCode_kExtReserveEnd: TVMTypeCode = 64;
pub const TVMTypeCode_kExtEnd: TVMTypeCode = 128;
/// \brief The type code in TVMType
/// \note TVMType is used in two places.
pub type TVMTypeCode = u32;
/// \brief The data type used in TVM Runtime.
///
/// Examples
/// - float: type_code = 2, bits = 32, lanes=1
/// - float4(vectorized 4 float): type_code = 2, bits = 32, lanes=4
/// - int8: type_code = 0, bits = 8, lanes=1
///
/// \note Arguments TVM API function always takes bits=64 and lanes=1
pub type TVMType = DLDataType;
/// \brief The Device information, abstract away common device types.
pub type TVMContext = DLContext;
/// \brief The tensor array stucture to TVM API.
pub type TVMArray = DLTensor;
/// \brief the array handle
pub type TVMArrayHandle = *mut TVMArray;
/// \brief Union type of values
/// being passed through API and function calls.
#[repr(C)]
#[derive(Copy, Clone)]
pub union TVMValue {
  pub v_int64: i64,
  pub v_float64: f64,
  pub v_handle: *mut ::std::os::raw::c_void,
  pub v_str: *const ::std::os::raw::c_char,
  pub v_type: TVMType,
  pub v_ctx: TVMContext,
  _bindgen_union_align: u64,
}
/// \brief Byte array type used to pass in byte array
/// When kBytes is used as data type.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TVMByteArray {
  pub data: *const ::std::os::raw::c_char,
  pub size: usize,
}
/// \brief Handle to TVM runtime modules.
pub type TVMModuleHandle = *mut ::std::os::raw::c_void;
/// \brief Handle to packed function handle.
pub type TVMFunctionHandle = *mut ::std::os::raw::c_void;
/// \brief Handle to hold return value.
pub type TVMRetValueHandle = *mut ::std::os::raw::c_void;
/// \brief The stream that is specific to device
/// can be NULL, which indicates the default one.
pub type TVMStreamHandle = *mut ::std::os::raw::c_void;
extern "C" {
  /// \brief Used for implementing C API function.
  /// Set last error message before return.
  /// \param msg The error message to be set.
  pub fn TVMAPISetLastError(msg: *const ::std::os::raw::c_char);
}
extern "C" {
  /// \brief return str message of the last error
  /// all function in this file will return 0 when success
  /// and -1 when an error occured,
  /// TVMGetLastError can be called to retrieve the error
  ///
  /// this function is threadsafe and can be called by different thread
  /// \return error info
  pub fn TVMGetLastError() -> *const ::std::os::raw::c_char;
}
extern "C" {
  /// \brief Load module from file.
  /// \param file_name The file name to load the module from.
  /// \param format The format of the module.
  /// \param out The result module
  ///
  /// \return 0 when success, -1 when failure happens
  /// \note The resulting module do not contain import relation.
  /// It can be reconstructed by TVMModImport.
  pub fn TVMModLoadFromFile(
    file_name: *const ::std::os::raw::c_char,
    format: *const ::std::os::raw::c_char,
    out: *mut TVMModuleHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Add dep to mod's dependency.
  /// This allows functions in this module to use modules.
  ///
  /// \param mod The module handle.
  /// \param dep The dependent module to be imported.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMModImport(mod_: TVMModuleHandle, dep: TVMModuleHandle) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Get function from the module.
  /// \param mod The module handle.
  /// \param func_name The name of the function.
  /// \param query_imports Whether to query imported modules
  /// \param out The result function, can be NULL if it is not available.
  /// \return 0 when no error is thrown, -1 when failure happens
  pub fn TVMModGetFunction(
    mod_: TVMModuleHandle,
    func_name: *const ::std::os::raw::c_char,
    query_imports: ::std::os::raw::c_int,
    out: *mut TVMFunctionHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Free front-end extension type resource.
  /// \param handle The extension handle.
  /// \param type_code The type of of the extension type.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMExtTypeFree(
    handle: *mut ::std::os::raw::c_void,
    type_code: ::std::os::raw::c_int,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Free the Module
  /// \param mod The module to be freed.
  ///
  /// \note This may not free up the module's resources.
  /// If there is active TVMFunctionHandle uses the module
  /// Or if this module is imported by another active module.
  ///
  /// The all functions remains valid until TVMFuncFree is called.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMModFree(mod_: TVMModuleHandle) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Free the function when it is no longer needed.
  /// \param func The function handle
  /// \return 0 when success, -1 when failure happens
  pub fn TVMFuncFree(func: TVMFunctionHandle) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Call a Packed TVM Function.
  ///
  /// \param func node handle of the function.
  /// \param arg_values The arguments
  /// \param type_codes The type codes of the arguments
  /// \param num_args Number of arguments.
  ///
  /// \param ret_val The return value.
  /// \param ret_type_code the type code of return value.
  ///
  /// \return 0 when success, -1 when failure happens
  /// \note TVM calls always exchanges with type bits=64, lanes=1
  ///
  /// \note API calls always exchanges with type bits=64, lanes=1
  /// If API call returns container handles (e.g. FunctionHandle)
  /// these handles should be managed by the front-end.
  /// The front-end need to call free function (e.g. TVMFuncFree)
  /// to free these handles.
  pub fn TVMFuncCall(
    func: TVMFunctionHandle,
    arg_values: *mut TVMValue,
    type_codes: *mut ::std::os::raw::c_int,
    num_args: ::std::os::raw::c_int,
    ret_val: *mut TVMValue,
    ret_type_code: *mut ::std::os::raw::c_int,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Set the return value of TVMPackedCFunc.
  ///
  /// This function is called by TVMPackedCFunc to set the return value.
  /// When this function is not called, the function returns null by default.
  ///
  /// \param ret The return value handle, pass by ret in TVMPackedCFunc
  /// \param value The value to be returned.
  /// \param type_code The type of the value to be returned.
  /// \param num_ret Number of return values, for now only 1 is supported.
  pub fn TVMCFuncSetReturn(
    ret: TVMRetValueHandle,
    value: *mut TVMValue,
    type_code: *mut ::std::os::raw::c_int,
    num_ret: ::std::os::raw::c_int,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Inplace translate callback argument value to return value.
  /// This is only needed for non-POD arguments.
  ///
  /// \param value The value to be translated.
  /// \param code The type code to be translated.
  /// \note This function will do a shallow copy when necessary.
  ///
  /// \return 0 when success, -1 when failure happens.
  pub fn TVMCbArgToReturn(
    value: *mut TVMValue,
    code: ::std::os::raw::c_int,
  ) -> ::std::os::raw::c_int;
}
/// \brief C type of packed function.
///
/// \param args The arguments
/// \param type_codes The type codes of the arguments
/// \param num_args Number of arguments.
/// \param ret The return value handle.
/// \param resource_handle The handle additional resouce handle from fron-end.
/// \return 0 if success, -1 if failure happens, set error via TVMAPISetLastError.
/// \sa TVMCFuncSetReturn
pub type TVMPackedCFunc = ::std::option::Option<
  unsafe extern "C" fn(
    args: *mut TVMValue,
    type_codes: *mut ::std::os::raw::c_int,
    num_args: ::std::os::raw::c_int,
    ret: TVMRetValueHandle,
    resource_handle: *mut ::std::os::raw::c_void,
  ) -> ::std::os::raw::c_int,
>;
/// \brief C callback to free the resource handle in C packed function.
/// \param resource_handle The handle additional resouce handle from fron-end.
pub type TVMPackedCFuncFinalizer =
  ::std::option::Option<unsafe extern "C" fn(resource_handle: *mut ::std::os::raw::c_void)>;
/// \brief Signature for extension function declarer.
///
/// TVM call this function to get the extension functions
/// The declarer will call register_func to register function and their name.
///
/// \param register_func_handle The register function
/// \return 0 if success, -1 if failure happens
pub type TVMExtensionFuncDeclarer = ::std::option::Option<
  unsafe extern "C" fn(register_func_handle: TVMFunctionHandle) -> ::std::os::raw::c_int,
>;
extern "C" {
  /// \brief Wrap a TVMPackedCFunc to become a FunctionHandle.
  ///
  /// The resource_handle will be managed by TVM API, until the function is no longer used.
  ///
  /// \param func The packed C function.
  /// \param resource_handle The resource handle from front-end, can be NULL.
  /// \param fin The finalizer on resource handle when the FunctionHandle get freed, can be NULL
  /// \param out the result function handle.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMFuncCreateFromCFunc(
    func: TVMPackedCFunc,
    resource_handle: *mut ::std::os::raw::c_void,
    fin: TVMPackedCFuncFinalizer,
    out: *mut TVMFunctionHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Register the function to runtime's global table.
  ///
  /// The registered function then can be pulled by the backend by the name.
  ///
  /// \param name The name of the function.
  /// \param f The function to be registered.
  /// \param override Whether allow override already registered function.
  pub fn TVMFuncRegisterGlobal(
    name: *const ::std::os::raw::c_char,
    f: TVMFunctionHandle,
    override_: ::std::os::raw::c_int,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Get a global function.
  ///
  /// \param name The name of the function.
  /// \param out the result function pointer, NULL if it does not exist.
  ///
  /// \note The function handle of global function is managed by TVM runtime,
  /// So TVMFuncFree is should not be called when it get deleted.
  pub fn TVMFuncGetGlobal(
    name: *const ::std::os::raw::c_char,
    out: *mut TVMFunctionHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief List all the globally registered function name
  /// \param out_size The number of functions
  /// \param out_array The array of function names.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMFuncListGlobalNames(
    out_size: *mut ::std::os::raw::c_int,
    out_array: *mut *mut *const ::std::os::raw::c_char,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Allocate a nd-array's memory,
  /// including space of shape, of given spec.
  ///
  /// \param shape The shape of the array, the data content will be copied to out
  /// \param ndim The number of dimension of the array.
  /// \param dtype_code The type code of the dtype
  /// \param dtype_bits The number of bits of dtype
  /// \param dtype_lanes The number of lanes in the dtype.
  /// \param device_type The device type of context
  /// \param device_id The device id of context.
  /// \param out The output handle.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMArrayAlloc(
    shape: *const tvm_index_t,
    ndim: ::std::os::raw::c_int,
    dtype_code: ::std::os::raw::c_int,
    dtype_bits: ::std::os::raw::c_int,
    dtype_lanes: ::std::os::raw::c_int,
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    out: *mut TVMArrayHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Free the TVM Array.
  /// \param handle The array handle to be freed.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMArrayFree(handle: TVMArrayHandle) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Copy array data from CPU byte array.
  /// \param handle The array handle.
  /// \param data the data pointer
  /// \param nbytes The number of bytes to copy.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMArrayCopyFromBytes(
    handle: TVMArrayHandle,
    data: *mut ::std::os::raw::c_void,
    nbytes: usize,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Copy array data to CPU byte array.
  /// \param handle The array handle.
  /// \param data the data pointer
  /// \param nbytes The number of bytes to copy.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMArrayCopyToBytes(
    handle: TVMArrayHandle,
    data: *mut ::std::os::raw::c_void,
    nbytes: usize,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Copy the array, both from and to must be valid during the copy.
  /// \param from The array to be copied from.
  /// \param to The target space.
  /// \param stream The stream where the copy happens, can be NULL.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMArrayCopyFromTo(
    from: TVMArrayHandle,
    to: TVMArrayHandle,
    stream: TVMStreamHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Produce an array from the DLManagedTensor that shares data memory
  /// with the DLManagedTensor.
  /// \param from The source DLManagedTensor.
  /// \param out The output array handle.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMArrayFromDLPack(
    from: *mut DLManagedTensor,
    out: *mut TVMArrayHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Produce a DLMangedTensor from the array that shares data memory with
  /// the array.
  /// \param from The source array.
  /// \param out The DLManagedTensor handle.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMArrayToDLPack(
    from: TVMArrayHandle,
    out: *mut *mut DLManagedTensor,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Delete (free) a DLManagedTensor's data.
  /// \param dltensor Pointer to the DLManagedTensor.
  pub fn TVMDLManagedTensorCallDeleter(dltensor: *mut DLManagedTensor);
}
extern "C" {
  /// \brief Create a new runtime stream.
  ///
  /// \param device_type The device type of context
  /// \param device_id The device id of context
  /// \param out The new stream handle
  /// \return 0 when success, -1 when failure happens
  pub fn TVMStreamCreate(
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    out: *mut TVMStreamHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Free a created stream handle.
  ///
  /// \param device_type The device type of context
  /// \param device_id The device id of context
  /// \param stream The stream to be freed
  /// \return 0 when success, -1 when failure happens
  pub fn TVMStreamFree(
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    stream: TVMStreamHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Set the runtime stream of current thread to be stream.
  /// The subsequent calls to the same device_type
  /// will use the setted stream handle.
  /// The specific type of stream is runtime device dependent.
  ///
  /// \param device_type The device type of context
  /// \param device_id The device id of context.
  /// \param handle The stream handle.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMSetStream(
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    handle: TVMStreamHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Wait until all computations on stream completes.
  ///
  /// \param device_type The device type of context
  /// \param device_id The device id of context.
  /// \param stream The stream to be synchronized.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMSynchronize(
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    stream: TVMStreamHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Synchronize two streams of execution.
  ///
  /// \param device_type The device type of context
  /// \param device_id The device id of context
  /// \param src The source stream to synchronize.
  /// \param dst The destination stream to synchronize.
  /// \return 0 when success, -1 when failure happens
  pub fn TVMStreamStreamSynchronize(
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    src: TVMStreamHandle,
    dst: TVMStreamHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Backend function for modules to get function
  /// from its environment mod_node (its imports and global function).
  /// The user do should not call TVMFuncFree on func.
  ///
  /// \param mod_node The module handle.
  /// \param func_name The name of the function.
  /// \param out The result function.
  /// \return 0 when no error is thrown, -1 when failure happens
  pub fn TVMBackendGetFuncFromEnv(
    mod_node: *mut ::std::os::raw::c_void,
    func_name: *const ::std::os::raw::c_char,
    out: *mut TVMFunctionHandle,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Backend function to register system-wide library symbol.
  ///
  /// \param name The name of the symbol
  /// \param ptr The symbol address.
  /// \return 0 when no error is thrown, -1 when failure happens
  pub fn TVMBackendRegisterSystemLibSymbol(
    name: *const ::std::os::raw::c_char,
    ptr: *mut ::std::os::raw::c_void,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Backend function to allocate temporal workspace.
  ///
  /// \note The result allocate spaced is ensured to be aligned to kTempAllocaAlignment.
  ///
  /// \param nbytes The size of the space requested.
  /// \param device_type The device type which the space will be allocated.
  /// \param device_id The device id which the space will be allocated.
  /// \param dtype_code_hint The type code of the array elements. Only used in
  /// certain backends such as OpenGL.
  /// \param dtype_bits_hint The type bits of the array elements. Only used in
  /// certain backends such as OpenGL.
  /// \return nullptr when error is thrown, a valid ptr if success
  pub fn TVMBackendAllocWorkspace(
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    nbytes: u64,
    dtype_code_hint: ::std::os::raw::c_int,
    dtype_bits_hint: ::std::os::raw::c_int,
  ) -> *mut ::std::os::raw::c_void;
}
extern "C" {
  /// \brief Backend function to free temporal workspace.
  ///
  /// \param ptr The result allocated space pointer.
  /// \param device_type The device type which the space will be allocated.
  /// \param device_id The device id which the space will be allocated.
  /// \return 0 when no error is thrown, -1 when failure happens
  ///
  /// \sa TVMBackendAllocWorkspace
  pub fn TVMBackendFreeWorkspace(
    device_type: ::std::os::raw::c_int,
    device_id: ::std::os::raw::c_int,
    ptr: *mut ::std::os::raw::c_void,
  ) -> ::std::os::raw::c_int;
}
/// \brief Environment for TVM parallel task.
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct TVMParallelGroupEnv {
  /// \brief Auxiliary used for synchronization
  pub sync_handle: *mut ::std::os::raw::c_void,
  /// \brief total amount of task
  pub num_task: i32,
}
/// \brief The callback function to execute a parallel lambda
/// \param task_id the task id of the function.
/// \param penv The parallel environment backs the execution.
/// \param cdata The supporting closure data.
pub type FTVMParallelLambda = ::std::option::Option<
  unsafe extern "C" fn(
    task_id: ::std::os::raw::c_int,
    penv: *mut TVMParallelGroupEnv,
    cdata: *mut ::std::os::raw::c_void,
  ) -> ::std::os::raw::c_int,
>;
extern "C" {
  /// \brief Backend function for running parallel jobs.
  ///
  /// \param flambda The parallel function to be launched.
  /// \param cdata The closure data.
  /// \param num_task Number of tasks to launch, can be 0, means launch
  /// with all available threads.
  ///
  /// \return 0 when no error is thrown, -1 when failure happens
  pub fn TVMBackendParallelLaunch(
    flambda: FTVMParallelLambda,
    cdata: *mut ::std::os::raw::c_void,
    num_task: ::std::os::raw::c_int,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief BSP barrrier between parallel threads
  /// \param task_id the task id of the function.
  /// \param penv The parallel environment backs the execution.
  /// \return 0 when no error is thrown, -1 when failure happens
  pub fn TVMBackendParallelBarrier(
    task_id: ::std::os::raw::c_int,
    penv: *mut TVMParallelGroupEnv,
  ) -> ::std::os::raw::c_int;
}
extern "C" {
  /// \brief Simple static initialization function.
  /// Run f once and set handle to be not null.
  /// This function is mainly used for test purpose.
  ///
  /// \param handle An global address to indicate f
  /// \param f The function to be ran
  /// \param cdata The closure data to pass to the function.
  /// \param nbytes Number of bytes in the closure data.
  /// \return 0 when no error is thrown, -1 when failure happens
  pub fn TVMBackendRunOnce(
    handle: *mut *mut ::std::os::raw::c_void,
    f: ::std::option::Option<
      unsafe extern "C" fn(arg1: *mut ::std::os::raw::c_void) -> ::std::os::raw::c_int,
    >,
    cdata: *mut ::std::os::raw::c_void,
    nbytes: ::std::os::raw::c_int,
  ) -> ::std::os::raw::c_int;
}
