/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/*!
 *  Copyright (c) 2017 by Contributors
 * \brief bias_add op constructions
 * \file nn/bias_add.h
 */
#ifndef TOPI_NN_BIAS_ADD_H_
#define TOPI_NN_BIAS_ADD_H_

#include <string>

#include "topi/tags.h"
#include "topi/broadcast.h"
#include "topi/transform.h"
#include "tvm/tvm.h"

namespace topi {
namespace nn {

/*!
* \brief Creates an operation that calculates data + bias
*
* \param data Tensor with shape [batch, in_dim]
* \param bias Tensor with shape [batch].
*
* \return Tensor with shape [batch, in_dim]
*/
inline tvm::Tensor bias_add(const tvm::Tensor& data, const tvm::Tensor& bias, int axis) {
  int data_ndim = data->shape.size();
  if (axis < 0) {
    axis += data_ndim;
  }
  int num_newaxis = data_ndim - axis - 1;
  return add(data, (num_newaxis ? expand_dims(bias, 1, num_newaxis) : bias));
}
}  // namespace nn
}  // namespace topi
#endif  // TOPI_NN_BIAS_ADD_H_
