#include "othello_env.h"
 
#include <algorithm>
#include <cmath>

using namespace std;
using namespace OthelloComm;
using namespace OthelloFunction;
using namespace OthelloFeature;

OthelloEnv::OthelloEnv() {
    CreateGlobalVariables();

    FOR_EACHCOORD(i) {
        stones_[i].self_id = i;
    }

    feature_history_list_.clear();
    memset(board_state_, 0, sizeof(board_state_));
    memset(legal_move_map_, 1, sizeof(legal_move_map_));
    memset(move_count_, 0, sizeof(move_count_));
    current_player_ = BLACK;
    last_position_ = COORD_UNSET;
    is_resign_ = false;
    state_ = 0;
    turn_ = 0;
    B_ = 0;
    W_ = 0;
    board_hash_states_.clear();
    zobrist_hash_value_ = 0;
}

//OthelloEnv::OthelloEnv(const OthelloEnv &ge) : OthelloEnv() {
//     CopyFrom(ge);
// }
 
OthelloEnv::~OthelloEnv() {

}

// void OthelloEnv::CopyFrom(const OthelloEnv &src) {
//     *this = src;
// }


void OthelloEnv::GetSensibleMove() {
    // Add new feature plane
    string plane;
    // black
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == BLACK) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }
    // white
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == WHITE) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }


    memset(legal_move_map_, 0, sizeof(legal_move_map_));

    Find_Legal_Moves(current_player_);

}
 
int OthelloState::Move(int action) {
    Find_Legal_Moves(current_player_);
    if (!IsLegal(action)) {
        return -1;
    }

    if(IsResign(action)){
        is_resign_ = true;
        return 0;
    }

    last_position_ = to;

    {
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Self()];
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Opponent()];
        if (!IsPass(action)) {
            zobrist_hash_value_ ^= g_zobrist_board_hash_weight[Self()][action];
        }
    }

    if (IsPass(action)) {
        HandOff();
        GetSensibleMove();
        return 0;
    }

    OthelloCoordId x, y;
    ++move_count_[action];
    board_state_[action] = Self();
    IdToCoord(to, x, y);
    Check_Cross(x, y, 1);

    HandOff();
    GetSensibleMove();

    return 0;
}

int OthelloEnv::Check_Straight_Army(OthelloCoordId x, OthelloCoordId y, int d, int update) const{
    int me = board_state_[OthelloFunction::CoordToId(x, y)];
    int army = 3 - me;
    //int army = Opponent(me);
    int army_count = 0;
    bool found_flag = false;
    int flag[OthelloComm::BORDER_SIZE][OthelloComm::BORDER_SIZE] = {{0}};
    
    OthelloCoordId i, j;
    OthelloCoordId tx, ty;
    
    tx = x;
    ty = y;
    
    for(i = 0; i < OthelloComm::BORDER_SIZE; i++){
      tx+=OthelloComm::DirX[d];
      ty+=OthelloComm::DirY[d];
        
      if(OthelloFunction::In_Board(tx, ty)){
        if(board_state_[OthelloFunction::CoordToId(tx, ty)] == army ){
          army_count ++;
          flag[tx][ty] = 1;
        }else if(board_state_[OthelloFunction::CoordToId(tx, ty)] == me){
          found_flag = true;
          break;
        }else{
          break;
        }
      }else{
        break;
      }
    }
    
    if(found_flag && (army_count > 0) && update){
      for(i = 0; i < OthelloComm::BORDER_SIZE; i++)
        for(j = 0; j < OthelloComm::BORDER_SIZE; j++)
          if(flag[i][j] == 1){
            if(board_state_[OthelloFunction::CoordToId(i, j)] != OthelloComm::EMPTY){
                board_state_[OthelloFunction::CoordToId(i, j)] = 3 - board[OthelloFunction::CoordToId(i,j)];
                //board_state_[OthelloFunction::CoordToId(i, j)] = Opponent(board_state_[OthelloFunction::CoordToId(i, j)]);
            }
          }
    }
    if(found_flag && (army_count > 0)){
      return army_count;
    }else{ 
      return 0;
    }
}

bool OthelloEnv::Check_Cross(OthelloCoordId x, OthelloCoordId y, int update) const{
    int k;
    OthelloCoordId dx, dy;
    
    if(!OthelloFunction::In_Board(x, y) || board_state_[OthelloFunction::CoordToId(x, y)] == OthelloComm::EMPTY){
      return false;
    }
    
    int army = 3 - board_state_[OthelloFunction::CoordToId(x, y)];
    int army_count = 0;
    
    for(k = 0 ; k < 8 ; k++ ){
        dx = x + OthelloComm::DirX[k];
        dy = y + OthelloComm::DirY[k];
        if(OthelloFunction::In_Board(dx, dy) && board_state_[OthelloFunction::CoordToId(dx, dy)] == army ){
            army_count += Check_Straight_Army(x, y, k, update) ;
        }
    }
    
    if(army_count > 0){
      return true;
    }else{
      return false;
    }
}

int OthelloEnv::Find_Legal_Moves(int color) const{
    OthelloCoordId i,j;
    int me = color;
    int legal_count = 0;
    int Legal_Move_Index[50][3];
    int Legal_Moves[OthelloComm::BORDER_SIZE][OthelloComm::BORDER_SIZE];
    Legal_Move_Index[0][0] = 0;
    B_ = W_ = 0;
    
    for(i = 0; i < OthelloComm::BORDER_SIZE; i++ ){
      for(j = 0; j < OthelloComm::BORDER_SIZE; j++){
        Legal_Moves[i][j] = 0;
        legal_move_map_[OthelloFunction::CoordToId(i, j)] = false;
      }
    }
    
    for(i = 0; i < OthelloComm::BORDER_SIZE; i++ ){
      for(j = 0; j < OthelloComm::BORDER_SIZE; j++ ){
        if(board_state_[OthelloFunction::CoordToId(i, j)] == EMPTY){ 
          if(i > 0 && i < OthelloComm::BORDER_SIZE - 1 && j > 0 && j < OthelloComm::BORDER_SIZE - 1){
            if((board_state_[OthelloFunction::CoordToId(i - 1, j - 1)]  == OthelloComm::EMPTY || board_state_[OthelloFunction::CoordToId(i - 1, j - 1)] == me) &&
               (board_state_[OthelloFunction::CoordToId(i - 1, j)]   == OthelloComm::EMPTY    || board_state_[OthelloFunction::CoordToId(i - 1, j)]     == me) &&
               (board_state_[OthelloFunction::CoordToId(i - 1, j + 1)]  == OthelloComm::EMPTY || board_state_[OthelloFunction::CoordToId(i - 1, j + 1)] == me) &&
               (board_state_[OthelloFunction::CoordToId(i, j - 1)]    == OthelloComm::EMPTY   || board_state_[OthelloFunction::CoordToId(i, j - 1)]     == me) &&
               (board_state_[OthelloFunction::CoordToId(i, j + 1)]    == OthelloComm::EMPTY   || board_state_[OthelloFunction::CoordToId(i, j + 1)]     == me) &&
               (board_state_[OthelloFunction::CoordToId(i + 1, j - 1)]  == OthelloComm::EMPTY || board_state_[OthelloFunction::CoordToId(i + 1, j - 1)] == me) &&
               (board_state_[OthelloFunction::CoordToId(i + 1, j)]    == OthelloComm::EMPTY   || board_state_[OthelloFunction::CoordToId(i + 1, j)]     == me) &&
               (board_state_[OthelloFunction::CoordToId(i + 1, j + 1)]  == OthelloComm::EMPTY || board_state_[OthelloFunction::CoordToId(i + 1, j + 1)] == me)){
              continue;
            }
          }
          board_state_[OthelloFunction::CoordToId(i, j)] = me;
          if(Check_Cross(i, j, 0)){
            Legal_Moves[i][j] = 1;
            legal_move_map_[OthelloComm::CoordToId(i, j)] = true;
            legal_count++;
            Legal_Move_Index[0][0] = legal_count;
            Legal_Move_Index[legal_count][1] = i ;
            Legal_Move_Index[legal_count][2] = j ;
          }
          board_state_[OthelloFunction::CoordToId(i, j)] = 0;
        }else if(board_state_[OthelloFunction::CoordToId(i, j)] == OthelloComm::BLACK){
          B_++;
        }else if(board_state_[OthelloFunction::CoordToId(i, j)] == OthelloComm::WHITE){
          W_++;
        }
      }
    }
    return legal_count;
}

int OthelloEnv::CalcResult() const{
  int lg_b, lg_w;
    
  if(is_resign_){
    if(current_player_ == OthelloComm::BLACK){
        state_ = 2;
    }else if(current_player_ == OthelloComm::WHITE){
        state_ = 1;
    }
  }

  if(state_ != 0){
    return state_;
  }

  lg_b = Find_Legal_Moves(OthelloComm::BLACK);
  lg_w = Find_Legal_Moves(OthelloComm::WHITE);

  if(B_ == 0){
    state_ = 2;
    return state_;
  }
  if(W_ == 0){
    state_ = 1;
    return state_;
  }
  
  if ( lg_b == 0 && lg_w == 0 ){
    if(B_ > W_){
      state_ = 1;
      return state_;
    }else if(B_ < W_){
      state_ = 2;
      return state_;
    }else{
      state_ = 3;
      return state_;
    }
  }
  return state_;
}



OthelloStoneColor OthelloEnv::GetWinner() const {
    int result = CalcResult();
    if (result == 3){
      return OthelloComm::EMPTY;
    }else if (result == 1){
      return OthelloComm::BLACK;
    }else if(result == 2){
      return OthelloComm::WHITE;
    }
}


void OthelloEnv::GetResult(float& res) {
	if (GetWinner() == OthelloComm::EMPTY){
		res = 0.0f;
	}else{
        res = GetWinner() == CurrentPlayer() ? -1.0f : 1.0f;
    }
}

vector<bool> OthelloEnv::GetFeature(BaseFeature& feature) const { // HWC
	feature.clear();
	feature.resize(OTHELLOBOARD_SIZE * (SIZE_HISTORYEACHSIDE + 1));
    // because push black into history first,
    // if next player is black,
    // we should get planes swap of each two planes
    int reverse_plane = int(Self() == BLACK);
    for (OthelloSize i = 0; i < SIZE_HISTORYEACHSIDE && i < feature_history_list_.size(); ++i) {
        const string &feature_str = *(feature_history_list_.rbegin() + (i ^ reverse_plane));
        for (int j = 0, k = i; j < OTHELLOBOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
            feature[k] = feature_str[j] - '0';
        }
    }
    if (Self() == BLACK) {
        for (int j = 0, k = SIZE_HISTORYEACHSIDE; j < OTHELLOBOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
            feature[k] = 1;
        }
    }
    return feature;
}

int OthelloEnv::GetActionNum() {//include PASS and RESIGN
	return OthelloComm::OTHELLOBOARD_SIZE + 2;
}
 
void OthelloEnv::GetInputDim(vector<int>& input_dim) {
    input_dim.clear();
    input_dim.push_back(SIZE_HISTORYEACHSIDE);
    input_dim.push_back(BORDER_SIZE);
    input_dim.push_back(BORDER_SIZE)
}

void OthelloEnv::GetLegalAction(vector<int>& action) {
    action.clear();
    FOR_EACHCOORD(id) {
        if (legal_move_map_[id]) {
            action.push_back(id);
        }
    }
}

/*void OthelloEnv::TransformCoord(OthelloCoordId &x, OthelloCoordId &y, int mode, bool reverse = false)
{
    if (reverse) {
        if (mode & 4) std::swap(x, y);
        if (mode & 2) y = OthelloComm::BORDER_SIZE - y - 1;
        if (mode & 1) x = OthelloComm::BORDER_SIZE - x - 1;
    } else {
        if (mode & 1) x = OthelloComm::BORDER_SIZE - x - 1;
        if (mode & 2) y = OthelloComm::BORDER_SIZE - y - 1;
        if (mode & 4) std::swap(x, y);
    }
}*/
 
// void OthelloEnv::TransformFeatures(BaseFeature& feature, int transform_mode) {
//     BaseFeature ret(feature.size());
//     int depth = features.size() / OthelloComm::OTHELLOBOARD_SIZE;
//     for (int i = 0; i < OthelloComm::OTHELLOBOARD_SIZE; ++i) {
//         OthelloCoordId x, y;
//         OthelloFunction::IdToCoord(i, x, y);
//         TransformCoord(x, y, mode);
//         int j = OthelloFunction::CoordToId(x, y);
//         for (int k = 0; k < depth; ++k) {
//             ret[i * depth + k] = features[j * depth + k];
//         }
//     }
//     feature = std::move(ret);
// }

// void TransformPolicy(int transform_mode) {
// }

