#pragma once

#include <inttypes.h>
#include <string>
#include <vector>

// Return code of functions should be "int"
typedef uint8_t OthelloStoneColor;       // Stone color
typedef int16_t OthelloCoordId;          // Stone IDs or coordinates
typedef int16_t OthelloSize;             // Counts of visit times, used blocks, ..

namespace OthelloComm {

const OthelloCoordId BORDER_SIZE = 8; // sxk_modify
const OthelloCoordId OTHELLOBOARD_SIZE = BORDER_SIZE * BORDER_SIZE;
const OthelloCoordId COORD_UNSET = -2;
const OthelloCoordId COORD_PASS = -1;
const OthelloCoordId COORD_RESIGN = -3;

const OthelloStoneColor EMPTY = 0;
const OthelloStoneColor BLACK = 1;
const OthelloStoneColor WHITE = 2;
const OthelloStoneColor WALL = 3;
const OthelloStoneColor COLOR_UNKNOWN = -1;
//const char *const COLOR_STRING[] = { "Empty", "Black", "White"};
const char *const COLOR_STRING[] = { "Empty", "Black", "White", "Wall" };

const OthelloCoordId DirX[8] = {0, 1, 1, 1, 0, -1, -1, -1};
const OthelloCoordId DirY[8] = {-1, -1, 0, 1, 1, 1, 0, -1};

} // namespace OthelloComm

namespace OthelloFeature {

const int SIZE_HISTORYEACHSIDE = 16;
const int SIZE_PLAYERCOLOR = 1;

const int STARTPOS_HISTORYEACHSIDE = 0;
const int STARTPOS_PLAYERCOLOR = STARTPOS_HISTORYEACHSIDE + SIZE_HISTORYEACHSIDE;

const int FEATURE_COUNT = STARTPOS_PLAYERCOLOR + SIZE_PLAYERCOLOR;

} // namespace OthelloFeature


namespace OthelloFunction {

extern bool InBoard(const OthelloCoordId id);

extern bool InBoard(const OthelloCoordId x, const OthelloCoordId y);

extern bool IsPass(const OthelloCoordId id);

extern bool IsPass(const OthelloCoordId x, const OthelloCoordId y);

extern bool IsUnset(const OthelloCoordId id);

extern bool IsUnset(const OthelloCoordId x, const OthelloCoordId y);

extern bool IsResign(const OthelloCoordId id);

extern bool IsResign(const OthelloCoordId x, const OthelloCoordId y);


extern void IdToCoord(const OthelloCoordId id, OthelloCoordId &x, OthelloCoordId &y);

extern OthelloCoordId CoordToId(const OthelloCoordId x, const OthelloCoordId y);

extern void StrToCoord(const std::string &str, OthelloCoordId &x, OthelloCoordId &y);

extern std::string CoordToStr(const OthelloCoordId x, const OthelloCoordId y);

extern std::string IdToStr(const OthelloCoordId id);

extern OthelloCoordId StrToId(const std::string &str);


extern void CreateGlobalVariables();

extern void CreateHashWeights();

extern void CreateQuickLog2Table();

extern void CreateZobristHash();

} // namespace OthelloFunction


//typedef std::pair<OthelloCoordId, OthelloCoordId> OthelloPosition;
typedef std::pair<uint64_t, uint64_t> OthelloHashValuePair;

extern OthelloHashValuePair g_hash_weight[OthelloComm::BORDER_SIZE][OthelloComm::BORDER_SIZE];
const OthelloHashValuePair g_hash_unit(3, 7);
extern uint64_t g_zobrist_board_hash_weight[4][OthelloComm::OTHELLOBOARD_SIZE];
extern uint64_t g_zobrist_player_hash_weight[4];
//state：统计棋局状态,0未分胜负，1黑胜，2白胜，3平局
//extern int state;
//extern int B, W;

extern OthelloCoordId g_log2_table[67];

#define FOR_EACHCOORD(id) for (OthelloCoordId id = 0; id < OthelloComm::OTHELLOBOARD_SIZE; ++id)

