#include "gobang_comm.h"
#include "base_env.h"

#include <cstdlib>
#include <cstring>
#include <stack>
#include <string>
#include <unordered_set>
#include <vector>

#if defined(_WIN32) || defined(_WIN64)
#  include <intrin.h>
#  define __builtin_popcount __popcnt
#  define __builtin_popcountll __popcnt64
#endif

typedef vector<bool> BaseFeature;

 
struct GoBangStone {
    GoBangCoordId self_id;      // Id of this stone
    GoBangCoordId next_id;      // Use like link-list
    GoBangCoordId parent_id;    // Use like union-find-set (rooted by tail)

    // inline void SetSelfId(GoBangCoordId id) { self_id = id; }

    inline void Reset(GoBangCoordId id = GoBangComm::COORD_UNSET) {
        next_id = parent_id = self_id;
    }
} ;


class GoBangEnv: public BaseEnv {
public:
	GoBangEnv();
    // GoBangEnv(const GoBangEnv &ge);
    ~GoBangEnv();

    int Move(int action) override;
    bool IsFinish() override { return ((state_ != 0 ? true : false) || is_resign_); }
    void GetResult(float& res) override;
    void GetFeature(BaseFeature& feature) override;
    int GetActionNum() override;
    void GetInputDim(vector<int>& input_dim) override;
    void GetLegalAction(vector<int>& action) override;
    bool IsLegal(int action) override { return GoBangFunction::IsResign(action) || legal_move_map_[action]; }
    std::string action2str(int action) override { return GoBangFunction::IdToStr(const GoBangCoordId action); }
    int CurrentPlayer() override { return current_player_; }

protected:
    // void Init();

    // void CopyFrom(const GoBangEnv &src);
    int GobangResult(GoBangCoordId x, GoBangCoordId y) const;
    int CalcResult() const;
    GoBangStoneColor GetWinner() const;
    inline void HandOff() { current_player_ = Opponent(); }
    inline GoBangStoneColor Opponent(const GoBangStoneColor color = GoBangComm::COLOR_UNKNOWN) const {
        return GoBangComm::BLACK + GoBangComm::WHITE
            - (GoBangComm::COLOR_UNKNOWN != color ? color : current_player_);
    }
    inline GoBangStoneColor Self() const { return current_player_; }
    inline GoBangCoordId GetLastMove() const { return last_position_; }
    // inline GoBangStoneColor CurrentPlayer() const { return current_player_; }
    //void GoBangEnv::TransformCoord(GoBangCoordId &x, GoBangCoordId &y, int mode, bool reverse = false)

    void GetSensibleMove();
    int dir_x() const;
    int dir_y() const;
    bool live_four(int left[4], int right[4]) const;
    bool live_three(int left[4], int right[4]) const;
    bool Ban(GoBangCoordId x, GoBangCoordId y) const;

protected:
    // board utils
    GoBangStone stones_[GoBangComm::GOBANGBOARD_SIZE];
    GoBangStoneColor board_state_[GoBangComm::GOBANGBOARD_SIZE];
    GoBangStoneColor current_player_;
    GoBangCoordId last_position_;
    bool is_resign_;
    int state_;
    int action_count_;

    // hash board state
    std::unordered_set<uint64_t> board_hash_states_;
    uint64_t zobrist_hash_value_;

    // features
    bool legal_move_map_[GoBangComm::GOBANGBOARD_SIZE];
    GoBangSize move_count_[GoBangComm::GOBANGBOARD_SIZE];

    std::vector<std::string> feature_history_list_;
};
