#include "gobang_env.h"
 
#include <algorithm>
#include <cmath>

using namespace std;
using namespace GoBangComm;
using namespace GoBangFunction;
using namespace GoBangFeature;

GoBangEnv::GoBangEnv() {
    CreateGlobalVariables();

    FOR_EACHCOORD(i) {
        stones_[i].self_id = i;
    }

    feature_history_list_.clear();
    memset(board_state_, 0, sizeof(board_state_));
    memset(legal_move_map_, 1, sizeof(legal_move_map_));
    memset(move_count_, 0, sizeof(move_count_));
    current_player_ = BLACK;
    last_position_ = COORD_UNSET;
    is_resign_ = false;
    state_ = 0;
    action_count_ = 0;
    board_hash_states_.clear();
    zobrist_hash_value_ = 0;
}

//GoBangEnv::GoBangEnv(const GoBangEnv &ge) : GoBangEnv() {
//     CopyFrom(ge);
// }
 
GoBangEnv::~GoBangEnv() {

}

 // void GoBangEnv::CopyFrom(const GoBangEnv &src) {
 //     *this = src;
 // }


void GoBangEnv::GetSensibleMove() {
    // Add new feature plane
    string plane;
    // black
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == BLACK) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }
    // white
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == WHITE) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }

    memset(legal_move_map_, 0, sizeof(legal_move_map_));

    FOR_EACHCOORD(i) {
        if (EMPTY != board_state_[i]) {
            continue;
        }
        
        legal_move_map_[i] = true;

        GoBangCoordId x, y;
        IdToCoord(i, x, y);
        if(current_player_ == BLACK && Ban(x,y)){
            legal_move_map_[i] = false;
        }
    }
}
 
int GoBangState::Move(int action) {
    if (!IsLegal(action)) {
        return -1;
    }
    if(IsResign(action)){
      is_resign_ = true;
      return 0;
    }

    last_position_ = action;

    {
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Self()];
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Opponent()];
        zobrist_hash_value_ ^= g_zobrist_board_hash_weight[Self()][action];
    }

    ++move_count_[action];
    board_state_[action] = Self();
    ++action_count_;

    HandOff();
    GetSensibleMove();


    return 0;
}

int GoBangEnv::dir_x() const{
  static int angle = 135;  //角度，从零开始，每次增加45度，135度的下一次回到零
  if(angle < 135){
    angle+=45;
  }else{
    angle = 0;
  }
  switch(angle){
  case 0: 
    return 0;
    break;
  case 45:case 90:case 135:
    return 1;
    break;
  default:
    printf("error angle\n");
    return 0;
    break;
  }
}

int GoBangEnv::dir_y() const{
  static int angle = 135;  //角度，从零开始，每次增加45度，135度的下一次回到零
  if(angle < 135){
    angle+=45;
  }else{ 
    angle = 0;
  }
  switch(angle){
  case 0: case 45:
      return 1;
      break;
  case 90:
    return 0;
    break;
  case 135:
    return -1;
    break;
  default:
    printf("error angle.\n");
    return 0;
    break;
  }
}

bool GoBangEnv::live_four(int left[4], int right[4]) const{   //判断输入的序列是否是活四，这里略去了两头四四的情况没有考虑，不过这里的活四只是为了判断是否为活三而准备，如果已经是两头四四的话那已经形成了禁手，是否是活三变得没有意义
  GoBangStoneColor type = GoBangComm::BLACK;      //需要判断的只有黑子
  int i,j;
  int a,b;          //a为一变量，b为临时储存a的值
  int left_1 = 0;     //记录左方相同子的个数
  int right_1 = 0;    //记录右方相同子的个数
  int count = 0;      //统计可以形成5的点数
  /*先判断一下是否还没放子的时候就已经是5颗了*/
  for(j = 0; j < 4 && right[j] == type; j++){    //当右边的子与之相同时(前面的条件是为了保证不越界) 
    right_1++;
  } 
  for(j = 0; j < 4 && left[j] == type; j++){     //当左边的子与之相同时(前面的条件是为了保证不越界)
    left_1++;
  }
  if(left_1 + right_1 == 4){   //如果已经五连，那么不是活四，返回0，如果没有五连，什么也不做
    return false;
  }
  for(a = 0; a < 8; a++){
    left_1 = 0;   
    right_1 = 0;
    if(a < 4){             //将left和right上的0依次改为type再判断是否形成五连，形成则可形成五连的点加1,注：这里的0是初始化给的0而非EMPTY,a<4是统计left
      b = a;
      if(left[a] == 0){
        left[a] = type;
      }else{
        continue;
      }
    }else if(a >= 4){//a>=4是统计right
      b = a;
      a-=4;
      if(right[a] == 0){
        right[a] = type;
      }else{
        a = b;
        continue;
      }
    }
      
    for(j = 0; j < 4 && right[j] == type; j++){    //当左边的子与之相同时(前面的条件是为了保证不越界)
      right_1++;
    }
    for(j = 0; j < 4 && left[j] == type; j++){     //当左边的子与之相同时(前面的条件是为了保证不越界)
      left_1++;
    }
    if(left_1 + right_1 == 4){   //如果形成五连
      count++;
    }
    if(b < 4){            //将改的值改回去     
        left[a] = 0;
    }
    else if(b >= 4){
        right[a] = 0;
    }
    a = b;  
  }
  if(count == 2){
    return true;
  }else{
    return false;
  }
}

bool GoBangEnv::live_three(int left[4], int right[4]) const{    //判断是否为活三
  GoBangStoneColor type = GoBangComm::BLACK;  //因为白棋不用判断，所以必为黑棋
  int i,j;
  int a,b;      //a为一变量，b为临时储存a的值
  if(live_four(left, right)){      //已经是活四，就不再是活三了
    return false;  
  }
  for(a = 0; a < 8; a++){
    if(a < 4){         //将left和right上的0依次改为type再判断是否形成活四,注：这里的0是初始化给的0而非EMPTY，a<4是统计left
      b = a;
      if(left[a] == 0){
        left[a] = type;
      }else{
        continue;
      }
    }else if(a >= 4){//a>=4是统计right
      b = a;
      a-=4;
      if(right[a] == 0){
        right[a] = type;
      }else{
        a = b;
        continue;
      }
    }
    if(live_four(left,right)){   //如果加一步之后形成活四，那么是活三
      if(b < 4){         //将改的值改回去     
        left[a] = 0;
      }else if(b >= 4){
        right[a] = 0;
      }
      return true;
    }else {
      if(b < 4){         //将改的值改回去     
        left[a] = 0;
      }else if(b >= 4){
        right[a] = 0;
      }
    }
    a = b;
  }
  return false;
}

bool GoBangEnv::Ban(GoBangCoordId x, GoBangCoordId y) const{
  GoBangStoneColor type = GoBangComm::BLACK; // 黑棋判断禁手
  int left[4][4] = { {0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0} };     //用来储存这个点沿x轴反方向四轴的棋子状态
  int right[4][4] = { {0,0,0,0},{0,0,0,0},{0,0,0,0},{0,0,0,0} };  //用来储存这个点沿x轴正方向四轴的棋子状态
  int left_2[4] = {0,0,0,0};    //为live_three函数传递参数而准备的数组，下同
  int right_2[4] = {0,0,0,0};
  int i,j;    //j为倍数
  int a,b;
  int fo_l[4],fo_r[4];    //表示上面数组中第一个其它棋子或是边界外的位置
  int count[2] = {0,0};     //统计活三、活四或冲四的个数
  int le[4] = {0,0,0,0},ri[4] = {0,0,0,0};    //对左右两边的状
  for(i = 0; i < 4; i++){      //将点(x+1,y+1)水平，右斜，竖直，左斜的方向上4个棋子的状态读入上面两个数组中
    a = dir_x(); b = dir_y();
    for(j = 1; j < 5; j++){
      if((x + j * a < GoBangComm::BORDER_SIZE) && (x + j * a >= 0) && (y + j * b < GoBangComm::BORDER_SIZE) && (y + j * b >= 0)){    //如果这颗子在边界内
        int id = GoBangFunction::CoordToId(x + j * a, y + j * b);
        right[i][j - 1] = board_state_[id];
      }
      else{
        right[i][j - 1] = -2;    //如果不在边界内
      }
      if((x - j * a < GoBangComm::BORDER_SIZE) && (x - j * a >= 0) && (y - j * b < GoBangComm::BORDER_SIZE) && (y - j * b >= 0)){    //如果这颗子在边界内
        int id = GoBangFunction::CoordToId(x - j * a, y - j * b);
        left[i][j - 1] = board_state_[id];
      }
      else{
        left[i][j - 1] = -2;     //如果不在边界内
      }
    }
  }
  
  for(i = 0; i < 4; i++){
    for(j = 0; j < 4; j++){
      if(left[i][j] != type && left[i][j] != 0){   //如果不是相同棋子也不是空位的话
        fo_l[i] = j;   //第一个其它棋子，或是边界外
        break;
      }
    }
    if(j == 4){         //如果四个都没有对手的棋子的话，空间充足
      fo_l[i] = j;
    }
    for(j = 0; j < 4; j++){ 
      if(right[i][j] != type && right[i][j] != 0){   //如果不是相同棋子也不是空位的话
        fo_r[i]=j;    //第一个其它棋子，或是边界外
        break;
      }
    }
    if(j == 4){        //如果四个都没有对手的棋子的话，空间充足
      fo_r[i] = j;
    }
  }
  
  for(i = 0; i < 4; i++){     //用le和ri对左右两边的状态进行编码，百位与fo_l/fo_r的值相同，剩下的0和1按二进制来编码，left[i][0]的权为8，left[i][3]的权为1，加入此编码的目的是为了解决c语言无法将两数组直接比较，于是换一种方便的表示方式来比较它们。
    for(j = 0; j < fo_l[i]; j++){
      le[i]+=abs(left[i][j])*pow(2,3-j);    //剩下的0和1按二进制来编码，left[i][0]的权为8，left[i][3]的权为1
    }
    le[i]+=100*fo_l[i];      //百位与fo_l/fo_r的值相同
  }
  for(i = 0; i < 4; i++){    //用le和ri对左右两边的状态进行编码，百位与fo_l/fo_r的值相同，剩下的0和1按二进制来编码，right[i][0]的权为8，right[i][3]的权为1，加入此编码的目的是为了解决c语言无法将两数组直接比较，于是换一种方便的表示方式来比较它们。
    for(j = 0; j < fo_r[i]; j++){
      ri[i]+=abs(right[i][j])*pow(2,3-j);    //剩下的0和1按二进制来编码，right[i][0]的权为8，right[i][3]的权为1
    }
    ri[i]+=100*fo_r[i];       //百位与fo_l/fo_r的值相同
  }
  for(i = 0; i < 4; i++){
    switch(le[i] % 100){         //统计活四和冲四的个数
    case 0:
      if((ri[i] % 100) == 11 || (ri[i] % 100) == 13 || (ri[i] % 100) == 14 || (ri[i] % 100) == 7)
        count[1]++;
      break;
    case 4:
      if((ri[i] % 100) == 12)
        count[1]++;
      else if((ri[i] % 100) == 13)        //特殊的两头四四
        count[1]+=2;               
      break;
    case 6:
      if((ri[i] % 100) == 8)
        count[1]++;
      else if((ri[i] % 100) == 11)    //特殊的两头四四
        count[1]+=2;
      break;
    case 7:
      if((ri[i] % 100) == 12)
        count[1]++;
      else if((ri[i] % 100) == 7)       //特殊的两头四四
        count[1]+=2;
      break;
    case 8:
      if((ri[i] % 100) ==12 || (ri[i] % 100) == 6 || (ri[i] % 100) == 10)
        count[1]++;
      break;
    case 10:
      if((ri[i] % 100) == 10)     //特殊的两头四四
        count[1]+=2;
      break;
    case 11:
      if((ri[i] % 100) == 0)
        count[1]++;
      else if((ri[i] % 100) == 6)   //特殊的两头四四
        count[1]+=2;
      break;
    case 12:
      if((ri[i] % 100)==8 || (ri[i] % 100) == 4)
        count[1]++;
      break;
    case 13:
      if((ri[i] % 100) == 0)
        count[1]++;
      else if((ri[i] % 100) == 4)    //特殊的两头四四
        count[1]+=2;
      break;
    case 14:
      if((ri[i]%100) == 0)
        count[1]++;
      break;
    default:
      break;
    }
  }
  for(i = 0; i < 4; i++){    //统计活三的个数
    for(j = 0; j < 4; j++){
      left_2[j] = left[i][j];    //将数组left、right的第i行复制到left_2、right_2
      right_2[j] = right[i][j];
    }
    if(live_three(left_2, right_2))
      count[0]++;
  }

  if(count[0] >= 2 || count[1] >= 2){    //如果形成三三禁手或是四四禁手，白棋胜利
    return true;                      //黑子禁手状态 
  }
  return false;
}

int GoBangEnv::GobangResult(GoBangCoordId x, GoBangCoordId y) const{
  GoBangStoneColor type;        //如果最后落子为黑子，其为1，白子为2
  int left_1[4] = {0,0,0,0};    //记录x轴反方相同棋子的个数
  int right_1[4] = {0,0,0,0};   //记录x轴正方相同棋子的个数
  int i, j;
  int a, b;

  if(action_count_ >= GoBangComm::GOBANGBOARD_SIZE){
    state_ = 3;
  }
  if(is_resign_){
    if(current_player_ == GoBangComm::BLACK){
      state_ = 2;
    }else if(current_player_ == GoBangComm::WHITE){
      state_ = 1;
    }
  }
  if(state_ != 0){    //如果游戏结束
    return state_;
  }
  type = board_state_[GoBangFunction::CoordToId(x, y)];
  //type = current_player_;
  
  for(i = 0; i < 4; i++){
    j = 1; a = dir_x(); b = dir_y();
    while((x + j * a < GoBangComm::BORDER_SIZE) && (y + j * b < GoBangComm::BORDER_SIZE) && (x + j * a >= 0) && (y + j * b >= 0) && (board[GoBangFunction::CoordToId(x + j * a, y + j * b)] == type)){    //当x轴正向的子与之相同时(前面的条件是为了保证不越界)
      j++;
      right_1[i]++;
    }
    j = 1;
    while((x - j * a < GoBangComm::BORDER_SIZE) && (y - j * b <= GoBangComm::BORDER_SIZE) && (x - j * a >= 0) && (y - j * b >= 0) && (board[GoBangFunction::CoordToId(x - j * a, y - j * b)] == type))    //当x轴反向的子与之相同时
    {
      j++;
      left_1[i]++;
    }
  }

  for(i = 0; i < 4; i++){
    if(type == GoBangComm::WHITE){        //如果刚才为白棋落子，那么不进行禁手判断
      if((left_1[i] + right_1[i]) >= 4){   //白棋只判断是否胜利  
        state_ = 2;
        return state_;
      }else{            //继续下一根轴检测
        continue;
      }
    }else{                 //如果是黑棋，需要考虑禁手状态
      if((left_1[i] + right_1[i]) == 4){    //胜利
        state_ = 1;        //将状态改为对应的棋子胜利
        return state_;                      //结束函数
      }
      else if((left_1[i]+right_1[i]) > 4){   //长连禁手
        state_ = 2;                        //黑子禁手状态,白棋获胜
        return state_;
      }
    }
  }
  if(type == GoBangComm::WHITE){        //如果是白子，即使没有胜利也不进行下面的判断
    return state_;
  }
   /*如果是黑子落子且没有胜利，那么继续进行禁手判断*/
  if(Ban(x, y)){
    state_ = 2;
    return state_;
  }
  return state_;
}


int GoBangEnv::CalcResult() const {
    GoBangCoordId x, y;
    int result = 0;
    FOR_EACHCOORD(i) {
        if(board_state_[i] == GoBangComm::EMPTY){
            continue;
        }else{
            GoBangFunction::IdToCoord(i, x, y);
            result = GobangResult(x, y);
            if(result != 0){
              return result;
            }
        }
    }
    return result;
}


GoBangStoneColor GoBangEnv::GetWinner() const {
    int result = CalcResult();
    if (result == 3){
      return GoBangComm::EMPTY;
    }else if (result == 1){
      return GoBangComm::BLACK;
    }else if(result == 2){
      return GoBangComm::WHITE;
    }
}

void GoBangEnv::GetResult(float& res) {
	if (GetWinner() == GoBangComm::EMPTY){
		res = 0.0f;
	}else{
        res = GetWinner() == CurrentPlayer() ? -1.0f : 1.0f;
    }
}

vector<bool> GoBangEnv::GetFeature(BaseFeature& feature) const { // HWC
  feature.clear();
	feature.resize(GOBANGBOARD_SIZE * (SIZE_HISTORYEACHSIDE + 1));
  //vector<bool> feature(GOBANGBOARD_SIZE * (SIZE_HISTORYEACHSIDE + 1), 0);
  // because push black into history first,
  // if next player is black,
  // we should get planes swap of each two planes
  int reverse_plane = int(Self() == BLACK);
  for (GoBangSize i = 0; i < SIZE_HISTORYEACHSIDE && i < feature_history_list_.size(); ++i) {
    const string &feature_str = *(feature_history_list_.rbegin() + (i ^ reverse_plane));
    for (int j = 0, k = i; j < GOBANGBOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
      feature[k] = feature_str[j] - '0';
    }
  }
  if (Self() == BLACK) {
    for (int j = 0, k = SIZE_HISTORYEACHSIDE; j < GOBANGBOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
      feature[k] = 1;
    }
  }
  return feature;
}

int GoBangEnv::GetActionNum() {//include RESIGN
	return GoBangComm::GOBANGBOARD_SIZE + 1;
}
 
void GoBangEnv::GetInputDim(vector<int>& input_dim) {
    input_dim.clear();
    input_dim.push_back(SIZE_HISTORYEACHSIDE);
    input_dim.push_back(BORDER_SIZE);
    input_dim.push_back(BORDER_SIZE)
}

void GoBangEnv::GetLegalAction(vector<int>& action) {
    action.clear();
    FOR_EACHCOORD(id) {
        if (legal_move_map_[id]) {
            action.push_back(id);
        }
    }
}

/*void GoBangEnv::TransformCoord(GoBangCoordId &x, GoBangCoordId &y, int mode, bool reverse = false)
{
    if (reverse) {
        if (mode & 4) std::swap(x, y);
        if (mode & 2) y = GoBangComm::BORDER_SIZE - y - 1;
        if (mode & 1) x = GoBangComm::BORDER_SIZE - x - 1;
    } else {
        if (mode & 1) x = GoBangComm::BORDER_SIZE - x - 1;
        if (mode & 2) y = GoBangComm::BORDER_SIZE - y - 1;
        if (mode & 4) std::swap(x, y);
    }
}*/
 
// void GoBangEnv::TransformFeatures(BaseFeature& feature, int transform_mode) {
//     BaseFeature ret(feature.size());
//     int depth = features.size() / GoBangComm::GOBANGBOARD_SIZE;
//     for (int i = 0; i < GoBangComm::GOBANGBOARD_SIZE; ++i) {
//         GoBangCoordId x, y;
//         GoBangFunction::IdToCoord(i, x, y);
//         TransformCoord(x, y, mode);
//         int j = GoBangFunction::CoordToId(x, y);
//         for (int k = 0; k < depth; ++k) {
//             ret[i * depth + k] = features[j * depth + k];
//         }
//     }
//     feature = std::move(ret);
// }

// void TransformPolicy(int transform_mode) {
// }


