#pragma once

#include <inttypes.h>
#include <string>
#include <vector>

// Return code of functions should be "int"
typedef uint8_t GoBangStoneColor;       // Stone color
typedef int16_t GoBangCoordId;          // Stone IDs or coordinates
typedef int16_t GoBangSize;             // Counts of visit times, used blocks, .. or other count

namespace GoBangComm {

const GoBangCoordId BORDER_SIZE = 15; // sxk_modify
const GoBangCoordId GOBANGBOARD_SIZE = BORDER_SIZE * BORDER_SIZE;
const GoBangCoordId COORD_UNSET = -2;
//const GoBangCoordId COORD_PASS = -1;
const GoBangCoordId COORD_RESIGN = -3;

const GoBangStoneColor EMPTY = 0;
const GoBangStoneColor BLACK = 1;
const GoBangStoneColor WHITE = 2;
const GoBangStoneColor WALL = 3;
const GoBangStoneColor COLOR_UNKNOWN = -1;
const char *const COLOR_STRING[] = { "Empty", "Black", "White", "Wall" };

} // namespace GoBangComm

namespace GoBangFeature {

const int SIZE_HISTORYEACHSIDE = 16;
const int SIZE_PLAYERCOLOR = 1;

const int STARTPOS_HISTORYEACHSIDE = 0;
const int STARTPOS_PLAYERCOLOR = STARTPOS_HISTORYEACHSIDE + SIZE_HISTORYEACHSIDE;

const int FEATURE_COUNT = STARTPOS_PLAYERCOLOR + SIZE_PLAYERCOLOR;

} // namespace GoBangFeature


namespace GoBangFunction {

extern bool InBoard(const GoBangCoordId id);

extern bool InBoard(const GoBangCoordId x, const GoBangCoordId y);

extern bool IsUnset(const GoBangCoordId id);

extern bool IsUnset(const GoBangCoordId x, const GoBangCoordId y);

extern bool IsResign(const GoBangCoordId id);

extern bool IsResign(const GoBangCoordId x, const GoBangCoordId y);


extern void IdToCoord(const GoBangCoordId id, GoBangCoordId &x, GoBangCoordId &y);

extern GoBangCoordId CoordToId(const GoBangCoordId x, const GoBangCoordId y);

extern void StrToCoord(const std::string &str, GoBangCoordId &x, GoBangCoordId &y);

extern std::string CoordToStr(const GoBangCoordId x, const GoBangCoordId y);

extern std::string IdToStr(const GoBangCoordId id);

extern GoBangCoordId StrToId(const std::string &str);


extern void CreateGlobalVariables();

extern void CreateHashWeights();

extern void CreateQuickLog2Table();

extern void CreateZobristHash();

} // namespace GoBangFunction


//typedef std::pair<GoBangCoordId, GoBangCoordId> GoBangPosition;
typedef std::pair<uint64_t, uint64_t> GoBangHashValuePair;

extern GoBangHashValuePair g_hash_weight[GoBangComm::BORDER_SIZE][GoBangComm::BORDER_SIZE];
const GoBangHashValuePair g_hash_unit(3, 7);
extern uint64_t g_zobrist_board_hash_weight[4][GoBangComm::GOBANGBOARD_SIZE];
extern uint64_t g_zobrist_player_hash_weight[4];
//action_count:统计已落子数，state：统计棋局状态,0未分胜负，1黑胜，2白胜，3平局
//extern int action_count = 0;
//extern int state = 0;

extern GoBangCoordId g_log2_table[67];

#define FOR_EACHCOORD(id) for (GoBangCoordId id = 0; id < GoBangComm::GOBANGBOARD_SIZE; ++id)
