/*
	Base class for environments of RL.
    	Following features:
        Discrete and fix-size action space.
      Used as:
        Experiment environment;
        Environment in Agents' mind
*/
#include <cstdlib>
#include <string>
  
class GoBang: public BaseEnv {
public:
      GoBang();
      ~GoBang();
      virtual int Move(int action) = 0;
      virtual bool IsFinish() = 0;
      virtual void GetResult(float& res) = 0;
      virtual void GetFeature(BaseFeature& feature) = 0;
      virtual void GetActionNum() = 0;
      virtual void GetInputDim(vector<int>& input_dim) = 0;
      virtual void GetLegalAction(vector<int>& action) = 0;
      virtual bool IsLegal(int action) = 0;
      virtual std::string action2str(int action) = 0;
      //virtual void TransformFeatures(BaseFeature& feature, int transform_mode) = 0;
      //virtual void TransformPolicy(int transform_mode) = 0; // this is reverse mode of TransformFeature
protected:
      virtual void Init() = 0;
};
         