#include "connect4_env.h"
 
#include <algorithm>
#include <cmath>

using namespace std;
using namespace Connect4Comm;
using namespace Connect4Function;
using namespace Connect4Feature;

Connect4Env::Connect4Env() {
    CreateGlobalVariables();

    FOR_EACHCOORD(i) {
        stones_[i].self_id = i;
    }

    feature_history_list_.clear();
    memset(board_state_, 0, sizeof(board_state_));
    memset(legal_move_map_, 1, sizeof(legal_move_map_));
    memset(move_count_, 0, sizeof(move_count_));
    current_player_ = BLACK;
    last_position_ = COORD_UNSET;
    is_resign_ = false;
    state_ = 0;
    action_count_ = 0;
    board_hash_states_.clear();
    zobrist_hash_value_ = 0;
}

//Connect4Env::Connect4Env(const Connect4Env &ge) : Connect4Env() {
//     CopyFrom(ge);
// }
 
Connect4Env::~Connect4Env() {

}

// void Connect4Env::CopyFrom(const Connect4Env &src) {
//     *this = src;
// }


void Connect4Env::GetSensibleMove() {
    // Add new feature plane
    string plane;
    // black
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == BLACK) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }
    // white
    {
        plane = "";
        FOR_EACHCOORD(id) {
            if (board_state_[id] == WHITE) {
                plane += "1";
            } else {
                plane += "0";
            }
        }
        feature_history_list_.push_back(plane);
    }


    memset(legal_move_map_, 0, sizeof(legal_move_map_));

    Find_Legal_Moves();

}
 
int Connect4State::Move(int action) {
    Find_Legal_Moves();
    if (!IsLegal(action)) {
        return -1;
    }

    if(IsResign(action)){
        is_resign_ = true;
        return 0;
    }

    last_position_ = to;

    {
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Self()];
        zobrist_hash_value_ ^= g_zobrist_player_hash_weight[Opponent()];
        zobrist_hash_value_ ^= g_zobrist_board_hash_weight[Self()][action];
    }

    ++move_count_[action];
    board_state_[action] = Self();
    ++action_count_;

    HandOff();
    GetSensibleMove();

    return 0;
}
void Connect4Env::Find_Legal_Moves() const{
    Connect4CoordId i, j, id;
    for(id = 0; id < Connect4Comm::CONNECT4BOARD_SIZE; id++){
        legal_move_map_[id] = false;
    }
    for(j = 0; j < Connect4Comm::BORDER_SIZE_LENGTH; j++){
        if(board_state_[Connect4Function::CoordToId(0, j)] != Connect4Comm::EMPTY){
            continue;
        }
        for(i = 0;(i < Connect4Comm::BORDER_SIZE_HEIGHT && board_state_[Connect4Function::CoordToId(i, j)] == Connect4Comm::EMPTY); i++);
        legal_move_map_[Connect4Function::CoordToId(--i, j)] = true;
    }
}

int Connect4Env::dir_x() const{
  static int angle = 135;  //Ƕȣ㿪ʼÿ45ȣ135ȵһλص
  if(angle < 135){
    angle+=45;
  }else{
    angle = 0;
  }
  switch(angle){
  case 0: 
    return 0;
    break;
  case 45:case 90:case 135:
    return 1;
    break;
  default:
    printf("error angle\n");
    return 0;
    break;
  }
}

int Connect4Env::dir_y() const{
  static int angle = 135;  //Ƕȣ㿪ʼÿ45ȣ135ȵһλص
  if(angle < 135){
    angle+=45;
  }else{ 
    angle = 0;
  }
  switch(angle){
  case 0: case 45:
      return 1;
      break;
  case 90:
    return 0;
    break;
  case 135:
    return -1;
    break;
  default:
    printf("error angle.\n");
    return 0;
    break;
  }
}

int Connect4Env::Connect4Result(Connect4CoordId x, Connect4CoordId y) const{
    Connect4StoneColor type;        //ΪӣΪ1Ϊ2
    int left_1[4] = {0,0,0,0};    //¼xᷴͬӵĸ
    int right_1[4] = {0,0,0,0};   //¼xͬӵĸ
    int i, j;
    int a, b;

    if(action_count_ >= Connect4Comm::CONNECT4BOARD_SIZE){
        state_ = 3;
    }
    if(is_resign_){
        if(current_player_ == Connect4Comm::BLACK){
            state_ = 2;
        }else if(current_player_ == Connect4Comm::WHITE){
            state_ = 1;
        }
    }
    if(state_ != 0){    //Ϸ
        return state_;
    }
    type = board_state_[Connect4Function::CoordToId(x, y)];
    //type = current_player_;
  
    for(i = 0; i < 4; i++){
        j = 1; a = dir_x(); b = dir_y();
        while((x + j * a < Connect4Comm::BORDER_SIZE_HEIGHT) && (y + j * b < Connect4Comm::BORDER_SIZE_LENGTH) && (x + j * a >= 0) && (y + j * b >= 0) && (board[Connect4Function::CoordToId(x + j * a, y + j * b)] == type)){    //x֮ͬʱ(ǰΪ˱֤Խ)
            j++;
            right_1[i]++;
        }
        j = 1;
        while((x - j * a < Connect4Comm::BORDER_SIZE_HEIGHT) && (y - j * b <= Connect4Comm::BORDER_SIZE_LENGTH) && (x - j * a >= 0) && (y - j * b >= 0) && (board[Connect4Function::CoordToId(x - j * a, y - j * b)] == type))    //x֮ᷴͬʱ
        {
            j++;
            left_1[i]++;
        }
    }

    for(i = 0; i < 4; i++){
        if(type == Connect4Comm::WHITE){        //ղΪӣôнж
            if((left_1[i] + right_1[i]) >= 3){   //ֻжǷʤ  
                state_ = 2;
                return state_;
            }else{            //һ
                continue;
            }
        }else{                 //Ǻ壬Ҫǽ״̬
            if((left_1[i] + right_1[i]) >= 3){    //ʤ
                state_ = 1;        //״̬ΪӦʤ
                return state_;                      //
            }
        }
    }
   
    return state_;
}

int Connect4Env::CalcResult() const{
    //Connect4StoneColor type;
    Connect4CoordId x, y;
    int result = 0;
    FOR_EACHCOORD(i) {
        if(board_state_[i] == Connect4Comm::EMPTY){
            continue;
        }else{
            Connect4Function::IdToCoord(i, x, y);
            result = Connect4Result(x, y);
            if(result != 0){
              return result;
            }
        }
    }
    return result;
}



Connect4StoneColor Connect4Env::GetWinner() const {
    int result = CalcResult();
    if (result == 3){
      return Connect4Comm::EMPTY;
    }else if (result == 1){
      return Connect4Comm::BLACK;
    }else if(result == 2){
      return Connect4Comm::WHITE;
    }
}


void Connect4Env::GetResult(float& res) {
	if (GetWinner() == Connect4Comm::EMPTY){
		res = 0.0f;
	}else{
        res = GetWinner() == CurrentPlayer() ? -1.0f : 1.0f;
    }
}

vector<bool> Connect4Env::GetFeature(BaseFeature& feature) const { // HWC
	feature.clear();
	feature.resize(CONNECT4BOARD_SIZE * (SIZE_HISTORYEACHSIDE + 1));
    // because push black into history first,
    // if next player is black,
    // we should get planes swap of each two planes
    int reverse_plane = int(Self() == BLACK);
    for (Connect4Size i = 0; i < SIZE_HISTORYEACHSIDE && i < feature_history_list_.size(); ++i) {
        const string &feature_str = *(feature_history_list_.rbegin() + (i ^ reverse_plane));
        for (int j = 0, k = i; j < CONNECT4BOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
            feature[k] = feature_str[j] - '0';
        }
    }
    if (Self() == BLACK) {
        for (int j = 0, k = SIZE_HISTORYEACHSIDE; j < CONNECT4BOARD_SIZE; ++j, k += (SIZE_HISTORYEACHSIDE + 1)) {
            feature[k] = 1;
        }
    }
    return feature;
}

int Connect4Env::GetActionNum() {//include RESIGN
	return Connect4Comm::CONNECT4BOARD_SIZE + 1;
}
 
void Connect4Env::GetInputDim(vector<int>& input_dim) {
    input_dim.clear();
    input_dim.push_back(SIZE_HISTORYEACHSIDE);
    input_dim.push_back(BORDER_SIZE_HEIGHT);
    input_dim.push_back(BORDER_SIZE_LENGTH)
}

void Connect4Env::GetLegalAction(vector<int>& action) {
    action.clear();
    FOR_EACHCOORD(id) {
        if (legal_move_map_[id]) {
            action.push_back(id);
        }
    }
}

/*void Connect4Env::TransformCoord(Connect4CoordId &x, Connect4CoordId &y, int mode, bool reverse = false)
{
    if (reverse) {
        if (mode & 4) std::swap(x, y);
        if (mode & 2) y = Connect4Comm::BORDER_SIZE_LENGTH - y - 1;
        if (mode & 1) x = Connect4Comm::BORDER_SIZE_HEIGHT - x - 1;
    } else {
        if (mode & 1) x = Connect4Comm::BORDER_SIZE_HEIGHT - x - 1;
        if (mode & 2) y = Connect4Comm::BORDER_SIZE_LENGTH - y - 1;
        if (mode & 4) std::swap(x, y);
    }
}*/
 
// void Connect4Env::TransformFeatures(BaseFeature& feature, int transform_mode) {
//     BaseFeature ret(feature.size());
//     int depth = features.size() / Connect4Comm::CONNECT4BOARD_SIZE;
//     for (int i = 0; i < Connect4Comm::CONNECT4BOARD_SIZE; ++i) {
//         Connect4CoordId x, y;
//         Connect4Function::IdToCoord(i, x, y);
//         TransformCoord(x, y, mode);
//         int j = Connect4Function::CoordToId(x, y);
//         for (int k = 0; k < depth; ++k) {
//             ret[i * depth + k] = features[j * depth + k];
//         }
//     }
//     feature = std::move(ret);
// }

// void TransformPolicy(int transform_mode) {
// }

