
#include <inttypes.h>
#include <string>
#include <vector>

// Return code of functions should be "int"
typedef uint8_t Connect4StoneColor;       // Stone color
typedef int16_t Connect4CoordId;          // Stone IDs or coordinates
typedef int16_t Connect4Size;             // Counts of visit times, used blocks, ..

namespace Connect4Comm {

const Connect4CoordId BORDER_SIZE_LENGTH = 12; // sxk_modify
const Connect4CoordId BORDER_SIZE_HEIGHT = 7;
const Connect4CoordId CONNECT4BOARD_SIZE = BORDER_SIZE_LENGTH * BORDER_SIZE_HEIGHT;
const Connect4CoordId COORD_UNSET = -2;
//const Connect4CoordId COORD_PASS = -1;
const Connect4CoordId COORD_RESIGN = -3;

const Connect4StoneColor EMPTY = 0;
const Connect4StoneColor BLACK = 1;
const Connect4StoneColor WHITE = 2;
const Connect4StoneColor WALL = 3;
const Connect4StoneColor COLOR_UNKNOWN = -1;
//const char *const COLOR_STRING[] = { "Empty", "Black", "White"};
const char *const COLOR_STRING[] = { "Empty", "Black", "White", "Wall" };

} // namespace Connect4Comm

namespace Connect4Feature {

const int SIZE_HISTORYEACHSIDE = 16;
const int SIZE_PLAYERCOLOR = 1;

const int STARTPOS_HISTORYEACHSIDE = 0;
const int STARTPOS_PLAYERCOLOR = STARTPOS_HISTORYEACHSIDE + SIZE_HISTORYEACHSIDE;

const int FEATURE_COUNT = STARTPOS_PLAYERCOLOR + SIZE_PLAYERCOLOR;

} // namespace Connect4Feature


namespace Connect4Function {

extern bool InBoard(const Connect4CoordId id);

extern bool InBoard(const Connect4CoordId x, const Connect4CoordId y);

extern bool IsUnset(const Connect4CoordId id);

extern bool IsUnset(const Connect4CoordId x, const Connect4CoordId y);

extern bool IsResign(const Connect4CoordId id);

extern bool IsResign(const Connect4CoordId x, const Connect4CoordId y);


extern void IdToCoord(const Connect4CoordId id, Connect4CoordId &x, Connect4CoordId &y);

extern Connect4CoordId CoordToId(const Connect4CoordId x, const Connect4CoordId y);

extern void StrToCoord(const std::string &str, Connect4CoordId &x, Connect4CoordId &y);

extern std::string CoordToStr(const Connect4CoordId x, const Connect4CoordId y);

extern std::string IdToStr(const Connect4CoordId id);

extern Connect4CoordId StrToId(const std::string &str);


extern void CreateGlobalVariables();

extern void CreateHashWeights();

extern void CreateQuickLog2Table();

extern void CreateZobristHash();

} // namespace Connect4Function


//typedef std::pair<Connect4CoordId, Connect4CoordId> Connect4Position;
typedef std::pair<uint64_t, uint64_t> Connect4HashValuePair;

extern Connect4HashValuePair g_hash_weight[Connect4Comm::BORDER_SIZE_HEIGHT][Connect4Comm::BORDER_SIZE_LENGTH];
const Connect4HashValuePair g_hash_unit(3, 7);
extern uint64_t g_zobrist_board_hash_weight[4][Connect4Comm::CONNECT4BOARD_SIZE];
extern uint64_t g_zobrist_player_hash_weight[4];
//state：统计棋局状态,0未分胜负，1黑胜，2白胜，3平局
//extern int state;
//extern int action_count;

extern Connect4CoordId g_log2_table[67];

#define FOR_EACHCOORD(id) for (Connect4CoordId id = 0; id < Connect4Comm::CONNECT4BOARD_SIZE; ++id)

