#pragma once

#include <inttypes.h>
#include <string>
#include <vector>

//Chess Board Id:
//  0  1  2  3  4  5  6  7
//  8  9 10 11 12 13 14 15
// 16 17 18 19 20 21 22 23
// 24 25 26 27 28 29 30 31
// 32 33 34 35 36 37 38 39
// 40 41 42 43 44 45 46 47
// 48 49 50 51 52 53 54 55 
// 56 57 58 59 60 61 62 63 
//End

// Return code of functions should be "int"
typedef uint8_t ChessStoneColor;       // Stone color
typedef int16_t ChessCoordId;          // Stone IDs or coordinates
typedef int16_t ChessSize;             // Counts of visit times, used blocks, .. or other count

namespace ChessComm {

const ChessCoordId BORDER_SIZE = 8; // sxk_modify
const ChessCoordId CHESSBOARD_SIZE = BORDER_SIZE * BORDER_SIZE;
const ChessCoordId COORD_UNSET = -2;
//const ChessCoordId COORD_PASS = -1;
const ChessCoordId COORD_RESIGN = -3;

const ChessStoneColor EMPTY = 0;
const ChessStoneColor BLACK = 1;
const ChessStoneColor WHITE = 2;
const ChessStoneColor WALL = 3;
const ChessStoneColor WHITE_PAWN = 4;
const ChessStoneColor WHITE_KNIGHT = 5;
const ChessStoneColor WHITE_BISHOP = 6;
const ChessStoneColor WHITE_ROOK = 7;
const ChessStoneColor WHITE_QUEEN = 8;
const ChessStoneColor WHITE_KING = 9;
const ChessStoneColor BLACK_PAWN = 10;
const ChessStoneColor BLACK_KNIGHT = 11;
const ChessStoneColor BLACK_BISHOP = 12;
const ChessStoneColor BLACK_ROOK = 13;
const ChessStoneColor BLACK_QUEEN = 14;
const ChessStoneColor BLACK_KING = 15;
const ChessStoneColor COLOR_UNKNOWN = -1;
const char *const COLOR_STRING[] = { "Empty", "Black", "White", "Wall", "White Pawn", "White Knight", "White Bishop", "White Rook", "White Queen", "White King", "Black Pawn", "Black Knight", "Black Bishop", "Black Rook", "Black Queen", "Black King" };

const ChessCoordId N = -8;
const ChessCoordId S = 8;
const ChessCoordId E = 1;
const ChessCoordId W = -1;
const ChessCoordId NW = -9;
const ChessCoordId SW = 7;
const ChessCoordId NE = -7;
const ChessCoordId SE = 9;
const ChessCoordId NNW = -17;
const ChessCoordId NNE = -15;
const ChessCoordId NWW = -10;
const ChessCoordId NEE = -6;
const ChessCoordId SSW = 15;
const ChessCoordId SSE = 17;
const ChessCoordId SWW = 6;
const ChessCoordId SEE = 10;

} // namespace ChessComm

namespace ChessFeature {

const int SIZE_HISTORYEACHSIDE = 16;
const int SIZE_PLAYERCOLOR = 1;

const int STARTPOS_HISTORYEACHSIDE = 0;
const int STARTPOS_PLAYERCOLOR = STARTPOS_HISTORYEACHSIDE + SIZE_HISTORYEACHSIDE;

const int FEATURE_COUNT = STARTPOS_PLAYERCOLOR + SIZE_PLAYERCOLOR;

} // namespace ChessFeature


namespace ChessFunction {

extern bool InBoard(const ChessCoordId id);

extern bool InBoard(const ChessCoordId x, const ChessCoordId y);

extern bool IsUnset(const ChessCoordId id);

extern bool IsUnset(const ChessCoordId x, const ChessCoordId y);

extern bool IsResign(const ChessCoordId id);

extern bool IsResign(const ChessCoordId x, const ChessCoordId y);


extern void IdToCoord(const ChessCoordId id, ChessCoordId &x, ChessCoordId &y);

extern ChessCoordId CoordToId(const ChessCoordId x, const ChessCoordId y);

extern void StrToCoord(const std::string &str, ChessCoordId &x, ChessCoordId &y);

extern std::string CoordToStr(const ChessCoordId x, const ChessCoordId y);

extern std::string IdToStr(const ChessCoordId id);

extern ChessCoordId StrToId(const std::string &str);

extern void ActionToId(const int &action, const ChessCoordId &from_id, const ChessCoordId &to_id, ChessStone &captured_stone, ChessStone &promoted_stone, ChessStone &stone);

extern void IdToAction(const ChessCoordId &from_id, const ChessCoordId &to_id, ChessStone &captured_stone, ChessStone &promoted_stone, ChessStone &stone, const int &action);

extern void CreateGlobalVariables();

extern void CreateHashWeights();

extern void CreateQuickLog2Table();

extern void CreateZobristHash();

} // namespace ChessFunction


//typedef std::pair<ChessCoordId, ChessCoordId> ChessPosition;
typedef std::pair<uint64_t, uint64_t> ChessHashValuePair;

extern ChessHashValuePair g_hash_weight[ChessComm::BORDER_SIZE][ChessComm::BORDER_SIZE];
const ChessHashValuePair g_hash_unit(3, 7);
extern uint64_t g_zobrist_board_hash_weight[4][ChessComm::CHESSBOARD_SIZE];
extern uint64_t g_zobrist_player_hash_weight[4];
//action_count:统计已落子数，state：统计棋局状态,0未分胜负，1黑胜，2白胜，3平局
//extern int action_count = 0;
//extern int state = 0;

extern ChessCoordId g_log2_table[67];

#define FOR_EACHCOORD(id) for (ChessCoordId id = 0; id < ChessComm::CHESSBOARD_SIZE; ++id)
