/*
	Base class for environments of RL.
    	Following features:
        Discrete and fix-size action space.
      Used as:
        Experiment environment;
        Environment in Agents' mind
*/
//EnCode for move(action)::
/*
from_id     64
to_id       64
captured    10
promoted    8
stone       17
Attention: all this coding part should be >= 0
*/
//action = from_id * 64^4 + to_id * 64^3 + captured * 64^2 + promoted * 64^1 = stone * 64^0
#include <cstdlib>
#include <string>
  
class Chess: public BaseEnv {
public:
      Chess();
      ~Chess();
      virtual int Move(int action) = 0;
      virtual bool IsFinish() = 0;
      virtual void GetResult(float& res) = 0;
      virtual void GetFeature(BaseFeature& feature) = 0;
      virtual void GetActionNum() = 0;
      virtual void GetInputDim(vector<int>& input_dim) = 0;
      virtual void GetLegalAction(vector<int>& action) = 0;
      virtual bool IsLegal(int action) = 0;
      virtual std::string action2str(int action) = 0;
      //virtual void TransformFeatures(BaseFeature& feature, int transform_mode) = 0;
      //virtual void TransformPolicy(int transform_mode) = 0; // this is reverse mode of TransformFeature
protected:
      virtual void Init() = 0;
};
         