def firstlast2lastfirst(name):
    if "," in name:
        return name
    # 名人列表中存在一些名字是First Name Last Name的格式，将其转换为Last Name, First Name格式
    # 例如：'John Doe' -> 'Doe, John'，'M. Jane Smith' -> 'Smith, Jane M.'
    special_str = [".", "Ms.", "Mr.", "Mrs.", "Dr.", "Prof.", "PhD", "MD", "Jr.", "Sr.", "The", "Honorable"]
    special_str = [item.lower() for item in special_str]
    name_split = name.split(" ")
    name_split = [item.strip() for item in name_split if item.strip() != ""]
    name_split = [item for item in name_split if item not in special_str]
    
    # Grigory Isaakovich Barenblatt --> Barenblatt, Alexa, Marc Isaakovich
    
    if len(name_split) == 2:
        first_name = name_split[0]
        last_name = name_split[1]
        new_name = f"{last_name}, {first_name}"
    elif len(name_split) == 3:
        if name_split[0].startswith("(") and name_split[0].endswith(")"):
            # (Alexander) Philip Dawid
            first_name = f"{name_split[1]} {name_split[0]}"
            last_name = f"{name_split[2]}"
        elif name_split[1].startswith("(") and name_split[1].endswith(")"):
            # Xinyan (Tracy) Cui --> Cui, Xinyan (Tracy)
            first_name = f"{name_split[0]} {name_split[1]}"
            last_name = f"{name_split[2]}"
        elif name_split[2].startswith("(") and name_split[2].endswith(")"):
            # Ye Fred (Ying)实际是姓Ye，名Ying，英文名Fred, 需要将其转换为"Ye, Ying Fred"
            # Zhu Jesse (Jingxu)实际是姓Zhu，名Jingxu，英文名Jesse, 需要将其转换为"Zhu, Jingxu Jesse"
            first_name = f"{name_split[2][1:-1]} ({name_split[1]})"
            last_name = f"{name_split[0]}"
        elif name_split[0].endswith("."):
            # M. Jane Smith --> Smith, Jane M.
            # K.W. Michael Siu --> Siu, Michael K.W.
            first_name = f"{name_split[1]} {name_split[0]}"
            last_name = name_split[2]
        elif name_split[1].endswith("."):
            # Jane M. Smith --> Smith, Jane M.
            # Pierre J.H. Richardson --> Richardson, Pierre J.H.
            first_name = f"{name_split[0]} {name_split[1]}"
            last_name = name_split[2]
        elif name_split[2].endswith("."):
            # Wimmer-Schweingruber Robert F. --> Wimmer-Schweingruber, Robert F.
            # Wilderer Peter A. --> Wilderer, Peter A.
            first_name = f"{name_split[1]} {name_split[2]}"
            last_name = f"{name_split[0]}"
        else:
            # William Nelson Joy --> Joy, William Nelson
            # Michael J Carey --> Carey, Michael J
            # len_3_list.append(" ".join(name_split))
            first_name = f"{name_split[0]} {name_split[1]}"
            last_name = name_split[2]
        
        new_name = f"{last_name}, {first_name}"
        # print(f"{name} --> {new_name}")
    else:
        # lens greater than 3 这部分名字应该不会跟其他部分名字出现重复
        last_name = name_split[-1]
        first_name = " ".join(name_split[:-1])
        new_name = f"{last_name}, {first_name}"
        
    return new_name


def name_in_niuren_list(name, niuren_name_list):
    """
    判断名字是否在牛人列表中
    :param name: 名字
    :param niuren_name_list: 牛人列表
    :return: 如果在牛人列表中，返回 True，否则返回 False
    """
    for idx, niuren_name in enumerate(niuren_name_list):
        if isinstance(niuren_name, str):
            if name == niuren_name:
                return idx
        elif isinstance(niuren_name, list):
            if name in niuren_name:
                return idx

    for idx, niuren_name in enumerate(niuren_name_list):
        if isinstance(niuren_name, str):
            if niuren_name.startswith(name):
                if niuren_name[niuren_name.find(name) + len(name)] == " ":
                    return idx
            if name.startswith(niuren_name):
                if name[name.find(niuren_name) + len(niuren_name)] == " ":
                    return idx
        elif isinstance(niuren_name, list):
            for niuren_name_item in niuren_name:
                if niuren_name_item.startswith(name):
                    if niuren_name_item[niuren_name_item.find(name) + len(name)] == " ":
                        return idx
                if name.startswith(niuren_name_item):
                    if name[name.find(niuren_name_item) + len(niuren_name_item)] == " ":
                        return idx
    return -1