country_to_id_map = {
    "美国": 1,
    "中国": 2,
    "日本": 3,
    "韩国": 4,
    "新加坡": 5,
    "台湾": 6,
    "香港": 7,
    "澳门": 8,
    "中国台湾": 6,
    "中国香港": 7,
    "中国澳门": 8,
    "法国": 9,
    "英国": 10,
    "德国": 11,
    "意大利": 12,
    "西班牙": 13,
    "加拿大": 14,
    "荷兰": 15,
    "印度": 16,
    "阿联酋": 17,
    "比利时": 18,
    "俄罗斯": 19,
    "阿富汗": 20,
    "亚美尼亚": 21,
    "阿塞拜疆": 22,
    "巴林": 23,
    "孟加拉国": 24,
    "不丹": 25,
    "文莱": 26,
    "缅甸": 27,
    "柬埔寨": 28,
    "塞浦路斯": 29,
    "东帝汶": 30,
    "格鲁吉亚": 31,
    "印度尼西亚": 32,
    "伊朗": 33,
    "伊拉克": 34,
    "以色列": 35,
    "约旦": 36,
    "哈萨克斯坦": 37,
    "科威特": 38,
    "吉尔吉斯斯坦": 39,
    "老挝": 40,
    "黎巴嫩": 41,
    "马来西亚": 42,
    "马尔代夫": 43,
    "蒙古": 44,
    "尼泊尔": 45,
    "朝鲜": 46,
    "阿曼": 47,
    "巴基斯坦": 48,
    "巴勒斯坦": 49,
    "菲律宾": 50,
    "卡塔尔": 51,
    "沙特阿拉伯": 52,
    "斯里兰卡": 53,
    "叙利亚": 54,
    "塔吉克斯坦": 55,
    "泰国": 56,
    "土库曼斯坦": 57,
    "乌兹别克斯坦": 58,
    "越南": 59,
    "也门": 60,
    "北塞浦路斯": 61,
    "纳戈尔诺-卡拉巴 赫": 62,
    "阿尔及利亚": 63,
    "安哥拉": 64,
    "贝宁": 65,
    "博茨瓦纳": 66,
    "布基纳法索": 67,
    "布隆迪": 68,
    "佛得角": 69,
    "喀麦隆": 70,
    "中非共和国": 71,
    "乍得": 72,
    "科摩罗": 73,
    "刚果": 75,
    "科特迪瓦": 76,
    "吉布提": 77,
    "埃及": 78,
    "赤道几内亚": 79,
    "厄立特里亚": 80,
    "埃塞俄比亚": 81,
    "加蓬": 82,
    "冈比亚": 83,
    "加纳": 84,
    "几内亚": 85,
    "几内亚比绍": 86,
    "肯尼亚": 87,
    "莱索托": 88,
    "利比里亚": 89,
    "利比亚": 90,
    "马达加斯加": 91,
    "马拉维": 92,
    "马里": 93,
    "毛里塔尼亚": 94,
    "毛里求斯": 95,
    "摩洛哥": 96,
    "莫桑比克": 97,
    "纳米比亚": 98,
    "尼日尔": 99,
    "尼日利亚": 100,
    "卢旺达": 101,
    "圣多美和普林西比": 102,
    "塞内加尔": 103,
    "塞舌尔": 104,
    "塞拉利昂": 105,
    "索马里": 106,
    "南非": 107,
    "南苏丹": 108,
    "苏丹": 109,
    "斯威士兰": 110,
    "坦桑尼亚": 111,
    "多哥": 112,
    "突尼斯": 113,
    "乌干达": 114,
    "赞比亚": 115,
    "津巴布韦": 116,
    "西撒哈拉": 117,
    "阿尔巴尼亚": 118,
    "安道尔": 119,
    "奥地利": 120,
    "白俄罗斯": 121,
    "波斯尼亚和黑塞哥维那": 122,
    "保加利亚": 123,
    "克罗地亚": 124,
    "捷克": 125,
    "丹麦": 126,
    "爱沙尼亚": 127,
    "芬兰": 128,
    "希腊": 129,
    "匈牙利": 130,
    "冰岛": 131,
    "爱尔兰": 132,
    "拉脱维亚": 133,
    "列支敦士登": 134,
    "立陶宛": 135,
    "卢森堡": 136,
    "马耳他": 137,
    "摩尔多瓦": 138,
    "摩纳哥": 139,
    "黑山": 140,
    "北马其顿": 141,
    "挪威": 142,
    "波兰": 143,
    "葡萄牙": 144,
    "罗马尼亚": 145,
    "圣马力诺": 146,
    "塞尔维亚": 147,
    "斯洛伐克": 148,
    "斯洛文尼亚": 149,
    "瑞典": 150,
    "瑞士": 151,
    "乌克兰": 152,
    "梵蒂冈": 153,
    "科索沃": 154,
    "法罗群岛": 155,
    "直布罗陀": 156,
    "安提瓜和巴布达": 157,
    "巴哈马": 158,
    "巴巴多斯": 159,
    "伯利兹": 160,
    "哥斯达黎加": 161,
    "古巴": 162,
    "多米尼加": 163,
    "多米尼加共和国": 164,
    "萨尔瓦多": 165,
    "格林纳达": 166,
    "危地马拉": 167,
    "海地": 168,
    "洪都拉斯": 169,
    "牙买加": 170,
    "墨西哥": 171,
    "尼加拉瓜": 172,
    "巴拿马": 173,
    "圣基茨和尼维斯": 174,
    "圣卢西亚": 175,
    "圣文森特和格林纳丁斯": 176,
    "特立尼达和多巴哥": 177,
    "百慕大": 178,
    "格陵兰": 179,
    "波多黎各": 180,
    "美属维尔京群岛": 181,
    "英属维尔京群岛": 182,
    "开曼群岛": 183,
    "安圭拉": 184,
    "蒙特塞拉特": 185,
    "阿根廷": 186,
    "玻利维亚": 187,
    "巴西": 188,
    "智利": 189,
    "哥伦比亚": 190,
    "厄瓜多尔": 191,
    "圭亚那": 192,
    "巴拉圭": 193,
    "秘鲁": 194,
    "苏里南": 195,
    "乌拉圭": 196,
    "委内瑞拉": 197,
    "法属圭亚那": 198,
    "福克兰群岛": 199,
    "澳大利亚": 200,
    "斐济": 201,
    "基里巴斯": 202,
    "马绍尔群岛": 203,
    "密克罗尼西亚": 204,
    "瑙鲁": 205,
    "新西兰": 206,
    "帕劳": 207,
    "巴布亚新几内亚": 208,
    "萨摩亚": 209,
    "所罗门群岛": 210,
    "汤加": 211,
    "图瓦卢": 212,
    "瓦努阿图": 213,
    "库克群岛": 214,
    "纽埃": 215,
    "法属波利尼西亚": 216,
    "新喀里多尼亚": 217,
    "瓦利斯和富图纳": 218,
    "托克劳": 219,
    "皮特凯恩群岛": 220,
    "土耳其": 221,
}


def country_to_idx(country_str: str) -> str:
    result = []
    country_str = country_str.strip()
    for country in country_str.split(";"):
        clean_country = country.strip()
        if clean_country not in country_to_id_map:
            err_msg = f"Unknown Country: {clean_country}"
            print(err_msg)
            raise ValueError(err_msg)
        else:
            result.append(str(country_to_id_map[clean_country]))

    return ";".join(result)
