import json
import logging
import psrc.stage1.citationProcess as CP
from pathlib import Path

if __name__ == "__main__":
    cwd_dir = Path.cwd()

    # 构建 config.json 的完整路径
    config_path = (cwd_dir / "config.json").resolve()

    # 读取config.json中的配置参数
    with open( config_path, 'r', encoding='utf-8') as f:
        config = json.load(f)

    # Path对象后跟/用于连接地址

     # 创建日志目录
    log_dir = cwd_dir / "logs"
    log_dir.mkdir(exist_ok=True)
    
     # 配置日志系统
    log_file = log_dir / "citation_process.log"
    logLevel = config["logLevel"]
    # logging.basicConfig(...) 是 Python 标准库 logging 模块中的一个函数，用于快速配置日志记录的基本设置.
    # 设置日志记录的最低级别为 INFO, 只有日志级别大于等于 INFO 的日志记录才会被处理（例如 INFO、WARNING、ERROR、CRITICAL）.
    # logging.debug("这是一个调试信息")    # 不会输出（低于 INFO）
    # logging.info("这是一个普通信息")     # 会输出
    logging.basicConfig(
        # %(asctime)s：日志记录的时间戳（默认格式：YYYY-MM-DD HH:MM:SS）。
        # %(levelname)s：日志级别名称（如 INFO, WARNING）。
        # %(message)s：日志的具体内容。
        level=logLevel, format="%(asctime)s - %(levelname)s - %(message)s",
        handlers=[
            logging.FileHandler(log_file, encoding='utf-8'),
            logging.StreamHandler()
        ]
    )

    logging.info(f"程序启动，日志文件保存在: {log_file}")
    CP.citationProcess(config)
