# 环境配置
- 确保执行py的cwd在papertools仓库文件夹下
- 路径和参数配置都在config.json文件中
    - api_key
        - 目前的密钥是东辰同学自己从知乎上打广告赚来的，只有100块的额度，请尽量使用自己的密钥
        - 如果使用不同的API的密钥注意更改openAI的调用方式，这里推荐硅基流动，因为我就是用硅基流动跑通的
    - base_url
        - api接口url
    - pdf_dir
        - 放置论文pdf的文件夹
    - result_dir
        - 输出关键信息json文件的文件夹
    - source_excel_path
        - 放置需要check的excel表格
        - 第context_start+1行开始实际表项
        - 第一列索引
        - 第三列论文标题
        - 第七列论文作者
    - target_excel_path
        - 输出的格式化表格
    - ccfa_excel_path
        - CCFA的参考表格
    - logLevel
        - 取10表示DEBUG级别
        - 取20表示INFO级别
    - sheetNum 需要处理的工作表数量
    - maxItem 每个工作表的最大条目数
- python3.12
- 无法import的库使用pip install逐个安装
    - `openai`, `pypdf`
    - `python-Levenshtein`

# 使用方法
- 将excel表的第三行改为如下图所示包含被引用文章标题的bibtex格式
    - ![](./others/bibtex.png)
- 查看config.json正确配置参数，让程序能够找到需要的文件位置和参数
    - 默认配置
        - 文章的pdf分sheet放置在Papers/sheetname文件夹下
        - 待check的excel表格放在others文件夹中
        - 输出的表格放在target文件夹中, pdf会原地标准化重命名
- python main.py 执行程序
- 程序执行过程中，不要打开target excel文件，不然会争用权限发生错误
- 成功后的日志样例在logs文件夹下
- 断点处理：如果在excel某个序号之前的pdf都正确提取了信息，并且正确修改了excel，下一个序号开始的pdf出错了
    - 建议将正确的pdf都转移到其他文件夹，这样再次运行脚本将处理剩下的pdf
- TODO:多模型交叉验证
- TODO:Temperature的设置

# 需求与解决方案
1. TODO:下载论文pdf
    1. 常用网站agent下载
    2. 输出无法下载的条目
2. stage1:自动化提取信息和格式化
    1. 通过config.json读取配置对象
    2. **遍历**excel的sheet
        1. **遍历**sheet中的论文名称和索引
            1. 用**大模型**读取pdf中第一页的论文名称和关键信息，存储到json文件夹下
            2. 读取pdf中从后向前的引用信息, 通过**大模型**找出sheetname对应文章在当前pdf文章中的索引，存储到json文件夹下
            3. **遍历**excel表格中的论文名称进行模糊匹配, 匹配成功后
                1. 将pdf文件中的关键信息写入json文件中进行保存, 包括 标题 会议名称 作者姓名 机构 国家.
                2. 用pdf文件中的论文名称和索引标准化重命名pdf文件和excel表格中的论文标题、会议名称、作者姓名、机构、国家.
                3. 首先用**大模型**将英文国家名翻译成中国名，将国家对应的索引写入目标excel表格中.
                4. 将pdf文件中的会议或者期刊名称和CCFA的会议或者期刊名称的表格交给**大模型**匹配,匹配结果以“是/否”的形式写入目标excel表格中.
            4. 匹配失败后，输出无法匹配的条目,使用warning记录无法匹配的条目，方便后续处理.
    3. 得到从pdf中提取的信息和格式化的excel表格.
    4. 人工复核
        1. 可能会有重复的pdf，只有标准化重命名之后才会发现，当两个pdf的索引名称相同时，说明pdf重复匹配，需要手动删除重复的pdf和excel表项，由人工结合原表格信息判定重复现象.
        2. 可能机构和国家会有重复，请人工检查.
        3. 读log查红色warning信息
3. stage2: 知名企业、牛人判断

# 代码结构说明
1. psrc文件夹下是库函数
2. config.json是配置文件
3. main.py是主程序
4. logs文件夹是日志文件
5. json文件夹是关键信息json文件