# Excel 格式检查脚本

## requirements
`
openpyxl>=3.0.0
`
## 功能

本脚本用于自动检查指定 Excel 文件中若干 Sheet 的格式和内容是否规范：

- 跳过每个 Sheet 前三行，从第四行（标题行）开始校验。
- 检查每列内容的格式（如是否为空、是否为合法 URL、作者格式等）。
- 若发现格式问题，会在 Excel 文件中用红色标注问题单元格并添加批注。
- 会输出一个详细的文本报告，列出所有问题。

---

## 输入格式

- **Excel 文件**（如 `测试输入.xlsx`）
- 至少包含一个 Sheet，Sheet 名称需在脚本 `sheet_names` 变量中指定。
- 每个 Sheet 的**第4行**为标题行，要求包含以下列：

    ```
    序号、引文链接、引文名称、期刊/会议名称、是否是CCF-A、
    引用序号、引文作者、通讯作者顺序、引文机构、引文机构所属国家索引、
    引文机构所属国家、引文机构在知名企业中的索引、
    知名企业名称（参考知名企业列表）、牛人(参考全局牛人列表)、牛人署名顺序
    ```

---

## 输出格式

- **标记后的 Excel 文件**
  - 命名为：原文件名后加 `_标记`（如 `测试输入_标记.xlsx`）
  - 有问题的单元格会被标红并添加批注说明原因。
  - 如果标题栏缺少列，标题行第1-10列都会被标红，第1列批注缺少的列名。

- **文本报告**
  - 命名为：原文件名后加 `_格式问题报告.txt`
  - 列出所有 Sheet、行、列的具体格式问题，方便汇总和修改。

---

## 使用方法

1. 修改脚本开头的 `excel_path` 和 `sheet_names` 变量，指定你的 Excel 文件和需要检查的 Sheet 名。
2. 运行脚本：
    ```bash
    python format_checking.py
    ```
3. 查看输出的 `_标记.xlsx` 和 `_格式问题报告.txt` 文件。

---