# CCF-A 期刊/会议自动判别脚本

## 功能简介




本脚本可自动判断 Excel 文件中每条期刊/会议名称是否属于 CCF-A 类别，并在指定列中填写“是”或“否”。

- 支持批量处理指定 Sheet。
- 自动比对 CCF-A 会议/期刊缩写（括号内）或全称。
- 输出标注好“是否是CCF-A”的新 Excel 文件。


# [!] 本脚本采用精确匹配，因此更容易出现假阴性（即：实际应该是 CCF-A，但被判定为“否”），而不容易出现假阳性（即：实际不是 CCF-A，被判定为“是”）。


## 输入文件说明

### 1. CCF_A_list.csv

- 两列，带表头：`abbr,fullname`
- `abbr`：CCF-A会议/期刊缩写（如 AAAI）
- `fullname`：CCF-A会议/期刊全称（如 AAAI Conference on Artificial Intelligence）

示例：
```
abbr,fullname
AAAI,AAAI Conference on Artificial Intelligence
SIGMOD,ACM SIGMOD International Conference on Management of Data
```

### 2. 测试输入.xlsx

- 至少包含一个待检查的 Sheet，Sheet 名在脚本 `sheet_names` 变量设定。
- 每个 Sheet 的**第4行为标题行**，且**第4列为“期刊/会议名称”**，**第5列为“是否是CCF-A”**。

标题示例（第4行应如下）：

| ... | 期刊/会议名称 | 是否是CCF-A | ... |
|-----|--------------|-------------|-----|

---

## 脚本用法

1. 将 `CCF_A_list.csv` 和 `测试输入.xlsx` 放在同一目录下。
2. 修改脚本头部 `sheet_names`，如：

    ```python
    sheet_names = ["Dadiannao"]
    ```

3. 运行脚本：

    ```bash
    python check_ccfa.py
    ```

4. 程序会输出新文件：  
   `测试输入_CCF_A判断.xlsx`  
   其中每条记录的“是否是CCF-A”列将被自动填充“是”或“否”。

---

## 判别规则

1. **简称优先判断**
    - **先提取括号内简称**（支持中英文括号），只保留英文字母。
    - **再提取冒号前简称**（支持英文冒号 `:` 和中文冒号 `：`），只保留英文字母。
    - 如果存在简称（即括号简称或冒号前简称），将其与 CCF-A 列表的缩写（abbr）进行**精确匹配**：
        - **匹配成功则判为“是”**。
        - **如果简称存在但未匹配成功，直接判为“否”**，不再进行全称判断。

2. **全称匹配判断**
    - **仅当上述两种简称均不存在时**，才对“期刊/会议名称”与 CCF-A 列表的全称（fullname）进行**包含匹配**：
        - 只要 CCF-A 全称出现在名称中，即判为“是”；
        - 否则判为“否”。
---

## 依赖环境

- openpyxl

可通过 pip 安装依赖：

```bash
pip install openpyxl