from selenium import webdriver
from selenium.webdriver.chrome.service import Service
from webdriver_manager.chrome import ChromeDriverManager
from selenium.webdriver.chrome.options import Options
from config import CHROME_USER_OPTION_PATH, DOWNLOAD_DIR

class ChromeDriver:
    _instance = None
    download_dir = DOWNLOAD_DIR

    def __new__(cls, *args, **kwargs):
        if not cls._instance:
            cls._instance = super(ChromeDriver, cls).__new__(cls)
            cls._instance._initialized = False
        return cls._instance

    def __init__(self, start_fullscreen=True, user_agent=None):
        if not self._initialized:

            driver_path = ChromeDriverManager().install()
            service = Service(executable_path=driver_path)

            options = webdriver.ChromeOptions()
            options.add_argument(
                f"--user-data-dir={CHROME_USER_OPTION_PATH}",
            )
            options.add_experimental_option(
                "prefs",
                {
                    "download.default_directory": self.download_dir,
                    "download.prompt_for_download": False,
                    "download.directory_upgrade": True,
                    "plugins.always_open_pdf_externally": True,
                },
            )
            # options.add_experimental_option("prefs", prefs)
            # if start_fullscreen:
            #     options.add_argument("--start-fullscreen")
            # if user_agent:
            #     options.add_argument(f"user-agent={user_agent}")

            self.driver = webdriver.Chrome(options=options)

            self._initialized = True

    def get_driver(self):
        return self.driver
