from urllib.parse import urlparse
from pdfDownloader.downloader import (
    PaperDownloader,
    IEEEExploreDownloader,
    ScienceDirectDownloader,
    ProQuestDownloader,
    ArxivDownloader,
    SpringerDownloader,
    acmDownloader,
    mdpiDownloader,
    patentDownloader
)
from driver import ChromeDriverManager


class DownloaderFactory:    

    @staticmethod
    def get_downloader(url: str) -> PaperDownloader:
        domain = urlparse(url).netloc

        if "patents.google.com" in domain:
            return patentDownloader
        elif "arxiv.org" in domain:
            return ArxivDownloader
        elif "www.mdpi.com" in domain:
            return mdpiDownloader
        elif "dl.acm.org" in domain:
            return acmDownloader
        elif "link.springer.com" in domain:
            return SpringerDownloader
        elif "ieeexplore.ieee.org" in domain:
            return IEEEExploreDownloader
        elif "search.proquest.com" in domain:
            return ProQuestDownloader
        elif "sciencedirect.com" in domain:
            return ScienceDirectDownloader

        else:
            raise ValueError(f"Unsupported website: {domain}")
