# PDF Crawler for Academic Websites

本程序用于批量爬取主流学术网站论文的PDF档案和相关元数据，支持断点续传，并可采集作者、发表期刊、机构等字段（部分字段依赖网站信息精度，需人工复检）。**当前支持的网站列表如下：**

* mdpi
* acm
* springer
* ieee
* proquest
* patents

## Requirement

**1. 安装依赖**

```bash
pip install Selenium pandas
```

**2. 安装 [Chrome 浏览器](https://www.google.com/chrome/)**

---

## Quick Start

### Step 1. 配置 config.py

在项目目录下找到 `config.py`，需要修改如下三个路径并填写为你本地机器对应的绝对路径：

```python
CHROME_USER_OPTION_PATH = "C:\\Users\\你的用户名\\AppData\\Local\\Google\\Chrome\\User Data"
DOWNLOAD_DIR = "D:\\你的下载目录路径\\pdf_tmp"
SAVED_DIR = "D:\\你的保存目录路径\\pdf_saved"
```

#### 路径说明

* **CHROME_USER_OPTION_PATH**
  Chrome 用户数据目录。用于selenium启用你的真实已登录Chrome配置，包括cookies与插件，使得下载无需每次重新登录。可在Chrome地址栏里输入 `chrome://version/` 查看本地“个人资料路径（Profile Path）”。
* **DOWNLOAD_DIR**
  临时下载目录。程序将PDF文件先下载至此目录，确保有写入权限。
* **SAVED_DIR**
  最终保存目录。下载失败与已完成文件会被迁移/整理至此目录做归档。

---

### Step 2. 配置待爬取链接 input.xlsx

创建 `data/input.xlsx` 文件，格式如下：

| url                                          | author | pdf|
| -------------------------------------------- || ------------------ |
| [https://xx.xx/xxxx](https://xx.xx/xxxx.pdf) | 0          | 0             | 0              | 0                  |

**说明**

* 第一列 `url`：放置你要爬取的网页或PDF链接。
* 其余每列初始请全部填0，程序自动修改为1表示该资源已处理/已爬取。方便断点恢复和进度追踪。

---

### Step 3. Chrome 登录准备

**注意：部分学术论文网站需要登录后才可下载文献（尤其机构授权的PDF下载权限）。为保证能正常下载PDF，请务必提前完成下列操作：**

1. **启动Chrome浏览器。**
2. **登录你准备爬取的论文网站并认证机构信息。常见网站包含：**
   * mdpi
   * acm
   * springer
   * ieee
   * sciencedirect
   * ...
3. **确认登录状态有效（可直接下载PDF且不弹出登录页/验证码）。**

---

### Step 4. 关闭全部Chrome浏览器

> **必须关闭所有Chrome实例** （包括后台服务），避免Selenium和本地Chrome操作配置文件时冲突、导致启动失败或cookie丢失。

---

### Step 5. 启动爬虫

```bash
python main.py
```

---

## 功能描述

1. **支持断点续传** ：重复运行不会重复下载已爬取论文，可跨多次启动继续未完成工作。
2. **PDF下载支持** ：适配["mdpi","acm", "springer", "ieee", "proquest", "patents"]等常见学术和专利网站。
3. **元数据采集** ：自动提取论文作者、发表期刊名与（部分网站）机构，结果自动保存修改到 `modified_output.csv`。

* 注意：机构爬取仅适用于部分网站，且如ieee只能爬取作者当前单位，和实际论文中单位可能不同。

1. **多字段复核建议** ：自动爬取的信息仅供参考，一定要人工审核核查。

---

### 注意事项

* 某些网站的机构字段存在一定的不确定性，仅作辅助统计用途。
* **所有结果建议人工复检，确保数据准确。**
* 若首次运行遇到chromedriver下载失败，请检查代理/梯子设置。

---

## 支持网站字段详情

| 网站                                                | 作者列表 | 发表期刊 | 机构                                             |
| --------------------------------------------------- | -------- | -------- | ------------------------------------------------ |
| ieeexplore.ieee.org                                 | √       | √       | √（爬取作者主页当前机构，和论文单位可能有区别） |
| dl.acm.org                                          | √       | √       |                                                  |
| arxiv.org                                           | √       | √       |                                                  |
| [www.mdpi.com](http://www.mdpi.com/)                   | √       | √       | √                                               |
| link.springer.com                                   | √       | √       |                                                  |
| patents.google.com（专利）                          | √       | √       | √                                               |
| [www.sciencedirect.com](http://www.sciencedirect.com/) | √       | √       | √                                               |
