from utils import read_config
from utils_vllm import vllm_chatcomplete
from step1_sample_apps import mk_sample_prompt
from step1_evaluate_code import evaluate
from step1_sort_split_dataset import sort_and_split_dataset 


if __name__ == "__main__":
    cfg = read_config()
    
    mk_sample_prompt(cfg["model"], cfg["apps"], cfg["sample"]["sample_prompt_path"])

    vllm_chatcomplete(
        cfg["model"],
        cfg["sample"]["sample_prompt_path"],
        cfg["sample"]["sample_result_path"],
        cfg["sample"]["sampling_params"],
    )

    evaluate(
        cfg["sample"]["sample_result_path"],
        cfg["apps"],
        cfg["evaluate"]["evaluate_result_path"],
    )

    sort_and_split_dataset(
        cfg["evaluate"]["evaluate_result_path"],
        cfg["dataset"]["train_path"],
        cfg["dataset"]["test_path"],
        cfg["dataset"]["minimal_test_path"],
        cfg["sample"]["sampling_params"]["n"]
    )