import json
import re
from codebleu import calc_codebleu
import sys

if sys.version_info < (3, 11):
    import tomli as tomllib
else:
    import tomllib



def load_jsonl(file_path):
    with open(file_path, "r", encoding="utf-8") as f:
        return [json.loads(line) for line in f]


def load_json(file_path):
    with open(file_path, "r", encoding="utf-8") as f:
        return json.load(f)


def save_jsonl(data, file_path):
    with open(file_path, "w", encoding="utf-8") as f:
        for item in data:
            f.write(json.dumps(item) + "\n")

def save_json(data, file_path, indent=None):
    with open(file_path, "w", encoding="utf-8") as f:
        json.dump(data, f, indent=indent)


codeblock_pattern = re.compile(r"```python(.+?)```", flags=re.DOTALL)
code_template = """```python
{}
```
"""

def extract_code(text: str):
    codes = [match.strip() for match in re.findall(codeblock_pattern, text)]
    if len(codes) > 0:
        code = "\n".join(codes)
        return code
    else:
        return ""


def code_similarity(ref, pred):
    return calc_codebleu([ref], [pred], lang="python", weights=(0, 0.5, 0.5, 0))
