import argparse
from pathlib import Path
from utils import save_json
from utils_vllm import vllm_chatcomplete
from step1_sample_apps import mk_sample_prompt
from step1_evaluate_code import evaluate
from step1_sort_split_dataset import sort_and_split_dataset


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--model", type=str)
    parser.add_argument("--apps", type=str)
    parser.add_argument("--output_dir", type=str)
    args = parser.parse_args()

    output_dir = Path(args.output_dir)
    output_dir.mkdir(exist_ok=True)

    prompt_path = output_dir / "prompt.jsonl"
    mk_sample_prompt(args.model, args.apps, prompt_path)

    code_path = output_dir / "sample.jsonl"
    sampling_params = dict(n=50, temperature=0.6, max_new_tokens=2048)
    save_json(sampling_params, output_dir / "sampling_params.json")
    vllm_chatcomplete(args.model, prompt_path, code_path, sampling_params)

    dataset_path = output_dir / "dataset.jsonl"
    evaluate(code_path, args.apps, dataset_path)

    train_path = output_dir / "train.jsonl"
    test_path = output_dir / "test.jsonl"
    min_test_path = output_dir / "min_test.jsonl"
    sort_and_split_dataset(
        dataset_path, train_path, test_path, min_test_path, sampling_params["n"]
    )
