import argparse

from codecritic.utils.json import load_jsonl, save_jsonl


if __name__ == "__main__":
    parser = argparse.ArgumentParser()
    parser.add_argument("--dataset", type=str)
    parser.add_argument("--w_reason", type=str)
    parser.add_argument("--wo_reason", type=str)
    args = parser.parse_args()

    ds = load_jsonl(args.dataset)
    w_reason, wo_reason = [], []
    for item in ds:
        question = item.pop("question")
        response = item.pop("response")

        msg1 = question[:2]
        msg2 = question + response[:1]

        w_reason.append({**item, "messages": msg2})
        wo_reason.append({**item, "messages": msg1})

    save_jsonl(wo_reason, args.wo_reason)
    save_jsonl(w_reason, args.w_reason)
