JUDGE_PROMPT = "Is the code correct (Yes/No)?"


def mk_critic_verify(answer=None):
    # answer: bool or none
    message = [{"role": "user", "content": JUDGE_PROMPT}]
    if answer is not None:
        response = "Yes" if answer else "No"
        message.append({"role": "assistant", "content": response})

    return message


def get_score_token_id(tokenizer, token_str="Yes"):
    score_tokens = tokenizer.encode(token_str, add_special_tokens=False)
    assert len(score_tokens) == 1
    return score_tokens[0]
