import re


codeblock_pattern = re.compile(r"```python(.+?)```", flags=re.DOTALL)
code_template = """```python
{}
```
"""


def extract_code(text: str):
    codes = [match.strip() for match in re.findall(codeblock_pattern, text)]
    if len(codes) > 0:
        code = "\n".join(codes)
        return code
    else:
        return ""