from rich.console import Console
from rich.panel import Panel
from rich.text import Text
import json
import sys


def display_messages(messages, console):
    for message in messages:
        role = message["role"]
        content = message["content"]
        text = Text(content, style="bold")
        panel = Panel(text, title=f"[{role.capitalize()}]")
        console.print(panel)


if __name__ == "__main__":
    json_string = sys.stdin.read()
    console = Console()
    messages = json.loads(json_string)
    display_messages(messages, console)

