# Additional Experiment:
# Is reasoning really work? Let's verify step by step.
from codecritic.data.code import extract_code, code_template

from codecritic.data.utils import SPLITTER, mk_message
from codecritic.data.verify import mk_critic_verify

COV_PROMPT = "Please verify your code step by step using Markdown code blocks. After each step, explain whether it's correct or not, and if not, explain the issue."

COV_EXAMPLE = """\
** Example RETURN FORMAT **

```python
def add_numbers(a, b):
    return a + b

result = add_numbers(5, '10')
```

1. **Code:**
```python
def add_numbers(a, b):
    return a + b
```
**Explanation:** Correct. This defines a function `add_numbers` that takes two arguments and returns their sum.

2. **Code:**
```python
result = add_numbers(5, '10')
```
**Explanation:** Incorrect. The second argument is a string (`'10'`), which will cause a TypeError when trying to add it to an integer.
"""

CORRECT_PROMPT = "Your code is correct."
INCORRECT_PROMPT = "Your code is incorrect."


def mk_cov_prompt(is_correct, splitter, mode):
    if mode == "train":
        anchor = CORRECT_PROMPT if is_correct else INCORRECT_PROMPT
    elif mode == "test":
        anchor = ""
    else:
         raise ValueError(f"Invalid mode: {mode}. Expected 'train' or 'test'.")

    turn1 = {"role": "user", "content": '\n'.join([anchor, COV_PROMPT, COV_EXAMPLE])}
    if splitter:
        turn2 = {
            "role": "assistant",
            "content": "Here's a step-by-step verification of the code." + SPLITTER,
        }
        return [turn1, turn2]
    else:
        return [turn1]


def convert_preference_to_vot_prompt(item, splitter, mode):
    message = item["messages"][0]["content"]
    chosen = item["chosen"]["content"]
    rejected = item["rejected"]["content"]

    chosen = code_template.format(extract_code(chosen))
    rejected = code_template.format(extract_code(rejected))

    messages1 = mk_message(message, chosen) + mk_cov_prompt(True, splitter, mode)
    messages2 = mk_message(message, rejected) + mk_cov_prompt(False, splitter, mode)
    return (
        {"messages": messages1, "eval_result": True, "problem_id": item["problem_id"]},
        {"messages": messages2, "eval_result": False, "problem_id": item["problem_id"]}
    )


def convert_sft_to_vot_prompt(item, splitter, mode):
    question = item["messages"][0]["content"]
    response = item["messages"][1]["content"]

    code = code_template.format(extract_code(response))
    messages = mk_message(question, code) + mk_cov_prompt(item["eval_result"], splitter, mode)
    return {"messages": messages, "eval_result": item["eval_result"], "problem_id": item["problem_id"]}


def convert_cov_to_cov_dataset(item, mode):
    item["messages"][2]["content"] = COV_PROMPT

    if mode == "train":
        item["messages"] += mk_critic_verify(item["eval_result"])
    return item
