import json


def mk_prompt(doc):
    prompt = "Write Python code to solve competitive programming problems in a markdown code block."

    starter_code = None if len(doc["starter_code"]) == 0 else doc["starter_code"]
    try:
        input_outpout = json.loads(doc["input_output"])
        fn_name = None if not input_outpout.get("fn_name") else input_outpout["fn_name"]
    except ValueError:
        fn_name = None
    prompt += "\nQUESTION:\n"
    prompt += doc["question"]
    if starter_code:
        prompt += starter_code
    if not fn_name:
        prompt += "\nUse Standard Input format"
    else:
        prompt += "\nUse Call-Based format"

    prompt += "\nPlease generate the code in a ```python markdown block, ensuring to include the closing ``` at the end."

    conversation = [{"role": "user", "content": prompt}]
    return conversation
