def mk_preference_dataset_info(dataset_name):
    return {
        dataset_name: {
            "file_name": f"{dataset_name}.json",
            "formatting": "sharegpt",
            "ranking": True,
            "columns": {
                "messages": "messages",
                "chosen": "chosen",
                "rejected": "rejected",
            },
            "tags": {
                "role_tag": "role",
                "content_tag": "content",
                "user_tag": "user",
                "assistant_tag": "assistant",
                "system_tag": "system",
            },
        }
    }


# see utils.extract_code
code_template = r"```python{}```"


def mk_preference_pair(instruction, chosen_code, rejected_code):
    return {
        "messages": [
            {"role": "user", "content": instruction},
        ],
        "chosen": {"role": "assistant", "content": code_template.format(chosen_code)},
        "rejected": {
            "role": "assistant",
            "content": code_template.format(rejected_code),
        },
    }


def mk_sft_dataset_info(dataset_name):
    return {
        dataset_name: {
            "file_name": f"{dataset_name}.json",
            "formatting": "sharegpt",
            "columns": {"messages": "messages"},
            "tags": {
                "role_tag": "role",
                "content_tag": "content",
                "user_tag": "user",
                "assistant_tag": "assistant",
                "system_tag": "system",
            },
        }
    }


# Note that the human and observation should appear in odd positions
# while llm should appear in even positions.
def mk_sft_item(messages):
    return {"messages": messages}


def mk_critic_qa(instruction, code):
    # Code should be enclosed in a markdown code block
    return [
        {"role": "user", "content": instruction},
        {"role": "assistant", "content": code},
    ]


def mk_critic_verify(answer=None):
    # answer: bool or none
    message = [{"role": "user", "content": "Is the code correct (Yes/No)?"}]
    if answer is not None:
        response = "Yes" if answer else "No"
        message.append({"role": "assistant", "content": response})

    return message
