from utils_vllm import vllm_chatcomplete, vllm_score
from utils import read_config
from transformers import AutoTokenizer


if __name__ == "__main__":
    cfg = read_config()
    vllm_chatcomplete(
        cfg["critic"]["model_path"],
        cfg["dataset"]["minimal_test_path"],
        cfg["critic"]["test"]["reason_result_path"],
        cfg["critic"]["test"]["sampling_params"]
    )

    tokenizer = AutoTokenizer.from_pretrained(cfg["model"])
    score_tokens = tokenizer.encode("Yes")
    assert len(score_tokens) == 1
    score_token = score_tokens[0]

    vllm_score(
        cfg["critic"]["model_path"],
        cfg["critic"]["test"]["reason_result_path"],
        cfg["critic"]["test"]["score_result_path"],
        score_token
    )