#!/bin/bash

set -x
test -d $1
test -f scripts/$2.ys

rm -rf $1/work_$2
mkdir $1/work_$2
cd $1/work_$2

touch .start



	expected_string=""
	expected="1"
	if [ "$1" = "yosys" ]; then
		expected_string="yosys -- Yosys Open SYnthesis Suite"
	elif [ "$1" = "yosys_help" ]; then
		expected_string="print the help message for the specified command"
	elif [ "$1" = "yosys_no_banner" ]; then
		expected_string="yosys -- Yosys Open SYnthesis Suite"
		expected="0"
	elif [ "$1" = "yosys_no_footer" ]; then
		expected_string="End of script. Logfile hash:"
		expected="0"
	elif [ "$1" = "yosys_quiet" ]; then
		expected_string="yosys"
		expected="0"
	elif [ "$1" = "yosys_headers" ]; then
		expected_string="yosys"
		expected="0"
	elif [ "$1" = "yosys_time" ]; then
		expected_string="\[00000.000000\]"
	elif [ "$1" = "yosys_detailed_timing" ]; then
		expected_string=" calls"
	elif [ "$1" = "yosys_log_file" ]; then
		expected_string="yosys -- Yosys Open SYnthesis Suite"
	elif [ "$1" = "yosys_log_file_lb_mode" ]; then
		expected_string="yosys -- Yosys Open SYnthesis Suite"
	elif [ "$1" = "yosys_write_des_to_file" ]; then
		expected_string="Generated by Yosys"
	elif [ "$1" = "yosys_backends" ]; then
		expected_string="Generated by Yosys"
	elif [ "$1" = "yosys_frontends" ]; then
		expected_string="Parsing \`../top.v' using frontend \`verilog'"
	elif [ "$1" = "yosys_command_list" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_help_for_command" ]; then
		expected_string="abc \[options\] \[selection\]"
	elif [ "$1" = "yosys_script" ]; then
		expected_string="Executing script file \`../run_script.ys'"
	elif [ "$1" = "yosys_tcl_script" ]; then
		expected_string="Run tcl script!"
	elif [ "$1" = "yosys_exec_command" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_enable_tracing" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_randomize_alloc_point_addr" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_abort" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_macro" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_header" ]; then
		expected_string=" Parsing \`../top.v' using frontend \`verilog'"
	elif [ "$1" = "yosys_regexp" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_regexp_w" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_regexp_e" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_dependencies" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_globally_en_log_mes" ]; then
		expected_string="abc"
	elif [ "$1" = "yosys_version" ]; then
		expected_string="Yosys "
	elif [ "$1" = "yosys_synth" ]; then
		expected_string="Running command \`synth'"
	fi

	../run_yosys.sh
	if [ "$1"! = "yosys_abort" ]; then
		if [ $? != 0 ] ; then
			echo FAIL > ${1}_${2}.status
			touch .stamp
			exit 0
		fi
	fi
	if grep "$expected_string" yosys.log; then
		if [ $expected = "1" ]; then
			echo PASS > ${1}_${2}.status
		else
			echo FAIL > ${1}_${2}.status
		fi
	else
		if [ $expected = "1" ]; then
			echo FAIL > ${1}_${2}.status
		else
			echo PASS > ${1}_${2}.status
		fi
	fi


touch .stamp
