
module top
(
// Closk & reset
input  wire         clk,
input  wire         rstn,

// PicoRV32 bus interface
input  wire         valid,
output wire         ready,
input  wire [31:0]  addr,
output wire [31:0]  rdata
);

// ============================================================================

localparam  MEM_SIZE_BITS   = 10; // In 32-bit words
localparam  MEM_SIZE        = 1 << MEM_SIZE_BITS;
localparam  MEM_ADDR_MASK   = 32'h0010_0000;

// ============================================================================

wire [MEM_SIZE_BITS-1:0]    mem_addr;
reg  [31:0]                 mem_data;
reg  [31:0]                 mem[0:MEM_SIZE];

initial begin
    mem['h0000] <= 32'h00000093;
    mem['h0001] <= 32'h00000193;
    mem['h0002] <= 32'h00000213;
    mem['h0003] <= 32'h00000293;
    mem['h0004] <= 32'h00000313;
    mem['h0005] <= 32'h00000393;
    mem['h0006] <= 32'h00000413;
    mem['h0007] <= 32'h00000493;
    mem['h0008] <= 32'h00000513;
    mem['h0009] <= 32'h00000593;
    mem['h000A] <= 32'h00000613;
    mem['h000B] <= 32'h00000693;
    mem['h000C] <= 32'h00000713;
    mem['h000D] <= 32'h00000793;
    mem['h000E] <= 32'h00000813;
    mem['h000F] <= 32'h00000893;
    mem['h0010] <= 32'h00000913;
    mem['h0011] <= 32'h00000993;
    mem['h0012] <= 32'h00000A13;
    mem['h0013] <= 32'h00000A93;
    mem['h0014] <= 32'h00000B13;
    mem['h0015] <= 32'h00000B93;
    mem['h0016] <= 32'h00000C13;
    mem['h0017] <= 32'h00000C93;
    mem['h0018] <= 32'h00000D13;
    mem['h0019] <= 32'h00000D93;
    mem['h001A] <= 32'h00000E13;
    mem['h001B] <= 32'h00000E93;
    mem['h001C] <= 32'h00000F13;
    mem['h001D] <= 32'h00000F93;
    mem['h001E] <= 32'h03000537;
    mem['h001F] <= 32'h00100593;
    mem['h0020] <= 32'h00B52023;
    mem['h0021] <= 32'h00000513;
    mem['h0022] <= 32'h00A52023;
    mem['h0023] <= 32'h00450513;
    mem['h0024] <= 32'hFE254CE3;
    mem['h0025] <= 32'h03000537;
    mem['h0026] <= 32'h00300593;
    mem['h0027] <= 32'h00B52023;
    mem['h0028] <= 32'h00001517;
    mem['h0029] <= 32'hB4050513;
    mem['h002A] <= 32'h00000593;
    mem['h002B] <= 32'h00000613;
    mem['h002C] <= 32'h00C5DC63;
    mem['h002D] <= 32'h00052683;
    mem['h002E] <= 32'h00D5A023;
    mem['h002F] <= 32'h00450513;
    mem['h0030] <= 32'h00458593;
    mem['h0031] <= 32'hFEC5C8E3;
    mem['h0032] <= 32'h03000537;
    mem['h0033] <= 32'h00700593;
    mem['h0034] <= 32'h00B52023;
    mem['h0035] <= 32'h00000513;
    mem['h0036] <= 32'h00000593;
    mem['h0037] <= 32'h00B55863;
    mem['h0038] <= 32'h00052023;
    mem['h0039] <= 32'h00450513;
    mem['h003A] <= 32'hFEB54CE3;
    mem['h003B] <= 32'h03000537;
    mem['h003C] <= 32'h00F00593;
    mem['h003D] <= 32'h00B52023;
    mem['h003E] <= 32'h015000EF;
    mem['h003F] <= 32'h0000006F;
    mem['h0040] <= 32'h020002B7;
    mem['h0041] <= 32'h12000313;
    mem['h0042] <= 32'h00629023;
    mem['h0043] <= 32'h000281A3;
    mem['h0044] <= 32'h02060863;
    mem['h0045] <= 32'h00800F13;
    mem['h0046] <= 32'h0FF67393;
    mem['h0047] <= 32'h0073DE93;
    mem['h0048] <= 32'h01D28023;
    mem['h0049] <= 32'h010EEE93;
    mem['h004A] <= 32'h01D28023;
    mem['h004B] <= 32'h00139393;
    mem['h004C] <= 32'h0FF3F393;
    mem['h004D] <= 32'hFFFF0F13;
    mem['h004E] <= 32'hFE0F12E3;
    mem['h004F] <= 32'h00628023;
    mem['h0050] <= 32'h04058663;
    mem['h0051] <= 32'h00800F13;
    mem['h0052] <= 32'h00054383;
    mem['h0053] <= 32'h0073DE93;
    mem['h0054] <= 32'h01D28023;
    mem['h0055] <= 32'h010EEE93;
    mem['h0056] <= 32'h01D28023;
    mem['h0057] <= 32'h0002CE83;
    mem['h0058] <= 32'h002EFE93;
    mem['h0059] <= 32'h001EDE93;
    mem['h005A] <= 32'h00139393;
    mem['h005B] <= 32'h01D3E3B3;
    mem['h005C] <= 32'h0FF3F393;
    mem['h005D] <= 32'hFFFF0F13;
    mem['h005E] <= 32'hFC0F1AE3;
    mem['h005F] <= 32'h00750023;
    mem['h0060] <= 32'h00150513;
    mem['h0061] <= 32'hFFF58593;
    mem['h0062] <= 32'hFB9FF06F;
    mem['h0063] <= 32'h08000313;
    mem['h0064] <= 32'h006281A3;
    mem['h0065] <= 32'h00008067;
    mem['h0066] <= 32'hFE010113;
    mem['h0067] <= 32'h00112E23;
    mem['h0068] <= 32'h00812C23;
    mem['h0069] <= 32'h02010413;
    mem['h006A] <= 32'h00050793;
    mem['h006B] <= 32'hFEF407A3;
    mem['h006C] <= 32'hFEF44703;
    mem['h006D] <= 32'h00A00793;
    mem['h006E] <= 32'h00F71663;
    mem['h006F] <= 32'h00D00513;
    mem['h0070] <= 32'hFD9FF0EF;
    mem['h0071] <= 32'h020007B7;
    mem['h0072] <= 32'h00878793;
    mem['h0073] <= 32'hFEF44703;
    mem['h0074] <= 32'h00E7A023;
    mem['h0075] <= 32'h00000013;
    mem['h0076] <= 32'h01C12083;
    mem['h0077] <= 32'h01812403;
    mem['h0078] <= 32'h02010113;
    mem['h0079] <= 32'h00008067;
    mem['h007A] <= 32'hFE010113;
    mem['h007B] <= 32'h00112E23;
    mem['h007C] <= 32'h00812C23;
    mem['h007D] <= 32'h02010413;
    mem['h007E] <= 32'hFEA42623;
    mem['h007F] <= 32'h01C0006F;
    mem['h0080] <= 32'hFEC42783;
    mem['h0081] <= 32'h00178713;
    mem['h0082] <= 32'hFEE42623;
    mem['h0083] <= 32'h0007C783;
    mem['h0084] <= 32'h00078513;
    mem['h0085] <= 32'hF85FF0EF;
    mem['h0086] <= 32'hFEC42783;
    mem['h0087] <= 32'h0007C783;
    mem['h0088] <= 32'hFE0790E3;
    mem['h0089] <= 32'h00000013;
    mem['h008A] <= 32'h01C12083;
    mem['h008B] <= 32'h01812403;
    mem['h008C] <= 32'h02010113;
    mem['h008D] <= 32'h00008067;
    mem['h008E] <= 32'hFD010113;
    mem['h008F] <= 32'h02112623;
    mem['h0090] <= 32'h02812423;
    mem['h0091] <= 32'h03010413;
    mem['h0092] <= 32'hFCA42E23;
    mem['h0093] <= 32'hFCB42C23;
    mem['h0094] <= 32'h00700793;
    mem['h0095] <= 32'hFEF42623;
    mem['h0096] <= 32'h06C0006F;
    mem['h0097] <= 32'hFEC42783;
    mem['h0098] <= 32'h00279793;
    mem['h0099] <= 32'hFDC42703;
    mem['h009A] <= 32'h00F757B3;
    mem['h009B] <= 32'h00F7F713;
    mem['h009C] <= 32'h001017B7;
    mem['h009D] <= 32'hA8078793;
    mem['h009E] <= 32'h00F707B3;
    mem['h009F] <= 32'h0007C783;
    mem['h00A0] <= 32'hFEF405A3;
    mem['h00A1] <= 32'hFEB44703;
    mem['h00A2] <= 32'h03000793;
    mem['h00A3] <= 32'h00F71863;
    mem['h00A4] <= 32'hFEC42703;
    mem['h00A5] <= 32'hFD842783;
    mem['h00A6] <= 32'h00F75E63;
    mem['h00A7] <= 32'hFEB44783;
    mem['h00A8] <= 32'h00078513;
    mem['h00A9] <= 32'hEF5FF0EF;
    mem['h00AA] <= 32'hFEC42783;
    mem['h00AB] <= 32'hFCF42C23;
    mem['h00AC] <= 32'h0080006F;
    mem['h00AD] <= 32'h00000013;
    mem['h00AE] <= 32'hFEC42783;
    mem['h00AF] <= 32'hFFF78793;
    mem['h00B0] <= 32'hFEF42623;
    mem['h00B1] <= 32'hFEC42783;
    mem['h00B2] <= 32'hF807DAE3;
    mem['h00B3] <= 32'h00000013;
    mem['h00B4] <= 32'h02C12083;
    mem['h00B5] <= 32'h02812403;
    mem['h00B6] <= 32'h03010113;
    mem['h00B7] <= 32'h00008067;
    mem['h00B8] <= 32'hFE010113;
    mem['h00B9] <= 32'h00112E23;
    mem['h00BA] <= 32'h00812C23;
    mem['h00BB] <= 32'h02010413;
    mem['h00BC] <= 32'hFEA42623;
    mem['h00BD] <= 32'hFEC42703;
    mem['h00BE] <= 32'h06300793;
    mem['h00BF] <= 32'h00E7FA63;
    mem['h00C0] <= 32'h001017B7;
    mem['h00C1] <= 32'hA9478513;
    mem['h00C2] <= 32'hEE1FF0EF;
    mem['h00C3] <= 32'h28C0006F;
    mem['h00C4] <= 32'hFEC42703;
    mem['h00C5] <= 32'h05900793;
    mem['h00C6] <= 32'h00E7FE63;
    mem['h00C7] <= 32'h03900513;
    mem['h00C8] <= 32'hE79FF0EF;
    mem['h00C9] <= 32'hFEC42783;
    mem['h00CA] <= 32'hFA678793;
    mem['h00CB] <= 32'hFEF42623;
    mem['h00CC] <= 32'h1200006F;
    mem['h00CD] <= 32'hFEC42703;
    mem['h00CE] <= 32'h04F00793;
    mem['h00CF] <= 32'h00E7FE63;
    mem['h00D0] <= 32'h03800513;
    mem['h00D1] <= 32'hE55FF0EF;
    mem['h00D2] <= 32'hFEC42783;
    mem['h00D3] <= 32'hFB078793;
    mem['h00D4] <= 32'hFEF42623;
    mem['h00D5] <= 32'h0FC0006F;
    mem['h00D6] <= 32'hFEC42703;
    mem['h00D7] <= 32'h04500793;
    mem['h00D8] <= 32'h00E7FE63;
    mem['h00D9] <= 32'h03700513;
    mem['h00DA] <= 32'hE31FF0EF;
    mem['h00DB] <= 32'hFEC42783;
    mem['h00DC] <= 32'hFBA78793;
    mem['h00DD] <= 32'hFEF42623;
    mem['h00DE] <= 32'h0D80006F;
    mem['h00DF] <= 32'hFEC42703;
    mem['h00E0] <= 32'h03B00793;
    mem['h00E1] <= 32'h00E7FE63;
    mem['h00E2] <= 32'h03600513;
    mem['h00E3] <= 32'hE0DFF0EF;
    mem['h00E4] <= 32'hFEC42783;
    mem['h00E5] <= 32'hFC478793;
    mem['h00E6] <= 32'hFEF42623;
    mem['h00E7] <= 32'h0B40006F;
    mem['h00E8] <= 32'hFEC42703;
    mem['h00E9] <= 32'h03100793;
    mem['h00EA] <= 32'h00E7FE63;
    mem['h00EB] <= 32'h03500513;
    mem['h00EC] <= 32'hDE9FF0EF;
    mem['h00ED] <= 32'hFEC42783;
    mem['h00EE] <= 32'hFCE78793;
    mem['h00EF] <= 32'hFEF42623;
    mem['h00F0] <= 32'h0900006F;
    mem['h00F1] <= 32'hFEC42703;
    mem['h00F2] <= 32'h02700793;
    mem['h00F3] <= 32'h00E7FE63;
    mem['h00F4] <= 32'h03400513;
    mem['h00F5] <= 32'hDC5FF0EF;
    mem['h00F6] <= 32'hFEC42783;
    mem['h00F7] <= 32'hFD878793;
    mem['h00F8] <= 32'hFEF42623;
    mem['h00F9] <= 32'h06C0006F;
    mem['h00FA] <= 32'hFEC42703;
    mem['h00FB] <= 32'h01D00793;
    mem['h00FC] <= 32'h00E7FE63;
    mem['h00FD] <= 32'h03300513;
    mem['h00FE] <= 32'hDA1FF0EF;
    mem['h00FF] <= 32'hFEC42783;
    mem['h0100] <= 32'hFE278793;
    mem['h0101] <= 32'hFEF42623;
    mem['h0102] <= 32'h0480006F;
    mem['h0103] <= 32'hFEC42703;
    mem['h0104] <= 32'h01300793;
    mem['h0105] <= 32'h00E7FE63;
    mem['h0106] <= 32'h03200513;
    mem['h0107] <= 32'hD7DFF0EF;
    mem['h0108] <= 32'hFEC42783;
    mem['h0109] <= 32'hFEC78793;
    mem['h010A] <= 32'hFEF42623;
    mem['h010B] <= 32'h0240006F;
    mem['h010C] <= 32'hFEC42703;
    mem['h010D] <= 32'h00900793;
    mem['h010E] <= 32'h00E7FC63;
    mem['h010F] <= 32'h03100513;
    mem['h0110] <= 32'hD59FF0EF;
    mem['h0111] <= 32'hFEC42783;
    mem['h0112] <= 32'hFF678793;
    mem['h0113] <= 32'hFEF42623;
    mem['h0114] <= 32'hFEC42703;
    mem['h0115] <= 32'h00800793;
    mem['h0116] <= 32'h00E7FE63;
    mem['h0117] <= 32'h03900513;
    mem['h0118] <= 32'hD39FF0EF;
    mem['h0119] <= 32'hFEC42783;
    mem['h011A] <= 32'hFF778793;
    mem['h011B] <= 32'hFEF42623;
    mem['h011C] <= 32'h1280006F;
    mem['h011D] <= 32'hFEC42703;
    mem['h011E] <= 32'h00700793;
    mem['h011F] <= 32'h00E7FE63;
    mem['h0120] <= 32'h03800513;
    mem['h0121] <= 32'hD15FF0EF;
    mem['h0122] <= 32'hFEC42783;
    mem['h0123] <= 32'hFF878793;
    mem['h0124] <= 32'hFEF42623;
    mem['h0125] <= 32'h1040006F;
    mem['h0126] <= 32'hFEC42703;
    mem['h0127] <= 32'h00600793;
    mem['h0128] <= 32'h00E7FE63;
    mem['h0129] <= 32'h03700513;
    mem['h012A] <= 32'hCF1FF0EF;
    mem['h012B] <= 32'hFEC42783;
    mem['h012C] <= 32'hFF978793;
    mem['h012D] <= 32'hFEF42623;
    mem['h012E] <= 32'h0E00006F;
    mem['h012F] <= 32'hFEC42703;
    mem['h0130] <= 32'h00500793;
    mem['h0131] <= 32'h00E7FE63;
    mem['h0132] <= 32'h03600513;
    mem['h0133] <= 32'hCCDFF0EF;
    mem['h0134] <= 32'hFEC42783;
    mem['h0135] <= 32'hFFA78793;
    mem['h0136] <= 32'hFEF42623;
    mem['h0137] <= 32'h0BC0006F;
    mem['h0138] <= 32'hFEC42703;
    mem['h0139] <= 32'h00400793;
    mem['h013A] <= 32'h00E7FE63;
    mem['h013B] <= 32'h03500513;
    mem['h013C] <= 32'hCA9FF0EF;
    mem['h013D] <= 32'hFEC42783;
    mem['h013E] <= 32'hFFB78793;
    mem['h013F] <= 32'hFEF42623;
    mem['h0140] <= 32'h0980006F;
    mem['h0141] <= 32'hFEC42703;
    mem['h0142] <= 32'h00300793;
    mem['h0143] <= 32'h00E7FE63;
    mem['h0144] <= 32'h03400513;
    mem['h0145] <= 32'hC85FF0EF;
    mem['h0146] <= 32'hFEC42783;
    mem['h0147] <= 32'hFFC78793;
    mem['h0148] <= 32'hFEF42623;
    mem['h0149] <= 32'h0740006F;
    mem['h014A] <= 32'hFEC42703;
    mem['h014B] <= 32'h00200793;
    mem['h014C] <= 32'h00E7FE63;
    mem['h014D] <= 32'h03300513;
    mem['h014E] <= 32'hC61FF0EF;
    mem['h014F] <= 32'hFEC42783;
    mem['h0150] <= 32'hFFD78793;
    mem['h0151] <= 32'hFEF42623;
    mem['h0152] <= 32'h0500006F;
    mem['h0153] <= 32'hFEC42703;
    mem['h0154] <= 32'h00100793;
    mem['h0155] <= 32'h00E7FE63;
    mem['h0156] <= 32'h03200513;
    mem['h0157] <= 32'hC3DFF0EF;
    mem['h0158] <= 32'hFEC42783;
    mem['h0159] <= 32'hFFE78793;
    mem['h015A] <= 32'hFEF42623;
    mem['h015B] <= 32'h02C0006F;
    mem['h015C] <= 32'hFEC42783;
    mem['h015D] <= 32'h00078E63;
    mem['h015E] <= 32'h03100513;
    mem['h015F] <= 32'hC1DFF0EF;
    mem['h0160] <= 32'hFEC42783;
    mem['h0161] <= 32'hFFF78793;
    mem['h0162] <= 32'hFEF42623;
    mem['h0163] <= 32'h00C0006F;
    mem['h0164] <= 32'h03000513;
    mem['h0165] <= 32'hC05FF0EF;
    mem['h0166] <= 32'h01C12083;
    mem['h0167] <= 32'h01812403;
    mem['h0168] <= 32'h02010113;
    mem['h0169] <= 32'h00008067;
    mem['h016A] <= 32'hFD010113;
    mem['h016B] <= 32'h02112623;
    mem['h016C] <= 32'h02812423;
    mem['h016D] <= 32'h03010413;
    mem['h016E] <= 32'hFCA42E23;
    mem['h016F] <= 32'hFFF00793;
    mem['h0170] <= 32'hFEF42623;
    mem['h0171] <= 32'hC00027F3;
    mem['h0172] <= 32'hFEF42423;
    mem['h0173] <= 32'h030007B7;
    mem['h0174] <= 32'hFFF00713;
    mem['h0175] <= 32'h00E7A023;
    mem['h0176] <= 32'hFDC42783;
    mem['h0177] <= 32'h08078A63;
    mem['h0178] <= 32'hFDC42503;
    mem['h0179] <= 32'hC05FF0EF;
    mem['h017A] <= 32'h0880006F;
    mem['h017B] <= 32'hC00027F3;
    mem['h017C] <= 32'hFEF42223;
    mem['h017D] <= 32'hFE442703;
    mem['h017E] <= 32'hFE842783;
    mem['h017F] <= 32'h40F707B3;
    mem['h0180] <= 32'hFEF42023;
    mem['h0181] <= 32'hFE042703;
    mem['h0182] <= 32'h00B727B7;
    mem['h0183] <= 32'hB0078793;
    mem['h0184] <= 32'h04E7F863;
    mem['h0185] <= 32'hFDC42783;
    mem['h0186] <= 32'h00078663;
    mem['h0187] <= 32'hFDC42503;
    mem['h0188] <= 32'hBC9FF0EF;
    mem['h0189] <= 32'hFE442783;
    mem['h018A] <= 32'hFEF42423;
    mem['h018B] <= 32'h030007B7;
    mem['h018C] <= 32'h0007A783;
    mem['h018D] <= 32'h00179713;
    mem['h018E] <= 32'h030007B7;
    mem['h018F] <= 32'h0007A783;
    mem['h0190] <= 32'h0017D793;
    mem['h0191] <= 32'h0017F793;
    mem['h0192] <= 32'h0017B793;
    mem['h0193] <= 32'h0FF7F793;
    mem['h0194] <= 32'h00078693;
    mem['h0195] <= 32'h030007B7;
    mem['h0196] <= 32'h00D76733;
    mem['h0197] <= 32'h00E7A023;
    mem['h0198] <= 32'h020007B7;
    mem['h0199] <= 32'h00878793;
    mem['h019A] <= 32'h0007A783;
    mem['h019B] <= 32'hFEF42623;
    mem['h019C] <= 32'hFEC42703;
    mem['h019D] <= 32'hFFF00793;
    mem['h019E] <= 32'hF6F70AE3;
    mem['h019F] <= 32'h030007B7;
    mem['h01A0] <= 32'h0007A023;
    mem['h01A1] <= 32'hFEC42783;
    mem['h01A2] <= 32'h0FF7F793;
    mem['h01A3] <= 32'h00078513;
    mem['h01A4] <= 32'h02C12083;
    mem['h01A5] <= 32'h02812403;
    mem['h01A6] <= 32'h03010113;
    mem['h01A7] <= 32'h00008067;
    mem['h01A8] <= 32'hFF010113;
    mem['h01A9] <= 32'h00112623;
    mem['h01AA] <= 32'h00812423;
    mem['h01AB] <= 32'h01010413;
    mem['h01AC] <= 32'h00000513;
    mem['h01AD] <= 32'hEF5FF0EF;
    mem['h01AE] <= 32'h00050793;
    mem['h01AF] <= 32'h00078513;
    mem['h01B0] <= 32'h00C12083;
    mem['h01B1] <= 32'h00812403;
    mem['h01B2] <= 32'h01010113;
    mem['h01B3] <= 32'h00008067;
    mem['h01B4] <= 32'hEB010113;
    mem['h01B5] <= 32'h14112623;
    mem['h01B6] <= 32'h14812423;
    mem['h01B7] <= 32'h15010413;
    mem['h01B8] <= 32'h00050793;
    mem['h01B9] <= 32'hEAB42C23;
    mem['h01BA] <= 32'hEAF40FA3;
    mem['h01BB] <= 32'hEC040793;
    mem['h01BC] <= 32'hFCF42A23;
    mem['h01BD] <= 32'h12B9B7B7;
    mem['h01BE] <= 32'h0A178793;
    mem['h01BF] <= 32'hFEF42623;
    mem['h01C0] <= 32'hC00027F3;
    mem['h01C1] <= 32'hFCF42823;
    mem['h01C2] <= 32'hC02027F3;
    mem['h01C3] <= 32'hFCF42623;
    mem['h01C4] <= 32'hFE042423;
    mem['h01C5] <= 32'h1200006F;
    mem['h01C6] <= 32'hFE042223;
    mem['h01C7] <= 32'h0640006F;
    mem['h01C8] <= 32'hFEC42783;
    mem['h01C9] <= 32'h00D79793;
    mem['h01CA] <= 32'hFEC42703;
    mem['h01CB] <= 32'h00F747B3;
    mem['h01CC] <= 32'hFEF42623;
    mem['h01CD] <= 32'hFEC42783;
    mem['h01CE] <= 32'h0117D793;
    mem['h01CF] <= 32'hFEC42703;
    mem['h01D0] <= 32'h00F747B3;
    mem['h01D1] <= 32'hFEF42623;
    mem['h01D2] <= 32'hFEC42783;
    mem['h01D3] <= 32'h00579793;
    mem['h01D4] <= 32'hFEC42703;
    mem['h01D5] <= 32'h00F747B3;
    mem['h01D6] <= 32'hFEF42623;
    mem['h01D7] <= 32'hFEC42783;
    mem['h01D8] <= 32'h0FF7F713;
    mem['h01D9] <= 32'hFE442783;
    mem['h01DA] <= 32'hFF040693;
    mem['h01DB] <= 32'h00F687B3;
    mem['h01DC] <= 32'hECE78823;
    mem['h01DD] <= 32'hFE442783;
    mem['h01DE] <= 32'h00178793;
    mem['h01DF] <= 32'hFEF42223;
    mem['h01E0] <= 32'hFE442703;
    mem['h01E1] <= 32'h0FF00793;
    mem['h01E2] <= 32'hF8E7DCE3;
    mem['h01E3] <= 32'hFE042023;
    mem['h01E4] <= 32'hFC042E23;
    mem['h01E5] <= 32'h0440006F;
    mem['h01E6] <= 32'hFE042783;
    mem['h01E7] <= 32'hFF040713;
    mem['h01E8] <= 32'h00F707B3;
    mem['h01E9] <= 32'hED07C783;
    mem['h01EA] <= 32'h02078263;
    mem['h01EB] <= 32'hFDC42783;
    mem['h01EC] <= 32'h00178713;
    mem['h01ED] <= 32'hFCE42E23;
    mem['h01EE] <= 32'hFE042703;
    mem['h01EF] <= 32'h0FF77713;
    mem['h01F0] <= 32'hFF040693;
    mem['h01F1] <= 32'h00F687B3;
    mem['h01F2] <= 32'hECE78823;
    mem['h01F3] <= 32'hFE042783;
    mem['h01F4] <= 32'h00178793;
    mem['h01F5] <= 32'hFEF42023;
    mem['h01F6] <= 32'hFE042703;
    mem['h01F7] <= 32'h0FF00793;
    mem['h01F8] <= 32'hFAE7DCE3;
    mem['h01F9] <= 32'hFC042C23;
    mem['h01FA] <= 32'hFC042023;
    mem['h01FB] <= 32'h0300006F;
    mem['h01FC] <= 32'hFD842783;
    mem['h01FD] <= 32'h00279793;
    mem['h01FE] <= 32'hFD442703;
    mem['h01FF] <= 32'h00F707B3;
    mem['h0200] <= 32'h0007A783;
    mem['h0201] <= 32'hFEC42703;
    mem['h0202] <= 32'h00F747B3;
    mem['h0203] <= 32'hFEF42623;
    mem['h0204] <= 32'hFD842783;
    mem['h0205] <= 32'h00178793;
    mem['h0206] <= 32'hFCF42C23;
    mem['h0207] <= 32'hFD842703;
    mem['h0208] <= 32'h03F00793;
    mem['h0209] <= 32'hFCE7D6E3;
    mem['h020A] <= 32'hFE842783;
    mem['h020B] <= 32'h00178793;
    mem['h020C] <= 32'hFEF42423;
    mem['h020D] <= 32'hFE842703;
    mem['h020E] <= 32'h01300793;
    mem['h020F] <= 32'hECE7DEE3;
    mem['h0210] <= 32'hC00027F3;
    mem['h0211] <= 32'hFCF42423;
    mem['h0212] <= 32'hC02027F3;
    mem['h0213] <= 32'hFCF42223;
    mem['h0214] <= 32'hEBF44783;
    mem['h0215] <= 32'h06078E63;
    mem['h0216] <= 32'h001017B7;
    mem['h0217] <= 32'hA9C78513;
    mem['h0218] <= 32'h989FF0EF;
    mem['h0219] <= 32'hFC842703;
    mem['h021A] <= 32'hFD042783;
    mem['h021B] <= 32'h40F707B3;
    mem['h021C] <= 32'h00800593;
    mem['h021D] <= 32'h00078513;
    mem['h021E] <= 32'h9C1FF0EF;
    mem['h021F] <= 32'h00A00513;
    mem['h0220] <= 32'h919FF0EF;
    mem['h0221] <= 32'h001017B7;
    mem['h0222] <= 32'hAA878513;
    mem['h0223] <= 32'h95DFF0EF;
    mem['h0224] <= 32'hFC442703;
    mem['h0225] <= 32'hFCC42783;
    mem['h0226] <= 32'h40F707B3;
    mem['h0227] <= 32'h00800593;
    mem['h0228] <= 32'h00078513;
    mem['h0229] <= 32'h995FF0EF;
    mem['h022A] <= 32'h00A00513;
    mem['h022B] <= 32'h8EDFF0EF;
    mem['h022C] <= 32'h001017B7;
    mem['h022D] <= 32'hAB478513;
    mem['h022E] <= 32'h931FF0EF;
    mem['h022F] <= 32'h00800593;
    mem['h0230] <= 32'hFEC42503;
    mem['h0231] <= 32'h975FF0EF;
    mem['h0232] <= 32'h00A00513;
    mem['h0233] <= 32'h8CDFF0EF;
    mem['h0234] <= 32'hEB842783;
    mem['h0235] <= 32'h00078C63;
    mem['h0236] <= 32'hFC442703;
    mem['h0237] <= 32'hFCC42783;
    mem['h0238] <= 32'h40F70733;
    mem['h0239] <= 32'hEB842783;
    mem['h023A] <= 32'h00E7A023;
    mem['h023B] <= 32'hFC842703;
    mem['h023C] <= 32'hFD042783;
    mem['h023D] <= 32'h40F707B3;
    mem['h023E] <= 32'h00078513;
    mem['h023F] <= 32'h14C12083;
    mem['h0240] <= 32'h14812403;
    mem['h0241] <= 32'h15010113;
    mem['h0242] <= 32'h00008067;
    mem['h0243] <= 32'hFE010113;
    mem['h0244] <= 32'h00112E23;
    mem['h0245] <= 32'h00812C23;
    mem['h0246] <= 32'h02010413;
    mem['h0247] <= 32'h030007B7;
    mem['h0248] <= 32'h01F00713;
    mem['h0249] <= 32'h00E7A023;
    mem['h024A] <= 32'h020007B7;
    mem['h024B] <= 32'h00478793;
    mem['h024C] <= 32'h0D900713;
    mem['h024D] <= 32'h00E7A023;
    mem['h024E] <= 32'h001017B7;
    mem['h024F] <= 32'hAC078513;
    mem['h0250] <= 32'h8A9FF0EF;
    mem['h0251] <= 32'h030007B7;
    mem['h0252] <= 32'h03F00713;
    mem['h0253] <= 32'h00E7A023;
    mem['h0254] <= 32'h030007B7;
    mem['h0255] <= 32'h07F00713;
    mem['h0256] <= 32'h00E7A023;
    mem['h0257] <= 32'h00000013;
    mem['h0258] <= 32'h001017B7;
    mem['h0259] <= 32'hACC78513;
    mem['h025A] <= 32'hC41FF0EF;
    mem['h025B] <= 32'h00050793;
    mem['h025C] <= 32'h00078713;
    mem['h025D] <= 32'h00D00793;
    mem['h025E] <= 32'hFEF714E3;
    mem['h025F] <= 32'h001017B7;
    mem['h0260] <= 32'hAE878513;
    mem['h0261] <= 32'h865FF0EF;
    mem['h0262] <= 32'h001017B7;
    mem['h0263] <= 32'hAEC78513;
    mem['h0264] <= 32'h859FF0EF;
    mem['h0265] <= 32'h001017B7;
    mem['h0266] <= 32'hB1478513;
    mem['h0267] <= 32'h84DFF0EF;
    mem['h0268] <= 32'h001017B7;
    mem['h0269] <= 32'hB3C78513;
    mem['h026A] <= 32'h841FF0EF;
    mem['h026B] <= 32'h001017B7;
    mem['h026C] <= 32'hB6078513;
    mem['h026D] <= 32'h835FF0EF;
    mem['h026E] <= 32'h001017B7;
    mem['h026F] <= 32'hB8878513;
    mem['h0270] <= 32'h829FF0EF;
    mem['h0271] <= 32'h001017B7;
    mem['h0272] <= 32'hAE878513;
    mem['h0273] <= 32'h81DFF0EF;
    mem['h0274] <= 32'h001017B7;
    mem['h0275] <= 32'hAE878513;
    mem['h0276] <= 32'h811FF0EF;
    mem['h0277] <= 32'h001017B7;
    mem['h0278] <= 32'hBB078513;
    mem['h0279] <= 32'h805FF0EF;
    mem['h027A] <= 32'h001017B7;
    mem['h027B] <= 32'hAE878513;
    mem['h027C] <= 32'hFF8FF0EF;
    mem['h027D] <= 32'h00A00793;
    mem['h027E] <= 32'hFEF42623;
    mem['h027F] <= 32'h0780006F;
    mem['h0280] <= 32'h001017B7;
    mem['h0281] <= 32'hBD478513;
    mem['h0282] <= 32'hFE0FF0EF;
    mem['h0283] <= 32'hC95FF0EF;
    mem['h0284] <= 32'h00050793;
    mem['h0285] <= 32'hFEF405A3;
    mem['h0286] <= 32'hFEB44703;
    mem['h0287] <= 32'h02000793;
    mem['h0288] <= 32'h00E7FE63;
    mem['h0289] <= 32'hFEB44703;
    mem['h028A] <= 32'h07E00793;
    mem['h028B] <= 32'h00E7E863;
    mem['h028C] <= 32'hFEB44783;
    mem['h028D] <= 32'h00078513;
    mem['h028E] <= 32'hF60FF0EF;
    mem['h028F] <= 32'h001017B7;
    mem['h0290] <= 32'hAE878513;
    mem['h0291] <= 32'hFA4FF0EF;
    mem['h0292] <= 32'hFEB44703;
    mem['h0293] <= 32'h03900793;
    mem['h0294] <= 32'h00F71C63;
    mem['h0295] <= 32'h00000593;
    mem['h0296] <= 32'h00100513;
    mem['h0297] <= 32'hC75FF0EF;
    mem['h0298] <= 32'h00000013;
    mem['h0299] <= 32'h0180006F;
    mem['h029A] <= 32'hFEC42783;
    mem['h029B] <= 32'hFFF78793;
    mem['h029C] <= 32'hFEF42623;
    mem['h029D] <= 32'hFEC42783;
    mem['h029E] <= 32'hF8F044E3;
    mem['h029F] <= 32'hF49FF06F;
    mem['h02A0] <= 32'h33323130;
    mem['h02A1] <= 32'h37363534;
    mem['h02A2] <= 32'h62613938;
    mem['h02A3] <= 32'h66656463;
    mem['h02A4] <= 32'h00000000;
    mem['h02A5] <= 32'h30313D3E;
    mem['h02A6] <= 32'h00000030;
    mem['h02A7] <= 32'h6C637943;
    mem['h02A8] <= 32'h203A7365;
    mem['h02A9] <= 32'h00007830;
    mem['h02AA] <= 32'h74736E49;
    mem['h02AB] <= 32'h203A736E;
    mem['h02AC] <= 32'h00007830;
    mem['h02AD] <= 32'h736B6843;
    mem['h02AE] <= 32'h203A6D75;
    mem['h02AF] <= 32'h00007830;
    mem['h02B0] <= 32'h746F6F42;
    mem['h02B1] <= 32'h2E676E69;
    mem['h02B2] <= 32'h00000A2E;
    mem['h02B3] <= 32'h73657250;
    mem['h02B4] <= 32'h4E452073;
    mem['h02B5] <= 32'h20524554;
    mem['h02B6] <= 32'h63206F74;
    mem['h02B7] <= 32'h69746E6F;
    mem['h02B8] <= 32'h2E65756E;
    mem['h02B9] <= 32'h00000A2E;
    mem['h02BA] <= 32'h0000000A;
    mem['h02BB] <= 32'h5F5F2020;
    mem['h02BC] <= 32'h20205F5F;
    mem['h02BD] <= 32'h2020205F;
    mem['h02BE] <= 32'h20202020;
    mem['h02BF] <= 32'h5F202020;
    mem['h02C0] <= 32'h205F5F5F;
    mem['h02C1] <= 32'h20202020;
    mem['h02C2] <= 32'h20202020;
    mem['h02C3] <= 32'h5F5F5F5F;
    mem['h02C4] <= 32'h0000000A;
    mem['h02C5] <= 32'h20207C20;
    mem['h02C6] <= 32'h285C205F;
    mem['h02C7] <= 32'h5F20295F;
    mem['h02C8] <= 32'h5F205F5F;
    mem['h02C9] <= 32'h202F5F5F;
    mem['h02CA] <= 32'h7C5F5F5F;
    mem['h02CB] <= 32'h5F5F2020;
    mem['h02CC] <= 32'h2F20205F;
    mem['h02CD] <= 32'h5F5F5F20;
    mem['h02CE] <= 32'h00000A7C;
    mem['h02CF] <= 32'h7C207C20;
    mem['h02D0] <= 32'h7C20295F;
    mem['h02D1] <= 32'h202F7C20;
    mem['h02D2] <= 32'h202F5F5F;
    mem['h02D3] <= 32'h5F5C205F;
    mem['h02D4] <= 32'h5C205F5F;
    mem['h02D5] <= 32'h5F202F20;
    mem['h02D6] <= 32'h207C5C20;
    mem['h02D7] <= 32'h00000A7C;
    mem['h02D8] <= 32'h20207C20;
    mem['h02D9] <= 32'h7C2F5F5F;
    mem['h02DA] <= 32'h28207C20;
    mem['h02DB] <= 32'h28207C5F;
    mem['h02DC] <= 32'h7C20295F;
    mem['h02DD] <= 32'h20295F5F;
    mem['h02DE] <= 32'h5F28207C;
    mem['h02DF] <= 32'h207C2029;
    mem['h02E0] <= 32'h5F5F5F7C;
    mem['h02E1] <= 32'h0000000A;
    mem['h02E2] <= 32'h7C5F7C20;
    mem['h02E3] <= 32'h7C202020;
    mem['h02E4] <= 32'h5F5C7C5F;
    mem['h02E5] <= 32'h5F5C5F5F;
    mem['h02E6] <= 32'h5F2F5F5F;
    mem['h02E7] <= 32'h2F5F5F5F;
    mem['h02E8] <= 32'h5F5F5C20;
    mem['h02E9] <= 32'h5C202F5F;
    mem['h02EA] <= 32'h5F5F5F5F;
    mem['h02EB] <= 32'h00000A7C;
    mem['h02EC] <= 32'h5B202020;
    mem['h02ED] <= 32'h52205D39;
    mem['h02EE] <= 32'h73206E75;
    mem['h02EF] <= 32'h6C706D69;
    mem['h02F0] <= 32'h69747369;
    mem['h02F1] <= 32'h65622063;
    mem['h02F2] <= 32'h6D68636E;
    mem['h02F3] <= 32'h0A6B7261;
    mem['h02F4] <= 32'h00000000;
    mem['h02F5] <= 32'h6D6D6F43;
    mem['h02F6] <= 32'h3E646E61;
    mem['h02F7] <= 32'h00000020;

end

always @(posedge clk)
    mem_data <= mem[mem_addr];

// ============================================================================

reg o_ready;

always @(posedge clk or negedge rstn)
    if (!rstn)  o_ready <= 1'd0;
    else        o_ready <= valid && ((addr & MEM_ADDR_MASK) != 0);

// Output connectins
assign ready    = o_ready;
assign rdata    = mem_data;
assign mem_addr = addr[MEM_SIZE_BITS+1:2];

endmodule
