// File: test_deflate_bench.v
// Generated by MyHDL 0.10
// Date: Sun Jan  6 10:46:55 2019


`timescale 1ns/10ps

module test_deflate_bench (
    i_clk,
    o_led,
    led0_g,
    led1_b,
    led2_r
);


input i_clk;
output [3:0] o_led;
reg [3:0] o_led;
output led0_g;
reg led0_g;
output led1_b;
reg led1_b;
output led2_r;
reg led2_r;

reg [23:0] o_iprogress;
reg [23:0] resultlen;
reg reset;
reg [23:0] o_oprogress;
reg o_done;
reg [7:0] o_byte;
reg [23:0] i_waddr;
reg [23:0] i_raddr;
reg [2:0] i_mode;
reg [7:0] i_data;
reg [21:0] scounter;
reg [15:0] counter;
reg [4:0] tstate;
reg [14:0] tbi;
reg wtick;
reg [5:0] resume;
reg [7:0] copy;
reg [18:0] deflate0_wleaf;
reg [9:0] deflate0_step;
reg deflate0_static;
reg [4:0] deflate0_state;
reg [8:0] deflate0_spread_i;
reg [9:0] deflate0_spread;
reg [18:0] deflate0_rleaf;
reg [14:0] deflate0_reverse;
reg [1:0] deflate0_prev_method;
reg [3:0] deflate0_outcarrybits;
reg [8:0] deflate0_outcarry;
reg [7:0] deflate0_orbyte;
reg [12:0] deflate0_oraddr;
reg [23:0] deflate0_old_di;
reg [12:0] deflate0_offset;
reg [7:0] deflate0_obyte;
reg [7:0] deflate0_ob1;
reg [12:0] deflate0_oaddr;
reg [8:0] deflate0_numLiterals;
reg [5:0] deflate0_numDistance;
reg [8:0] deflate0_numCodeLength;
reg deflate0_nb;
reg [3:0] deflate0_more;
reg [3:0] deflate0_mlength;
reg [4:0] deflate0_minBits;
reg [2:0] deflate0_method;
reg [4:0] deflate0_maxBits;
reg [14:0] deflate0_lwaddr;
reg [14:0] deflate0_lraddr;
reg [12:0] deflate0_length;
reg [18:0] deflate0_leaf;
reg [14:0] deflate0_lastToken;
reg [15:0] deflate0_ladler1;
reg [23:0] deflate0_isize;
reg [9:0] deflate0_instantMaxBit;
reg [14:0] deflate0_instantMask;
reg [8:0] deflate0_howOften;
reg deflate0_flush;
reg deflate0_first_block;
reg deflate0_final;
reg deflate0_filled;
reg [3:0] deflate0_fcount;
reg [18:0] deflate0_dwleaf;
reg [18:0] deflate0_drleaf;
reg [2:0] deflate0_doo;
reg deflate0_do_init;
reg deflate0_do_compress;
reg [23:0] deflate0_do;
reg [14:0] deflate0_dlwaddr;
reg [14:0] deflate0_dlraddr;
reg [9:0] deflate0_dlength;
reg [2:0] deflate0_dio;
reg [23:0] deflate0_di;
reg [4:0] deflate0_d_maxBits;
reg [9:0] deflate0_d_instantMaxBit;
reg [14:0] deflate0_d_instantMask;
reg [8:0] deflate0_cur_static;
reg signed [24:0] deflate0_cur_search;
reg [4:0] deflate0_cur_next;
reg [23:0] deflate0_cur_i;
reg signed [9:0] deflate0_cur_dist;
reg [23:0] deflate0_cur_cstatic;
reg [15:0] deflate0_cur_HF1;
reg [7:0] deflate0_copy2;
reg [7:0] deflate0_copy1;
reg [14:0] deflate0_code;
reg [3:0] deflate0_bits;
reg [8:0] deflate0_b_numCodeLength;
reg [7:0] deflate0_b9;
reg [7:0] deflate0_b8;
reg [7:0] deflate0_b7;
reg [7:0] deflate0_b6;
reg [7:0] deflate0_b5;
wire [31:0] deflate0_b41;
reg [7:0] deflate0_b4;
reg [7:0] deflate0_b3;
reg [7:0] deflate0_b2;
wire [39:0] deflate0_b15;
wire [79:0] deflate0_b110;
reg [7:0] deflate0_b10;
reg [7:0] deflate0_b1;
reg [15:0] deflate0_adler2;
reg [15:0] deflate0_adler1;
reg deflate0_cwindow;
reg [7:0] deflate0_oram [0:8192-1];
reg [15:0] deflate0_nextCode [0:16-1];
reg deflate0_leaves [0:1-1];
reg [7:0] deflate0_iram [0:512-1];
reg [3:0] deflate0_distanceLength [0:32-1];
reg deflate0_d_leaves [0:1-1];
reg [3:0] deflate0_codeLength [0:320-1];
reg [8:0] deflate0_bitLengthCount [0:16-1];
wire deflate0_smatch [0:1-1];

assign deflate0_b41[32-1:24] = deflate0_b4;
assign deflate0_b41[24-1:16] = deflate0_b3;
assign deflate0_b41[16-1:8] = deflate0_b2;
assign deflate0_b41[8-1:0] = deflate0_b1;
assign deflate0_b15[40-1:32] = deflate0_b1;
assign deflate0_b15[32-1:24] = deflate0_b2;
assign deflate0_b15[24-1:16] = deflate0_b3;
assign deflate0_b15[16-1:8] = deflate0_b4;
assign deflate0_b15[8-1:0] = deflate0_b5;
assign deflate0_b110[80-1:72] = deflate0_b1;
assign deflate0_b110[72-1:64] = deflate0_b2;
assign deflate0_b110[64-1:56] = deflate0_b3;
assign deflate0_b110[56-1:48] = deflate0_b4;
assign deflate0_b110[48-1:40] = deflate0_b5;
assign deflate0_b110[40-1:32] = deflate0_b6;
assign deflate0_b110[32-1:24] = deflate0_b7;
assign deflate0_b110[24-1:16] = deflate0_b8;
assign deflate0_b110[16-1:8] = deflate0_b9;
assign deflate0_b110[8-1:0] = deflate0_b10;

task MYHDL3_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL82_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

function integer MYHDL4_get4;
    input boffset;
    input width;
begin: MYHDL83_RETURN
    MYHDL4_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL5_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL84_RETURN
    MYHDL5_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

task MYHDL6_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL85_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

task MYHDL7_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL86_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

function integer MYHDL8_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL87_RETURN
    MYHDL8_get4 = ($signed($signed({1'b0, deflate0_b41}) >>> ($signed({1'b0, deflate0_dio}) + boffset)) & ((1 << width) - 1));
end
endfunction

task MYHDL9_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL88_RETURN
    nshift = $signed(($signed({1'b0, deflate0_dio}) + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= (($signed({1'b0, deflate0_dio}) + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

task MYHDL10_put;
    input d;
    integer d;
    input width;
    integer width;
    reg pshift;
    integer carry;
    integer doo_next;
begin: MYHDL89_RETURN
    deflate0_obyte <= ((deflate0_ob1 | (d << deflate0_doo)) & 255);
    deflate0_oaddr <= deflate0_do;
    pshift = ((deflate0_doo + width) > 8);
    if (pshift) begin
        carry = ($signed({1'b0, width}) - (8 - $signed({1'b0, deflate0_doo})));
        deflate0_ob1 <= $signed($signed({1'b0, d}) >>> ($signed({1'b0, width}) - carry));
    end
    else begin
        deflate0_ob1 <= (deflate0_ob1 | (d << deflate0_doo));
    end
    deflate0_do <= (deflate0_do + pshift);
    o_oprogress <= (deflate0_do + pshift);
    doo_next = ((deflate0_doo + width) & 7);
    if ((doo_next == 0)) begin
        deflate0_flush <= 1'b1;
    end
    deflate0_doo <= doo_next;
end
endtask

task MYHDL11_do_flush;
begin: MYHDL90_RETURN
    deflate0_flush <= 1'b0;
    deflate0_ob1 <= 0;
    o_oprogress <= (deflate0_do + 1);
    deflate0_do <= (deflate0_do + 1);
end
endtask

task MYHDL12_put;
    input d;
    integer d;
    input [4-1:0] width;
    reg pshift;
    integer carry;
    integer doo_next;
begin: MYHDL91_RETURN
    deflate0_obyte <= (($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo}))) & 255);
    deflate0_oaddr <= deflate0_do;
    pshift = ((deflate0_doo + width) > 8);
    if (pshift) begin
        carry = ($signed({1'b0, width}) - (8 - $signed({1'b0, deflate0_doo})));
        deflate0_ob1 <= $signed(d >>> ($signed({1'b0, width}) - carry));
    end
    else begin
        deflate0_ob1 <= ($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo})));
    end
    deflate0_do <= (deflate0_do + pshift);
    o_oprogress <= (deflate0_do + pshift);
    doo_next = ((deflate0_doo + width) & 7);
    if ((doo_next == 0)) begin
        deflate0_flush <= 1'b1;
    end
    deflate0_doo <= doo_next;
end
endtask

task MYHDL13_do_flush;
begin: MYHDL92_RETURN
    deflate0_flush <= 1'b0;
    deflate0_ob1 <= 0;
    o_oprogress <= (deflate0_do + 1);
    deflate0_do <= (deflate0_do + 1);
end
endtask

task MYHDL14_put;
    input d;
    integer d;
    input [4-1:0] width;
    reg pshift;
    integer carry;
    integer doo_next;
begin: MYHDL93_RETURN
    deflate0_obyte <= (($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo}))) & 255);
    deflate0_oaddr <= deflate0_do;
    pshift = ((deflate0_doo + width) > 8);
    if (pshift) begin
        carry = ($signed({1'b0, width}) - (8 - $signed({1'b0, deflate0_doo})));
        deflate0_ob1 <= $signed(d >>> ($signed({1'b0, width}) - carry));
    end
    else begin
        deflate0_ob1 <= ($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo})));
    end
    deflate0_do <= (deflate0_do + pshift);
    o_oprogress <= (deflate0_do + pshift);
    doo_next = ((deflate0_doo + width) & 7);
    if ((doo_next == 0)) begin
        deflate0_flush <= 1'b1;
    end
    deflate0_doo <= doo_next;
end
endtask

task MYHDL15_put;
    input [9-1:0] d;
    input [4-1:0] width;
    reg pshift;
    integer carry;
    integer doo_next;
begin: MYHDL94_RETURN
    deflate0_obyte <= ((deflate0_ob1 | (d << deflate0_doo)) & 255);
    deflate0_oaddr <= deflate0_do;
    pshift = ((deflate0_doo + width) > 8);
    if (pshift) begin
        carry = ($signed({1'b0, width}) - (8 - $signed({1'b0, deflate0_doo})));
        deflate0_ob1 <= $signed($signed({1'b0, d}) >>> ($signed({1'b0, width}) - carry));
    end
    else begin
        deflate0_ob1 <= (deflate0_ob1 | (d << deflate0_doo));
    end
    deflate0_do <= (deflate0_do + pshift);
    o_oprogress <= (deflate0_do + pshift);
    doo_next = ((deflate0_doo + width) & 7);
    if ((doo_next == 0)) begin
        deflate0_flush <= 1'b1;
    end
    deflate0_doo <= doo_next;
end
endtask

function integer MYHDL16_rev_bits;
    input [24-1:0] b;
    input nb;
    integer nb;
    integer r;
begin: MYHDL95_RETURN
    r = (((((((((((((((((b >>> 14) & 1) << 0) | (((b >>> 13) & 1) << 1)) | (((b >>> 12) & 1) << 2)) | (((b >>> 11) & 1) << 3)) | (((b >>> 10) & 1) << 4)) | (((b >>> 9) & 1) << 5)) | (((b >>> 8) & 1) << 6)) | (((b >>> 7) & 1) << 7)) | (((b >>> 6) & 1) << 8)) | (((b >>> 5) & 1) << 9)) | (((b >>> 4) & 1) << 10)) | (((b >>> 3) & 1) << 11)) | (((b >>> 2) & 1) << 12)) | (((b >>> 1) & 1) << 13)) | (((b >>> 0) & 1) << 14));
    r = r >>> (15 - $signed({1'b0, nb}));
    MYHDL16_rev_bits = r;
end
endfunction

task MYHDL17_put;
    input d;
    integer d;
    input width;
    integer width;
    reg pshift;
    integer carry;
    integer doo_next;
begin: MYHDL96_RETURN
    deflate0_obyte <= (($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo}))) & 255);
    deflate0_oaddr <= deflate0_do;
    pshift = (($signed({1'b0, deflate0_doo}) + width) > 8);
    if (pshift) begin
        carry = (width - (8 - $signed({1'b0, deflate0_doo})));
        deflate0_ob1 <= $signed(d >>> (width - carry));
    end
    else begin
        deflate0_ob1 <= ($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo})));
    end
    deflate0_do <= (deflate0_do + pshift);
    o_oprogress <= (deflate0_do + pshift);
    doo_next = (($signed({1'b0, deflate0_doo}) + width) & 7);
    if ((doo_next == 0)) begin
        deflate0_flush <= 1'b1;
    end
    deflate0_doo <= doo_next;
end
endtask

task MYHDL18_put;
    input d;
    integer d;
    input width;
    integer width;
    reg pshift;
    integer carry;
    integer doo_next;
begin: MYHDL97_RETURN
    deflate0_obyte <= (($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo}))) & 255);
    deflate0_oaddr <= deflate0_do;
    pshift = ((deflate0_doo + width) > 8);
    if (pshift) begin
        carry = ($signed({1'b0, width}) - (8 - $signed({1'b0, deflate0_doo})));
        deflate0_ob1 <= $signed(d >>> ($signed({1'b0, width}) - carry));
    end
    else begin
        deflate0_ob1 <= ($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo})));
    end
    deflate0_do <= (deflate0_do + pshift);
    o_oprogress <= (deflate0_do + pshift);
    doo_next = ((deflate0_doo + width) & 7);
    if ((doo_next == 0)) begin
        deflate0_flush <= 1'b1;
    end
    deflate0_doo <= doo_next;
end
endtask

task MYHDL21_put;
    input d;
    integer d;
    input [4-1:0] width;
    reg pshift;
    integer carry;
    integer doo_next;
begin: MYHDL98_RETURN
    deflate0_obyte <= (($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo}))) & 255);
    deflate0_oaddr <= deflate0_do;
    pshift = ((deflate0_doo + width) > 8);
    if (pshift) begin
        carry = ($signed({1'b0, width}) - (8 - $signed({1'b0, deflate0_doo})));
        deflate0_ob1 <= $signed(d >>> ($signed({1'b0, width}) - carry));
    end
    else begin
        deflate0_ob1 <= ($signed({1'b0, deflate0_ob1}) | (d << $signed({1'b0, deflate0_doo})));
    end
    deflate0_do <= (deflate0_do + pshift);
    o_oprogress <= (deflate0_do + pshift);
    doo_next = ((deflate0_doo + width) & 7);
    if ((doo_next == 0)) begin
        deflate0_flush <= 1'b1;
    end
    deflate0_doo <= doo_next;
end
endtask

function integer MYHDL30_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL99_RETURN
    MYHDL30_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL31_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL100_RETURN
    MYHDL31_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL32_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL101_RETURN
    MYHDL32_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL33_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL102_RETURN
    MYHDL33_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL34_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL103_RETURN
    MYHDL34_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL35_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL104_RETURN
    MYHDL35_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

task MYHDL36_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL105_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

function integer MYHDL37_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL106_RETURN
    MYHDL37_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

task MYHDL38_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL107_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

function integer MYHDL39_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL108_RETURN
    MYHDL39_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL40_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL109_RETURN
    MYHDL40_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL41_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL110_RETURN
    MYHDL41_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

task MYHDL42_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL111_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

function integer MYHDL49_rev_bits;
    input [16-1:0] b;
    input [4-1:0] nb;
    integer r;
begin: MYHDL112_RETURN
    r = (((((((((((((((((b >>> 14) & 1) << 0) | (((b >>> 13) & 1) << 1)) | (((b >>> 12) & 1) << 2)) | (((b >>> 11) & 1) << 3)) | (((b >>> 10) & 1) << 4)) | (((b >>> 9) & 1) << 5)) | (((b >>> 8) & 1) << 6)) | (((b >>> 7) & 1) << 7)) | (((b >>> 6) & 1) << 8)) | (((b >>> 5) & 1) << 9)) | (((b >>> 4) & 1) << 10)) | (((b >>> 3) & 1) << 11)) | (((b >>> 2) & 1) << 12)) | (((b >>> 1) & 1) << 13)) | (((b >>> 0) & 1) << 14));
    r = r >>> (15 - $signed({1'b0, nb}));
    MYHDL49_rev_bits = r;
end
endfunction

function integer MYHDL50_makeLeaf;
    input [9-1:0] lcode;
    input [4-1:0] lbits;
begin: MYHDL113_RETURN
    MYHDL50_makeLeaf = ((lcode << 4) | lbits);
end
endfunction

function integer MYHDL51_makeLeaf;
    input [9-1:0] lcode;
    input [4-1:0] lbits;
begin: MYHDL114_RETURN
    MYHDL51_makeLeaf = ((lcode << 4) | lbits);
end
endfunction

function integer MYHDL52_makeLeaf;
    input [9-1:0] lcode;
    input [4-1:0] lbits;
begin: MYHDL115_RETURN
    MYHDL52_makeLeaf = ((lcode << 4) | lbits);
end
endfunction

function integer MYHDL53_get4;
    input boffset;
    input [5-1:0] width;
begin: MYHDL116_RETURN
    MYHDL53_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL54_get_bits;
    input [19-1:0] aleaf;
begin: MYHDL117_RETURN
    MYHDL54_get_bits = ($signed({1'b0, aleaf}) & ((1 << 4) - 1));
end
endfunction

function integer MYHDL55_get4;
    input boffset;
    input [5-1:0] width;
begin: MYHDL118_RETURN
    MYHDL55_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL56_get_bits;
    input [19-1:0] aleaf;
begin: MYHDL119_RETURN
    MYHDL56_get_bits = ($signed({1'b0, aleaf}) & ((1 << 4) - 1));
end
endfunction

function integer MYHDL57_get_bits;
    input [19-1:0] aleaf;
begin: MYHDL120_RETURN
    MYHDL57_get_bits = ($signed({1'b0, aleaf}) & ((1 << 4) - 1));
end
endfunction

task MYHDL58_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL121_RETURN
    nshift = $signed(($signed({1'b0, deflate0_dio}) + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= (($signed({1'b0, deflate0_dio}) + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

function integer MYHDL59_get_code;
    input [19-1:0] aleaf;
begin: MYHDL122_RETURN
    MYHDL59_get_code = (aleaf >>> 4);
end
endfunction

function integer MYHDL60_get4;
    input boffset;
    integer boffset;
    input [5-1:0] width;
begin: MYHDL123_RETURN
    MYHDL60_get4 = ($signed($signed({1'b0, deflate0_b41}) >>> ($signed({1'b0, deflate0_dio}) + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL61_get_bits;
    input [19-1:0] aleaf;
begin: MYHDL124_RETURN
    MYHDL61_get_bits = ($signed({1'b0, aleaf}) & ((1 << 4) - 1));
end
endfunction

function integer MYHDL62_get4;
    input boffset;
    integer boffset;
    input [5-1:0] width;
begin: MYHDL125_RETURN
    MYHDL62_get4 = ($signed($signed({1'b0, deflate0_b41}) >>> ($signed({1'b0, deflate0_dio}) + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL63_get_bits;
    input [19-1:0] aleaf;
begin: MYHDL126_RETURN
    MYHDL63_get_bits = ($signed({1'b0, aleaf}) & ((1 << 4) - 1));
end
endfunction

function integer MYHDL64_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL127_RETURN
    MYHDL64_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL65_get_code;
    input [19-1:0] aleaf;
begin: MYHDL128_RETURN
    MYHDL65_get_code = (aleaf >>> 4);
end
endfunction

function integer MYHDL66_get_bits;
    input [19-1:0] aleaf;
begin: MYHDL129_RETURN
    MYHDL66_get_bits = ($signed({1'b0, aleaf}) & ((1 << 4) - 1));
end
endfunction

function integer MYHDL67_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL130_RETURN
    MYHDL67_get4 = ($signed($signed({1'b0, deflate0_b41}) >>> ($signed({1'b0, deflate0_dio}) + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL68_get_bits;
    input [19-1:0] aleaf;
begin: MYHDL131_RETURN
    MYHDL68_get_bits = ($signed({1'b0, aleaf}) & ((1 << 4) - 1));
end
endfunction

task MYHDL69_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL132_RETURN
    nshift = $signed(($signed({1'b0, deflate0_dio}) + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= (($signed({1'b0, deflate0_dio}) + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

function integer MYHDL70_get4;
    input boffset;
    input width;
    integer width;
begin: MYHDL133_RETURN
    MYHDL70_get4 = ((deflate0_b41 >>> (deflate0_dio + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL71_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL134_RETURN
    MYHDL71_get4 = ($signed($signed({1'b0, deflate0_b41}) >>> ($signed({1'b0, deflate0_dio}) + boffset)) & ((1 << width) - 1));
end
endfunction

function integer MYHDL72_rev_bits;
    input b;
    integer b;
    input nb;
    integer nb;
    integer r;
begin: MYHDL135_RETURN
    r = (((((((((((((((((b >>> 14) & 1) << 0) | (((b >>> 13) & 1) << 1)) | (((b >>> 12) & 1) << 2)) | (((b >>> 11) & 1) << 3)) | (((b >>> 10) & 1) << 4)) | (((b >>> 9) & 1) << 5)) | (((b >>> 8) & 1) << 6)) | (((b >>> 7) & 1) << 7)) | (((b >>> 6) & 1) << 8)) | (((b >>> 5) & 1) << 9)) | (((b >>> 4) & 1) << 10)) | (((b >>> 3) & 1) << 11)) | (((b >>> 2) & 1) << 12)) | (((b >>> 1) & 1) << 13)) | (((b >>> 0) & 1) << 14));
    r = r >>> (15 - $signed({1'b0, nb}));
    MYHDL72_rev_bits = r;
end
endfunction

function integer MYHDL73_get4;
    input boffset;
    integer boffset;
    input width;
    integer width;
begin: MYHDL136_RETURN
    MYHDL73_get4 = ($signed($signed({1'b0, deflate0_b41}) >>> ($signed({1'b0, deflate0_dio}) + boffset)) & ((1 << width) - 1));
end
endfunction

task MYHDL74_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL137_RETURN
    nshift = $signed(($signed({1'b0, deflate0_dio}) + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= (($signed({1'b0, deflate0_dio}) + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

task MYHDL75_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL138_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask

task MYHDL76_adv;
    input width;
    integer width;
    integer nshift;
begin: MYHDL139_RETURN
    nshift = ((deflate0_dio + width) >>> 3);
    o_iprogress <= deflate0_di;
    deflate0_dio <= ((deflate0_dio + width) & 7);
    deflate0_di <= ($signed({1'b0, deflate0_di}) + nshift);
    if ((nshift != 0)) begin
        deflate0_filled <= 1'b0;
    end
end
endtask


always @(posedge i_clk) begin: TEST_DEFLATE_BENCH_DEFLATE0_IO_LOGIC
    o_byte <= deflate0_oram[(i_raddr & 8191)];
    if ((i_mode == 2)) begin
        deflate0_iram[(i_waddr & 511)] <= i_data;
        deflate0_isize <= i_waddr;
    end
end


always @(posedge i_clk) begin: TEST_DEFLATE_BENCH_DEFLATE0_LOGIC
    integer hm;
    integer skip;
    reg no_adv;
    integer cs_i;
    reg [4-1:0] outlen;
    integer outbits;
    reg [8-1:0] bdata;
    integer adler1_next;
    integer lencode;
    integer nextdist;
    integer copydist;
    integer extra_dist;
    integer extra_bits;
    integer outcode;
    reg [10-1:0] lfmatch;
    integer distance;
    integer fmatch2;
    integer match;
    reg mdone;
    reg found;
    integer fmatch;
    integer si;
    integer limit;
    reg [8-1:0] cbyte;
    integer stat_i;
    integer clo_i;
    integer n_adv;
    integer dbl_i;
    integer dbl;
    integer dist_i;
    reg [4-1:0] j;
    integer t;
    integer hf2_i;
    reg [5-1:0] amb;
    integer ncode;
    reg [16-1:0] canonical;
    reg [4-1:0] bits_next;
    reg [15-1:0] aim;
    integer cto;
    integer mask;
    integer token;
    integer extraLength;
    integer tlength;
    integer distanceCode;
    integer moreBits;
    integer mored;
    if ((!reset)) begin
        $write("DEFLATE RESET");
        $write("\n");
        deflate0_state <= 5'b00000;
        o_done <= 1'b0;
        deflate0_prev_method <= 3;
    end
    else begin
        case (deflate0_state)
            5'b00000: begin
                if ((1'b1 && (i_mode == 4))) begin
                    $write("STARTC");
                    $write("\n");
                    deflate0_do_compress <= 1'b1;
                    o_done <= 1'b0;
                    o_iprogress <= 0;
                    o_oprogress <= 0;
                    deflate0_di <= 0;
                    deflate0_dio <= 0;
                    deflate0_do <= 0;
                    deflate0_doo <= 0;
                    deflate0_filled <= 1'b1;
                    deflate0_cur_static <= 0;
                    deflate0_cur_cstatic <= 0;
                    deflate0_state <= 5'b01110;
                end
                else if ((1'b0 && (i_mode == 5))) begin
                    deflate0_do_compress <= 1'b0;
                    o_done <= 1'b0;
                    o_iprogress <= 0;
                    o_oprogress <= 0;
                    deflate0_di <= 0;
                    deflate0_dio <= 0;
                    deflate0_do <= 0;
                    deflate0_doo <= 0;
                    deflate0_filled <= 1'b1;
                    deflate0_first_block <= 1'b1;
                    deflate0_state <= 5'b00001;
                end
                else begin
                    // pass
                end
            end
            5'b00001: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if ((!deflate0_filled)) begin
                    deflate0_filled <= 1'b1;
                end
                else if ((!deflate0_nb)) begin
                    // pass
                end
                else if (deflate0_first_block) begin
                    deflate0_first_block <= 1'b0;
                    if ((deflate0_b1 == 120)) begin
                        $write("deflate mode");
                        $write("\n");
                    end
                    else begin
                        $write("%h", deflate0_di);
                        $write(" ");
                        $write("%h", deflate0_dio);
                        $write(" ");
                        $write("%h", deflate0_nb);
                        $write(" ");
                        $write("%h", deflate0_b1);
                        $write(" ");
                        $write("%h", deflate0_b2);
                        $write(" ");
                        $write("%h", deflate0_b3);
                        $write(" ");
                        $write("%h", deflate0_b4);
                        $write(" ");
                        $write("%h", deflate0_isize);
                        $write("\n");
                        o_done <= 1'b1;
                        deflate0_state <= 5'b00000;
                    end
                    MYHDL3_adv(16);
                end
                else begin
                    if (MYHDL4_get4(0, 1)) begin
                        $write("final");
                        $write("\n");
                        deflate0_final <= 1'b1;
                    end
                    hm = MYHDL5_get4(1, 2);
                    deflate0_method <= hm;
                    $write("method");
                    $write(" ");
                    $write("%0d", hm);
                    $write("\n");
                    case (hm)
                        'h2: begin
                            if ((!1'b1)) begin
                                $write("dynamic tree mode disabled");
                                $write("\n");
                            end
                            deflate0_state <= 5'b00010;
                            deflate0_numCodeLength <= 0;
                            deflate0_numLiterals <= 0;
                            deflate0_static <= 1'b0;
                            MYHDL6_adv(3);
                        end
                        'h1: begin
                            deflate0_static <= 1'b1;
                            deflate0_cur_static <= 0;
                            $write("prev method is");
                            $write(" ");
                            $write("%h", deflate0_prev_method);
                            $write("\n");
                            if ((deflate0_prev_method == 1)) begin
                                $write("skip HF init");
                                $write("\n");
                                deflate0_state <= 5'b10011;
                                deflate0_cur_next <= 0;
                            end
                            else begin
                                deflate0_state <= 5'b01110;
                            end
                            MYHDL7_adv(3);
                        end
                        'h0: begin
                            deflate0_state <= 5'b10101;
                            skip = (8 - deflate0_dio);
                            if ((skip <= 2)) begin
                                skip = (16 - deflate0_dio);
                            end
                            deflate0_length <= MYHDL8_get4(skip, 16);
                            MYHDL9_adv((skip + 16));
                            deflate0_cur_i <= 0;
                            deflate0_offset <= 7;
                        end
                        default: begin
                            deflate0_state <= 5'b00000;
                            $write("Bad method");
                            $write("\n");
                        end
                    endcase
                    deflate0_prev_method <= hm;
                    $write("set prev");
                    $write(" ");
                    $write("%0d", hm);
                    $write("\n");
                end
            end
            5'b10110: begin
                no_adv = 0;
                if ((!1'b1)) begin
                    // pass
                end
                else if ((!deflate0_nb)) begin
                    no_adv = 1;
                end
                else if ((deflate0_cur_cstatic == 0)) begin
                    deflate0_flush <= 1'b0;
                    deflate0_ob1 <= 0;
                    deflate0_adler1 <= 1;
                    deflate0_adler2 <= 0;
                    deflate0_ladler1 <= 0;
                    deflate0_oaddr <= 0;
                    deflate0_obyte <= 120;
                end
                else if ((deflate0_cur_cstatic == 1)) begin
                    deflate0_oaddr <= 1;
                    deflate0_obyte <= 156;
                    deflate0_do <= 2;
                end
                else if ((deflate0_cur_cstatic == 2)) begin
                    MYHDL10_put(3, 3);
                end
                else if (deflate0_flush) begin
                    no_adv = 1;
                    deflate0_oaddr <= deflate0_do;
                    deflate0_obyte <= deflate0_ob1;
                    MYHDL11_do_flush;
                end
                else if ((($signed({1'b0, deflate0_cur_cstatic}) >= ($signed({1'b0, deflate0_isize}) - 10)) && (i_mode != 0))) begin
                    $write("P");
                    $write(" ");
                    $write("%h", deflate0_cur_cstatic);
                    $write(" ");
                    $write("%h", deflate0_isize);
                    $write("\n");
                    no_adv = 1;
                end
                else if ((deflate0_cur_cstatic > (deflate0_isize + 3))) begin
                    if ((deflate0_cur_cstatic == (deflate0_isize + 4))) begin
                        $write("Put EOF");
                        $write(" ");
                        $write("%h", deflate0_do);
                        $write("\n");
                        cs_i = 256;
                        outlen = deflate0_codeLength[cs_i];
                        case (cs_i)
                            0: outbits = 12;
                            1: outbits = 140;
                            2: outbits = 76;
                            3: outbits = 204;
                            4: outbits = 44;
                            5: outbits = 172;
                            6: outbits = 108;
                            7: outbits = 236;
                            8: outbits = 28;
                            9: outbits = 156;
                            10: outbits = 92;
                            11: outbits = 220;
                            12: outbits = 60;
                            13: outbits = 188;
                            14: outbits = 124;
                            15: outbits = 252;
                            16: outbits = 2;
                            17: outbits = 130;
                            18: outbits = 66;
                            19: outbits = 194;
                            20: outbits = 34;
                            21: outbits = 162;
                            22: outbits = 98;
                            23: outbits = 226;
                            24: outbits = 18;
                            25: outbits = 146;
                            26: outbits = 82;
                            27: outbits = 210;
                            28: outbits = 50;
                            29: outbits = 178;
                            30: outbits = 114;
                            31: outbits = 242;
                            32: outbits = 10;
                            33: outbits = 138;
                            34: outbits = 74;
                            35: outbits = 202;
                            36: outbits = 42;
                            37: outbits = 170;
                            38: outbits = 106;
                            39: outbits = 234;
                            40: outbits = 26;
                            41: outbits = 154;
                            42: outbits = 90;
                            43: outbits = 218;
                            44: outbits = 58;
                            45: outbits = 186;
                            46: outbits = 122;
                            47: outbits = 250;
                            48: outbits = 6;
                            49: outbits = 134;
                            50: outbits = 70;
                            51: outbits = 198;
                            52: outbits = 38;
                            53: outbits = 166;
                            54: outbits = 102;
                            55: outbits = 230;
                            56: outbits = 22;
                            57: outbits = 150;
                            58: outbits = 86;
                            59: outbits = 214;
                            60: outbits = 54;
                            61: outbits = 182;
                            62: outbits = 118;
                            63: outbits = 246;
                            64: outbits = 14;
                            65: outbits = 142;
                            66: outbits = 78;
                            67: outbits = 206;
                            68: outbits = 46;
                            69: outbits = 174;
                            70: outbits = 110;
                            71: outbits = 238;
                            72: outbits = 30;
                            73: outbits = 158;
                            74: outbits = 94;
                            75: outbits = 222;
                            76: outbits = 62;
                            77: outbits = 190;
                            78: outbits = 126;
                            79: outbits = 254;
                            80: outbits = 1;
                            81: outbits = 129;
                            82: outbits = 65;
                            83: outbits = 193;
                            84: outbits = 33;
                            85: outbits = 161;
                            86: outbits = 97;
                            87: outbits = 225;
                            88: outbits = 17;
                            89: outbits = 145;
                            90: outbits = 81;
                            91: outbits = 209;
                            92: outbits = 49;
                            93: outbits = 177;
                            94: outbits = 113;
                            95: outbits = 241;
                            96: outbits = 9;
                            97: outbits = 137;
                            98: outbits = 73;
                            99: outbits = 201;
                            100: outbits = 41;
                            101: outbits = 169;
                            102: outbits = 105;
                            103: outbits = 233;
                            104: outbits = 25;
                            105: outbits = 153;
                            106: outbits = 89;
                            107: outbits = 217;
                            108: outbits = 57;
                            109: outbits = 185;
                            110: outbits = 121;
                            111: outbits = 249;
                            112: outbits = 5;
                            113: outbits = 133;
                            114: outbits = 69;
                            115: outbits = 197;
                            116: outbits = 37;
                            117: outbits = 165;
                            118: outbits = 101;
                            119: outbits = 229;
                            120: outbits = 21;
                            121: outbits = 149;
                            122: outbits = 85;
                            123: outbits = 213;
                            124: outbits = 53;
                            125: outbits = 181;
                            126: outbits = 117;
                            127: outbits = 245;
                            128: outbits = 13;
                            129: outbits = 141;
                            130: outbits = 77;
                            131: outbits = 205;
                            132: outbits = 45;
                            133: outbits = 173;
                            134: outbits = 109;
                            135: outbits = 237;
                            136: outbits = 29;
                            137: outbits = 157;
                            138: outbits = 93;
                            139: outbits = 221;
                            140: outbits = 61;
                            141: outbits = 189;
                            142: outbits = 125;
                            143: outbits = 253;
                            144: outbits = 19;
                            145: outbits = 275;
                            146: outbits = 147;
                            147: outbits = 403;
                            148: outbits = 83;
                            149: outbits = 339;
                            150: outbits = 211;
                            151: outbits = 467;
                            152: outbits = 51;
                            153: outbits = 307;
                            154: outbits = 179;
                            155: outbits = 435;
                            156: outbits = 115;
                            157: outbits = 371;
                            158: outbits = 243;
                            159: outbits = 499;
                            160: outbits = 11;
                            161: outbits = 267;
                            162: outbits = 139;
                            163: outbits = 395;
                            164: outbits = 75;
                            165: outbits = 331;
                            166: outbits = 203;
                            167: outbits = 459;
                            168: outbits = 43;
                            169: outbits = 299;
                            170: outbits = 171;
                            171: outbits = 427;
                            172: outbits = 107;
                            173: outbits = 363;
                            174: outbits = 235;
                            175: outbits = 491;
                            176: outbits = 27;
                            177: outbits = 283;
                            178: outbits = 155;
                            179: outbits = 411;
                            180: outbits = 91;
                            181: outbits = 347;
                            182: outbits = 219;
                            183: outbits = 475;
                            184: outbits = 59;
                            185: outbits = 315;
                            186: outbits = 187;
                            187: outbits = 443;
                            188: outbits = 123;
                            189: outbits = 379;
                            190: outbits = 251;
                            191: outbits = 507;
                            192: outbits = 7;
                            193: outbits = 263;
                            194: outbits = 135;
                            195: outbits = 391;
                            196: outbits = 71;
                            197: outbits = 327;
                            198: outbits = 199;
                            199: outbits = 455;
                            200: outbits = 39;
                            201: outbits = 295;
                            202: outbits = 167;
                            203: outbits = 423;
                            204: outbits = 103;
                            205: outbits = 359;
                            206: outbits = 231;
                            207: outbits = 487;
                            208: outbits = 23;
                            209: outbits = 279;
                            210: outbits = 151;
                            211: outbits = 407;
                            212: outbits = 87;
                            213: outbits = 343;
                            214: outbits = 215;
                            215: outbits = 471;
                            216: outbits = 55;
                            217: outbits = 311;
                            218: outbits = 183;
                            219: outbits = 439;
                            220: outbits = 119;
                            221: outbits = 375;
                            222: outbits = 247;
                            223: outbits = 503;
                            224: outbits = 15;
                            225: outbits = 271;
                            226: outbits = 143;
                            227: outbits = 399;
                            228: outbits = 79;
                            229: outbits = 335;
                            230: outbits = 207;
                            231: outbits = 463;
                            232: outbits = 47;
                            233: outbits = 303;
                            234: outbits = 175;
                            235: outbits = 431;
                            236: outbits = 111;
                            237: outbits = 367;
                            238: outbits = 239;
                            239: outbits = 495;
                            240: outbits = 31;
                            241: outbits = 287;
                            242: outbits = 159;
                            243: outbits = 415;
                            244: outbits = 95;
                            245: outbits = 351;
                            246: outbits = 223;
                            247: outbits = 479;
                            248: outbits = 63;
                            249: outbits = 319;
                            250: outbits = 191;
                            251: outbits = 447;
                            252: outbits = 127;
                            253: outbits = 383;
                            254: outbits = 255;
                            255: outbits = 511;
                            256: outbits = 0;
                            257: outbits = 64;
                            258: outbits = 32;
                            259: outbits = 96;
                            260: outbits = 16;
                            261: outbits = 80;
                            262: outbits = 48;
                            263: outbits = 112;
                            264: outbits = 8;
                            265: outbits = 72;
                            266: outbits = 40;
                            267: outbits = 104;
                            268: outbits = 24;
                            269: outbits = 88;
                            270: outbits = 56;
                            271: outbits = 120;
                            272: outbits = 4;
                            273: outbits = 68;
                            274: outbits = 36;
                            275: outbits = 100;
                            276: outbits = 20;
                            277: outbits = 84;
                            278: outbits = 52;
                            279: outbits = 116;
                            280: outbits = 3;
                            281: outbits = 131;
                            282: outbits = 67;
                            283: outbits = 195;
                            284: outbits = 35;
                            285: outbits = 163;
                            286: outbits = 99;
                            default: outbits = 227;
                        endcase
                        $write("EOF BITS:");
                        $write(" ");
                        $write("%0d", cs_i);
                        $write(" ");
                        $write("%h", outlen);
                        $write(" ");
                        $write("%0d", outbits);
                        $write("\n");
                        MYHDL12_put(outbits, outlen);
                    end
                    else if ((deflate0_cur_cstatic == (deflate0_isize + 5))) begin
                        $write("calc end adler");
                        $write("\n");
                        deflate0_adler2 <= ((deflate0_adler2 + deflate0_ladler1) % 65521);
                        if ((deflate0_doo != 0)) begin
                            deflate0_oaddr <= deflate0_do;
                            deflate0_obyte <= deflate0_ob1;
                            deflate0_do <= (deflate0_do + 1);
                        end
                    end
                    else if ((deflate0_cur_cstatic == (deflate0_isize + 6))) begin
                        $write("c1");
                        $write("\n");
                        deflate0_oaddr <= deflate0_do;
                        deflate0_obyte <= (deflate0_adler2 >>> 8);
                        deflate0_do <= (deflate0_do + 1);
                        o_oprogress <= (deflate0_do + 1);
                    end
                    else if ((deflate0_cur_cstatic == (deflate0_isize + 7))) begin
                        $write("c2");
                        $write("\n");
                        deflate0_oaddr <= deflate0_do;
                        deflate0_obyte <= (deflate0_adler2 & 255);
                        deflate0_do <= (deflate0_do + 1);
                        o_oprogress <= (deflate0_do + 1);
                    end
                    else if ((deflate0_cur_cstatic == (deflate0_isize + 8))) begin
                        $write("c3");
                        $write("\n");
                        deflate0_oaddr <= deflate0_do;
                        deflate0_obyte <= (deflate0_adler1 >>> 8);
                        deflate0_do <= (deflate0_do + 1);
                        o_oprogress <= (deflate0_do + 1);
                    end
                    else if ((deflate0_cur_cstatic == (deflate0_isize + 9))) begin
                        $write("c4");
                        $write("\n");
                        deflate0_oaddr <= deflate0_do;
                        deflate0_obyte <= (deflate0_adler1 & 255);
                        o_oprogress <= (deflate0_do + 1);
                    end
                    else if ((deflate0_cur_cstatic == (deflate0_isize + 10))) begin
                        $write("EOF finish");
                        $write(" ");
                        $write("%h", deflate0_do);
                        $write("\n");
                        o_done <= 1'b1;
                        deflate0_state <= 5'b00000;
                    end
                    else begin
                        $write("%h", deflate0_cur_cstatic);
                        $write(" ");
                        $write("%h", deflate0_isize);
                        $write("\n");
                    end
                end
                else begin
                    bdata = deflate0_iram[(deflate0_di & 511)];
                    o_iprogress <= deflate0_di;
                    adler1_next = ((deflate0_adler1 + bdata) % 65521);
                    deflate0_adler1 <= adler1_next;
                    deflate0_adler2 <= ((deflate0_adler2 + deflate0_ladler1) % 65521);
                    deflate0_ladler1 <= adler1_next;
                    deflate0_state <= 5'b10111;
                    deflate0_cur_search <= (deflate0_di - 1);
                end
                if ((!no_adv)) begin
                    deflate0_cur_cstatic <= (deflate0_cur_cstatic + 1);
                end
            end
            5'b11010: begin
                if ((!1'b1)) begin
                    // pass
                end
                else if (deflate0_flush) begin
                    MYHDL13_do_flush;
                end
                else if (deflate0_do_init) begin
                    deflate0_do_init <= 1'b0;
                    deflate0_cur_cstatic <= ((deflate0_cur_cstatic + deflate0_mlength) - 1);
                    deflate0_outcarrybits <= 0;
		    // Crash
                    lencode = (deflate0_mlength + 254);
                    outlen = deflate0_codeLength[lencode];
                    case (lencode)
                        0: outbits = 12;
                        1: outbits = 140;
                        2: outbits = 76;
                        3: outbits = 204;
                        4: outbits = 44;
                        5: outbits = 172;
                        6: outbits = 108;
                        7: outbits = 236;
                        8: outbits = 28;
                        9: outbits = 156;
                        10: outbits = 92;
                        11: outbits = 220;
                        12: outbits = 60;
                        13: outbits = 188;
                        14: outbits = 124;
                        15: outbits = 252;
                        16: outbits = 2;
                        17: outbits = 130;
                        18: outbits = 66;
                        19: outbits = 194;
                        20: outbits = 34;
                        21: outbits = 162;
                        22: outbits = 98;
                        23: outbits = 226;
                        24: outbits = 18;
                        25: outbits = 146;
                        26: outbits = 82;
                        27: outbits = 210;
                        28: outbits = 50;
                        29: outbits = 178;
                        30: outbits = 114;
                        31: outbits = 242;
                        32: outbits = 10;
                        33: outbits = 138;
                        34: outbits = 74;
                        35: outbits = 202;
                        36: outbits = 42;
                        37: outbits = 170;
                        38: outbits = 106;
                        39: outbits = 234;
                        40: outbits = 26;
                        41: outbits = 154;
                        42: outbits = 90;
                        43: outbits = 218;
                        44: outbits = 58;
                        45: outbits = 186;
                        46: outbits = 122;
                        47: outbits = 250;
                        48: outbits = 6;
                        49: outbits = 134;
                        50: outbits = 70;
                        51: outbits = 198;
                        52: outbits = 38;
                        53: outbits = 166;
                        54: outbits = 102;
                        55: outbits = 230;
                        56: outbits = 22;
                        57: outbits = 150;
                        58: outbits = 86;
                        59: outbits = 214;
                        60: outbits = 54;
                        61: outbits = 182;
                        62: outbits = 118;
                        63: outbits = 246;
                        64: outbits = 14;
                        65: outbits = 142;
                        66: outbits = 78;
                        67: outbits = 206;
                        68: outbits = 46;
                        69: outbits = 174;
                        70: outbits = 110;
                        71: outbits = 238;
                        72: outbits = 30;
                        73: outbits = 158;
                        74: outbits = 94;
                        75: outbits = 222;
                        76: outbits = 62;
                        77: outbits = 190;
                        78: outbits = 126;
                        79: outbits = 254;
                        80: outbits = 1;
                        81: outbits = 129;
                        82: outbits = 65;
                        83: outbits = 193;
                        84: outbits = 33;
                        85: outbits = 161;
                        86: outbits = 97;
                        87: outbits = 225;
                        88: outbits = 17;
                        89: outbits = 145;
                        90: outbits = 81;
                        91: outbits = 209;
                        92: outbits = 49;
                        93: outbits = 177;
                        94: outbits = 113;
                        95: outbits = 241;
                        96: outbits = 9;
                        97: outbits = 137;
                        98: outbits = 73;
                        99: outbits = 201;
                        100: outbits = 41;
                        101: outbits = 169;
                        102: outbits = 105;
                        103: outbits = 233;
                        104: outbits = 25;
                        105: outbits = 153;
                        106: outbits = 89;
                        107: outbits = 217;
                        108: outbits = 57;
                        109: outbits = 185;
                        110: outbits = 121;
                        111: outbits = 249;
                        112: outbits = 5;
                        113: outbits = 133;
                        114: outbits = 69;
                        115: outbits = 197;
                        116: outbits = 37;
                        117: outbits = 165;
                        118: outbits = 101;
                        119: outbits = 229;
                        120: outbits = 21;
                        121: outbits = 149;
                        122: outbits = 85;
                        123: outbits = 213;
                        124: outbits = 53;
                        125: outbits = 181;
                        126: outbits = 117;
                        127: outbits = 245;
                        128: outbits = 13;
                        129: outbits = 141;
                        130: outbits = 77;
                        131: outbits = 205;
                        132: outbits = 45;
                        133: outbits = 173;
                        134: outbits = 109;
                        135: outbits = 237;
                        136: outbits = 29;
                        137: outbits = 157;
                        138: outbits = 93;
                        139: outbits = 221;
                        140: outbits = 61;
                        141: outbits = 189;
                        142: outbits = 125;
                        143: outbits = 253;
                        144: outbits = 19;
                        145: outbits = 275;
                        146: outbits = 147;
                        147: outbits = 403;
                        148: outbits = 83;
                        149: outbits = 339;
                        150: outbits = 211;
                        151: outbits = 467;
                        152: outbits = 51;
                        153: outbits = 307;
                        154: outbits = 179;
                        155: outbits = 435;
                        156: outbits = 115;
                        157: outbits = 371;
                        158: outbits = 243;
                        159: outbits = 499;
                        160: outbits = 11;
                        161: outbits = 267;
                        162: outbits = 139;
                        163: outbits = 395;
                        164: outbits = 75;
                        165: outbits = 331;
                        166: outbits = 203;
                        167: outbits = 459;
                        168: outbits = 43;
                        169: outbits = 299;
                        170: outbits = 171;
                        171: outbits = 427;
                        172: outbits = 107;
                        173: outbits = 363;
                        174: outbits = 235;
                        175: outbits = 491;
                        176: outbits = 27;
                        177: outbits = 283;
                        178: outbits = 155;
                        179: outbits = 411;
                        180: outbits = 91;
                        181: outbits = 347;
                        182: outbits = 219;
                        183: outbits = 475;
                        184: outbits = 59;
                        185: outbits = 315;
                        186: outbits = 187;
                        187: outbits = 443;
                        188: outbits = 123;
                        189: outbits = 379;
                        190: outbits = 251;
                        191: outbits = 507;
                        192: outbits = 7;
                        193: outbits = 263;
                        194: outbits = 135;
                        195: outbits = 391;
                        196: outbits = 71;
                        197: outbits = 327;
                        198: outbits = 199;
                        199: outbits = 455;
                        200: outbits = 39;
                        201: outbits = 295;
                        202: outbits = 167;
                        203: outbits = 423;
                        204: outbits = 103;
                        205: outbits = 359;
                        206: outbits = 231;
                        207: outbits = 487;
                        208: outbits = 23;
                        209: outbits = 279;
                        210: outbits = 151;
                        211: outbits = 407;
                        212: outbits = 87;
                        213: outbits = 343;
                        214: outbits = 215;
                        215: outbits = 471;
                        216: outbits = 55;
                        217: outbits = 311;
                        218: outbits = 183;
                        219: outbits = 439;
                        220: outbits = 119;
                        221: outbits = 375;
                        222: outbits = 247;
                        223: outbits = 503;
                        224: outbits = 15;
                        225: outbits = 271;
                        226: outbits = 143;
                        227: outbits = 399;
                        228: outbits = 79;
                        229: outbits = 335;
                        230: outbits = 207;
                        231: outbits = 463;
                        232: outbits = 47;
                        233: outbits = 303;
                        234: outbits = 175;
                        235: outbits = 431;
                        236: outbits = 111;
                        237: outbits = 367;
                        238: outbits = 239;
                        239: outbits = 495;
                        240: outbits = 31;
                        241: outbits = 287;
                        242: outbits = 159;
                        243: outbits = 415;
                        244: outbits = 95;
                        245: outbits = 351;
                        246: outbits = 223;
                        247: outbits = 479;
                        248: outbits = 63;
                        249: outbits = 319;
                        250: outbits = 191;
                        251: outbits = 447;
                        252: outbits = 127;
                        253: outbits = 383;
                        254: outbits = 255;
                        255: outbits = 511;
                        256: outbits = 0;
                        257: outbits = 64;
                        258: outbits = 32;
                        259: outbits = 96;
                        260: outbits = 16;
                        261: outbits = 80;
                        262: outbits = 48;
                        263: outbits = 112;
                        264: outbits = 8;
                        265: outbits = 72;
                        266: outbits = 40;
                        267: outbits = 104;
                        268: outbits = 24;
                        269: outbits = 88;
                        270: outbits = 56;
                        271: outbits = 120;
                        272: outbits = 4;
                        273: outbits = 68;
                        274: outbits = 36;
                        275: outbits = 100;
                        276: outbits = 20;
                        277: outbits = 84;
                        278: outbits = 52;
                        279: outbits = 116;
                        280: outbits = 3;
                        281: outbits = 131;
                        282: outbits = 67;
                        283: outbits = 195;
                        284: outbits = 35;
                        285: outbits = 163;
                        286: outbits = 99;
                        default: outbits = 227;
                    endcase
                    MYHDL14_put(outbits, outlen);
                    deflate0_cur_i <= 0;
                end
                else if (deflate0_outcarrybits) begin
                    MYHDL15_put(deflate0_outcarry, deflate0_outcarrybits);
                    deflate0_state <= 5'b11011;
                end
                else begin
                    case ((deflate0_cur_i + 1))
                        0: nextdist = 1;
                        1: nextdist = 2;
                        2: nextdist = 3;
                        3: nextdist = 4;
                        4: nextdist = 5;
                        5: nextdist = 7;
                        6: nextdist = 9;
                        7: nextdist = 13;
                        8: nextdist = 17;
                        9: nextdist = 25;
                        10: nextdist = 33;
                        11: nextdist = 49;
                        12: nextdist = 65;
                        13: nextdist = 97;
                        14: nextdist = 129;
                        15: nextdist = 193;
                        16: nextdist = 257;
                        17: nextdist = 385;
                        18: nextdist = 513;
                        19: nextdist = 769;
                        20: nextdist = 1025;
                        21: nextdist = 1537;
                        22: nextdist = 2049;
                        23: nextdist = 3073;
                        24: nextdist = 4097;
                        25: nextdist = 6145;
                        26: nextdist = 8193;
                        27: nextdist = 12289;
                        28: nextdist = 16385;
                        default: nextdist = 24577;
                    endcase
                    if ((nextdist > deflate0_cur_dist)) begin
                        case (deflate0_cur_i)
                            0: copydist = 1;
                            1: copydist = 2;
                            2: copydist = 3;
                            3: copydist = 4;
                            4: copydist = 5;
                            5: copydist = 7;
                            6: copydist = 9;
                            7: copydist = 13;
                            8: copydist = 17;
                            9: copydist = 25;
                            10: copydist = 33;
                            11: copydist = 49;
                            12: copydist = 65;
                            13: copydist = 97;
                            14: copydist = 129;
                            15: copydist = 193;
                            16: copydist = 257;
                            17: copydist = 385;
                            18: copydist = 513;
                            19: copydist = 769;
                            20: copydist = 1025;
                            21: copydist = 1537;
                            22: copydist = 2049;
                            23: copydist = 3073;
                            24: copydist = 4097;
                            25: copydist = 6145;
                            26: copydist = 8193;
                            27: copydist = 12289;
                            28: copydist = 16385;
                            default: copydist = 24577;
                        endcase
                        extra_dist = (deflate0_cur_dist - copydist);
                        case ((deflate0_cur_i / 2))
                            0: extra_bits = 0;
                            1: extra_bits = 0;
                            2: extra_bits = 1;
                            3: extra_bits = 2;
                            4: extra_bits = 3;
                            5: extra_bits = 4;
                            6: extra_bits = 5;
                            7: extra_bits = 6;
                            8: extra_bits = 7;
                            9: extra_bits = 8;
                            10: extra_bits = 9;
                            11: extra_bits = 10;
                            12: extra_bits = 11;
                            13: extra_bits = 12;
                            default: extra_bits = 13;
                        endcase
                        deflate0_cur_i <= (($signed({1'b0, deflate0_di}) - $signed({1'b0, deflate0_mlength})) + 1);
                        outcode = (MYHDL16_rev_bits(deflate0_cur_i, 5) | (extra_dist << 5));
                        if ((extra_bits <= 4)) begin
                            MYHDL17_put(outcode, (5 + extra_bits));
                            deflate0_state <= 5'b11011;
                        end
                        else begin
                            deflate0_outcarry <= $signed(outcode >>> 8);
                            deflate0_outcarrybits <= (extra_bits - 3);
                            outcode = (outcode & 255);
                            MYHDL18_put(outcode, 8);
                        end
                    end
                    else begin
                        deflate0_cur_i <= (deflate0_cur_i + 1);
                    end
                end
            end
            5'b11011: begin
                if ((!1'b1)) begin
                    // pass
                end
                else if ((deflate0_cur_i < deflate0_di)) begin
                    bdata = deflate0_iram[(deflate0_cur_i & 511)];
                    adler1_next = ((deflate0_adler1 + bdata) % 65521);
                    deflate0_adler1 <= adler1_next;
                    deflate0_adler2 <= ((deflate0_adler2 + deflate0_ladler1) % 65521);
                    deflate0_ladler1 <= adler1_next;
                    deflate0_cur_i <= (deflate0_cur_i + 1);
                end
                else begin
                    deflate0_state <= 5'b10110;
                end
            end
            5'b11001: begin
                if ((1'b0 && 1'b1)) begin
                    lfmatch = deflate0_dlength;
                    distance = (lfmatch + 1);
                    fmatch2 = (($signed({1'b0, deflate0_di}) - $signed({1'b0, lfmatch})) + 2);
                    match = 3;
                    mdone = 1'b1;
                    if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 4)) && (deflate0_iram[(fmatch2 & 511)] == deflate0_b4))) begin
                        match = 4;
                        if ((deflate0_fcount < 5)) begin
                            mdone = 1'b0;
                        end
                        else if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 5)) && (deflate0_iram[((fmatch2 + 1) & 511)] == deflate0_b5))) begin
                            match = 5;
                            if (1'b1) begin
                                if ((deflate0_fcount < 6)) begin
                                    mdone = 1'b0;
                                end
                                else begin
                                    if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 6)) && (deflate0_iram[((fmatch2 + 2) & 511)] == deflate0_b6))) begin
                                        match = 6;
                                        if ((deflate0_fcount < 7)) begin
                                            mdone = 1'b0;
                                        end
                                        else if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 7)) && (deflate0_iram[((fmatch2 + 3) & 511)] == deflate0_b7))) begin
                                            match = 7;
                                            if ((deflate0_fcount < 8)) begin
                                                mdone = 1'b0;
                                            end
                                            else if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 8)) && (deflate0_iram[((fmatch2 + 4) & 511)] == deflate0_b8))) begin
                                                match = 8;
                                                if ((deflate0_fcount < 9)) begin
                                                    mdone = 1'b0;
                                                end
                                                else if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 9)) && (deflate0_iram[((fmatch2 + 5) & 511)] == deflate0_b9))) begin
                                                    match = 9;
                                                    if ((deflate0_fcount < 10)) begin
                                                        mdone = 1'b0;
                                                    end
                                                    else if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 10)) && (deflate0_iram[((fmatch2 + 6) & 511)] == deflate0_b10))) begin
                                                        match = 10;
                                                    end
                                                end
                                            end
                                        end
                                    end
                                end
                            end
                        end
                    end
                    if (mdone) begin
                        deflate0_cur_dist <= distance;
                        deflate0_do_init <= 1'b1;
                        deflate0_di <= (deflate0_di + match);
                        deflate0_mlength <= match;
                        deflate0_state <= 5'b11010;
                    end
                end
            end
            5'b10111: begin
                if ((!1'b1)) begin
                    // pass
                end
                else begin
                    if (((deflate0_cur_search >= 0) && (deflate0_cur_search >= ($signed({1'b0, deflate0_di}) - 256)) && ($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - 3)))) begin
                        if (1'b0) begin
                            found = 0;
                            fmatch = 0;
                            begin: MYHDL19_BREAK
                            for (si=0; si<256; si=si+1) begin
                                if (deflate0_smatch[si]) begin
                                    fmatch = si;
                                    found = 1;
                                end
                            end
                            end
                            if (((!found) || ((($signed({1'b0, deflate0_di}) - fmatch) - 1) < 0))) begin
                                deflate0_cur_search <= (-1);
                            end
                            else begin
                                deflate0_dlength <= fmatch;
                                deflate0_state <= 5'b11001;
                            end
                        end
                        else begin
                            if (((!1'b0) && (deflate0_iram[(deflate0_cur_search & 511)] == deflate0_b1) && (deflate0_iram[((deflate0_cur_search + 1) & 511)] == deflate0_b2) && (deflate0_iram[((deflate0_cur_search + 2) & 511)] == deflate0_b3))) begin
                                deflate0_more <= 4;
                                deflate0_state <= 5'b11000;
                            end
                            else begin
                                deflate0_cur_search <= (deflate0_cur_search - 1);
                            end
                        end
                    end
                    else begin
                        bdata = deflate0_b1;
                        deflate0_di <= (deflate0_di + 1);
                        outlen = deflate0_codeLength[bdata];
                        case (bdata)
                            0: outbits = 12;
                            1: outbits = 140;
                            2: outbits = 76;
                            3: outbits = 204;
                            4: outbits = 44;
                            5: outbits = 172;
                            6: outbits = 108;
                            7: outbits = 236;
                            8: outbits = 28;
                            9: outbits = 156;
                            10: outbits = 92;
                            11: outbits = 220;
                            12: outbits = 60;
                            13: outbits = 188;
                            14: outbits = 124;
                            15: outbits = 252;
                            16: outbits = 2;
                            17: outbits = 130;
                            18: outbits = 66;
                            19: outbits = 194;
                            20: outbits = 34;
                            21: outbits = 162;
                            22: outbits = 98;
                            23: outbits = 226;
                            24: outbits = 18;
                            25: outbits = 146;
                            26: outbits = 82;
                            27: outbits = 210;
                            28: outbits = 50;
                            29: outbits = 178;
                            30: outbits = 114;
                            31: outbits = 242;
                            32: outbits = 10;
                            33: outbits = 138;
                            34: outbits = 74;
                            35: outbits = 202;
                            36: outbits = 42;
                            37: outbits = 170;
                            38: outbits = 106;
                            39: outbits = 234;
                            40: outbits = 26;
                            41: outbits = 154;
                            42: outbits = 90;
                            43: outbits = 218;
                            44: outbits = 58;
                            45: outbits = 186;
                            46: outbits = 122;
                            47: outbits = 250;
                            48: outbits = 6;
                            49: outbits = 134;
                            50: outbits = 70;
                            51: outbits = 198;
                            52: outbits = 38;
                            53: outbits = 166;
                            54: outbits = 102;
                            55: outbits = 230;
                            56: outbits = 22;
                            57: outbits = 150;
                            58: outbits = 86;
                            59: outbits = 214;
                            60: outbits = 54;
                            61: outbits = 182;
                            62: outbits = 118;
                            63: outbits = 246;
                            64: outbits = 14;
                            65: outbits = 142;
                            66: outbits = 78;
                            67: outbits = 206;
                            68: outbits = 46;
                            69: outbits = 174;
                            70: outbits = 110;
                            71: outbits = 238;
                            72: outbits = 30;
                            73: outbits = 158;
                            74: outbits = 94;
                            75: outbits = 222;
                            76: outbits = 62;
                            77: outbits = 190;
                            78: outbits = 126;
                            79: outbits = 254;
                            80: outbits = 1;
                            81: outbits = 129;
                            82: outbits = 65;
                            83: outbits = 193;
                            84: outbits = 33;
                            85: outbits = 161;
                            86: outbits = 97;
                            87: outbits = 225;
                            88: outbits = 17;
                            89: outbits = 145;
                            90: outbits = 81;
                            91: outbits = 209;
                            92: outbits = 49;
                            93: outbits = 177;
                            94: outbits = 113;
                            95: outbits = 241;
                            96: outbits = 9;
                            97: outbits = 137;
                            98: outbits = 73;
                            99: outbits = 201;
                            100: outbits = 41;
                            101: outbits = 169;
                            102: outbits = 105;
                            103: outbits = 233;
                            104: outbits = 25;
                            105: outbits = 153;
                            106: outbits = 89;
                            107: outbits = 217;
                            108: outbits = 57;
                            109: outbits = 185;
                            110: outbits = 121;
                            111: outbits = 249;
                            112: outbits = 5;
                            113: outbits = 133;
                            114: outbits = 69;
                            115: outbits = 197;
                            116: outbits = 37;
                            117: outbits = 165;
                            118: outbits = 101;
                            119: outbits = 229;
                            120: outbits = 21;
                            121: outbits = 149;
                            122: outbits = 85;
                            123: outbits = 213;
                            124: outbits = 53;
                            125: outbits = 181;
                            126: outbits = 117;
                            127: outbits = 245;
                            128: outbits = 13;
                            129: outbits = 141;
                            130: outbits = 77;
                            131: outbits = 205;
                            132: outbits = 45;
                            133: outbits = 173;
                            134: outbits = 109;
                            135: outbits = 237;
                            136: outbits = 29;
                            137: outbits = 157;
                            138: outbits = 93;
                            139: outbits = 221;
                            140: outbits = 61;
                            141: outbits = 189;
                            142: outbits = 125;
                            143: outbits = 253;
                            144: outbits = 19;
                            145: outbits = 275;
                            146: outbits = 147;
                            147: outbits = 403;
                            148: outbits = 83;
                            149: outbits = 339;
                            150: outbits = 211;
                            151: outbits = 467;
                            152: outbits = 51;
                            153: outbits = 307;
                            154: outbits = 179;
                            155: outbits = 435;
                            156: outbits = 115;
                            157: outbits = 371;
                            158: outbits = 243;
                            159: outbits = 499;
                            160: outbits = 11;
                            161: outbits = 267;
                            162: outbits = 139;
                            163: outbits = 395;
                            164: outbits = 75;
                            165: outbits = 331;
                            166: outbits = 203;
                            167: outbits = 459;
                            168: outbits = 43;
                            169: outbits = 299;
                            170: outbits = 171;
                            171: outbits = 427;
                            172: outbits = 107;
                            173: outbits = 363;
                            174: outbits = 235;
                            175: outbits = 491;
                            176: outbits = 27;
                            177: outbits = 283;
                            178: outbits = 155;
                            179: outbits = 411;
                            180: outbits = 91;
                            181: outbits = 347;
                            182: outbits = 219;
                            183: outbits = 475;
                            184: outbits = 59;
                            185: outbits = 315;
                            186: outbits = 187;
                            187: outbits = 443;
                            188: outbits = 123;
                            189: outbits = 379;
                            190: outbits = 251;
                            191: outbits = 507;
                            192: outbits = 7;
                            193: outbits = 263;
                            194: outbits = 135;
                            195: outbits = 391;
                            196: outbits = 71;
                            197: outbits = 327;
                            198: outbits = 199;
                            199: outbits = 455;
                            200: outbits = 39;
                            201: outbits = 295;
                            202: outbits = 167;
                            203: outbits = 423;
                            204: outbits = 103;
                            205: outbits = 359;
                            206: outbits = 231;
                            207: outbits = 487;
                            208: outbits = 23;
                            209: outbits = 279;
                            210: outbits = 151;
                            211: outbits = 407;
                            212: outbits = 87;
                            213: outbits = 343;
                            214: outbits = 215;
                            215: outbits = 471;
                            216: outbits = 55;
                            217: outbits = 311;
                            218: outbits = 183;
                            219: outbits = 439;
                            220: outbits = 119;
                            221: outbits = 375;
                            222: outbits = 247;
                            223: outbits = 503;
                            224: outbits = 15;
                            225: outbits = 271;
                            226: outbits = 143;
                            227: outbits = 399;
                            228: outbits = 79;
                            229: outbits = 335;
                            230: outbits = 207;
                            231: outbits = 463;
                            232: outbits = 47;
                            233: outbits = 303;
                            234: outbits = 175;
                            235: outbits = 431;
                            236: outbits = 111;
                            237: outbits = 367;
                            238: outbits = 239;
                            239: outbits = 495;
                            240: outbits = 31;
                            241: outbits = 287;
                            242: outbits = 159;
                            243: outbits = 415;
                            244: outbits = 95;
                            245: outbits = 351;
                            246: outbits = 223;
                            247: outbits = 479;
                            248: outbits = 63;
                            249: outbits = 319;
                            250: outbits = 191;
                            251: outbits = 447;
                            252: outbits = 127;
                            253: outbits = 383;
                            254: outbits = 255;
                            255: outbits = 511;
                            256: outbits = 0;
                            257: outbits = 64;
                            258: outbits = 32;
                            259: outbits = 96;
                            260: outbits = 16;
                            261: outbits = 80;
                            262: outbits = 48;
                            263: outbits = 112;
                            264: outbits = 8;
                            265: outbits = 72;
                            266: outbits = 40;
                            267: outbits = 104;
                            268: outbits = 24;
                            269: outbits = 88;
                            270: outbits = 56;
                            271: outbits = 120;
                            272: outbits = 4;
                            273: outbits = 68;
                            274: outbits = 36;
                            275: outbits = 100;
                            276: outbits = 20;
                            277: outbits = 84;
                            278: outbits = 52;
                            279: outbits = 116;
                            280: outbits = 3;
                            281: outbits = 131;
                            282: outbits = 67;
                            283: outbits = 195;
                            284: outbits = 35;
                            285: outbits = 163;
                            286: outbits = 99;
                            default: outbits = 227;
                        endcase
                        MYHDL21_put(outbits, outlen);
                        deflate0_state <= 5'b10110;
                    end
                end
            end
            5'b11000: begin
                mdone = 1'b1;
                limit = 5;
                if (1'b1) begin
                    limit = 10;
                end
                if ((deflate0_more <= limit)) begin
                    cbyte = deflate0_b4;
                    case (deflate0_more)
                        'h5: begin
                            cbyte = deflate0_b5;
                        end
                        'h6: begin
                            cbyte = deflate0_b6;
                        end
                        'h7: begin
                            cbyte = deflate0_b7;
                        end
                        'h8: begin
                            cbyte = deflate0_b8;
                        end
                        'h9: begin
                            cbyte = deflate0_b9;
                        end
                        'ha: begin
                            cbyte = deflate0_b10;
                        end
                    endcase
                    if ((($signed({1'b0, deflate0_di}) < ($signed({1'b0, deflate0_isize}) - $signed({1'b0, deflate0_more}))) && (deflate0_iram[(((deflate0_cur_search + $signed({1'b0, deflate0_more})) - 1) & 511)] == cbyte))) begin
                        deflate0_more <= (deflate0_more + 1);
                        mdone = 1'b0;
                    end
                end
                if (mdone) begin
                    match = (deflate0_more - 1);
                    distance = ($signed({1'b0, deflate0_di}) - deflate0_cur_search);
                    deflate0_cur_dist <= distance;
                    deflate0_do_init <= 1'b1;
                    deflate0_di <= (deflate0_di + match);
                    deflate0_mlength <= match;
                    deflate0_state <= 5'b11010;
                end
            end
            5'b01110: begin
                for (stat_i=0; stat_i<144; stat_i=stat_i+1) begin
                    deflate0_codeLength[stat_i] <= 8;
                end
                for (stat_i=144; stat_i<256; stat_i=stat_i+1) begin
                    deflate0_codeLength[stat_i] <= 9;
                end
                for (stat_i=256; stat_i<280; stat_i=stat_i+1) begin
                    deflate0_codeLength[stat_i] <= 7;
                end
                for (stat_i=280; stat_i<288; stat_i=stat_i+1) begin
                    deflate0_codeLength[stat_i] <= 8;
                end
                deflate0_numCodeLength <= 288;
                if (deflate0_do_compress) begin
                    deflate0_state <= 5'b10110;
                end
                else begin
                    deflate0_cur_HF1 <= 0;
                    deflate0_state <= 5'b00111;
                end
            end
            5'b00010: begin
                if (((!1'b0) || (!1'b1))) begin
                    // pass
                end
                else if ((!deflate0_filled)) begin
                    deflate0_filled <= 1'b1;
                end
                else if ((deflate0_numLiterals == 0)) begin
                    $write("%h", deflate0_di);
                    $write(" ");
                    $write("%h", deflate0_isize);
                    $write("\n");
                    deflate0_numLiterals <= (257 + MYHDL30_get4(0, 5));
                    $write("NL:");
                    $write(" ");
                    $write("%0d", (257 + MYHDL31_get4(0, 5)));
                    $write("\n");
                    deflate0_numDistance <= (1 + MYHDL32_get4(5, 5));
                    $write("ND:");
                    $write(" ");
                    $write("%0d", (1 + MYHDL33_get4(5, 5)));
                    $write("\n");
                    deflate0_b_numCodeLength <= (4 + MYHDL34_get4(10, 4));
                    $write("NCL:");
                    $write(" ");
                    $write("%0d", (4 + MYHDL35_get4(10, 4)));
                    $write("\n");
                    deflate0_numCodeLength <= 0;
                    MYHDL36_adv(14);
                end
                else begin
                    if ((deflate0_numCodeLength < 19)) begin
                        case (deflate0_numCodeLength)
                            0: clo_i = 16;
                            1: clo_i = 17;
                            2: clo_i = 18;
                            3: clo_i = 0;
                            4: clo_i = 8;
                            5: clo_i = 7;
                            6: clo_i = 9;
                            7: clo_i = 6;
                            8: clo_i = 10;
                            9: clo_i = 5;
                            10: clo_i = 11;
                            11: clo_i = 4;
                            12: clo_i = 12;
                            13: clo_i = 3;
                            14: clo_i = 13;
                            15: clo_i = 2;
                            16: clo_i = 14;
                            17: clo_i = 1;
                            default: clo_i = 15;
                        endcase
                        if ((deflate0_numCodeLength < deflate0_b_numCodeLength)) begin
                            deflate0_codeLength[clo_i] <= MYHDL37_get4(0, 3);
                            MYHDL38_adv(3);
                        end
                        else begin
                            deflate0_codeLength[clo_i] <= 0;
                        end
                        deflate0_numCodeLength <= (deflate0_numCodeLength + 1);
                    end
                    else begin
                        deflate0_numCodeLength <= 19;
                        deflate0_cur_HF1 <= 0;
                        deflate0_state <= 5'b00111;
                    end
                end
            end
            5'b00011: begin
                if (((!1'b0) || (!1'b1))) begin
                    // pass
                end
                else if ((!deflate0_filled)) begin
                    deflate0_filled <= 1'b1;
                end
                else if ((deflate0_numCodeLength < (deflate0_numLiterals + deflate0_numDistance))) begin
                    n_adv = 0;
                    if ((deflate0_code < 16)) begin
                        deflate0_howOften <= 1;
                        deflate0_lastToken <= deflate0_code;
                    end
                    else if ((deflate0_code == 16)) begin
                        deflate0_howOften <= (3 + MYHDL39_get4(0, 2));
                        n_adv = 2;
                    end
                    else if ((deflate0_code == 17)) begin
                        deflate0_howOften <= (3 + MYHDL40_get4(0, 3));
                        deflate0_lastToken <= 0;
                        n_adv = 3;
                    end
                    else if ((deflate0_code == 18)) begin
                        deflate0_howOften <= (11 + MYHDL41_get4(0, 7));
                        deflate0_lastToken <= 0;
                        n_adv = 7;
                    end
                    else begin
                    end
                    if ((n_adv != 0)) begin
                        MYHDL42_adv(n_adv);
                    end
                    deflate0_state <= 5'b00100;
                end
                else begin
                    $write("FILL UP");
                    $write("\n");
                    for (dbl_i=0; dbl_i<32; dbl_i=dbl_i+1) begin
                        dbl = 0;
                        if (((dbl_i + $signed({1'b0, deflate0_numLiterals})) < deflate0_numCodeLength)) begin
                            dbl = deflate0_codeLength[(dbl_i + $signed({1'b0, deflate0_numLiterals}))];
                        end
                        deflate0_distanceLength[dbl_i] <= dbl;
                    end
                    deflate0_cur_i <= deflate0_numLiterals;
                    deflate0_state <= 5'b00110;
                end
            end
            5'b00110: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if ((deflate0_cur_i < 320)) begin
                    deflate0_codeLength[deflate0_cur_i] <= 0;
                    deflate0_cur_i <= (deflate0_cur_i + 1);
                end
                else begin
                    deflate0_method <= 3;
                    deflate0_cur_HF1 <= 0;
                    deflate0_state <= 5'b00111;
                end
            end
            5'b00101: begin
                if ((1'b0 && 1'b1)) begin
                    $write("DISTTREE");
                    $write("\n");
                    for (dist_i=0; dist_i<32; dist_i=dist_i+1) begin
                        deflate0_codeLength[dist_i] <= deflate0_distanceLength[dist_i];
                    end
                    deflate0_numCodeLength <= 32;
                    deflate0_method <= 4;
                    deflate0_cur_HF1 <= 0;
                    deflate0_state <= 5'b00111;
                end
            end
            5'b00100: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if ((deflate0_howOften != 0)) begin
                    deflate0_codeLength[deflate0_numCodeLength] <= deflate0_lastToken;
                    deflate0_howOften <= (deflate0_howOften - 1);
                    deflate0_numCodeLength <= (deflate0_numCodeLength + 1);
                end
                else if ((deflate0_numCodeLength < (deflate0_numLiterals + deflate0_numDistance))) begin
                    deflate0_cur_next <= 0;
                    deflate0_state <= 5'b10011;
                end
                else begin
                    deflate0_state <= 5'b00011;
                end
            end
            5'b00111: begin
                if (1'b0) begin
                    if ((deflate0_cur_HF1 < 16)) begin
                        deflate0_bitLengthCount[deflate0_cur_HF1] <= 0;
                    end
                    if (((deflate0_cur_HF1 < 1) && 1'b1)) begin
                        deflate0_dlwaddr <= deflate0_cur_HF1;
                        deflate0_dwleaf <= 0;
                    end
                    if (((deflate0_method != 4) && (deflate0_cur_HF1 < 1))) begin
                        deflate0_lwaddr <= deflate0_cur_HF1;
                        deflate0_wleaf <= 0;
                    end
                    limit = 1;
                    if (((deflate0_method == 4) && 1'b1)) begin
                        limit = 1;
                    end
                    if ((deflate0_cur_HF1 < limit)) begin
                        deflate0_cur_HF1 <= (deflate0_cur_HF1 + 1);
                    end
                    else begin
                        $write("DID HF1 INIT");
                        $write("\n");
                        deflate0_cur_i <= 0;
                        deflate0_state <= 5'b01000;
                    end
                end
            end
            5'b01000: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if ((deflate0_cur_i < deflate0_numCodeLength)) begin
                    j = deflate0_codeLength[deflate0_cur_i];
                    deflate0_bitLengthCount[j] <= (deflate0_bitLengthCount[j] + 1);
                    deflate0_cur_i <= (deflate0_cur_i + 1);
                end
                else begin
                    deflate0_bitLengthCount[0] <= 0;
                    deflate0_state <= 5'b01001;
                    deflate0_cur_i <= 1;
                    if ((deflate0_method == 4)) begin
                        deflate0_d_maxBits <= 0;
                    end
                    else begin
                        deflate0_maxBits <= 0;
                    end
                    deflate0_minBits <= 15;
                end
            end
            5'b01001: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if ((deflate0_cur_i <= 15)) begin
                    if ((deflate0_bitLengthCount[deflate0_cur_i] != 0)) begin
                        if ((deflate0_cur_i < deflate0_minBits)) begin
                            deflate0_minBits <= deflate0_cur_i;
                        end
                        if ((deflate0_method == 4)) begin
                            if ((deflate0_cur_i > deflate0_d_maxBits)) begin
                                deflate0_d_maxBits <= deflate0_cur_i;
                            end
                        end
                        else begin
                            if ((deflate0_cur_i > deflate0_maxBits)) begin
                                deflate0_maxBits <= deflate0_cur_i;
                            end
                        end
                    end
                    deflate0_cur_i <= (deflate0_cur_i + 1);
                end
                else begin
                    $write("%h", deflate0_minBits);
                    $write(" ");
                    $write("%h", deflate0_maxBits);
                    $write("\n");
                    t = 10;
                    if (((deflate0_method == 4) && 1'b1)) begin
                        if ((t > deflate0_d_maxBits)) begin
                            t = deflate0_d_maxBits;
                        end
                        deflate0_d_instantMaxBit <= t;
                        deflate0_d_instantMask <= ((1 << t) - 1);
                    end
                    else begin
                        if ((t > deflate0_maxBits)) begin
                            t = deflate0_maxBits;
                        end
                        deflate0_instantMaxBit <= t;
                        deflate0_instantMask <= ((1 << t) - 1);
                    end
                    $write("%0d", ((1 << t) - 1));
                    $write("\n");
                    deflate0_state <= 5'b01010;
                    deflate0_cur_i <= deflate0_minBits;
                    deflate0_code <= 0;
                    for (hf2_i=0; hf2_i<16; hf2_i=hf2_i+1) begin
                        deflate0_nextCode[hf2_i] <= 0;
                    end
                    $write("to HF3");
                    $write("\n");
                end
            end
            5'b01010: begin
                if (1'b0) begin
                    amb = deflate0_maxBits;
                    if (((deflate0_method == 4) && 1'b1)) begin
                        amb = deflate0_d_maxBits;
                    end
                    if ((deflate0_cur_i <= amb)) begin
                        ncode = ((deflate0_code + deflate0_bitLengthCount[($signed({1'b0, deflate0_cur_i}) - 1)]) << 1);
                        deflate0_code <= ncode;
                        deflate0_nextCode[deflate0_cur_i] <= ncode;
                        deflate0_cur_i <= (deflate0_cur_i + 1);
                    end
                    else begin
                        deflate0_state <= 5'b01011;
                        deflate0_cur_i <= 0;
                        deflate0_spread_i <= 0;
                        $write("to HF4");
                        $write("\n");
                    end
                end
            end
            5'b01100: begin
                if (1'b0) begin
                    canonical = deflate0_nextCode[deflate0_bits];
                    deflate0_nextCode[deflate0_bits] <= (deflate0_nextCode[deflate0_bits] + 1);
                    deflate0_reverse <= MYHDL49_rev_bits(canonical, deflate0_bits);
                    deflate0_leaf <= MYHDL50_makeLeaf(deflate0_spread_i, deflate0_bits);
                    deflate0_state <= 5'b01101;
                end
            end
            5'b01101: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if (((deflate0_method == 4) && 1'b1)) begin
                    deflate0_dwleaf <= deflate0_leaf;
                    deflate0_dlwaddr <= deflate0_reverse;
                    if ((deflate0_bits <= deflate0_d_instantMaxBit)) begin
                        if (((deflate0_reverse + (1 << deflate0_bits)) <= deflate0_d_instantMask)) begin
                            deflate0_step <= (1 << deflate0_bits);
                            deflate0_spread <= (deflate0_reverse + (1 << deflate0_bits));
                            deflate0_state <= 5'b10010;
                        end
                        else begin
                            deflate0_spread_i <= (deflate0_spread_i + 1);
                            deflate0_state <= 5'b01011;
                        end
                    end
                    else begin
                        deflate0_state <= 5'b01011;
                        deflate0_spread_i <= (deflate0_spread_i + 1);
                    end
                end
                else begin
                    deflate0_wleaf <= deflate0_leaf;
                    deflate0_lwaddr <= deflate0_reverse;
                    if ((deflate0_bits <= deflate0_instantMaxBit)) begin
                        if (((deflate0_reverse + (1 << deflate0_bits)) <= deflate0_instantMask)) begin
                            deflate0_step <= (1 << deflate0_bits);
                            deflate0_spread <= (deflate0_reverse + (1 << deflate0_bits));
                            deflate0_state <= 5'b10010;
                        end
                        else begin
                            deflate0_spread_i <= (deflate0_spread_i + 1);
                            deflate0_state <= 5'b01011;
                        end
                    end
                    else begin
                        deflate0_spread_i <= (deflate0_spread_i + 1);
                        deflate0_state <= 5'b01011;
                    end
                end
            end
            5'b01011: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if ((deflate0_spread_i < deflate0_numCodeLength)) begin
                    bits_next = deflate0_codeLength[deflate0_spread_i];
                    if ((bits_next != 0)) begin
                        deflate0_bits <= bits_next;
                        deflate0_state <= 5'b01100;
                    end
                    else begin
                        deflate0_spread_i <= (deflate0_spread_i + 1);
                    end
                end
                else begin
                    if (deflate0_do_compress) begin
                        deflate0_state <= 5'b10110;
                        deflate0_cur_cstatic <= 0;
                    end
                    else if (((deflate0_method == 3) && 1'b1)) begin
                        deflate0_state <= 5'b00101;
                    end
                    else if (((deflate0_method == 4) && 1'b1)) begin
                        $write("DEFLATE m2!");
                        $write("\n");
                        deflate0_state <= 5'b10011;
                    end
                    else if (((deflate0_method == 2) && 1'b1)) begin
                        deflate0_numCodeLength <= 0;
                        deflate0_state <= 5'b10011;
                    end
                    else begin
                        deflate0_state <= 5'b10011;
                    end
                    deflate0_cur_next <= 0;
                    deflate0_cur_i <= 0;
                end
            end
            5'b10010: begin
                if (1'b0) begin
                    if (((deflate0_method == 4) && 1'b1)) begin
                        deflate0_dlwaddr <= deflate0_spread;
                        deflate0_dwleaf <= MYHDL51_makeLeaf(deflate0_spread_i, deflate0_codeLength[deflate0_spread_i]);
                    end
                    else begin
                        deflate0_lwaddr <= deflate0_spread;
                        deflate0_wleaf <= MYHDL52_makeLeaf(deflate0_spread_i, deflate0_codeLength[deflate0_spread_i]);
                    end
                    aim = deflate0_instantMask;
                    if (((deflate0_method == 4) && 1'b1)) begin
                        aim = deflate0_d_instantMask;
                    end
                    if (($signed({1'b0, deflate0_spread}) > ($signed({1'b0, aim}) - $signed({1'b0, deflate0_step})))) begin
                        deflate0_spread_i <= (deflate0_spread_i + 1);
                        deflate0_state <= 5'b01011;
                    end
                    else begin
                        deflate0_spread <= (deflate0_spread + deflate0_step);
                    end
                end
            end
            5'b10011: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if ((!deflate0_filled)) begin
                    deflate0_filled <= 1'b1;
                end
                else if ((deflate0_cur_next == 0)) begin
                    cto = MYHDL53_get4(0, deflate0_maxBits);
                    mask = ((1 << deflate0_instantMaxBit) - 1);
                    deflate0_lraddr <= (cto & mask);
                    deflate0_filled <= 1'b0;
                    deflate0_cur_next <= (deflate0_instantMaxBit + 1);
                end
                else if ((1'b1 && (MYHDL54_get_bits(deflate0_rleaf) >= deflate0_cur_next))) begin
                    $write("CACHE MISS");
                    $write(" ");
                    $write("%h", deflate0_cur_next);
                    $write("\n");
                    cto = MYHDL55_get4(0, deflate0_maxBits);
                    mask = ((1 << deflate0_cur_next) - 1);
                    deflate0_lraddr <= (cto & mask);
                    deflate0_filled <= 1'b0;
                    deflate0_cur_next <= (deflate0_cur_next + 1);
                end
                else begin
                    MYHDL58_adv(MYHDL57_get_bits(deflate0_rleaf));
                    // if get_code(leaf) == 0:
                    //     print("leaf 0", di, isize)
                    deflate0_code <= MYHDL59_get_code(deflate0_rleaf);
                    if (((deflate0_method == 2) && 1'b1)) begin
                        deflate0_state <= 5'b00011;
                    end
                    else begin
                        deflate0_state <= 5'b10100;
                    end
                end
            end
            5'b01111: begin
                if (((!1'b0) || (!1'b1))) begin
                    // pass
                end
                else if ((!deflate0_filled)) begin
                    deflate0_filled <= 1'b1;
                end
                else if ((deflate0_cur_next == 0)) begin
                    token = (deflate0_code - 257);
                    case (token)
                        0: extraLength = 0;
                        1: extraLength = 0;
                        2: extraLength = 0;
                        3: extraLength = 0;
                        4: extraLength = 0;
                        5: extraLength = 0;
                        6: extraLength = 0;
                        7: extraLength = 0;
                        8: extraLength = 1;
                        9: extraLength = 1;
                        10: extraLength = 1;
                        11: extraLength = 1;
                        12: extraLength = 2;
                        13: extraLength = 2;
                        14: extraLength = 2;
                        15: extraLength = 2;
                        16: extraLength = 3;
                        17: extraLength = 3;
                        18: extraLength = 3;
                        19: extraLength = 3;
                        20: extraLength = 4;
                        21: extraLength = 4;
                        22: extraLength = 4;
                        23: extraLength = 4;
                        24: extraLength = 5;
                        25: extraLength = 5;
                        26: extraLength = 5;
                        27: extraLength = 5;
                        default: extraLength = 0;
                    endcase
                    cto = MYHDL60_get4(extraLength, deflate0_d_maxBits);
                    mask = ((1 << deflate0_d_instantMaxBit) - 1);
                    deflate0_dlraddr <= (cto & mask);
                    deflate0_filled <= 1'b0;
                    deflate0_cur_next <= (deflate0_instantMaxBit + 1);
                end
                else if ((MYHDL61_get_bits(deflate0_drleaf) >= deflate0_cur_next)) begin
                    $write("DCACHE MISS");
                    $write(" ");
                    $write("%h", deflate0_cur_next);
                    $write("\n");
                    token = (deflate0_code - 257);
                    case (token)
                        0: extraLength = 0;
                        1: extraLength = 0;
                        2: extraLength = 0;
                        3: extraLength = 0;
                        4: extraLength = 0;
                        5: extraLength = 0;
                        6: extraLength = 0;
                        7: extraLength = 0;
                        8: extraLength = 1;
                        9: extraLength = 1;
                        10: extraLength = 1;
                        11: extraLength = 1;
                        12: extraLength = 2;
                        13: extraLength = 2;
                        14: extraLength = 2;
                        15: extraLength = 2;
                        16: extraLength = 3;
                        17: extraLength = 3;
                        18: extraLength = 3;
                        19: extraLength = 3;
                        20: extraLength = 4;
                        21: extraLength = 4;
                        22: extraLength = 4;
                        23: extraLength = 4;
                        24: extraLength = 5;
                        25: extraLength = 5;
                        26: extraLength = 5;
                        27: extraLength = 5;
                        default: extraLength = 0;
                    endcase
                    cto = MYHDL62_get4(extraLength, deflate0_d_maxBits);
                    mask = ((1 << deflate0_cur_next) - 1);
                    deflate0_dlraddr <= (cto & mask);
                    deflate0_filled <= 1'b0;
                    deflate0_cur_next <= (deflate0_cur_next + 1);
                end
                else begin
                    deflate0_state <= 5'b10000;
                end
            end
            5'b10000: begin
                if ((1'b0 && 1'b1)) begin
                    token = (deflate0_code - 257);
                    case (token)
                        0: tlength = 3;
                        1: tlength = 4;
                        2: tlength = 5;
                        3: tlength = 6;
                        4: tlength = 7;
                        5: tlength = 8;
                        6: tlength = 9;
                        7: tlength = 10;
                        8: tlength = 11;
                        9: tlength = 13;
                        10: tlength = 15;
                        11: tlength = 17;
                        12: tlength = 19;
                        13: tlength = 23;
                        14: tlength = 27;
                        15: tlength = 31;
                        16: tlength = 35;
                        17: tlength = 43;
                        18: tlength = 51;
                        19: tlength = 59;
                        20: tlength = 67;
                        21: tlength = 83;
                        22: tlength = 99;
                        23: tlength = 115;
                        24: tlength = 131;
                        25: tlength = 163;
                        26: tlength = 195;
                        27: tlength = 227;
                        default: tlength = 258;
                    endcase
                    case (token)
                        0: extraLength = 0;
                        1: extraLength = 0;
                        2: extraLength = 0;
                        3: extraLength = 0;
                        4: extraLength = 0;
                        5: extraLength = 0;
                        6: extraLength = 0;
                        7: extraLength = 0;
                        8: extraLength = 1;
                        9: extraLength = 1;
                        10: extraLength = 1;
                        11: extraLength = 1;
                        12: extraLength = 2;
                        13: extraLength = 2;
                        14: extraLength = 2;
                        15: extraLength = 2;
                        16: extraLength = 3;
                        17: extraLength = 3;
                        18: extraLength = 3;
                        19: extraLength = 3;
                        20: extraLength = 4;
                        21: extraLength = 4;
                        22: extraLength = 4;
                        23: extraLength = 4;
                        24: extraLength = 5;
                        25: extraLength = 5;
                        26: extraLength = 5;
                        27: extraLength = 5;
                        default: extraLength = 0;
                    endcase
                    tlength = tlength + MYHDL64_get4(0, extraLength);
                    distanceCode = MYHDL65_get_code(deflate0_drleaf);
                    case (distanceCode)
                        0: distance = 1;
                        1: distance = 2;
                        2: distance = 3;
                        3: distance = 4;
                        4: distance = 5;
                        5: distance = 7;
                        6: distance = 9;
                        7: distance = 13;
                        8: distance = 17;
                        9: distance = 25;
                        10: distance = 33;
                        11: distance = 49;
                        12: distance = 65;
                        13: distance = 97;
                        14: distance = 129;
                        15: distance = 193;
                        16: distance = 257;
                        17: distance = 385;
                        18: distance = 513;
                        19: distance = 769;
                        20: distance = 1025;
                        21: distance = 1537;
                        22: distance = 2049;
                        23: distance = 3073;
                        24: distance = 4097;
                        25: distance = 6145;
                        26: distance = 8193;
                        27: distance = 12289;
                        28: distance = 16385;
                        default: distance = 24577;
                    endcase
                    case ($signed(distanceCode >>> 1))
                        0: moreBits = 0;
                        1: moreBits = 0;
                        2: moreBits = 1;
                        3: moreBits = 2;
                        4: moreBits = 3;
                        5: moreBits = 4;
                        6: moreBits = 5;
                        7: moreBits = 6;
                        8: moreBits = 7;
                        9: moreBits = 8;
                        10: moreBits = 9;
                        11: moreBits = 10;
                        12: moreBits = 11;
                        13: moreBits = 12;
                        default: moreBits = 13;
                    endcase
                    mored = MYHDL67_get4((extraLength + MYHDL66_get_bits(deflate0_drleaf)), moreBits);
                    distance = distance + mored;
                    MYHDL69_adv(((moreBits + extraLength) + MYHDL68_get_bits(deflate0_drleaf)));
                    deflate0_offset <= (($signed({1'b0, deflate0_do}) - distance) & 8191);
                    deflate0_length <= tlength;
                    deflate0_cur_i <= 0;
                    deflate0_oraddr <= ($signed({1'b0, deflate0_do}) - distance);
                    deflate0_state <= 5'b10101;
                end
            end
            5'b10100: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if (((deflate0_method == 1) && (!deflate0_filled))) begin
                    deflate0_filled <= 1'b1;
                end
                else if ((($signed({1'b0, deflate0_di}) >= ($signed({1'b0, deflate0_isize}) - 4)) && (!(i_mode == 0)))) begin
                    // pass
                end
                else if ((deflate0_do >= (i_raddr + 8192))) begin
                    // pass
                end
                else if (($signed({1'b0, deflate0_di}) > ($signed({1'b0, deflate0_isize}) - 3))) begin
                    deflate0_state <= 5'b00000;
                    o_done <= 1'b1;
                    $write("NO EOF ");
                    $write(" ");
                    $write("%h", deflate0_di);
                    $write("\n");
                end
                else if ((deflate0_code == 256)) begin
                    $write("EOF:");
                    $write(" ");
                    $write("%h", deflate0_di);
                    $write(" ");
                    $write("%h", deflate0_do);
                    $write("\n");
                    if ((!deflate0_final)) begin
                        deflate0_state <= 5'b00001;
                        deflate0_filled <= 1'b0;
                        $write("New Block!");
                        $write("\n");
                    end
                    else begin
                        o_done <= 1'b1;
                        deflate0_state <= 5'b00000;
                    end
                end
                else begin
                    if ((deflate0_code < 256)) begin
                        deflate0_oaddr <= deflate0_do;
                        deflate0_obyte <= deflate0_code;
                        o_oprogress <= (deflate0_do + 1);
                        deflate0_do <= (deflate0_do + 1);
                        deflate0_cur_next <= 0;
                        deflate0_state <= 5'b10011;
                    end
                    else if ((deflate0_code == 300)) begin
                    end
                    else begin
                        if (deflate0_static) begin
                            token = (deflate0_code - 257);
                            case (token)
                                0: tlength = 3;
                                1: tlength = 4;
                                2: tlength = 5;
                                3: tlength = 6;
                                4: tlength = 7;
                                5: tlength = 8;
                                6: tlength = 9;
                                7: tlength = 10;
                                8: tlength = 11;
                                9: tlength = 13;
                                10: tlength = 15;
                                11: tlength = 17;
                                12: tlength = 19;
                                13: tlength = 23;
                                14: tlength = 27;
                                15: tlength = 31;
                                16: tlength = 35;
                                17: tlength = 43;
                                18: tlength = 51;
                                19: tlength = 59;
                                20: tlength = 67;
                                21: tlength = 83;
                                22: tlength = 99;
                                23: tlength = 115;
                                24: tlength = 131;
                                25: tlength = 163;
                                26: tlength = 195;
                                27: tlength = 227;
                                default: tlength = 258;
                            endcase
                            case (token)
                                0: extraLength = 0;
                                1: extraLength = 0;
                                2: extraLength = 0;
                                3: extraLength = 0;
                                4: extraLength = 0;
                                5: extraLength = 0;
                                6: extraLength = 0;
                                7: extraLength = 0;
                                8: extraLength = 1;
                                9: extraLength = 1;
                                10: extraLength = 1;
                                11: extraLength = 1;
                                12: extraLength = 2;
                                13: extraLength = 2;
                                14: extraLength = 2;
                                15: extraLength = 2;
                                16: extraLength = 3;
                                17: extraLength = 3;
                                18: extraLength = 3;
                                19: extraLength = 3;
                                20: extraLength = 4;
                                21: extraLength = 4;
                                22: extraLength = 4;
                                23: extraLength = 4;
                                24: extraLength = 5;
                                25: extraLength = 5;
                                26: extraLength = 5;
                                27: extraLength = 5;
                                default: extraLength = 0;
                            endcase
                            tlength = tlength + MYHDL70_get4(0, extraLength);
                            t = MYHDL71_get4(extraLength, 5);
                            distanceCode = MYHDL72_rev_bits(t, 5);
                            case (distanceCode)
                                0: distance = 1;
                                1: distance = 2;
                                2: distance = 3;
                                3: distance = 4;
                                4: distance = 5;
                                5: distance = 7;
                                6: distance = 9;
                                7: distance = 13;
                                8: distance = 17;
                                9: distance = 25;
                                10: distance = 33;
                                11: distance = 49;
                                12: distance = 65;
                                13: distance = 97;
                                14: distance = 129;
                                15: distance = 193;
                                16: distance = 257;
                                17: distance = 385;
                                18: distance = 513;
                                19: distance = 769;
                                20: distance = 1025;
                                21: distance = 1537;
                                22: distance = 2049;
                                23: distance = 3073;
                                24: distance = 4097;
                                25: distance = 6145;
                                26: distance = 8193;
                                27: distance = 12289;
                                28: distance = 16385;
                                default: distance = 24577;
                            endcase
                            case ($signed(distanceCode >>> 1))
                                0: moreBits = 0;
                                1: moreBits = 0;
                                2: moreBits = 1;
                                3: moreBits = 2;
                                4: moreBits = 3;
                                5: moreBits = 4;
                                6: moreBits = 5;
                                7: moreBits = 6;
                                8: moreBits = 7;
                                9: moreBits = 8;
                                10: moreBits = 9;
                                11: moreBits = 10;
                                12: moreBits = 11;
                                13: moreBits = 12;
                                default: moreBits = 13;
                            endcase
                            distance = distance + MYHDL73_get4((extraLength + 5), moreBits);
                            MYHDL74_adv(((extraLength + 5) + moreBits));
                            deflate0_offset <= ($signed({1'b0, deflate0_do}) - distance);
                            deflate0_length <= tlength;
                            deflate0_cur_i <= 0;
                            deflate0_oraddr <= ($signed({1'b0, deflate0_do}) - distance);
                            deflate0_state <= 5'b10101;
                        end
                        else begin
                            if ((!1'b1)) begin
                                $write("DYNAMIC mode disabled");
                                $write("\n");
                            end
                            deflate0_state <= 5'b01111;
                        end
                    end
                    deflate0_cur_next <= 0;
                end
            end
            5'b10101: begin
                if ((!1'b0)) begin
                    // pass
                end
                else if (((deflate0_cur_i == 0) && ((deflate0_do + deflate0_length) >= (i_raddr + 8192)))) begin
                    // pass
                end
                else if (($signed({1'b0, deflate0_di}) >= ($signed({1'b0, deflate0_isize}) - 2))) begin
                    // pass
                end
                else if ((deflate0_method == 0)) begin
                    if ((!deflate0_filled)) begin
                        deflate0_filled <= 1'b1;
                    end
                    else if ((deflate0_cur_i < deflate0_length)) begin
                        deflate0_oaddr <= deflate0_do;
                        deflate0_obyte <= deflate0_b3;
                        MYHDL75_adv(8);
                        deflate0_cur_i <= (deflate0_cur_i + 1);
                        deflate0_do <= (deflate0_do + 1);
                        o_oprogress <= (deflate0_do + 1);
                    end
                    else if ((!deflate0_final)) begin
                        MYHDL76_adv(16);
                        deflate0_state <= 5'b00001;
                        deflate0_filled <= 1'b0;
                        $write("new block");
                        $write("\n");
                    end
                    else begin
                        o_done <= 1'b1;
                        deflate0_state <= 5'b00000;
                    end
                end
                else if ((deflate0_cur_i < (deflate0_length + 2))) begin
                    deflate0_oraddr <= (deflate0_offset + deflate0_cur_i);
                    if ((deflate0_cur_i == 1)) begin
                        deflate0_copy1 <= deflate0_orbyte;
                    end
                    if ((deflate0_cur_i == 3)) begin
                        deflate0_copy2 <= deflate0_orbyte;
                    end
                    if ((deflate0_cur_i > 1)) begin
                        if ((((deflate0_offset + deflate0_cur_i) & 8191) == ((deflate0_do + 1) & 8191))) begin
                            deflate0_obyte <= deflate0_copy1;
                        end
                        else if (((deflate0_cur_i == 3) || (((deflate0_offset + deflate0_cur_i) & 8191) != (deflate0_do & 8191)))) begin
                            deflate0_obyte <= deflate0_orbyte;
                        end
                        else if ((deflate0_cur_i > 2)) begin
                            if ((deflate0_cur_i & 1)) begin
                                deflate0_obyte <= deflate0_copy2;
                            end
                            else begin
                                deflate0_obyte <= deflate0_copy1;
                            end
                        end
                        else begin
                            deflate0_obyte <= deflate0_copy1;
                        end
                        deflate0_oaddr <= deflate0_do;
                        o_oprogress <= (deflate0_do + 1);
                        deflate0_do <= (deflate0_do + 1);
                    end
                    deflate0_cur_i <= (deflate0_cur_i + 1);
                end
                else begin
                    deflate0_cur_next <= 0;
                    deflate0_state <= 5'b10011;
                end
            end
            default: begin
                $write("unknown state?!");
                $write("\n");
                deflate0_state <= 5'b00000;
            end
        endcase
    end
end


always @(posedge i_clk) begin: TEST_DEFLATE_BENCH_DEFLATE0_FILL_BUF
    integer shift;
    reg [8-1:0] rb;
    if ((!reset)) begin
        $write("FILL RESET");
        $write("\n");
        deflate0_nb <= 0;
    end
    else begin
        if ((deflate0_isize < 4)) begin
            deflate0_nb <= 0;
            deflate0_old_di <= 0;
        end
        else if (((i_mode == 4) || (i_mode == 5))) begin
            deflate0_nb <= 0;
            deflate0_old_di <= 0;
        end
        else begin
            // if do_compress:
            //     print("FILL", di, old_di, nb, b1, b2, b3, b4)
            if (1'b0) begin
                shift = (($signed({1'b0, deflate0_di}) - $signed({1'b0, deflate0_old_di})) * 8);
                // if shift != 0:
                //     print("shift", shift, cwindow, b1, b2, b3, b4)
                if (1'b1) begin
                    deflate0_cwindow <= (($signed({1'b0, deflate0_cwindow}) << shift) | $signed($signed({1'b0, deflate0_b110}) >>> (80 - shift)));
                end
                else begin
                    deflate0_cwindow <= (($signed({1'b0, deflate0_cwindow}) << shift) | $signed($signed({1'b0, deflate0_b15}) >>> (40 - shift)));
                end
            end
            deflate0_b1 <= deflate0_iram[(deflate0_di & 511)];
            deflate0_b2 <= deflate0_iram[((deflate0_di + 1) & 511)];
            deflate0_b3 <= deflate0_iram[((deflate0_di + 2) & 511)];
            if ((deflate0_old_di == deflate0_di)) begin
                // if fcount < 9:
                //     print("fcount", fcount)
                deflate0_nb <= 1'b1;
                rb = deflate0_iram[((deflate0_di + deflate0_fcount) & 511)];
                if ((deflate0_fcount == 4)) begin
                    deflate0_b5 <= rb;
                    deflate0_fcount <= 5;
                end
                else if (1'b1) begin
                    case (deflate0_fcount)
                        'h5: begin
                            deflate0_b6 <= rb;
                        end
                        'h6: begin
                            deflate0_b7 <= rb;
                        end
                        'h7: begin
                            deflate0_b8 <= rb;
                        end
                        'h8: begin
                            deflate0_b9 <= rb;
                        end
                        'h9: begin
                            deflate0_b10 <= rb;
                        end
                    endcase
                    if ((deflate0_fcount < 10)) begin
                        deflate0_fcount <= (deflate0_fcount + 1);
                    end
                end
            end
            else begin
                deflate0_fcount <= 4;
                deflate0_b4 <= deflate0_iram[((deflate0_di + 3) & 511)];
            end
            deflate0_old_di <= deflate0_di;
        end
    end
end


always @(posedge i_clk) begin: TEST_DEFLATE_BENCH_DEFLATE0_BRAMWRITE
    deflate0_oram[deflate0_oaddr] <= deflate0_obyte;
    deflate0_leaves[deflate0_lwaddr] <= deflate0_wleaf;
    deflate0_d_leaves[deflate0_dlwaddr] <= deflate0_dwleaf;
end


always @(posedge i_clk) begin: TEST_DEFLATE_BENCH_DEFLATE0_BRAMREAD
    deflate0_orbyte <= deflate0_oram[deflate0_oraddr];
    deflate0_rleaf <= deflate0_leaves[deflate0_lraddr];
    deflate0_drleaf <= deflate0_d_leaves[deflate0_dlraddr];
end


always @(posedge i_clk) begin: TEST_DEFLATE_BENCH_COUNT
    if ((scounter == 0)) begin
        counter <= (counter + 1);
    end
    scounter <= (scounter + 1);
end


always @(posedge i_clk) begin: TEST_DEFLATE_BENCH_LOGIC
    integer ud1;
    integer ud2;
    if ((tstate == 5'b00000)) begin
        $write("RESET");
        $write(" ");
        $write("%h", counter);
        $write("\n");
        reset <= 0;
        led0_g <= 0;
        led1_b <= 0;
        led2_r <= 0;
        tbi <= 0;
        tstate <= 5'b00001;
    end
    else if (((22 > 2) && (scounter != 0))) begin
        // pass
    end
    else if ((tstate == 5'b00001)) begin
        if ((tbi < 1)) begin
            tbi <= (tbi + 1);
        end
        else begin
            reset <= 1;
            if (1'b0) begin
                tstate <= 5'b00010;
            end
            else begin
                tstate <= 5'b00111;
            end
            tbi <= 0;
        end
    end
    else if ((tstate == 5'b10001)) begin
        led0_g <= 1;
        led2_r <= 0;
        led1_b <= 0;
    end
    else if ((tstate == 5'b10000)) begin
        led0_g <= (!led0_g);
        led2_r <= (!led2_r);
        led1_b <= o_done;
    end
    else if ((tstate == 5'b00010)) begin
        if ((tbi < 88)) begin
            o_led <= tbi;
            led1_b <= o_done;
            led2_r <= (!led2_r);
            i_mode <= 2;
            case (tbi)
                0: i_data <= 120;
                1: i_data <= 156;
                2: i_data <= 117;
                3: i_data <= 207;
                4: i_data <= 187;
                5: i_data <= 9;
                6: i_data <= 128;
                7: i_data <= 64;
                8: i_data <= 0;
                9: i_data <= 4;
                10: i_data <= 209;
                11: i_data <= 86;
                12: i_data <= 214;
                13: i_data <= 14;
                14: i_data <= 220;
                15: i_data <= 243;
                16: i_data <= 223;
                17: i_data <= 129;
                18: i_data <= 29;
                19: i_data <= 216;
                20: i_data <= 128;
                21: i_data <= 102;
                22: i_data <= 7;
                23: i_data <= 7;
                24: i_data <= 246;
                25: i_data <= 31;
                26: i_data <= 24;
                27: i_data <= 9;
                28: i_data <= 10;
                29: i_data <= 59;
                30: i_data <= 19;
                31: i_data <= 78;
                32: i_data <= 246;
                33: i_data <= 36;
                34: i_data <= 237;
                35: i_data <= 87;
                36: i_data <= 173;
                37: i_data <= 77;
                38: i_data <= 71;
                39: i_data <= 187;
                40: i_data <= 235;
                41: i_data <= 217;
                42: i_data <= 169;
                43: i_data <= 215;
                44: i_data <= 219;
                45: i_data <= 111;
                46: i_data <= 59;
                47: i_data <= 239;
                48: i_data <= 146;
                49: i_data <= 247;
                50: i_data <= 144;
                51: i_data <= 247;
                52: i_data <= 152;
                53: i_data <= 247;
                54: i_data <= 148;
                55: i_data <= 247;
                56: i_data <= 156;
                57: i_data <= 247;
                58: i_data <= 146;
                59: i_data <= 247;
                60: i_data <= 154;
                61: i_data <= 247;
                62: i_data <= 6;
                63: i_data <= 28;
                64: i_data <= 98;
                65: i_data <= 130;
                66: i_data <= 211;
                67: i_data <= 0;
                68: i_data <= 53;
                69: i_data <= 72;
                70: i_data <= 13;
                71: i_data <= 84;
                72: i_data <= 131;
                73: i_data <= 213;
                74: i_data <= 128;
                75: i_data <= 53;
                76: i_data <= 104;
                77: i_data <= 13;
                78: i_data <= 92;
                79: i_data <= 131;
                80: i_data <= 183;
                81: i_data <= 124;
                82: i_data <= 188;
                83: i_data <= 15;
                84: i_data <= 106;
                85: i_data <= 67;
                86: i_data <= 122;
                default: i_data <= 80;
            endcase
            i_waddr <= tbi;
            tbi <= (tbi + 1);
        end
        else begin
            i_mode <= 0;
            led2_r <= 0;
            tstate <= 5'b00011;
        end
    end
    else if ((tstate == 5'b00011)) begin
        i_mode <= 5;
        tstate <= 5'b00100;
    end
    else if ((tstate == 5'b00100)) begin
        led1_b <= (!led1_b);
        i_mode <= 0;
        if (((i_mode == 0) && o_done)) begin
            $write("result len");
            $write(" ");
            $write("%h", o_oprogress);
            $write("\n");
            resultlen <= o_oprogress;
            tbi <= 0;
            i_raddr <= 0;
            i_mode <= 3;
            wtick <= 1'b1;
            tstate <= 5'b00101;
        end
    end
    else if ((tstate == 5'b00101)) begin
        led1_b <= 0;
        o_led <= tbi;
        // Note that the read can also be pipelined in a tight loop
        // without the WTICK delay, but this will not work with
        // SLOWDOWN > 1
        if (wtick) begin
            wtick <= 1'b0;
        end
        else if ((tbi < 498)) begin
            led2_r <= (!led2_r);
            case (tbi)
                0: ud1 = 32;
                1: ud1 = 32;
                2: ud1 = 32;
                3: ud1 = 72;
                4: ud1 = 101;
                5: ud1 = 108;
                6: ud1 = 108;
                7: ud1 = 111;
                8: ud1 = 32;
                9: ud1 = 87;
                10: ud1 = 111;
                11: ud1 = 114;
                12: ud1 = 108;
                13: ud1 = 100;
                14: ud1 = 33;
                15: ud1 = 32;
                16: ud1 = 48;
                17: ud1 = 32;
                18: ud1 = 32;
                19: ud1 = 32;
                20: ud1 = 32;
                21: ud1 = 32;
                22: ud1 = 32;
                23: ud1 = 32;
                24: ud1 = 32;
                25: ud1 = 32;
                26: ud1 = 72;
                27: ud1 = 101;
                28: ud1 = 108;
                29: ud1 = 108;
                30: ud1 = 111;
                31: ud1 = 32;
                32: ud1 = 87;
                33: ud1 = 111;
                34: ud1 = 114;
                35: ud1 = 108;
                36: ud1 = 100;
                37: ud1 = 33;
                38: ud1 = 32;
                39: ud1 = 49;
                40: ud1 = 32;
                41: ud1 = 32;
                42: ud1 = 32;
                43: ud1 = 32;
                44: ud1 = 32;
                45: ud1 = 32;
                46: ud1 = 32;
                47: ud1 = 32;
                48: ud1 = 32;
                49: ud1 = 72;
                50: ud1 = 101;
                51: ud1 = 108;
                52: ud1 = 108;
                53: ud1 = 111;
                54: ud1 = 32;
                55: ud1 = 87;
                56: ud1 = 111;
                57: ud1 = 114;
                58: ud1 = 108;
                59: ud1 = 100;
                60: ud1 = 33;
                61: ud1 = 32;
                62: ud1 = 50;
                63: ud1 = 32;
                64: ud1 = 32;
                65: ud1 = 32;
                66: ud1 = 32;
                67: ud1 = 32;
                68: ud1 = 32;
                69: ud1 = 32;
                70: ud1 = 32;
                71: ud1 = 32;
                72: ud1 = 72;
                73: ud1 = 101;
                74: ud1 = 108;
                75: ud1 = 108;
                76: ud1 = 111;
                77: ud1 = 32;
                78: ud1 = 87;
                79: ud1 = 111;
                80: ud1 = 114;
                81: ud1 = 108;
                82: ud1 = 100;
                83: ud1 = 33;
                84: ud1 = 32;
                85: ud1 = 51;
                86: ud1 = 32;
                87: ud1 = 32;
                88: ud1 = 32;
                89: ud1 = 32;
                90: ud1 = 32;
                91: ud1 = 32;
                92: ud1 = 32;
                93: ud1 = 32;
                94: ud1 = 32;
                95: ud1 = 72;
                96: ud1 = 101;
                97: ud1 = 108;
                98: ud1 = 108;
                99: ud1 = 111;
                100: ud1 = 32;
                101: ud1 = 87;
                102: ud1 = 111;
                103: ud1 = 114;
                104: ud1 = 108;
                105: ud1 = 100;
                106: ud1 = 33;
                107: ud1 = 32;
                108: ud1 = 52;
                109: ud1 = 32;
                110: ud1 = 32;
                111: ud1 = 32;
                112: ud1 = 32;
                113: ud1 = 32;
                114: ud1 = 32;
                115: ud1 = 32;
                116: ud1 = 32;
                117: ud1 = 32;
                118: ud1 = 72;
                119: ud1 = 101;
                120: ud1 = 108;
                121: ud1 = 108;
                122: ud1 = 111;
                123: ud1 = 32;
                124: ud1 = 87;
                125: ud1 = 111;
                126: ud1 = 114;
                127: ud1 = 108;
                128: ud1 = 100;
                129: ud1 = 33;
                130: ud1 = 32;
                131: ud1 = 53;
                132: ud1 = 32;
                133: ud1 = 32;
                134: ud1 = 32;
                135: ud1 = 32;
                136: ud1 = 32;
                137: ud1 = 32;
                138: ud1 = 32;
                139: ud1 = 32;
                140: ud1 = 32;
                141: ud1 = 72;
                142: ud1 = 101;
                143: ud1 = 108;
                144: ud1 = 108;
                145: ud1 = 111;
                146: ud1 = 32;
                147: ud1 = 87;
                148: ud1 = 111;
                149: ud1 = 114;
                150: ud1 = 108;
                151: ud1 = 100;
                152: ud1 = 33;
                153: ud1 = 32;
                154: ud1 = 54;
                155: ud1 = 32;
                156: ud1 = 32;
                157: ud1 = 32;
                158: ud1 = 32;
                159: ud1 = 32;
                160: ud1 = 32;
                161: ud1 = 32;
                162: ud1 = 32;
                163: ud1 = 32;
                164: ud1 = 72;
                165: ud1 = 101;
                166: ud1 = 108;
                167: ud1 = 108;
                168: ud1 = 111;
                169: ud1 = 32;
                170: ud1 = 87;
                171: ud1 = 111;
                172: ud1 = 114;
                173: ud1 = 108;
                174: ud1 = 100;
                175: ud1 = 33;
                176: ud1 = 32;
                177: ud1 = 55;
                178: ud1 = 32;
                179: ud1 = 32;
                180: ud1 = 32;
                181: ud1 = 32;
                182: ud1 = 32;
                183: ud1 = 32;
                184: ud1 = 32;
                185: ud1 = 32;
                186: ud1 = 32;
                187: ud1 = 72;
                188: ud1 = 101;
                189: ud1 = 108;
                190: ud1 = 108;
                191: ud1 = 111;
                192: ud1 = 32;
                193: ud1 = 87;
                194: ud1 = 111;
                195: ud1 = 114;
                196: ud1 = 108;
                197: ud1 = 100;
                198: ud1 = 33;
                199: ud1 = 32;
                200: ud1 = 56;
                201: ud1 = 32;
                202: ud1 = 32;
                203: ud1 = 32;
                204: ud1 = 32;
                205: ud1 = 32;
                206: ud1 = 32;
                207: ud1 = 32;
                208: ud1 = 32;
                209: ud1 = 32;
                210: ud1 = 72;
                211: ud1 = 101;
                212: ud1 = 108;
                213: ud1 = 108;
                214: ud1 = 111;
                215: ud1 = 32;
                216: ud1 = 87;
                217: ud1 = 111;
                218: ud1 = 114;
                219: ud1 = 108;
                220: ud1 = 100;
                221: ud1 = 33;
                222: ud1 = 32;
                223: ud1 = 57;
                224: ud1 = 32;
                225: ud1 = 32;
                226: ud1 = 32;
                227: ud1 = 32;
                228: ud1 = 32;
                229: ud1 = 32;
                230: ud1 = 32;
                231: ud1 = 32;
                232: ud1 = 32;
                233: ud1 = 72;
                234: ud1 = 101;
                235: ud1 = 108;
                236: ud1 = 108;
                237: ud1 = 111;
                238: ud1 = 32;
                239: ud1 = 87;
                240: ud1 = 111;
                241: ud1 = 114;
                242: ud1 = 108;
                243: ud1 = 100;
                244: ud1 = 33;
                245: ud1 = 32;
                246: ud1 = 49;
                247: ud1 = 48;
                248: ud1 = 32;
                249: ud1 = 32;
                250: ud1 = 32;
                251: ud1 = 32;
                252: ud1 = 32;
                253: ud1 = 32;
                254: ud1 = 32;
                255: ud1 = 32;
                256: ud1 = 32;
                257: ud1 = 72;
                258: ud1 = 101;
                259: ud1 = 108;
                260: ud1 = 108;
                261: ud1 = 111;
                262: ud1 = 32;
                263: ud1 = 87;
                264: ud1 = 111;
                265: ud1 = 114;
                266: ud1 = 108;
                267: ud1 = 100;
                268: ud1 = 33;
                269: ud1 = 32;
                270: ud1 = 49;
                271: ud1 = 49;
                272: ud1 = 32;
                273: ud1 = 32;
                274: ud1 = 32;
                275: ud1 = 32;
                276: ud1 = 32;
                277: ud1 = 32;
                278: ud1 = 32;
                279: ud1 = 32;
                280: ud1 = 32;
                281: ud1 = 72;
                282: ud1 = 101;
                283: ud1 = 108;
                284: ud1 = 108;
                285: ud1 = 111;
                286: ud1 = 32;
                287: ud1 = 87;
                288: ud1 = 111;
                289: ud1 = 114;
                290: ud1 = 108;
                291: ud1 = 100;
                292: ud1 = 33;
                293: ud1 = 32;
                294: ud1 = 49;
                295: ud1 = 50;
                296: ud1 = 32;
                297: ud1 = 32;
                298: ud1 = 32;
                299: ud1 = 32;
                300: ud1 = 32;
                301: ud1 = 32;
                302: ud1 = 32;
                303: ud1 = 32;
                304: ud1 = 32;
                305: ud1 = 72;
                306: ud1 = 101;
                307: ud1 = 108;
                308: ud1 = 108;
                309: ud1 = 111;
                310: ud1 = 32;
                311: ud1 = 87;
                312: ud1 = 111;
                313: ud1 = 114;
                314: ud1 = 108;
                315: ud1 = 100;
                316: ud1 = 33;
                317: ud1 = 32;
                318: ud1 = 49;
                319: ud1 = 51;
                320: ud1 = 32;
                321: ud1 = 32;
                322: ud1 = 32;
                323: ud1 = 32;
                324: ud1 = 32;
                325: ud1 = 32;
                326: ud1 = 32;
                327: ud1 = 32;
                328: ud1 = 32;
                329: ud1 = 72;
                330: ud1 = 101;
                331: ud1 = 108;
                332: ud1 = 108;
                333: ud1 = 111;
                334: ud1 = 32;
                335: ud1 = 87;
                336: ud1 = 111;
                337: ud1 = 114;
                338: ud1 = 108;
                339: ud1 = 100;
                340: ud1 = 33;
                341: ud1 = 32;
                342: ud1 = 49;
                343: ud1 = 52;
                344: ud1 = 32;
                345: ud1 = 32;
                346: ud1 = 32;
                347: ud1 = 32;
                348: ud1 = 32;
                349: ud1 = 32;
                350: ud1 = 32;
                351: ud1 = 32;
                352: ud1 = 32;
                353: ud1 = 72;
                354: ud1 = 101;
                355: ud1 = 108;
                356: ud1 = 108;
                357: ud1 = 111;
                358: ud1 = 32;
                359: ud1 = 87;
                360: ud1 = 111;
                361: ud1 = 114;
                362: ud1 = 108;
                363: ud1 = 100;
                364: ud1 = 33;
                365: ud1 = 32;
                366: ud1 = 49;
                367: ud1 = 53;
                368: ud1 = 32;
                369: ud1 = 32;
                370: ud1 = 32;
                371: ud1 = 32;
                372: ud1 = 32;
                373: ud1 = 32;
                374: ud1 = 32;
                375: ud1 = 32;
                376: ud1 = 32;
                377: ud1 = 72;
                378: ud1 = 101;
                379: ud1 = 108;
                380: ud1 = 108;
                381: ud1 = 111;
                382: ud1 = 32;
                383: ud1 = 87;
                384: ud1 = 111;
                385: ud1 = 114;
                386: ud1 = 108;
                387: ud1 = 100;
                388: ud1 = 33;
                389: ud1 = 32;
                390: ud1 = 49;
                391: ud1 = 54;
                392: ud1 = 32;
                393: ud1 = 32;
                394: ud1 = 32;
                395: ud1 = 32;
                396: ud1 = 32;
                397: ud1 = 32;
                398: ud1 = 32;
                399: ud1 = 32;
                400: ud1 = 32;
                401: ud1 = 72;
                402: ud1 = 101;
                403: ud1 = 108;
                404: ud1 = 108;
                405: ud1 = 111;
                406: ud1 = 32;
                407: ud1 = 87;
                408: ud1 = 111;
                409: ud1 = 114;
                410: ud1 = 108;
                411: ud1 = 100;
                412: ud1 = 33;
                413: ud1 = 32;
                414: ud1 = 49;
                415: ud1 = 55;
                416: ud1 = 32;
                417: ud1 = 32;
                418: ud1 = 32;
                419: ud1 = 32;
                420: ud1 = 32;
                421: ud1 = 32;
                422: ud1 = 32;
                423: ud1 = 32;
                424: ud1 = 32;
                425: ud1 = 72;
                426: ud1 = 101;
                427: ud1 = 108;
                428: ud1 = 108;
                429: ud1 = 111;
                430: ud1 = 32;
                431: ud1 = 87;
                432: ud1 = 111;
                433: ud1 = 114;
                434: ud1 = 108;
                435: ud1 = 100;
                436: ud1 = 33;
                437: ud1 = 32;
                438: ud1 = 49;
                439: ud1 = 56;
                440: ud1 = 32;
                441: ud1 = 32;
                442: ud1 = 32;
                443: ud1 = 32;
                444: ud1 = 32;
                445: ud1 = 32;
                446: ud1 = 32;
                447: ud1 = 32;
                448: ud1 = 32;
                449: ud1 = 72;
                450: ud1 = 101;
                451: ud1 = 108;
                452: ud1 = 108;
                453: ud1 = 111;
                454: ud1 = 32;
                455: ud1 = 87;
                456: ud1 = 111;
                457: ud1 = 114;
                458: ud1 = 108;
                459: ud1 = 100;
                460: ud1 = 33;
                461: ud1 = 32;
                462: ud1 = 49;
                463: ud1 = 57;
                464: ud1 = 32;
                465: ud1 = 32;
                466: ud1 = 32;
                467: ud1 = 32;
                468: ud1 = 32;
                469: ud1 = 32;
                470: ud1 = 32;
                471: ud1 = 32;
                472: ud1 = 32;
                473: ud1 = 72;
                474: ud1 = 101;
                475: ud1 = 108;
                476: ud1 = 108;
                477: ud1 = 111;
                478: ud1 = 32;
                479: ud1 = 87;
                480: ud1 = 111;
                481: ud1 = 114;
                482: ud1 = 108;
                483: ud1 = 100;
                484: ud1 = 33;
                485: ud1 = 32;
                486: ud1 = 50;
                487: ud1 = 48;
                488: ud1 = 32;
                489: ud1 = 32;
                490: ud1 = 32;
                491: ud1 = 32;
                492: ud1 = 32;
                493: ud1 = 32;
                494: ud1 = 32;
                495: ud1 = 32;
                496: ud1 = 32;
                default: ud1 = 72;
            endcase
            if (($signed({1'b0, o_byte}) != ud1)) begin
                i_mode <= 0;
                $write("FAIL");
                $write(" ");
                $write("%0d", 498);
                $write(" ");
                $write("%h", tbi);
                $write(" ");
                $write("%h", o_byte);
                $write(" ");
                $write("%0d", ud1);
                $write("\n");
                tstate <= 5'b10000;
            end
            else begin
                // pass
            end
            i_raddr <= (tbi + 1);
            tbi <= (tbi + 1);
            wtick <= 1'b1;
        end
        else begin
            $write("%0d", 498);
            $write("\n");
            $write("DECOMPRESS test OK!, pausing");
            $write(" ");
            $write("%h", tbi);
            $write("\n");
            i_mode <= 0;
            tbi <= 0;
            if ((!1'b1)) begin
                tstate <= 5'b01111;
            end
            else begin
                tstate <= 5'b00110;
            end
            resume <= 1;
        end
    end
    else if ((tstate == 5'b00110)) begin
        led2_r <= 0;
        if ((resume == 0)) begin
            $write("--------------COMPRESS-------------");
            $write("\n");
            tbi <= 0;
            led0_g <= 0;
            tstate <= 5'b00111;
        end
        else begin
            led2_r <= (!led2_r);
            resume <= (resume + 1);
        end
    end
    else if ((tstate == 5'b00111)) begin
        o_led <= tbi;
        if ((tbi < 498)) begin
            led2_r <= 0;
            led1_b <= (!led1_b);
            i_mode <= 2;
            case (tbi)
                0: i_data <= 32;
                1: i_data <= 32;
                2: i_data <= 32;
                3: i_data <= 72;
                4: i_data <= 101;
                5: i_data <= 108;
                6: i_data <= 108;
                7: i_data <= 111;
                8: i_data <= 32;
                9: i_data <= 87;
                10: i_data <= 111;
                11: i_data <= 114;
                12: i_data <= 108;
                13: i_data <= 100;
                14: i_data <= 33;
                15: i_data <= 32;
                16: i_data <= 48;
                17: i_data <= 32;
                18: i_data <= 32;
                19: i_data <= 32;
                20: i_data <= 32;
                21: i_data <= 32;
                22: i_data <= 32;
                23: i_data <= 32;
                24: i_data <= 32;
                25: i_data <= 32;
                26: i_data <= 72;
                27: i_data <= 101;
                28: i_data <= 108;
                29: i_data <= 108;
                30: i_data <= 111;
                31: i_data <= 32;
                32: i_data <= 87;
                33: i_data <= 111;
                34: i_data <= 114;
                35: i_data <= 108;
                36: i_data <= 100;
                37: i_data <= 33;
                38: i_data <= 32;
                39: i_data <= 49;
                40: i_data <= 32;
                41: i_data <= 32;
                42: i_data <= 32;
                43: i_data <= 32;
                44: i_data <= 32;
                45: i_data <= 32;
                46: i_data <= 32;
                47: i_data <= 32;
                48: i_data <= 32;
                49: i_data <= 72;
                50: i_data <= 101;
                51: i_data <= 108;
                52: i_data <= 108;
                53: i_data <= 111;
                54: i_data <= 32;
                55: i_data <= 87;
                56: i_data <= 111;
                57: i_data <= 114;
                58: i_data <= 108;
                59: i_data <= 100;
                60: i_data <= 33;
                61: i_data <= 32;
                62: i_data <= 50;
                63: i_data <= 32;
                64: i_data <= 32;
                65: i_data <= 32;
                66: i_data <= 32;
                67: i_data <= 32;
                68: i_data <= 32;
                69: i_data <= 32;
                70: i_data <= 32;
                71: i_data <= 32;
                72: i_data <= 72;
                73: i_data <= 101;
                74: i_data <= 108;
                75: i_data <= 108;
                76: i_data <= 111;
                77: i_data <= 32;
                78: i_data <= 87;
                79: i_data <= 111;
                80: i_data <= 114;
                81: i_data <= 108;
                82: i_data <= 100;
                83: i_data <= 33;
                84: i_data <= 32;
                85: i_data <= 51;
                86: i_data <= 32;
                87: i_data <= 32;
                88: i_data <= 32;
                89: i_data <= 32;
                90: i_data <= 32;
                91: i_data <= 32;
                92: i_data <= 32;
                93: i_data <= 32;
                94: i_data <= 32;
                95: i_data <= 72;
                96: i_data <= 101;
                97: i_data <= 108;
                98: i_data <= 108;
                99: i_data <= 111;
                100: i_data <= 32;
                101: i_data <= 87;
                102: i_data <= 111;
                103: i_data <= 114;
                104: i_data <= 108;
                105: i_data <= 100;
                106: i_data <= 33;
                107: i_data <= 32;
                108: i_data <= 52;
                109: i_data <= 32;
                110: i_data <= 32;
                111: i_data <= 32;
                112: i_data <= 32;
                113: i_data <= 32;
                114: i_data <= 32;
                115: i_data <= 32;
                116: i_data <= 32;
                117: i_data <= 32;
                118: i_data <= 72;
                119: i_data <= 101;
                120: i_data <= 108;
                121: i_data <= 108;
                122: i_data <= 111;
                123: i_data <= 32;
                124: i_data <= 87;
                125: i_data <= 111;
                126: i_data <= 114;
                127: i_data <= 108;
                128: i_data <= 100;
                129: i_data <= 33;
                130: i_data <= 32;
                131: i_data <= 53;
                132: i_data <= 32;
                133: i_data <= 32;
                134: i_data <= 32;
                135: i_data <= 32;
                136: i_data <= 32;
                137: i_data <= 32;
                138: i_data <= 32;
                139: i_data <= 32;
                140: i_data <= 32;
                141: i_data <= 72;
                142: i_data <= 101;
                143: i_data <= 108;
                144: i_data <= 108;
                145: i_data <= 111;
                146: i_data <= 32;
                147: i_data <= 87;
                148: i_data <= 111;
                149: i_data <= 114;
                150: i_data <= 108;
                151: i_data <= 100;
                152: i_data <= 33;
                153: i_data <= 32;
                154: i_data <= 54;
                155: i_data <= 32;
                156: i_data <= 32;
                157: i_data <= 32;
                158: i_data <= 32;
                159: i_data <= 32;
                160: i_data <= 32;
                161: i_data <= 32;
                162: i_data <= 32;
                163: i_data <= 32;
                164: i_data <= 72;
                165: i_data <= 101;
                166: i_data <= 108;
                167: i_data <= 108;
                168: i_data <= 111;
                169: i_data <= 32;
                170: i_data <= 87;
                171: i_data <= 111;
                172: i_data <= 114;
                173: i_data <= 108;
                174: i_data <= 100;
                175: i_data <= 33;
                176: i_data <= 32;
                177: i_data <= 55;
                178: i_data <= 32;
                179: i_data <= 32;
                180: i_data <= 32;
                181: i_data <= 32;
                182: i_data <= 32;
                183: i_data <= 32;
                184: i_data <= 32;
                185: i_data <= 32;
                186: i_data <= 32;
                187: i_data <= 72;
                188: i_data <= 101;
                189: i_data <= 108;
                190: i_data <= 108;
                191: i_data <= 111;
                192: i_data <= 32;
                193: i_data <= 87;
                194: i_data <= 111;
                195: i_data <= 114;
                196: i_data <= 108;
                197: i_data <= 100;
                198: i_data <= 33;
                199: i_data <= 32;
                200: i_data <= 56;
                201: i_data <= 32;
                202: i_data <= 32;
                203: i_data <= 32;
                204: i_data <= 32;
                205: i_data <= 32;
                206: i_data <= 32;
                207: i_data <= 32;
                208: i_data <= 32;
                209: i_data <= 32;
                210: i_data <= 72;
                211: i_data <= 101;
                212: i_data <= 108;
                213: i_data <= 108;
                214: i_data <= 111;
                215: i_data <= 32;
                216: i_data <= 87;
                217: i_data <= 111;
                218: i_data <= 114;
                219: i_data <= 108;
                220: i_data <= 100;
                221: i_data <= 33;
                222: i_data <= 32;
                223: i_data <= 57;
                224: i_data <= 32;
                225: i_data <= 32;
                226: i_data <= 32;
                227: i_data <= 32;
                228: i_data <= 32;
                229: i_data <= 32;
                230: i_data <= 32;
                231: i_data <= 32;
                232: i_data <= 32;
                233: i_data <= 72;
                234: i_data <= 101;
                235: i_data <= 108;
                236: i_data <= 108;
                237: i_data <= 111;
                238: i_data <= 32;
                239: i_data <= 87;
                240: i_data <= 111;
                241: i_data <= 114;
                242: i_data <= 108;
                243: i_data <= 100;
                244: i_data <= 33;
                245: i_data <= 32;
                246: i_data <= 49;
                247: i_data <= 48;
                248: i_data <= 32;
                249: i_data <= 32;
                250: i_data <= 32;
                251: i_data <= 32;
                252: i_data <= 32;
                253: i_data <= 32;
                254: i_data <= 32;
                255: i_data <= 32;
                256: i_data <= 32;
                257: i_data <= 72;
                258: i_data <= 101;
                259: i_data <= 108;
                260: i_data <= 108;
                261: i_data <= 111;
                262: i_data <= 32;
                263: i_data <= 87;
                264: i_data <= 111;
                265: i_data <= 114;
                266: i_data <= 108;
                267: i_data <= 100;
                268: i_data <= 33;
                269: i_data <= 32;
                270: i_data <= 49;
                271: i_data <= 49;
                272: i_data <= 32;
                273: i_data <= 32;
                274: i_data <= 32;
                275: i_data <= 32;
                276: i_data <= 32;
                277: i_data <= 32;
                278: i_data <= 32;
                279: i_data <= 32;
                280: i_data <= 32;
                281: i_data <= 72;
                282: i_data <= 101;
                283: i_data <= 108;
                284: i_data <= 108;
                285: i_data <= 111;
                286: i_data <= 32;
                287: i_data <= 87;
                288: i_data <= 111;
                289: i_data <= 114;
                290: i_data <= 108;
                291: i_data <= 100;
                292: i_data <= 33;
                293: i_data <= 32;
                294: i_data <= 49;
                295: i_data <= 50;
                296: i_data <= 32;
                297: i_data <= 32;
                298: i_data <= 32;
                299: i_data <= 32;
                300: i_data <= 32;
                301: i_data <= 32;
                302: i_data <= 32;
                303: i_data <= 32;
                304: i_data <= 32;
                305: i_data <= 72;
                306: i_data <= 101;
                307: i_data <= 108;
                308: i_data <= 108;
                309: i_data <= 111;
                310: i_data <= 32;
                311: i_data <= 87;
                312: i_data <= 111;
                313: i_data <= 114;
                314: i_data <= 108;
                315: i_data <= 100;
                316: i_data <= 33;
                317: i_data <= 32;
                318: i_data <= 49;
                319: i_data <= 51;
                320: i_data <= 32;
                321: i_data <= 32;
                322: i_data <= 32;
                323: i_data <= 32;
                324: i_data <= 32;
                325: i_data <= 32;
                326: i_data <= 32;
                327: i_data <= 32;
                328: i_data <= 32;
                329: i_data <= 72;
                330: i_data <= 101;
                331: i_data <= 108;
                332: i_data <= 108;
                333: i_data <= 111;
                334: i_data <= 32;
                335: i_data <= 87;
                336: i_data <= 111;
                337: i_data <= 114;
                338: i_data <= 108;
                339: i_data <= 100;
                340: i_data <= 33;
                341: i_data <= 32;
                342: i_data <= 49;
                343: i_data <= 52;
                344: i_data <= 32;
                345: i_data <= 32;
                346: i_data <= 32;
                347: i_data <= 32;
                348: i_data <= 32;
                349: i_data <= 32;
                350: i_data <= 32;
                351: i_data <= 32;
                352: i_data <= 32;
                353: i_data <= 72;
                354: i_data <= 101;
                355: i_data <= 108;
                356: i_data <= 108;
                357: i_data <= 111;
                358: i_data <= 32;
                359: i_data <= 87;
                360: i_data <= 111;
                361: i_data <= 114;
                362: i_data <= 108;
                363: i_data <= 100;
                364: i_data <= 33;
                365: i_data <= 32;
                366: i_data <= 49;
                367: i_data <= 53;
                368: i_data <= 32;
                369: i_data <= 32;
                370: i_data <= 32;
                371: i_data <= 32;
                372: i_data <= 32;
                373: i_data <= 32;
                374: i_data <= 32;
                375: i_data <= 32;
                376: i_data <= 32;
                377: i_data <= 72;
                378: i_data <= 101;
                379: i_data <= 108;
                380: i_data <= 108;
                381: i_data <= 111;
                382: i_data <= 32;
                383: i_data <= 87;
                384: i_data <= 111;
                385: i_data <= 114;
                386: i_data <= 108;
                387: i_data <= 100;
                388: i_data <= 33;
                389: i_data <= 32;
                390: i_data <= 49;
                391: i_data <= 54;
                392: i_data <= 32;
                393: i_data <= 32;
                394: i_data <= 32;
                395: i_data <= 32;
                396: i_data <= 32;
                397: i_data <= 32;
                398: i_data <= 32;
                399: i_data <= 32;
                400: i_data <= 32;
                401: i_data <= 72;
                402: i_data <= 101;
                403: i_data <= 108;
                404: i_data <= 108;
                405: i_data <= 111;
                406: i_data <= 32;
                407: i_data <= 87;
                408: i_data <= 111;
                409: i_data <= 114;
                410: i_data <= 108;
                411: i_data <= 100;
                412: i_data <= 33;
                413: i_data <= 32;
                414: i_data <= 49;
                415: i_data <= 55;
                416: i_data <= 32;
                417: i_data <= 32;
                418: i_data <= 32;
                419: i_data <= 32;
                420: i_data <= 32;
                421: i_data <= 32;
                422: i_data <= 32;
                423: i_data <= 32;
                424: i_data <= 32;
                425: i_data <= 72;
                426: i_data <= 101;
                427: i_data <= 108;
                428: i_data <= 108;
                429: i_data <= 111;
                430: i_data <= 32;
                431: i_data <= 87;
                432: i_data <= 111;
                433: i_data <= 114;
                434: i_data <= 108;
                435: i_data <= 100;
                436: i_data <= 33;
                437: i_data <= 32;
                438: i_data <= 49;
                439: i_data <= 56;
                440: i_data <= 32;
                441: i_data <= 32;
                442: i_data <= 32;
                443: i_data <= 32;
                444: i_data <= 32;
                445: i_data <= 32;
                446: i_data <= 32;
                447: i_data <= 32;
                448: i_data <= 32;
                449: i_data <= 72;
                450: i_data <= 101;
                451: i_data <= 108;
                452: i_data <= 108;
                453: i_data <= 111;
                454: i_data <= 32;
                455: i_data <= 87;
                456: i_data <= 111;
                457: i_data <= 114;
                458: i_data <= 108;
                459: i_data <= 100;
                460: i_data <= 33;
                461: i_data <= 32;
                462: i_data <= 49;
                463: i_data <= 57;
                464: i_data <= 32;
                465: i_data <= 32;
                466: i_data <= 32;
                467: i_data <= 32;
                468: i_data <= 32;
                469: i_data <= 32;
                470: i_data <= 32;
                471: i_data <= 32;
                472: i_data <= 32;
                473: i_data <= 72;
                474: i_data <= 101;
                475: i_data <= 108;
                476: i_data <= 108;
                477: i_data <= 111;
                478: i_data <= 32;
                479: i_data <= 87;
                480: i_data <= 111;
                481: i_data <= 114;
                482: i_data <= 108;
                483: i_data <= 100;
                484: i_data <= 33;
                485: i_data <= 32;
                486: i_data <= 50;
                487: i_data <= 48;
                488: i_data <= 32;
                489: i_data <= 32;
                490: i_data <= 32;
                491: i_data <= 32;
                492: i_data <= 32;
                493: i_data <= 32;
                494: i_data <= 32;
                495: i_data <= 32;
                496: i_data <= 32;
                default: i_data <= 72;
            endcase
            i_waddr <= tbi;
            tbi <= (tbi + 1);
        end
        else begin
            $write("wrote bytes to compress");
            $write(" ");
            $write("%h", tbi);
            $write("\n");
            i_mode <= 0;
            tstate <= 5'b01000;
        end
    end
    else if ((tstate == 5'b01000)) begin
        i_mode <= 4;
        tstate <= 5'b01001;
    end
    else if ((tstate == 5'b01001)) begin
        led2_r <= (!led2_r);
        if ((i_mode == 4)) begin
            $write("WAIT COMPRESS");
            $write("\n");
            i_mode <= 0;
            led1_b <= 0;
        end
        else if (o_done) begin
            $write("result len");
            $write(" ");
            $write("%h", o_oprogress);
            $write("\n");
            resultlen <= o_oprogress;
            tbi <= 0;
            i_raddr <= 0;
            i_mode <= 3;
            if ((!1'b0)) begin
                if ((o_oprogress == 38)) begin
                    tstate <= 5'b01111;
                    resume <= 1;
                    $write("compress OK!");
                    $write("\n");
                end
                else begin
                    $write("compress len FAILED");
                    $write(" ");
                    $write("%h", o_oprogress);
                    $write("\n");
                    tstate <= 5'b10000;
                end
                if ((22 <= 4)) begin
                end
            end
            else begin
                tstate <= 5'b01010;
                wtick <= 1'b1;
            end
        end
    end
    else if ((tstate == 5'b01010)) begin
        led2_r <= 0;
        o_led <= tbi;
        if (wtick) begin
            if ((tbi > 0)) begin
                i_mode <= 2;
                i_data <= copy;
                i_waddr <= (tbi - 1);
            end
            wtick <= 1'b0;
            tbi <= (tbi + 1);
        end
        else if ((tbi < resultlen)) begin
            i_mode <= 3;
            led1_b <= (!led1_b);
            i_raddr <= tbi;
            copy <= o_byte;
            wtick <= 1'b1;
        end
        else begin
            $write("Compress output bytes copied to input");
            $write(" ");
            $write("%h", resultlen);
            $write(" ");
            $write("%0d", ($signed({1'b0, tbi}) - 1));
            $write("\n");
            i_mode <= 0;
            tbi <= 0;
            tstate <= 5'b01100;
        end
    end
    else if ((tstate == 5'b01100)) begin
        $write("start decompress of test compression");
        $write("\n");
        i_mode <= 5;
        tstate <= 5'b01101;
    end
    else if ((tstate == 5'b01101)) begin
        led2_r <= 0;
        led1_b <= (!led1_b);
        i_mode <= 0;
        if (((i_mode == 0) && o_done)) begin
            $write("DONE DECOMPRESS VERIFY");
            $write(" ");
            $write("%h", o_oprogress);
            $write("\n");
            tbi <= 0;
            i_raddr <= 0;
            i_mode <= 3;
            wtick <= 1'b1;
            tstate <= 5'b01110;
        end
    end
    else if ((tstate == 5'b01110)) begin
        led1_b <= 0;
        led2_r <= (!led2_r);
        o_led <= tbi;
        if (wtick) begin
            wtick <= 1'b0;
        end
        else if ((tbi < 498)) begin
            case (tbi)
                0: ud2 = 32;
                1: ud2 = 32;
                2: ud2 = 32;
                3: ud2 = 72;
                4: ud2 = 101;
                5: ud2 = 108;
                6: ud2 = 108;
                7: ud2 = 111;
                8: ud2 = 32;
                9: ud2 = 87;
                10: ud2 = 111;
                11: ud2 = 114;
                12: ud2 = 108;
                13: ud2 = 100;
                14: ud2 = 33;
                15: ud2 = 32;
                16: ud2 = 48;
                17: ud2 = 32;
                18: ud2 = 32;
                19: ud2 = 32;
                20: ud2 = 32;
                21: ud2 = 32;
                22: ud2 = 32;
                23: ud2 = 32;
                24: ud2 = 32;
                25: ud2 = 32;
                26: ud2 = 72;
                27: ud2 = 101;
                28: ud2 = 108;
                29: ud2 = 108;
                30: ud2 = 111;
                31: ud2 = 32;
                32: ud2 = 87;
                33: ud2 = 111;
                34: ud2 = 114;
                35: ud2 = 108;
                36: ud2 = 100;
                37: ud2 = 33;
                38: ud2 = 32;
                39: ud2 = 49;
                40: ud2 = 32;
                41: ud2 = 32;
                42: ud2 = 32;
                43: ud2 = 32;
                44: ud2 = 32;
                45: ud2 = 32;
                46: ud2 = 32;
                47: ud2 = 32;
                48: ud2 = 32;
                49: ud2 = 72;
                50: ud2 = 101;
                51: ud2 = 108;
                52: ud2 = 108;
                53: ud2 = 111;
                54: ud2 = 32;
                55: ud2 = 87;
                56: ud2 = 111;
                57: ud2 = 114;
                58: ud2 = 108;
                59: ud2 = 100;
                60: ud2 = 33;
                61: ud2 = 32;
                62: ud2 = 50;
                63: ud2 = 32;
                64: ud2 = 32;
                65: ud2 = 32;
                66: ud2 = 32;
                67: ud2 = 32;
                68: ud2 = 32;
                69: ud2 = 32;
                70: ud2 = 32;
                71: ud2 = 32;
                72: ud2 = 72;
                73: ud2 = 101;
                74: ud2 = 108;
                75: ud2 = 108;
                76: ud2 = 111;
                77: ud2 = 32;
                78: ud2 = 87;
                79: ud2 = 111;
                80: ud2 = 114;
                81: ud2 = 108;
                82: ud2 = 100;
                83: ud2 = 33;
                84: ud2 = 32;
                85: ud2 = 51;
                86: ud2 = 32;
                87: ud2 = 32;
                88: ud2 = 32;
                89: ud2 = 32;
                90: ud2 = 32;
                91: ud2 = 32;
                92: ud2 = 32;
                93: ud2 = 32;
                94: ud2 = 32;
                95: ud2 = 72;
                96: ud2 = 101;
                97: ud2 = 108;
                98: ud2 = 108;
                99: ud2 = 111;
                100: ud2 = 32;
                101: ud2 = 87;
                102: ud2 = 111;
                103: ud2 = 114;
                104: ud2 = 108;
                105: ud2 = 100;
                106: ud2 = 33;
                107: ud2 = 32;
                108: ud2 = 52;
                109: ud2 = 32;
                110: ud2 = 32;
                111: ud2 = 32;
                112: ud2 = 32;
                113: ud2 = 32;
                114: ud2 = 32;
                115: ud2 = 32;
                116: ud2 = 32;
                117: ud2 = 32;
                118: ud2 = 72;
                119: ud2 = 101;
                120: ud2 = 108;
                121: ud2 = 108;
                122: ud2 = 111;
                123: ud2 = 32;
                124: ud2 = 87;
                125: ud2 = 111;
                126: ud2 = 114;
                127: ud2 = 108;
                128: ud2 = 100;
                129: ud2 = 33;
                130: ud2 = 32;
                131: ud2 = 53;
                132: ud2 = 32;
                133: ud2 = 32;
                134: ud2 = 32;
                135: ud2 = 32;
                136: ud2 = 32;
                137: ud2 = 32;
                138: ud2 = 32;
                139: ud2 = 32;
                140: ud2 = 32;
                141: ud2 = 72;
                142: ud2 = 101;
                143: ud2 = 108;
                144: ud2 = 108;
                145: ud2 = 111;
                146: ud2 = 32;
                147: ud2 = 87;
                148: ud2 = 111;
                149: ud2 = 114;
                150: ud2 = 108;
                151: ud2 = 100;
                152: ud2 = 33;
                153: ud2 = 32;
                154: ud2 = 54;
                155: ud2 = 32;
                156: ud2 = 32;
                157: ud2 = 32;
                158: ud2 = 32;
                159: ud2 = 32;
                160: ud2 = 32;
                161: ud2 = 32;
                162: ud2 = 32;
                163: ud2 = 32;
                164: ud2 = 72;
                165: ud2 = 101;
                166: ud2 = 108;
                167: ud2 = 108;
                168: ud2 = 111;
                169: ud2 = 32;
                170: ud2 = 87;
                171: ud2 = 111;
                172: ud2 = 114;
                173: ud2 = 108;
                174: ud2 = 100;
                175: ud2 = 33;
                176: ud2 = 32;
                177: ud2 = 55;
                178: ud2 = 32;
                179: ud2 = 32;
                180: ud2 = 32;
                181: ud2 = 32;
                182: ud2 = 32;
                183: ud2 = 32;
                184: ud2 = 32;
                185: ud2 = 32;
                186: ud2 = 32;
                187: ud2 = 72;
                188: ud2 = 101;
                189: ud2 = 108;
                190: ud2 = 108;
                191: ud2 = 111;
                192: ud2 = 32;
                193: ud2 = 87;
                194: ud2 = 111;
                195: ud2 = 114;
                196: ud2 = 108;
                197: ud2 = 100;
                198: ud2 = 33;
                199: ud2 = 32;
                200: ud2 = 56;
                201: ud2 = 32;
                202: ud2 = 32;
                203: ud2 = 32;
                204: ud2 = 32;
                205: ud2 = 32;
                206: ud2 = 32;
                207: ud2 = 32;
                208: ud2 = 32;
                209: ud2 = 32;
                210: ud2 = 72;
                211: ud2 = 101;
                212: ud2 = 108;
                213: ud2 = 108;
                214: ud2 = 111;
                215: ud2 = 32;
                216: ud2 = 87;
                217: ud2 = 111;
                218: ud2 = 114;
                219: ud2 = 108;
                220: ud2 = 100;
                221: ud2 = 33;
                222: ud2 = 32;
                223: ud2 = 57;
                224: ud2 = 32;
                225: ud2 = 32;
                226: ud2 = 32;
                227: ud2 = 32;
                228: ud2 = 32;
                229: ud2 = 32;
                230: ud2 = 32;
                231: ud2 = 32;
                232: ud2 = 32;
                233: ud2 = 72;
                234: ud2 = 101;
                235: ud2 = 108;
                236: ud2 = 108;
                237: ud2 = 111;
                238: ud2 = 32;
                239: ud2 = 87;
                240: ud2 = 111;
                241: ud2 = 114;
                242: ud2 = 108;
                243: ud2 = 100;
                244: ud2 = 33;
                245: ud2 = 32;
                246: ud2 = 49;
                247: ud2 = 48;
                248: ud2 = 32;
                249: ud2 = 32;
                250: ud2 = 32;
                251: ud2 = 32;
                252: ud2 = 32;
                253: ud2 = 32;
                254: ud2 = 32;
                255: ud2 = 32;
                256: ud2 = 32;
                257: ud2 = 72;
                258: ud2 = 101;
                259: ud2 = 108;
                260: ud2 = 108;
                261: ud2 = 111;
                262: ud2 = 32;
                263: ud2 = 87;
                264: ud2 = 111;
                265: ud2 = 114;
                266: ud2 = 108;
                267: ud2 = 100;
                268: ud2 = 33;
                269: ud2 = 32;
                270: ud2 = 49;
                271: ud2 = 49;
                272: ud2 = 32;
                273: ud2 = 32;
                274: ud2 = 32;
                275: ud2 = 32;
                276: ud2 = 32;
                277: ud2 = 32;
                278: ud2 = 32;
                279: ud2 = 32;
                280: ud2 = 32;
                281: ud2 = 72;
                282: ud2 = 101;
                283: ud2 = 108;
                284: ud2 = 108;
                285: ud2 = 111;
                286: ud2 = 32;
                287: ud2 = 87;
                288: ud2 = 111;
                289: ud2 = 114;
                290: ud2 = 108;
                291: ud2 = 100;
                292: ud2 = 33;
                293: ud2 = 32;
                294: ud2 = 49;
                295: ud2 = 50;
                296: ud2 = 32;
                297: ud2 = 32;
                298: ud2 = 32;
                299: ud2 = 32;
                300: ud2 = 32;
                301: ud2 = 32;
                302: ud2 = 32;
                303: ud2 = 32;
                304: ud2 = 32;
                305: ud2 = 72;
                306: ud2 = 101;
                307: ud2 = 108;
                308: ud2 = 108;
                309: ud2 = 111;
                310: ud2 = 32;
                311: ud2 = 87;
                312: ud2 = 111;
                313: ud2 = 114;
                314: ud2 = 108;
                315: ud2 = 100;
                316: ud2 = 33;
                317: ud2 = 32;
                318: ud2 = 49;
                319: ud2 = 51;
                320: ud2 = 32;
                321: ud2 = 32;
                322: ud2 = 32;
                323: ud2 = 32;
                324: ud2 = 32;
                325: ud2 = 32;
                326: ud2 = 32;
                327: ud2 = 32;
                328: ud2 = 32;
                329: ud2 = 72;
                330: ud2 = 101;
                331: ud2 = 108;
                332: ud2 = 108;
                333: ud2 = 111;
                334: ud2 = 32;
                335: ud2 = 87;
                336: ud2 = 111;
                337: ud2 = 114;
                338: ud2 = 108;
                339: ud2 = 100;
                340: ud2 = 33;
                341: ud2 = 32;
                342: ud2 = 49;
                343: ud2 = 52;
                344: ud2 = 32;
                345: ud2 = 32;
                346: ud2 = 32;
                347: ud2 = 32;
                348: ud2 = 32;
                349: ud2 = 32;
                350: ud2 = 32;
                351: ud2 = 32;
                352: ud2 = 32;
                353: ud2 = 72;
                354: ud2 = 101;
                355: ud2 = 108;
                356: ud2 = 108;
                357: ud2 = 111;
                358: ud2 = 32;
                359: ud2 = 87;
                360: ud2 = 111;
                361: ud2 = 114;
                362: ud2 = 108;
                363: ud2 = 100;
                364: ud2 = 33;
                365: ud2 = 32;
                366: ud2 = 49;
                367: ud2 = 53;
                368: ud2 = 32;
                369: ud2 = 32;
                370: ud2 = 32;
                371: ud2 = 32;
                372: ud2 = 32;
                373: ud2 = 32;
                374: ud2 = 32;
                375: ud2 = 32;
                376: ud2 = 32;
                377: ud2 = 72;
                378: ud2 = 101;
                379: ud2 = 108;
                380: ud2 = 108;
                381: ud2 = 111;
                382: ud2 = 32;
                383: ud2 = 87;
                384: ud2 = 111;
                385: ud2 = 114;
                386: ud2 = 108;
                387: ud2 = 100;
                388: ud2 = 33;
                389: ud2 = 32;
                390: ud2 = 49;
                391: ud2 = 54;
                392: ud2 = 32;
                393: ud2 = 32;
                394: ud2 = 32;
                395: ud2 = 32;
                396: ud2 = 32;
                397: ud2 = 32;
                398: ud2 = 32;
                399: ud2 = 32;
                400: ud2 = 32;
                401: ud2 = 72;
                402: ud2 = 101;
                403: ud2 = 108;
                404: ud2 = 108;
                405: ud2 = 111;
                406: ud2 = 32;
                407: ud2 = 87;
                408: ud2 = 111;
                409: ud2 = 114;
                410: ud2 = 108;
                411: ud2 = 100;
                412: ud2 = 33;
                413: ud2 = 32;
                414: ud2 = 49;
                415: ud2 = 55;
                416: ud2 = 32;
                417: ud2 = 32;
                418: ud2 = 32;
                419: ud2 = 32;
                420: ud2 = 32;
                421: ud2 = 32;
                422: ud2 = 32;
                423: ud2 = 32;
                424: ud2 = 32;
                425: ud2 = 72;
                426: ud2 = 101;
                427: ud2 = 108;
                428: ud2 = 108;
                429: ud2 = 111;
                430: ud2 = 32;
                431: ud2 = 87;
                432: ud2 = 111;
                433: ud2 = 114;
                434: ud2 = 108;
                435: ud2 = 100;
                436: ud2 = 33;
                437: ud2 = 32;
                438: ud2 = 49;
                439: ud2 = 56;
                440: ud2 = 32;
                441: ud2 = 32;
                442: ud2 = 32;
                443: ud2 = 32;
                444: ud2 = 32;
                445: ud2 = 32;
                446: ud2 = 32;
                447: ud2 = 32;
                448: ud2 = 32;
                449: ud2 = 72;
                450: ud2 = 101;
                451: ud2 = 108;
                452: ud2 = 108;
                453: ud2 = 111;
                454: ud2 = 32;
                455: ud2 = 87;
                456: ud2 = 111;
                457: ud2 = 114;
                458: ud2 = 108;
                459: ud2 = 100;
                460: ud2 = 33;
                461: ud2 = 32;
                462: ud2 = 49;
                463: ud2 = 57;
                464: ud2 = 32;
                465: ud2 = 32;
                466: ud2 = 32;
                467: ud2 = 32;
                468: ud2 = 32;
                469: ud2 = 32;
                470: ud2 = 32;
                471: ud2 = 32;
                472: ud2 = 32;
                473: ud2 = 72;
                474: ud2 = 101;
                475: ud2 = 108;
                476: ud2 = 108;
                477: ud2 = 111;
                478: ud2 = 32;
                479: ud2 = 87;
                480: ud2 = 111;
                481: ud2 = 114;
                482: ud2 = 108;
                483: ud2 = 100;
                484: ud2 = 33;
                485: ud2 = 32;
                486: ud2 = 50;
                487: ud2 = 48;
                488: ud2 = 32;
                489: ud2 = 32;
                490: ud2 = 32;
                491: ud2 = 32;
                492: ud2 = 32;
                493: ud2 = 32;
                494: ud2 = 32;
                495: ud2 = 32;
                496: ud2 = 32;
                default: ud2 = 72;
            endcase
            if (($signed({1'b0, o_byte}) != ud2)) begin
                tstate <= 5'b00000;
                i_mode <= 0;
                $write("FAIL");
                $write(" ");
                $write("%0d", 498);
                $write(" ");
                $write("%h", tbi);
                $write(" ");
                $write("%0d", ud2);
                $write(" ");
                $write("%h", o_byte);
                $write("\n");
                tstate <= 5'b10000;
            end
            tbi <= (tbi + 1);
            i_raddr <= (tbi + 1);
            wtick <= 1'b1;
        end
        else begin
            $write("%0d", 498);
            $write("\n");
            $write("ALL OK!");
            $write(" ");
            $write("%h", tbi);
            $write("\n");
            led2_r <= 0;
            i_mode <= 0;
            resume <= 1;
            //
            tstate <= 5'b01111;
        end
    end
    else if ((tstate == 5'b01111)) begin
        if ((22 <= 4)) begin
        end
        if ((resume == 0)) begin
            $write("--------------RESET-------------");
            $write("\n");
            o_led <= (o_led + 1);
            tstate <= 5'b00000;
        end
        else begin
            led0_g <= (!led0_g);
            resume <= (resume + 1);
        end
    end
    // if now() > 50000:
    //     raise StopSimulation()
end

endmodule
