module mux2 (S,A,B,Y);
    input S;
    input A,B;
    output reg Y;
`ifndef BUG

    always @(*)
		Y = (S)? B : A;
`else

    always @(*)
		Y = (~S)? B : A;
`endif
endmodule

module mux4 ( S, D, Y );

input[1:0] S;
input[3:0] D;
output Y;

reg Y;
wire[1:0] S;
wire[3:0] D;

always @*
begin
    casez( S )
       0 : Y = D[0];
       1 : Y = D[1];
`ifndef BUG
       2 : Y = D[2];
`else
       2 : Y = D[3];
`endif
       3 : Y = D[3];
   endcase
end

endmodule

module mux8 ( S, D, Y );

input[2:0] S;
inout[7:0] D;
output Y;

reg Y;
wire[2:0] S;
wire[7:0] D;

always @*
begin
   casex( S )
       0 : Y = D[0];
       1 : Y = D[1];
       2 : Y = D[2];
       3 : Y = D[3];
`ifndef BUG
       4 : Y = D[4];
`else
       4 : Y = D[7];
`endif
       5 : Y = D[5];
       6 : Y = D[6];
       7 : Y = D[7];
   endcase
end

endmodule

module mux16 (D, S, Y);
 	input  [15:0] D;
 	input  [3:0] S;
 	output Y;

assign Y = D[S];

endmodule


module top (
input [3:0] S,
input [15:0] D,
output M2,M4,M8,M16
);
parameter u = 0;

mux2 u_mux2 (
        .S (S[0]),
        .A (D[0]),
        .B (D[1]),
        .Y (M2)
    );


mux4 u_mux4 (
        .S (S[1:0]),
        .D (D[3:0]),
        .Y (M4)
    );

mux8 u_mux8 (
        .S (S[2:0]),
        .D (D[7:0]),
        .Y (M8)
    );

mux16 u_mux16 (
        .S (S[3:0]),
        .D (D[15:0]),
        .Y (M16)
    );

genvar index;
generate
for (index=0; index < 8; index=index+1)
  begin: gen_code_label
  end
endgenerate

genvar index;
generate
case( u )
       0 : begin end
       1 : begin end
       2 : begin end
       3 : begin end
   endcase
endgenerate

// reg angle;
// case (index)
// //Create the case statement
// 	1 :
// 	begin
//     generate
//     genvar caseIndex;
//         for (caseIndex = 0; caseIndex < 1024; caseIndex=caseIndex+1)
//             begin
//                 caseIndex: angle = 2*pi*caseIndex/1024;
//             end
//     endgenerate
//     end
// endcase

endmodule
