{- sv2v
 - Author: Zachary Snow <zach@zachjs.com>
 - Initial Verilog AST Author: Tom Hawkins <tomahawkins@gmail.com>
 -
 - Helpers for printing AST items
 -}

module Language.SystemVerilog.AST.ShowHelp
    ( showPad
    , showPadBefore
    , indent
    , unlines'
    , commas
    , indentedParenList
    , showCase
    ) where

import Data.List (intercalate)
import Text.Printf (printf)

showPad :: Show t => t -> String
showPad x =
    if str == ""
        then ""
        else str ++ " "
    where str = show x

showPadBefore :: Show t => t -> String
showPadBefore x =
    if str == ""
        then ""
        else " " ++ str
    where str = show x

indent :: String -> String
indent a = '\t' : f a
    where
        f [] = []
        f ('\n' : xs) = "\n\t" ++ f xs
        f (x : xs) = x : f xs

unlines' :: [String] -> String
unlines' = intercalate "\n"

commas :: [String] -> String
commas = intercalate ", "

indentedParenList :: [String] -> String
indentedParenList [] = "()"
indentedParenList [x] = "(" ++ x ++ ")"
indentedParenList l = "(\n" ++ (indent $ intercalate ",\n" l) ++ "\n)"

showCase :: (Show x, Show y) => ([x], y) -> String
showCase (a, b) = printf "%s: %s" (commas $ map show a) (show b)
