;;- Machine description for the Hitachi SH.
;;  Copyright (C) 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001
;;  Free Software Foundation, Inc.
;;  Contributed by Steve Chamberlain (sac@cygnus.com).
;;  Improved by Jim Wilson (wilson@cygnus.com).

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.


;; ??? Should prepend a * to all pattern names which are not used.
;; This will make the compiler smaller, and rebuilds after changes faster.

;; ??? Should be enhanced to include support for many more GNU superoptimizer
;; sequences.  Especially the sequences for arithmetic right shifts.

;; ??? Should check all DImode patterns for consistency and usefulness.

;; ??? The MAC.W and MAC.L instructions are not supported.  There is no
;; way to generate them.

;; ??? The cmp/str instruction is not supported.  Perhaps it can be used
;; for a str* inline function.

;; BSR is not generated by the compiler proper, but when relaxing, it
;; generates .uses pseudo-ops that allow linker relaxation to create
;; BSR.  This is actually implemented in bfd/{coff,elf32}-sh.c

;; Special constraints for SH machine description:
;;
;;    t -- T
;;    x -- mac
;;    l -- pr
;;    z -- r0
;;
;; Special formats used for outputting SH instructions:
;;
;;   %.  --  print a .s if insn needs delay slot
;;   %@  --  print rte/rts if is/isn't an interrupt function
;;   %#  --  output a nop if there is nothing to put in the delay slot
;;   %O  --  print a constant without the #
;;   %R  --  print the lsw reg of a double
;;   %S  --  print the msw reg of a double
;;   %T  --  print next word of a double REG or MEM
;;
;; Special predicates:
;;
;;  arith_operand          -- operand is valid source for arithmetic op
;;  arith_reg_operand      -- operand is valid register for arithmetic op
;;  general_movdst_operand -- operand is valid move destination
;;  general_movsrc_operand -- operand is valid move source
;;  logical_operand        -- operand is valid source for logical op

;; -------------------------------------------------------------------------
;; Constants
;; -------------------------------------------------------------------------

(define_constants [
  (AP_REG	16)
  (PR_REG	17)
  (T_REG	18)
  (GBR_REG	19)
  (MACH_REG	20)
  (MACL_REG	21)
  (FPUL_REG	22)
  (RAP_REG	23)

  (FPSCR_REG	48)

  (PIC_REG	12)
  (FP_REG	14)
  (SP_REG	15)

  (R0_REG	0)
  (R1_REG	1)
  (R2_REG	2)
  (R3_REG	3)
  (R4_REG	4)
  (R5_REG	5)
  (R6_REG	6)

  (DR0_REG	24)
  (DR2_REG	26)
  (DR4_REG	28)

  (XD0_REG	40)

  ;; These are used with unspec.
  (UNSPEC_MOVA		1)
  (UNSPEC_CASESI	2)
  (UNSPEC_BBR		4)
  (UNSPEC_SFUNC		5)
  (UNSPEC_PIC		6)
  (UNSPEC_GOT		7)
  (UNSPEC_GOTOFF	8)
  (UNSPEC_PLT		9)
  (UNSPEC_CALLER	10)
  (UNSPEC_ICACHE	12)

  ;; These are used with unspec_volatile.
  (UNSPECV_BLOCKAGE	0)
  (UNSPECV_ALIGN	1)
  (UNSPECV_CONST2	2)
  (UNSPECV_CONST4	4)
  (UNSPECV_CONST8	6)
  (UNSPECV_WINDOW_END	10)
  (UNSPECV_CONST_END	11)
])  

;; -------------------------------------------------------------------------
;; Attributes
;; -------------------------------------------------------------------------

;; Target CPU.

(define_attr "cpu"
 "sh1,sh2,sh3,sh3e,sh4"
  (const (symbol_ref "sh_cpu_attr")))

(define_attr "endian" "big,little"
 (const (if_then_else (symbol_ref "TARGET_LITTLE_ENDIAN")
		      (const_string "little") (const_string "big"))))

;; Indicate if the default fpu mode is single precision.
(define_attr "fpu_single" "yes,no"
  (const (if_then_else (symbol_ref "TARGET_FPU_SINGLE")
                         (const_string "yes") (const_string "no"))))

(define_attr "fmovd" "yes,no"
  (const (if_then_else (symbol_ref "TARGET_FMOVD")
		       (const_string "yes") (const_string "no"))))
;; issues/clock
(define_attr "issues" "1,2"
  (const (if_then_else (symbol_ref "TARGET_SUPERSCALAR") (const_string "2") (const_string "1"))))

;; cbranch	conditional branch instructions
;; jump		unconditional jumps
;; arith	ordinary arithmetic
;; arith3	a compound insn that behaves similarly to a sequence of
;;		three insns of type arith
;; arith3b	like above, but might end with a redirected branch
;; load		from memory
;; load_si	Likewise, SImode variant for general register.
;; store	to memory
;; move		register to register
;; fmove	register to register, floating point
;; smpy		word precision integer multiply
;; dmpy		longword or doublelongword precision integer multiply
;; return	rts
;; pload	load of pr reg, which can't be put into delay slot of rts
;; prset	copy register to pr reg, ditto
;; pstore	store of pr reg, which can't be put into delay slot of jsr
;; prget	copy pr to register, ditto
;; pcload	pc relative load of constant value
;; pcload_si	Likewise, SImode variant for general register.
;; rte		return from exception
;; sfunc	special function call with known used registers
;; call		function call
;; fp		floating point
;; fdiv		floating point divide (or square root)
;; gp_fpul	move between general purpose register and fpul
;; dfp_arith, dfp_cmp,dfp_conv
;; dfdiv	double precision floating point divide (or square root)
;; nil		no-op move, will be deleted.

(define_attr "type"
 "cbranch,jump,jump_ind,arith,arith3,arith3b,dyn_shift,other,load,load_si,store,move,fmove,smpy,dmpy,return,pload,prset,pstore,prget,pcload,pcload_si,rte,sfunc,call,fp,fdiv,dfp_arith,dfp_cmp,dfp_conv,dfdiv,gp_fpul,nil"
  (const_string "other"))

;; Indicate what precision must be selected in fpscr for this insn, if any.

(define_attr "fp_mode" "single,double,none" (const_string "none"))

; If a conditional branch destination is within -252..258 bytes away
; from the instruction it can be 2 bytes long.  Something in the
; range -4090..4100 bytes can be 6 bytes long.  All other conditional
; branches are initially assumed to be 16 bytes long.
; In machine_dependent_reorg, we split all branches that are longer than
; 2 bytes.

;; The maximum range used for SImode constant pool entries is 1018.  A final
;; instruction can add 8 bytes while only being 4 bytes in size, thus we
;; can have a total of 1022 bytes in the pool.  Add 4 bytes for a branch
;; instruction around the pool table, 2 bytes of alignment before the table,
;; and 30 bytes of alignment after the table.  That gives a maximum total
;; pool size of 1058 bytes.
;; Worst case code/pool content size ratio is 1:2 (using asms).
;; Thus, in the worst case, there is one instruction in front of a maximum
;; sized pool, and then there are 1052 bytes of pool for every 508 bytes of
;; code.  For the last n bytes of code, there are 2n + 36 bytes of pool.
;; If we have a forward branch, the initial table will be put after the
;; unconditional branch.
;;
;; ??? We could do much better by keeping track of the actual pcloads within
;; the branch range and in the pcload range in front of the branch range.

;; ??? This looks ugly because genattrtab won't allow if_then_else or cond
;; inside an le.
(define_attr "short_cbranch_p" "no,yes"
  (cond [(ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 252)) (const_int 506))
	 (const_string "yes")
	 (ne (symbol_ref "NEXT_INSN (PREV_INSN (insn)) != insn") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 252)) (const_int 508))
	 (const_string "yes")
         ] (const_string "no")))

(define_attr "med_branch_p" "no,yes"
  (cond [(leu (plus (minus (match_dup 0) (pc)) (const_int 990))
	      (const_int 1988))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 4092))
	      (const_int 8186))
	 (const_string "yes")
	 ] (const_string "no")))

(define_attr "med_cbranch_p" "no,yes"
  (cond [(leu (plus (minus (match_dup 0) (pc)) (const_int 988))
	      (const_int 1986))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 4090))
	       (const_int 8184))
	 (const_string "yes")
	 ] (const_string "no")))

(define_attr "braf_branch_p" "no,yes"
  (cond [(ne (symbol_ref "! TARGET_SH2") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 10330))
	      (const_int 20660))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 32764))
	      (const_int 65530))
	 (const_string "yes")
	 ] (const_string "no")))

(define_attr "braf_cbranch_p" "no,yes"
  (cond [(ne (symbol_ref "! TARGET_SH2") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 10328))
	      (const_int 20658))
	 (const_string "yes")
	 (ne (symbol_ref "mdep_reorg_phase <= SH_FIXUP_PCLOAD") (const_int 0))
	 (const_string "no")
	 (leu (plus (minus (match_dup 0) (pc)) (const_int 32762))
	      (const_int 65528))
	 (const_string "yes")
	 ] (const_string "no")))

; An unconditional jump in the range -4092..4098 can be 2 bytes long.
; For wider ranges, we need a combination of a code and a data part.
; If we can get a scratch register for a long range jump, the code
; part can be 4 bytes long; otherwise, it must be 8 bytes long.
; If the jump is in the range -32764..32770, the data part can be 2 bytes
; long; otherwise, it must be 6 bytes long.

; All other instructions are two bytes long by default.

;; ??? This should use something like *branch_p (minus (match_dup 0) (pc)),
;; but getattrtab doesn't understand this.
(define_attr "length" ""
  (cond [(eq_attr "type" "cbranch")
	 (cond [(eq_attr "short_cbranch_p" "yes")
		(const_int 2)
		(eq_attr "med_cbranch_p" "yes")
		(const_int 6)
		(eq_attr "braf_cbranch_p" "yes")
		(const_int 12)
;; ??? using pc is not computed transitively.
		(ne (match_dup 0) (match_dup 0))
		(const_int 14)
		(ne (symbol_ref ("flag_pic")) (const_int 0))
		(const_int 24)
		] (const_int 16))
	 (eq_attr "type" "jump")
	 (cond [(eq_attr "med_branch_p" "yes")
		(const_int 2)
		(and (eq (symbol_ref "GET_CODE (PREV_INSN (insn))")
			 (symbol_ref "INSN"))
		     (eq (symbol_ref "INSN_CODE (PREV_INSN (insn))")
			 (symbol_ref "code_for_indirect_jump_scratch")))
		(if_then_else (eq_attr "braf_branch_p" "yes")
			      (const_int 6)
			      (const_int 10))
		(eq_attr "braf_branch_p" "yes")
		(const_int 10)
;; ??? using pc is not computed transitively.
		(ne (match_dup 0) (match_dup 0))
		(const_int 12)
		(ne (symbol_ref ("flag_pic")) (const_int 0))
		(const_int 22)
		] (const_int 14))
	 ] (const_int 2)))

;; (define_function_unit {name} {num-units} {n-users} {test}
;;                       {ready-delay} {issue-delay} [{conflict-list}])

;; Load and store instructions save a cycle if they are aligned on a
;; four byte boundary.  Using a function unit for stores encourages
;; gcc to separate load and store instructions by one instruction,
;; which makes it more likely that the linker will be able to word
;; align them when relaxing.

;; Loads have a latency of two.
;; However, call insns can have a delay slot, so that we want one more
;; insn to be scheduled between the load of the function address and the call.
;; This is equivalent to a latency of three.
;; We cannot use a conflict list for this, because we need to distinguish
;; between the actual call address and the function arguments.
;; ADJUST_COST can only properly handle reductions of the cost, so we
;; use a latency of three here.
;; We only do this for SImode loads of general registers, to make the work
;; for ADJUST_COST easier.
(define_function_unit "memory" 1 0
  (and (eq_attr "issues" "1")
       (eq_attr "type" "load_si,pcload_si"))
  3 2)
(define_function_unit "memory" 1 0
  (and (eq_attr "issues" "1")
       (eq_attr "type" "load,pcload,pload,store,pstore"))
  2 2)

(define_function_unit "int"    1 0
  (and (eq_attr "issues" "1") (eq_attr "type" "arith3,arith3b")) 3 3)

(define_function_unit "int"    1 0
  (and (eq_attr "issues" "1") (eq_attr "type" "dyn_shift")) 2 2)

(define_function_unit "int"    1 0
  (and (eq_attr "issues" "1") (eq_attr "type" "!arith3,arith3b,dyn_shift")) 1 1)

;; ??? These are approximations.
(define_function_unit "mpy"    1 0
  (and (eq_attr "issues" "1") (eq_attr "type" "smpy")) 2 2)
(define_function_unit "mpy"    1 0
  (and (eq_attr "issues" "1") (eq_attr "type" "dmpy")) 3 3)

(define_function_unit "fp"     1 0
  (and (eq_attr "issues" "1") (eq_attr "type" "fp,fmove")) 2 1)
(define_function_unit "fp"     1 0
  (and (eq_attr "issues" "1") (eq_attr "type" "fdiv")) 13 12)


;; SH4 scheduling
;; The SH4 is a dual-issue implementation, thus we have to multiply all
;; costs by at least two.
;; There will be single increments of the modeled that don't correspond
;; to the actual target ;; whenever two insns to be issued depend one a
;; single resource, and the scheduler picks to be the first one.
;; If we multiplied the costs just by two, just two of these single
;; increments would amount to an actual cycle.  By picking a larger
;; factor, we can ameliorate the effect; However, we then have to make sure
;; that only two insns are modeled as issued per actual cycle.
;; Moreover, we need a way to specify the latency of insns that don't
;; use an actual function unit.
;; We use an 'issue' function unit to do that, and a cost factor of 10.

(define_function_unit "issue" 2 0
  (and (eq_attr "issues" "2") (eq_attr "type" "!nil,arith3"))
  10 10)

(define_function_unit "issue" 2 0
  (and (eq_attr "issues" "2") (eq_attr "type" "arith3"))
  30 30)

;; There is no point in providing exact scheduling information about branches,
;; because they are at the starts / ends of basic blocks anyways.

;; Some insns cannot be issued before/after another insn in the same cycle,
;; irrespective of the type of the other insn.

;; default is dual-issue, but can't be paired with an insn that
;; uses multiple function units.
(define_function_unit "single_issue"     1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "!smpy,dmpy,pload,pstore,dfp_cmp,gp_fpul,call,sfunc,arith3,arith3b"))
  1 10
  [(eq_attr "type" "smpy,dmpy,pload,pstore,dfp_cmp,gp_fpul")])

(define_function_unit "single_issue"     1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "smpy,dmpy,pload,pstore,dfp_cmp,gp_fpul"))
  10 10
  [(const_int 1)])

;; arith3 insns are always pairable at the start, but not inecessarily at
;; the end; however, there doesn;t seem to be a way to express that.
(define_function_unit "single_issue"     1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "arith3"))
  30 20
  [(const_int 1)])

;; arith3b insn are pairable at the end and have latency that prevents pairing
;; with the following branch, but we don't want this latency be respected;
;; When the following branch is immediately adjacent, we can redirect the
;; internal branch, which is likly to be a larger win.
(define_function_unit "single_issue"     1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "arith3b"))
  20 20
  [(const_int 1)])

;; calls introduce a longisch delay that is likely to flush the pipelines.
(define_function_unit "single_issue"     1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "call,sfunc"))
  160 160
  [(eq_attr "type" "!call") (eq_attr "type" "call")])

;; Load and store instructions have no alignment peculiarities for the SH4,
;; but they use the load-store unit, which they share with the fmove type
;; insns (fldi[01]; fmov frn,frm; flds; fsts; fabs; fneg) .
;; Loads have a latency of two.
;; However, call insns can only paired with a preceding insn, and have
;; a delay slot, so that we want two more insns to be scheduled between the
;; load of the function address and the call.  This is equivalent to a
;; latency of three.
;; We cannot use a conflict list for this, because we need to distinguish
;; between the actual call address and the function arguments.
;; ADJUST_COST can only properly handle reductions of the cost, so we
;; use a latency of three here, which gets multiplied by 10 to yield 30.
;; We only do this for SImode loads of general registers, to make the work
;; for ADJUST_COST easier.

;; When specifying different latencies for different insns using the
;; the same function unit, genattrtab.c assumes a 'FIFO constraint'
;; so that the blockage is at least READY-COST (E) + 1 - READY-COST (C)
;; for an executing insn E and a candidate insn C.
;; Therefore, we define three different function units for load_store:
;; load_store, load and load_si.

(define_function_unit "load_si" 1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "load_si,pcload_si")) 30 10)
(define_function_unit "load" 1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "load,pcload,pload")) 20 10)
(define_function_unit "load_store" 1 0
  (and (eq_attr "issues" "2")
       (eq_attr "type" "load_si,pcload_si,load,pcload,pload,store,pstore,fmove"))
  10 10)

(define_function_unit "int"    1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "arith,dyn_shift")) 10 10)

;; Again, we have to pretend a lower latency for the "int" unit to avoid a
;; spurious FIFO constraint; the multiply instructions use the "int"
;; unit actually only for two cycles.
(define_function_unit "int"    1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "smpy,dmpy")) 20 20)

;; We use a fictous "mpy" unit to express the actual latency.
(define_function_unit "mpy"    1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "smpy,dmpy")) 40 20)

;; Again, we have to pretend a lower latency for the "int" unit to avoid a
;; spurious FIFO constraint.
(define_function_unit "int"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "gp_fpul")) 10 10)

;; We use a fictous "gp_fpul" unit to express the actual latency.
(define_function_unit "gp_fpul"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "gp_fpul")) 20 10)

;; ??? multiply uses the floating point unit, but with a two cycle delay.
;; Thus, a simple single-precision fp operation could finish if issued in
;; the very next cycle, but stalls when issued two or three cycles later.
;; Similarily, a divide / sqrt can work without stalls if issued in
;; the very next cycle, while it would have to block if issued two or
;; three cycles later.
;; There is no way to model this with gcc's function units.  This problem is
;; actually mentioned in md.texi.  Tackling this problem requires first that
;; it is possible to speak about the target in an open discussion.
;; 
;; However, simple double-precision operations always conflict.

(define_function_unit "fp"    1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "smpy,dmpy")) 40 40
  [(eq_attr "type" "dfp_cmp,dfp_conv,dfp_arith")])

;; The "fp" unit is for pipeline stages F1 and F2.

(define_function_unit "fp"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "fp")) 30 10)

;; Again, we have to pretend a lower latency for the "fp" unit to avoid a
;; spurious FIFO constraint; the bulk of the fdiv type insns executes in
;; the F3 stage.
(define_function_unit "fp"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "fdiv")) 30 10)

;; The "fdiv" function unit models the aggregate effect of the F1, F2 and F3
;; pipeline stages on the pipelining of fdiv/fsqrt insns.
;; We also use it to give the actual latency here.
;; fsqrt is actually one cycle faster than fdiv (and the value used here),
;; but that will hardly matter in practice for scheduling.
(define_function_unit "fdiv"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "fdiv")) 120 100)

;; There is again a late use of the "fp" unit by [d]fdiv type insns
;; that we can't express.

(define_function_unit "fp"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "dfp_cmp,dfp_conv")) 40 20)

(define_function_unit "fp"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "dfp_arith")) 80 60)

(define_function_unit "fp"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "dfdiv")) 230 10)

(define_function_unit "fdiv"     1 0
  (and (eq_attr "issues" "2") (eq_attr "type" "dfdiv")) 230 210)

; Definitions for filling branch delay slots.

(define_attr "needs_delay_slot" "yes,no" (const_string "no"))

;; ??? This should be (nil) instead of (const_int 0)
(define_attr "hit_stack" "yes,no"
	(cond [(eq (symbol_ref "find_regno_note (insn, REG_INC, SP_REG)")
		   (const_int 0))
	       (const_string "no")]
	      (const_string "yes")))

(define_attr "interrupt_function" "no,yes"
  (const (symbol_ref "current_function_interrupt")))

(define_attr "in_delay_slot" "yes,no"
  (cond [(eq_attr "type" "cbranch") (const_string "no")
	 (eq_attr "type" "pcload,pcload_si") (const_string "no")
	 (eq_attr "needs_delay_slot" "yes") (const_string "no")
	 (eq_attr "length" "2") (const_string "yes")
	 ] (const_string "no")))

(define_attr "is_sfunc" ""
  (if_then_else (eq_attr "type" "sfunc") (const_int 1) (const_int 0)))

(define_delay
  (eq_attr "needs_delay_slot" "yes")
  [(eq_attr "in_delay_slot" "yes") (nil) (nil)])

;; On the SH and SH2, the rte instruction reads the return pc from the stack,
;; and thus we can't put a pop instruction in its delay slot.
;; ??? On the SH3, the rte instruction does not use the stack, so a pop
;; instruction can go in the delay slot.

;; Since a normal return (rts) implicitly uses the PR register,
;; we can't allow PR register loads in an rts delay slot.

(define_delay
  (eq_attr "type" "return")
  [(and (eq_attr "in_delay_slot" "yes")
	(ior (and (eq_attr "interrupt_function" "no")
		  (eq_attr "type" "!pload,prset"))
	     (and (eq_attr "interrupt_function" "yes")
		  (ior
		   (ne (symbol_ref "TARGET_SH3") (const_int 0))
		   (eq_attr "hit_stack" "no"))))) (nil) (nil)])

;; Since a call implicitly uses the PR register, we can't allow
;; a PR register store in a jsr delay slot.

(define_delay
  (ior (eq_attr "type" "call") (eq_attr "type" "sfunc"))
  [(and (eq_attr "in_delay_slot" "yes")
	(eq_attr "type" "!pstore,prget")) (nil) (nil)])

;; Say that we have annulled true branches, since this gives smaller and
;; faster code when branches are predicted as not taken.

(define_delay
  (and (eq_attr "type" "cbranch")
       (ne (symbol_ref "TARGET_SH2") (const_int 0)))
  [(eq_attr "in_delay_slot" "yes") (eq_attr "in_delay_slot" "yes") (nil)])

;; -------------------------------------------------------------------------
;; SImode signed integer comparisons
;; -------------------------------------------------------------------------

(define_insn ""
  [(set (reg:SI T_REG)
	(eq:SI (and:SI (match_operand:SI 0 "arith_reg_operand" "z,r")
		       (match_operand:SI 1 "arith_operand" "L,r"))
	       (const_int 0)))]
  ""
  "tst	%1,%0")

;; ??? Perhaps should only accept reg/constant if the register is reg 0.
;; That would still allow reload to create cmpi instructions, but would
;; perhaps allow forcing the constant into a register when that is better.
;; Probably should use r0 for mem/imm compares, but force constant into a
;; register for pseudo/imm compares.

(define_insn "cmpeqsi_t"
  [(set (reg:SI T_REG)
	(eq:SI (match_operand:SI 0 "arith_reg_operand" "r,z,r")
	       (match_operand:SI 1 "arith_operand" "N,rI,r")))]
  ""
  "@
	tst	%0,%0
	cmp/eq	%1,%0
	cmp/eq	%1,%0")

(define_insn "cmpgtsi_t"
  [(set (reg:SI T_REG)
	(gt:SI (match_operand:SI 0 "arith_reg_operand" "r,r")
	       (match_operand:SI 1 "arith_reg_or_0_operand" "r,N")))]
  ""
  "@
	cmp/gt	%1,%0
	cmp/pl	%0")

(define_insn "cmpgesi_t"
  [(set (reg:SI T_REG)
	(ge:SI (match_operand:SI 0 "arith_reg_operand" "r,r")
	       (match_operand:SI 1 "arith_reg_or_0_operand" "r,N")))]
  ""
  "@
	cmp/ge	%1,%0
	cmp/pz	%0")

;; -------------------------------------------------------------------------
;; SImode unsigned integer comparisons
;; -------------------------------------------------------------------------

(define_insn "cmpgeusi_t"
  [(set (reg:SI T_REG)
	(geu:SI (match_operand:SI 0 "arith_reg_operand" "r")
		(match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "cmp/hs	%1,%0")

(define_insn "cmpgtusi_t"
  [(set (reg:SI T_REG)
	(gtu:SI (match_operand:SI 0 "arith_reg_operand" "r")
		(match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "cmp/hi	%1,%0")

;; We save the compare operands in the cmpxx patterns and use them when
;; we generate the branch.

(define_expand "cmpsi"
  [(set (reg:SI T_REG)
	(compare (match_operand:SI 0 "arith_operand" "")
		 (match_operand:SI 1 "arith_operand" "")))]
  ""
  "
{
  sh_compare_op0 = operands[0];
  sh_compare_op1 = operands[1];
  DONE;
}")

;; -------------------------------------------------------------------------
;; DImode signed integer comparisons
;; -------------------------------------------------------------------------

;; ??? Could get better scheduling by splitting the initial test from the
;; rest of the insn after reload.  However, the gain would hardly justify
;; the sh.md size increase necessary to do that.

(define_insn ""
  [(set (reg:SI T_REG)
	(eq:SI (and:DI (match_operand:DI 0 "arith_reg_operand" "r")
		       (match_operand:DI 1 "arith_operand" "r"))
	       (const_int 0)))]
  ""
  "* return output_branchy_insn (EQ, \"tst\\t%S1,%S0\;bf\\t%l9\;tst\\t%R1,%R0\",
				 insn, operands);"
  [(set_attr "length" "6")
   (set_attr "type" "arith3b")])

(define_insn "cmpeqdi_t"
  [(set (reg:SI T_REG)
	(eq:SI (match_operand:DI 0 "arith_reg_operand" "r,r")
	       (match_operand:DI 1 "arith_reg_or_0_operand" "N,r")))]
  ""
  "@
	tst	%S0,%S0\;bf	%,Ldi%=\;tst	%R0,%R0\\n%,Ldi%=:
	cmp/eq	%S1,%S0\;bf	%,Ldi%=\;cmp/eq	%R1,%R0\\n%,Ldi%=:"
  [(set_attr "length" "6")
   (set_attr "type" "arith3b")])

(define_split
  [(set (reg:SI T_REG)
	(eq:SI (match_operand:DI 0 "arith_reg_operand" "r,r")
	       (match_operand:DI 1 "arith_reg_or_0_operand" "N,r")))]
;; If we applied this split when not optimizing, it would only be
;; applied during the machine-dependent reorg, when no new basic blocks
;; may be created.
  "reload_completed && optimize"
  [(set (reg:SI T_REG) (eq:SI (match_dup 2) (match_dup 3)))
   (set (pc) (if_then_else (eq (reg:SI T_REG) (const_int 0))
			   (label_ref (match_dup 6))
			   (pc)))
   (set (reg:SI T_REG) (eq:SI (match_dup 4) (match_dup 5)))
   (match_dup 6)]
  "
{
  operands[2]
    = gen_rtx_REG (SImode,
		   true_regnum (operands[0]) + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  operands[3]
    = (operands[1] == const0_rtx
       ? const0_rtx
       : gen_rtx_REG (SImode,
		      true_regnum (operands[1])
		      + (TARGET_LITTLE_ENDIAN ? 1 : 0)));
  operands[4] = gen_lowpart (SImode, operands[0]);
  operands[5] = gen_lowpart (SImode, operands[1]);
  operands[6] = gen_label_rtx ();
}")

(define_insn "cmpgtdi_t"
  [(set (reg:SI T_REG)
	(gt:SI (match_operand:DI 0 "arith_reg_operand" "r,r")
	       (match_operand:DI 1 "arith_reg_or_0_operand" "r,N")))]
  "TARGET_SH2"
  "@
	cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/gt\\t%S1,%S0\;cmp/hi\\t%R1,%R0\\n%,Ldi%=:
	tst\\t%S0,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/pl\\t%S0\;cmp/hi\\t%S0,%R0\\n%,Ldi%=:"
  [(set_attr "length" "8")
   (set_attr "type" "arith3")])

(define_insn "cmpgedi_t"
  [(set (reg:SI T_REG)
	(ge:SI (match_operand:DI 0 "arith_reg_operand" "r,r")
	       (match_operand:DI 1 "arith_reg_or_0_operand" "r,N")))]
  "TARGET_SH2"
  "@
	cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/ge\\t%S1,%S0\;cmp/hs\\t%R1,%R0\\n%,Ldi%=:
	cmp/pz\\t%S0"
  [(set_attr "length" "8,2")
   (set_attr "type" "arith3,arith")])

;; -------------------------------------------------------------------------
;; DImode unsigned integer comparisons
;; -------------------------------------------------------------------------

(define_insn "cmpgeudi_t"
  [(set (reg:SI T_REG)
	(geu:SI (match_operand:DI 0 "arith_reg_operand" "r")
		(match_operand:DI 1 "arith_reg_operand" "r")))]
  "TARGET_SH2"
  "cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/hs\\t%S1,%S0\;cmp/hs\\t%R1,%R0\\n%,Ldi%=:"
  [(set_attr "length" "8")
   (set_attr "type" "arith3")])

(define_insn "cmpgtudi_t"
  [(set (reg:SI T_REG)
	(gtu:SI (match_operand:DI 0 "arith_reg_operand" "r")
		(match_operand:DI 1 "arith_reg_operand" "r")))]
  "TARGET_SH2"
  "cmp/eq\\t%S1,%S0\;bf{.|/}s\\t%,Ldi%=\;cmp/hi\\t%S1,%S0\;cmp/hi\\t%R1,%R0\\n%,Ldi%=:"
  [(set_attr "length" "8")
   (set_attr "type" "arith3")])

;; We save the compare operands in the cmpxx patterns and use them when
;; we generate the branch.

(define_expand "cmpdi"
  [(set (reg:SI T_REG)
	(compare (match_operand:DI 0 "arith_operand" "")
		 (match_operand:DI 1 "arith_operand" "")))]
  "TARGET_SH2"
  "
{
  sh_compare_op0 = operands[0];
  sh_compare_op1 = operands[1];
  DONE;
}")

;; -------------------------------------------------------------------------
;; Addition instructions
;; -------------------------------------------------------------------------

;; ??? This should be a define expand.

(define_insn "adddi3"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(plus:DI (match_operand:DI 1 "arith_reg_operand" "%0")
		 (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI T_REG))]
  ""
  "#"
  [(set_attr "length" "6")])

(define_split
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(plus:DI (match_operand:DI 1 "arith_reg_operand" "%0")
		 (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI T_REG))]
  "reload_completed"
  [(const_int 0)]
  "
{
  rtx high0, high2, low0 = gen_lowpart (SImode, operands[0]);
  high0 = gen_rtx_REG (SImode,
		       true_regnum (operands[0])
		       + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  high2 = gen_rtx_REG (SImode,
		       true_regnum (operands[2])
		       + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  emit_insn (gen_clrt ());
  emit_insn (gen_addc (low0, low0, gen_lowpart (SImode, operands[2])));
  emit_insn (gen_addc1 (high0, high0, high2));
  DONE;
}")

(define_insn "addc"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (plus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			  (match_operand:SI 2 "arith_reg_operand" "r"))
		 (reg:SI T_REG)))
   (set (reg:SI T_REG)
	(ltu:SI (plus:SI (match_dup 1) (match_dup 2)) (match_dup 1)))]
  ""
  "addc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "addc1"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (plus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			  (match_operand:SI 2 "arith_reg_operand" "r"))
		 (reg:SI T_REG)))
   (clobber (reg:SI T_REG))]
  ""
  "addc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "addsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (match_operand:SI 1 "arith_operand" "%0")
		 (match_operand:SI 2 "arith_operand" "rI")))]
  ""
  "add	%2,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Subtraction instructions
;; -------------------------------------------------------------------------

;; ??? This should be a define expand.

(define_insn "subdi3"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(minus:DI (match_operand:DI 1 "arith_reg_operand" "0")
		 (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI T_REG))]
  ""
  "#"
  [(set_attr "length" "6")])

(define_split
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(minus:DI (match_operand:DI 1 "arith_reg_operand" "0")
		  (match_operand:DI 2 "arith_reg_operand" "r")))
   (clobber (reg:SI T_REG))]
  "reload_completed"
  [(const_int 0)]
  "
{
  rtx high0, high2, low0 = gen_lowpart (SImode, operands[0]);
  high0 = gen_rtx_REG (SImode,
		       true_regnum (operands[0])
		       + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  high2 = gen_rtx_REG (SImode,
		       true_regnum (operands[2])
		       + (TARGET_LITTLE_ENDIAN ? 1 : 0));
  emit_insn (gen_clrt ());
  emit_insn (gen_subc (low0, low0, gen_lowpart (SImode, operands[2])));
  emit_insn (gen_subc1 (high0, high0, high2));
  DONE;
}")

(define_insn "subc"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(minus:SI (minus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			    (match_operand:SI 2 "arith_reg_operand" "r"))
		  (reg:SI T_REG)))
   (set (reg:SI T_REG)
	(gtu:SI (minus:SI (match_dup 1) (match_dup 2)) (match_dup 1)))]
  ""
  "subc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "subc1"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(minus:SI (minus:SI (match_operand:SI 1 "arith_reg_operand" "0")
			    (match_operand:SI 2 "arith_reg_operand" "r"))
		  (reg:SI T_REG)))
   (clobber (reg:SI T_REG))]
  ""
  "subc	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "*subsi3_internal"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(minus:SI (match_operand:SI 1 "arith_reg_operand" "0")
		  (match_operand:SI 2 "arith_reg_operand" "r")))]
  ""
  "sub	%2,%0"
  [(set_attr "type" "arith")])

;; Convert `constant - reg' to `neg rX; add rX, #const' since this
;; will sometimes save one instruction.  Otherwise we might get
;; `mov #const, rY; sub rY,rX; mov rX, rY' if the source and dest regs
;; are the same.

(define_expand "subsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(minus:SI (match_operand:SI 1 "arith_operand" "")
		  (match_operand:SI 2 "arith_reg_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[1]) == CONST_INT)
    {
      emit_insn (gen_negsi2 (operands[0], operands[2]));
      emit_insn (gen_addsi3 (operands[0], operands[0], operands[1]));
      DONE;
    }
}")

;; -------------------------------------------------------------------------
;; Division instructions
;; -------------------------------------------------------------------------

;; We take advantage of the library routines which don't clobber as many
;; registers as a normal function call would.

;; The INSN_REFERENCES_ARE_DELAYED in sh.h is problematic because it
;; also has an effect on the register that holds the address of the sfunc.
;; To make this work, we have an extra dummy insns that shows the use
;; of this register for reorg.

(define_insn "use_sfunc_addr"
  [(set (reg:SI PR_REG)
	(unspec [(match_operand:SI 0 "register_operand" "r")] UNSPEC_SFUNC))]
  ""
  ""
  [(set_attr "length" "0")])

;; We must use a pseudo-reg forced to reg 0 in the SET_DEST rather than
;; hard register 0.  If we used hard register 0, then the next instruction
;; would be a move from hard register 0 to a pseudo-reg.  If the pseudo-reg
;; gets allocated to a stack slot that needs its address reloaded, then
;; there is nothing to prevent reload from using r0 to reload the address.
;; This reload would clobber the value in r0 we are trying to store.
;; If we let reload allocate r0, then this problem can never happen.

(define_insn "udivsi3_i1"
  [(set (match_operand:SI 0 "register_operand" "=z")
	(udiv:SI (reg:SI R4_REG) (reg:SI R5_REG)))
   (clobber (reg:SI T_REG))
   (clobber (reg:SI PR_REG))
   (clobber (reg:SI R4_REG))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  "! TARGET_SH4"
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "udivsi3_i4"
  [(set (match_operand:SI 0 "register_operand" "=y")
	(udiv:SI (reg:SI R4_REG) (reg:SI R5_REG)))
   (clobber (reg:SI T_REG))
   (clobber (reg:SI PR_REG))
   (clobber (reg:DF DR0_REG))
   (clobber (reg:DF DR2_REG))
   (clobber (reg:DF DR4_REG))
   (clobber (reg:SI R0_REG))
   (clobber (reg:SI R1_REG))
   (clobber (reg:SI R4_REG))
   (clobber (reg:SI R5_REG))
   (use (reg:PSI FPSCR_REG))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  "TARGET_SH4 && ! TARGET_FPU_SINGLE"
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "fp_mode" "double")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "udivsi3_i4_single"
  [(set (match_operand:SI 0 "register_operand" "=y")
	(udiv:SI (reg:SI R4_REG) (reg:SI R5_REG)))
   (clobber (reg:SI T_REG))
   (clobber (reg:SI PR_REG))
   (clobber (reg:DF DR0_REG))
   (clobber (reg:DF DR2_REG))
   (clobber (reg:DF DR4_REG))
   (clobber (reg:SI R0_REG))
   (clobber (reg:SI R1_REG))
   (clobber (reg:SI R4_REG))
   (clobber (reg:SI R5_REG))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  "TARGET_HARD_SH4 && TARGET_FPU_SINGLE"
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "udivsi3"
  [(set (match_dup 3) (symbol_ref:SI "__udivsi3"))
   (set (reg:SI R4_REG) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI R5_REG) (match_operand:SI 2 "general_operand" ""))
   (parallel [(set (match_operand:SI 0 "register_operand" "")
		   (udiv:SI (reg:SI R4_REG)
			    (reg:SI R5_REG)))
	      (clobber (reg:SI T_REG))
	      (clobber (reg:SI PR_REG))
	      (clobber (reg:SI R4_REG))
	      (use (match_dup 3))])]
  ""
  "
{
  rtx first, last;

  operands[3] = gen_reg_rtx(SImode);
  /* Emit the move of the address to a pseudo outside of the libcall.  */
  if (TARGET_HARD_SH4 && TARGET_SH3E)
    {
      emit_move_insn (operands[3],
		      gen_rtx_SYMBOL_REF (SImode, \"__udivsi3_i4\"));
      if (TARGET_FPU_SINGLE)
	last = gen_udivsi3_i4_single (operands[0], operands[3]);
      else
	last = gen_udivsi3_i4 (operands[0], operands[3]);
    }
  else
    {
      emit_move_insn (operands[3],
		      gen_rtx_SYMBOL_REF (SImode, \"__udivsi3\"));
      last = gen_udivsi3_i1 (operands[0], operands[3]);
    }
  first = emit_move_insn (gen_rtx_REG (SImode, 4), operands[1]);
  emit_move_insn (gen_rtx_REG (SImode, 5), operands[2]);
  last = emit_insn (last);
  /* Wrap the sequence in REG_LIBCALL / REG_RETVAL notes so that loop
     invariant code motion can move it.  */
  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last, REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));
  DONE;
}")

(define_insn "divsi3_i1"
  [(set (match_operand:SI 0 "register_operand" "=z")
	(div:SI (reg:SI R4_REG) (reg:SI R5_REG)))
   (clobber (reg:SI T_REG))
   (clobber (reg:SI PR_REG))
   (clobber (reg:SI R1_REG))
   (clobber (reg:SI R2_REG))
   (clobber (reg:SI R3_REG))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  "! TARGET_SH4"
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "divsi3_i4"
  [(set (match_operand:SI 0 "register_operand" "=y")
	(div:SI (reg:SI R4_REG) (reg:SI R5_REG)))
   (clobber (reg:SI PR_REG))
   (clobber (reg:DF DR0_REG))
   (clobber (reg:DF DR2_REG))
   (use (reg:PSI FPSCR_REG))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  "TARGET_SH4 && ! TARGET_FPU_SINGLE"
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "fp_mode" "double")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "divsi3_i4_single"
  [(set (match_operand:SI 0 "register_operand" "=y")
	(div:SI (reg:SI R4_REG) (reg:SI R5_REG)))
   (clobber (reg:SI PR_REG))
   (clobber (reg:DF DR0_REG))
   (clobber (reg:DF DR2_REG))
   (clobber (reg:SI R2_REG))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  "TARGET_HARD_SH4 && TARGET_FPU_SINGLE"
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "divsi3"
  [(set (match_dup 3) (symbol_ref:SI "__sdivsi3"))
   (set (reg:SI R4_REG) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI R5_REG) (match_operand:SI 2 "general_operand" ""))
   (parallel [(set (match_operand:SI 0 "register_operand" "")
		   (div:SI (reg:SI R4_REG)
			   (reg:SI R5_REG)))
	      (clobber (reg:SI T_REG))
	      (clobber (reg:SI PR_REG))
	      (clobber (reg:SI R1_REG))
	      (clobber (reg:SI R2_REG))
	      (clobber (reg:SI R3_REG))
	      (use (match_dup 3))])]
  ""
  "
{
  rtx first, last;

  operands[3] = gen_reg_rtx(SImode);
  /* Emit the move of the address to a pseudo outside of the libcall.  */
  if (TARGET_HARD_SH4 && TARGET_SH3E)
    {
      emit_move_insn (operands[3],
		      gen_rtx_SYMBOL_REF (SImode, \"__sdivsi3_i4\"));
      if (TARGET_FPU_SINGLE)
	last = gen_divsi3_i4_single (operands[0], operands[3]);
      else
	last = gen_divsi3_i4 (operands[0], operands[3]);
    }
  else
    {
      emit_move_insn (operands[3], gen_rtx_SYMBOL_REF (SImode, \"__sdivsi3\"));
      last = gen_divsi3_i1 (operands[0], operands[3]);
    }
  first = emit_move_insn (gen_rtx_REG (SImode, 4), operands[1]);
  emit_move_insn (gen_rtx_REG (SImode, 5), operands[2]);
  last = emit_insn (last);
  /* Wrap the sequence in REG_LIBCALL / REG_RETVAL notes so that loop
     invariant code motion can move it.  */
  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last, REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));
  DONE;
}")

;; -------------------------------------------------------------------------
;; Multiplication instructions
;; -------------------------------------------------------------------------

(define_insn "umulhisi3_i"
  [(set (reg:SI MACL_REG)
	(mult:SI (zero_extend:SI
		  (match_operand:HI 0 "arith_reg_operand" "r"))
		 (zero_extend:SI
		  (match_operand:HI 1 "arith_reg_operand" "r"))))]
  ""
  "mulu.w	%1,%0"
  [(set_attr "type" "smpy")])

(define_insn "mulhisi3_i"
  [(set (reg:SI MACL_REG)
	(mult:SI (sign_extend:SI
		  (match_operand:HI 0 "arith_reg_operand" "r"))
		 (sign_extend:SI
		  (match_operand:HI 1 "arith_reg_operand" "r"))))]
  ""
  "muls.w	%1,%0"
  [(set_attr "type" "smpy")])

(define_expand "mulhisi3"
  [(set (reg:SI MACL_REG)
	(mult:SI (sign_extend:SI
		  (match_operand:HI 1 "arith_reg_operand" ""))
		 (sign_extend:SI
		  (match_operand:HI 2 "arith_reg_operand" ""))))
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI MACL_REG))]
  ""
  "
{
  rtx first, last;

  first = emit_insn (gen_mulhisi3_i (operands[1], operands[2]));
  last = emit_move_insn (operands[0], gen_rtx_REG (SImode, MACL_REG));
  /* Wrap the sequence in REG_LIBCALL / REG_RETVAL notes so that loop
     invariant code motion can move it.  */
  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last, REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));
  DONE;
}")

(define_expand "umulhisi3"
  [(set (reg:SI MACL_REG)
	(mult:SI (zero_extend:SI
		  (match_operand:HI 1 "arith_reg_operand" ""))
		 (zero_extend:SI
		  (match_operand:HI 2 "arith_reg_operand" ""))))
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI MACL_REG))]
  ""
  "
{
  rtx first, last;

  first = emit_insn (gen_umulhisi3_i (operands[1], operands[2]));
  last = emit_move_insn (operands[0], gen_rtx_REG (SImode, MACL_REG));
  /* Wrap the sequence in REG_LIBCALL / REG_RETVAL notes so that loop
     invariant code motion can move it.  */
  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last, REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));
  DONE;
}")

;; mulsi3 on the SH2 can be done in one instruction, on the SH1 we generate
;; a call to a routine which clobbers known registers.

(define_insn ""
  [(set (match_operand:SI 1 "register_operand" "=z")
	(mult:SI (reg:SI R4_REG) (reg:SI R5_REG)))
   (clobber (reg:SI MACL_REG))
   (clobber (reg:SI T_REG))
   (clobber (reg:SI PR_REG))
   (clobber (reg:SI R3_REG))
   (clobber (reg:SI R2_REG))
   (clobber (reg:SI R1_REG))
   (use (match_operand:SI 0 "arith_reg_operand" "r"))]
  ""
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "mulsi3_call"
  [(set (reg:SI R4_REG) (match_operand:SI 1 "general_operand" ""))
   (set (reg:SI R5_REG) (match_operand:SI 2 "general_operand" ""))
   (parallel[(set (match_operand:SI 0 "register_operand" "")
		  (mult:SI (reg:SI R4_REG)
			   (reg:SI R5_REG)))
	     (clobber (reg:SI MACL_REG))
	     (clobber (reg:SI T_REG))
	     (clobber (reg:SI PR_REG))
	     (clobber (reg:SI R3_REG))
	     (clobber (reg:SI R2_REG))
	     (clobber (reg:SI R1_REG))
	     (use (match_operand:SI 3 "register_operand" ""))])]
  ""
  "")

(define_insn "mul_l"
  [(set (reg:SI MACL_REG)
	(mult:SI (match_operand:SI 0 "arith_reg_operand" "r")
		 (match_operand:SI 1 "arith_reg_operand" "r")))]
  "TARGET_SH2"
  "mul.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "mulsi3"
  [(set (reg:SI MACL_REG)
	(mult:SI  (match_operand:SI 1 "arith_reg_operand" "")
		  (match_operand:SI 2 "arith_reg_operand" "")))
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI MACL_REG))]
  ""
  "
{
  rtx first, last;

  if (!TARGET_SH2)
    {
      /* The address must be set outside the libcall,
	 since it goes into a pseudo.  */
      rtx sym = gen_rtx_SYMBOL_REF (SImode, \"__mulsi3\");
      rtx addr = force_reg (SImode, sym);
      rtx insns = gen_mulsi3_call (operands[0], operands[1],
				   operands[2], addr);
      first = XVECEXP (insns, 0, 0);
      last = XVECEXP (insns, 0, XVECLEN (insns, 0) - 1);
      emit_insn (insns);
    }
  else
    {
      rtx macl = gen_rtx_REG (SImode, MACL_REG);

      first = emit_insn (gen_mul_l (operands[1], operands[2]));
      /* consec_sets_giv can only recognize the first insn that sets a
	 giv as the giv insn.  So we must tag this also with a REG_EQUAL
	 note.  */
      last = emit_insn (gen_movsi_i ((operands[0]), macl));
    }
  /* Wrap the sequence in REG_LIBCALL / REG_RETVAL notes so that loop
     invariant code motion can move it.  */
  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last, REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));
  DONE;
}")

(define_insn "mulsidi3_i"
  [(set (reg:SI MACH_REG)
	(truncate:SI
	 (lshiftrt:DI
	  (mult:DI
	   (sign_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
	   (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" "r")))
	  (const_int 32))))
   (set (reg:SI MACL_REG)
	(mult:SI (match_dup 0)
		 (match_dup 1)))]
  "TARGET_SH2"
  "dmuls.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_insn "mulsidi3"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(mult:DI
	 (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" "r"))
	 (sign_extend:DI (match_operand:SI 2 "arith_reg_operand" "r"))))
   (clobber (reg:SI MACH_REG))
   (clobber (reg:SI MACL_REG))]
  "TARGET_SH2"
  "#")

(define_split
  [(set (match_operand:DI 0 "arith_reg_operand" "")
	(mult:DI
	 (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
	 (sign_extend:DI (match_operand:SI 2 "arith_reg_operand" ""))))
   (clobber (reg:SI MACH_REG))
   (clobber (reg:SI MACL_REG))]
  "TARGET_SH2"
  [(const_int 0)]
  "
{
  rtx low_dst = gen_lowpart (SImode, operands[0]);
  rtx high_dst = gen_highpart (SImode, operands[0]);

  emit_insn (gen_mulsidi3_i (operands[1], operands[2]));

  emit_move_insn (low_dst, gen_rtx_REG (SImode, MACL_REG));
  emit_move_insn (high_dst, gen_rtx_REG (SImode, MACH_REG));
  /* We need something to tag the possible REG_EQUAL notes on to.  */
  emit_move_insn (operands[0], operands[0]);
  DONE;
}")

(define_insn "umulsidi3_i"
  [(set (reg:SI MACH_REG)
	(truncate:SI
	 (lshiftrt:DI
	  (mult:DI
	   (zero_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
	   (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" "r")))
	  (const_int 32))))
   (set (reg:SI MACL_REG)
	(mult:SI (match_dup 0)
		 (match_dup 1)))]
  "TARGET_SH2"
  "dmulu.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_insn "umulsidi3"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(mult:DI
	 (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" "r"))
	 (zero_extend:DI (match_operand:SI 2 "arith_reg_operand" "r"))))
   (clobber (reg:SI MACH_REG))
   (clobber (reg:SI MACL_REG))]
  "TARGET_SH2"
  "#")

(define_split
  [(set (match_operand:DI 0 "arith_reg_operand" "")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
		 (zero_extend:DI (match_operand:SI 2 "arith_reg_operand" ""))))
   (clobber (reg:SI MACH_REG))
   (clobber (reg:SI MACL_REG))]
  "TARGET_SH2"
  [(const_int 0)]
  "
{
  rtx low_dst = gen_lowpart (SImode, operands[0]);
  rtx high_dst = gen_highpart (SImode, operands[0]);

  emit_insn (gen_umulsidi3_i (operands[1], operands[2]));

  emit_move_insn (low_dst, gen_rtx_REG (SImode, MACL_REG));
  emit_move_insn (high_dst, gen_rtx_REG (SImode, MACH_REG));
  /* We need something to tag the possible REG_EQUAL notes on to.  */
  emit_move_insn (operands[0], operands[0]);
  DONE;
}")

(define_insn "smulsi3_highpart_i"
  [(set (reg:SI MACH_REG)
	(truncate:SI
	 (lshiftrt:DI
	  (mult:DI
	   (sign_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
	   (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" "r")))
	  (const_int 32))))
   (clobber (reg:SI MACL_REG))]
  "TARGET_SH2"
  "dmuls.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "smulsi3_highpart"
  [(parallel
    [(set (reg:SI MACH_REG)
	  (truncate:SI
	   (lshiftrt:DI
	    (mult:DI
	     (sign_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
	     (sign_extend:DI (match_operand:SI 2 "arith_reg_operand" "")))
	    (const_int 32))))
    (clobber (reg:SI MACL_REG))])
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI MACH_REG))]
  "TARGET_SH2"
  "
{
  rtx first, last;

  first = emit_insn (gen_smulsi3_highpart_i (operands[1], operands[2]));
  last = emit_move_insn (operands[0], gen_rtx_REG (SImode, MACH_REG));
  /* Wrap the sequence in REG_LIBCALL / REG_RETVAL notes so that loop
     invariant code motion can move it.  */
  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last, REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));
  /* expand_binop can't find a suitable code in mul_highpart_optab to
     make a REG_EQUAL note from, so make one here.
     ??? Alternatively, we could put this at the calling site of expand_binop,
     i.e. expand_mult_highpart.  */
  REG_NOTES (last)
    = gen_rtx_EXPR_LIST (REG_EQUAL, copy_rtx (SET_SRC (single_set (first))),
			 REG_NOTES (last));
  DONE;
}")

(define_insn "umulsi3_highpart_i"
  [(set (reg:SI MACH_REG)
	(truncate:SI
	 (lshiftrt:DI
	  (mult:DI
	   (zero_extend:DI (match_operand:SI 0 "arith_reg_operand" "r"))
	   (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" "r")))
	  (const_int 32))))
   (clobber (reg:SI MACL_REG))]
  "TARGET_SH2"
  "dmulu.l	%1,%0"
  [(set_attr "type" "dmpy")])

(define_expand "umulsi3_highpart"
  [(parallel
    [(set (reg:SI MACH_REG)
	  (truncate:SI
	   (lshiftrt:DI
	    (mult:DI
	     (zero_extend:DI (match_operand:SI 1 "arith_reg_operand" ""))
	     (zero_extend:DI (match_operand:SI 2 "arith_reg_operand" "")))
	    (const_int 32))))
    (clobber (reg:SI MACL_REG))])
   (set (match_operand:SI 0 "arith_reg_operand" "")
	(reg:SI MACH_REG))]
  "TARGET_SH2"
  "
{
  rtx first, last;

  first = emit_insn (gen_umulsi3_highpart_i (operands[1], operands[2]));
  last = emit_move_insn (operands[0], gen_rtx_REG (SImode, MACH_REG));
  /* Wrap the sequence in REG_LIBCALL / REG_RETVAL notes so that loop
     invariant code motion can move it.  */
  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last, REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));
  DONE;
}")

;; -------------------------------------------------------------------------
;; Logical operations
;; -------------------------------------------------------------------------

(define_insn ""
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,z")
	(and:SI (match_operand:SI 1 "arith_reg_operand" "%0,0")
		(match_operand:SI 2 "logical_operand" "r,L")))]
  ""
  "and	%2,%0"
  [(set_attr "type" "arith")])

;; If the constant is 255, then emit a extu.b instruction instead of an
;; and, since that will give better code.

(define_expand "andsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(and:SI (match_operand:SI 1 "arith_reg_operand" "")
		(match_operand:SI 2 "logical_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT && INTVAL (operands[2]) == 255)
    {
      emit_insn (gen_zero_extendqisi2 (operands[0],
				       gen_lowpart (QImode, operands[1])));
      DONE;
    }
}")

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,z")
	(ior:SI (match_operand:SI 1 "arith_reg_operand" "%0,0")
		(match_operand:SI 2 "logical_operand" "r,L")))]
  ""
  "or	%2,%0"
  [(set_attr "type" "arith")])

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "=z,r")
	(xor:SI (match_operand:SI 1 "arith_reg_operand" "%0,0")
		(match_operand:SI 2 "logical_operand" "L,r")))]
  ""
  "xor	%2,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Shifts and rotates
;; -------------------------------------------------------------------------

(define_insn "rotlsi3_1"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "0")
		   (const_int 1)))
   (set (reg:SI T_REG)
	(lshiftrt:SI (match_dup 1) (const_int 31)))]
  ""
  "rotl	%0"
  [(set_attr "type" "arith")])

(define_insn "rotlsi3_31"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "0")
		   (const_int 31)))
   (clobber (reg:SI T_REG))]
  ""
  "rotr	%0"
  [(set_attr "type" "arith")])

(define_insn "rotlsi3_16"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "r")
		   (const_int 16)))]
  ""
  "swap.w	%1,%0"
  [(set_attr "type" "arith")])

(define_expand "rotlsi3"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(rotate:SI (match_operand:SI 1 "arith_reg_operand" "")
		   (match_operand:SI 2 "immediate_operand" "")))]
  ""
  "
{
  static char rot_tab[] = {
    000, 000, 000, 000, 000, 000, 010, 001,
    001, 001, 011, 013, 003, 003, 003, 003,
    003, 003, 003, 003, 003, 013, 012, 002,
    002, 002, 010, 000, 000, 000, 000, 000,
  };

  int count, choice;

  if (GET_CODE (operands[2]) != CONST_INT)
    FAIL;
  count = INTVAL (operands[2]);
  choice = rot_tab[count];
  if (choice & 010 && SH_DYNAMIC_SHIFT_COST <= 1)
    FAIL;
  choice &= 7;
  switch (choice)
    {
    case 0:
      emit_move_insn (operands[0], operands[1]);
      count -= (count & 16) * 2;
      break;
    case 3:
     emit_insn (gen_rotlsi3_16 (operands[0], operands[1]));
     count -= 16;
     break;
    case 1:
    case 2:
      {
	rtx parts[2];
	parts[0] = gen_reg_rtx (SImode);
	parts[1] = gen_reg_rtx (SImode);
	emit_insn (gen_rotlsi3_16 (parts[2-choice], operands[1]));
	parts[choice-1] = operands[1];
	emit_insn (gen_ashlsi3 (parts[0], parts[0], GEN_INT (8)));
	emit_insn (gen_lshrsi3 (parts[1], parts[1], GEN_INT (8)));
	emit_insn (gen_iorsi3 (operands[0], parts[0], parts[1]));
	count = (count & ~16) - 8;
      }
    }

  for (; count > 0; count--)
    emit_insn (gen_rotlsi3_1 (operands[0], operands[0]));
  for (; count < 0; count++)
    emit_insn (gen_rotlsi3_31 (operands[0], operands[0]));

  DONE;
}")

(define_insn "*rotlhi3_8"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r")
	(rotate:HI (match_operand:HI 1 "arith_reg_operand" "r")
		   (const_int 8)))]
  ""
  "swap.b	%1,%0"
  [(set_attr "type" "arith")])

(define_expand "rotlhi3"
  [(set (match_operand:HI 0 "arith_reg_operand" "")
	(rotate:HI (match_operand:HI 1 "arith_reg_operand" "")
		   (match_operand:HI 2 "immediate_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) != CONST_INT || INTVAL (operands[2]) != 8)
    FAIL;
}")

;;
;; shift left

;; This pattern is used by init_expmed for computing the costs of shift
;; insns.

(define_insn_and_split "ashlsi3_std"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,r,r,r")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "0,0,0,0")
		   (match_operand:SI 2 "nonmemory_operand" "r,M,K,?ri")))
   (clobber (match_scratch:SI 3 "=X,X,X,&r"))]
  "TARGET_SH3
   || (GET_CODE (operands[2]) == CONST_INT
       && CONST_OK_FOR_K (INTVAL (operands[2])))"
  "@
   shld	%2,%0
   add	%0,%0
   shll%O2	%0
   #"
  "TARGET_SH3
   && reload_completed
   && GET_CODE (operands[2]) == CONST_INT
   && ! CONST_OK_FOR_K (INTVAL (operands[2]))"
  [(set (match_dup 3) (match_dup 2))
   (parallel
    [(set (match_dup 0) (ashift:SI (match_dup 1) (match_dup 3)))
     (clobber (match_dup 4))])]
  "operands[4] = gen_rtx_SCRATCH (SImode);"
  [(set_attr "length" "*,*,*,4")
   (set_attr "type" "dyn_shift,arith,arith,arith")])

(define_insn "ashlhi3_k"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r,r")
	(ashift:HI (match_operand:HI 1 "arith_reg_operand" "0,0")
		   (match_operand:HI 2 "const_int_operand" "M,K")))]
  "CONST_OK_FOR_K (INTVAL (operands[2]))"
  "@
	add	%0,%0
	shll%O2	%0"
  [(set_attr "type" "arith")])

(define_insn "ashlsi3_n"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "0")
		   (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "! sh_dynamicalize_shift_p (operands[2])"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shift_insns_rtx (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 3))
	       (const_string "6")]
	      (const_string "8")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "")
		   (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "reload_completed"
  [(use (reg:SI R0_REG))]
  "
{
  gen_shifty_op (ASHIFT, operands);
  DONE;
}")

(define_expand "ashlsi3"
  [(parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (ashift:SI (match_operand:SI 1 "arith_reg_operand" "")
			      (match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:SI T_REG))])]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && sh_dynamicalize_shift_p (operands[2]))
    operands[2] = force_reg (SImode, operands[2]);
  if (TARGET_SH3)
    {
      emit_insn (gen_ashlsi3_std (operands[0], operands[1], operands[2]));
      DONE;
    }
  if (! immediate_operand (operands[2], GET_MODE (operands[2])))
    FAIL;
}")

(define_insn "ashlhi3"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r")
	(ashift:HI (match_operand:HI 1 "arith_reg_operand" "0")
		   (match_operand:HI 2 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  ""
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shift_insns_rtx (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 2))
	       (const_string "4")]
	      (const_string "6")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:HI 0 "arith_reg_operand" "")
	(ashift:HI (match_operand:HI 1 "arith_reg_operand" "")
		   (match_operand:HI 2 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "reload_completed"
  [(use (reg:SI R0_REG))]
  "
{
  gen_shifty_hi_op (ASHIFT, operands);
  DONE;
}")

;
; arithmetic shift right
;

(define_insn "ashrsi3_k"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "M")))
   (clobber (reg:SI T_REG))]
  "INTVAL (operands[2]) == 1"
  "shar	%0"
  [(set_attr "type" "arith")])

;; We can't do HImode right shifts correctly unless we start out with an
;; explicit zero / sign extension; doing that would result in worse overall
;; code, so just let the machine independent code widen the mode.
;; That's why we don't have ashrhi3_k / lshrhi3_k / lshrhi3_m / lshrhi3 .


;; ??? This should be a define expand.

(define_insn "ashrsi2_16"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "r")
                     (const_int 16)))]
  ""
  "#"
  [(set_attr "length" "4")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "r")
		     (const_int 16)))]
  ""
  [(set (match_dup 0) (rotate:SI (match_dup 1) (const_int 16)))
   (set (match_dup 0) (sign_extend:SI (match_dup 2)))]
  "operands[2] = gen_lowpart (HImode, operands[0]);")

;; ??? This should be a define expand.

(define_insn "ashrsi2_31"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (const_int 31)))
   (clobber (reg:SI T_REG))]
  ""
  "#"
  [(set_attr "length" "4")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (const_int 31)))
   (clobber (reg:SI T_REG))]
  ""
  [(const_int 0)]
  "
{
  emit_insn (gen_ashlsi_c (operands[0], operands[1]));
  emit_insn (gen_subc1 (operands[0], operands[0], operands[0]));
  DONE;
}")

(define_insn "ashlsi_c"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "arith_reg_operand" "0") (const_int 1)))
   (set (reg:SI T_REG)
	(lt:SI (match_dup 1) (const_int 0)))]
  ""
  "shll	%0"
  [(set_attr "type" "arith")])

(define_insn "ashrsi3_d"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (neg:SI (match_operand:SI 2 "arith_reg_operand" "r"))))]
  "TARGET_SH3"
  "shad	%2,%0"
  [(set_attr "type" "dyn_shift")])

(define_insn "ashrsi3_n"
  [(set (reg:SI R4_REG)
	(ashiftrt:SI (reg:SI R4_REG)
		     (match_operand:SI 0 "const_int_operand" "i")))
   (clobber (reg:SI T_REG))
   (clobber (reg:SI PR_REG))
   (use (match_operand:SI 1 "arith_reg_operand" "r"))]
  ""
  "jsr	@%1%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "ashrsi3"
  [(parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (ashiftrt:SI (match_operand:SI 1 "arith_reg_operand" "")
				(match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:SI T_REG))])]
  ""
  "if (expand_ashiftrt (operands)) DONE; else FAIL;")

;; logical shift right

(define_insn "lshrsi3_d"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (neg:SI (match_operand:SI 2 "arith_reg_operand" "r"))))]
  "TARGET_SH3"
  "shld	%2,%0"
  [(set_attr "type" "dyn_shift")])

;;  Only the single bit shift clobbers the T bit.

(define_insn "lshrsi3_m"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "M")))
   (clobber (reg:SI T_REG))]
  "CONST_OK_FOR_M (INTVAL (operands[2]))"
  "shlr	%0"
  [(set_attr "type" "arith")])

(define_insn "lshrsi3_k"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "K")))]
  "CONST_OK_FOR_K (INTVAL (operands[2]))
   && ! CONST_OK_FOR_M (INTVAL (operands[2]))"
  "shlr%O2	%0"
  [(set_attr "type" "arith")])

(define_insn "lshrsi3_n"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
		     (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "! sh_dynamicalize_shift_p (operands[2])"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shift_insns_rtx (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shift_insns_rtx (insn)") (const_int 3))
	       (const_string "6")]
	      (const_string "8")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "")
		     (match_operand:SI 2 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "reload_completed"
  [(use (reg:SI R0_REG))]
  "
{
  gen_shifty_op (LSHIFTRT, operands);
  DONE;
}")

(define_expand "lshrsi3"
  [(parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "")
				(match_operand:SI 2 "nonmemory_operand" "")))
	      (clobber (reg:SI T_REG))])]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && sh_dynamicalize_shift_p (operands[2]))
    operands[2] = force_reg (SImode, operands[2]);
  if (TARGET_SH3 && arith_reg_operand (operands[2], GET_MODE (operands[2])))
    {
      rtx count = copy_to_mode_reg (SImode, operands[2]);
      emit_insn (gen_negsi2 (count, count));
      emit_insn (gen_lshrsi3_d (operands[0], operands[1], count));
      DONE;
    }
  if (! immediate_operand (operands[2], GET_MODE (operands[2])))
    FAIL;
}")

;; ??? This should be a define expand.

(define_insn "ashldi3_k"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(ashift:DI (match_operand:DI 1 "arith_reg_operand" "0")
		   (const_int 1)))
   (clobber (reg:SI T_REG))]
  ""
  "shll	%R0\;rotcl	%S0"
  [(set_attr "length" "4")
   (set_attr "type" "arith")])

(define_expand "ashldi3"
  [(parallel [(set (match_operand:DI 0 "arith_reg_operand" "")
		   (ashift:DI (match_operand:DI 1 "arith_reg_operand" "")
			      (match_operand:DI 2 "immediate_operand" "")))
	      (clobber (reg:SI T_REG))])]
  ""
  "{ if (GET_CODE (operands[2]) != CONST_INT
	 || INTVAL (operands[2]) != 1) FAIL;} ")

;; ??? This should be a define expand.

(define_insn "lshrdi3_k"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(lshiftrt:DI (match_operand:DI 1 "arith_reg_operand" "0")
		     (const_int 1)))
   (clobber (reg:SI T_REG))]
  ""
  "shlr	%S0\;rotcr	%R0"
  [(set_attr "length" "4")
   (set_attr "type" "arith")])

(define_expand "lshrdi3"
  [(parallel [(set (match_operand:DI 0 "arith_reg_operand" "")
		   (lshiftrt:DI (match_operand:DI 1 "arith_reg_operand" "")
			       (match_operand:DI 2 "immediate_operand" "")))
	     (clobber (reg:SI T_REG))])]
  ""
  "{ if (GET_CODE (operands[2]) != CONST_INT
	 || INTVAL (operands[2]) != 1) FAIL;} ")

;; ??? This should be a define expand.

(define_insn "ashrdi3_k"
  [(set (match_operand:DI 0 "arith_reg_operand" "=r")
	(ashiftrt:DI (match_operand:DI 1 "arith_reg_operand" "0")
		     (const_int 1)))
   (clobber (reg:SI T_REG))]
  ""
  "shar	%S0\;rotcr	%R0"
  [(set_attr "length" "4")
   (set_attr "type" "arith")])

(define_expand "ashrdi3"
  [(parallel [(set (match_operand:DI 0 "arith_reg_operand" "")
		   (ashiftrt:DI (match_operand:DI 1 "arith_reg_operand" "")
				(match_operand:DI 2 "immediate_operand" "")))
	      (clobber (reg:SI T_REG))])]
  ""
  "{ if (GET_CODE (operands[2]) != CONST_INT
	 || INTVAL (operands[2]) != 1) FAIL; } ")

;; combined left/right shift

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))]
  "(unsigned)INTVAL (operands[2]) < 32"
  [(use (reg:SI R0_REG))]
  "if (gen_shl_and (operands[0], operands[2], operands[3], operands[1])) FAIL;
   DONE;")

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "(unsigned)INTVAL (operands[2]) < 32"
  [(use (reg:SI R0_REG))]
  "if (gen_shl_and (operands[0], operands[2], operands[3], operands[1])) FAIL;
   DONE;")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "0")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "shl_and_kind (operands[2], operands[3], 0) == 1"
 "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_and_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 5))
	       (const_string "10")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 6))
	       (const_string "12")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 7))
	       (const_string "14")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 8))
	       (const_string "16")]
	      (const_string "18")))
   (set_attr "type" "arith")])

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=z")
	(and:SI (ashift:SI (match_operand:SI 1 "register_operand" "0")
			   (match_operand:SI 2 "const_int_operand" "n"))
		(match_operand:SI 3 "const_int_operand" "n")))
   (clobber (reg:SI T_REG))]
  "shl_and_kind (operands[2], operands[3], 0) == 2"
 "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_and_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_and_length (insn)") (const_int 4))
	       (const_string "8")]
	      (const_string "10")))
   (set_attr "type" "arith")])

;; shift left / and combination with a scratch register: The combine pass
;; does not accept the individual instructions, even though they are
;; cheap.  But it needs a precise description so that it is usable after
;; reload.
(define_insn "and_shl_scratch"
  [(set (match_operand:SI 0 "register_operand" "=r,&r")
	(lshiftrt:SI
	 (ashift:SI
	  (and:SI
	   (lshiftrt:SI (match_operand:SI 1 "register_operand" "r,0")
			(match_operand:SI 2 "const_int_operand" "N,n"))
	   (match_operand:SI 3 "" "0,r"))
	  (match_operand:SI 4 "const_int_operand" "n,n"))
	 (match_operand:SI 5 "const_int_operand" "n,n")))
   (clobber (reg:SI T_REG))]
  ""
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_and_scr_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_and_scr_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_and_scr_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_and_scr_length (insn)") (const_int 5))
	       (const_string "10")]
	      (const_string "12")))
   (set_attr "type" "arith")])

(define_split
  [(set (match_operand:SI 0 "register_operand" "=r,&r")
	(lshiftrt:SI
	 (ashift:SI
	  (and:SI
	   (lshiftrt:SI (match_operand:SI 1 "register_operand" "r,0")
			(match_operand:SI 2 "const_int_operand" "N,n"))
	   (match_operand:SI 3 "register_operand" "0,r"))
	  (match_operand:SI 4 "const_int_operand" "n,n"))
	 (match_operand:SI 5 "const_int_operand" "n,n")))
   (clobber (reg:SI T_REG))]
  ""
  [(use (reg:SI R0_REG))]
  "
{
  rtx and_source = operands[rtx_equal_p (operands[0], operands[1]) ? 3 : 1];

  if (INTVAL (operands[2]))
    {
      gen_shifty_op (LSHIFTRT, operands);
    }
  emit_insn (gen_andsi3 (operands[0], operands[0], and_source));
  operands[2] = operands[4];
  gen_shifty_op (ASHIFT, operands);
  if (INTVAL (operands[5]))
    {
      operands[2] = operands[5];
      gen_shifty_op (LSHIFTRT, operands);
    }
  DONE;
}")

;; signed left/right shift combination.
(define_split
  [(set (match_operand:SI 0 "register_operand" "=r")
        (sign_extract:SI
	 (ashift:SI (match_operand:SI 1 "register_operand" "r")
		    (match_operand:SI 2 "const_int_operand" "n"))
	 (match_operand:SI 3 "const_int_operand" "n")
	 (const_int 0)))
   (clobber (reg:SI T_REG))]
  ""
  [(use (reg:SI R0_REG))]
  "if (gen_shl_sext (operands[0], operands[2], operands[3], operands[1])) FAIL;
   DONE;")

(define_insn "shl_sext_ext"
  [(set (match_operand:SI 0 "register_operand" "=r")
        (sign_extract:SI
	 (ashift:SI (match_operand:SI 1 "register_operand" "0")
		    (match_operand:SI 2 "const_int_operand" "n"))
	 (match_operand:SI 3 "const_int_operand" "n")
	 (const_int 0)))
   (clobber (reg:SI T_REG))]
  "(unsigned)shl_sext_kind (operands[2], operands[3], 0) - 1 < 5"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_sext_length (insn)") (const_int 1))
	       (const_string "2")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 2))
	       (const_string "4")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 5))
	       (const_string "10")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 6))
	       (const_string "12")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 7))
	       (const_string "14")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 8))
	       (const_string "16")]
	      (const_string "18")))
    (set_attr "type" "arith")])

(define_insn "shl_sext_sub"
  [(set (match_operand:SI 0 "register_operand" "=z")
        (sign_extract:SI
	 (ashift:SI (match_operand:SI 1 "register_operand" "0")
		    (match_operand:SI 2 "const_int_operand" "n"))
	 (match_operand:SI 3 "const_int_operand" "n")
	 (const_int 0)))
   (clobber (reg:SI T_REG))]
  "(shl_sext_kind (operands[2], operands[3], 0) & ~1) == 6"
  "#"
  [(set (attr "length")
	(cond [(eq (symbol_ref "shl_sext_length (insn)") (const_int 3))
	       (const_string "6")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 4))
	       (const_string "8")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 5))
	       (const_string "10")
	       (eq (symbol_ref "shl_sext_length (insn)") (const_int 6))
	       (const_string "12")]
	      (const_string "14")))
    (set_attr "type" "arith")])

;; These patterns are found in expansions of DImode shifts by 16, and
;; allow the xtrct instruction to be generated from C source.

(define_insn "xtrct_left"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ior:SI (ashift:SI (match_operand:SI 1 "arith_reg_operand" "r")
			   (const_int 16))
 	        (lshiftrt:SI (match_operand:SI 2 "arith_reg_operand" "0")
			     (const_int 16))))]
  ""
  "xtrct	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "xtrct_right"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
        (ior:SI (lshiftrt:SI (match_operand:SI 1 "arith_reg_operand" "0")
			     (const_int 16))
 	        (ashift:SI (match_operand:SI 2 "arith_reg_operand" "r")
			   (const_int 16))))]
  ""
  "xtrct	%2,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Unary arithmetic
;; -------------------------------------------------------------------------

(define_insn "negc"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(neg:SI (plus:SI (reg:SI T_REG)
			 (match_operand:SI 1 "arith_reg_operand" "r"))))
   (set (reg:SI T_REG)
	(ne:SI (ior:SI (reg:SI T_REG) (match_dup 1))
	       (const_int 0)))]
  ""
  "negc	%1,%0"
  [(set_attr "type" "arith")])

(define_expand "negdi2"
  [(set (match_operand:DI 0 "arith_reg_operand" "")
	(neg:DI (match_operand:DI 1 "arith_reg_operand" "")))
   (clobber (reg:SI T_REG))]
  ""
  "
{
  int low_word = (TARGET_LITTLE_ENDIAN ? 0 : 1);
  int high_word = (TARGET_LITTLE_ENDIAN ? 1 : 0);

  rtx low_src = operand_subword (operands[1], low_word, 0, DImode);
  rtx high_src = operand_subword (operands[1], high_word, 0, DImode);

  rtx low_dst = operand_subword (operands[0], low_word, 1, DImode);
  rtx high_dst = operand_subword (operands[0], high_word, 1, DImode);

  emit_insn (gen_clrt ());
  emit_insn (gen_negc (low_dst, low_src));
  emit_insn (gen_negc (high_dst, high_src));
  DONE;
}")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(neg:SI (match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "neg	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(not:SI (match_operand:SI 1 "arith_reg_operand" "r")))]
  ""
  "not	%1,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Zero extension instructions
;; -------------------------------------------------------------------------

(define_insn "zero_extendhisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(zero_extend:SI (match_operand:HI 1 "arith_reg_operand" "r")))]
  ""
  "extu.w	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "zero_extendqisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(zero_extend:SI (match_operand:QI 1 "arith_reg_operand" "r")))]
  ""
  "extu.b	%1,%0"
  [(set_attr "type" "arith")])

(define_insn "zero_extendqihi2"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r")
	(zero_extend:HI (match_operand:QI 1 "arith_reg_operand" "r")))]
  ""
  "extu.b	%1,%0"
  [(set_attr "type" "arith")])

;; -------------------------------------------------------------------------
;; Sign extension instructions
;; -------------------------------------------------------------------------

;; ??? This should be a define expand.
;; ??? Or perhaps it should be dropped?

/* There is no point in defining extendsidi2; convert_move generates good
   code for that.  */

(define_insn "extendhisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:HI 1 "general_movsrc_operand" "r,m")))]
  ""
  "@
	exts.w	%1,%0
   	mov.w	%1,%0"
  [(set_attr "type" "arith,load")])

(define_insn "extendqisi2"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:QI 1 "general_movsrc_operand" "r,m")))]
  ""
  "@
	exts.b	%1,%0
	mov.b	%1,%0"
  [(set_attr "type" "arith,load")])

(define_insn "extendqihi2"
  [(set (match_operand:HI 0 "arith_reg_operand" "=r,r")
	(sign_extend:HI (match_operand:QI 1 "general_movsrc_operand" "r,m")))]
  ""
  "@
	exts.b	%1,%0
	mov.b	%1,%0"
  [(set_attr "type" "arith,load")])

;; -------------------------------------------------------------------------
;; Move instructions
;; -------------------------------------------------------------------------

;; define push and pop so it is easy for sh.c

(define_expand "push"
  [(set (mem:SI (pre_dec:SI (reg:SI SP_REG)))
	(match_operand:SI 0 "register_operand" "r,l,x"))]
  ""
  "")

(define_expand "pop"
  [(set (match_operand:SI 0 "register_operand" "=r,l,x")
	(mem:SI (post_inc:SI (reg:SI SP_REG))))]
  ""
  "")

(define_expand "push_e"
  [(parallel [(set (mem:SF (pre_dec:SI (reg:SI SP_REG)))
		   (match_operand:SF 0 "" ""))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (scratch:SI))])]
  ""
  "")

(define_insn "push_fpul"
  [(set (mem:SF (pre_dec:SI (reg:SI SP_REG))) (reg:SF FPUL_REG))]
  "TARGET_SH3E"
  "sts.l	fpul,@-r15"
  [(set_attr "type" "store")
   (set_attr "hit_stack" "yes")])

;; DFmode pushes for sh4 require a lot of what is defined for movdf_i4,
;; so use that.
(define_expand "push_4"
  [(parallel [(set (mem:DF (pre_dec:SI (reg:SI SP_REG)))
		   (match_operand:DF 0 "" ""))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (scratch:SI))])]
  ""
  "")

(define_expand "pop_e"
  [(parallel [(set (match_operand:SF 0 "" "")
	      (mem:SF (post_inc:SI (reg:SI SP_REG))))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (scratch:SI))])]
  ""
  "")

(define_insn "pop_fpul"
  [(set (reg:SF FPUL_REG) (mem:SF (post_inc:SI (reg:SI SP_REG))))]
  "TARGET_SH3E"
  "lds.l	@r15+,fpul"
  [(set_attr "type" "load")
   (set_attr "hit_stack" "yes")])

(define_expand "pop_4"
  [(parallel [(set (match_operand:DF 0 "" "")
		   (mem:DF (post_inc:SI (reg:SI SP_REG))))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (scratch:SI))])]
  ""
  "")

;; These two patterns can happen as the result of optimization, when
;; comparisons get simplified to a move of zero or 1 into the T reg.
;; They don't disappear completely, because the T reg is a fixed hard reg.

(define_insn "clrt"
  [(set (reg:SI T_REG) (const_int 0))]
  ""
  "clrt")

(define_insn "sett"
  [(set (reg:SI T_REG) (const_int 1))]
  ""
  "sett")

;; t/r must come after r/r, lest reload will try to reload stuff like
;; (set (subreg:SI (mem:QI (plus:SI (reg:SI SP_REG) (const_int 12)) 0) 0)
;; (made from (set (subreg:SI (reg:QI ###) 0) ) into T.
(define_insn "movsi_i"
  [(set (match_operand:SI 0 "general_movdst_operand" "=r,r,t,r,r,r,r,m,<,<,x,l,x,l,r")
	(match_operand:SI 1 "general_movsrc_operand" "Q,rI,r,mr,x,l,t,r,x,l,r,r,>,>,i"))]
  "
   ! TARGET_SH3E
   && (register_operand (operands[0], SImode)
       || register_operand (operands[1], SImode))"
  "@
	mov.l	%1,%0
	mov	%1,%0
	cmp/pl	%1
	mov.l	%1,%0
	sts	%1,%0
	sts	%1,%0
	movt	%0
	mov.l	%1,%0
	sts.l	%1,%0
	sts.l	%1,%0
	lds	%1,%0
	lds	%1,%0
	lds.l	%1,%0
	lds.l	%1,%0
	fake	%1,%0"
  [(set_attr "type" "pcload_si,move,*,load_si,move,prget,move,store,store,pstore,move,prset,load,pload,pcload_si")
   (set_attr "length" "*,*,*,*,*,*,*,*,*,*,*,*,*,*,*")])

;; t/r must come after r/r, lest reload will try to reload stuff like
;; (subreg:SI (reg:SF FR14_REG) 0) into T (compiling stdlib/strtod.c -m3e -O2)
;; ??? This allows moves from macl to fpul to be recognized, but these moves
;; will require a reload.
(define_insn "movsi_ie"
  [(set (match_operand:SI 0 "general_movdst_operand" "=r,r,t,r,r,r,r,m,<,<,x,l,x,l,y,<,r,y,r,y")
	(match_operand:SI 1 "general_movsrc_operand" "Q,rI,r,mr,x,l,t,r,x,l,r,r,>,>,>,y,i,r,y,y"))]
  "TARGET_SH3E
   && (register_operand (operands[0], SImode)
       || register_operand (operands[1], SImode))"
  "@
	mov.l	%1,%0
	mov	%1,%0
	cmp/pl	%1
	mov.l	%1,%0
	sts	%1,%0
	sts	%1,%0
	movt	%0
	mov.l	%1,%0
	sts.l	%1,%0
	sts.l	%1,%0
	lds	%1,%0
	lds	%1,%0
	lds.l	%1,%0
	lds.l	%1,%0
	lds.l	%1,%0
	sts.l	%1,%0
	fake	%1,%0
	lds	%1,%0
	sts	%1,%0
	! move optimized away"
  [(set_attr "type" "pcload_si,move,*,load_si,move,prget,move,store,store,pstore,move,prset,load,pload,load,store,pcload_si,gp_fpul,gp_fpul,nil")
   (set_attr "length" "*,*,*,*,*,*,*,*,*,*,*,*,*,*,*,*,*,*,*,0")])

(define_insn "movsi_i_lowpart"
  [(set (strict_low_part (match_operand:SI 0 "general_movdst_operand" "+r,r,r,r,r,r,m,r"))
	(match_operand:SI 1 "general_movsrc_operand" "Q,rI,mr,x,l,t,r,i"))]
   "register_operand (operands[0], SImode)
    || register_operand (operands[1], SImode)"
  "@
	mov.l	%1,%0
	mov	%1,%0
	mov.l	%1,%0
	sts	%1,%0
	sts	%1,%0
	movt	%0
	mov.l	%1,%0
	fake	%1,%0"
  [(set_attr "type" "pcload,move,load,move,prget,move,store,pcload")])

(define_expand "movsi"
  [(set (match_operand:SI 0 "general_movdst_operand" "")
	(match_operand:SI 1 "general_movsrc_operand" ""))]
  ""
  "{ if (prepare_move_operands (operands, SImode)) DONE; }")

(define_expand "ic_invalidate_line"
  [(parallel [(unspec_volatile [(match_operand:SI 0 "register_operand" "+r")
				(match_dup 1)] UNSPEC_ICACHE)
	      (clobber (scratch:SI))])]
  "TARGET_HARD_SH4"
  "
{
  operands[0] = force_reg (Pmode, operands[0]);
  operands[1] = force_reg (Pmode, GEN_INT (0xf0000008));
}")

;; The address %0 is assumed to be 4-aligned at least.  Thus, by ORing
;; 0xf0000008, we get the low-oder bits *1*00 (binary), which fits
;; the requirement *1*00 for associative address writes.  The alignment of
;; %0 implies that its least significant bit is cleared,
;; thus we clear the V bit of a matching entry if there is one.
(define_insn "ic_invalidate_line_i"
  [(unspec_volatile [(match_operand:SI 0 "register_operand" "r")
		     (match_operand:SI 1 "register_operand" "r")]
		     UNSPEC_ICACHE)
   (clobber (match_scratch:SI 2 "=&r"))]
  "TARGET_HARD_SH4"
  "ocbwb\\t@%0\;extu.w\\t%0,%2\;or\\t%1,%2\;mov.l\\t%0,@%2"
  [(set_attr "length" "8")])

(define_insn "movqi_i"
  [(set (match_operand:QI 0 "general_movdst_operand" "=r,r,m,r,r,l")
	(match_operand:QI 1 "general_movsrc_operand"  "ri,m,r,t,l,r"))]
  "arith_reg_operand (operands[0], QImode)
   || arith_reg_operand (operands[1], QImode)"
  "@
	mov	%1,%0
	mov.b	%1,%0
	mov.b	%1,%0
	movt	%0
	sts	%1,%0
	lds	%1,%0"
 [(set_attr "type" "move,load,store,move,move,move")])

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "general_operand"  ""))]
  ""
  "{ if (prepare_move_operands (operands, QImode)) DONE; }")

(define_insn "movhi_i"
  [(set (match_operand:HI 0 "general_movdst_operand" "=r,r,r,r,m,r,l,r")
	(match_operand:HI 1 "general_movsrc_operand" "Q,rI,m,t,r,l,r,i"))]
  "arith_reg_operand (operands[0], HImode)
   || arith_reg_operand (operands[1], HImode)"
  "@
	mov.w	%1,%0
	mov	%1,%0
	mov.w	%1,%0
	movt	%0
	mov.w	%1,%0
	sts	%1,%0
	lds	%1,%0
	fake	%1,%0"
  [(set_attr "type" "pcload,move,load,move,store,move,move,pcload")])

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_movdst_operand" "")
	(match_operand:HI 1 "general_movsrc_operand"  ""))]
  ""
  "{ if (prepare_move_operands (operands, HImode)) DONE; }")

;; ??? This should be a define expand.

;; x/r can be created by inlining/cse, e.g. for execute/961213-1.c
;; compiled with -m2 -ml -O3 -funroll-loops
(define_insn ""
  [(set (match_operand:DI 0 "general_movdst_operand" "=r,r,r,m,r,r,r,*!x")
	(match_operand:DI 1 "general_movsrc_operand" "Q,r,m,r,I,i,x,r"))]
  "arith_reg_operand (operands[0], DImode)
   || arith_reg_operand (operands[1], DImode)"
  "* return output_movedouble (insn, operands, DImode);"
  [(set_attr "length" "4")
   (set_attr "type" "pcload,move,load,store,move,pcload,move,move")])

;; If the output is a register and the input is memory or a register, we have
;; to be careful and see which word needs to be loaded first.  

(define_split
  [(set (match_operand:DI 0 "general_movdst_operand" "")
	(match_operand:DI 1 "general_movsrc_operand" ""))]
  "reload_completed"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "
{
  int regno;

  if ((GET_CODE (operands[0]) == MEM
       && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)
      || (GET_CODE (operands[1]) == MEM
	  && GET_CODE (XEXP (operands[1], 0)) == POST_INC))
    FAIL;

  if (GET_CODE (operands[0]) == REG)
    regno = REGNO (operands[0]);
  else if (GET_CODE (operands[0]) == SUBREG)
    regno = subreg_regno (operands[0]);
  else if (GET_CODE (operands[0]) == MEM)
    regno = -1;

  if (regno == -1
      || ! refers_to_regno_p (regno, regno + 1, operands[1], 0))
    {
      operands[2] = operand_subword (operands[0], 0, 0, DImode);
      operands[3] = operand_subword (operands[1], 0, 0, DImode);
      operands[4] = operand_subword (operands[0], 1, 0, DImode);
      operands[5] = operand_subword (operands[1], 1, 0, DImode);
    }
  else
    {
      operands[2] = operand_subword (operands[0], 1, 0, DImode);
      operands[3] = operand_subword (operands[1], 1, 0, DImode);
      operands[4] = operand_subword (operands[0], 0, 0, DImode);
      operands[5] = operand_subword (operands[1], 0, 0, DImode);
    }

  if (operands[2] == 0 || operands[3] == 0
      || operands[4] == 0 || operands[5] == 0)
    FAIL;
}")

(define_expand "movdi"
  [(set (match_operand:DI 0 "general_movdst_operand" "")
	(match_operand:DI 1 "general_movsrc_operand" ""))]
  ""
  "{ if (prepare_move_operands (operands, DImode)) DONE; }")

;; ??? This should be a define expand.

(define_insn "movdf_k"
  [(set (match_operand:DF 0 "general_movdst_operand" "=r,r,r,m")
	(match_operand:DF 1 "general_movsrc_operand" "r,FQ,m,r"))]
  "(! TARGET_SH4 || reload_completed
    /* ??? We provide some insn so that direct_{load,store}[DFmode] get set */
    || (GET_CODE (operands[0]) == REG && REGNO (operands[0]) == 3)
    || (GET_CODE (operands[1]) == REG && REGNO (operands[1]) == 3))
   && (arith_reg_operand (operands[0], DFmode)
       || arith_reg_operand (operands[1], DFmode))"
  "* return output_movedouble (insn, operands, DFmode);"
  [(set_attr "length" "4")
   (set_attr "type" "move,pcload,load,store")])

;; All alternatives of movdf_i4 are split for ! TARGET_FMOVD.
;; However, the d/F/c/z alternative cannot be split directly; it is converted
;; with special code in machine_dependent_reorg into a load of the R0_REG and
;; the d/m/c/X alternative, which is split later into single-precision
;; instructions.  And when not optimizing, no splits are done before fixing
;; up pcloads, so we need usable length information for that.
(define_insn "movdf_i4"
  [(set (match_operand:DF 0 "general_movdst_operand" "=d,r,d,d,m,r,r,m,!??r,!???d")
	(match_operand:DF 1 "general_movsrc_operand" "d,r,F,m,d,FQ,m,r,d,r"))
   (use (match_operand:PSI 2 "fpscr_operand" "c,c,c,c,c,c,c,c,c,c"))
   (clobber (match_scratch:SI 3 "=X,X,&z,X,X,X,X,X,X,X"))]
  "TARGET_SH4
   && (arith_reg_operand (operands[0], DFmode)
       || arith_reg_operand (operands[1], DFmode))"
  "@
	fmov	%1,%0
	#
	#
	fmov.d	%1,%0
	fmov.d	%1,%0
	#
	#
	#
	#
	#"
  [(set_attr_alternative "length"
     [(if_then_else (eq_attr "fmovd" "yes") (const_int 2) (const_int 4))
      (const_int 4)
      (if_then_else (eq_attr "fmovd" "yes") (const_int 4) (const_int 6))
      (if_then_else (eq_attr "fmovd" "yes") (const_int 2) (const_int 6))
      (if_then_else (eq_attr "fmovd" "yes") (const_int 2) (const_int 6))
      (const_int 4)
      (const_int 8) (const_int 8) ;; these need only 8 bytes for @(r0,rn)
      (const_int 8) (const_int 8)])
   (set_attr "type" "fmove,move,pcload,load,store,pcload,load,store,load,load")
   (set (attr "fp_mode") (if_then_else (eq_attr "fmovd" "yes")
					   (const_string "double")
					   (const_string "none")))])

;; Moving DFmode between fp/general registers through memory
;; (the top of the stack) is faster than moving through fpul even for
;; little endian.  Because the type of an instruction is important for its
;; scheduling,  it is beneficial to split these operations, rather than
;; emitting them in one single chunk, even if this will expose a stack
;; use that will prevent scheduling of other stack accesses beyond this
;; instruction.
(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(match_operand:DF 1 "register_operand" ""))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (match_scratch:SI 3 "=X"))]
  "TARGET_SH4 && reload_completed
   && (true_regnum (operands[0]) < 16) != (true_regnum (operands[1]) < 16)"
  [(const_int 0)]
  "
{
  rtx insn, tos;

  tos = gen_rtx (MEM, DFmode, gen_rtx (PRE_DEC, Pmode, stack_pointer_rtx));
  insn = emit_insn (gen_movdf_i4 (tos, operands[1], operands[2]));
  REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_INC, stack_pointer_rtx, NULL_RTX);
  tos = gen_rtx (MEM, DFmode, gen_rtx (POST_INC, Pmode, stack_pointer_rtx));
  insn = emit_insn (gen_movdf_i4 (operands[0], tos, operands[2]));
  REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_INC, stack_pointer_rtx, NULL_RTX);
  DONE;
}")

;; local-alloc sometimes allocates scratch registers even when not required,
;; so we must be prepared to handle these.

;; Remove the use and clobber from a movdf_i4 so that we can use movdf_k.
(define_split
  [(set (match_operand:DF 0 "general_movdst_operand" "")
	(match_operand:DF 1 "general_movsrc_operand"  ""))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (match_scratch:SI 3 "X"))]
  "TARGET_SH4
   && reload_completed
   && true_regnum (operands[0]) < 16
   && true_regnum (operands[1]) < 16"
  [(set (match_dup 0) (match_dup 1))]
  "
{
  /* If this was a reg <-> mem operation with base + index reg addressing,
     we have to handle this in a special way.  */
  rtx mem = operands[0];
  int store_p = 1;
  if (! memory_operand (mem, DFmode))
    {
      mem = operands[1];
      store_p = 0;
    }
  if (GET_CODE (mem) == SUBREG && SUBREG_BYTE (mem) == 0)
    mem = SUBREG_REG (mem);
  if (GET_CODE (mem) == MEM)
    {
      rtx addr = XEXP (mem, 0);
      if (GET_CODE (addr) == PLUS
	  && GET_CODE (XEXP (addr, 0)) == REG
	  && GET_CODE (XEXP (addr, 1)) == REG)
	{
	  int offset;
	  rtx reg0 = gen_rtx (REG, Pmode, 0);
	  rtx regop = operands[store_p], word0 ,word1;

	  if (GET_CODE (regop) == SUBREG)
	    regop = alter_subreg (regop);
	  if (REGNO (XEXP (addr, 0)) == REGNO (XEXP (addr, 1)))
	    offset = 2;
	  else
	    offset = 4;
	  mem = copy_rtx (mem);
	  PUT_MODE (mem, SImode);
	  word0 = alter_subreg (gen_rtx (SUBREG, SImode, regop, 0));
	  word1 = alter_subreg (gen_rtx (SUBREG, SImode, regop, 4));
	  if (store_p || ! refers_to_regno_p (REGNO (word0),
					      REGNO (word0) + 1, addr, 0))
	    {
	      emit_insn (store_p
			 ? gen_movsi_ie (mem, word0)
			 : gen_movsi_ie (word0, mem));
	      emit_insn (gen_addsi3 (reg0, reg0, GEN_INT (offset)));
	      mem = copy_rtx (mem);
	      emit_insn (store_p
			 ? gen_movsi_ie (mem, word1)
			 : gen_movsi_ie (word1, mem));
	      emit_insn (gen_addsi3 (reg0, reg0, GEN_INT (-offset)));
	    }
	  else
	    {
	      emit_insn (gen_addsi3 (reg0, reg0, GEN_INT (offset)));
	      emit_insn (gen_movsi_ie (word1, mem));
	      emit_insn (gen_addsi3 (reg0, reg0, GEN_INT (-offset)));
	      mem = copy_rtx (mem);
	      emit_insn (gen_movsi_ie (word0, mem));
	    }
	  DONE;
	}
    }
}")

;; Split away the clobber of r0 after machine_dependent_reorg has fixed pcloads.
(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(match_operand:DF 1 "memory_operand"  ""))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (reg:SI R0_REG))]
  "TARGET_SH4 && reload_completed"
  [(parallel [(set (match_dup 0) (match_dup 1))
	      (use (match_dup 2))
	      (clobber (scratch:SI))])]
  "")

(define_expand "reload_indf"
  [(parallel [(set (match_operand:DF 0 "register_operand" "=f")
		   (match_operand:DF 1 "immediate_operand" "FQ"))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (match_operand:SI 2 "register_operand" "=&z"))])]
  ""
  "")

(define_expand "reload_outdf"
  [(parallel [(set (match_operand:DF 0 "register_operand" "=r,f")
		   (match_operand:DF 1 "register_operand" "af,r"))
	      (clobber (match_operand:SI 2 "register_operand" "=&y,y"))])]
  ""
  "")

;; Simplify no-op moves.
(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(match_operand:SF 1 "register_operand" ""))
   (use (match_operand:PSI 2 "fpscr_operand" ""))
   (clobber (match_scratch:SI 3 "X"))]
  "TARGET_SH3E && reload_completed
   && true_regnum (operands[0]) == true_regnum (operands[1])"
  [(set (match_dup 0) (match_dup 0))]
  "")

;; fmovd substitute post-reload splits
(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(match_operand:DF 1 "register_operand" ""))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (match_scratch:SI 3 "X"))]
  "TARGET_SH4 && ! TARGET_FMOVD && reload_completed
   && FP_OR_XD_REGISTER_P (true_regnum (operands[0]))
   && FP_OR_XD_REGISTER_P (true_regnum (operands[1]))"
  [(const_int 0)]
  "
{
  int dst = true_regnum (operands[0]), src = true_regnum (operands[1]);
  emit_insn (gen_movsf_ie (gen_rtx (REG, SFmode, dst),
			   gen_rtx (REG, SFmode, src), operands[2]));
  emit_insn (gen_movsf_ie (gen_rtx (REG, SFmode, dst + 1),
			   gen_rtx (REG, SFmode, src + 1), operands[2]));
  DONE;
}")

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(mem:DF (match_operand:SI 1 "register_operand" "")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (match_scratch:SI 3 "X"))]
  "TARGET_SH4 && ! TARGET_FMOVD && reload_completed
   && FP_OR_XD_REGISTER_P (true_regnum (operands[0]))
   && find_regno_note (insn, REG_DEAD, true_regnum (operands[1]))"
  [(const_int 0)]
  "
{
  int regno = true_regnum (operands[0]);
  rtx insn;
  rtx mem2 = gen_rtx (MEM, SFmode, gen_rtx (POST_INC, Pmode, operands[1]));

  insn = emit_insn (gen_movsf_ie (gen_rtx (REG, SFmode,
					   regno + !! TARGET_LITTLE_ENDIAN),
				  mem2, operands[2]));
  REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_INC, operands[1], NULL_RTX);
  insn = emit_insn (gen_movsf_ie (gen_rtx (REG, SFmode,
					   regno + ! TARGET_LITTLE_ENDIAN),
				  gen_rtx (MEM, SFmode, operands[1]),
				  operands[2]));
  DONE;
}")

(define_split
  [(set (match_operand:DF 0 "register_operand" "")
	(match_operand:DF 1 "memory_operand" ""))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (match_scratch:SI 3 "X"))]
  "TARGET_SH4 && ! TARGET_FMOVD && reload_completed
   && FP_OR_XD_REGISTER_P (true_regnum (operands[0]))"
  [(const_int 0)]
  "
{
  int regno = true_regnum (operands[0]);
  rtx addr, insn, adjust = NULL_RTX;
  rtx mem2 = copy_rtx (operands[1]);
  rtx reg0 = gen_rtx_REG (SFmode, regno + !! TARGET_LITTLE_ENDIAN);
  rtx reg1 = gen_rtx_REG (SFmode, regno + ! TARGET_LITTLE_ENDIAN);

  PUT_MODE (mem2, SFmode);
  operands[1] = copy_rtx (mem2);
  addr = XEXP (mem2, 0);
  if (GET_CODE (addr) != POST_INC)
    {
      /* If we have to modify the stack pointer, the value that we have
	 read with post-increment might be modified by an interrupt,
	 so write it back.  */
      if (REGNO (addr) == STACK_POINTER_REGNUM)
	adjust = gen_push_e (reg0);
      else
	adjust = gen_addsi3 (addr, addr, GEN_INT (-4));
      XEXP (mem2, 0) = addr = gen_rtx_POST_INC (SImode, addr);
    }
  addr = XEXP (addr, 0);
  insn = emit_insn (gen_movsf_ie (reg0, mem2, operands[2]));
  REG_NOTES (insn) = gen_rtx_EXPR_LIST (REG_INC, addr, NULL_RTX);
  insn = emit_insn (gen_movsf_ie (reg1, operands[1], operands[2]));
  if (adjust)
    emit_insn (adjust);
  else
    REG_NOTES (insn) = gen_rtx_EXPR_LIST (REG_INC, addr, NULL_RTX);
  DONE;
}")

(define_split
  [(set (match_operand:DF 0 "memory_operand" "")
	(match_operand:DF 1 "register_operand" ""))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (match_scratch:SI 3 "X"))]
  "TARGET_SH4 && ! TARGET_FMOVD && reload_completed
   && FP_OR_XD_REGISTER_P (true_regnum (operands[1]))"
  [(const_int 0)]
  "
{
  int regno = true_regnum (operands[1]);
  rtx insn, addr, adjust = NULL_RTX;

  operands[0] = copy_rtx (operands[0]);
  PUT_MODE (operands[0], SFmode);
  insn = emit_insn (gen_movsf_ie (operands[0],
				  gen_rtx (REG, SFmode,
					   regno + ! TARGET_LITTLE_ENDIAN),
				  operands[2]));
  operands[0] = copy_rtx (operands[0]);
  addr = XEXP (operands[0], 0);
  if (GET_CODE (addr) != PRE_DEC)
    {
      adjust = gen_addsi3 (addr, addr, GEN_INT (4));
      emit_insn_before (adjust, insn);
      XEXP (operands[0], 0) = addr = gen_rtx (PRE_DEC, SImode, addr);
    }
  addr = XEXP (addr, 0);
  if (! adjust)
    REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_INC, addr, NULL_RTX);
  insn = emit_insn (gen_movsf_ie (operands[0],
				  gen_rtx (REG, SFmode,
					   regno + !! TARGET_LITTLE_ENDIAN),
				  operands[2]));
  REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_INC, addr, NULL_RTX);
  DONE;
}")

;; If the output is a register and the input is memory or a register, we have
;; to be careful and see which word needs to be loaded first.  

(define_split
  [(set (match_operand:DF 0 "general_movdst_operand" "")
	(match_operand:DF 1 "general_movsrc_operand" ""))]
  "reload_completed"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "
{
  int regno;

  if ((GET_CODE (operands[0]) == MEM
       && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)
      || (GET_CODE (operands[1]) == MEM
	  && GET_CODE (XEXP (operands[1], 0)) == POST_INC))
    FAIL;

  if (GET_CODE (operands[0]) == REG)
    regno = REGNO (operands[0]);
  else if (GET_CODE (operands[0]) == SUBREG)
    regno = subreg_regno (operands[0]);
  else if (GET_CODE (operands[0]) == MEM)
    regno = -1;

  if (regno == -1
      || ! refers_to_regno_p (regno, regno + 1, operands[1], 0))
    {
      operands[2] = operand_subword (operands[0], 0, 0, DFmode);
      operands[3] = operand_subword (operands[1], 0, 0, DFmode);
      operands[4] = operand_subword (operands[0], 1, 0, DFmode);
      operands[5] = operand_subword (operands[1], 1, 0, DFmode);
    }
  else
    {
      operands[2] = operand_subword (operands[0], 1, 0, DFmode);
      operands[3] = operand_subword (operands[1], 1, 0, DFmode);
      operands[4] = operand_subword (operands[0], 0, 0, DFmode);
      operands[5] = operand_subword (operands[1], 0, 0, DFmode);
    }

  if (operands[2] == 0 || operands[3] == 0
      || operands[4] == 0 || operands[5] == 0)
    FAIL;
}")

;; If a base address generated by LEGITIMIZE_ADDRESS for SImode is
;; used only once, let combine add in the index again.

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(match_operand:SI 1 "" ""))
   (clobber (match_operand 2 "register_operand" ""))]
  "! reload_in_progress && ! reload_completed"
  [(use (reg:SI R0_REG))]
  "
{
  rtx addr, reg, const_int;

  if (GET_CODE (operands[1]) != MEM)
    FAIL;
  addr = XEXP (operands[1], 0);
  if (GET_CODE (addr) != PLUS)
    FAIL;
  reg = XEXP (addr, 0);
  const_int = XEXP (addr, 1);
  if (! (BASE_REGISTER_RTX_P (reg) && INDEX_REGISTER_RTX_P (operands[2])
	 && GET_CODE (const_int) == CONST_INT))
    FAIL;
  emit_move_insn (operands[2], const_int);
  emit_move_insn (operands[0],
		  change_address (operands[1], VOIDmode,
				  gen_rtx_PLUS (SImode, reg, operands[2])));
  DONE;
}")

(define_split
  [(set (match_operand:SI 1 "" "")
	(match_operand:SI 0 "register_operand" ""))
   (clobber (match_operand 2 "register_operand" ""))]
  "! reload_in_progress && ! reload_completed"
  [(use (reg:SI R0_REG))]
  "
{
  rtx addr, reg, const_int;

  if (GET_CODE (operands[1]) != MEM)
    FAIL;
  addr = XEXP (operands[1], 0);
  if (GET_CODE (addr) != PLUS)
    FAIL;
  reg = XEXP (addr, 0);
  const_int = XEXP (addr, 1);
  if (! (BASE_REGISTER_RTX_P (reg) && INDEX_REGISTER_RTX_P (operands[2])
	 && GET_CODE (const_int) == CONST_INT))
    FAIL;
  emit_move_insn (operands[2], const_int);
  emit_move_insn (change_address (operands[1], VOIDmode,
				  gen_rtx_PLUS (SImode, reg, operands[2])),
		  operands[0]);
  DONE;
}")

(define_expand "movdf"
  [(set (match_operand:DF 0 "general_movdst_operand" "")
	(match_operand:DF 1 "general_movsrc_operand" ""))]
  ""
  "
{
  if (prepare_move_operands (operands, DFmode)) DONE;
  if (TARGET_SH4)
    {
      emit_df_insn (gen_movdf_i4 (operands[0], operands[1], get_fpscr_rtx ()));
      DONE;
    }
}")


(define_insn "movsf_i"
  [(set (match_operand:SF 0 "general_movdst_operand" "=r,r,r,r,m,l,r")
	(match_operand:SF 1 "general_movsrc_operand"  "r,I,FQ,mr,r,r,l"))]
  "
   (! TARGET_SH3E
    /* ??? We provide some insn so that direct_{load,store}[SFmode] get set */
    || (GET_CODE (operands[0]) == REG && REGNO (operands[0]) == 3)
    || (GET_CODE (operands[1]) == REG && REGNO (operands[1]) == 3))
   && (arith_reg_operand (operands[0], SFmode)
       || arith_reg_operand (operands[1], SFmode))"
  "@
	mov	%1,%0
	mov	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	lds	%1,%0
	sts	%1,%0"
  [(set_attr "type" "move,move,pcload,load,store,move,move")])

;; We may not split the ry/yr/XX alternatives to movsi_ie, since
;; update_flow_info would not know where to put REG_EQUAL notes
;; when the destination changes mode.
(define_insn "movsf_ie"
  [(set (match_operand:SF 0 "general_movdst_operand"
	 "=f,r,f,f,fy,f,m,r,r,m,f,y,y,rf,r,y,<,y,y")
	(match_operand:SF 1 "general_movsrc_operand"
	  "f,r,G,H,FQ,mf,f,FQ,mr,r,y,f,>,fr,y,r,y,>,y"))
   (use (match_operand:PSI 2 "fpscr_operand" "c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c,c"))
   (clobber (match_scratch:SI 3 "=X,X,X,X,&z,X,X,X,X,X,X,X,X,y,X,X,X,X,X"))]

  "TARGET_SH3E
   && (arith_reg_operand (operands[0], SFmode)
       || arith_reg_operand (operands[1], SFmode)
       || arith_reg_operand (operands[3], SImode)
       || (fpul_operand (operands[0], SFmode)
	   && memory_operand (operands[1], SFmode)
	   && GET_CODE (XEXP (operands[1], 0)) == POST_INC)
       || (fpul_operand (operands[1], SFmode)
	   && memory_operand (operands[0], SFmode)
	   && GET_CODE (XEXP (operands[0], 0)) == PRE_DEC))"
  "@
	fmov	%1,%0
	mov	%1,%0
	fldi0	%0
	fldi1	%0
	#
	fmov.s	%1,%0
	fmov.s	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	mov.l	%1,%0
	fsts	fpul,%0
	flds	%1,fpul
	lds.l	%1,%0
	#
	sts	%1,%0
	lds	%1,%0
	sts.l	%1,%0
	lds.l	%1,%0
	! move optimized away"
  [(set_attr "type" "fmove,move,fmove,fmove,pcload,load,store,pcload,load,store,fmove,fmove,load,*,gp_fpul,gp_fpul,store,load,nil")
   (set_attr "length" "*,*,*,*,4,*,*,*,*,*,2,2,2,4,2,2,2,2,0")
   (set (attr "fp_mode") (if_then_else (eq_attr "fmovd" "yes")
					   (const_string "single")
					   (const_string "none")))])

(define_split
  [(set (match_operand:SF 0 "register_operand" "")
	(match_operand:SF 1 "register_operand" ""))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))
   (clobber (reg:SI FPUL_REG))]
  ""
  [(parallel [(set (reg:SF FPUL_REG) (match_dup 1))
	      (use (match_dup 2))
	      (clobber (scratch:SI))])
   (parallel [(set (match_dup 0) (reg:SF FPUL_REG))
	      (use (match_dup 2))
	      (clobber (scratch:SI))])]
  "")

(define_expand "movsf"
  [(set (match_operand:SF 0 "general_movdst_operand" "")
        (match_operand:SF 1 "general_movsrc_operand" ""))]
  ""
  "
{
  if (prepare_move_operands (operands, SFmode))
    DONE;
  if (TARGET_SH3E)
    {
      emit_sf_insn (gen_movsf_ie (operands[0], operands[1], get_fpscr_rtx ()));
      DONE;
    }
}")

(define_insn "mov_nop"
  [(set (match_operand 0 "register_operand" "") (match_dup 0))]
  "TARGET_SH3E"
  ""
  [(set_attr "length" "0")
   (set_attr "type" "nil")])

(define_expand "reload_insf"
  [(parallel [(set (match_operand:SF 0 "register_operand" "=a")
		   (match_operand:SF 1 "immediate_operand" "FQ"))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (match_operand:SI 2 "register_operand" "=&z"))])]
  ""
  "")

(define_expand "reload_insi"
  [(parallel [(set (match_operand:SF 0 "register_operand" "=y")
		   (match_operand:SF 1 "immediate_operand" "FQ"))
	      (clobber (match_operand:SI 2 "register_operand" "=&z"))])]
  ""
  "")

(define_insn "*movsi_y"
  [(set (match_operand:SI 0 "register_operand" "=y,y")
	(match_operand:SI 1 "immediate_operand" "Qi,I"))
   (clobber (match_scratch:SI 2 "=&z,r"))]
  "TARGET_SH3E
   && (reload_in_progress || reload_completed)"
  "#"
  [(set_attr "length" "4")
   (set_attr "type" "pcload,move")])

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(match_operand:SI 1 "immediate_operand" ""))
   (clobber (match_operand:SI 2 "register_operand" ""))]
  ""
  [(set (match_dup 2) (match_dup 1))
   (set (match_dup 0) (match_dup 2))]
  "")

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(match_operand:SI 1 "memory_operand" ""))
   (clobber (reg:SI R0_REG))]
  ""
  [(set (match_dup 0) (match_dup 1))]
  "")

;; ------------------------------------------------------------------------
;; Define the real conditional branch instructions.
;; ------------------------------------------------------------------------

(define_insn "branch_true"
  [(set (pc) (if_then_else (ne (reg:SI T_REG) (const_int 0))
			   (label_ref (match_operand 0 "" ""))
			   (pc)))]
  ""
  "* return output_branch (1, insn, operands);"
  [(set_attr "type" "cbranch")])

(define_insn "branch_false"
  [(set (pc) (if_then_else (eq (reg:SI T_REG) (const_int 0))
			   (label_ref (match_operand 0 "" ""))
			   (pc)))]
  ""
  "* return output_branch (0, insn, operands);"
  [(set_attr "type" "cbranch")])

;; Patterns to prevent reorg from re-combining a condbranch with a branch
;; which destination is too far away.
;; The const_int_operand is distinct for each branch target; it avoids
;; unwanted matches with redundant_insn.
(define_insn "block_branch_redirect"
  [(set (pc) (unspec [(match_operand 0 "const_int_operand" "")] UNSPEC_BBR))]
  ""
  ""
  [(set_attr "length" "0")])

;; This one has the additional purpose to record a possible scratch register
;; for the following branch.
(define_insn "indirect_jump_scratch"
  [(set (match_operand 0 "register_operand" "=r")
	(unspec [(match_operand 1 "const_int_operand" "")] UNSPEC_BBR))]
  ""
  ""
  [(set_attr "length" "0")])

;; Conditional branch insns

(define_expand "beq"
  [(set (pc)
	(if_then_else (ne (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, EQ);")

(define_expand "bne"
  [(set (pc)
	(if_then_else (eq (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, EQ);")

(define_expand "bgt"
  [(set (pc)
	(if_then_else (ne (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GT);")

(define_expand "blt"
  [(set (pc)
	(if_then_else (eq (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  if (GET_MODE_CLASS (GET_MODE (sh_compare_op0)) == MODE_FLOAT)
    {
      rtx tmp = sh_compare_op0;
      sh_compare_op0 = sh_compare_op1;
      sh_compare_op1 = tmp;
      emit_insn (gen_bgt (operands[0]));
      DONE;
    }
  from_compare (operands, GE);
}")

(define_expand "ble"
  [(set (pc)
	(if_then_else (eq (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  if (TARGET_SH3E
      && TARGET_IEEE
      && GET_MODE_CLASS (GET_MODE (sh_compare_op0)) == MODE_FLOAT)
    {
      rtx tmp = sh_compare_op0;
      sh_compare_op0 = sh_compare_op1;
      sh_compare_op1 = tmp;
      emit_insn (gen_bge (operands[0]));
      DONE;
    }
  from_compare (operands, GT);
}")

(define_expand "bge"
  [(set (pc)
	(if_then_else (ne (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{
  if (TARGET_SH3E
      && ! TARGET_IEEE
      && GET_MODE_CLASS (GET_MODE (sh_compare_op0)) == MODE_FLOAT)
    {
      rtx tmp = sh_compare_op0;
      sh_compare_op0 = sh_compare_op1;
      sh_compare_op1 = tmp;
      emit_insn (gen_ble (operands[0]));
      DONE;
    }
  from_compare (operands, GE);
}")

(define_expand "bgtu"
  [(set (pc)
	(if_then_else (ne (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GTU); ")

(define_expand "bltu"
  [(set (pc)
	(if_then_else (eq (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GEU);")

(define_expand "bgeu"
  [(set (pc)
	(if_then_else (ne (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GEU);")

(define_expand "bleu"
  [(set (pc)
	(if_then_else (eq (reg:SI T_REG) (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "from_compare (operands, GTU);")

;; ------------------------------------------------------------------------
;; Jump and linkage insns
;; ------------------------------------------------------------------------

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "*
{
  /* The length is 16 if the delay slot is unfilled.  */
  if (get_attr_length(insn) > 4)
    return output_far_jump(insn, operands[0]);
  else
    return   \"bra	%l0%#\";
}"
  [(set_attr "type" "jump")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "calli"
  [(call (mem:SI (match_operand:SI 0 "arith_reg_operand" "r"))
	 (match_operand 1 "" ""))
   (use (reg:PSI FPSCR_REG))
   (clobber (reg:SI PR_REG))]
  ""
  "jsr	@%0%#"
  [(set_attr "type" "call")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "needs_delay_slot" "yes")])

;; This is a pc-rel call, using bsrf, for use with PIC.

(define_insn "calli_pcrel"
  [(call (mem:SI (match_operand:SI 0 "arith_reg_operand" "r"))
	 (match_operand 1 "" ""))
   (use (reg:PSI FPSCR_REG))
   (use (reg:SI PIC_REG))
   (use (match_operand 2 "" ""))
   (clobber (reg:SI PR_REG))]
  "TARGET_SH2"
  "bsrf	%0\\n%O2:%#"
  [(set_attr "type" "call")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "needs_delay_slot" "yes")])

(define_insn_and_split "call_pcrel"
  [(call (mem:SI (match_operand:SI 0 "symbol_ref_operand" ""))
	 (match_operand 1 "" ""))
   (use (reg:PSI FPSCR_REG))
   (use (reg:SI PIC_REG))
   (clobber (reg:SI PR_REG))
   (clobber (match_scratch:SI 2 "=r"))]
  "TARGET_SH2"
  "#"
  "reload_completed"
  [(const_int 0)]
  "
{
  rtx lab = gen_call_site ();

  if (SYMBOL_REF_FLAG (operands[0]))
    emit_insn (gen_sym_label2reg (operands[2], operands[0], lab));
  else
    emit_insn (gen_symPLT_label2reg (operands[2], operands[0], lab));
  emit_call_insn (gen_calli_pcrel (operands[2], operands[1], lab));
  DONE;
}"
  [(set_attr "type" "call")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "needs_delay_slot" "yes")])

(define_insn "call_valuei"
  [(set (match_operand 0 "" "=rf")
	(call (mem:SI (match_operand:SI 1 "arith_reg_operand" "r"))
	      (match_operand 2 "" "")))
   (use (reg:PSI FPSCR_REG))
   (clobber (reg:SI PR_REG))]
  ""
  "jsr	@%1%#"
  [(set_attr "type" "call")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "needs_delay_slot" "yes")])

(define_insn "call_valuei_pcrel"
  [(set (match_operand 0 "" "=rf")
	(call (mem:SI (match_operand:SI 1 "arith_reg_operand" "r"))
	      (match_operand 2 "" "")))
   (use (reg:PSI FPSCR_REG))
   (use (reg:SI PIC_REG))
   (use (match_operand 3 "" ""))
   (clobber (reg:SI PR_REG))]
  "TARGET_SH2"
  "bsrf	%1\\n%O3:%#"
  [(set_attr "type" "call")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "needs_delay_slot" "yes")])

(define_insn_and_split "call_value_pcrel"
  [(set (match_operand 0 "" "=rf")
	(call (mem:SI (match_operand:SI 1 "symbol_ref_operand" ""))
	      (match_operand 2 "" "")))
   (use (reg:PSI FPSCR_REG))
   (use (reg:SI PIC_REG))
   (clobber (reg:SI PR_REG))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_SH2"
  "#"
  "reload_completed"
  [(const_int 0)]
  "
{
  rtx lab = gen_call_site ();

  if (SYMBOL_REF_FLAG (operands[1]))
    emit_insn (gen_sym_label2reg (operands[3], operands[1], lab));
  else
    emit_insn (gen_symPLT_label2reg (operands[3], operands[1], lab));
  emit_call_insn (gen_call_valuei_pcrel (operands[0], operands[3],
					 operands[2], lab));
  DONE;
}"
  [(set_attr "type" "call")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "needs_delay_slot" "yes")])

(define_expand "call"
  [(parallel [(call (mem:SI (match_operand 0 "arith_reg_operand" ""))
			    (match_operand 1 "" ""))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (reg:SI PR_REG))])]
  ""
  "
{
  if (flag_pic && TARGET_SH2
      && GET_CODE (operands[0]) == MEM
      && GET_CODE (XEXP (operands[0], 0)) == SYMBOL_REF)
    {
      emit_call_insn (gen_call_pcrel (XEXP (operands[0], 0), operands[1]));
      DONE;
    }
  else
    operands[0] = force_reg (SImode, XEXP (operands[0], 0));
}")

(define_expand "call_value"
  [(parallel [(set (match_operand 0 "arith_reg_operand" "")
		   (call (mem:SI (match_operand 1 "arith_reg_operand" ""))
				 (match_operand 2 "" "")))
	      (use (reg:PSI FPSCR_REG))
	      (clobber (reg:SI PR_REG))])]
  ""
  "
{
  if (flag_pic && TARGET_SH2
      && GET_CODE (operands[1]) == MEM
      && GET_CODE (XEXP (operands[1], 0)) == SYMBOL_REF)
    {
      emit_call_insn (gen_call_value_pcrel (operands[0], XEXP (operands[1], 0),
					    operands[2]));
      DONE;
    }
  else
    operands[1] = force_reg (SImode, XEXP (operands[1], 0));
}")

(define_insn "sibcalli"
  [(call (mem:SI (match_operand:SI 0 "register_operand" "k"))
	 (match_operand 1 "" ""))
   (use (reg:PSI FPSCR_REG))
   (return)]
  ""
  "jmp	@%0%#"
  [(set_attr "needs_delay_slot" "yes")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "type" "jump_ind")])

(define_insn "sibcalli_pcrel"
  [(call (mem:SI (match_operand:SI 0 "arith_reg_operand" "k"))
	 (match_operand 1 "" ""))
   (use (match_operand 2 "" ""))
   (use (reg:PSI FPSCR_REG))
   (return)]
  "TARGET_SH2"
  "braf	%0\\n%O2:%#"
  [(set_attr "needs_delay_slot" "yes")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "type" "jump_ind")])

(define_insn_and_split "sibcall_pcrel"
  [(call (mem:SI (match_operand:SI 0 "symbol_ref_operand" ""))
	 (match_operand 1 "" ""))
   (use (reg:PSI FPSCR_REG))
   (clobber (match_scratch:SI 2 "=k"))
   (return)]
  "TARGET_SH2"
  "#"
  "reload_completed"
  [(const_int 0)]
  "
{
  rtx lab = gen_call_site ();
  rtx call_insn;

  emit_insn (gen_sym_label2reg (operands[2], operands[0], lab));
  call_insn = emit_call_insn (gen_sibcalli_pcrel (operands[2], operands[1],
						  lab));
  SIBLING_CALL_P (call_insn) = 1;
  DONE;
}"
  [(set_attr "needs_delay_slot" "yes")
   (set (attr "fp_mode")
	(if_then_else (eq_attr "fpu_single" "yes")
		      (const_string "single") (const_string "double")))
   (set_attr "type" "jump_ind")])

(define_expand "sibcall"
  [(parallel
    [(call (mem:SI (match_operand 0 "arith_reg_operand" ""))
	   (match_operand 1 "" ""))
     (use (reg:PSI FPSCR_REG))
     (return)])]
  ""
  "
{
  if (flag_pic && TARGET_SH2
      && GET_CODE (operands[0]) == MEM
      && GET_CODE (XEXP (operands[0], 0)) == SYMBOL_REF
      /* The PLT needs the PIC register, but the epilogue would have
	 to restore it, so we can only use PC-relative PIC calls for
	 static functions.  */
      && SYMBOL_REF_FLAG (XEXP (operands[0], 0)))
    {
      emit_call_insn (gen_sibcall_pcrel (XEXP (operands[0], 0), operands[1]));
      DONE;
    }
  else
    operands[0] = force_reg (SImode, XEXP (operands[0], 0));
}")

(define_expand "sibcall_value"
  [(set (match_operand 0 "" "")
	(call (match_operand 1 "" "")
	      (match_operand 2 "" "")))]
  ""
  "
{
  emit_call_insn (gen_sibcall (operands[1], operands[2]));
  DONE;
}")

(define_expand "sibcall_epilogue"
  [(return)]
  ""
  "
{
  sh_expand_epilogue ();
  DONE;
}")

(define_insn "indirect_jump"
  [(set (pc)
	(match_operand:SI 0 "arith_reg_operand" "r"))]
  ""
  "jmp	@%0%#"
  [(set_attr "needs_delay_slot" "yes")
   (set_attr "type" "jump_ind")])

;; The use of operand 1 / 2 helps us distinguish case table jumps
;; which can be present in structured code from indirect jumps which can not
;; be present in structured code.  This allows -fprofile-arcs to work.

;; For SH1 processors.
(define_insn "casesi_jump_1"
  [(set (pc)
	(match_operand:SI 0 "register_operand" "r"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "jmp  @%0%#"
  [(set_attr "needs_delay_slot" "yes")
   (set_attr "type" "jump_ind")])

;; For all later processors.
(define_insn "casesi_jump_2"
  [(set (pc) (plus:SI (match_operand:SI 0 "register_operand" "r")
		      (label_ref (match_operand 1 "" ""))))
   (use (label_ref (match_operand 2 "" "")))]
  "TARGET_SH2
   && (! INSN_UID (operands[1]) || prev_real_insn (operands[1]) == insn)"
  "braf	%0%#"
  [(set_attr "needs_delay_slot" "yes")
   (set_attr "type" "jump_ind")])

;; Call subroutine returning any type.
;; ??? This probably doesn't work.

(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
		    (const_int 0))
	      (match_operand 1 "" "")
	      (match_operand 2 "" "")])]
  "TARGET_SH3E"
  "
{
  int i;

  emit_call_insn (gen_call (operands[0], const0_rtx));

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage ());

  DONE;
}")

;; ------------------------------------------------------------------------
;; Misc insns
;; ------------------------------------------------------------------------

(define_insn "dect"
  [(set (reg:SI T_REG)
	(eq:SI (match_operand:SI 0 "arith_reg_operand" "+r") (const_int 1)))
   (set (match_dup 0) (plus:SI (match_dup 0) (const_int -1)))]
  "TARGET_SH2"
  "dt	%0"
  [(set_attr "type" "arith")])

(define_insn "nop"
  [(const_int 0)]
  ""
  "nop")

;; Load address of a label. This is only generated by the casesi expand,
;; and by machine_dependent_reorg (fixing up fp moves).
;; This must use unspec, because this only works for labels that are
;; within range,

(define_insn "mova"
  [(set (reg:SI R0_REG)
	(unspec [(label_ref (match_operand 0 "" ""))] UNSPEC_MOVA))]
  ""
  "mova	%O0,r0"
  [(set_attr "in_delay_slot" "no")
   (set_attr "type" "arith")])

;; machine_dependent_reorg() will make this a `mova'.
(define_insn "mova_const"
  [(set (reg:SI R0_REG)
	(unspec [(match_operand 0 "immediate_operand" "i")] UNSPEC_MOVA))]
  ""
  "#"
  [(set_attr "in_delay_slot" "no")
   (set_attr "type" "arith")])

(define_expand "GOTaddr2picreg"
  [(set (reg:SI R0_REG)
	(unspec [(const:SI (unspec:SI [(match_dup 1)] UNSPEC_PIC))]
		UNSPEC_MOVA))
   (set (match_dup 0) (const:SI (unspec:SI [(match_dup 1)] UNSPEC_PIC)))
   (set (match_dup 0) (plus:SI (match_dup 0) (reg:SI R0_REG)))]
  "" "
{
  operands[0] = pic_offset_table_rtx;
  operands[1] = gen_rtx_SYMBOL_REF (VOIDmode, GOT_SYMBOL_NAME);
}
")

(define_expand "builtin_setjmp_receiver"
  [(match_operand 0 "" "")]
  "flag_pic"
  "
{
  emit_insn (gen_GOTaddr2picreg ());
  DONE;
}")

(define_expand "call_site"
  [(unspec [(match_dup 0)] UNSPEC_CALLER)]
  ""
  "
{
  static HOST_WIDE_INT i = 0;
  operands[0] = GEN_INT (i);
  i++;
}")

(define_expand "sym_label2reg"
  [(set (match_operand:SI 0 "" "")
	(const (minus:SI
		(const:SI (unspec:SI [(match_operand:SI 1 "" "")] UNSPEC_PIC))
		(const (plus:SI
			(match_operand:SI 2 "" "")
			(const_int 2))))))]
  "" "")

(define_expand "symGOT2reg"
  [(set (match_operand:SI 0 "" "")
        (const:SI (unspec:SI [(match_operand:SI 1 "" "")] UNSPEC_GOT)))
  (set (match_dup 0) (plus:SI (match_dup 0) (match_dup 2)))
  (set (match_dup 0) (mem:SI (match_dup 0)))]
  ""
  "
{
  operands[2] = pic_offset_table_rtx;
}")

(define_expand "symGOTOFF2reg"
  [(set (match_operand:SI 0 "" "")
	(const:SI (unspec:SI [(match_operand:SI 1 "" "")] UNSPEC_GOTOFF)))
  (set (match_dup 0) (plus:SI (match_dup 0) (match_dup 2)))]
  ""
  "
{
  operands[2] = pic_offset_table_rtx;
}")

(define_expand "symPLT_label2reg"
  [(set (match_operand:SI 0 "" "")
	(const (minus:SI
		(const (plus:SI
			(unspec [(match_operand:SI 1 "" "")] UNSPEC_PLT)
			(pc)))
		(const (plus:SI
			(match_operand:SI 2 "" "")
			(const_int 2))))))
   ;; Even though the PIC register is not really used by the call
   ;; sequence in which this is expanded, the PLT code assumes the PIC
   ;; register is set, so we must not skip its initialization.  Since
   ;; we only use this expand as part of calling sequences, and never
   ;; to take the address of a function, this is the best point to
   ;; insert the (use).  Using the PLT to take the address of a
   ;; function would be wrong, not only because the PLT entry could
   ;; then be called from a function that doesn't initialize the PIC
   ;; register to the proper GOT, but also because pointers to the
   ;; same function might not compare equal, should they be set by
   ;; different shared libraries.
   (use (reg:SI PIC_REG))]
  ""
  "")

;; case instruction for switch statements.

;; Operand 0 is index
;; operand 1 is the minimum bound
;; operand 2 is the maximum bound - minimum bound + 1
;; operand 3 is CODE_LABEL for the table;
;; operand 4 is the CODE_LABEL to go to if index out of range.

(define_expand "casesi"
  [(match_operand:SI 0 "arith_reg_operand" "")
   (match_operand:SI 1 "arith_reg_operand" "")
   (match_operand:SI 2 "arith_reg_operand" "")
   (match_operand 3 "" "") (match_operand 4 "" "")]
  ""
  "
{
  rtx reg = gen_reg_rtx (SImode);
  rtx reg2 = gen_reg_rtx (SImode);
  operands[1] = copy_to_mode_reg (SImode, operands[1]);
  operands[2] = copy_to_mode_reg (SImode, operands[2]);
  /* If optimizing, casesi_worker depends on the mode of the instruction
     before label it 'uses' - operands[3].  */
  emit_insn (gen_casesi_0 (operands[0], operands[1], operands[2], operands[4],
			   reg));
  emit_insn (gen_casesi_worker_0 (reg2, reg, operands[3]));
  if (TARGET_SH2)
    emit_jump_insn (gen_casesi_jump_2 (reg2, gen_label_rtx (), operands[3]));
  else
    emit_jump_insn (gen_casesi_jump_1 (reg2, operands[3]));
  /* For SH2 and newer, the ADDR_DIFF_VEC is not actually relative to
     operands[3], but to lab.  We will fix this up in
     machine_dependent_reorg.  */
  emit_barrier ();
  DONE;
}")

(define_expand "casesi_0"
  [(set (match_operand:SI 4 "" "") (match_operand:SI 0 "arith_reg_operand" ""))
   (set (match_dup 4) (minus:SI (match_dup 4)
				(match_operand:SI 1 "arith_operand" "")))
   (set (reg:SI T_REG)
	(gtu:SI (match_dup 4)
		(match_operand:SI 2 "arith_reg_operand" "")))
   (set (pc)
	(if_then_else (ne (reg:SI T_REG)
			  (const_int 0))
		      (label_ref (match_operand 3 "" ""))
		      (pc)))]
  ""
  "")

;; ??? reload might clobber r0 if we use it explicitly in the RTL before
;; reload; using a R0_REGS pseudo reg is likely to give poor code.
;; So we keep the use of r0 hidden in a R0_REGS clobber until after reload.

(define_insn "casesi_worker_0"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(unspec:SI [(match_operand 1 "register_operand" "0,r")
		 (label_ref (match_operand 2 "" ""))] UNSPEC_CASESI))
   (clobber (match_scratch:SI 3 "=X,1"))
   (clobber (match_scratch:SI 4 "=&z,z"))]
  ""
  "#")

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(unspec [(match_operand 1 "register_operand" "")
		 (label_ref (match_operand 2 "" ""))] UNSPEC_CASESI))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "! TARGET_SH2 && reload_completed"
  [(set (reg:SI R0_REG) (unspec [(label_ref (match_dup 2))] UNSPEC_MOVA))
   (parallel [(set (match_dup 0)
	      (unspec [(reg:SI R0_REG) (match_dup 1)
		       (label_ref (match_dup 2))] UNSPEC_CASESI))
	      (clobber (match_dup 3))])
   (set (match_dup 0) (plus:SI (match_dup 0) (reg:SI R0_REG)))]
  "LABEL_NUSES (operands[2])++;")

(define_split
  [(set (match_operand:SI 0 "register_operand" "")
	(unspec:SI [(match_operand 1 "register_operand" "")
		 (label_ref (match_operand 2 "" ""))] UNSPEC_CASESI))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_SH2 && reload_completed"
  [(set (reg:SI R0_REG) (unspec [(label_ref (match_dup 2))] UNSPEC_MOVA))
   (parallel [(set (match_dup 0)
	      (unspec:SI [(reg:SI R0_REG) (match_dup 1)
		       (label_ref (match_dup 2))] UNSPEC_CASESI))
	      (clobber (match_dup 3))])]
  "LABEL_NUSES (operands[2])++;")

(define_insn "*casesi_worker"
  [(set (match_operand:SI 0 "register_operand" "=r,r")
	(unspec [(reg:SI R0_REG) (match_operand 1 "register_operand" "0,r")
		 (label_ref (match_operand 2 "" ""))] UNSPEC_CASESI))
   (clobber (match_scratch:SI 3 "=X,1"))]
  ""
  "*
{
  rtx diff_vec = PATTERN (next_real_insn (operands[2]));

  if (GET_CODE (diff_vec) != ADDR_DIFF_VEC)
    abort ();

  switch (GET_MODE (diff_vec))
    {
    case SImode:
      return \"shll2	%1\;mov.l	@(r0,%1),%0\";
    case HImode:
      return \"add	%1,%1\;mov.w	@(r0,%1),%0\";
    case QImode:
      if (ADDR_DIFF_VEC_FLAGS (diff_vec).offset_unsigned)
	return \"mov.b	@(r0,%1),%0\;extu.b	%0,%0\";
      return \"mov.b	@(r0,%1),%0\";
    default:
      abort ();
    }
}"
  [(set_attr "length" "4")])

(define_expand "return"
  [(return)]
  "reload_completed && ! sh_need_epilogue ()"
  "")

(define_insn "*return_i"
  [(return)]
  "reload_completed"
  "%@	%#"
  [(set_attr "type" "return")
   (set_attr "needs_delay_slot" "yes")])

(define_expand "prologue"
  [(const_int 0)]
  ""
  "sh_expand_prologue (); DONE;")

(define_expand "epilogue"
  [(return)]
  ""
  "sh_expand_epilogue ();")

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] UNSPECV_BLOCKAGE)]
  ""
  ""
  [(set_attr "length" "0")])

;; ------------------------------------------------------------------------
;; Scc instructions
;; ------------------------------------------------------------------------

(define_insn "movt"
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(eq:SI (reg:SI T_REG) (const_int 1)))]
  ""
  "movt	%0"
  [(set_attr "type" "arith")])

(define_expand "seq"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (EQ);")

(define_expand "slt"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (LT);")

(define_expand "sle"
  [(match_operand:SI 0 "arith_reg_operand" "")]
  ""
  "
{
  rtx tmp = sh_compare_op0;
  sh_compare_op0 = sh_compare_op1;
  sh_compare_op1 = tmp;
  emit_insn (gen_sge (operands[0]));
  DONE;
}")

(define_expand "sgt"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (GT);")

(define_expand "sge"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "
{
  if (GET_MODE_CLASS (GET_MODE (sh_compare_op0)) == MODE_FLOAT)
    {
      if (TARGET_IEEE)
	{
	  rtx lab = gen_label_rtx ();
	  prepare_scc_operands (EQ);
	  emit_jump_insn (gen_branch_true (lab));
	  prepare_scc_operands (GT);
	  emit_label (lab);
	  emit_insn (gen_movt (operands[0]));
	}
      else
	emit_insn (gen_movnegt (operands[0], prepare_scc_operands (LT)));
      DONE;
    }
  operands[1] = prepare_scc_operands (GE);
}")

(define_expand "sgtu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (GTU);")

(define_expand "sltu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (LTU);")

(define_expand "sleu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (LEU);")

(define_expand "sgeu"
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(match_dup 1))]
  ""
  "operands[1] = prepare_scc_operands (GEU);")

;; sne moves the complement of the T reg to DEST like this:
;;      cmp/eq ...
;;      mov    #-1,temp
;;      negc   temp,dest
;;   This is better than xoring compare result with 1 because it does
;;   not require r0 and further, the -1 may be CSE-ed or lifted out of a
;;   loop.

(define_expand "sne"
  [(set (match_dup 2) (const_int -1))
   (parallel [(set (match_operand:SI 0 "arith_reg_operand" "")
		   (neg:SI (plus:SI (match_dup 1)
				    (match_dup 2))))
	      (set (reg:SI T_REG)
		   (ne:SI (ior:SI (match_dup 1) (match_dup 2))
			  (const_int 0)))])]  
  ""
  "
{
   operands[1] = prepare_scc_operands (EQ);
   operands[2] = gen_reg_rtx (SImode);
}")

;; Use the same trick for FP sle / sge
(define_expand "movnegt"
  [(set (match_dup 2) (const_int -1))
   (parallel [(set (match_operand 0 "" "")
		   (neg:SI (plus:SI (match_dup 1)
				    (match_dup 2))))
	      (set (reg:SI T_REG)
		   (ne:SI (ior:SI (match_operand 1 "" "") (match_dup 2))
			  (const_int 0)))])]  
  ""
  "operands[2] = gen_reg_rtx (SImode);")

;; Recognize mov #-1/negc/neg sequence, and change it to movt/add #-1.
;; This prevents a regression that occurred when we switched from xor to
;; mov/neg for sne.

(define_split
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(plus:SI (reg:SI T_REG)
		 (const_int -1)))]
  ""
  [(set (match_dup 0) (eq:SI (reg:SI T_REG) (const_int 1)))
   (set (match_dup 0) (plus:SI (match_dup 0) (const_int -1)))]
  "")

;; -------------------------------------------------------------------------
;; Instructions to cope with inline literal tables
;; -------------------------------------------------------------------------

; 2 byte integer in line

(define_insn "consttable_2"
 [(unspec_volatile [(match_operand:SI 0 "general_operand" "=g")
		    (match_operand 1 "" "")]
		   UNSPECV_CONST2)]
 ""
 "*
{
  if (operands[1] != const0_rtx)
    assemble_integer (operands[0], 2, BITS_PER_UNIT * 2, 1);
  return \"\";
}"
 [(set_attr "length" "2")
 (set_attr "in_delay_slot" "no")])

; 4 byte integer in line

(define_insn "consttable_4"
 [(unspec_volatile [(match_operand:SI 0 "general_operand" "=g")
		    (match_operand 1 "" "")]
		   UNSPECV_CONST4)]
 ""
 "*
{
  if (operands[1] != const0_rtx)
    assemble_integer (operands[0], 4, BITS_PER_UNIT * 4, 1);
  return \"\";
}"
 [(set_attr "length" "4")
  (set_attr "in_delay_slot" "no")])

; 8 byte integer in line

(define_insn "consttable_8"
 [(unspec_volatile [(match_operand:SI 0 "general_operand" "=g")
		    (match_operand 1 "" "")]
		   UNSPECV_CONST8)]
 ""
 "*
{
  if (operands[1] != const0_rtx)
    assemble_integer (operands[0], 8, BITS_PER_UNIT * 8, 1);
  return \"\";
}"
 [(set_attr "length" "8")
  (set_attr "in_delay_slot" "no")])

; 4 byte floating point

(define_insn "consttable_sf"
 [(unspec_volatile [(match_operand:SF 0 "general_operand" "=g")
		    (match_operand 1 "" "")]
		   UNSPECV_CONST4)]
 ""
 "*
{
  if (operands[1] != const0_rtx)
    {
      union real_extract u;
      memcpy (&u, &CONST_DOUBLE_LOW (operands[0]), sizeof u);
      assemble_real (u.d, SFmode, GET_MODE_ALIGNMENT (SFmode));
    }
  return \"\";
}"
 [(set_attr "length" "4")
  (set_attr "in_delay_slot" "no")])

; 8 byte floating point

(define_insn "consttable_df"
 [(unspec_volatile [(match_operand:DF 0 "general_operand" "=g")
		    (match_operand 1 "" "")]
		   UNSPECV_CONST8)]
 ""
 "*
{
  if (operands[1] != const0_rtx)
    {
      union real_extract u;
      memcpy (&u, &CONST_DOUBLE_LOW (operands[0]), sizeof u);
      assemble_real (u.d, DFmode, GET_MODE_ALIGNMENT (DFmode));
    }
  return \"\";
}"
 [(set_attr "length" "8")
  (set_attr "in_delay_slot" "no")])

;; Alignment is needed for some constant tables; it may also be added for
;; Instructions at the start of loops, or after unconditional branches.
;; ??? We would get more accurate lengths if we did instruction
;; alignment based on the value of INSN_CURRENT_ADDRESS; the approach used
;; here is too conservative.

; align to a two byte boundary

(define_expand "align_2"
 [(unspec_volatile [(const_int 1)] UNSPECV_ALIGN)]
 ""
 "")

; align to a four byte boundary
;; align_4 and align_log are instructions for the starts of loops, or
;; after unconditional branches, which may take up extra room.

(define_expand "align_4"
 [(unspec_volatile [(const_int 2)] UNSPECV_ALIGN)]
 ""
 "")

; align to a cache line boundary

(define_insn "align_log"
 [(unspec_volatile [(match_operand 0 "const_int_operand" "")] UNSPECV_ALIGN)]
 ""
 ""
 [(set_attr "length" "0")
  (set_attr "in_delay_slot" "no")])

; emitted at the end of the literal table, used to emit the
; 32bit branch labels if needed.

(define_insn "consttable_end"
  [(unspec_volatile [(const_int 0)] UNSPECV_CONST_END)]
  ""
  "* return output_jump_label_table ();"
  [(set_attr "in_delay_slot" "no")])

; emitted at the end of the window in the literal table.

(define_insn "consttable_window_end"
  [(unspec_volatile [(match_operand 0 "" "")] UNSPECV_WINDOW_END)]
  ""
  ""
  [(set_attr "length" "0")
   (set_attr "in_delay_slot" "no")])

;; -------------------------------------------------------------------------
;; Misc
;; -------------------------------------------------------------------------

;; String/block move insn.

(define_expand "movstrsi"
  [(parallel [(set (mem:BLK (match_operand:BLK 0 "" ""))
		   (mem:BLK (match_operand:BLK 1 "" "")))
	      (use (match_operand:SI 2 "nonmemory_operand" ""))
	      (use (match_operand:SI 3 "immediate_operand" ""))
	      (clobber (reg:SI PR_REG))
	      (clobber (reg:SI R4_REG))
	      (clobber (reg:SI R5_REG))
	      (clobber (reg:SI R0_REG))])]
  ""
  "
{
  if(expand_block_move (operands))
     DONE;
  else FAIL;
}")

(define_insn "block_move_real"
  [(parallel [(set (mem:BLK (reg:SI R4_REG))
		   (mem:BLK (reg:SI R5_REG)))
	      (use (match_operand:SI 0 "arith_reg_operand" "r"))
	      (clobber (reg:SI PR_REG))
	      (clobber (reg:SI R0_REG))])]
  "! TARGET_HARD_SH4"
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "block_lump_real"
  [(parallel [(set (mem:BLK (reg:SI R4_REG))
		   (mem:BLK (reg:SI R5_REG)))
	      (use (match_operand:SI 0 "arith_reg_operand" "r"))
	      (use (reg:SI R6_REG))
	      (clobber (reg:SI PR_REG))
	      (clobber (reg:SI T_REG))
	      (clobber (reg:SI R4_REG))
	      (clobber (reg:SI R5_REG))
	      (clobber (reg:SI R6_REG))
	      (clobber (reg:SI R0_REG))])]
  "! TARGET_HARD_SH4"
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "block_move_real_i4"
  [(parallel [(set (mem:BLK (reg:SI R4_REG))
		   (mem:BLK (reg:SI R5_REG)))
	      (use (match_operand:SI 0 "arith_reg_operand" "r"))
	      (clobber (reg:SI PR_REG))
	      (clobber (reg:SI R0_REG))
	      (clobber (reg:SI R1_REG))
	      (clobber (reg:SI R2_REG))])]
  "TARGET_HARD_SH4"
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

(define_insn "block_lump_real_i4"
  [(parallel [(set (mem:BLK (reg:SI R4_REG))
		   (mem:BLK (reg:SI R5_REG)))
	      (use (match_operand:SI 0 "arith_reg_operand" "r"))
	      (use (reg:SI R6_REG))
	      (clobber (reg:SI PR_REG))
	      (clobber (reg:SI T_REG))
	      (clobber (reg:SI R4_REG))
	      (clobber (reg:SI R5_REG))
	      (clobber (reg:SI R6_REG))
	      (clobber (reg:SI R0_REG))
	      (clobber (reg:SI R1_REG))
	      (clobber (reg:SI R2_REG))
	      (clobber (reg:SI R3_REG))])]
  "TARGET_HARD_SH4"
  "jsr	@%0%#"
  [(set_attr "type" "sfunc")
   (set_attr "needs_delay_slot" "yes")])

;; -------------------------------------------------------------------------
;; Floating point instructions.
;; -------------------------------------------------------------------------

;; ??? All patterns should have a type attribute.

(define_expand "fpu_switch0"
  [(set (match_operand:SI 0 "" "") (match_dup 2))
   (set (match_dup 1) (mem:PSI (match_dup 0)))]
  "TARGET_SH4"
  "
{
  operands[1] = get_fpscr_rtx ();
  operands[2] = gen_rtx_SYMBOL_REF (SImode, \"__fpscr_values\");
  if (flag_pic)
    operands[2] = legitimize_pic_address (operands[2], SImode,
					  no_new_pseudos ? operands[0] : 0);
}")

(define_expand "fpu_switch1"
  [(set (match_operand:SI 0 "" "") (match_dup 2))
   (set (match_dup 3) (plus:SI (match_dup 0) (const_int 4)))
   (set (match_dup 1) (mem:PSI (match_dup 3)))]
  "TARGET_SH4"
  "
{
  operands[1] = get_fpscr_rtx ();
  operands[2] = gen_rtx_SYMBOL_REF (SImode, \"__fpscr_values\");
  if (flag_pic)
    operands[2] = legitimize_pic_address (operands[2], SImode,
					  no_new_pseudos ? operands[0] : 0);
  operands[3] = no_new_pseudos ? operands[0] : gen_reg_rtx (SImode);
}")

(define_expand "movpsi"
  [(set (match_operand:PSI 0 "register_operand" "")
	(match_operand:PSI 1 "general_movsrc_operand" ""))]
  "TARGET_SH4"
  "")

;; The c / m alternative is a fake to guide reload to load directly into
;; fpscr, since reload doesn't know how to use post-increment.
;; GO_IF_LEGITIMATE_ADDRESS guards about bogus addresses before reload,
;; SECONDARY_INPUT_RELOAD_CLASS does this during reload, and the insn's
;; predicate after reload.
;; The gp_fpul type for r/!c might look a bit odd, but it actually schedules
;; like a gpr <-> fpul move.
(define_insn "fpu_switch"
  [(set (match_operand:PSI 0 "register_operand" "=c,c,r,c,c,r,m,r")
	(match_operand:PSI 1 "general_movsrc_operand" "c,>,m,m,r,r,r,!c"))]
  "TARGET_SH4
   && (! reload_completed
       || true_regnum (operands[0]) != FPSCR_REG
       || GET_CODE (operands[1]) != MEM
       || GET_CODE (XEXP (operands[1], 0)) != PLUS)"
  "@
	! precision stays the same
	lds.l	%1,fpscr
	mov.l	%1,%0
	#
	lds	%1,fpscr
	mov	%1,%0
	mov.l	%1,%0
	sts	fpscr,%0"
  [(set_attr "length" "0,2,2,4,2,2,2,2")
   (set_attr "type" "dfp_conv,dfp_conv,load,dfp_conv,dfp_conv,move,store,gp_fpul")])

(define_split
  [(set (reg:PSI FPSCR_REG)
	(mem:PSI (match_operand:SI 0 "register_operand" "r")))]
  "TARGET_SH4 && find_regno_note (insn, REG_DEAD, true_regnum (operands[0]))"
  [(set (match_dup 0) (match_dup 0))]
  "
{
  rtx insn = emit_insn (gen_fpu_switch (get_fpscr_rtx (),
					gen_rtx (MEM, PSImode,
						 gen_rtx (POST_INC, Pmode,
							  operands[0]))));
  REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_INC, operands[0], NULL_RTX);
}")

(define_split
  [(set (reg:PSI FPSCR_REG)
	(mem:PSI (match_operand:SI 0 "register_operand" "r")))]
  "TARGET_SH4"
  [(set (match_dup 0) (plus:SI (match_dup 0) (const_int -4)))]
  "
{
  rtx insn = emit_insn (gen_fpu_switch (get_fpscr_rtx (),
					gen_rtx (MEM, PSImode,
						 gen_rtx (POST_INC, Pmode,
							  operands[0]))));
  REG_NOTES (insn) = gen_rtx (EXPR_LIST, REG_INC, operands[0], NULL_RTX);
}")

;; ??? This uses the fp unit, but has no type indicating that.
;; If we did that, this would either give a bogus latency or introduce
;; a bogus FIFO constraint.
;; Since this insn is currently only used for prologues/epilogues,
;; it is probably best to claim no function unit, which matches the
;; current setting.
(define_insn "toggle_sz"
  [(set (reg:PSI FPSCR_REG)
	(xor:PSI (reg:PSI FPSCR_REG) (const_int 1048576)))]
  "TARGET_SH4"
  "fschg")

(define_expand "addsf3"
  [(match_operand:SF 0 "arith_reg_operand" "")
   (match_operand:SF 1 "arith_reg_operand" "")
   (match_operand:SF 2 "arith_reg_operand" "")]
  "TARGET_SH3E"
  "{ expand_sf_binop (&gen_addsf3_i, operands); DONE; }")

(define_insn "addsf3_i"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "arith_reg_operand" "%0")
		 (match_operand:SF 2 "arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH3E"
  "fadd	%2,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_expand "subsf3"
  [(match_operand:SF 0 "fp_arith_reg_operand" "")
   (match_operand:SF 1 "fp_arith_reg_operand" "")
   (match_operand:SF 2 "fp_arith_reg_operand" "")]
  "TARGET_SH3E"
  "{ expand_sf_binop (&gen_subsf3_i, operands); DONE; }")

(define_insn "subsf3_i"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "fp_arith_reg_operand" "0")
		 (match_operand:SF 2 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH3E"
  "fsub	%2,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

;; Unfortunately, the combiner is unable to cope with the USE of the FPSCR
;; register in feeding fp instructions.  Thus, we cannot generate fmac for
;; mixed-precision SH4 targets.  To allow it to be still generated for the
;; SH3E, we use a separate insn for SH3E mulsf3.

(define_expand "mulsf3"
  [(match_operand:SF 0 "fp_arith_reg_operand" "")
   (match_operand:SF 1 "fp_arith_reg_operand" "")
   (match_operand:SF 2 "fp_arith_reg_operand" "")]
  "TARGET_SH3E"
  "
{
  if (TARGET_SH4)
    expand_sf_binop (&gen_mulsf3_i4, operands);
  else
    emit_insn (gen_mulsf3_ie (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "mulsf3_i4"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "fp_arith_reg_operand" "%0")
		 (match_operand:SF 2 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH3E"
  "fmul	%2,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_insn "mulsf3_ie"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "fp_arith_reg_operand" "%0")
		 (match_operand:SF 2 "fp_arith_reg_operand" "f")))]
  "TARGET_SH3E && ! TARGET_SH4"
  "fmul	%2,%0"
  [(set_attr "type" "fp")])

(define_insn "*macsf3"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "fp_arith_reg_operand" "%w")
			  (match_operand:SF 2 "fp_arith_reg_operand" "f"))
		 (match_operand:SF 3 "arith_reg_operand" "0")))
   (use (match_operand:PSI 4 "fpscr_operand" "c"))]
  "TARGET_SH3E && ! TARGET_SH4"
  "fmac	fr0,%2,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_expand "divsf3"
  [(match_operand:SF 0 "arith_reg_operand" "")
   (match_operand:SF 1 "arith_reg_operand" "")
   (match_operand:SF 2 "arith_reg_operand" "")]
  "TARGET_SH3E"
  "{ expand_sf_binop (&gen_divsf3_i, operands); DONE; }")

(define_insn "divsf3_i"
  [(set (match_operand:SF 0 "arith_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "arith_reg_operand" "0")
		 (match_operand:SF 2 "arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH3E"
  "fdiv	%2,%0"
  [(set_attr "type" "fdiv")
   (set_attr "fp_mode" "single")])

(define_expand "floatsisf2"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "")
	(float:SF (match_operand:SI 1 "fpul_operand" "")))]
  "TARGET_SH3E"
  "
{
  if (TARGET_SH4)
    {
      emit_sf_insn (gen_floatsisf2_i4 (operands[0], operands[1], get_fpscr_rtx ()));
      DONE;
    }
}")

(define_insn "floatsisf2_i4"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(float:SF (match_operand:SI 1 "fpul_operand" "y")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "float	%1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_insn "*floatsisf2_ie"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(float:SF (match_operand:SI 1 "fpul_operand" "y")))]
  "TARGET_SH3E && ! TARGET_SH4"
  "float	%1,%0"
  [(set_attr "type" "fp")])

(define_expand "fix_truncsfsi2"
  [(set (match_operand:SI 0 "fpul_operand" "=y")
	(fix:SI (match_operand:SF 1 "fp_arith_reg_operand" "f")))]
  "TARGET_SH3E"
  "
{
  if (TARGET_SH4)
    {
      emit_sf_insn (gen_fix_truncsfsi2_i4 (operands[0], operands[1], get_fpscr_rtx ()));
      DONE;
    }
}")

(define_insn "fix_truncsfsi2_i4"
  [(set (match_operand:SI 0 "fpul_operand" "=y")
	(fix:SI (match_operand:SF 1 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "ftrc	%1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

;; ??? This pattern is used nowhere.  fix_truncsfsi2 always expands to
;; fix_truncsfsi2_i4.
;; (define_insn "fix_truncsfsi2_i4_2"
;;  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
;;	(fix:SI (match_operand:SF 1 "arith_reg_operand" "f")))
;;   (use (reg:PSI FPSCR_REG))
;;   (clobber (reg:SI FPUL_REG))]
;;  "TARGET_SH4"
;;  "#"
;;  [(set_attr "length" "4")
;;   (set_attr "fp_mode" "single")])

;;(define_split
;;  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
;;	(fix:SI (match_operand:SF 1 "arith_reg_operand" "f")))
;;   (use (match_operand:PSI 2 "fpscr_operand" "c"))
;;   (clobber (reg:SI FPUL_REG))]
;;  "TARGET_SH4"
;;  [(parallel [(set (reg:SI FPUL_REG) (fix:SI (match_dup 1)))
;;	      (use (match_dup 2))])
;;   (set (match_dup 0) (reg:SI FPUL_REG))])

(define_insn "*fixsfsi"
  [(set (match_operand:SI 0 "fpul_operand" "=y")
	(fix:SI (match_operand:SF 1 "fp_arith_reg_operand" "f")))]
  "TARGET_SH3E && ! TARGET_SH4"
  "ftrc	%1,%0"
  [(set_attr "type" "fp")])

(define_insn "cmpgtsf_t"
  [(set (reg:SI T_REG)
	(gt:SI (match_operand:SF 0 "fp_arith_reg_operand" "f")
	       (match_operand:SF 1 "fp_arith_reg_operand" "f")))]
  "TARGET_SH3E && ! TARGET_SH4"
  "fcmp/gt	%1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_insn "cmpeqsf_t"
  [(set (reg:SI T_REG)
	(eq:SI (match_operand:SF 0 "fp_arith_reg_operand" "f")
	       (match_operand:SF 1 "fp_arith_reg_operand" "f")))]
  "TARGET_SH3E && ! TARGET_SH4"
  "fcmp/eq	%1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_insn "ieee_ccmpeqsf_t"
  [(set (reg:SI T_REG)
	(ior:SI (reg:SI T_REG)
		(eq:SI (match_operand:SF 0 "fp_arith_reg_operand" "f")
		       (match_operand:SF 1 "fp_arith_reg_operand" "f"))))]
  "TARGET_SH3E && TARGET_IEEE && ! TARGET_SH4"
  "* return output_ieee_ccmpeq (insn, operands);"
  [(set_attr "length" "4")])


(define_insn "cmpgtsf_t_i4"
  [(set (reg:SI T_REG)
	(gt:SI (match_operand:SF 0 "fp_arith_reg_operand" "f")
	       (match_operand:SF 1 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fcmp/gt	%1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_insn "cmpeqsf_t_i4"
  [(set (reg:SI T_REG)
	(eq:SI (match_operand:SF 0 "fp_arith_reg_operand" "f")
	       (match_operand:SF 1 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fcmp/eq	%1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "single")])

(define_insn "*ieee_ccmpeqsf_t_4"
  [(set (reg:SI T_REG)
	(ior:SI (reg:SI T_REG)
		(eq:SI (match_operand:SF 0 "fp_arith_reg_operand" "f")
		       (match_operand:SF 1 "fp_arith_reg_operand" "f"))))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_IEEE && TARGET_SH4"
  "* return output_ieee_ccmpeq (insn, operands);"
  [(set_attr "length" "4")
   (set_attr "fp_mode" "single")])

(define_expand "cmpsf"
  [(set (reg:SI T_REG)
	(compare (match_operand:SF 0 "arith_operand" "")
		 (match_operand:SF 1 "arith_operand" "")))]
  "TARGET_SH3E"
  "
{
  sh_compare_op0 = operands[0];
  sh_compare_op1 = operands[1];
  DONE;
}")

(define_expand "negsf2"
  [(match_operand:SF 0 "fp_arith_reg_operand" "")
   (match_operand:SF 1 "fp_arith_reg_operand" "")]
  "TARGET_SH3E"
  "{ expand_sf_unop (&gen_negsf2_i, operands); DONE; }")

(define_insn "negsf2_i"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(neg:SF (match_operand:SF 1 "fp_arith_reg_operand" "0")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH3E"
  "fneg	%0"
  [(set_attr "type" "fmove")
   (set_attr "fp_mode" "single")])

(define_expand "sqrtsf2"
  [(match_operand:SF 0 "fp_arith_reg_operand" "")
   (match_operand:SF 1 "fp_arith_reg_operand" "")]
  "TARGET_SH3E"
  "{ expand_sf_unop (&gen_sqrtsf2_i, operands); DONE; }")

(define_insn "sqrtsf2_i"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "fp_arith_reg_operand" "0")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH3E"
  "fsqrt	%0"
  [(set_attr "type" "fdiv")
   (set_attr "fp_mode" "single")])

(define_expand "abssf2"
  [(match_operand:SF 0 "fp_arith_reg_operand" "")
   (match_operand:SF 1 "fp_arith_reg_operand" "")]
  "TARGET_SH3E"
  "{ expand_sf_unop (&gen_abssf2_i, operands); DONE; }")

(define_insn "abssf2_i"
  [(set (match_operand:SF 0 "fp_arith_reg_operand" "=f")
	(abs:SF (match_operand:SF 1 "fp_arith_reg_operand" "0")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH3E"
  "fabs	%0"
  [(set_attr "type" "fmove")
   (set_attr "fp_mode" "single")])

(define_expand "adddf3"
  [(match_operand:DF 0 "fp_arith_reg_operand" "")
   (match_operand:DF 1 "fp_arith_reg_operand" "")
   (match_operand:DF 2 "fp_arith_reg_operand" "")]
  "TARGET_SH4"
  "{ expand_df_binop (&gen_adddf3_i, operands); DONE; }")

(define_insn "adddf3_i"
  [(set (match_operand:DF 0 "fp_arith_reg_operand" "=f")
	(plus:DF (match_operand:DF 1 "fp_arith_reg_operand" "%0")
		 (match_operand:DF 2 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fadd	%2,%0"
  [(set_attr "type" "dfp_arith")
   (set_attr "fp_mode" "double")])

(define_expand "subdf3"
  [(match_operand:DF 0 "fp_arith_reg_operand" "")
   (match_operand:DF 1 "fp_arith_reg_operand" "")
   (match_operand:DF 2 "fp_arith_reg_operand" "")]
  "TARGET_SH4"
  "{ expand_df_binop (&gen_subdf3_i, operands); DONE; }")

(define_insn "subdf3_i"
  [(set (match_operand:DF 0 "fp_arith_reg_operand" "=f")
	(minus:DF (match_operand:DF 1 "fp_arith_reg_operand" "0")
		  (match_operand:DF 2 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fsub	%2,%0"
  [(set_attr "type" "dfp_arith")
   (set_attr "fp_mode" "double")])

(define_expand "muldf3"
  [(match_operand:DF 0 "fp_arith_reg_operand" "")
   (match_operand:DF 1 "fp_arith_reg_operand" "")
   (match_operand:DF 2 "fp_arith_reg_operand" "")]
  "TARGET_SH4"
  "{ expand_df_binop (&gen_muldf3_i, operands); DONE; }")

(define_insn "muldf3_i"
  [(set (match_operand:DF 0 "fp_arith_reg_operand" "=f")
	(mult:DF (match_operand:DF 1 "fp_arith_reg_operand" "%0")
		 (match_operand:DF 2 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fmul	%2,%0"
  [(set_attr "type" "dfp_arith")
   (set_attr "fp_mode" "double")])

(define_expand "divdf3"
  [(match_operand:DF 0 "fp_arith_reg_operand" "")
   (match_operand:DF 1 "fp_arith_reg_operand" "")
   (match_operand:DF 2 "fp_arith_reg_operand" "")]
  "TARGET_SH4"
  "{ expand_df_binop (&gen_divdf3_i, operands); DONE; }")

(define_insn "divdf3_i"
  [(set (match_operand:DF 0 "fp_arith_reg_operand" "=f")
	(div:DF (match_operand:DF 1 "fp_arith_reg_operand" "0")
		(match_operand:DF 2 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 3 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fdiv	%2,%0"
  [(set_attr "type" "dfdiv")
   (set_attr "fp_mode" "double")])

(define_expand "floatsidf2"
  [(match_operand:DF 0 "fp_arith_reg_operand" "")
   (match_operand:SI 1 "fpul_operand" "")]
  "TARGET_SH4"
  "
{
  emit_df_insn (gen_floatsidf2_i (operands[0], operands[1], get_fpscr_rtx ()));
  DONE;
}")

(define_insn "floatsidf2_i"
  [(set (match_operand:DF 0 "fp_arith_reg_operand" "=f")
	(float:DF (match_operand:SI 1 "fpul_operand" "y")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "float	%1,%0"
  [(set_attr "type" "dfp_conv")
   (set_attr "fp_mode" "double")])

(define_expand "fix_truncdfsi2"
  [(match_operand:SI 0 "fpul_operand" "")
   (match_operand:DF 1 "fp_arith_reg_operand" "")]
  "TARGET_SH4"
  "
{
  emit_df_insn (gen_fix_truncdfsi2_i (operands[0], operands[1], get_fpscr_rtx ()));
  DONE;
}")

(define_insn "fix_truncdfsi2_i"
  [(set (match_operand:SI 0 "fpul_operand" "=y")
	(fix:SI (match_operand:DF 1 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "ftrc	%1,%0"
  [(set_attr "type" "dfp_conv")
   (set_attr "fp_mode" "double")])

;; ??? This pattern is used nowhere.  fix_truncdfsi2 always expands to
;; fix_truncdfsi2_i.
;; (define_insn "fix_truncdfsi2_i4"
;;   [(set (match_operand:SI 0 "arith_reg_operand" "=r")
;; 	(fix:SI (match_operand:DF 1 "arith_reg_operand" "f")))
;;    (use (match_operand:PSI 2 "fpscr_operand" "c"))
;;    (clobber (reg:SI FPUL_REG))]
;;   "TARGET_SH4"
;;   "#"
;;   [(set_attr "length" "4")
;;    (set_attr "fp_mode" "double")])
;; 
;; (define_split
;;   [(set (match_operand:SI 0 "arith_reg_operand" "=r")
;; 	(fix:SI (match_operand:DF 1 "arith_reg_operand" "f")))
;;    (use (match_operand:PSI 2 "fpscr_operand" "c"))
;;    (clobber (reg:SI FPUL_REG))]
;;   "TARGET_SH4"
;;   [(parallel [(set (reg:SI FPUL_REG) (fix:SI (match_dup 1)))
;; 	      (use (match_dup 2))])
;;    (set (match_dup 0) (reg:SI FPUL_REG))])

(define_insn "cmpgtdf_t"
  [(set (reg:SI T_REG)
	(gt:SI (match_operand:DF 0 "arith_reg_operand" "f")
	       (match_operand:DF 1 "arith_reg_operand" "f")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fcmp/gt	%1,%0"
  [(set_attr "type" "dfp_cmp")
   (set_attr "fp_mode" "double")])

(define_insn "cmpeqdf_t"
  [(set (reg:SI T_REG)
	(eq:SI (match_operand:DF 0 "arith_reg_operand" "f")
	       (match_operand:DF 1 "arith_reg_operand" "f")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fcmp/eq	%1,%0"
  [(set_attr "type" "dfp_cmp")
   (set_attr "fp_mode" "double")])

(define_insn "*ieee_ccmpeqdf_t"
  [(set (reg:SI T_REG)
	(ior:SI (reg:SI T_REG)
		(eq:SI (match_operand:DF 0 "arith_reg_operand" "f")
		       (match_operand:DF 1 "arith_reg_operand" "f"))))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_IEEE && TARGET_SH4"
  "* return output_ieee_ccmpeq (insn, operands);"
  [(set_attr "length" "4")
   (set_attr "fp_mode" "double")])
   
(define_expand "cmpdf"
  [(set (reg:SI T_REG)
	(compare (match_operand:DF 0 "arith_operand" "")
		 (match_operand:DF 1 "arith_operand" "")))]
  "TARGET_SH4"
  "
{
  sh_compare_op0 = operands[0];
  sh_compare_op1 = operands[1];
  DONE;
}")

(define_expand "negdf2"
  [(match_operand:DF 0 "arith_reg_operand" "")
   (match_operand:DF 1 "arith_reg_operand" "")]
  "TARGET_SH4"
  "{ expand_df_unop (&gen_negdf2_i, operands); DONE; }")

(define_insn "negdf2_i"
  [(set (match_operand:DF 0 "arith_reg_operand" "=f")
	(neg:DF (match_operand:DF 1 "arith_reg_operand" "0")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fneg	%0"
  [(set_attr "type" "fmove")
   (set_attr "fp_mode" "double")])

(define_expand "sqrtdf2"
  [(match_operand:DF 0 "arith_reg_operand" "")
   (match_operand:DF 1 "arith_reg_operand" "")]
  "TARGET_SH4"
  "{ expand_df_unop (&gen_sqrtdf2_i, operands); DONE; }")

(define_insn "sqrtdf2_i"
  [(set (match_operand:DF 0 "arith_reg_operand" "=f")
	(sqrt:DF (match_operand:DF 1 "arith_reg_operand" "0")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fsqrt	%0"
  [(set_attr "type" "dfdiv")
   (set_attr "fp_mode" "double")])

(define_expand "absdf2"
  [(match_operand:DF 0 "arith_reg_operand" "")
   (match_operand:DF 1 "arith_reg_operand" "")]
  "TARGET_SH4"
  "{ expand_df_unop (&gen_absdf2_i, operands); DONE; }")

(define_insn "absdf2_i"
  [(set (match_operand:DF 0 "arith_reg_operand" "=f")
	(abs:DF (match_operand:DF 1 "arith_reg_operand" "0")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fabs	%0"
  [(set_attr "type" "fmove")
   (set_attr "fp_mode" "double")])

(define_expand "extendsfdf2"
  [(match_operand:DF 0 "fp_arith_reg_operand" "")
   (match_operand:SF 1 "fpul_operand" "")]
  "TARGET_SH4"
  "
{
  emit_df_insn (gen_extendsfdf2_i4 (operands[0], operands[1], get_fpscr_rtx ()));
  DONE;
}")

(define_insn "extendsfdf2_i4"
  [(set (match_operand:DF 0 "fp_arith_reg_operand" "=f")
	(float_extend:DF (match_operand:SF 1 "fpul_operand" "y")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fcnvsd  %1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "double")])

(define_expand "truncdfsf2"
  [(match_operand:SF 0 "fpul_operand" "")
   (match_operand:DF 1 "fp_arith_reg_operand" "")]
  "TARGET_SH4"
  "
{
  emit_df_insn (gen_truncdfsf2_i4 (operands[0], operands[1], get_fpscr_rtx ()));
  DONE;
}")

(define_insn "truncdfsf2_i4"
  [(set (match_operand:SF 0 "fpul_operand" "=y")
	(float_truncate:SF (match_operand:DF 1 "fp_arith_reg_operand" "f")))
   (use (match_operand:PSI 2 "fpscr_operand" "c"))]
  "TARGET_SH4"
  "fcnvds  %1,%0"
  [(set_attr "type" "fp")
   (set_attr "fp_mode" "double")])

;; Bit field extract patterns.  These give better code for packed bitfields,
;; because they allow auto-increment addresses to be generated.

(define_expand "insv"
  [(set (zero_extract:SI (match_operand:QI 0 "memory_operand" "")
			 (match_operand:SI 1 "immediate_operand" "")
			 (match_operand:SI 2 "immediate_operand" ""))
	(match_operand:SI 3 "general_operand" ""))]
  "! TARGET_LITTLE_ENDIAN"
  "
{
  rtx addr_target, orig_address, shift_reg;
  HOST_WIDE_INT size;

  /* ??? expmed doesn't care for non-register predicates.  */
  if (! memory_operand (operands[0], VOIDmode)
      || ! immediate_operand (operands[1], VOIDmode)
      || ! immediate_operand (operands[2], VOIDmode)
      || ! general_operand (operands[3], VOIDmode))
    FAIL;
  /* If this isn't a 16 / 24 / 32 bit field, or if
     it doesn't start on a byte boundary, then fail.  */
  size = INTVAL (operands[1]);
  if (size < 16 || size > 32 || size % 8 != 0
      || (INTVAL (operands[2]) % 8) != 0)
    FAIL;

  size /= 8;
  orig_address = XEXP (operands[0], 0);
  shift_reg = gen_reg_rtx (SImode);
  emit_insn (gen_movsi (shift_reg, operands[3]));
  addr_target = copy_addr_to_reg (plus_constant (orig_address, size - 1));

  operands[0] = replace_equiv_address (operands[0], addr_target);
  emit_insn (gen_movqi (operands[0], gen_rtx_SUBREG (QImode, shift_reg, 0)));

  while (size -= 1)
    {
      emit_insn (gen_lshrsi3_k (shift_reg, shift_reg, GEN_INT (8)));
      emit_insn (gen_addsi3 (addr_target, addr_target, GEN_INT (-1)));
      emit_insn (gen_movqi (operands[0],
			    gen_rtx_SUBREG (QImode, shift_reg, 0)));
    }

  DONE;
}")

;; -------------------------------------------------------------------------
;; Peepholes
;; -------------------------------------------------------------------------

;; This matches cases where a stack pointer increment at the start of the
;; epilogue combines with a stack slot read loading the return value.

(define_peephole
  [(set (match_operand:SI 0 "arith_reg_operand" "")
	(mem:SI (match_operand:SI 1 "arith_reg_operand" "")))
   (set (match_dup 1) (plus:SI (match_dup 1) (const_int 4)))]
  "REGNO (operands[1]) != REGNO (operands[0])"
  "mov.l	@%1+,%0")

;; See the comment on the dt combiner pattern above.

(define_peephole
  [(set (match_operand:SI 0 "arith_reg_operand" "=r")
	(plus:SI (match_dup 0)
		 (const_int -1)))
   (set (reg:SI T_REG)
	(eq:SI (match_dup 0)
	       (const_int 0)))]
  "TARGET_SH2"
  "dt	%0")

;; These convert sequences such as `mov #k,r0; add r15,r0; mov.l @r0,rn'
;; to `mov #k,r0; mov.l @(r0,r15),rn'.  These sequences are generated by
;; reload when the constant is too large for a reg+offset address.

;; ??? We would get much better code if this was done in reload.  This would
;; require modifying find_reloads_address to recognize that if the constant
;; is out-of-range for an immediate add, then we get better code by reloading
;; the constant into a register than by reloading the sum into a register,
;; since the former is one instruction shorter if the address does not need
;; to be offsettable.  Unfortunately this does not work, because there is
;; only one register, r0, that can be used as an index register.  This register
;; is also the function return value register.  So, if we try to force reload
;; to use double-reg addresses, then we end up with some instructions that
;; need to use r0 twice.  The only way to fix this is to change the calling
;; convention so that r0 is not used to return values.

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:SI (match_dup 0))
	(match_operand:SI 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.l	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:SI 2 "general_movdst_operand" "")
	(mem:SI (match_dup 0)))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.l	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:HI (match_dup 0))
	(match_operand:HI 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.w	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:HI 2 "general_movdst_operand" "")
	(mem:HI (match_dup 0)))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.w	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:QI (match_dup 0))
	(match_operand:QI 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.b	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:QI 2 "general_movdst_operand" "")
	(mem:QI (match_dup 0)))]
  "REGNO (operands[0]) == 0 && reg_unused_after (operands[0], insn)"
  "mov.b	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:SF (match_dup 0))
	(match_operand:SF 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG && REGNO (operands[2]) < 16)
       || (GET_CODE (operands[2]) == SUBREG
	   && REGNO (SUBREG_REG (operands[2])) < 16))
   && reg_unused_after (operands[0], insn)"
  "mov.l	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:SF 2 "general_movdst_operand" "")

	(mem:SF (match_dup 0)))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG && REGNO (operands[2]) < 16)
       || (GET_CODE (operands[2]) == SUBREG
	   && REGNO (SUBREG_REG (operands[2])) < 16))
   && reg_unused_after (operands[0], insn)"
  "mov.l	@(%0,%1),%2")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (mem:SF (match_dup 0))
	(match_operand:SF 2 "general_movsrc_operand" ""))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG
        && FP_OR_XD_REGISTER_P (REGNO (operands[2])))
       || (GET_CODE (operands[2]) == SUBREG
	   && FP_OR_XD_REGISTER_P (REGNO (SUBREG_REG (operands[2])))))
   && reg_unused_after (operands[0], insn)"
  "fmov{.s|}	%2,@(%0,%1)")

(define_peephole
  [(set (match_operand:SI 0 "register_operand" "=r")
	(plus:SI (match_dup 0) (match_operand:SI 1 "register_operand" "r")))
   (set (match_operand:SF 2 "general_movdst_operand" "")

	(mem:SF (match_dup 0)))]
  "REGNO (operands[0]) == 0
   && ((GET_CODE (operands[2]) == REG
	&& FP_OR_XD_REGISTER_P (REGNO (operands[2])))
       || (GET_CODE (operands[2]) == SUBREG
	   && FP_OR_XD_REGISTER_P (REGNO (SUBREG_REG (operands[2])))))
   && reg_unused_after (operands[0], insn)"
  "fmov{.s|}	@(%0,%1),%2")

;; Switch to a new stack with its address in sp_switch (a SYMBOL_REF).  */
(define_insn "sp_switch_1"
  [(const_int 1)]
  ""
  "*
{
  rtx xoperands[1];

  xoperands[0] = sp_switch;
  output_asm_insn (\"mov.l r0,@-r15\;mov.l %0,r0\", xoperands);
  output_asm_insn (\"mov.l @r0,r0\;mov.l r15,@-r0\", xoperands);
  return \"mov r0,r15\";
}"
  [(set_attr "length" "10")])

;; Switch back to the original stack for interrupt functions with the
;; sp_switch attribute.  */
(define_insn "sp_switch_2"
  [(const_int 2)]
  ""
  "mov.l @r15+,r15\;mov.l @r15+,r0"
  [(set_attr "length" "4")])
