;; Machine description for IBM RISC System 6000 (POWER) for GNU C compiler
;; Copyright (C) 1990, 91-97, 1998 Free Software Foundation, Inc.
;; Contributed by Richard Kenner (kenner@vlsi1.ultra.nyu.edu)

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;; Define an insn type attribute.  This is used in function unit delay
;; computations.
(define_attr "type" "integer,load,store,fpload,fpstore,imul,idiv,branch,compare,delayed_compare,fpcompare,mtjmpr,fp,dmul,sdiv,ddiv,ssqrt,dsqrt,jmpreg"
  (const_string "integer"))

;; Length (in bytes).
(define_attr "length" ""
  (if_then_else (eq_attr "type" "branch")
		(if_then_else (and (ge (minus (pc) (match_dup 0))
				       (const_int -32768))
				   (lt (minus (pc) (match_dup 0))
				       (const_int 32767)))
			      (const_int 8)
			      (const_int 12))
		(const_int 4)))

;; Processor type -- this attribute must exactly match the processor_type
;; enumeration in rs6000.h.

(define_attr "cpu" "rios1,rios2,mpccore,ppc403,ppc601,ppc603,ppc604,ppc604e,ppc620"
  (const (symbol_ref "rs6000_cpu_attr")))

; (define_function_unit NAME MULTIPLICITY SIMULTANEITY
;			TEST READY-DELAY ISSUE-DELAY [CONFLICT-LIST])

; Load/Store Unit -- pure PowerPC only
; (POWER and 601 use Integer Unit)
(define_function_unit "lsu" 1 0
  (and (eq_attr "type" "load")
       (eq_attr "cpu" "mpccore,ppc603,ppc604,ppc604e,ppc620"))
  2 1)

(define_function_unit "lsu" 1 0
  (and (eq_attr "type" "store,fpstore")
       (eq_attr "cpu" "mpccore,ppc603,ppc604,ppc604e,ppc620"))
  1 1)

(define_function_unit "lsu" 1 0
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "mpccore,ppc603"))
  2 1)

(define_function_unit "lsu" 1 0
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppc604,ppc604e,ppc620"))
  3 1)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "load")
       (eq_attr "cpu" "rios1,ppc403,ppc601"))
  2 1)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "store,fpstore")
       (eq_attr "cpu" "rios1,ppc403,ppc601"))
  1 1)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fpstore")
       (eq_attr "cpu" "rios1,ppc601"))
  0 1)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "rios1"))
  2 1)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "fpload")
       (eq_attr "cpu" "ppc601"))
  3 1)

(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "load,fpload")
       (eq_attr "cpu" "rios2"))
  2 1)

(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "store,fpstore")
       (eq_attr "cpu" "rios2"))
  1 1)

; Integer Unit (RIOS1, PPC601, PPC603)
(define_function_unit "iu" 1 0
  (and (eq_attr "type" "integer")
       (eq_attr "cpu" "rios1,mpccore,ppc403,ppc601,ppc603"))
  1 1)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppc403"))
  4 4)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "rios1,ppc601,ppc603"))
  5 5)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "rios1"))
  19 19)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc403"))
  33 33)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc601"))
  36 36)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc603"))
  37 36)

; RIOS2 has two integer units: a primary one which can perform all
; operations and a secondary one which is fed in lock step with the first
; and can perform "simple" integer operations.  
; To catch this we define a 'dummy' imuldiv-unit that is also needed
; for the complex insns. 
(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "integer")
       (eq_attr "cpu" "rios2"))
  1 1)

(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "rios2"))
  2 2)

(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "rios2"))
  13 13)

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "rios2"))
  2 2)

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "rios2"))
  13 13)

; MPCCORE has separate IMUL/IDIV unit for multicycle instructions
; Divide latency varies greatly from 2-11, use 6 as average
(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "mpccore"))
  2 1)

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "mpccore"))
  6 6)

; PPC604{,e} has two units that perform integer operations
; and one unit for divide/multiply operations (and move
; from/to spr).
(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "integer")
       (eq_attr "cpu" "ppc604,ppc604e,ppc620"))
  1 1)

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppc604,ppc620"))
  4 2)

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "imul")
       (eq_attr "cpu" "ppc604e"))
  2 1)

(define_function_unit "imuldiv" 1 0
  (and (eq_attr "type" "idiv")
       (eq_attr "cpu" "ppc604,ppc604e,ppc620"))
  20 19)

; compare is done on integer unit, but feeds insns which
; execute on the branch unit.
(define_function_unit "iu" 1 0   
  (and (eq_attr "type" "compare")
       (eq_attr "cpu" "rios1"))
  4 1)

(define_function_unit "iu" 1 0   
  (and (eq_attr "type" "delayed_compare")
       (eq_attr "cpu" "rios1"))
  5 1)

(define_function_unit "iu" 1 0
  (and (eq_attr "type" "compare,delayed_compare")
       (eq_attr "cpu" "mpccore,ppc403,ppc601,ppc603,ppc604,ppc604e,ppc620"))
  3 1)

(define_function_unit "iu2" 2 0   
  (and (eq_attr "type" "compare,delayed_compare")
       (eq_attr "cpu" "rios2"))
  3 1)

(define_function_unit "iu2" 2 0
  (and (eq_attr "type" "compare,delayed_compare")
       (eq_attr "cpu" "ppc604,ppc604e,ppc620"))
  1 1)

; fp compare uses fp unit
(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "rios1"))
  9 1)

; rios1 and rios2 have different fpcompare delays
(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "rios2"))
  5 1)

; on ppc601 and ppc603, fpcompare takes also 2 cycles from
; the integer unit
; here we do not define delays, just occupy the unit. The dependencies
; will be assigned by the fpcompare definition in the fpu.
(define_function_unit "iu" 1 0
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc601,ppc603"))
  0 2)

; fp compare uses fp unit
(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "ppc601,ppc603,ppc604,ppc604e,ppc620"))
  5 1)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fpcompare")
       (eq_attr "cpu" "mpccore"))
  1 1)

(define_function_unit "bpu" 1 0
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "rios1,rios2"))
  5 1)

(define_function_unit "bpu" 1 0
  (and (eq_attr "type" "mtjmpr")
       (eq_attr "cpu" "mpccore,ppc403,ppc601,ppc603,ppc604,ppc604e,ppc620"))
  4 1)

; all jumps/branches are executing on the bpu, in 1 cycle, for all machines.
(define_function_unit "bpu" 1 0
  (eq_attr "type" "jmpreg")
  1 1)

(define_function_unit "bpu" 1 0
  (eq_attr "type" "branch")
  1 1)

; Floating Point Unit
(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fp,dmul")
       (eq_attr "cpu" "rios1"))
  2 1)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "mpccore"))
  4 4)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "ppc601"))
  4 1)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "ppc603,ppc604,ppc604e,ppc620"))
  3 1)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "mpccore"))
  5 5)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc601"))
  5 2)

; is this true?
(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc603"))
  4 2)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "ppc604,ppc604e,ppc620"))
  3 1)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "sdiv,ddiv")
       (eq_attr "cpu" "rios1"))
  19 19)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc601"))
  17 17)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "mpccore"))
  10 10)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "sdiv")
       (eq_attr "cpu" "ppc603,ppc604,ppc604e,ppc620"))
  18 18)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "mpccore"))
  17 17)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc601,ppc604,ppc604e,ppc620"))
  31 31)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "ddiv")
       (eq_attr "cpu" "ppc603"))
  33 33)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "ssqrt")
       (eq_attr "cpu" "ppc620"))
  31 31)

(define_function_unit "fpu" 1 0
  (and (eq_attr "type" "dsqrt")
       (eq_attr "cpu" "ppc620"))
  31 31)

; RIOS2 has two symmetric FPUs.
(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "fp")
       (eq_attr "cpu" "rios2"))
  2 1)

(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "dmul")
       (eq_attr "cpu" "rios2"))
  2 1)

(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "sdiv,ddiv")
       (eq_attr "cpu" "rios2"))
  17 17)

(define_function_unit "fpu2" 2 0
  (and (eq_attr "type" "ssqrt,dsqrt")
       (eq_attr "cpu" "rios2"))
  26 26)


;; Start with fixed-point load and store insns.  Here we put only the more
;; complex forms.  Basic data transfer is done later.

(define_expand "zero_extendqidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lbz%U1%X1 %0,%1
   rldicl %0,%1,0,56"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "rldicl. %2,%1,0,56"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "rldicl. %0,%1,0,56"
  [(set_attr "type" "compare")])

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "extsb. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "extsb. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "zero_extendhidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lhz%U1%X1 %0,%1
   rldicl %0,%1,0,48"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "rldicl. %2,%1,0,48"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "rldicl. %0,%1,0,48"
  [(set_attr "type" "compare")])

(define_expand "extendhidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lha%U1%X1 %0,%1
   extsh %0,%1"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "extsh. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "extsh. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "zero_extendsidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:SI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lwz%U1%X1 %0,%1
   rldicl %0,%1,0,32"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "rldicl. %2,%1,0,32"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "rldicl. %0,%1,0,32"
  [(set_attr "type" "compare")])

(define_expand "extendsidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_operand:SI 1 "lwa_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lwa%U1%X1 %0,%1
   extsw %0,%1"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "extsw. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "extsw. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "zero_extendqisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "{andil.|andi.} %2,%1,0xff"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "{andil.|andi.} %0,%1,0xff"
  [(set_attr "type" "compare")])

(define_expand "extendqisi2"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:QI 1 "gpc_reg_operand" ""))]
  ""
  "
{
  if (TARGET_POWERPC)
    emit_insn (gen_extendqisi2_ppc (operands[0], operands[1]));
  else if (TARGET_POWER)
    emit_insn (gen_extendqisi2_power (operands[0], operands[1]));
  else
    emit_insn (gen_extendqisi2_no_power (operands[0], operands[1]));
  DONE;
}")

(define_insn "extendqisi2_ppc"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  "TARGET_POWERPC"
  "extsb. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_dup 1)))]
  "TARGET_POWERPC"
  "extsb. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "extendqisi2_power"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  "TARGET_POWER"
  "
{ operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "extendqisi2_no_power"
  [(set (match_dup 2)
	(ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
		   (const_int 24)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 2)
		     (const_int 24)))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "
{ operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "zero_extendqihi2"
  [(set (match_operand:HI 0 "gpc_reg_operand" "")
	(zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:HI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:HI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 "=r"))]
  ""
  "{andil.|andi.} %2,%1,0xff"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "=r")
	(zero_extend:HI (match_dup 1)))]
  ""
  "{andil.|andi.} %0,%1,0xff"
  [(set_attr "type" "compare")])

(define_expand "extendqihi2"
  [(use (match_operand:HI 0 "gpc_reg_operand" ""))
   (use (match_operand:QI 1 "gpc_reg_operand" ""))]
  ""
  "
{
  if (TARGET_POWERPC)
    emit_insn (gen_extendqihi2_ppc (operands[0], operands[1]));
  else if (TARGET_POWER)
    emit_insn (gen_extendqihi2_power (operands[0], operands[1]));
  else
    emit_insn (gen_extendqihi2_no_power (operands[0], operands[1]));
  DONE;
}")

(define_insn "extendqihi2_ppc"
  [(set (match_operand:HI 0 "gpc_reg_operand" "=r")
	(sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 "=r"))]
  "TARGET_POWERPC"
  "extsb. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "=r")
	(sign_extend:HI (match_dup 1)))]
  "TARGET_POWERPC"
  "extsb. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "extendqihi2_power"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:HI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  "TARGET_POWER"
  "
{ operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "extendqihi2_no_power"
  [(set (match_dup 2)
	(ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
		   (const_int 24)))
   (set (match_operand:HI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 2)
		     (const_int 24)))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "
{ operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lhz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xffff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "{andil.|andi.} %2,%1,0xffff"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "{andil.|andi.} %0,%1,0xffff"
  [(set_attr "type" "compare")])

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lha%U1%X1 %0,%1
   {exts|extsh} %0,%1"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "{exts.|extsh.} %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_dup 1)))]
  ""
  "{exts.|extsh.} %0,%1"
  [(set_attr "type" "compare")])

;; Fixed-point arithmetic insns.

;; Discourage ai/addic because of carry but provide it in an alternative
;; allowing register zero as source.
(define_expand "addsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT && !add_operand (operands[2], SImode))
    {
      rtx tmp = ((reload_in_progress || reload_completed
		  || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (SImode));

      HOST_WIDE_INT low = INTVAL (operands[2]) & 0xffff;
      HOST_WIDE_INT high = INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff);

      if (low & 0x8000)
        high += 0x10000, low |= ((HOST_WIDE_INT) -1) << 16;

      emit_insn (gen_addsi3 (tmp, operands[1], GEN_INT (high)));
      emit_insn (gen_addsi3 (operands[0], tmp, GEN_INT (low)));
      DONE;
    }
}")

(define_insn "*addsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,?r,r")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,b,r,b")
		 (match_operand:SI 2 "add_operand" "r,I,I,J")))]
  ""
  "@
   {cax|add} %0,%1,%2
   {cal %0,%2(%1)|addi %0,%1,%2}
   {ai|addic} %0,%1,%2
   {cau|addis} %0,%1,%v2"
  [(set_attr "length" "4,4,4,4")])

(define_insn "*addsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "reg_or_short_operand" "r,I"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  ""
  "@
   {cax.|add.} %3,%1,%2
   {ai.|addic.} %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*addsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "reg_or_short_operand" "r,I"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {cax.|add.} %0,%1,%2
   {ai.|addic.} %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an add that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.  Note that the low-order
;; add should be last in case the result gets used in an address.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "non_add_cint_operand" "")))]
  ""
  [(set (match_dup 0) (plus:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (plus:SI (match_dup 0) (match_dup 4)))]
"
{
  HOST_WIDE_INT low = INTVAL (operands[2]) & 0xffff;
  HOST_WIDE_INT high = INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff);

  if (low & 0x8000)
    high += 0x10000, low |= ((HOST_WIDE_INT) -1) << 16;

  operands[3] = GEN_INT (high);
  operands[4] = GEN_INT (low);
}")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "nor %0,%1,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "nor. %2,%1,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (match_dup 1)))]
  ""
  "nor. %0,%1,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "rI")
		  (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "! TARGET_POWERPC"
  "{sf%I1|subf%I1c} %0,%2,%1")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "r,I")
		  (match_operand:SI 2 "gpc_reg_operand" "r,r")))]
  "TARGET_POWERPC"
  "@
   subf %0,%2,%1
   subfic %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWERPC"
  "{sf.|subfc.} %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWERPC"
  "subf. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWERPC"
  "{sf.|subfc.} %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC"
  "subf. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_expand "subsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "")
		  (match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_addsi3 (operands[0], operands[1],
			     negate_rtx (SImode, operands[2])));
      DONE;
    }
}")

;; For SMIN, SMAX, UMIN, and UMAX, we use DEFINE_EXPAND's that involve a doz[i]
;; instruction and some auxiliary computations.  Then we just have a single
;; DEFINE_INSN for doz[i] and the define_splits to make them if made by
;; combine.

(define_expand "sminsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  "TARGET_POWER"
  "
{ operands[3] = gen_reg_rtx (SImode); }")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smin:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "TARGET_POWER"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (minus:SI (match_dup 2) (match_dup 3)))]
  "")

(define_expand "smaxsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  "TARGET_POWER"
  "
{ operands[3] = gen_reg_rtx (SImode); }")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smax:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "TARGET_POWER"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (plus:SI (match_dup 3) (match_dup 1)))]
  "")

(define_expand "uminsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  "TARGET_POWER"
  "
{
  operands[3] = gen_reg_rtx (SImode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = GEN_INT (-2147483647 - 1);
}")

(define_expand "umaxsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  "TARGET_POWER"
  "
{
  operands[3] = gen_reg_rtx (SImode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = GEN_INT (-2147483647 - 1);
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "reg_or_short_operand" "rI"))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWER"
  "doz%I2. %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI (gt (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  "TARGET_POWER"
  "doz%I2. %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

;; We don't need abs with condition code because such comparisons should
;; never be done.
(define_expand "abssi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "")))]
  ""
  "
{
  if (!TARGET_POWER)
    {
      emit_insn (gen_abssi2_nopower (operands[0], operands[1]));
      DONE;
    }
}")

(define_insn "abssi2_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWER"
  "abs %0,%1")

(define_insn "abssi2_nopower"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER"
  "*
{
  return (TARGET_POWERPC)
    ? \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;subf %0,%2,%0\"
    : \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;{sf|subfc} %0,%2,%0\";
}"
  [(set_attr "length" "12")])

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER && reload_completed"
  [(set (match_dup 2) (ashiftrt:SI (match_dup 1) (const_int 31)))
   (set (match_dup 0) (xor:SI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:SI (match_dup 0) (match_dup 2)))]
  "")

(define_insn "*nabs_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r"))))]
  "TARGET_POWER"
  "nabs %0,%1")

(define_insn "*nabs_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER"
  "*
{
  return (TARGET_POWERPC)
    ? \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;subf %0,%0,%2\"
    : \"{srai|srawi} %2,%1,31\;xor %0,%2,%1\;{sf|subfc} %0,%0,%2\";
}"
  [(set_attr "length" "12")])

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "!TARGET_POWER && reload_completed"
  [(set (match_dup 2) (ashiftrt:SI (match_dup 1) (const_int 31)))
   (set (match_dup 0) (xor:SI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:SI (match_dup 2) (match_dup 0)))]
  "")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "neg %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "neg. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (match_dup 1)))]
  ""
  "neg. %0,%1"
  [(set_attr "type" "compare")])

(define_insn "ffssi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(ffs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "neg %0,%1\;and %0,%0,%1\;{cntlz|cntlzw} %0,%0\;{sfi|subfic} %0,%0,32"
  [(set_attr "length" "16")])

(define_expand "mulsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_short_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_mulsi3_mq (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_mulsi3_no_mq (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "mulsi3_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
   (clobber (match_scratch:SI 3 "=q,q"))]
  "TARGET_POWER"
  "@
   {muls|mullw} %0,%1,%2
   {muli|mulli} %0,%1,%2"
   [(set_attr "type" "imul")])

(define_insn "mulsi3_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "r,I")))]
  "! TARGET_POWER"
  "@
   {muls|mullw} %0,%1,%2
   {muli|mulli} %0,%1,%2"
   [(set_attr "type" "imul")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))
   (clobber (match_scratch:SI 4 "=q"))]
  "TARGET_POWER"
  "{muls.|mullw.} %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWER"
  "{muls.|mullw.} %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(mult:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q"))]
  "TARGET_POWER"
  "{muls.|mullw.} %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(mult:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "{muls.|mullw.} %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

;; Operand 1 is divided by operand 2; quotient goes to operand
;; 0 and remainder to operand 3.
;; ??? At some point, see what, if anything, we can do about if (x % y == 0).

(define_expand "divmodsi4"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (div:SI (match_operand:SI 1 "gpc_reg_operand" "")
			   (match_operand:SI 2 "gpc_reg_operand" "")))
	      (set (match_operand:SI 3 "gpc_reg_operand" "")
		   (mod:SI (match_dup 1) (match_dup 2)))])]
  "TARGET_POWER || (! TARGET_POWER && ! TARGET_POWERPC)"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_divss_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      emit_move_insn (operands[3], gen_rtx_REG (SImode, 4));
      DONE;
    }
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "gpc_reg_operand" "r")))
   (set (match_operand:SI 3 "gpc_reg_operand" "=q")
	(mod:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "divs %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_expand "udivsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "")
                 (match_operand:SI 2 "gpc_reg_operand" "")))]
  "TARGET_POWERPC || (! TARGET_POWER && ! TARGET_POWERPC)"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_quous_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_udivsi3_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "udivsi3_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "divwu %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "*udivsi3_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                 (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "divwu %0,%1,%2"
  [(set_attr "type" "idiv")])

;; For powers of two we can do srai/aze for divide and then adjust for
;; modulus.  If it isn't a power of two, FAIL on POWER so divmodsi4 will be
;; used; for PowerPC, force operands into register and do a normal divide;
;; for AIX common-mode, use quoss call on register operands.
(define_expand "divsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && exact_log2 (INTVAL (operands[2])) >= 0)
    ;
  else if (TARGET_POWERPC)
    {
      operands[2] = force_reg (SImode, operands[2]);
      if (TARGET_POWER)
	{
	  emit_insn (gen_divsi3_mq (operands[0], operands[1], operands[2]));
	  DONE;
	}
    }
  else if (TARGET_POWER)
    FAIL;
  else
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_quoss_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      DONE;
    }
}")

(define_insn "divsi3_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "divw %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "*divsi3_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "divw %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_expand "modsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  int i = exact_log2 (INTVAL (operands[2]));
  rtx temp1;
  rtx temp2;

  if (GET_CODE (operands[2]) != CONST_INT || i < 0)
    FAIL;

  temp1 = gen_reg_rtx (SImode);
  temp2 = gen_reg_rtx (SImode);

  emit_insn (gen_divsi3 (temp1, operands[1], operands[2]));
  emit_insn (gen_ashlsi3 (temp2, temp1, GEN_INT (i)));
  emit_insn (gen_subsi3 (operands[0], operands[1], temp2));
  DONE;
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "const_int_operand" "N")))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "{srai|srawi} %0,%1,%p2\;{aze|addze} %0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "N"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "{srai|srawi} %3,%1,%p2\;{aze.|addze.} %3,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "N"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_dup 1) (match_dup 2)))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "{srai|srawi} %0,%1,%p2\;{aze.|addze.} %0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(udiv:SI
	 (plus:DI (ashift:DI
		   (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 32))
		  (zero_extend:DI (match_operand:SI 4 "register_operand" "2")))
	 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (set (match_operand:SI 2 "register_operand" "=*q")
	(umod:SI
	 (plus:DI (ashift:DI
		   (zero_extend:DI (match_dup 1)) (const_int 32))
		  (zero_extend:DI (match_dup 4)))
	 (match_dup 3)))]
  "TARGET_POWER"
  "div %0,%1,%3"
  [(set_attr "type" "idiv")])

;; To do unsigned divide we handle the cases of the divisor looking like a
;; negative number.  If it is a constant that is less than 2**31, we don't
;; have to worry about the branches.  So make a few subroutines here.
;;
;; First comes the normal case.
(define_expand "udivmodsi4_normal"
  [(set (match_dup 4) (const_int 0))
   (parallel [(set (match_operand:SI 0 "" "")
		   (udiv:SI (plus:DI (ashift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_operand:SI 1 "" "")))
			    (match_operand:SI 2 "" "")))
	      (set (match_operand:SI 3 "" "")
		   (umod:SI (plus:DI (ashift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_dup 1)))
			    (match_dup 2)))])]
  "TARGET_POWER"
  "
{ operands[4] = gen_reg_rtx (SImode); }")

;; This handles the branches.
(define_expand "udivmodsi4_tests"
  [(set (match_operand:SI 0 "" "") (const_int 0))
   (set (match_operand:SI 3 "" "") (match_operand:SI 1 "" ""))
   (set (match_dup 5) (compare:CCUNS (match_dup 1) (match_operand:SI 2 "" "")))
   (set (pc) (if_then_else (ltu (match_dup 5) (const_int 0))
			   (label_ref (match_operand:SI 4 "" "")) (pc)))
   (set (match_dup 0) (const_int 1))
   (set (match_dup 3) (minus:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 6) (compare:CC (match_dup 2) (const_int 0)))
   (set (pc) (if_then_else (lt (match_dup 6) (const_int 0))
			   (label_ref (match_dup 4)) (pc)))]
  "TARGET_POWER"
  "
{ operands[5] = gen_reg_rtx (CCUNSmode);
  operands[6] = gen_reg_rtx (CCmode);
}")

(define_expand "udivmodsi4"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "reg_or_cint_operand" "")))
	      (set (match_operand:SI 3 "gpc_reg_operand" "")
		   (umod:SI (match_dup 1) (match_dup 2)))])]
  ""
  "
{
  rtx label = 0;

  if (! TARGET_POWER)
    {
      if (! TARGET_POWERPC)
        {
	  emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
	  emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
	  emit_insn (gen_divus_call ());
	  emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
	  emit_move_insn (operands[3], gen_rtx_REG (SImode, 4));
	  DONE;
        }
      else
        FAIL;
    }

  if (GET_CODE (operands[2]) != CONST_INT || INTVAL (operands[2]) < 0)
    {
      operands[2] = force_reg (SImode, operands[2]);
      label = gen_label_rtx ();
      emit (gen_udivmodsi4_tests (operands[0], operands[1], operands[2],
				  operands[3], label));
    }
  else
    operands[2] = force_reg (SImode, operands[2]);

  emit (gen_udivmodsi4_normal (operands[0], operands[1], operands[2],
			       operands[3]));
  if (label)
    emit_label (label);

  DONE;
}")

;; AIX architecture-independent common-mode multiply (DImode),
;; divide/modulus, and quotient subroutine calls.  Input operands in R3 and
;; R4; results in R3 and sometimes R4; link register always clobbered by bla
;; instruction; R0 sometimes clobbered; also, MQ sometimes clobbered but
;; assumed unused if generating common-mode, so ignore.
(define_insn "mulh_call"
  [(set (reg:SI 3)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI (reg:SI 3))
			       (sign_extend:DI (reg:SI 4)))
		      (const_int 32))))
   (clobber (match_scratch:SI 0 "=l"))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __mulh"
  [(set_attr "type" "imul")])

(define_insn "mull_call"
  [(set (reg:DI 3)
	(mult:DI (sign_extend:DI (reg:SI 3))
		 (sign_extend:DI (reg:SI 4))))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __mull"
  [(set_attr "type" "imul")])

(define_insn "divss_call"
  [(set (reg:SI 3)
	(div:SI (reg:SI 3) (reg:SI 4)))
   (set (reg:SI 4)
	(mod:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __divss"
  [(set_attr "type" "idiv")])

(define_insn "divus_call"
  [(set (reg:SI 3)
	(udiv:SI (reg:SI 3) (reg:SI 4)))
   (set (reg:SI 4)
	(umod:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))
   (clobber (match_scratch:CC 1 "=x"))
   (clobber (reg:CC 69))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __divus"
  [(set_attr "type" "idiv")])

(define_insn "quoss_call"
  [(set (reg:SI 3)
	(div:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __quoss"
  [(set_attr "type" "idiv")])

(define_insn "quous_call"
  [(set (reg:SI 3)
	(udiv:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))
   (clobber (match_scratch:CC 1 "=x"))
   (clobber (reg:CC 69))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __quous"
  [(set_attr "type" "idiv")])

;; Logical instructions
(define_insn "andsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
		(match_operand:SI 2 "and_operand" "?r,L,K,J")))
   (clobber (match_scratch:CC 3 "=X,X,x,x"))]
  ""
  "@
   and %0,%1,%2
   {rlinm|rlwinm} %0,%1,0,%m2,%M2
   {andil.|andi.} %0,%1,%b2
   {andiu.|andis.} %0,%1,%u2"
  [(set_attr "length" "4,4,4,4")])

(define_insn "*andsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,J,L"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r"))]
  ""
  "@
   and. %3,%1,%2
   {andil.|andi.} %3,%1,%b2
   {andiu.|andis.} %3,%1,%u2
   {rlinm.|rlwinm.} %3,%1,0,%m2,%M2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")])

(define_insn "*andsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,J,L"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   and. %0,%1,%2
   {andil.|andi.} %0,%1,%b2
   {andiu.|andis.} %0,%1,%u2
   {rlinm.|rlwinm.} %0,%1,0,%m2,%M2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")])

(define_expand "iorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && !logical_operand (operands[2], SImode))
    {
      HOST_WIDE_INT value = INTVAL (operands[2]);
      rtx tmp = ((reload_in_progress || reload_completed
		  || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (SImode));

      emit_insn (gen_iorsi3 (tmp, operands[1],
			     GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
      emit_insn (gen_iorsi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_insn "*iorsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:SI 2 "logical_operand" "r,K,J")))]
  ""
  "@
   or %0,%1,%2
   {oril|ori} %0,%1,%b2
   {oriu|oris} %0,%1,%u2"
  [(set_attr "length" "4,4,4")])

(define_insn "*iorsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "or. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*iorsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (match_dup 1) (match_dup 2)))]
  ""
  "or. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an IOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "non_logical_cint_operand" "")))]
  ""
  [(set (match_dup 0) (ior:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (ior:SI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = GEN_INT (INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff));
  operands[4] = GEN_INT (INTVAL (operands[2]) & 0xffff);
}")

(define_expand "xorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && !logical_operand (operands[2], SImode))
    {
      HOST_WIDE_INT value = INTVAL (operands[2]);
      rtx tmp = ((reload_in_progress || reload_completed
		  || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (SImode));

      emit_insn (gen_xorsi3 (tmp, operands[1],
			     GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
      emit_insn (gen_xorsi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_insn "*xorsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:SI 2 "logical_operand" "r,K,J")))]
  ""
  "@
   xor %0,%1,%2
   {xoril|xori} %0,%1,%b2
   {xoriu|xoris} %0,%1,%u2"
  [(set_attr "length" "4,4,4")])

(define_insn "*xorsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "xor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*xorsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(xor:SI (match_dup 1) (match_dup 2)))]
  ""
  "xor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an XOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
        (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
                (match_operand:SI 2 "non_logical_cint_operand" "")))]
  ""
  [(set (match_dup 0) (xor:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (xor:SI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = GEN_INT (INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff));
  operands[4] = GEN_INT (INTVAL (operands[2]) & 0xffff);
}")

(define_insn "*eqvsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			(match_operand:SI 2 "gpc_reg_operand" "r"))))]
   ""
   "eqv %0,%1,%2")

(define_insn "*eqvsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
				    (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
   ""
   "eqv. %3,%1,%2"
   [(set_attr "type" "compare")])

(define_insn "*eqvsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
				    (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (xor:SI (match_dup 1) (match_dup 2))))]
   ""
   "eqv. %0,%1,%2"
   [(set_attr "type" "compare")])

(define_insn "*andcsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(match_operand:SI 2 "gpc_reg_operand" "r")))]
  ""
  "andc %0,%2,%1")

(define_insn "*andcsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "andc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*andcsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_dup 1)) (match_dup 2)))]
  ""
  "andc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*iorcsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(match_operand:SI 2 "gpc_reg_operand" "r")))]
  ""
  "orc %0,%2,%1")

(define_insn "*iorcsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "orc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*iorcsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_dup 1)) (match_dup 2)))]
  ""
  "orc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*nandsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		(not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  ""
  "nand %0,%1,%2")

(define_insn "*nandsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "nand. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*nandsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_dup 1)) (not:SI (match_dup 2))))]
  ""
  "nand. %0,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*norsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		(not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  ""
  "nor %0,%1,%2")

(define_insn "*norsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "nor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*norsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "%r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_dup 1)) (not:SI (match_dup 2))))]
  ""
  "nor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; maskir insn.  We need four forms because things might be in arbitrary
;; orders.  Don't define forms that only set CR fields because these
;; would modify an input register.

(define_insn "*maskir_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_dup 2)
			(match_operand:SI 3 "gpc_reg_operand" "r"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_dup 2))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			(match_operand:SI 3 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal4"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_operand:SI 2 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal5"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0"))
		 (and:SI (match_dup 2)
			 (match_operand:SI 3 "gpc_reg_operand" "r")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 2) (match_dup 3))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn "*maskir_internal6"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0"))
		 (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_dup 2)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 3) (match_dup 2))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn "*maskir_internal7"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			 (match_operand:SI 3 "gpc_reg_operand" "r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_dup 2) (match_dup 3))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn "*maskir_internal8"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_dup 3) (match_dup 2))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER"
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

;; Rotate and shift insns, in all their variants.  These support shifts,
;; field inserts and extracts, and various combinations thereof.
(define_expand "insv"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(match_operand:SI 3 "gpc_reg_operand" "r"))]
  ""
  "
{
  /* Do not handle 16/8 bit structures that fit in HI/QI modes directly, since
     the (SUBREG:SI (REG:HI xxx)) that is otherwise generated can confuse the
     compiler if the address of the structure is taken later.  */
  if (GET_CODE (operands[0]) == SUBREG
      && (GET_MODE_SIZE (GET_MODE (SUBREG_REG (operands[0]))) < UNITS_PER_WORD))
    FAIL;
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(match_operand:SI 3 "gpc_reg_operand" "r"))]
  ""
  "*
{
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (32 - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(ashift:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		   (match_operand:SI 4 "const_int_operand" "i")))]
  "(32 - (INTVAL (operands[4]) & 31)) >= INTVAL (operands[1])"
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (shift - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(ashiftrt:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		     (match_operand:SI 4 "const_int_operand" "i")))]
  "(32 - (INTVAL (operands[4]) & 31)) >= INTVAL (operands[1])"
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (32 - shift - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(lshiftrt:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		     (match_operand:SI 4 "const_int_operand" "i")))]
  "(32 - (INTVAL (operands[4]) & 31)) >= INTVAL (operands[1])"
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (32 - shift - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(zero_extract:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_operand:SI 4 "const_int_operand" "i")
			 (match_operand:SI 5 "const_int_operand" "i")))]
  "INTVAL (operands[4]) >= INTVAL (operands[1])"
  "*
{
  int extract_start = INTVAL (operands[5]) & 31;
  int extract_size = INTVAL (operands[4]) & 31;
  int insert_start = INTVAL (operands[2]) & 31;
  int insert_size = INTVAL (operands[1]) & 31;

/* Align extract field with insert field */
  operands[5] = GEN_INT (extract_start + extract_size - insert_start - insert_size);
  operands[1] = GEN_INT (insert_start + insert_size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h5,%h2,%h1\";
}")

(define_insn ""
  [(set (zero_extract:DI (match_operand:DI 0 "gpc_reg_operand" "+r")
			 (match_operand:DI 1 "const_int_operand" "i")
			 (match_operand:DI 2 "const_int_operand" "i"))
	(match_operand:DI 3 "gpc_reg_operand" "r"))]
  "TARGET_POWERPC64"
  "*
{
  int start = INTVAL (operands[2]) & 63;
  int size = INTVAL (operands[1]) & 63;

  operands[2] = GEN_INT (64 - start - size);
  return \"rldimi %0,%3,%H2,%H1\";
}")

(define_expand "extzv"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i")))]
  ""
  "
{
  /* Do not handle 16/8 bit structures that fit in HI/QI modes directly, since
     the (SUBREG:SI (REG:HI xxx)) that is otherwise generated can confuse the
     compiler if the address of the structure is taken later.  */
  if (GET_CODE (operands[0]) == SUBREG
      && (GET_MODE_SIZE (GET_MODE (SUBREG_REG (operands[0]))) < UNITS_PER_WORD))
    FAIL;
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i")))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  return \"{rlinm|rlwinm} %0,%1,%3,%s2,31\";
}")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  /* If the bitfield being tested fits in the upper or lower half of a
     word, it is possible to use andiu. or andil. to test it.  This is
     useful because the condition register set-use delay is smaller for
     andi[ul]. than for rlinm.  This doesn't work when the starting bit
     position is 0 because the LT and GT bits may be set wrong.  */

  if ((start > 0 && start + size <= 16) || start >= 16)
    {
      operands[3] = GEN_INT (((1 << (16 - (start & 15)))
			      - (1 << (16 - (start & 15) - size))));
      if (start < 16)
	return \"{andiu.|andis.} %4,%1,%3\";
      else
	return \"{andil.|andi.} %4,%1,%3\";
    }

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  return \"{rlinm.|rlwinm.} %4,%1,%3,%s2,31\";
}"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_dup 1) (match_dup 2) (match_dup 3)))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  if (start >= 16 && start + size == 32)
    {
      operands[3] = GEN_INT ((1 << (32 - start)) - 1);
      return \"{andil.|andi.} %0,%1,%3\";
    }

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  return \"{rlinm.|rlwinm.} %0,%1,%3,%s2,31\";
}"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extract:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			 (match_operand:DI 2 "const_int_operand" "i")
			 (match_operand:DI 3 "const_int_operand" "i")))]
  "TARGET_POWERPC64"
  "*
{
  int start = INTVAL (operands[3]) & 63;
  int size = INTVAL (operands[2]) & 63;

  if (start + size >= 64)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  operands[2] = GEN_INT (64 - size);
  return \"rldicl %0,%1,%3,%2\";
}")

(define_insn ""
  [(set (match_operand:CC 0 "gpc_reg_operand" "=x")
	(compare:CC (zero_extract:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			 (match_operand:DI 2 "const_int_operand" "i")
			 (match_operand:DI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (clobber (match_scratch:DI 4 "=r"))]
  "TARGET_POWERPC64"
  "*
{
  int start = INTVAL (operands[3]) & 63;
  int size = INTVAL (operands[2]) & 63;

  if (start + size >= 64)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  operands[2] = GEN_INT (64 - size);
  return \"rldicl. %4,%1,%3,%2\";
}")

(define_insn ""
  [(set (match_operand:CC 4 "gpc_reg_operand" "=x")
	(compare:CC (zero_extract:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			 (match_operand:DI 2 "const_int_operand" "i")
			 (match_operand:DI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extract:DI (match_dup 1) (match_dup 2) (match_dup 3)))]
  "TARGET_POWERPC64"
  "*
{
  int start = INTVAL (operands[3]) & 63;
  int size = INTVAL (operands[2]) & 63;

  if (start + size >= 64)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  operands[2] = GEN_INT (64 - size);
  return \"rldicl. %0,%1,%3,%2\";
}")

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xffffffff")

(define_insn "*rotlsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xffffffff"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotlsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(rotate:SI (match_dup 1) (match_dup 2)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xffffffff"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotlsi3_internal4"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		(match_operand:SI 3 "mask_operand" "L")))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,%m3,%M3")

(define_insn "*rotlsi3_internal5"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:SI 3 "mask_operand" "L"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %4,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotlsi3_internal6"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:SI 3 "mask_operand" "L"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (rotate:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotlsi3_internal7"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xff")

(define_insn "*rotlsi3_internal8"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotlsi3_internal9"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:QI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotlsi3_internal10"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xffff")

(define_insn "*rotlsi3_internal11"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xffff"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotlsi3_internal12"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:HI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "{rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xffff"
  [(set_attr "type" "delayed_compare")])

;; Note that we use "sle." instead of "sl." so that we can set
;; SHIFT_COUNT_TRUNCATED.

(define_expand "ashlsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_ashlsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_ashlsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "ashlsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  "TARGET_POWER"
  "@
   sle %0,%1,%2
   {sli|slwi} %0,%1,%h2"
  [(set_attr "length" "8")])

(define_insn "ashlsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "! TARGET_POWER"
  "{sl|slw}%I2 %0,%1,%h2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   sle. %3,%1,%2
   {sli.|slwi.} %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWER"
  "{sl|slw}%I2. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   sle. %0,%1,%2
   {sli.|slwi.} %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "{sl|slw}%I2. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "L")))]
  "includes_lshift_p (operands[2], operands[3])"
  "{rlinm|rlwinm} %0,%1,%h2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  "includes_lshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %4,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (ashift:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_lshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %0,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

;; The AIX assembler mis-handles "sri x,x,0", so write that case as
;; "sli x,x,0".
(define_expand "lshrsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_lshrsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_lshrsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "lshrsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,O,i")))
   (clobber (match_scratch:SI 3 "=q,X,X"))]
  "TARGET_POWER"
  "@
  sre %0,%1,%2
  mr %0,%1
  {s%A2i|s%A2wi} %0,%1,%h2")

(define_insn "lshrsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "O,ri")))]
  "! TARGET_POWER"
  "@
  mr %0,%1
  {sr|srw}%I2 %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,O,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,X,r"))
   (clobber (match_scratch:SI 4 "=q,X,X"))]
  "TARGET_POWER"
  "@
  sre. %3,%1,%2
  mr. %1,%1
  {s%A2i.|s%A2wi.} %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "O,ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=X,r"))]
  "! TARGET_POWER"
  "@
   mr. %1,%1
   {sr|srw}%I2. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,O,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X,X"))]
  "TARGET_POWER"
  "@
  sre. %0,%1,%2
  mr. %0,%1
  {s%A2i.|s%A2wi.} %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "O,ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "@
   mr. %0,%1
   {sr|srw}%I2. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "L")))]
  "includes_rshift_p (operands[2], operands[3])"
  "{rlinm|rlwinm} %0,%1,%s2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  "includes_rshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %4,%1,%s2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (lshiftrt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_rshift_p (operands[2], operands[3])"
  "{rlinm.|rlwinm.} %0,%1,%s2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (255))"
  "{rlinm|rlwinm} %0,%1,%s2,0xff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "includes_rshift_p (operands[2], GEN_INT (255))"
  "{rlinm.|rlwinm.} %3,%1,%s2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:QI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (255))"
  "{rlinm.|rlwinm.} %0,%1,%s2,0xff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (65535))"
  "{rlinm|rlwinm} %0,%1,%s2,0xffff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "includes_rshift_p (operands[2], GEN_INT (65535))"
  "{rlinm.|rlwinm.} %3,%1,%s2,0xffff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:HI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (65535))"
  "{rlinm.|rlwinm.} %0,%1,%s2,0xffff"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(ashiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(lshiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(zero_extract:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			 (const_int 1)
			 (const_int 0)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_expand "ashrsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
		     (match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_ashrsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_ashrsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "ashrsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  "TARGET_POWER"
  "@
   srea %0,%1,%2
   {srai|srawi} %0,%1,%h2")

(define_insn "ashrsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "! TARGET_POWER"
  "{sra|sraw}%I2 %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   srea. %3,%1,%2
   {srai.|srawi.} %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "! TARGET_POWER"
  "{sra|sraw}%I2. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  "TARGET_POWER"
  "@
   srea. %0,%1,%2
   {srai.|srawi.} %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "{sra|sraw}%I2. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

;; Floating-point insns, excluding normal data motion.
;;
;; PowerPC has a full set of single-precision floating point instructions.
;;
;; For the POWER architecture, we pretend that we have both SFmode and
;; DFmode insns, while, in fact, all fp insns are actually done in double.
;; The only conversions we will do will be when storing to memory.  In that
;; case, we will use the "frsp" instruction before storing.
;;
;; Note that when we store into a single-precision memory location, we need to
;; use the frsp insn first.  If the register being stored isn't dead, we
;; need a scratch register for the frsp.  But this is difficult when the store
;; is done by reload.  It is not incorrect to do the frsp on the register in
;; this case, we just lose precision that we would have otherwise gotten but
;; is not guaranteed.  Perhaps this should be tightened up at some point.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float_extend:DF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "*
{
  if (REGNO (operands[0]) == REGNO (operands[1]))
    return \"\";
  else
    return \"fmr %0,%1\";
}"
  [(set_attr "type" "fp")])

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(float_truncate:SF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "frsp %0,%1"
  [(set_attr "type" "fp")])

(define_insn "aux_truncdfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(unspec:SF [(match_operand:SF 1 "gpc_reg_operand" "f")] 0))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "frsp %0,%1"
  [(set_attr "type" "fp")])

(define_insn "negsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_insn "abssf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(abs:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (abs:SF (match_operand:SF 1 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT"
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_expand "addsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fadds %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fa|fadd} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_expand "subsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		  (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		  (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fsubs %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		  (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fs|fsub} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_expand "mulsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fmuls %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fm|fmul} %0,%1,%2"
  [(set_attr "type" "dmul")])

(define_expand "divsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "")
		(match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		(match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT"
  "fdivs %0,%1,%2"
  [(set_attr "type" "sdiv")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		(match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "{fd|fdiv} %0,%1,%2"
  [(set_attr "type" "ddiv")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			  (match_operand:SF 2 "gpc_reg_operand" "f"))
		 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "fmadds %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			  (match_operand:SF 2 "gpc_reg_operand" "f"))
		 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fma|fmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
		  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "fmsubs %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
		  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fms|fmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				  (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "fnmadds %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				  (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				   (match_operand:SF 2 "gpc_reg_operand" "f"))
			  (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "fnmsubs %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				   (match_operand:SF 2 "gpc_reg_operand" "f"))
			  (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_expand "sqrtsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "")))]
  "(TARGET_PPC_GPOPT || TARGET_POWER2) && TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GPOPT && TARGET_HARD_FLOAT"
  "fsqrts %0,%1"
  [(set_attr "type" "ssqrt")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_POWER2 && TARGET_HARD_FLOAT"
  "fsqrt %0,%1"
  [(set_attr "type" "dsqrt")])

;; For MIN, MAX, and conditional move, we use DEFINE_EXPAND's that involve a
;; fsel instruction and some auxiliary computations.  Then we just have a
;; single DEFINE_INSN for fsel and the define_splits to make them if made by
;; combine.
(define_expand "maxsf3"
  [(set (match_dup 3)
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		  (match_operand:SF 2 "gpc_reg_operand" "")))
   (set (match_operand:SF 0 "gpc_reg_operand" "")
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (SFmode); }")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(smax:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:SF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:SF (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "minsf3"
  [(set (match_dup 3)
	(minus:SF (match_operand:SF 2 "gpc_reg_operand" "")
		  (match_operand:SF 1 "gpc_reg_operand" "")))
   (set (match_operand:SF 0 "gpc_reg_operand" "")
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (SFmode); }")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(smin:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:SF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:SF (match_dup 2) (match_dup 1)))
   (set (match_dup 0)
	(if_then_else:SF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "movsfcc"
   [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	 (if_then_else:SF (match_operand 1 "comparison_operator" "")
			  (match_operand:SF 2 "gpc_reg_operand" "f")
			  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{
  rtx temp, op0, op1;
  enum rtx_code code = GET_CODE (operands[1]);
  if (! rs6000_compare_fp_p)
    FAIL;
  switch (code)
    {
    case GE: case EQ: case NE:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      break;
    case GT:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    case LE:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      break;
    case LT:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    default:
      FAIL;
    }
  if (GET_MODE (rs6000_compare_op0) == DFmode)
    {
      temp = gen_reg_rtx (DFmode);
      emit_insn (gen_subdf3 (temp, op0, op1));
      emit_insn (gen_fseldfsf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfsf4 (operands[0], temp, operands[0], operands[3]));
	}
      else if (code == NE)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfsf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  else
    {
      temp = gen_reg_rtx (SFmode);
      emit_insn (gen_subsf3 (temp, op0, op1));
      emit_insn (gen_fselsfsf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfsf4 (operands[0], temp, operands[0], operands[3]));
	}
      else if (code == NE)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfsf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  DONE;
}")

(define_insn "fselsfsf4"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(if_then_else:SF (ge (match_operand:SF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:SF 2 "gpc_reg_operand" "f")
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "fseldfsf4"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(if_then_else:SF (ge (match_operand:DF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:SF 2 "gpc_reg_operand" "f")
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "negdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_insn "absdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(abs:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (abs:DF (match_operand:DF 1 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT"
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn "adddf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fa|fadd} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "subdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		  (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fs|fsub} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "muldf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fm|fmul} %0,%1,%2"
  [(set_attr "type" "dmul")])

(define_insn "divdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(div:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		(match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "{fd|fdiv} %0,%1,%2"
  [(set_attr "type" "ddiv")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			  (match_operand:DF 2 "gpc_reg_operand" "f"))
		 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fma|fmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			   (match_operand:DF 2 "gpc_reg_operand" "f"))
		  (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fms|fmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				  (match_operand:DF 2 "gpc_reg_operand" "f"))
			 (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				   (match_operand:DF 2 "gpc_reg_operand" "f"))
			  (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT && TARGET_FUSED_MADD"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn "sqrtdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(sqrt:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "(TARGET_PPC_GPOPT || TARGET_POWER2) && TARGET_HARD_FLOAT"
  "fsqrt %0,%1"
  [(set_attr "type" "dsqrt")])

;; For MIN, MAX, and conditional move, we use DEFINE_EXPAND's that involve a
;; fsel instruction and some auxiliary computations.  Then we just have a
;; single DEFINE_INSN for fsel and the define_splits to make them if made by
;; combine.

(define_expand "maxdf3"
  [(set (match_dup 3)
	(minus:DF (match_operand:DF 1 "gpc_reg_operand" "")
		  (match_operand:DF 2 "gpc_reg_operand" "")))
   (set (match_operand:DF 0 "gpc_reg_operand" "")
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (DFmode); }")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(smax:DF (match_operand:DF 1 "gpc_reg_operand" "")
		 (match_operand:DF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:DF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:DF (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "mindf3"
  [(set (match_dup 3)
	(minus:DF (match_operand:DF 2 "gpc_reg_operand" "")
		  (match_operand:DF 1 "gpc_reg_operand" "")))
   (set (match_operand:DF 0 "gpc_reg_operand" "")
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{ operands[3] = gen_reg_rtx (DFmode); }")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(smin:DF (match_operand:DF 1 "gpc_reg_operand" "")
		 (match_operand:DF 2 "gpc_reg_operand" "")))
   (clobber (match_operand:DF 3 "gpc_reg_operand" ""))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  [(set (match_dup 3)
	(minus:DF (match_dup 2) (match_dup 1)))
   (set (match_dup 0)
	(if_then_else:DF (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_expand "movdfcc"
   [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	 (if_then_else:DF (match_operand 1 "comparison_operator" "")
			  (match_operand:DF 2 "gpc_reg_operand" "f")
			  (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "
{
  rtx temp, op0, op1;
  enum rtx_code code = GET_CODE (operands[1]);
  if (! rs6000_compare_fp_p)
    FAIL;
  switch (code)
    {
    case GE: case EQ: case NE:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      break;
    case GT:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    case LE:
      op0 = rs6000_compare_op1;
      op1 = rs6000_compare_op0;
      break;
    case LT:
      op0 = rs6000_compare_op0;
      op1 = rs6000_compare_op1;
      temp = operands[2]; operands[2] = operands[3]; operands[3] = temp;
      break;
    default:
      FAIL;
    }
  if (GET_MODE (rs6000_compare_op0) == DFmode)
    {
      temp = gen_reg_rtx (DFmode);
      emit_insn (gen_subdf3 (temp, op0, op1));
      emit_insn (gen_fseldfdf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfdf4 (operands[0], temp, operands[0], operands[3]));
	}
      else if (code == NE)
	{
	  emit_insn (gen_negdf2 (temp, temp));
	  emit_insn (gen_fseldfdf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  else
    {
      temp = gen_reg_rtx (SFmode);
      emit_insn (gen_subsf3 (temp, op0, op1));
      emit_insn (gen_fselsfdf4 (operands[0], temp, operands[2], operands[3]));
      if (code == EQ)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfdf4 (operands[0], temp, operands[0], operands[3]));
	}
      else if (code == NE)
	{
	  emit_insn (gen_negsf2 (temp, temp));
	  emit_insn (gen_fselsfdf4 (operands[0], temp, operands[3], operands[0]));
	}
    }
  DONE;
}")

(define_insn "fseldfdf4"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(if_then_else:DF (ge (match_operand:DF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:DF 2 "gpc_reg_operand" "f")
			 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "fselsfdf4"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(if_then_else:DF (ge (match_operand:SF 1 "gpc_reg_operand" "f")
			     (const_int 0))
			 (match_operand:DF 2 "gpc_reg_operand" "f")
			 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

;; Conversions to and from floating-point.

(define_expand "floatsidf2"
  [(parallel [(set (match_operand:DF 0 "gpc_reg_operand" "")
		   (float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
	      (use (match_dup 2))
	      (use (match_dup 3))
	      (clobber (match_dup 4))
	      (clobber (match_dup 5))
	      (clobber (reg:DF 76))])]
  "TARGET_HARD_FLOAT"
  "
{
  operands[2] = force_reg (SImode, GEN_INT (0x43300000));
  operands[3] = force_reg (DFmode, rs6000_float_const (\"4503601774854144\", DFmode));
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = gen_reg_rtx (Pmode);
}")

(define_insn "*floatsidf2_internal"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=&f")
	(float:DF (match_operand:SI 1 "gpc_reg_operand" "r")))
   (use (match_operand:SI 2 "gpc_reg_operand" "r"))
   (use (match_operand:DF 3 "gpc_reg_operand" "f"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (match_operand 5 "gpc_reg_operand" "=b"))
   (clobber (reg:DF 76))]
  "TARGET_HARD_FLOAT"
  "#"
  [(set_attr "length" "24")])

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
   (use (match_operand:SI 2 "gpc_reg_operand" ""))
   (use (match_operand:DF 3 "gpc_reg_operand" ""))
   (clobber (match_operand:SI 4 "gpc_reg_operand" ""))
   (clobber (match_operand 5 "gpc_reg_operand" ""))
   (clobber (reg:DF 76))]
  "TARGET_HARD_FLOAT"
  [(set (match_dup 4)
	(xor:SI (match_dup 1)
		(match_dup 6)))
   (set (match_dup 5)
	(unspec [(const_int 0)] 11))
   (set (match_dup 7)
	(unspec [(match_dup 4)
		 (match_dup 5)] 12))	;; low word
   (set (match_dup 7)
	(unspec [(match_dup 2)
		 (match_dup 5)
		 (match_dup 7)] 13))	;; high word
   (set (match_dup 0)
	(unspec [(match_dup 7)
		 (match_dup 5)] 14))
   (set (match_dup 0)
	(minus:DF (match_dup 0)
		  (match_dup 3)))]
  "
{
  operands[6] = GEN_INT (0x80000000);
  operands[7] = gen_rtx_REG (DFmode, FPMEM_REGNUM);
}")

(define_expand "floatunssidf2"
  [(parallel [(set (match_operand:DF 0 "gpc_reg_operand" "")
		   (unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
	      (use (match_dup 2))
	      (use (match_dup 3))
	      (clobber (match_dup 4))
	      (clobber (reg:DF 76))])]
  "TARGET_HARD_FLOAT"
  "
{
  operands[2] = force_reg (SImode, GEN_INT (0x43300000));
  operands[3] = force_reg (DFmode, rs6000_float_const (\"4503599627370496\", DFmode));
  operands[4] = gen_reg_rtx (Pmode);
}")

(define_insn "*floatunssidf2_internal"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=&f")
	(unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "r")))
   (use (match_operand:SI 2 "gpc_reg_operand" "r"))
   (use (match_operand:DF 3 "gpc_reg_operand" "f"))
   (clobber (match_operand 4 "gpc_reg_operand" "=b"))
   (clobber (reg:DF 76))]
  "TARGET_HARD_FLOAT"
  "#"
  [(set_attr "length" "20")])

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
   (use (match_operand:SI 2 "gpc_reg_operand" ""))
   (use (match_operand:DF 3 "gpc_reg_operand" ""))
   (clobber (match_operand 4 "gpc_reg_operand" ""))
   (clobber (reg:DF 76))]
  "TARGET_HARD_FLOAT"
  [(set (match_dup 4)
	(unspec [(const_int 0)] 11))
   (set (match_dup 5)
	(unspec [(match_dup 1)
		 (match_dup 4)] 12))	;; low word
   (set (match_dup 5)
	(unspec [(match_dup 2)
		 (match_dup 4)
		 (match_dup 5)] 13))	;; high word
   (set (match_dup 0)
	(unspec [(match_dup 5)
		 (match_dup 4)] 14))
   (set (match_dup 0)
	(minus:DF (match_dup 0)
		  (match_dup 3)))]
  "operands[5] = gen_rtx_REG (DFmode, FPMEM_REGNUM);")

;; Load up scratch register with base address + offset if needed
(define_insn "*floatsidf2_loadaddr"
  [(set (match_operand 0 "gpc_reg_operand" "=b")
	(unspec [(const_int 0)] 11))]
  "TARGET_HARD_FLOAT"
  "*
{
  if (rs6000_fpmem_offset > 32760)
    {
      rtx xop[3];

      xop[0] = operands[0];
      xop[1] = (frame_pointer_needed) ? frame_pointer_rtx : stack_pointer_rtx;
      xop[2] = GEN_INT ((rs6000_fpmem_offset >> 16) + ((rs6000_fpmem_offset & 0x8000) >> 15));
      output_asm_insn (\"{cau|addis} %0,%1,%2\", xop);
    }

  return \"\";
}"
  [(set_attr "length" "4")])

(define_insn "*floatsidf2_store1"
  [(set (reg:DF 76)
	(unspec [(match_operand:SI 0 "gpc_reg_operand" "r")
		 (match_operand 1 "gpc_reg_operand" "b")] 12))]
  "TARGET_HARD_FLOAT"
  "*
{
  rtx indx;

  if (rs6000_fpmem_offset > 32760)
    indx = operands[1];
  else if (frame_pointer_needed)
    indx = frame_pointer_rtx;
  else
    indx = stack_pointer_rtx;

  operands[2] = gen_rtx_MEM (SImode,
			 gen_rtx_PLUS (Pmode,
				  indx,
				  GEN_INT ((((rs6000_fpmem_offset & 0xffff) ^ 0x8000) - 0x8000)
					   + ((WORDS_BIG_ENDIAN != 0) * 4))));

  return \"{st|stw} %0,%2\";
}"
  [(set_attr "type" "store")])

(define_insn "*floatsidf2_store2"
  [(set (reg:DF 76)
	(unspec [(match_operand:SI 0 "gpc_reg_operand" "r")
		 (match_operand 1 "gpc_reg_operand" "b")
		 (reg:DF 76)] 13))]
  "TARGET_HARD_FLOAT"
  "*
{
  rtx indx;

  if (rs6000_fpmem_offset > 32760)
    indx = operands[1];
  else if (frame_pointer_needed)
    indx = frame_pointer_rtx;
  else
    indx = stack_pointer_rtx;

  operands[2] = gen_rtx_MEM (SImode,
			 gen_rtx_PLUS (Pmode,
				  indx,
				  GEN_INT ((((rs6000_fpmem_offset & 0xffff) ^ 0x8000) - 0x8000)
					   + ((WORDS_BIG_ENDIAN == 0) * 4))));

  return \"{st|stw} %0,%2\";
}"
  [(set_attr "type" "store")])

(define_insn "*floatsidf2_load"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(unspec [(reg:DF 76)
		 (match_operand 1 "gpc_reg_operand" "b")] 14))]
  "TARGET_HARD_FLOAT"
  "*
{
  rtx indx;
  HOST_WIDE_INT offset = rs6000_fpmem_offset;

  if (rs6000_fpmem_offset > 32760)
    {
      indx = operands[1];
      offset = (((offset & 0xffff) ^ 0x8000) - 0x8000);
    }
  else if (frame_pointer_needed)
    indx = frame_pointer_rtx;
  else
    indx = stack_pointer_rtx;

  operands[2] = gen_rtx_MEM (SImode,
			 gen_rtx_PLUS (Pmode, indx, GEN_INT (offset)));

  return \"lfd %0,%2\";
}"
  [(set_attr "type" "fpload")])

(define_expand "fix_truncdfsi2"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (fix:SI (match_operand:DF 1 "gpc_reg_operand" "")))
	      (clobber (match_dup 2))
	      (clobber (match_dup 3))
	      (clobber (match_dup 4))])]
  "TARGET_HARD_FLOAT"
  "
{
  if (!TARGET_POWER2 && !TARGET_POWERPC)
    {
      emit_insn (gen_trunc_call (operands[0], operands[1],
				 gen_rtx_SYMBOL_REF (Pmode, RS6000_ITRUNC)));
      DONE;
    }

  operands[2] = gen_reg_rtx (DImode);
  operands[3] = gen_reg_rtx (Pmode);
  operands[4] = gen_rtx_REG (DImode, FPMEM_REGNUM);
}")

(define_insn "*fix_truncdfsi2_internal"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(fix:SI (match_operand:DF 1 "gpc_reg_operand" "f")))
   (clobber (match_operand:DI 2 "gpc_reg_operand" "=f"))
   (clobber (match_operand 3 "gpc_reg_operand" "=b"))
   (clobber (reg:DI 76))]
  "TARGET_HARD_FLOAT"
  "#"
  [(set_attr "length" "12")])

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(fix:SI (match_operand:DF 1 "gpc_reg_operand" "f")))
   (clobber (match_operand:DI 2 "gpc_reg_operand" ""))
   (clobber (match_operand 3 "gpc_reg_operand" ""))
   (clobber (reg:DI 76))]
  "TARGET_HARD_FLOAT"
  [(set (match_dup 2)
	(sign_extend:DI (fix:SI (match_operand:DF 1 "gpc_reg_operand" ""))))
   (set (match_dup 3)
	(unspec [(const_int 0)] 11))
   (set (match_dup 4)
	(unspec [(match_dup 2)
		 (match_dup 3)] 15))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(unspec [(match_dup 4)
		 (match_dup 3)] 16))]
  "operands[4] = gen_rtx_REG (DImode, FPMEM_REGNUM);")

(define_insn "*fix_truncdfsi2_store"
  [(set (reg:DI 76)
	(unspec [(match_operand:DI 0 "gpc_reg_operand" "f")
		 (match_operand 1 "gpc_reg_operand" "b")] 15))]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT"
  "*
{
  rtx indx;

  if (rs6000_fpmem_offset > 32760)
    indx = operands[1];
  else if (frame_pointer_needed)
    indx = frame_pointer_rtx;
  else
    indx = stack_pointer_rtx;

  operands[2] = gen_rtx_MEM (DFmode,
			 gen_rtx_PLUS (Pmode,
				  indx,
				  GEN_INT ((((rs6000_fpmem_offset & 0xffff)
					     ^ 0x8000) - 0x8000))));

  return \"stfd %0,%2\";
}"
  [(set_attr "type" "fpstore")])

(define_insn "*fix_truncdfsi2_load"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(unspec [(reg:DI 76)
		 (match_operand 1 "gpc_reg_operand" "b")] 16))]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT"
  "*
{
  rtx indx;

  if (rs6000_fpmem_offset > 32760)
    indx = operands[1];
  else if (frame_pointer_needed)
    indx = frame_pointer_rtx;
  else
    indx = stack_pointer_rtx;

  operands[2] = gen_rtx_MEM (DFmode,
			 gen_rtx_PLUS (Pmode,
				  indx,
				  GEN_INT ((((rs6000_fpmem_offset & 0xffff) ^ 0x8000) - 0x8000)
					   + ((WORDS_BIG_ENDIAN) ? 4 : 0))));

  return \"{l|lwz} %0,%2\";
}"
  [(set_attr "type" "load")])

(define_expand "fixuns_truncdfsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(unsigned_fix:SI (match_operand:DF 1 "gpc_reg_operand" "")))]
  "! TARGET_POWER2 && ! TARGET_POWERPC && TARGET_HARD_FLOAT"
  "
{
  emit_insn (gen_trunc_call (operands[0], operands[1],
			     gen_rtx_SYMBOL_REF (Pmode, RS6000_UITRUNC)));
  DONE;
}")

(define_expand "trunc_call"
  [(parallel [(set (match_operand:SI 0 "" "")
		   (fix:SI (match_operand:DF 1 "" "")))
	      (use (match_operand:SI 2 "" ""))])]
  "TARGET_HARD_FLOAT"
  "
{
  rtx insns = gen_trunc_call_rtl (operands[0], operands[1], operands[2]);
  rtx first = XVECEXP (insns, 0, 0);
  rtx last = XVECEXP (insns, 0, XVECLEN (insns, 0) - 1);

  REG_NOTES (first) = gen_rtx_INSN_LIST (REG_LIBCALL, last,
			       REG_NOTES (first));
  REG_NOTES (last) = gen_rtx_INSN_LIST (REG_RETVAL, first, REG_NOTES (last));

  emit_insn (insns);
  DONE;
}")

(define_expand "trunc_call_rtl"
  [(set (reg:DF 33) (match_operand:DF 1 "gpc_reg_operand" ""))
   (use (reg:DF 33))
   (parallel [(set (reg:SI 3)
		   (call (mem:SI (match_operand 2 "" "")) (const_int 0)))
	      (use (const_int 0))
	      (clobber (scratch:SI))])
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(reg:SI 3))]
  "TARGET_HARD_FLOAT"
  "
{
  rs6000_trunc_used = 1;
}")

(define_insn "*fctiwz"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=f")
	(sign_extend:DI (fix:SI (match_operand:DF 1 "gpc_reg_operand" "f"))))]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT"
  "{fcirz|fctiwz} %0,%1"
  [(set_attr "type" "fp")])

(define_insn "floatdidf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float:DF (match_operand:DI 1 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "fcfid %0,%1"
  [(set_attr "type" "fp")])

(define_insn "fix_truncdfdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=f")
	(fix:DI (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT"
  "fctidz %0,%1"
  [(set_attr "type" "fp")])

;; Define the DImode operations that can be done in a small number
;; of instructions.  The & constraints are to prevent the register
;; allocator from allocating registers that overlap with the inputs
;; (for example, having an input in 7,8 and an output in 6,7).  We
;; also allow for the output being the same as one of the inputs.

(define_insn "*adddi3_noppc64"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r,r,r")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,0,0")
		 (match_operand:DI 2 "reg_or_short_operand" "r,I,r,I")))]
  "! TARGET_POWERPC64"
  "*
{
  if (WORDS_BIG_ENDIAN)
    return (GET_CODE (operands[2])) != CONST_INT
	    ? \"{a|addc} %L0,%L1,%L2\;{ae|adde} %0,%1,%2\"
	    : \"{ai|addic} %L0,%L1,%2\;{a%G2e|add%G2e} %0,%1\";
  else
    return (GET_CODE (operands[2])) != CONST_INT
	    ? \"{a|addc} %0,%1,%2\;{ae|adde} %L0,%L1,%L2\"
	    : \"{ai|addic} %0,%1,%2\;{a%G2e|add%G2e} %L0,%L1\";
}"
  [(set_attr "length" "8")])

(define_insn "*subdi3_noppc64"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r,r,r,r")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "r,I,0,r,I")
		  (match_operand:DI 2 "gpc_reg_operand" "r,r,r,0,0")))]
  "! TARGET_POWERPC64"
  "*
{
  if (WORDS_BIG_ENDIAN)
    return (GET_CODE (operands[1]) != CONST_INT)
	    ? \"{sf|subfc} %L0,%L2,%L1\;{sfe|subfe} %0,%2,%1\"
	    : \"{sfi|subfic} %L0,%L2,%1\;{sf%G1e|subf%G1e} %0,%2\";
  else
    return (GET_CODE (operands[1]) != CONST_INT)
	    ? \"{sf|subfc} %0,%2,%1\;{sfe|subfe} %L0,%L2,%L1\"
	    : \"{sfi|subfic} %0,%2,%1\;{sf%G1e|subf%G1e} %L0,%L2\";
}"
  [(set_attr "length" "8")])

(define_insn "*negdi2_noppc64"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r,0")))]
  "! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"{sfi|subfic} %L0,%L1,0\;{sfze|subfze} %0,%1\"
    : \"{sfi|subfic} %0,%1,0\;{sfze|subfze} %L0,%L1\";
}"
  [(set_attr "length" "8")])

(define_expand "mulsidi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "! TARGET_POWERPC64"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_mull_call ());
      if (WORDS_BIG_ENDIAN)
        emit_move_insn (operands[0], gen_rtx_REG (DImode, 3));
      else
	{
	  emit_move_insn (operand_subword (operands[0], 0, 0, DImode),
			  gen_rtx_REG (SImode, 3));
	  emit_move_insn (operand_subword (operands[0], 1, 0, DImode),
			  gen_rtx_REG (SImode, 4));
	}
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_mulsidi3_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "mulsidi3_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWER"
  "mul %0,%1,%2\;mfmq %L0"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_insn "*mulsidi3_no_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  "TARGET_POWERPC && ! TARGET_POWER && ! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"mulhw %0,%1,%2\;mullw %L0,%1,%2\"
    : \"mulhw %L0,%1,%2\;mullw %0,%1,%2\";
}"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "TARGET_POWERPC && ! TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI (match_dup 1))
			       (sign_extend:DI (match_dup 2)))
		      (const_int 32))))
   (set (match_dup 4)
	(mult:SI (match_dup 1)
		 (match_dup 2)))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  operands[3] = operand_subword (operands[0], endian, 0, DImode);
  operands[4] = operand_subword (operands[0], 1 - endian, 0, DImode);
}")

(define_expand "umulsidi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "TARGET_POWERPC && ! TARGET_POWERPC64"
  "
{
  if (TARGET_POWER)
    {
      emit_insn (gen_umulsidi3_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "umulsidi3_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"mulhwu %0,%1,%2\;mullw %L0,%1,%2\"
    : \"mulhwu %L0,%1,%2\;mullw %0,%1,%2\";
}"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_insn "*umulsidi3_no_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  "TARGET_POWERPC && ! TARGET_POWER && ! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"mulhwu %0,%1,%2\;mullw %L0,%1,%2\"
    : \"mulhwu %L0,%1,%2\;mullw %0,%1,%2\";
}"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "TARGET_POWERPC && ! TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI (match_dup 1))
			       (zero_extend:DI (match_dup 2)))
		      (const_int 32))))
   (set (match_dup 4)
	(mult:SI (match_dup 1)
		 (match_dup 2)))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  operands[3] = operand_subword (operands[0], endian, 0, DImode);
  operands[4] = operand_subword (operands[0], 1 - endian, 0, DImode);
}")

(define_expand "smulsi3_highpart"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  ""
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_mulh_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_smulsi3_highpart_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "smulsi3_highpart_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWER"
  "mul %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "*smulsi3_highpart_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "mulhw %0,%1,%2"
  [(set_attr "type" "imul")])

(define_expand "umulsi3_highpart"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" ""))
			       (zero_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "")))
		      (const_int 32))))]
  "TARGET_POWERPC"
  "
{
  if (TARGET_POWER)
    {
      emit_insn (gen_umulsi3_highpart_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "umulsi3_highpart_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "mulhwu %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "*umulsi3_highpart_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "mulhwu %0,%1,%2"
  [(set_attr "type" "imul")])

;; If operands 0 and 2 are in the same register, we have a problem.  But
;; operands 0 and 1 (the usual case) can be in the same register.  That's
;; why we have the strange constraints below.
(define_insn "ashldi3_power"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,&r")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  "TARGET_POWER"
  "@
   {sli|slwi} %0,%L1,%h2\;{cal %L0,0(0)|li %L0,0}
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2"
  [(set_attr "length" "8")])

(define_insn "lshrdi3_power"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,&r")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  "TARGET_POWER"
  "@
   {s%A2i|s%A2wi} %L0,%1,%h2\;{cal %0,0(0)|li %0,0}
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2"
  [(set_attr "length" "8")])

;; Shift by a variable amount is too complex to be worth open-coding.  We
;; just handle shifts by constants.
(define_insn "ashrdi3_power"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "const_int_operand" "M,i")))
   (clobber (match_scratch:SI 3 "=X,q"))]
  "TARGET_POWER"
  "@
   {srai|srawi} %0,%1,31\;{srai|srawi} %L0,%1,%h2
   sraiq %0,%1,%h2\;srliq %L0,%L1,%h2"
  [(set_attr "length" "8")])

;; PowerPC64 DImode operations.

(define_expand "adddi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (! TARGET_POWERPC64)
    {
      if (non_short_cint_operand (operands[2], DImode))
	FAIL;
    }
  else
    if (GET_CODE (operands[2]) == CONST_INT
	&& !add_operand (operands[2], DImode))
      {
	rtx tmp = ((reload_in_progress || reload_completed
		    || rtx_equal_p (operands[0], operands[1]))
		   ? operands[0] : gen_reg_rtx (DImode));

	HOST_WIDE_INT low = INTVAL (operands[2]) & 0xffff;
	HOST_WIDE_INT high = INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff);

	if (low & 0x8000)
	  high += 0x10000, low |= ((HOST_WIDE_INT) -1) << 16;

	emit_insn (gen_adddi3 (tmp, operands[1], GEN_INT (high)));
	emit_insn (gen_adddi3 (operands[0], tmp, GEN_INT (low)));
	DONE;
      }
}")

;; Discourage ai/addic because of carry but provide it in an alternative
;; allowing register zero as source.

(define_insn "*adddi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,?r,r")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,b,r,b")
		 (match_operand:DI 2 "add_operand" "r,I,I,J")))]
  "TARGET_POWERPC64"
  "@
   add %0,%1,%2
   addi %0,%1,%2
   addic %0,%1,%2
   addis %0,%1,%v2")

(define_insn "*adddi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:DI 2 "reg_or_short_operand" "r,I"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_POWERPC64"
  "@
   add. %3,%1,%2
   addic. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*adddi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:DI 2 "reg_or_short_operand" "r,I"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "@
   add. %0,%1,%2
   addic. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an add that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.  Note that the low-order
;; add should be last in case the result gets used in an address.

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "non_add_cint_operand" "")))]
  "TARGET_POWERPC64"
  [(set (match_dup 0) (plus:DI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (plus:DI (match_dup 0) (match_dup 4)))]
"
{
  HOST_WIDE_INT low = INTVAL (operands[2]) & 0xffff;
  HOST_WIDE_INT high = INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff);

  if (low & 0x8000)
    high+=0x10000, low |= ((HOST_WIDE_INT) -1) << 16;

  operands[3] = GEN_INT (high);
  operands[4] = GEN_INT (low);
}")

(define_insn "one_cmpldi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(not:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "nor %0,%1,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "nor. %2,%1,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(not:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "nor. %0,%1,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "r,I")
		  (match_operand:DI 2 "gpc_reg_operand" "r,r")))]
  "TARGET_POWERPC64"
  "@
   subf %0,%2,%1
   subfic %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (minus:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			      (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "subf. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (minus:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			      (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(minus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "subf. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_expand "subdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "")
		  (match_operand:DI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_adddi3 (operands[0], operands[1],
			     negate_rtx (DImode, operands[2])));
      DONE;
    }
}")

(define_insn "absdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:DI 2 "=&r,&r"))]
  "TARGET_POWERPC64"
  "sradi %2,%1,63\;xor %0,%2,%1\;subf %0,%2,%0"
  [(set_attr "length" "12")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:DI 2 "=&r,&r"))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2) (ashiftrt:DI (match_dup 1) (const_int 63)))
   (set (match_dup 0) (xor:DI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:DI (match_dup 0) (match_dup 2)))]
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:DI 2 "=&r,&r"))]
  "TARGET_POWERPC64"
  "sradi %2,%1,63\;xor %0,%2,%1\;subf %0,%0,%2"
  [(set_attr "length" "12")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:DI 2 "=&r,&r"))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2) (ashiftrt:DI (match_dup 1) (const_int 63)))
   (set (match_dup 0) (xor:DI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:DI (match_dup 0) (match_dup 2)))]
  "")

(define_expand "negdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "neg %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (neg:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r"))]
  "TARGET_POWERPC64"
  "neg. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (neg:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(neg:DI (match_dup 1)))]
  "TARGET_POWERPC64"
  "neg. %0,%1"
  [(set_attr "type" "compare")])

(define_insn "ffsdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(ffs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "neg %0,%1\;and %0,%0,%1\;cntlzd %0,%0\;subfic %0,%0,64"
  [(set_attr "length" "16")])

(define_insn "muldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(mult:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
		 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "mulld %0,%1,%2"
   [(set_attr "type" "imul")])

(define_insn "smuldi3_highpart"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(truncate:DI
	 (lshiftrt:TI (mult:TI (sign_extend:TI
				(match_operand:DI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:TI
				(match_operand:DI 2 "gpc_reg_operand" "r")))
		      (const_int 64))))]
  "TARGET_POWERPC64"
  "mulhd %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "umuldi3_highpart"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(truncate:DI
	 (lshiftrt:TI (mult:TI (zero_extend:TI
				(match_operand:DI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:TI
				(match_operand:DI 2 "gpc_reg_operand" "r")))
		      (const_int 64))))]
  "TARGET_POWERPC64"
  "mulhdu %0,%1,%2"
  [(set_attr "type" "imul")])

(define_expand "divdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(div:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && exact_log2 (INTVAL (operands[2])) >= 0)
    ;
  else
    operands[2] = force_reg (DImode, operands[2]);
}")

(define_expand "moddi3"
  [(use (match_operand:DI 0 "gpc_reg_operand" ""))
   (use (match_operand:DI 1 "gpc_reg_operand" ""))
   (use (match_operand:DI 2 "reg_or_cint_operand" ""))]
  "TARGET_POWERPC64"
  "
{
  int i = exact_log2 (INTVAL (operands[2]));
  rtx temp1;
  rtx temp2;

  if (GET_CODE (operands[2]) != CONST_INT || i < 0)
    FAIL;

  temp1 = gen_reg_rtx (DImode);
  temp2 = gen_reg_rtx (DImode);

  emit_insn (gen_divdi3 (temp1, operands[1], operands[2]));
  emit_insn (gen_ashldi3 (temp2, temp1, GEN_INT (i)));
  emit_insn (gen_subdi3 (operands[0], operands[1], temp2));
  DONE;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(div:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		(match_operand:DI 2 "const_int_operand" "N")))]
  "TARGET_POWERPC64 && exact_log2 (INTVAL (operands[2])) >= 0"
  "sradi %0,%1,%p2\;addze %0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (div:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			    (match_operand:DI 2 "const_int_operand" "N"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64 && exact_log2 (INTVAL (operands[2])) >= 0"
  "sradi %3,%1,%p2\;addze. %3,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (div:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			    (match_operand:DI 2 "const_int_operand" "N"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(div:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && exact_log2 (INTVAL (operands[2])) >= 0"
  "sradi %0,%1,%p2\;addze. %0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
        (div:DI (match_operand:DI 1 "gpc_reg_operand" "r")
                (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "divd %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "udivdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
        (udiv:DI (match_operand:DI 1 "gpc_reg_operand" "r")
                 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "divdu %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "rotldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		   (match_operand:DI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,0")

(define_insn "*rotldi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			       (match_operand:DI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "rld%I2cl. %3,%1,%H2,0"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			       (match_operand:DI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(rotate:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "rld%I2cl. %0,%1,%H2,0"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal4"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			   (match_operand:DI 2 "reg_or_cint_operand" "ri"))
		(match_operand:DI 3 "mask64_operand" "S")))]
  "TARGET_POWERPC64"
  "rld%I2c%B3 %0,%1,%H2,%S3")

(define_insn "*rotldi3_internal5"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:DI
		     (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				(match_operand:DI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:DI 3 "mask64_operand" "S"))
		    (const_int 0)))
   (clobber (match_scratch:DI 4 "=r"))]
  "TARGET_POWERPC64"
  "rld%I2c%B3. %4,%1,%H2,%S3"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal6"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC (and:DI
		     (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				(match_operand:DI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:DI 3 "mask64_operand" "S"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (rotate:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWERPC64"
  "rld%I2c%B3. %0,%1,%H2,%S3"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal7"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI
	 (subreg:QI
	  (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,56")

(define_insn "*rotldi3_internal8"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI
		     (subreg:QI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "rld%I2cl. %3,%1,%H2,56"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal9"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI
		     (subreg:QI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (subreg:QI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl. %0,%1,%H2,56"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal10"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI
	 (subreg:HI
	  (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,48")

(define_insn "*rotldi3_internal11"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI
		     (subreg:HI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "rld%I2cl. %3,%1,%H2,48"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal12"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI
		     (subreg:HI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (subreg:HI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl. %0,%1,%H2,48"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal13"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI
	 (subreg:SI
	  (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,32")

(define_insn "*rotldi3_internal14"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI
		     (subreg:SI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "rld%I2cl. %3,%1,%H2,32"
  [(set_attr "type" "delayed_compare")])

(define_insn "*rotldi3_internal15"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:DI
		     (subreg:SI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI (subreg:SI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl. %0,%1,%H2,32"
  [(set_attr "type" "delayed_compare")])

(define_expand "ashldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
		   (match_operand:SI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64 || TARGET_POWER"
  "
{
  if (TARGET_POWERPC64)
    ;
  else if (TARGET_POWER)
    {
      emit_insn (gen_ashldi3_power (operands[0], operands[1], operands[2]));
      DONE;
    }
  else
    FAIL;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "sld%I2 %0,%1,%H2"
  [(set_attr "length" "8")])
  
(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "sld%I2. %3,%1,%H2"
  [(set_attr "type" "delayed_compare")])
  
(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ashift:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "sld%I2. %0,%1,%H2"
  [(set_attr "type" "delayed_compare")])

(define_expand "lshrdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
		     (match_operand:SI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64 || TARGET_POWER"
  "
{
  if (TARGET_POWERPC64)
    ;
  else if (TARGET_POWER)
    {
      emit_insn (gen_lshrdi3_power (operands[0], operands[1], operands[2]));
      DONE;
    }
  else
    FAIL;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "srd%I2 %0,%1,%H2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "srd%I2. %3,%1,%H2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(lshiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "srd%I2. %0,%1,%H2"
  [(set_attr "type" "delayed_compare")])

(define_expand "ashrdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
		     (match_operand:SI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64 || TARGET_POWER"
  "
{
  if (TARGET_POWERPC64)
    ;
  else if (TARGET_POWER && GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_ashrdi3_power (operands[0], operands[1], operands[2]));
      DONE;
    }
  else
    FAIL;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "srad%I2 %0,%1,%H2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "srad%I2. %3,%1,%H2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "srad%I2. %0,%1,%H2"
  [(set_attr "type" "delayed_compare")])

(define_insn "anddi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r")
		(match_operand:DI 2 "and64_operand" "?r,S,K,J")))
   (clobber (match_scratch:CC 3 "=X,X,x,x"))]
  "TARGET_POWERPC64"
  "@
   and %0,%1,%2
   rldic%B2 %0,%1,0,%S2
   andi. %0,%1,%b2
   andis. %0,%1,%u2")

(define_insn "*anddi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:DI 2 "and64_operand" "r,K,J,S"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r,r,r"))]
  "TARGET_POWERPC64"
  "@
   and. %3,%1,%2
   andi. %3,%1,%b2
   andis. %3,%1,%u2
   rldic%B2. %3,%1,0,%S2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")])

(define_insn "*anddi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:DI 2 "and64_operand" "r,K,J,S"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "@
   and. %0,%1,%2
   andi. %0,%1,%b2
   andis. %0,%1,%u2
   rldic%B2. %3,%1,0,%S2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")])

(define_expand "iordi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(ior:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && !logical_operand (operands[2], DImode))
    {
      HOST_WIDE_INT value = INTVAL (operands[2]);
      rtx tmp = ((reload_in_progress || reload_completed
		  || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (DImode));

      emit_insn (gen_iordi3 (tmp, operands[1],
			     GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
      emit_insn (gen_iordi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_insn "*iordi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r")
	(ior:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:DI 2 "logical_operand" "r,K,J")))]
  "TARGET_POWERPC64"
  "@
   or %0,%1,%2
   ori %0,%1,%b2
   oris %0,%1,%u2")

(define_insn "*iordi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "or. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*iordi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ior:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "or. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an IOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(ior:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "non_logical_cint_operand" "")))]
  "TARGET_POWERPC64"
  [(set (match_dup 0) (ior:DI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (ior:DI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = GEN_INT (INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff));
  operands[4] = GEN_INT (INTVAL (operands[2]) & 0xffff);
}")

(define_expand "xordi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(xor:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && !logical_operand (operands[2], DImode))
    {
      HOST_WIDE_INT value = INTVAL (operands[2]);
      rtx tmp = ((reload_in_progress || reload_completed
		  || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (DImode));

      emit_insn (gen_xordi3 (tmp, operands[1],
			     GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
      emit_insn (gen_xordi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_insn "*xordi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r")
	(xor:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:DI 2 "logical_operand" "r,K,J")))]
  "TARGET_POWERPC64"
  "@
   xor %0,%1,%2
   xori %0,%1,%b2
   xoris %0,%1,%u2")

(define_insn "*xordi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (xor:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "xor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*xordi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (xor:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(xor:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "xor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an XOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
        (xor:DI (match_operand:DI 1 "gpc_reg_operand" "")
                (match_operand:DI 2 "non_logical_cint_operand" "")))]
  "TARGET_POWERPC64"
  [(set (match_dup 0) (xor:DI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (xor:DI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = GEN_INT (INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff));
  operands[4] = GEN_INT (INTVAL (operands[2]) & 0xffff);
}")

(define_insn "*eqvdi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(not:DI (xor:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
			(match_operand:DI 2 "gpc_reg_operand" "r"))))]
   "TARGET_POWERPC64"
   "eqv %0,%1,%2")

(define_insn "*eqvdi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (not:DI (xor:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
				    (match_operand:DI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
   "TARGET_POWERPC64"
   "eqv. %3,%1,%2"
   [(set_attr "type" "compare")])

(define_insn "*eqvdi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (not:DI (xor:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
				    (match_operand:DI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(not:DI (xor:DI (match_dup 1) (match_dup 2))))]
   "TARGET_POWERPC64"
   "eqv. %0,%1,%2"
   [(set_attr "type" "compare")])

(define_insn "*andcdi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
		(match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "andc %0,%2,%1")

(define_insn "*andcdi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "andc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*andcdi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (not:DI (match_dup 1)) (match_dup 2)))]
  "TARGET_POWERPC64"
  "andc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*iorcdi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ior:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
		(match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "orc %0,%2,%1")

(define_insn "*iorcdi3_inernal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "orc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*iorcdi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
			    (match_operand:DI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ior:DI (not:DI (match_dup 1)) (match_dup 2)))]
  "TARGET_POWERPC64"
  "orc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn "*nanddi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ior:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "%r"))
		(not:DI (match_operand:DI 2 "gpc_reg_operand" "r"))))]
  "TARGET_POWERPC64"
  "nand %0,%1,%2")

(define_insn "*nanddi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "%r"))
			    (not:DI (match_operand:DI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "nand. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*nanddi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "%r"))
			    (not:DI (match_operand:DI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ior:DI (not:DI (match_dup 1)) (not:DI (match_dup 2))))]
  "TARGET_POWERPC64"
  "nand. %0,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*nordi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "%r"))
		(not:DI (match_operand:DI 2 "gpc_reg_operand" "r"))))]
  "TARGET_POWERPC64"
  "nor %0,%1,%2")

(define_insn "*nordi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "%r"))
			    (not:DI (match_operand:DI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r"))]
  "TARGET_POWERPC64"
  "nor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn "*nordi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:DI (not:DI (match_operand:DI 1 "gpc_reg_operand" "%r"))
			    (not:DI (match_operand:DI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (not:DI (match_dup 1)) (not:DI (match_dup 2))))]
  "TARGET_POWERPC64"
  "nor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Now define ways of moving data around.

;; Elf specific ways of loading addresses for non-PIC code.
;; The output of this could be r0, but we limit it to base
;; registers, since almost all uses of this will need it
;; in a base register shortly.
(define_insn "elf_high"
  [(set (match_operand:SI 0 "register_operand" "=b")
	(high:SI (match_operand 1 "" "")))]
  "TARGET_ELF && !TARGET_64BIT"
  "{liu|lis} %0,%1@ha")

(define_insn "elf_low"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(lo_sum:SI (match_operand:SI 1 "register_operand" "b")
		   (match_operand 2 "" "")))]
   "TARGET_ELF && !TARGET_64BIT"
   "{cal|la} %0,%2@l(%1)")

;; Set up a register with a value from the GOT table

(define_expand "movsi_got"
  [(set (match_operand:SI 0 "register_operand" "")
	(unspec [(match_operand:SI 1 "got_operand" "")
		 (match_dup 2)] 8))]
  "(DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS) && flag_pic == 1"
  "
{
  if (GET_CODE (operands[1]) == CONST)
    {
      rtx offset = const0_rtx;
      HOST_WIDE_INT value;

      operands[1] = eliminate_constant_term (XEXP (operands[1], 0), &offset);
      value = INTVAL (offset);
      if (value != 0)
	{
	  rtx tmp = ((reload_in_progress || reload_completed)
		     ? operands[0]
		     : gen_reg_rtx (Pmode));
	  emit_insn (gen_movsi_got (tmp, operands[1]));
	  emit_insn (gen_addsi3 (operands[0], tmp, offset));
	  DONE;
	}
    }

  operands[2] = rs6000_got_register (operands[1]);
}")

(define_insn "*movsi_got_internal"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec [(match_operand:SI 1 "got_no_const_operand" "")
		 (match_operand:SI 2 "register_operand" "b")] 8))]
  "(DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS) && flag_pic == 1"
  "{l|lwz} %0,%a1@got(%2)"
  [(set_attr "type" "load")])

;; Sometimes, though, the GOT `register' will be on the stack. Deal with
;; this case specially.
;; Force final to split this insn (if it hasn't been split already) to
;; avoid having to create a suitable output template.
(define_insn "*movsi_got_internal_mem"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec [(match_operand:SI 1 "got_no_const_operand" "")
		 (match_operand:SI 2 "memory_operand" "m")] 8))]
  "(DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS)
    && flag_pic == 1
    && (reload_in_progress || reload_completed)"
  "#"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Used by sched, shorten_branches and final when the GOT pseudo reg
;; didn't get allocated to a hard register.
(define_split 
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec [(match_operand:SI 1 "got_no_const_operand" "")
		 (match_operand:SI 2 "memory_operand" "m")] 8))]
  "(DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS)
    && flag_pic == 1
    && (reload_in_progress || reload_completed)"
  [(set (match_dup 0) (match_dup 2))
   (set (match_dup 0) (unspec [(match_dup 1)(match_dup 0)] 8))]
  "")

;; For SI, we special-case integers that can't be loaded in one insn.  We
;; do the load 16-bits at a time.  We could do this by loading from memory,
;; and this is even supposed to be faster, but it is simpler not to get
;; integers in the TOC.
(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	(match_operand:SI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (SImode, operands[1]);

  /* Convert a move of a CONST_DOUBLE into a CONST_INT */
  if (GET_CODE (operands[1]) == CONST_DOUBLE)
    operands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));

  /* Use default pattern for address of ELF small data */
  if (TARGET_ELF
      && (DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS)
      && (GET_CODE (operands[1]) == SYMBOL_REF || GET_CODE (operands[1]) == CONST)
      && small_data_operand (operands[1], SImode))
    {
      emit_insn (gen_rtx_SET (VOIDmode, operands[0], operands[1]));
      DONE;
    }

  if ((DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS)
      && flag_pic == 1 && got_operand (operands[1], SImode))
    {
      emit_insn (gen_movsi_got (operands[0], operands[1]));
      DONE;
    }

  if (TARGET_ELF && TARGET_NO_TOC && !TARGET_64BIT
      && !flag_pic
      && CONSTANT_P (operands[1])
      && GET_CODE (operands[1]) != HIGH
      && GET_CODE (operands[1]) != CONST_INT
      && GET_CODE (operands[1]) != CONSTANT_P_RTX)
    {
      rtx target = (reload_completed || reload_in_progress)
			? operands[0] : gen_reg_rtx (SImode);

      /* If this is a function address on -mcall-aixdesc or -mcall-nt,
	 convert it to the address of the descriptor.  */
      if ((DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_NT)
	  && GET_CODE (operands[1]) == SYMBOL_REF
	  && XSTR (operands[1], 0)[0] == '.')
	{
	  char *name = XSTR (operands[1], 0);
	  rtx new_ref;
	  while (*name == '.')
	    name++;
	  new_ref = gen_rtx_SYMBOL_REF (Pmode, name);
	  CONSTANT_POOL_ADDRESS_P (new_ref) = CONSTANT_POOL_ADDRESS_P (operands[1]);
	  SYMBOL_REF_FLAG (new_ref) = SYMBOL_REF_FLAG (operands[1]);
	  SYMBOL_REF_USED (new_ref) = SYMBOL_REF_USED (operands[1]);
	  operands[1] = new_ref;
	}

      emit_insn (gen_elf_high (target, operands[1]));
      emit_insn (gen_elf_low (operands[0], target, operands[1]));
      DONE;
    }

  if (GET_CODE (operands[1]) == CONST
      && DEFAULT_ABI == ABI_NT
      && !side_effects_p (operands[0]))
    {
      rtx const_term = const0_rtx;
      rtx sym = eliminate_constant_term (XEXP (operands[1], 0), &const_term);
      if (sym && GET_CODE (const_term) == CONST_INT
	  && (GET_CODE (sym) == SYMBOL_REF || GET_CODE (sym) == LABEL_REF))
	{
	  unsigned HOST_WIDE_INT value = INTVAL (const_term);
	  int new_reg_p = (flag_expensive_optimizations
			   && !reload_completed
			   && !reload_in_progress);
	  rtx tmp1 = (new_reg_p && value != 0) ? gen_reg_rtx (SImode) : operands[0];

	  emit_insn (gen_movsi (tmp1, sym));
	  if (INTVAL (const_term) != 0)
	    emit_insn (gen_addsi3 (operands[0], tmp1, GEN_INT (value)));
	  DONE;
	}
      else
	rs6000_fatal_bad_address (operands[1]);
    }

  if ((!TARGET_WINDOWS_NT || DEFAULT_ABI != ABI_NT)
      && CONSTANT_P (operands[1])
      && GET_CODE (operands[1]) != CONST_INT
      && GET_CODE (operands[1]) != CONSTANT_P_RTX
      && GET_CODE (operands[1]) != HIGH
      && ! LEGITIMATE_CONSTANT_POOL_ADDRESS_P (operands[1]))
    {
      /* Emit a USE operation so that the constant isn't deleted if
	 expensive optimizations are turned on because nobody
	 references it.  This should only be done for operands that
	 contain SYMBOL_REFs with CONSTANT_POOL_ADDRESS_P set.
	 This should not be done for operands that contain LABEL_REFs.
	 For now, we just handle the obvious case.  */
      if (GET_CODE (operands[1]) != LABEL_REF)
	emit_insn (gen_rtx_USE (VOIDmode, operands[1]));

      /* If we are to limit the number of things we put in the TOC and
	 this is a symbol plus a constant we can add in one insn,
	 just put the symbol in the TOC and add the constant.  Don't do
	 this if reload is in progress.  */
      if (GET_CODE (operands[1]) == CONST
	  && TARGET_NO_SUM_IN_TOC && ! reload_in_progress
	  && GET_CODE (XEXP (operands[1], 0)) == PLUS
	  && add_operand (XEXP (XEXP (operands[1], 0), 1), SImode)
	  && (GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == LABEL_REF
	      || GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == SYMBOL_REF)
	  && ! side_effects_p (operands[0]))
	{
	  rtx sym = force_const_mem (SImode, XEXP (XEXP (operands[1], 0), 0));
	  rtx other = XEXP (XEXP (operands[1], 0), 1);

	  emit_insn (gen_addsi3 (operands[0], force_reg (SImode, sym), other));
	  DONE;
	}

      operands[1] = force_const_mem (SImode, operands[1]);
      if (! memory_address_p (SImode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], SImode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,r,r,m,r,r,r,r,r,*q,*c*l,*h")
	(match_operand:SI 1 "input_operand" "r,U,m,r,I,J,n,R,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], SImode)
   || gpc_reg_operand (operands[1], SImode)"
  "@
   mr %0,%1
   {cal|la} %0,%a1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%X0|stw%U0%X0} %1,%0
   {lil|li} %0,%1
   {liu|lis} %0,%v1
   #
   {cal|la} %0,%1(%*)
   mf%1 %0
   mt%0 %1
   mt%0 %1
   cror 0,0,0"
  [(set_attr "type" "*,*,load,store,*,*,*,*,*,*,mtjmpr,*")
   (set_attr "length" "4,4,4,4,4,4,8,4,4,4,4,4")])

;; Split a load of a large constant into the appropriate two-insn
;; sequence.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_operand:SI 1 "const_int_operand" ""))]
  "(unsigned HOST_WIDE_INT) (INTVAL (operands[1]) + 0x8000) >= 0x10000
   && (INTVAL (operands[1]) & 0xffff) != 0"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ior:SI (match_dup 0)
		(match_dup 3)))]
  "
{
  operands[2] = GEN_INT (INTVAL (operands[1]) & 0xffff0000);
  operands[3] = GEN_INT (INTVAL (operands[1]) & 0xffff);
}")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r") (match_dup 1))]
  ""
  "mr. %0,%1"
  [(set_attr "type" "compare")])

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_operand" "")
	(match_operand:HI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (HImode, operands[1]);

  if (CONSTANT_P (operands[1])
      && GET_CODE (operands[1]) != CONST_INT
      && GET_CODE (operands[1]) != CONSTANT_P_RTX)
    {
      operands[1] = force_const_mem (HImode, operands[1]);
      if (! memory_address_p (HImode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], HImode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn ""
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,r,m,r,r,*q,*c*l,*h")
	(match_operand:HI 1 "input_operand" "r,m,r,i,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], HImode)
   || gpc_reg_operand (operands[1], HImode)"
  "@
   mr %0,%1
   lhz%U1%X1 %0,%1
   sth%U0%X0 %1,%0
   {lil|li} %0,%w1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   cror 0,0,0"
  [(set_attr "type" "*,load,store,*,*,*,mtjmpr,*")])

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (QImode, operands[1]);

  if (CONSTANT_P (operands[1])
      && GET_CODE (operands[1]) != CONST_INT
      && GET_CODE (operands[1]) != CONSTANT_P_RTX)
    {
      operands[1] = force_const_mem (QImode, operands[1]);
      if (! memory_address_p (QImode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], QImode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn ""
  [(set (match_operand:QI 0 "nonimmediate_operand" "=r,r,m,r,r,*q,*c*l,*h")
	(match_operand:QI 1 "input_operand" "r,m,r,i,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], QImode)
   || gpc_reg_operand (operands[1], QImode)"
  "@
   mr %0,%1
   lbz%U1%X1 %0,%1
   stb%U0%X0 %1,%0
   {lil|li} %0,%1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   cror 0,0,0"
  [(set_attr "type" "*,load,store,*,*,*,mtjmpr,*")])

;; Here is how to move condition codes around.  When we store CC data in
;; an integer register or memory, we store just the high-order 4 bits.
;; This lets us not shift in the most common case of CR0.
(define_expand "movcc"
  [(set (match_operand:CC 0 "nonimmediate_operand" "")
	(match_operand:CC 1 "nonimmediate_operand" ""))]
  ""
  "")

(define_insn ""
  [(set (match_operand:CC 0 "nonimmediate_operand" "=y,x,y,r,r,r,r,m")
	(match_operand:CC 1 "nonimmediate_operand" "y,r,r,x,y,r,m,r"))]
  "register_operand (operands[0], CCmode)
   || register_operand (operands[1], CCmode)"
  "@
   mcrf %0,%1
   mtcrf 128,%1
   {rlinm|rlwinm} %1,%1,%F0,0xffffffff\;mtcrf %R0,%1\;{rlinm|rlwinm} %1,%1,%f0,0xffffffff
   mfcr %0
   mfcr %0\;{rlinm|rlwinm} %0,%0,%f1,0xf0000000
   mr %0,%1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%U1|stw%U0%U1} %1,%0"
  [(set_attr "type" "*,*,*,compare,*,*,load,store")
   (set_attr "length" "*,*,12,*,8,*,*,*")])

;; For floating-point, we normally deal with the floating-point registers
;; unless -msoft-float is used.  The sole exception is that parameter passing
;; can produce floating-point values in fixed-point registers.  Unless the
;; value is a simple constant or already in memory, we deal with this by
;; allocating memory and copying the value explicitly via that memory location.
(define_expand "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
	(match_operand:SF 1 "any_operand" ""))]
  ""
  "
{
  /* If we are called from reload, we might be getting a SUBREG of a hard
     reg.  So expand it.  */
  if (GET_CODE (operands[0]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[0])) == REG
      && REGNO (SUBREG_REG (operands[0])) < FIRST_PSEUDO_REGISTER)
    operands[0] = alter_subreg (operands[0]);
  if (GET_CODE (operands[1]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[1])) == REG
      && REGNO (SUBREG_REG (operands[1])) < FIRST_PSEUDO_REGISTER)
    operands[1] = alter_subreg (operands[1]);

  if (TARGET_SOFT_FLOAT && GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (SFmode, operands[1]);

  else if (TARGET_HARD_FLOAT)
    {
      if (! TARGET_POWERPC64
	  && GET_CODE (operands[1]) == REG && REGNO (operands[1]) < 32)
	{
	  /* If this is a store to memory or another integer register do the
	     move directly.  Otherwise store to a temporary stack slot and
	     load from there into a floating point register.  */

	  if (GET_CODE (operands[0]) == MEM
	      || (GET_CODE (operands[0]) == REG
		  && (REGNO (operands[0]) < 32
		      || (reload_in_progress
			  && REGNO (operands[0]) >= FIRST_PSEUDO_REGISTER))))
	    {
	      emit_move_insn (operand_subword (operands[0], 0, 0, SFmode),
			      operand_subword (operands[1], 0, 0, SFmode));
	      DONE;
	    }
	  else
	    {
	      rtx stack_slot = assign_stack_temp (SFmode, 4, 0);

	      emit_move_insn (stack_slot, operands[1]);
	      emit_move_insn (operands[0], stack_slot);
	      DONE;
	    }
	}

      if (GET_CODE (operands[0]) == MEM)
	{
	  /* If operands[1] is a register, it may have double-precision data
	     in it, so truncate it to single precision.  We need not do
	     this for POWERPC.  */
	  if (! TARGET_POWERPC && TARGET_HARD_FLOAT
	      && GET_CODE (operands[1]) == REG)
	    {
	      rtx newreg
		= reload_in_progress ? operands[1] : gen_reg_rtx (SFmode);
	      emit_insn (gen_aux_truncdfsf2 (newreg, operands[1]));
	      operands[1] = newreg;
	    }

	  operands[1] = force_reg (SFmode, operands[1]);
	}

      if (! TARGET_POWERPC64
	  && GET_CODE (operands[0]) == REG && REGNO (operands[0]) < 32)
	{
	  if (GET_CODE (operands[1]) == MEM
#if HOST_FLOAT_FORMAT == TARGET_FLOAT_FORMAT && ! defined(REAL_IS_NOT_DOUBLE)
	      || GET_CODE (operands[1]) == CONST_DOUBLE
#endif
	      || (GET_CODE (operands[1]) == REG
		  && (REGNO (operands[1]) < 32
		      || (reload_in_progress
			  && REGNO (operands[1]) >= FIRST_PSEUDO_REGISTER))))
	    {
	      emit_move_insn (operand_subword (operands[0], 0, 0, SFmode),
			      operand_subword (operands[1], 0, 0, SFmode));
	      DONE;
	    }
	  else
	    {
	      rtx stack_slot = assign_stack_temp (SFmode, 4, 0);

	      emit_move_insn (stack_slot, operands[1]);
	      emit_move_insn (operands[0], stack_slot);
	      DONE;
	    }
	}
    }

  if (CONSTANT_P (operands[1]) && TARGET_HARD_FLOAT)
    {
      operands[1] = force_const_mem (SFmode, operands[1]);
      if (! memory_address_p (SFmode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], SFmode,
				      XEXP (operands[1], 0));
    }
}")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(match_operand:SF 1 "const_double_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 3))]
  "
{
  long l;
  REAL_VALUE_TYPE rv;

  REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
  REAL_VALUE_TO_TARGET_SINGLE (rv, l);

  operands[2] = operand_subword (operands[0], 0, 0, SFmode);
  operands[3] = GEN_INT(l);
}")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(match_operand:SF 1 "const_double_operand" ""))]
  "TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 3))]
  "
{
  long l;
  REAL_VALUE_TYPE rv;

  REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
  REAL_VALUE_TO_TARGET_SINGLE (rv, l);

  operands[2] = gen_lowpart (SImode, operands[0]);
  operands[3] = GEN_INT(l);
}")

(define_insn "*movsf_hardfloat"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=f,f,m,!r,!r")
	(match_operand:SF 1 "input_operand" "f,m,f,G,Fn"))]
  "(gpc_reg_operand (operands[0], SFmode)
   || gpc_reg_operand (operands[1], SFmode)) && TARGET_HARD_FLOAT"
  "@
   fmr %0,%1
   lfs%U1%X1 %0,%1
   stfs%U0%X0 %1,%0
   #
   #"
  [(set_attr "type" "fp,fpload,fpstore,*,*")
   (set_attr "length" "4,4,4,4,8")])

(define_insn "*movsf_softfloat"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=r,r,m,r,r,r,r,r")
	(match_operand:SF 1 "input_operand" "r,m,r,I,J,R,G,Fn"))]
  "(gpc_reg_operand (operands[0], SFmode)
   || gpc_reg_operand (operands[1], SFmode)) && TARGET_SOFT_FLOAT"
  "@
   mr %0,%1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%X0|stw%U0%X0} %1,%0
   {lil|li} %0,%1
   {liu|lis} %0,%v1
   {cal|la} %0,%1(%*)
   #
   #"
  [(set_attr "type" "*,load,store,*,*,*,*,*")
   (set_attr "length" "4,4,4,4,4,4,4,8")])


(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (DFmode, operands[1]);

  if (CONSTANT_P (operands[1]) && ! easy_fp_constant (operands[1], DFmode))
    {
      operands[1] = force_const_mem (DFmode, operands[1]);
      if (! memory_address_p (DFmode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], DFmode,
				      XEXP (operands[1], 0));
    }
}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "const_int_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 1))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  operands[2] = operand_subword (operands[0], endian, 0, DFmode);
  operands[3] = operand_subword (operands[0], 1 - endian, 0, DFmode);
  operands[4] = (INTVAL (operands[1]) & 0x80000000) ? constm1_rtx : const0_rtx;
}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "const_double_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  long l[2];
  REAL_VALUE_TYPE rv;

  REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
  REAL_VALUE_TO_TARGET_DOUBLE (rv, l);

  operands[2] = operand_subword (operands[0], endian, 0, DFmode);
  operands[3] = operand_subword (operands[0], 1 - endian, 0, DFmode);
  operands[4] = GEN_INT (l[endian]);
  operands[5] = GEN_INT (l[1 - endian]);
}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "easy_fp_constant" ""))]
  "TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 3))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  long l[2];
  REAL_VALUE_TYPE rv;

  REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
  REAL_VALUE_TO_TARGET_DOUBLE (rv, l);

  operands[2] = gen_lowpart (DImode, operands[0]);
  /* HIGHPART is lower memory address when WORDS_BIG_ENDIAN.  */
  operands[3] = immed_double_const (l[1 - endian], l[endian], DImode);
}")

;; Don't have reload use general registers to load a constant.  First,
;; it might not work if the output operand is the equivalent of
;; a non-offsettable memref, but also it is less efficient than loading
;; the constant into an FP register, since it will probably be used there.
;; The "??" is a kludge until we can figure out a more reasonable way
;; of handling these non-offsettable values.
(define_insn "*movdf_hardfloat32"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=!r,??r,o,!r,!r,!r,f,f,m")
	(match_operand:DF 1 "input_operand" "r,o,r,G,H,F,f,m,f"))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
    case 2:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
    case 3:
    case 4:
    case 5:
      return \"#\";
    case 6:
      return \"fmr %0,%1\";
    case 7:
      return \"lfd%U1%X1 %0,%1\";
    case 8:
      return \"stfd%U0%X0 %1,%0\";
    }
}"
  [(set_attr "type" "*,load,store,*,*,*,fp,fpload,fpstore")
   (set_attr "length" "8,8,8,8,12,16,*,*,*")])

(define_insn "*movdf_softfloat32"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=r,r,m,r,r,r")
	(match_operand:DF 1 "input_operand" "r,m,r,G,H,F"))]
  "! TARGET_POWERPC64 && TARGET_SOFT_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
    case 2:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
    case 3:
    case 4:
    case 5:
      return \"#\";
    }
}"
  [(set_attr "type" "*,load,store,*,*,*")
   (set_attr "length" "8,8,8,8,12,16")])

(define_insn "*movdf_hardfloat64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=!r,??r,m,!r,!r,!r,f,f,m")
	(match_operand:DF 1 "input_operand" "r,m,r,G,H,F,f,m,f"))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "@
   mr %0,%1
   ld%U1%X1 %0,%1
   std%U0%X0 %1,%0
   #
   #
   #
   fmr %0,%1
   lfd%U1%X1 %0,%1
   stfd%U0%X0 %1,%0"
  [(set_attr "type" "*,load,store,*,*,*,fp,fpload,fpstore")
   (set_attr "length" "4,4,4,8,12,16,4,4,4")])

(define_insn "*movdf_softfloat64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=r,r,m,r,r,r")
	(match_operand:DF 1 "input_operand" "r,m,r,G,H,F"))]
  "TARGET_POWERPC64 && TARGET_SOFT_FLOAT
   && (register_operand (operands[0], DFmode)
       || register_operand (operands[1], DFmode))"
  "@
   mr %0,%1
   ld%U1%X1 %0,%1
   std%U0%X0 %1,%0
   #
   #
   #"
  [(set_attr "type" "*,load,store,*,*,*")
   (set_attr "length" "*,*,*,8,12,16")])

;; Next come the multi-word integer load and store and the load and store
;; multiple insns.
(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
	(match_operand:DI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (DImode, operands[1]);

  /* Convert a move of a CONST_DOUBLE into a CONST_INT
     only if sign-extended lower-half for 32-bit host.  */
  if (GET_CODE (operands[1]) == CONST_DOUBLE
#if HOST_BITS_PER_WIDE_INT == 32
      && ((CONST_DOUBLE_HIGH (operands[1]) == 0
	   && (CONST_DOUBLE_LOW (operands[1]) & 0x80000000) == 0)
	  || (CONST_DOUBLE_HIGH (operands[1]) == 0xffffffff
	      && (CONST_DOUBLE_LOW (operands[1]) & 0x80000000) != 0))
#endif
	 )
    operands[1] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));

  if (TARGET_64BIT
      && CONSTANT_P (operands[1])
#if HOST_BITS_PER_WIDE_INT == 32
      && GET_CODE (operands[1]) != CONST_INT
      && GET_CODE (operands[1]) != CONSTANT_P_RTX
#endif
      && ! easy_fp_constant (operands[1], DImode)
      && ! LEGITIMATE_CONSTANT_POOL_ADDRESS_P (operands[1]))
    {
      /* Emit a USE operation so that the constant isn't deleted if
	 expensive optimizations are turned on because nobody
	 references it.  This should only be done for operands that
	 contain SYMBOL_REFs with CONSTANT_POOL_ADDRESS_P set.
	 This should not be done for operands that contain LABEL_REFs.
	 For now, we just handle the obvious case.  */
      if (GET_CODE (operands[1]) != LABEL_REF)
	emit_insn (gen_rtx_USE (VOIDmode, operands[1]));

      /* If we are to limit the number of things we put in the TOC and
	 this is a symbol plus a constant we can add in one insn,
	 just put the symbol in the TOC and add the constant.  Don't do
	 this if reload is in progress.  */
      if (GET_CODE (operands[1]) == CONST
	  && TARGET_NO_SUM_IN_TOC && ! reload_in_progress
	  && GET_CODE (XEXP (operands[1], 0)) == PLUS
	  && add_operand (XEXP (XEXP (operands[1], 0), 1), DImode)
	  && (GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == LABEL_REF
	      || GET_CODE (XEXP (XEXP (operands[1], 0), 0)) == SYMBOL_REF)
	  && ! side_effects_p (operands[0]))
	{
	  rtx sym = force_const_mem (DImode, XEXP (XEXP (operands[1], 0), 0));
	  rtx other = XEXP (XEXP (operands[1], 0), 1);

	  emit_insn (gen_adddi3 (operands[0], force_reg (DImode, sym), other));
	  DONE;
	}

      operands[1] = force_const_mem (DImode, operands[1]);
      if (! memory_address_p (DImode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], DImode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn "*movdi_32"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,m,f,f,m,r,r,r,r,r")
	(match_operand:DI 1 "input_operand" "r,m,r,f,m,f,IJK,n,G,H,F"))]
  "! TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], DImode)
       || gpc_reg_operand (operands[1], DImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
    case 2:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
    case 3:
      return \"fmr %0,%1\";
    case 4:
      return \"lfd%U1%X1 %0,%1\";
    case 5:
      return \"stfd%U0%X0 %1,%0\";
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return \"#\";
    }
}"
  [(set_attr "type" "*,load,store,fp,fpload,fpstore,*,*,*,*,*")
   (set_attr "length" "8,8,8,*,*,*,8,12,8,12,16")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_int_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 1))]
  "
{
  operands[2] = gen_rtx_SUBREG (SImode, operands[0], WORDS_BIG_ENDIAN == 0);
  operands[3] = gen_rtx_SUBREG (SImode, operands[0], WORDS_BIG_ENDIAN != 0);
  operands[4] = (INTVAL (operands[1]) & 0x80000000) ? constm1_rtx : const0_rtx;
}")

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_double_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
  "
{
  operands[2] = gen_rtx_SUBREG (SImode, operands[0], WORDS_BIG_ENDIAN == 0);
  operands[3] = gen_rtx_SUBREG (SImode, operands[0], WORDS_BIG_ENDIAN != 0);
  operands[4] = GEN_INT (CONST_DOUBLE_HIGH (operands[1]));
  operands[5] = GEN_INT (CONST_DOUBLE_LOW  (operands[1]));
}")

(define_insn "*movdi_64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,m,r,r,r,r,f,f,m,r,*h,*h")
	(match_operand:DI 1 "input_operand" "r,m,r,I,J,nF,R,f,m,f,*h,r,0"))]
  "TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], DImode)
       || gpc_reg_operand (operands[1], DImode))"
  "@
   mr %0,%1
   ld%U1%X1 %0,%1
   std%U0%X0 %1,%0
   li %0,%1
   lis %0,%v1
   #
   {cal|la} %0,%1(%*)
   fmr %0,%1
   lfd%U1%X1 %0,%1
   stfd%U0%X0 %1,%0
   mf%1 %0
   mt%0 %1
   cror 0,0,0"
  [(set_attr "type" "*,load,store,*,*,*,*,fp,fpload,fpstore,*,mtjmpr,*")
   (set_attr "length" "4,4,4,4,4,20,4,4,4,4,4,4,4")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(match_operand:DI 1 "const_double_operand" "F"))]
  "TARGET_POWERPC64 && GET_CODE (operands[1]) == CONST_DOUBLE
   && num_insns_constant (operands[1], DImode) == 1"
  "*
{
  return ((unsigned HOST_WIDE_INT)
	  (CONST_DOUBLE_LOW (operands[1]) + 0x8000) < 0x10000)
	 ? \"li %0,%1\" : \"lis %0,%v1\";
}")

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_int_operand" ""))]
  "HOST_BITS_PER_WIDE_INT == 32 && TARGET_POWERPC64
   && num_insns_constant (operands[1], DImode) > 1"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ior:DI (match_dup 0)
		(match_dup 3)))]
  "
{
  operands[2] = GEN_INT (INTVAL (operands[1]) & 0xffff0000);
  operands[3] = GEN_INT (INTVAL (operands[1]) & 0xffff);
}")

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_double_operand" ""))]
  "HOST_BITS_PER_WIDE_INT == 32 && TARGET_POWERPC64
   && GET_CODE (operands[1]) == CONST_DOUBLE
   && ((CONST_DOUBLE_HIGH (operands[1]) == 0
        && (CONST_DOUBLE_LOW (operands[1]) & 0x80000000) == 0)
       || (CONST_DOUBLE_HIGH (operands[1]) == 0xffffffff
           && (CONST_DOUBLE_LOW (operands[1]) & 0x80000000) != 0))"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ior:DI (match_dup 0)
		(match_dup 3)))]
  "
{
  operands[2] = GEN_INT (CONST_DOUBLE_LOW (operands[1]) & 0xffff0000);
  operands[3] = GEN_INT (CONST_DOUBLE_LOW (operands[1]) & 0xffff);
}")

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_double_operand" ""))]
  "HOST_BITS_PER_WIDE_INT == 32 && TARGET_POWERPC64
   && GET_CODE (operands[1]) == CONST_DOUBLE
   && CONST_DOUBLE_HIGH (operands[1]) == 0
   && (CONST_DOUBLE_LOW (operands[1]) & 0x80000000) != 0"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(zero_extend:DI (subreg:SI (match_dup 0) 0)))]
  "
{ operands[2] = GEN_INT (CONST_DOUBLE_LOW (operands[1])); }")

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_double_operand" ""))]
  "HOST_BITS_PER_WIDE_INT == 32 && TARGET_POWERPC64
   && GET_CODE (operands[1]) == CONST_DOUBLE
   && CONST_DOUBLE_LOW (operands[1]) == 0"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ashift:DI (match_dup 0)
		   (const_int 32)))]
  "
{ operands[2] = GEN_INT (CONST_DOUBLE_HIGH (operands[1])); }")

;; Generate all one-bits and clear left or right.
;; Use (and:DI (rotate:DI ...)) to avoid anddi3 unnecessary clobber.
(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "mask64_operand" ""))]
  "TARGET_POWERPC64 && num_insns_constant (operands[1], DImode) > 1"
  [(set (match_dup 0) (const_int -1))
   (set (match_dup 0)
	(and:DI (rotate:DI (match_dup 0)
			   (const_int 0))
		(match_dup 1)))]
  "")

;; Split a load of a large constant into the appropriate five-instruction
;; sequence.  Handle anything in a constant number of insns.
;; When non-easy constants can go in the TOC, this should use
;; easy_fp_constant predicate.
(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_double_operand" ""))]
  "TARGET_POWERPC64 && num_insns_constant (operands[1], DImode) > 1"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ashift:DI (match_dup 0)
		   (const_int 32)))
   (set (match_dup 0)
	(ior:DI (match_dup 0)
		(match_dup 3)))]
  "
{
  HOST_WIDE_INT low;
  HOST_WIDE_INT high;

  if (GET_CODE (operands[1]) == CONST_DOUBLE)
    {
      low = CONST_DOUBLE_LOW (operands[1]);
      high = CONST_DOUBLE_HIGH (operands[1]);
    }
  else
#if HOST_BITS_PER_WIDE_INT == 32
    {
      low = INTVAL (operands[1]);
      high = (low < 0) ? ~0 : 0;
    }
#else
    {
      low = INTVAL (operands[1]) & 0xffffffff;
      high = (HOST_WIDE_INT) INTVAL (operands[1]) >> 32;
    }
#endif

  operands[2] = GEN_INT (high);
  operands[3] = GEN_INT (low);
}")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (match_operand:DI 1 "gpc_reg_operand" "r")
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r") (match_dup 1))]
  "TARGET_POWERPC64"
  "mr. %0,%1"
  [(set_attr "type" "compare")])

;; TImode is similar, except that we usually want to compute the address into
;; a register and use lsi/stsi (the exception is during reload).  MQ is also
;; clobbered in stsi for POWER, so we need a SCRATCH for it.
(define_expand "movti"
  [(parallel [(set (match_operand:TI 0 "general_operand" "")
		   (match_operand:TI 1 "general_operand" ""))
	      (clobber (scratch:SI))])]
  "TARGET_STRING || TARGET_POWERPC64"
  "
{
  if (GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (TImode, operands[1]);

  if (GET_CODE (operands[0]) == MEM
      && GET_CODE (XEXP (operands[0], 0)) != REG
      && ! reload_in_progress)
    operands[0] = change_address (operands[0], TImode,
				  copy_addr_to_reg (XEXP (operands[0], 0)));

  if (GET_CODE (operands[1]) == MEM
      && GET_CODE (XEXP (operands[1], 0)) != REG
      && ! reload_in_progress)
    operands[1] = change_address (operands[1], TImode,
				  copy_addr_to_reg (XEXP (operands[1], 0)));
}")

;; We say that MQ is clobbered in the last alternative because the first
;; alternative would never get used otherwise since it would need a reload
;; while the 2nd alternative would not.  We put memory cases first so they
;; are preferred.  Otherwise, we'd try to reload the output instead of
;; giving the SCRATCH mq.
(define_insn "*movti_power"
  [(set (match_operand:TI 0 "reg_or_mem_operand" "=Q,m,????r,????r,????r")
	(match_operand:TI 1 "reg_or_mem_operand" "r,r,r,Q,m"))
   (clobber (match_scratch:SI 2 "=q,q#X,X,X,X"))]
  "TARGET_STRING && TARGET_POWER && ! TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], TImode) || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();

    case 0:
      return \"{stsi|stswi} %1,%P0,16\";

    case 1:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\;{st|stw} %Y1,%Y0\;{st|stw} %Z1,%Z0\";

    case 2:
      /* Normally copy registers with lowest numbered register copied first.
	 But copy in the other order if the first register of the output
	 is the second, third, or fourth register in the input.  */
      if (REGNO (operands[0]) >= REGNO (operands[1]) + 1
	  && REGNO (operands[0]) <= REGNO (operands[1]) + 3)
	return \"mr %Z0,%Z1\;mr %Y0,%Y1\;mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\;mr %Y0,%Y1\;mr %Z0,%Z1\";
    case 3:
      /* If the address is not used in the output, we can use lsi.  Otherwise,
	 fall through to generating four loads.  */
      if (! reg_overlap_mentioned_p (operands[0], operands[1]))
	return \"{lsi|lswi} %0,%P1,16\";
      /* ... fall through ... */
    case 4:
      /* If the address register is the same as the register for the lowest-
	 addressed word, load it last.  Similarly for the next two words.
	 Otherwise load lowest address to highest.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands[1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %0,%1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 1,
				  REGNO (operands[0]) + 2, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %L0,%L1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 2,
				  REGNO (operands[0]) + 3, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Z0,%Z1\;{l|lwz} %Y0,%Y1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\";
    }
}"
  [(set_attr "type" "store,store,*,load,load")
   (set_attr "length" "*,16,16,*,16")])

(define_insn "*movti_string"
  [(set (match_operand:TI 0 "reg_or_mem_operand" "=m,????r,????r")
	(match_operand:TI 1 "reg_or_mem_operand" "r,r,m"))
   (clobber (match_scratch:SI 2 "=X,X,X"))]
  "TARGET_STRING && !TARGET_POWER && ! TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], TImode) || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();

    case 0:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\;{st|stw} %Y1,%Y0\;{st|stw} %Z1,%Z0\";

    case 1:
      /* Normally copy registers with lowest numbered register copied first.
	 But copy in the other order if the first register of the output
	 is the second, third, or fourth register in the input.  */
      if (REGNO (operands[0]) >= REGNO (operands[1]) + 1
	  && REGNO (operands[0]) <= REGNO (operands[1]) + 3)
	return \"mr %Z0,%Z1\;mr %Y0,%Y1\;mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\;mr %Y0,%Y1\;mr %Z0,%Z1\";
    case 2:
      /* If the address register is the same as the register for the lowest-
	 addressed word, load it last.  Similarly for the next two words.
	 Otherwise load lowest address to highest.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands[1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %0,%1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 1,
				  REGNO (operands[0]) + 2, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\;{l|lwz} %L0,%L1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 2,
				  REGNO (operands[0]) + 3, operands[1], 0))
	return \"{l|lwz} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Z0,%Z1\;{l|lwz} %Y0,%Y1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\;{l|lwz} %Y0,%Y1\;{l|lwz} %Z0,%Z1\";
    }
}"
  [(set_attr "type" "store,*,load")
   (set_attr "length" "16,16,16")])

(define_insn "*movti_ppc64"
  [(set (match_operand:TI 0 "nonimmediate_operand" "=r,r,m")
	(match_operand:TI 1 "input_operand" "r,m,r"))]
  "TARGET_POWERPC64 && (gpc_reg_operand (operands[0], TImode)
   || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"ld %L0,%L1\;ld %0,%1\";
      else
	return \"ld%U1 %0,%1\;ld %L0,%L1\";
    case 2:
      return \"std%U0 %1,%0\;std %L1,%L0\";
    }
}"
  [(set_attr "type" "*,load,store")
   (set_attr "length" "8,8,8")])

(define_expand "load_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (use (match_operand:SI 2 "" ""))])]
  "TARGET_STRING"
  "
{
  int regno;
  int count;
  rtx from;
  int i;

  /* Support only loading a constant number of fixed-point registers from
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[1]) != MEM
      || GET_CODE (operands[0]) != REG
      || REGNO (operands[0]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[0]);

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count));
  from = force_reg (SImode, XEXP (operands[1], 0));

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx_SET (VOIDmode, gen_rtx_REG (SImode, regno + i),
		 change_address (operands[1], SImode,
				 plus_constant (from, i * 4)));
}")

(define_insn ""
  [(match_parallel 0 "load_multiple_operation"
		   [(set (match_operand:SI 1 "gpc_reg_operand" "=r")
			 (mem:SI (match_operand:SI 2 "register_operand" "b")))])]
  "TARGET_STRING"
  "*
{
  /* We have to handle the case where the pseudo used to contain the address
     is assigned to one of the output registers.  */
  int i, j;
  int words = XVECLEN (operands[0], 0);
  rtx xop[10];

  if (XVECLEN (operands[0], 0) == 1)
    return \"{l|lwz} %1,0(%2)\";

  for (i = 0; i < words; i++)
    if (refers_to_regno_p (REGNO (operands[1]) + i,
			   REGNO (operands[1]) + i + 1, operands[2], 0))
      {
	if (i == words-1)
	  {
	    xop[0] = operands[1];
	    xop[1] = operands[2];
	    xop[2] = GEN_INT (4 * (words-1));
	    output_asm_insn (\"{lsi|lswi} %0,%1,%2\;{l|lwz} %1,%2(%1)\", xop);
	    return \"\";
	  }
	else if (i == 0)
	  {
	    xop[0] = operands[1];
	    xop[1] = gen_rtx_REG (SImode, REGNO (operands[1]) + 1);
	    xop[2] = GEN_INT (4 * (words-1));
	    output_asm_insn (\"{cal %0,4(%0)|addi %0,%0,4}\;{lsi|lswi} %1,%0,%2\;{l|lwz} %0,-4(%0)\", xop);
	    return \"\";
	  }
	else
	  {
	    for (j = 0; j < words; j++)
	      if (j != i)
		{
		  xop[0] = gen_rtx_REG (SImode, REGNO (operands[1]) + j);
		  xop[1] = operands[2];
		  xop[2] = GEN_INT (j * 4);
		  output_asm_insn (\"{l|lwz} %0,%2(%1)\", xop);
		}
	    xop[0] = operands[2];
	    xop[1] = GEN_INT (i * 4);
	    output_asm_insn (\"{l|lwz} %0,%1(%0)\", xop);
	    return \"\";
	  }
      }

  return \"{lsi|lswi} %1,%2,%N0\";
}"
  [(set_attr "type" "load")
   (set_attr "length" "32")])


(define_expand "store_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (clobber (scratch:SI))
		     (use (match_operand:SI 2 "" ""))])]
  "TARGET_STRING"
  "
{
  int regno;
  int count;
  rtx to;
  int i;

  /* Support only storing a constant number of fixed-point registers to
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[0]) != MEM
      || GET_CODE (operands[1]) != REG
      || REGNO (operands[1]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[1]);

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count + 1));
  to = force_reg (SImode, XEXP (operands[0], 0));

  XVECEXP (operands[3], 0, 0)
    = gen_rtx_SET (VOIDmode, change_address (operands[0], SImode, to),
	       operands[1]);
  XVECEXP (operands[3], 0, 1) = gen_rtx_CLOBBER (VOIDmode,
						  gen_rtx_SCRATCH (SImode));

  for (i = 1; i < count; i++)
    XVECEXP (operands[3], 0, i + 1)
      = gen_rtx_SET (VOIDmode,
		 change_address (operands[0], SImode,
				 plus_constant (to, i * 4)),
		 gen_rtx_REG (SImode, regno + i));
}")

(define_insn ""
  [(match_parallel 0 "store_multiple_operation"
		   [(set (match_operand:SI 1 "indirect_operand" "=Q")
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (clobber (match_scratch:SI 3 "=q"))])]
  "TARGET_STRING && TARGET_POWER"
  "{stsi|stswi} %2,%P1,%O0"
  [(set_attr "type" "store")])

(define_insn ""
  [(match_parallel 0 "store_multiple_operation"
		   [(set (mem:SI (match_operand:SI 1 "register_operand" "b"))
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (clobber (match_scratch:SI 3 "X"))])]
  "TARGET_STRING && !TARGET_POWER"
  "{stsi|stswi} %2,%1,%O0"
  [(set_attr "type" "store")])


;; String/block move insn.
;; Argument 0 is the destination
;; Argument 1 is the source
;; Argument 2 is the length
;; Argument 3 is the alignment

(define_expand "movstrsi"
  [(parallel [(set (match_operand:BLK 0 "" "")
		   (match_operand:BLK 1 "" ""))
	      (use (match_operand:SI 2 "" ""))
	      (use (match_operand:SI 3 "" ""))])]
  ""
  "
{
  if (expand_block_move (operands))
    DONE;
  else
    FAIL;
}")

;; Move up to 32 bytes at a time.  The fixed registers are needed because the
;; register allocator doesn't have a clue about allocating 8 word registers
(define_expand "movstrsi_8reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (reg:SI  5))
	      (clobber (reg:SI  6))
	      (clobber (reg:SI  7))
	      (clobber (reg:SI  8))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (reg:SI 11))
	      (clobber (reg:SI 12))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && ((INTVAL (operands[2]) > 24 && INTVAL (operands[2]) < 32) || INTVAL (operands[2]) == 0)
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && ((INTVAL (operands[2]) > 24 && INTVAL (operands[2]) < 32) || INTVAL (operands[2]) == 0)
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 24 bytes at a time.  The fixed registers are needed because the
;; register allocator doesn't have a clue about allocating 6 word registers
(define_expand "movstrsi_6reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (reg:SI  7))
	      (clobber (reg:SI  8))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (reg:SI 11))
	      (clobber (reg:SI 12))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 16 && INTVAL (operands[2]) <= 24
   && (REGNO (operands[0]) < 7 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 7 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 7"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && INTVAL (operands[2]) > 16 && INTVAL (operands[2]) <= 32
   && (REGNO (operands[0]) < 7 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 7 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 7"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 16 bytes at a time, using 4 fixed registers to avoid spill problems
;; with TImode
(define_expand "movstrsi_4reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (reg:SI 11))
	      (clobber (reg:SI 12))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 8 && INTVAL (operands[2]) <= 16
   && (REGNO (operands[0]) < 9 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 9 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 9"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "register_operand" "=r"))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && INTVAL (operands[2]) > 8 && INTVAL (operands[2]) <= 16
   && (REGNO (operands[0]) < 9 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 9 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 9"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 8 bytes at a time.
(define_expand "movstrsi_2reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (match_scratch:DI 4 ""))
	      (clobber (match_scratch:SI 5 ""))])]
  "TARGET_STRING && !TARGET_64BIT"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:DI 4 "=&r"))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER && !TARGET_64BIT
   && INTVAL (operands[2]) > 4 && INTVAL (operands[2]) <= 8"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:DI 4 "=&r"))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER && !TARGET_64BIT
   && INTVAL (operands[2]) > 4 && INTVAL (operands[2]) <= 8"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 4 bytes at a time.
(define_expand "movstrsi_1reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (match_scratch:SI 4 ""))
	      (clobber (match_scratch:SI 5 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:SI 4 "=&r"))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) <= 4"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "register_operand" "b"))
	(mem:BLK (match_operand:SI 1 "register_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:SI 4 "=&r"))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && !TARGET_POWER
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) <= 4"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])


;; Define insns that do load or store with update.  Some of these we can
;; get by using pre-decrement or pre-increment, but the hardware can also
;; do cases where the increment is not the size of the object.
;;
;; In all these cases, we use operands 0 and 1 for the register being
;; incremented because those are the operands that local-alloc will
;; tie and these are the pair most likely to be tieable (and the ones
;; that will benefit the most).

(define_insn "*movdi_update1"
  [(set (match_operand:DI 3 "gpc_reg_operand" "=r,r")
	(mem:DI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0,0")
			 (match_operand:DI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b,b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && TARGET_UPDATE"
  "@
   ldux %3,%0,%2
   ldu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "*movdi_update2"
  [(set (match_operand:DI 3 "gpc_reg_operand" "=r")
	(sign_extend:DI
	 (mem:SI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0")
			  (match_operand:DI 2 "gpc_reg_operand" "r")))))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "lwaux %3,%0,%2"
  [(set_attr "type" "load")])

(define_insn "movdi_update"
  [(set (mem:DI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0,0")
			 (match_operand:DI 2 "reg_or_short_operand" "r,I")))
	(match_operand:DI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b,b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && TARGET_UPDATE"
  "@
   stdux %3,%0,%2
   stdu %3,%2(%0)"
  [(set_attr "type" "store")])

(define_insn "*movsi_update1"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {lux|lwzux} %3,%0,%2
   {lu|lwzu} %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "movsi_update"
  [(set (mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   {stux|stwux} %3,%0,%2
   {stu|stwu} %3,%2(%0)"
  [(set_attr "type" "store")])

(define_insn "*movhi_update"
  [(set (match_operand:HI 3 "gpc_reg_operand" "=r,r")
	(mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "*movhi_update2"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "*movhi_update3"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(sign_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lhaux %3,%0,%2
   lhau %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "*movhi_update4"
  [(set (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:HI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   sthux %3,%0,%2
   sthu %3,%2(%0)"
  [(set_attr "type" "store")])

(define_insn "*movqi_update1"
  [(set (match_operand:QI 3 "gpc_reg_operand" "=r,r")
	(mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "*movqi_update2"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "*movqi_update3"
  [(set (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:QI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   stbux %3,%0,%2
   stbu %3,%2(%0)"
  [(set_attr "type" "store")])

(define_insn "*movsf_update1"
  [(set (match_operand:SF 3 "gpc_reg_operand" "=f,f")
	(mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_UPDATE"
  "@
   lfsux %3,%0,%2
   lfsu %3,%2(%0)"
  [(set_attr "type" "fpload")])

(define_insn "*movsf_update2"
  [(set (mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_UPDATE"
  "@
   stfsux %3,%0,%2
   stfsu %3,%2(%0)"
  [(set_attr "type" "fpstore")])

(define_insn "*movsf_update3"
  [(set (match_operand:SF 3 "gpc_reg_operand" "=r,r")
	(mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_SOFT_FLOAT && TARGET_UPDATE"
  "@
   {lux|lwzux} %3,%0,%2
   {lu|lwzu} %3,%2(%0)"
  [(set_attr "type" "load")])

(define_insn "*movsf_update4"
  [(set (mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SF 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_SOFT_FLOAT && TARGET_UPDATE"
  "@
   {stux|stwux} %3,%0,%2
   {stu|stwu} %3,%2(%0)"
  [(set_attr "type" "store")])

(define_insn "*movdf_update1"
  [(set (match_operand:DF 3 "gpc_reg_operand" "=f,f")
	(mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_UPDATE"
  "@
   lfdux %3,%0,%2
   lfdu %3,%2(%0)"
  [(set_attr "type" "fpload")])

(define_insn "*movdf_update2"
  [(set (mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:DF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_UPDATE"
  "@
   stfdux %3,%0,%2
   stfdu %3,%2(%0)"
  [(set_attr "type" "fpstore")])

;; Peephole to convert two consecutive FP loads or stores into lfq/stfq.

(define_peephole
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(match_operand:DF 1 "memory_operand" ""))
   (set (match_operand:DF 2 "gpc_reg_operand" "=f")
	(match_operand:DF 3 "memory_operand" ""))]
  "TARGET_POWER2
   && TARGET_HARD_FLOAT
   && registers_ok_for_quad_peep (operands[0], operands[2])
   && ! MEM_VOLATILE_P (operands[1]) && ! MEM_VOLATILE_P (operands[3])
   && addrs_ok_for_quad_peep (XEXP (operands[1], 0), XEXP (operands[3], 0))"
  "lfq%U1%X1 %0,%1")

(define_peephole
  [(set (match_operand:DF 0 "memory_operand" "")
	(match_operand:DF 1 "gpc_reg_operand" "f"))
   (set (match_operand:DF 2 "memory_operand" "")
	(match_operand:DF 3 "gpc_reg_operand" "f"))]
  "TARGET_POWER2
   && TARGET_HARD_FLOAT
   && registers_ok_for_quad_peep (operands[1], operands[3])
   && ! MEM_VOLATILE_P (operands[0]) && ! MEM_VOLATILE_P (operands[2])
   && addrs_ok_for_quad_peep (XEXP (operands[0], 0), XEXP (operands[2], 0))"
  "stfq%U0%X0 %1,%0")

;; Next come insns related to the calling sequence.
;;
;; First, an insn to allocate new stack space for dynamic use (e.g., alloca).
;; We move the back-chain and decrement the stack pointer.

(define_expand "allocate_stack"
  [(set (match_operand 0 "register_operand" "=r")
	(minus (reg 1) (match_operand 1 "reg_or_short_operand" "")))
   (set (reg 1)
	(minus (reg 1) (match_dup 1)))]
  ""
  "
{ rtx chain = gen_reg_rtx (Pmode);
  rtx stack_bot = gen_rtx_MEM (Pmode, stack_pointer_rtx);
  rtx neg_op0;

  emit_move_insn (chain, stack_bot);

  /* Under Windows NT, we need to add stack probes for large/variable
     allocations, so do it via a call to the external function alloca
     instead of doing it inline.  */
  if (DEFAULT_ABI == ABI_NT
      && (GET_CODE (operands[1]) != CONST_INT || INTVAL (operands[1]) > 4096))
    {
      rtx tmp = gen_reg_rtx (Pmode);
      emit_library_call_value (gen_rtx_SYMBOL_REF (Pmode, \"__allocate_stack\"),
			       tmp, 0, Pmode, 1, operands[1], Pmode);
      emit_insn (gen_set_sp (tmp));
      emit_move_insn (operands[0], tmp);
      DONE;
    }

  if (GET_CODE (operands[1]) != CONST_INT
      || INTVAL (operands[1]) < -32767
      || INTVAL (operands[1]) > 32768)
    {
      neg_op0 = gen_reg_rtx (Pmode);
      if (TARGET_32BIT)
	emit_insn (gen_negsi2 (neg_op0, operands[1]));
      else
	emit_insn (gen_negdi2 (neg_op0, operands[1]));
    }
  else
    neg_op0 = GEN_INT (- INTVAL (operands[1]));

  if (TARGET_UPDATE)
    emit_insn ((* ((TARGET_32BIT) ? gen_movsi_update : gen_movdi_update))
		(stack_pointer_rtx, stack_pointer_rtx, neg_op0, chain));

  else
    {
      emit_insn ((* ((TARGET_32BIT) ? gen_addsi3 : gen_adddi3))
		 (stack_pointer_rtx, stack_pointer_rtx, neg_op0));
      emit_move_insn (gen_rtx_MEM (Pmode, stack_pointer_rtx), chain);
    }

  emit_move_insn (operands[0], virtual_stack_dynamic_rtx);
  DONE;
}")

;; Marker to indicate that the stack pointer was changed under NT in
;; ways not known to the compiler

(define_insn "set_sp"
  [(set (reg:SI 1)
	(unspec [(match_operand:SI 0 "register_operand" "r")] 7))]
  ""
  ""
  [(set_attr "length" "0")])

;; These patterns say how to save and restore the stack pointer.  We need not
;; save the stack pointer at function level since we are careful to
;; preserve the backchain.  At block level, we have to restore the backchain
;; when we restore the stack pointer.
;;
;; For nonlocal gotos, we must save both the stack pointer and its
;; backchain and restore both.  Note that in the nonlocal case, the
;; save area is a memory location.

(define_expand "save_stack_function"
  [(use (const_int 0))]
  ""
  "")

(define_expand "restore_stack_function"
  [(use (const_int 0))]
  ""
  "")

(define_expand "restore_stack_block"
  [(use (match_operand 0 "register_operand" ""))
   (set (match_dup 2) (match_dup 3))
   (set (match_dup 0) (match_operand 1 "register_operand" ""))
   (set (match_dup 3) (match_dup 2))]
  ""
  "
{
  operands[2] = gen_reg_rtx (Pmode);
  operands[3] = gen_rtx_MEM (Pmode, operands[0]);
}")

(define_expand "save_stack_nonlocal"
  [(match_operand 0 "memory_operand" "")
   (match_operand 1 "register_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (Pmode);

  /* Copy the backchain to the first word, sp to the second.  */
  emit_move_insn (temp, gen_rtx_MEM (Pmode, operands[1]));
  emit_move_insn (operand_subword (operands[0], 0, 0, (TARGET_32BIT ? DImode : TImode)),
		  temp);
  emit_move_insn (operand_subword (operands[0], 1, 0, (TARGET_32BIT ? DImode : TImode)),
		  operands[1]);
  DONE;
}")

(define_expand "restore_stack_nonlocal"
  [(match_operand 0 "register_operand" "")
   (match_operand 1 "memory_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (Pmode);

  /* Restore the backchain from the first word, sp from the second.  */
  emit_move_insn (temp,
		  operand_subword (operands[1], 0, 0, (TARGET_32BIT ? DImode : TImode)));
  emit_move_insn (operands[0],
		  operand_subword (operands[1], 1, 0, (TARGET_32BIT ? DImode : TImode)));
  emit_move_insn (gen_rtx_MEM (Pmode, operands[0]), temp);
  DONE;
}")

;; If we have -mminimal-toc, we need to reload r30 after a nonlocal goto.

(define_insn "nonlocal_goto_receiver"
  [(unspec_volatile [(const_int 0)] 1)]
  "TARGET_TOC && TARGET_MINIMAL_TOC"
  "*
{
  rs6000_output_load_toc_table (asm_out_file, 30);
  return \"\";
}"
  [(set_attr "type" "load")])

;; A function pointer under AIX is a pointer to a data area whose first word
;; contains the actual address of the function, whose second word contains a
;; pointer to its TOC, and whose third word contains a value to place in the
;; static chain register (r11).  Note that if we load the static chain, our
;; "trampoline" need not have any executable code.
;;
;; operands[0] is a register pointing to the 3 word descriptor (aka, the function address)
;; operands[1] is the stack size to clean up
;; operands[2] is the value FUNCTION_ARG returns for the VOID argument (must be 0 for AIX)
;; operands[3] is location to store the TOC
;; operands[4] is the TOC register
;; operands[5] is the static chain register
;;
;; We do not break this into separate insns, so that the scheduler will not try
;; to move the load of the new TOC before any loads from the TOC.

(define_insn "call_indirect_aix32"
  [(call (mem:SI (match_operand:SI 0 "register_operand" "b"))
	 (match_operand 1 "const_int_operand" "n"))
   (use (match_operand 2 "const_int_operand" "n"))
   (use (match_operand 3 "offsettable_addr_operand" "p"))
   (use (match_operand 4 "register_operand" "r"))
   (clobber (match_operand 5 "register_operand" "=r"))
   (clobber (match_scratch:SI 6 "=&r"))
   (clobber (match_scratch:SI 7 "=l"))]
  "DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[2]) == CALL_NORMAL || (INTVAL (operands[2]) & CALL_LONG) != 0)"
  "{st|stw} %4,%a3\;{l|lwz} %6,0(%0)\;{l|lwz} %4,4(%0)\;mt%7 %6\;{l|lwz} %5,8(%0)\;{brl|blrl}\;{l|lwz} %4,%a3"
  [(set_attr "type" "load")
   (set_attr "length" "28")])

(define_insn "call_indirect_aix64"
  [(call (mem:SI (match_operand:DI 0 "register_operand" "b"))
	 (match_operand 1 "const_int_operand" "n"))
   (use (match_operand 2 "const_int_operand" "n"))
   (use (match_operand 3 "offsettable_addr_operand" "p"))
   (use (match_operand 4 "register_operand" "r"))
   (clobber (match_operand 5 "register_operand" "=r"))
   (clobber (match_scratch:SI 6 "=&r"))
   (clobber (match_scratch:SI 7 "=l"))]
  "TARGET_64BIT && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[2]) == CALL_NORMAL || (INTVAL (operands[2]) & CALL_LONG) != 0)"
  "std %4,%a3\;ld %6,0(%0)\;ld %4,8(%0)\;mt%7 %6\;ld %5,16(%0)\;blrl\;ld %4,%a3"
  [(set_attr "type" "load")
   (set_attr "length" "28")])

(define_insn "call_value_indirect_aix32"
  [(set (match_operand 0 "register_operand" "fg")
	(call (mem:SI (match_operand:SI 1 "register_operand" "b"))
	      (match_operand 2 "const_int_operand" "n")))
   (use (match_operand 3 "const_int_operand" "n"))
   (use (match_operand 4 "offsettable_addr_operand" "p"))
   (use (match_operand 5 "register_operand" "r"))
   (clobber (match_operand 6 "register_operand" "=r"))
   (clobber (match_scratch:SI 7 "=&r"))
   (clobber (match_scratch:SI 8 "=l"))]
  "DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[3]) == CALL_NORMAL || (INTVAL (operands[3]) & CALL_LONG) != 0)"
  "{st|stw} %5,%a4\;{l|lwz} %7,0(%1)\;{l|lwz} %5,4(%1)\;mt%8 %7\;{l|lwz} %6,8(%1)\;{brl|blrl}\;{l|lwz} %5,%a4"
  [(set_attr "type" "load")
   (set_attr "length" "28")])

(define_insn "call_value_indirect_aix64"
  [(set (match_operand 0 "register_operand" "fg")
	(call (mem:SI (match_operand:DI 1 "register_operand" "b"))
	      (match_operand 2 "const_int_operand" "n")))
   (use (match_operand 3 "const_int_operand" "n"))
   (use (match_operand 4 "offsettable_addr_operand" "p"))
   (use (match_operand 5 "register_operand" "r"))
   (clobber (match_operand 6 "register_operand" "=r"))
   (clobber (match_scratch:SI 7 "=&r"))
   (clobber (match_scratch:SI 8 "=l"))]
  "TARGET_64BIT && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[3]) == CALL_NORMAL || (INTVAL (operands[3]) & CALL_LONG) != 0)"
  "std %5,%a4\;ld %7,0(%1)\;ld %5,8(%1)\;mt%8 %7\;ld %6,16(%1)\;blrl\;ld %5,%a4"
  [(set_attr "type" "load")
   (set_attr "length" "28")])

;; A function pointer undef NT is a pointer to a data area whose first word
;; contains the actual address of the function, whose second word contains a
;; pointer to its TOC.  The static chain is not stored under NT, which means
;; that we need a trampoline.
;;
;; operands[0] is an SImode pseudo in which we place the address of the function.
;; operands[1] is the stack size to clean up
;; operands[2] is the value FUNCTION_ARG returns for the VOID argument (must be 0 for NT)
;; operands[3] is location to store the TOC
;; operands[4] is the TOC register
;;
;; We do not break this into separate insns, so that the scheduler will not try
;; to move the load of the new TOC before any loads from the TOC.

(define_insn "call_indirect_nt"
  [(call (mem:SI (match_operand:SI 0 "register_operand" "b"))
	 (match_operand 1 "const_int_operand" "n"))
   (use (match_operand 2 "const_int_operand" "n"))
   (use (match_operand 3 "offsettable_addr_operand" "p"))
   (use (match_operand 4 "register_operand" "r"))
   (clobber (match_scratch:SI 5 "=&r"))
   (clobber (match_scratch:SI 6 "=l"))]
  "DEFAULT_ABI == ABI_NT
   && (INTVAL (operands[2]) == CALL_NORMAL || (INTVAL (operands[2]) & CALL_LONG) != 0)"
  "{st|stw} %4,%a3\;{l|lwz} %5,0(%0)\;{l|lwz} %4,4(%0)\;mt%6 %5\;{brl|blrl}\;{l|lwz} %4,%a3"
  [(set_attr "type" "load")
   (set_attr "length" "24")])

(define_insn "call_value_indirect_nt"
  [(set (match_operand 0 "register_operand" "fg")
	(call (mem:SI (match_operand:SI 1 "register_operand" "b"))
	      (match_operand 2 "const_int_operand" "n")))
   (use (match_operand 3 "const_int_operand" "n"))
   (use (match_operand 4 "offsettable_addr_operand" "p"))
   (use (match_operand 5 "register_operand" "r"))
   (clobber (match_scratch:SI 6 "=&r"))
   (clobber (match_scratch:SI 7 "=l"))]
  "DEFAULT_ABI == ABI_NT
   && (INTVAL (operands[3]) == CALL_NORMAL || (INTVAL (operands[3]) & CALL_LONG) != 0)"
  "{st|stw} %5,%a4\;{l|lwz} %6,0(%1)\;{l|lwz} %5,4(%1)\;mt%7 %6\;{brl|blrl}\;{l|lwz} %5,%a4"
  [(set_attr "type" "load")
   (set_attr "length" "24")])

;; A function pointer under System V is just a normal pointer
;; operands[0] is the function pointer
;; operands[1] is the stack size to clean up
;; operands[2] is the value FUNCTION_ARG returns for the VOID argument which indicates how to set cr1

(define_insn "call_indirect_sysv"
  [(call (mem:SI (match_operand:SI 0 "register_operand" "l,l"))
	 (match_operand 1 "const_int_operand" "n,n"))
   (use (match_operand 2 "const_int_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS || DEFAULT_ABI == ABI_AIX_NODESC"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return \"{brl|blrl}\";
}"
  [(set_attr "type" "jmpreg")
   (set_attr "length" "4,8")])

(define_insn "call_value_indirect_sysv"
  [(set (match_operand 0 "register_operand" "=fg,fg")
	(call (mem:SI (match_operand:SI 1 "register_operand" "l,l"))
	      (match_operand 2 "const_int_operand" "n,n")))
   (use (match_operand 3 "const_int_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS || DEFAULT_ABI == ABI_AIX_NODESC"
  "*
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return \"{brl|blrl}\";
}"
  [(set_attr "type" "jmpreg")
   (set_attr "length" "4,8")])

;; Now the definitions for the call and call_value insns
(define_expand "call"
  [(parallel [(call (mem:SI (match_operand 0 "address_operand" ""))
		    (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
  if (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != CONST_INT)
    abort ();

  operands[0] = XEXP (operands[0], 0);

  /* Convert NT DLL imports into an indirect call.  */
  if (GET_CODE (operands[0]) == SYMBOL_REF
      && (INTVAL (operands[2]) & CALL_NT_DLLIMPORT) != 0)
    {
      operands[0] = rs6000_dll_import_ref (operands[0]);
      operands[2] = GEN_INT ((int)CALL_NORMAL);
    }

  if (GET_CODE (operands[0]) != SYMBOL_REF
      || (INTVAL (operands[2]) & CALL_LONG) != 0)
    {
      if (INTVAL (operands[2]) & CALL_LONG)
	operands[0] = rs6000_longcall_ref (operands[0]);

      if (DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_AIX_NODESC || DEFAULT_ABI == ABI_SOLARIS)
	emit_call_insn (gen_call_indirect_sysv (force_reg (Pmode, operands[0]),
						operands[1], operands[2]));
      else
	{
	  rtx toc_reg = gen_rtx_REG (Pmode, 2);
	  rtx toc_addr = RS6000_SAVE_TOC;

	  if (DEFAULT_ABI == ABI_AIX)
	    {
	      /* AIX function pointers are really pointers to a three word area */
	      rtx static_chain = gen_rtx_REG (Pmode, STATIC_CHAIN_REGNUM);
	      emit_call_insn (TARGET_32BIT
			      ? gen_call_indirect_aix32 (force_reg (Pmode, operands[0]),
						         operands[1], operands[2],
						         toc_addr, toc_reg, static_chain)
			      : gen_call_indirect_aix64 (force_reg (Pmode, operands[0]),
						         operands[1], operands[2],
						         toc_addr, toc_reg, static_chain));
	    }
	  else if (DEFAULT_ABI == ABI_NT)
	    {
	      /* NT function pointers are really pointers to a two word area */
	      emit_call_insn (gen_call_indirect_nt (force_reg (Pmode, operands[0]),
						    operands[1], operands[2],
						    toc_addr, toc_reg));
	    }
	  else
	    abort ();
	}
      DONE;
    }
}")

(define_expand "call_value"
  [(parallel [(set (match_operand 0 "" "")
		   (call (mem:SI (match_operand 1 "address_operand" ""))
			 (match_operand 2 "" "")))
	      (use (match_operand 3 "" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
  if (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != CONST_INT)
    abort ();

  operands[1] = XEXP (operands[1], 0);

  /* Convert NT DLL imports into an indirect call.  */
  if (GET_CODE (operands[1]) == SYMBOL_REF
      && (INTVAL (operands[3]) & CALL_NT_DLLIMPORT) != 0)
    {
      operands[1] = rs6000_dll_import_ref (operands[1]);
      operands[3] = GEN_INT ((int)CALL_NORMAL);
    }

  if (GET_CODE (operands[1]) != SYMBOL_REF
      || (INTVAL (operands[3]) & CALL_LONG) != 0)
    {
      if (INTVAL (operands[2]) & CALL_LONG)
	operands[1] = rs6000_longcall_ref (operands[1]);

      if (DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_AIX_NODESC || DEFAULT_ABI == ABI_SOLARIS)
	emit_call_insn (gen_call_value_indirect_sysv (operands[0], operands[1],
						      operands[2], operands[3]));
      else
	{
	  rtx toc_reg = gen_rtx_REG (Pmode, 2);
	  rtx toc_addr = RS6000_SAVE_TOC;

	  if (DEFAULT_ABI == ABI_AIX)
	    {
	      /* AIX function pointers are really pointers to a three word area */
	      rtx static_chain = gen_rtx_REG (Pmode, STATIC_CHAIN_REGNUM);
	      emit_call_insn (TARGET_32BIT
			      ? gen_call_value_indirect_aix32 (operands[0],
							       force_reg (Pmode, operands[1]),
							       operands[2], operands[3],
							       toc_addr, toc_reg, static_chain)
			      : gen_call_value_indirect_aix64 (operands[0],
							       force_reg (Pmode, operands[1]),
							       operands[2], operands[3],
							       toc_addr, toc_reg, static_chain));
	    }
	  else if (DEFAULT_ABI == ABI_NT)
	    {
	      /* NT function pointers are really pointers to a two word area */
	      emit_call_insn (gen_call_value_indirect_nt (operands[0],
							  force_reg (Pmode, operands[1]),
							  operands[2], operands[3],
							  toc_addr, toc_reg));
	    }
	  else
	    abort ();
	}
      DONE;
    }
}")

;; Call to function in current module.  No TOC pointer reload needed.
;; Operand2 is non-zero if we are using the V.4 calling sequence and
;; either the function was not prototyped, or it was prototyped as a
;; variable argument function.  It is > 0 if FP registers were passed
;; and < 0 if they were not.

(define_insn "*call_local32"
  [(call (mem:SI (match_operand:SI 0 "current_file_function_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "(INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z0@local\" : \"bl %z0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*call_local64"
  [(call (mem:SI (match_operand:DI 0 "current_file_function_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "TARGET_64BIT && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z0@local\" : \"bl %z0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*ret_call_local32"
  [(set (match_operand 0 "" "=fg,fg")
	(call (mem:SI (match_operand:SI 1 "current_file_function_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "(INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z1@local\" : \"bl %z1\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])


(define_insn "*ret_call_local64"
  [(set (match_operand 0 "" "=fg,fg")
	(call (mem:SI (match_operand:DI 1 "current_file_function_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "TARGET_64BIT && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z1@local\" : \"bl %z1\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

;; Call to function which may be in another module.  Restore the TOC
;; pointer (r2) after the call unless this is System V.
;; Operand2 is non-zero if we are using the V.4 calling sequence and
;; either the function was not prototyped, or it was prototyped as a
;; variable argument function.  It is > 0 if FP registers were passed
;; and < 0 if they were not.

(define_insn "*call_nonlocal_aix32"
  [(call (mem:SI (match_operand:SI 0 "call_operand" "s,s"))
	 (match_operand 1 "" "fg,fg"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_NT)
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  /* Indirect calls should go through call_indirect */
  if (GET_CODE (operands[0]) == REG)
    abort ();

  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (TARGET_WINDOWS_NT) ? \"bl %z0\;.znop %z0\" : \"bl %z0\;%.\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "8,12")])

(define_insn "*call_nonlocal_aix64"
  [(call (mem:SI (match_operand:DI 0 "call_operand" "s,s"))
	 (match_operand 1 "" "fg,fg"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "TARGET_64BIT && (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_NT)
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  /* Indirect calls should go through call_indirect */
  if (GET_CODE (operands[0]) == REG)
    abort ();

  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (TARGET_WINDOWS_NT) ? \"bl %z0\;.znop %z0\" : \"bl %z0\;%.\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "8,12")])

(define_insn "*call_nonlocal_sysv"
  [(call (mem:SI (match_operand:SI 0 "call_operand" "s,s"))
	 (match_operand 1 "" "fg,fg"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "(DEFAULT_ABI == ABI_AIX_NODESC || DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS)
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  /* Indirect calls should go through call_indirect */
  if (GET_CODE (operands[0]) == REG)
    abort ();

  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z0@plt\" : \"bl %z0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*ret_call_nonlocal_aix32"
  [(set (match_operand 0 "" "=fg,fg")
	(call (mem:SI (match_operand:SI 1 "call_operand" "s,s"))
	      (match_operand 2 "" "fg,fg")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_NT)
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  /* This should be handled by call_value_indirect */
  if (GET_CODE (operands[1]) == REG)
    abort ();

  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (TARGET_WINDOWS_NT) ? \"bl %z1\;.znop %z1\" : \"bl %z1\;%.\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "8,12")])

(define_insn "*ret_call_nonlocal_aix64"
  [(set (match_operand 0 "" "=fg,fg")
	(call (mem:SI (match_operand:DI 1 "call_operand" "s,s"))
	      (match_operand 2 "" "fg,fg")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "TARGET_64BIT && (DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_NT)
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  /* This should be handled by call_value_indirect */
  if (GET_CODE (operands[1]) == REG)
    abort ();

  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (TARGET_WINDOWS_NT) ? \"bl %z1\;.znop %z1\" : \"bl %z1\;%.\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "8,12")])

(define_insn "*ret_call_nonlocal_sysv"
  [(set (match_operand 0 "" "=fg,fg")
	(call (mem:SI (match_operand:SI 1 "call_operand" "s,s"))
	      (match_operand 2 "" "fg,fg")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "(DEFAULT_ABI == ABI_AIX_NODESC || DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS)
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  /* This should be handled by call_value_indirect */
  if (GET_CODE (operands[1]) == REG)
    abort ();

  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z1@plt\" : \"bl %z1\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

;; Call subroutine returning any type.
(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
		    (const_int 0))
	      (match_operand 1 "" "")
	      (match_operand 2 "" "")])]
  ""
  "
{
  int i;

  emit_call_insn (gen_call (operands[0], const0_rtx, const0_rtx, const0_rtx));

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage ());

  DONE;
}")

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] 0)]
  ""
  "")

;; V.4 specific code to initialize the PIC register

(define_insn "init_v4_pic"
  [(set (match_operand:SI 0 "register_operand" "=l")
	(unspec [(const_int 0)] 7))]
  "DEFAULT_ABI == ABI_V4 || DEFAULT_ABI == ABI_SOLARIS"
  "bl _GLOBAL_OFFSET_TABLE_@local-4"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])


;; Compare insns are next.  Note that the RS/6000 has two types of compares,
;; signed & unsigned, and one type of branch.
;;
;; Start with the DEFINE_EXPANDs to generate the rtl for compares, scc
;; insns, and branches.  We store the operands of compares until we see
;; how it is used.
(define_expand "cmpsi"
  [(set (cc0)
        (compare (match_operand:SI 0 "gpc_reg_operand" "")
  		 (match_operand:SI 1 "reg_or_short_operand" "")))]
  ""
  "
{
  /* Take care of the possibility that operands[1] might be negative but
     this might be a logical operation.  That insn doesn't exist.  */
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) < 0)
    operands[1] = force_reg (SImode, operands[1]);

  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 0;
  DONE;
}")

(define_expand "cmpdi"
  [(set (cc0)
        (compare (match_operand:DI 0 "gpc_reg_operand" "")
  		 (match_operand:DI 1 "reg_or_short_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  /* Take care of the possibility that operands[1] might be negative but
     this might be a logical operation.  That insn doesn't exist.  */
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) < 0)
    operands[1] = force_reg (DImode, operands[1]);

  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 0;
  DONE;
}")

(define_expand "cmpsf"
  [(set (cc0) (compare (match_operand:SF 0 "gpc_reg_operand" "")
		       (match_operand:SF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "cmpdf"
  [(set (cc0) (compare (match_operand:DF 0 "gpc_reg_operand" "")
		       (match_operand:DF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "beq"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (eq (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bne"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ne (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "blt"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (lt (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bgt"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (gt (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "ble"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (le (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bge"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ge (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bgtu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (gtu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bltu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ltu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bgeu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (geu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bleu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (leu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

;; For SNE, we would prefer that the xor/abs sequence be used for integers.
;; For SEQ, likewise, except that comparisons with zero should be done
;; with an scc insns.  However, due to the order that combine see the
;; resulting insns, we must, in fact, allow SEQ for integers.  Fail in
;; the cases we don't want to handle.
(define_expand "seq"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(eq:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sne"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ne:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ if (! rs6000_compare_fp_p)
    FAIL;

  operands[1] = gen_rtx_COMPARE (CCFPmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCFPmode);
}")

;; A > 0 is best done using the portable sequence, so fail in that case.
(define_expand "sgt"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gt:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

;; A < 0 is best done in the portable way for A an integer.
(define_expand "slt"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(lt:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sge"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ge:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

;; A <= 0 is best done the portable way for A an integer.
(define_expand "sle"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(le:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx_COMPARE (mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sgtu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gtu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sltu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ltu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sgeu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(geu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sleu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(leu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx_COMPARE (CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

;; Here are the actual compare insns.
(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "{cmp%I2|cmpw%I2} %0,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
	(compare:CC (match_operand:DI 1 "gpc_reg_operand" "r")
		    (match_operand:DI 2 "reg_or_short_operand" "rI")))]
  "TARGET_POWERPC64"
  "cmpd%I2 %0,%1,%2"
  [(set_attr "type" "compare")])

;; If we are comparing a register for equality with a large constant,
;; we can do this with an XOR followed by a compare.  But we need a scratch
;; register for the result of the XOR.

(define_split
  [(set (match_operand:CC 0 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "non_short_cint_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "find_single_use (operands[0], insn, 0)
   && (GET_CODE (*find_single_use (operands[0], insn, 0)) == EQ
       || GET_CODE (*find_single_use (operands[0], insn, 0)) == NE)"
  [(set (match_dup 3) (xor:SI (match_dup 1) (match_dup 4)))
   (set (match_dup 0) (compare:CC (match_dup 3) (match_dup 5)))]
  "
{
  /* Get the constant we are comparing against, C,  and see what it looks like
     sign-extended to 16 bits.  Then see what constant could be XOR'ed
     with C to get the sign-extended value.  */

  int c = INTVAL (operands[2]);
  int sextc = (c << 16) >> 16;
  int xorv = c ^ sextc;

  operands[4] = GEN_INT (xorv);
  operands[5] = GEN_INT (sextc);
}")

(define_insn ""
  [(set (match_operand:CCUNS 0 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_u_short_operand" "rI")))]
  ""
  "{cmpl%I2|cmplw%I2} %0,%1,%W2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CCUNS 0 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:DI 1 "gpc_reg_operand" "r")
		       (match_operand:DI 2 "reg_or_u_short_operand" "rI")))]
  ""
  "cmpld%I2 %0,%1,%W2"
  [(set_attr "type" "compare")])

;; The following two insns don't exist as single insns, but if we provide
;; them, we can swap an add and compare, which will enable us to overlap more
;; of the required delay between a compare and branch.  We generate code for
;; them by splitting.

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "u_short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#"
  [(set_attr "length" "8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CC (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_split
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "")
		       (match_operand:SI 2 "u_short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CCUNS (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_insn ""
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:SF 1 "gpc_reg_operand" "f")
		      (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

(define_insn ""
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:DF 1 "gpc_reg_operand" "f")
		      (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT"
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

;; Now we have the scc insns.  We can do some combinations because of the
;; way the machine works.
;;
;; Note that this is probably faster if we can put an insn between the
;; mfcr and rlinm, but this is tricky.  Let's leave it for now.  In most
;; cases the insns below which don't use an intermediate CR field will
;; be used instead.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))]
  ""
  "%D1mfcr %0\;{rlinm|rlwinm} %0,%0,%J1,1"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y")
					(const_int 0)])
		    (const_int 0)))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r")
	(match_op_dup 1 [(match_dup 2) (const_int 0)]))]
  ""
  "%D1mfcr %3\;{rlinm.|rlwinm.} %3,%3,%J1,1"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				      [(match_operand 2 "cc_reg_operand" "y")
				       (const_int 0)])
		   (match_operand:SI 3 "const_int_operand" "n")))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[4] = GEN_INT (count);
  operands[5] = GEN_INT (put_bit);

  return \"%D1mfcr %0\;{rlinm|rlwinm} %0,%0,%4,%5,%5\";
}"
 [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y")
					(const_int 0)])
		    (match_operand:SI 3 "const_int_operand" "n"))
	 (const_int 0)))
   (set (match_operand:SI 4 "gpc_reg_operand" "=r")
	(ashift:SI (match_op_dup 1 [(match_dup 2) (const_int 0)])
		   (match_dup 3)))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[5] = GEN_INT (count);
  operands[6] = GEN_INT (put_bit);

  return \"%D1mfcr %4\;{rlinm.|rlwinm.} %4,%4,%5,%6,%6\";
}"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

;; If we are comparing the result of two comparisons, this can be done
;; using creqv or crxor.

(define_insn ""
  [(set (match_operand:CCEQ 0 "cc_reg_operand" "=y")
	(compare:CCEQ (match_operator 1 "scc_comparison_operator"
			      [(match_operand 2 "cc_reg_operand" "y")
			       (const_int 0)])
		      (match_operator 3 "scc_comparison_operator"
			      [(match_operand 4 "cc_reg_operand" "y")
			       (const_int 0)])))]
  "REGNO (operands[2]) != REGNO (operands[4])"
  "*
{
  enum rtx_code code1, code2;

  code1 = GET_CODE (operands[1]);
  code2 = GET_CODE (operands[3]);

  if ((code1 == EQ || code1 == LT || code1 == GT
       || code1 == LTU || code1 == GTU
       || (code1 != NE && GET_MODE (operands[2]) == CCFPmode))
      !=
      (code2 == EQ || code2 == LT || code2 == GT
       || code2 == LTU || code2 == GTU
       || (code2 != NE && GET_MODE (operands[4]) == CCFPmode)))
    return \"%C1%C3crxor %E0,%j1,%j3\";
  else
    return \"%C1%C3creqv %E0,%j1,%j3\";
}"
  [(set_attr "length" "12")])

;; There is a 3 cycle delay between consecutive mfcr instructions
;; so it is useful to combine 2 scc instructions to use only one mfcr.

(define_peephole
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r")
	(match_operator:SI 4 "scc_comparison_operator"
			   [(match_operand 5 "cc_reg_operand" "y")
			    (const_int 0)]))]
   "REGNO (operands[2]) != REGNO (operands[5])"
   "%D1%D4mfcr %3\;{rlinm|rlwinm} %0,%3,%J1,1\;{rlinm|rlwinm} %3,%3,%J4,1"
   [(set_attr "length" "20")])

;; There are some scc insns that can be done directly, without a compare.
;; These are faster because they don't involve the communications between
;; the FXU and branch units.   In fact, we will be replacing all of the
;; integer scc insns here or in the portable methods in emit_store_flag.
;;
;; Also support (neg (scc ..)) since that construct is used to replace
;; branches, (plus (scc ..) ..) since that construct is common and
;; takes no more insns than scc, and (and (neg (scc ..)) ..) in the
;; cases where it is no more expensive than (neg (scc ..)).

;; Have reload force a constant into a register for the simple insns that
;; otherwise won't accept constants.  We do this because it is faster than
;; the cmp/mfcr sequence we would otherwise generate.

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
	       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I")))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r"))]
  ""
  "@
   xor %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {sfi|subfic} %3,%1,0\;{ae|adde} %0,%3,%1
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r,r")
	       (match_operand:DI 2 "reg_or_cint_operand" "r,O,K,J,I")))
   (clobber (match_scratch:DI 3 "=r,&r,r,r,r"))]
  "TARGET_POWERPC64"
  "@
   xor %0,%1,%2\;subfic %3,%0,0\;adde %0,%3,%0
   subfic %3,%1,0\;adde %0,%3,%1
   xori %0,%1,%b2\;subfic %3,%0,0\;adde %0,%3,%0
   xoris %0,%1,%u2\;subfic %3,%0,0\;adde %0,%3,%0
   subfic %0,%1,%2\;subfic %3,%0,0\;adde %0,%3,%0"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC
	 (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r"))]
  ""
  "@
   xor %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {sfi|subfic} %3,%1,0\;{ae.|adde.} %0,%3,%1
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC
	 (eq:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r,r")
		(match_operand:DI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:DI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:DI 3 "=r,&r,r,r,r"))]
  "TARGET_POWERPC64"
  "@
   xor %0,%1,%2\;subfic %3,%0,0\;adde. %0,%3,%0
   subfic %3,%1,0\;adde. %0,%3,%1
   xori %0,%1,%b2\;subfic %3,%0,0\;adde. %0,%3,%0
   xoris %0,%1,%u2\;subfic %3,%0,0\;adde. %0,%3,%0
   subfic %0,%1,%2\;subfic %3,%0,0\;adde. %0,%3,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12")])

;; We have insns of the form shown by the first define_insn below.  If
;; there is something inside the comparison operation, we must split it.
(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operator 1 "comparison_operator"
				 [(match_operand:SI 2 "" "")
				  (match_operand:SI 3
						    "reg_or_cint_operand" "")])
		 (match_operand:SI 4 "gpc_reg_operand" "")))
   (clobber (match_operand:SI 5 "register_operand" ""))]
  "! gpc_reg_operand (operands[2], SImode)"
  [(set (match_dup 5) (match_dup 2))
   (set (match_dup 2) (plus:SI (match_op_dup 1 [(match_dup 2) (match_dup 3)])
			       (match_dup 4)))])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(plus:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
			(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {sfi|subfic} %4,%1,0\;{aze|addze} %0,%3
   {xoril|xori} %4,%1,%b2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {xoriu|xoris} %4,%1,%u2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {sfi|subfic} %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {sfi|subfic} %4,%1,0\;{aze.|addze.} %0,%3
   {xoril|xori} %4,%1,%b2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {xoriu|xoris} %4,%1,%u2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {sfi|subfic} %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(plus:SI (eq:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {sfi|subfic} %4,%1,0\;{aze.|addze.} %4,%3
   {xoril|xori} %4,%1,%b2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {xoriu|xoris} %4,%1,%u2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {sfi|subfic} %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(neg:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))))]
  ""
  "@
   xor %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,-1\;{sfe|subfe} %0,%0,%0
   {xoril|xori} %0,%1,%b2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {xoriu|xoris} %0,%1,%u2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {sfi|subfic} %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0"
   [(set_attr "length" "12,8,12,12,12")])

;; Simplify (ne X (const_int 0)) on the PowerPC.  No need to on the Power,
;; since it nabs/sr is just as fast.
(define_insn "*ne0"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(lshiftrt:SI (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		     (const_int 31)))
   (clobber (match_scratch:SI 2 "=&r"))]
  "!TARGET_POWER"
  "{ai|addic} %2,%1,-1\;{sfe|subfe} %0,%2,%1"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(lshiftrt:DI (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
		     (const_int 63)))
   (clobber (match_scratch:DI 2 "=&r"))]
  "TARGET_POWERPC64"
  "addic %2,%1,-1\;subfe %0,%2,%1"
  [(set_attr "length" "8")])

;; This is what (plus (ne X (const_int 0)) Y) looks like.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lshiftrt:SI
		  (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		  (const_int 31))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{ai|addic} %3,%1,-1\;{aze|addze} %0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(plus:DI (lshiftrt:DI
		  (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
		  (const_int 63))
		 (match_operand:DI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:DI 3 "=&r"))]
  "TARGET_POWERPC64"
  "addic %3,%1,-1\;addze %0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{ai|addic} %3,%1,-1\;{aze.|addze.} %3,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:DI (lshiftrt:DI
		   (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
		   (const_int 63))
		  (match_operand:DI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:DI 3 "=&r"))]
  "TARGET_POWERPC64"
  "addic %3,%1,-1\;addze. %3,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lshiftrt:SI (neg:SI (abs:SI (match_dup 1))) (const_int 31))
		 (match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{ai|addic} %3,%1,-1\;{aze.|addze.} %0,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:DI (lshiftrt:DI
		   (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
		   (const_int 63))
		  (match_operand:DI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(plus:DI (lshiftrt:DI (neg:DI (abs:DI (match_dup 1))) (const_int 63))
		 (match_dup 2)))
   (clobber (match_scratch:DI 3 "=&r"))]
  "TARGET_POWERPC64"
  "addic %3,%1,-1\;addze. %0,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
	       (match_operand:SI 2 "reg_or_short_operand" "r,O")))
   (clobber (match_scratch:SI 3 "=r,X"))]
  "TARGET_POWER"
  "@
   doz %3,%2,%1\;{sfi|subfic} %0,%3,0\;{ae|adde} %0,%0,%3
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x")
	(compare:CC
	 (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_short_operand" "r,O"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(le:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,X"))]
  "TARGET_POWER"
  "@
   doz %3,%2,%1\;{sfi|subfic} %0,%3,0\;{ae.|adde.} %0,%0,%3
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "compare,delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,O"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3
   {srai|srawi} %4,%1,31\;{sf|subfc} %4,%1,%4\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {srai|srawi} %4,%1,31\;{sf|subfc} %4,%1,%4\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (le:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3
   {srai|srawi} %4,%1,31\;{sf|subfc} %4,%1,%4\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		       (match_operand:SI 2 "reg_or_short_operand" "r,O"))))]
  "TARGET_POWER"
  "@
   doz %0,%2,%1\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(leu:SI (match_dup 1) (match_dup 2)))]
   ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{aze|addze} %0,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (leu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;nand %0,%0,%0"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI
		 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI")))
		(match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;andc %0,%3,%4"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI (leu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "{sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;andc. %0,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{sri|srwi} %0,%0,31"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{ai|addic} %4,%4,-1\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{ai|addic} %4,%4,-1\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{ai|addic} %4,%4,-1\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;neg %0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;neg %0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC
	 (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ltu:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;neg. %0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;neg. %0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,r,P,P"))
		 (match_operand:SI 3 "reg_or_short_operand" "r,I,r,I")))
   (clobber (match_scratch:SI 4 "=&r,r,&r,r"))]
  ""
  "@
  {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
  {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
  {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
  {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3"
 [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %4,%4,%3
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %4,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (ltu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWER"
  "doz%I2 %3,%1,%2\;{sfi|subfic} %0,%3,0\;{ae|adde} %0,%0,%3"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ge:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWER"
  "doz%I2 %3,%1,%2\;{sfi|subfic} %0,%3,0\;{ae.|adde.} %0,%0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (ge:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz%I2 %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "12")])

;; This is (and (neg (ge X (const_int 0))) Y).
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI
		 (lshiftrt:SI
		  (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		  (const_int 31)))
		(match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{srai|srawi} %3,%1,31\;andc %0,%2,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (lshiftrt:SI
		   (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 31)))
		 (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{srai|srawi} %3,%1,31\;andc. %3,%2,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (lshiftrt:SI
		   (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 31)))
		 (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI (lshiftrt:SI (not:SI (match_dup 1))
				     (const_int 31)))
		(match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{srai|srawi} %3,%1,31\;andc. %0,%2,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC
	 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(geu:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{aze|addze} %0,%3
   {ai|addic} %4,%1,%n2\;{aze|addze} %0,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{aze.|addze.} %4,%3
   {ai|addic} %4,%1,%n2\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (geu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{aze.|addze.} %0,%3
   {ai|addic} %4,%1,%n2\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,I"))))]
  ""
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;nand %0,%0,%0
   {sfi|subfic} %0,%1,-1\;{a%I2|add%I2c} %0,%0,%2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (neg:SI
		 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		(match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;andc %0,%3,%4
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;andc %0,%3,%4"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (neg:SI (geu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;andc. %0,%3,%4
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;andc. %0,%3,%4"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (const_int 0)))]
  ""
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(const_int 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_dup 1) (const_int 0)))]
  ""
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "r")))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{sri.|srwi.} %0,%0,31"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(const_int 0))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{a|addc} %3,%1,%1\;{sfe|subfe} %3,%1,%3\;{aze|addze} %0,%2"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{a|addc} %3,%1,%1\;{sfe|subfe} %3,%1,%3\;{aze.|addze.} %0,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_dup 1) (const_int 0)) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "{a|addc} %3,%1,%1\;{sfe|subfe} %3,%1,%3\;{aze.|addze.} %3,%2"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "r"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz %4,%2,%1\;{ai|addic} %4,%4,-1\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz %4,%2,%1\;{ai|addic} %4,%4,-1\;{aze.|addze.} %4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  "TARGET_POWER"
  "doz %4,%2,%1\;{ai|addic} %4,%4,-1\;{aze.|addze.} %0,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (const_int 0))))]
  ""
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "r"))))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;neg %0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gtu:SI (match_dup 1) (match_dup 2)))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;neg. %0,%0"
  [(set_attr "type" "compare")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "I,r,rI"))
		 (match_operand:SI 3 "reg_or_short_operand" "r,r,I")))
   (clobber (match_scratch:SI 4 "=&r,&r,&r"))]
  ""
  "@
   {ai|addic} %4,%1,%k2\;{aze|addze} %0,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf%I3|subf%I3c} %0,%4,%3"
  [(set_attr "length" "8,12,12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {ai|addic} %4,%1,%k2\;{aze.|addze.} %0,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (gtu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   {ai|addic} %4,%1,%k2\;{aze.|addze.} %0,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %0,%4,%3"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "8")])

;; Define both directions of branch and return.  If we need a reload
;; register, we'd rather use CR0 since it is much easier to copy a
;; register CC value to there.

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  if (get_attr_length (insn) == 8)
    return \"%C1bc %t1,%j1,%l0\";
  else
    return \"%C1bc %T1,%j1,%$+8\;b %l0\";

}"
  [(set_attr "type" "branch")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (return)
		      (pc)))]
  "direct_return ()"
  "{%C0bcr|%C0bclr} %t0,%j0"
  [(set_attr "type" "branch")
   (set_attr "length" "8")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  if (get_attr_length (insn) == 8)
    return \"%C1bc %T1,%j1,%l0\";
  else
    return \"%C1bc %t1,%j1,%$+8\;b %l0\";
}"
  [(set_attr "type" "branch")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (pc)
		      (return)))]
  "direct_return ()"
  "{%C0bcr|%C0bclr} %T0,%j0"
  [(set_attr "type" "branch")
   (set_attr "length" "8")])

;; Unconditional branch and return.

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "b %l0"
  [(set_attr "type" "branch")])

(define_insn "return"
  [(return)]
  "direct_return ()"
  "{br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "c,l"))]
  ""
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn ""
  [(set (pc) (match_operand:DI 0 "register_operand" "c,l"))]
  "TARGET_POWERPC64"
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

;; Table jump for switch statements:
(define_expand "tablejump"
  [(use (match_operand 0 "" ""))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "
{
  if (TARGET_32BIT)
    emit_jump_insn (gen_tablejumpsi (operands[0], operands[1]));
  else
    emit_jump_insn (gen_tablejumpdi (operands[0], operands[1]));
  DONE;
}")

(define_expand "tablejumpsi"
  [(set (match_dup 3)
	(plus:SI (match_operand:SI 0 "" "")
		 (match_dup 2)))
   (parallel [(set (pc) (match_dup 3))
	      (use (label_ref (match_operand 1 "" "")))])]
  ""
  "
{ operands[0] = force_reg (SImode, operands[0]);
  operands[2] = force_reg (SImode, gen_rtx_LABEL_REF (VOIDmode, operands[1]));
  operands[3] = gen_reg_rtx (SImode);
}")

(define_expand "tablejumpdi"
  [(set (match_dup 3)
	(plus:DI (match_operand:DI 0 "" "")
		 (match_dup 2)))
   (parallel [(set (pc) (match_dup 3))
	      (use (label_ref (match_operand 1 "" "")))])]
  ""
  "
{ operands[0] = force_reg (DImode, operands[0]);
  operands[2] = force_reg (DImode, gen_rtx_LABEL_REF (VOIDmode, operands[1]));
  operands[3] = gen_reg_rtx (DImode);
}")

(define_insn ""
  [(set (pc)
	(match_operand:SI 0 "register_operand" "c,l"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn ""
  [(set (pc)
	(match_operand:DI 0 "register_operand" "c,l"))
   (use (label_ref (match_operand 1 "" "")))]
  "TARGET_POWERPC64"
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn "nop"
  [(const_int 0)]
  ""
  "{cror 0,0,0|nop}")

;; Define the subtract-one-and-jump insns, starting with the template
;; so loop.c knows what to generate.

(define_expand "decrement_and_branch_on_count"
  [(parallel [(set (pc) (if_then_else (ne (match_operand:SI 0 "register_operand" "")
					  (const_int 1))
				      (label_ref (match_operand 1 "" ""))
				      (pc)))
	      (set (match_dup 0)
		   (plus:SI (match_dup 0)
			    (const_int -1)))
	      (clobber (match_scratch:CC 2 ""))
	      (clobber (match_scratch:SI 3 ""))])]
  ""
  "")

;; We need to be able to do this for any operand, including MEM, or we
;; will cause reload to blow up since we don't allow output reloads on
;; JUMP_INSNs.
;; In order that the length attribute is calculated correctly, the
;; label MUST be operand 0.

(define_insn ""
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz %$+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} %$+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

;; Similar, but we can use GE since we have a REG_NONNEG.
(define_insn ""
  [(set (pc)
	(if_then_else (ge (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&X"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  "find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz %$+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (ge (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&X"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  "find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} %$+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (eq (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} %$+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_insn ""
  [(set (pc)
	(if_then_else (eq (match_operand:SI 1 "register_operand" "c,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 8)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz %$+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16")])

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 0)
		   (plus:SI (match_dup 1)
			    (const_int -1)))])
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "general_operand" "")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed && ! gpc_reg_operand (operands[0], SImode)"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 4)
		   (plus:SI (match_dup 1)
			    (const_int -1)))])
   (set (match_dup 0)
	(match_dup 4))
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")

(define_insn "trap"
  [(trap_if (const_int 1) (const_int 0))]
  ""
  "{t 31,0,0|trap}")

(define_expand "conditional_trap"
  [(trap_if (match_operator 0 "trap_comparison_operator"
			    [(match_dup 2) (match_dup 3)])
	    (match_operand 1 "const_int_operand" ""))]
  ""
  "if (rs6000_compare_fp_p || operands[1] != const0_rtx) FAIL;
   operands[2] = rs6000_compare_op0;
   operands[3] = rs6000_compare_op1;")

(define_insn ""
  [(trap_if (match_operator 0 "trap_comparison_operator"
                            [(match_operand:SI 1 "register_operand" "r")
                             (match_operand:SI 2 "reg_or_short_operand" "rI")])
	    (const_int 0))]
  ""
  "t%V0%I2 %1,%2")
