;;- Machine description for IBM RISC System 6000 (POWER) for GNU C compiler
;;   Copyright (C) 1990, 1991 Free Software Foundation, Inc.
;;   Contributed by Richard Kenner (kenner@nyu.edu)

;; This file is part of GNU CC.

;; GNU CC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; GNU CC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU CC; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;; Define an insn type attribute.  This is used in function unit delay
;; computations.
(define_attr "type" "load,integer,fp,compare,delayed_compare,fpcompare,mtlr"
  (const_string "integer"))

;; Memory delivers its result in two cycles.
(define_function_unit "memory" 1 0 (eq_attr "type" "load") 2 0)

;; We consider floating-point insns to deliver their result in two cycles
;; to try to intersperse integer and FP operations.
(define_function_unit "fp" 1 0 (eq_attr "type" "fp,fpcompare") 2 0)

;; Most integer comparisons are ready in four cycles (a stall of three).
(define_function_unit "compare" 1 0 (eq_attr "type" "compare") 4 0)

;; Some integer comparisons aren't ready for five cycles (a stall of four).
(define_function_unit "compare" 1 0 (eq_attr "type" "delayed_compare") 5 0)

;; Floating-point comparisons take eight cycles.
(define_function_unit "compare" 1 0 (eq_attr "type" "fpcompare") 8 0)

;; Branches on LR cannot be done until five cycles after LR is set.
(define_function_unit "branch" 1 0 (eq_attr "type" "mtlr") 5 0)

;; Start with fixed-point load and store insns.  Here we put only the more
;; complex forms.  Basic data transfer is done later.

(define_expand "zero_extendqisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   rlinm %0,%1,0,24,31"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "andil. %2,%1,255"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "andil. %0,%1,255"
  [(set_attr "type" "compare")])

(define_expand "zero_extendqihi2"
  [(set (match_operand:HI 0 "gpc_reg_operand" "")
	(zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:HI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:HI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   rlinm %0,%1,0,24,31"
  [(set_attr "type" "load,*")])

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lhz%U1%X1 %0,%1
   rlinm %0,%1,0,16,31"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "andil. %2,%1,65535"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "andil. %0,%1,65535"
  [(set_attr "type" "compare")])

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lha%U1%X1 %0,%1
   exts %0,%1"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "exts. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_dup 1)))]
  ""
  "exts. %0,%1"
  [(set_attr "type" "compare")])

;; Fixed-point arithmetic insns.
(define_insn "addsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,b")
		 (match_operand:SI 2 "add_operand" "rI,J")))]
  ""
  "@
   a%I2 %0,%1,%2
   cau %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "reg_or_short_operand" "rI"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "a%I2. %3,%1,%2"
  [(set_attr "type" "compare")])
   
(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "reg_or_short_operand" "rI"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "a%I2. %0,%1,%2"
  [(set_attr "type" "compare")])
   
;; Split an add that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.  Note that the low-order
;; add should be last in case the result gets used in an address.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "non_add_cint_operand" "")))]
  ""
  [(set (match_dup 0) (plus:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (plus:SI (match_dup 0) (match_dup 4)))]
"
{
  int low = INTVAL (operands[2]) & 0xffff;
  int high = (unsigned) INTVAL (operands[2]) >> 16;

  if (low & 0x8000)
    high++, low |= 0xffff0000;

  operands[3] = gen_rtx (CONST_INT, VOIDmode, high << 16);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, low);
}")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "sfi %0,%1,-1")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "r,I")
		  (match_operand:SI 2 "gpc_reg_operand" "r,r")))]
  ""
  "@
   sf %0,%2,%1
   sfi %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "sf. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  ""
  "sf. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_expand "subsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "")
		  (match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_addsi3 (operands[0], operands[1],
			     negate_rtx (SImode, operands[2])));
      DONE;
    }
}")

;; For SMIN, SMAX, UMIN, and UMAX, we use DEFINE_EXPAND's that involve a doz[i]
;; instruction and some auxiliary computations.  Then we just have a single
;; DEFINE_INSN for doz[i] and the define_splits to make them if made by
;; combine.

(define_expand "sminsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  ""
  "
{ operands[3] = gen_reg_rtx (SImode); }")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smin:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  ""
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (minus:SI (match_dup 2) (match_dup 3)))]
  "")

(define_expand "smaxsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  ""
  "
{ operands[3] = gen_reg_rtx (SImode); }")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smax:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  ""
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (plus:SI (match_dup 3) (match_dup 1)))]
  "")

(define_expand "uminsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (const_int -2147483648)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (const_int -2147483648)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  ""
  "
{ operands[3] = gen_reg_rtx (SImode);  operands[4] = gen_reg_rtx (SImode); }")

(define_expand "umaxsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (const_int -2147483648)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (const_int -2147483648)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  ""
  "
{ operands[3] = gen_reg_rtx (SImode);  operands[4] = gen_reg_rtx (SImode); }")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "reg_or_short_operand" "rI"))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  ""
  "doz%I2 %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "doz%I2. %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI (gt (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  ""
  "doz%I2. %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

;; We don't need abs with condition code because such comparisons should
;; never be done.
(define_insn "abssi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "abs %0,%1")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r"))))]
  ""
  "nabs %0,%1")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "neg %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r"))]
  ""
  "neg. %2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (match_dup 1)))]
  ""
  "neg. %0,%1"
  [(set_attr "type" "compare")])

(define_insn "ffssi2"
  [(set (match_operand:SI 0 "register_operand" "=&r")
	(ffs:SI (match_operand:SI 1 "register_operand" "r")))]
  ""
  "neg %0,%1\;and %0,%0,%1\;cntlz %0,%0\;sfi %0,%0,32")

;; There is no need for (set (condition) (compare (ffs) 0)) because that
;; can be simplified to an ordinary comparison.  A parallel set and compare
;; might be used, so include it.

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (ffs:SI (match_operand:SI 1 "register_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=&r")
	(ffs:SI (match_dup 1)))]
  ""
  "neg %0,%1\;and %0,%0,%1\;cntlz %0,%0\;sfi. %0,%0,32"
  [(set_attr "type" "compare")])

(define_insn "mulsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
   (clobber (match_scratch:SI 3 "=q,q"))]
  ""
  "@
   muls %0,%1,%2
   muli %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))
   (clobber (match_scratch:SI 4 "=q"))]
  ""
  "muls. %3,%1,%2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(mult:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q"))]
  ""
  "muls. %0,%1,%2"
  [(set_attr "type" "delayed_compare")])

;; Operand 1 is divided by operand 2; quotient goes to operand
;; 0 and remainder to operand 3.
;; ??? At some point, see what, if anything, we can do about if (x % y == 0).

(define_insn "divmodsi4"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "gpc_reg_operand" "r")))
   (set (match_operand:SI 3 "gpc_reg_operand" "=q")
	(mod:SI (match_dup 1) (match_dup 2)))]
  ""
  "divs %0,%1,%2")

;; For powers of two we can do srai/aze for divide and then adjust for
;; modulus.  If it isn't a power of two, FAIL so divmodsi4 will be used.
(define_expand "divsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) != CONST_INT
      || exact_log2 (INTVAL (operands[2])) < 0)
    FAIL;
}")

(define_expand "modsi3"
  [(set (match_dup 3)
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" "")))
   (parallel [(set (match_dup 4) (ashift:SI (match_dup 3) (match_dup 5)))
	      (clobber (scratch:SI))])
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 1) (match_dup 4)))]
  ""
  "
{
  int i = exact_log2 (INTVAL (operands[2]));

  if (GET_CODE (operands[2]) != CONST_INT || i < 0)
    FAIL;

  operands[3] = gen_reg_rtx (SImode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = gen_rtx (CONST_INT, VOIDmode, i);
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "const_int_operand" "N")))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "srai %0,%1,%p2\;aze %0,%0")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "const_int_operand" "N")))
   (clobber (match_scratch:SI 3 "=r"))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "srai %3,%1,%p2\;aze. %3,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "const_int_operand" "N")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_dup 1) (match_dup 2)))]
  "exact_log2 (INTVAL (operands[2])) >= 0"
  "srai %0,%1,%p2\;aze. %0,%0"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(udiv:SI
	 (plus:DI (lshift:DI
		   (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 32))
		  (zero_extend:DI (match_operand:SI 4 "register_operand" "2")))
	 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (set (match_operand:SI 2 "register_operand" "=*q")
	(umod:SI
	 (plus:DI (lshift:DI
		   (zero_extend:DI (match_dup 1)) (const_int 32))
		  (zero_extend:DI (match_dup 4)))
	 (match_dup 3)))]
  
  ""
  "div %0,%1,%3")

;; To do unsigned divide we handle the cases of the divisor looking like a
;; negative number.  If it is a constant that is less than 2**31, we don't
;; have to worry about the branches.  So make a few subroutines here.
;;
;; First comes the normal case.
(define_expand "udivmodsi4_normal"
  [(set (match_dup 4) (const_int 0))
   (parallel [(set (match_operand:SI 0 "" "")
		   (udiv:SI (plus:DI (lshift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_operand:SI 1 "" "")))
			    (match_operand:SI 2 "" "")))
	      (set (match_operand:SI 3 "" "")
		   (umod:SI (plus:DI (lshift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_dup 1)))
			    (match_dup 2)))])]
  ""
  "
{ operands[4] = gen_reg_rtx (SImode); }")

;; This handles the branches.
(define_expand "udivmodsi4_tests"
  [(set (match_operand:SI 0 "" "") (const_int 0))
   (set (match_operand:SI 3 "" "") (match_operand:SI 1 "" ""))
   (set (match_dup 5) (compare:CCUNS (match_dup 1) (match_operand:SI 2 "" "")))
   (set (pc) (if_then_else (ltu (match_dup 5) (const_int 0))
			   (label_ref (match_operand:SI 4 "" "")) (pc)))
   (set (match_dup 0) (const_int 1))
   (set (match_dup 3) (minus:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 6) (compare:CC (match_dup 2) (const_int 0)))
   (set (pc) (if_then_else (lt (match_dup 6) (const_int 0))
			   (label_ref (match_dup 4)) (pc)))]
  ""
  "
{ operands[5] = gen_reg_rtx (CCUNSmode);
  operands[6] = gen_reg_rtx (CCmode);
}")

(define_expand "udivmodsi4"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "reg_or_cint_operand" "")))
	      (set (match_operand:SI 3 "gpc_reg_operand" "")
		   (umod:SI (match_dup 1) (match_dup 2)))])]
  ""
  "
{
  rtx label = 0;

  if (GET_CODE (operands[2]) != CONST_INT || INTVAL (operands[2]) < 0)
    {
      operands[2] = force_reg (SImode, operands[2]);
      label = gen_label_rtx ();
      emit (gen_udivmodsi4_tests (operands[0], operands[1], operands[2],
				  operands[3], label));
    }
  else
    operands[2] = force_reg (SImode, operands[2]);

  emit (gen_udivmodsi4_normal (operands[0], operands[1], operands[2],
			       operands[3]));
  if (label)
    emit_label (label);

  DONE;
}")
    
(define_insn "andsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
		(match_operand:SI 2 "and_operand" "?r,L,K,J")))
   (clobber (match_scratch:CC 3 "=X,X,x,x"))]
  ""
  "@
   and %0,%1,%2
   rlinm %0,%1,0,%m2,%M2
   andil. %0,%1,%b2
   andiu. %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,J,L"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r"))]
  ""
  "@
   and. %3,%1,%2
   andil. %3,%1,%b2
   andiu. %3,%1,%u2
   rlinm. %3,%1,0,%m2,%M2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,x")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,J,L"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   and. %0,%1,%2
   andil. %0,%1,%b2
   andiu. %0,%1,%u2
   rlinm. %0,%1,0,%m2,%M2"
  [(set_attr "type" "compare,compare,compare,delayed_compare")]) 

;; Take a AND with a constant that cannot be done in a single insn and try to
;; split it into two insns.  This does not verify that the insns are valid
;; since this need not be done as combine will do it.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "non_and_cint_operand" "")))]
  ""
  [(set (match_dup 0) (and:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (and:SI (match_dup 0) (match_dup 4)))]
  "
{
  int maskval = INTVAL (operands[2]);
  int i, transitions, last_bit_value;
  int orig = maskval, first_c = maskval, second_c;

  /* We know that MASKVAL must have more than 2 bit-transitions.  Start at
     the low-order bit and count for the third transition.  When we get there,
     make a first mask that has everything to the left of that position
     a one.  Then make the second mask to turn off whatever else is needed.  */

  for (i = 1, transitions = 0, last_bit_value = maskval & 1; i < 32; i++)
    {
      if (((maskval >>= 1) & 1) != last_bit_value)
	last_bit_value ^= 1, transitions++;

      if (transitions > 2)
	{
	  first_c |= (~0) << i;
	  break;
	}
    }

  second_c = orig | ~ first_c;

  operands[3] = gen_rtx (CONST_INT, VOIDmode, first_c);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, second_c);
}")

(define_insn "iorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:SI 2 "logical_operand" "r,K,J")))]
  ""
  "@
   or %0,%1,%2
   oril %0,%1,%b2
   oriu %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "or. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (match_dup 1) (match_dup 2)))]
  ""
  "or. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an IOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "non_logical_cint_operand" "")))]
  ""
  [(set (match_dup 0) (ior:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (ior:SI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = gen_rtx (CONST_INT, VOIDmode,
			 INTVAL (operands[2]) & 0xffff0000);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, INTVAL (operands[2]) & 0xffff);
}")

(define_insn "xorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r")
		(match_operand:SI 2 "logical_operand" "r,K,J")))]
  ""
  "@
   xor %0,%1,%2
   xoril %0,%1,%b2
   xoriu %0,%1,%u2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (xor:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "xor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (xor:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(xor:SI (match_dup 1) (match_dup 2)))]
  ""
  "xor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; Split an XOR that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "non_logical_cint_operand" "")))]
  ""
  [(set (match_dup 0) (xor:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (xor:SI (match_dup 0) (match_dup 4)))]
"
{
  operands[3] = gen_rtx (CONST_INT, VOIDmode,
			 INTVAL (operands[2]) & 0xffff0000);
  operands[4] = gen_rtx (CONST_INT, VOIDmode, INTVAL (operands[2]) & 0xffff);
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			(match_operand:SI 2 "gpc_reg_operand" "r"))))]
   ""
   "eqv %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
				    (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
   ""
   "eqv. %3,%1,%2"
   [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (not:SI (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
				    (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (xor:SI (match_dup 1) (match_dup 2))))]
   ""
   "eqv. %0,%1,%2"
   [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(match_operand:SI 2 "gpc_reg_operand" "r")))]
  ""
  "andc %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "andc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_dup 1)) (match_dup 2)))]
  ""
  "andc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(match_operand:SI 2 "gpc_reg_operand" "r")))]
  ""
  "orc %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "orc. %3,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_dup 1)) (match_dup 2)))]
  ""
  "orc. %0,%2,%1"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  ""
  "nand %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "nand. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (ior:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (not:SI (match_dup 1)) (not:SI (match_dup 2))))]
  ""
  "nand. %0,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		(not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  ""
  "nor %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "nor. %3,%1,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (and:SI (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
			    (not:SI (match_operand:SI 2 "gpc_reg_operand" "r")))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (not:SI (match_dup 1)) (not:SI (match_dup 2))))]
  ""
  "nor. %0,%1,%2"
  [(set_attr "type" "compare")])

;; maskir insn.  We need four forms because things might be in arbitrary
;; orders.  Don't define forms that only set CR fields because these
;; would modify an input register.

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_dup 2)
			(match_operand:SI 3 "gpc_reg_operand" "r"))))]
  ""
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:SI 0 "register_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_dup 2))))]
  ""
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			(match_operand:SI 3 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  ""
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_operand:SI 2 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  ""
  "maskir %0,%3,%2")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0"))
		 (and:SI (match_dup 2)
			 (match_operand:SI 3 "gpc_reg_operand" "r")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 2) (match_dup 3))))]
  ""
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0"))
		 (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_dup 2)))
	 (const_int 0)))
   (set (match_operand:SI 0 "register_operand" "=r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 3) (match_dup 2))))]
  ""
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			 (match_operand:SI 3 "gpc_reg_operand" "r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_dup 2) (match_dup 3))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  ""
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_dup 3) (match_dup 2))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  ""
  "maskir. %0,%3,%2"
  [(set_attr "type" "compare")])

;; Rotate and shift insns, in all their variants.  These support shifts,
;; field inserts and extracts, and various combinations thereof.
(define_insn "insv"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(match_operand:SI 3 "gpc_reg_operand" "r"))]
  ""
  "*
{
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = gen_rtx (CONST_INT, VOIDmode, 32 - start - size);
  operands[1] = gen_rtx (CONST_INT, VOIDmode, start + size - 1);
  return \"rlimi %0,%3,%4,%h2,%h1\";
}")

(define_insn "extzv"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i")))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = gen_rtx (CONST_INT, VOIDmode, start + size);
  return \"rlinm %0,%1,%3,%s2,31\";
}")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  /* If the bitfield being tested fits in the upper or lower half of a
     word, it is possible to use andiu. or andil. to test it.  This is
     useful because the condition register set-use delay is smaller for
     andi[ul]. than for rlinm.  This doesn't work when the starting bit
     position is 0 because the LT and GT bits may be set wrong.  */

  if ((start > 0 && start + size <= 16) || start >= 16)
    {
      operands[3] = gen_rtx (CONST_INT, VOIDmode,
			     ((1 << (16 - (start & 15)))
			      - (1 << (16 - (start & 15) - size))));
      if (start < 16)
	return \"andiu. %4,%1,%3\";
      else
	return \"andil. %4,%1,%3\";
    }
  
  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = gen_rtx (CONST_INT, VOIDmode, start + size);
  return \"rlinm. %4,%1,%3,%s2,31\";
}"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_dup 1) (match_dup 2) (match_dup 3)))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  if (start >= 16 && start + size == 32)
    {
      operands[3] = gen_rtx (CONST_INT, VOIDmode, (1 << (32 - start)) - 1);
      return \"andil. %0,%1,%3\";
    }
  
  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = gen_rtx (CONST_INT, VOIDmode, start + size);
  return \"rlinm. %0,%1,%3,%s2,31\";
}"
  [(set_attr "type" "delayed_compare")])

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  ""
  "rl%I2nm %0,%1,%h2,0,31")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "rl%I2nm. %3,%1,%h2,0,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(rotate:SI (match_dup 1) (match_dup 2)))]
  ""
  "rl%I2nm. %0,%1,%h2,0,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		(match_operand:SI 3 "mask_operand" "L")))]
  ""
  "rl%I2nm %0,%1,%h2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:SI 3 "mask_operand" "L"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  ""
  "rl%I2nm. %4,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri"))
		     (match_operand:SI 3 "mask_operand" "L"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (rotate:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  ""
  "rl%I2nm. %0,%1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "rl%I2nm %0,%1,%h2,24,31")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "rl%I2nm. %3,%1,%h2,24,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:QI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "rl%I2nm. %0,%1,%h2,24,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "rl%I2nm %0,%1,%h2,16,31")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "rl%I2nm. %3,%1,%h2,16,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:HI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "rl%I2nm. %0,%1,%h2,16,31"
  [(set_attr "type" "delayed_compare")])

;; Note that we use "sle." instead of "sl." so that we can set
;; SHIFT_COUNT_TRUNCATED.

(define_insn "ashlsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  ""
  "@
   sle %0,%1,%2
   sli %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  ""
  "@
   sle. %3,%1,%2
   sli. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  ""
  "@
   sle. %0,%1,%2
   sli. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "L")))]
  "includes_lshift_p (operands[2], operands[3])"
  "rlinm %0,%h1,%h2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  "includes_lshift_p (operands[2], operands[3])"
  "rlinm. %4,%h1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			    (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (ashift:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_lshift_p (operands[2], operands[3])"
  "rlinm. %0,%h1,%h2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

;; The RS/6000 assembler mis-handles "sri x,x,0", so write that case as
;; "sli x,x,0".
(define_insn "lshrsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  ""
  "@
  sre %0,%1,%2
  s%A2i %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  ""
  "@
  sre. %3,%1,%2
  s%A2i. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  ""
  "@
  sre. %0,%1,%2
  s%A2i. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "L")))]
  "includes_rshift_p (operands[2], operands[3])"
  "rlinm %0,%1,%s2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r"))]
  "includes_rshift_p (operands[2], operands[3])"
  "rlinm. %4,%1,%s2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			      (match_operand:SI 2 "const_int_operand" "i"))
		 (match_operand:SI 3 "mask_operand" "L"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (lshiftrt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_rshift_p (operands[2], operands[3])"
  "rlinm. %0,%1,%s2,%m3,%M3"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 255))"
  "rlinm %0,%1,%s2,24,31")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 255))"
  "rlinm. %3,%1,%s2,24,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:QI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 255))"
  "rlinm. %0,%1,%s2,24,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 65535))"
  "rlinm %0,%1,%s2,16,31")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r"))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 65535))"
  "rlinm. %3,%1,%s2,16,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "const_int_operand" "i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI (subreg:HI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], gen_rtx (CONST_INT, VOIDmode, 65535))"
  "rlinm. %0,%1,%s2,16,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(ashiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  ""
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(lshiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  ""
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(zero_extract:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			 (const_int 1)
			 (const_int 0)))]
  ""
  "rrib %0,%1,%2")

(define_insn "ashrsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  ""
  "@
   srea %0,%1,%2
   srai %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,X"))]
  ""
  "@
   srea. %3,%1,%2
   srai. %3,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X"))]
  ""
  "@
   srea. %0,%1,%2
   srai. %0,%1,%h2"
  [(set_attr "type" "delayed_compare")])

(define_expand "extendqisi2"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  ""
  "
{ operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "extendqihi2"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:HI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  ""
  "
{ operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

;; Floating-point insns, excluding normal data motion.
;;
;; We pretend that we have both SFmode and DFmode insns, while, in fact,
;; all fp insns are actually done in double.  The only conversions we will
;; do will be when storing to memory.  In that case, we will use the "frsp"
;; instruction before storing.
;;
;; Note that when we store into a single-precision memory location, we need to
;; use the frsp insn first.  If the register being stored isn't dead, we
;; need a scratch register for the frsp.  But this is difficult when the store
;; is done by reload.  It is not incorrect to do the frsp on the register in
;; this case, we just lose precision that we would have otherwise gotten but
;; is not guaranteed.  Perhaps this should be tightened up at some point.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float_extend:DF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  ""
  "*
{
  if (REGNO (operands[0]) == REGNO (operands[1]))
    return \"\";
  else
    return \"fmr %0,%1\";
}"
  [(set_attr "type" "fp")])

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(float_truncate:SF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  ""
  "*
{
  if (REGNO (operands[0]) == REGNO (operands[1]))
    return \"\";
  else
    return \"fmr %0,%1\";
}"
  [(set_attr "type" "fp")])

(define_insn "negsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  ""
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_insn "abssf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(abs:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  ""
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (abs:SF (match_operand:SF 1 "gpc_reg_operand" "f"))))]
  ""
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn "addsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  ""
  "fa %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "subsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		  (match_operand:SF 2 "gpc_reg_operand" "f")))]
  ""
  "fs %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "mulsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  ""
  "fm %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "divsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		(match_operand:SF 2 "gpc_reg_operand" "f")))]
  ""
  "fd %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			  (match_operand:SF 2 "gpc_reg_operand" "f"))
		 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  ""
  "fma %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
		  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  ""
  "fms %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				  (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  ""
  "fnma %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				   (match_operand:SF 2 "gpc_reg_operand" "f"))
			  (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  ""
  "fnms %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "negdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  ""
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_insn "absdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(abs:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  ""
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (abs:DF (match_operand:DF 1 "gpc_reg_operand" "f"))))]
  ""
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn "adddf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  ""
  "fa %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "subdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		  (match_operand:DF 2 "gpc_reg_operand" "f")))]
  ""
  "fs %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "muldf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  ""
  "fm %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "divdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(div:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		(match_operand:DF 2 "gpc_reg_operand" "f")))]
  ""
  "fd %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			  (match_operand:DF 2 "gpc_reg_operand" "f"))
		 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  ""
  "fma %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			   (match_operand:DF 2 "gpc_reg_operand" "f"))
		  (match_operand:DF 3 "gpc_reg_operand" "f")))]
  ""
  "fms %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				  (match_operand:DF 2 "gpc_reg_operand" "f"))
			 (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  ""
  "fnma %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				   (match_operand:DF 2 "gpc_reg_operand" "f"))
			  (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  ""
  "fnms %0,%1,%2,%3"
  [(set_attr "type" "fp")])

;; Conversions to and from floating-point.
(define_expand "floatsidf2"
  [(set (match_dup 2)
	(plus:DI (zero_extend:DI
		  (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_dup 3)))
		 (match_dup 4)))
   (set (match_operand:DF 0 "gpc_reg_operand" "")
	(minus:DF (subreg:DF (match_dup 2) 0)
		  (match_dup 5)))]
  ""
  "
{
#if HOST_BITS_PER_INT != BITS_PER_WORD
  /* Maybe someone can figure out how to do this in that case.  I don't
     want to right now.  */
  abort ();
#endif

  operands[2] = gen_reg_rtx (DImode);
  operands[3] = gen_rtx (CONST_INT, VOIDmode, 0x80000000);
  operands[4] = immed_double_const (0, 0x43300000, DImode);
  operands[5] = force_reg (DFmode, immed_double_const (0x43300000,
						       0x80000000, DFmode));
}")

(define_expand "floatunssidf2"
  [(set (match_dup 2)
	(plus:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (match_dup 3)))
   (set (match_operand:DF 0 "gpc_reg_operand" "")
	(minus:DF (subreg:DF (match_dup 2) 0)
		  (match_dup 4)))]
  ""
  "
{
#if HOST_BITS_PER_INT != BITS_PER_WORD
  /* Maybe someone can figure out how to do this in that case.  I don't
     want to right now.  */
  abort ();
#endif

  operands[2] = gen_reg_rtx (DImode);
  operands[3] = immed_double_const (0, 0x43300000, DImode);
  operands[4] = force_reg (DFmode, immed_double_const (0x43300000, 0, DFmode));
}")

;; For the above two cases, we always split.
(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (zero_extend:DI
		  (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "logical_operand" "")))
		 (match_operand:DI 3 "immediate_operand" "")))]
  "reload_completed && HOST_BITS_PER_INT == BITS_PER_WORD
   && GET_CODE (operands[3]) == CONST_DOUBLE
   && CONST_DOUBLE_LOW (operands[3]) == 0"
  [(set (match_dup 6) (xor:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 4) (match_dup 5))]
  "
{ operands[4] = operand_subword (operands[0], 0, 0, DImode);
  operands[5] = operand_subword (operands[3], 0, 0, DImode);
  operands[6] = operand_subword (operands[0], 1, 0, DImode);
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(plus:DI (zero_extend:DI
		  (xor:SI (match_operand:SI 1 "gpc_reg_operand" "%r")
			  (match_operand:SI 2 "logical_operand" "rKJ")))
		 (match_operand:DI 3 "immediate_operand" "n")))]
  "HOST_BITS_PER_INT == BITS_PER_WORD
   && GET_CODE (operands[3]) == CONST_DOUBLE
   && CONST_DOUBLE_LOW (operands[3]) == 0"
  "#")
  
(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "=")
	(plus:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (match_operand:DI 2 "immediate_operand" "")))]
  "reload_completed && HOST_BITS_PER_INT == BITS_PER_WORD
   && GET_CODE (operands[2]) == CONST_DOUBLE
   && CONST_DOUBLE_LOW (operands[2]) == 0"
  [(set (match_dup 3) (match_dup 4))
   (set (match_dup 5) (match_dup 1))]
  "
{ operands[3] = operand_subword (operands[0], 0, 0, DImode);
  operands[4] = operand_subword (operands[2], 0, 0, DImode);
  operands[5] = operand_subword (operands[0], 1, 0, DImode);

  if (rtx_equal_p (operands[1], operands[5]))
    {
      emit_move_insn (operands[3], operands[4]);
      DONE;
    }

  if (rtx_equal_p (operands[1], operands[3]))
    {
      rtx temp;

      temp = operands[3]; operands[3] = operands[5]; operands[5] = temp;
      temp = operands[4]; operands[4] = operands[1]; operands[1] = temp;
    }
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(plus:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		 (match_operand:DI 2 "immediate_operand" "n")))]
  "HOST_BITS_PER_INT == BITS_PER_WORD
   && GET_CODE (operands[2]) == CONST_DOUBLE
   && CONST_DOUBLE_LOW (operands[2]) == 0"
  "#")

(define_expand "fix_truncdfsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(fix:DF (match_operand:DF 1 "gpc_reg_operand" "")))]
  ""
  "
{
  emit_insn (gen_trunc_call (operands[0], operands[1],
			     gen_rtx (SYMBOL_REF, Pmode, \"itrunc\")));
  DONE;
}")

(define_expand "fixuns_truncdfsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(unsigned_fix:DF (match_operand:DF 1 "gpc_reg_operand" "")))]
  ""
  "
{
  emit_insn (gen_trunc_call (operands[0], operands[1],
			     gen_rtx (SYMBOL_REF, Pmode, \"uitrunc\")));
  DONE;
}")


(define_expand "trunc_call"
  [(parallel [(set (match_operand:SI 0 "" "")
		   (fix:DF (match_operand:DF 1 "" "")))
	      (use (match_operand:SI 2 "" ""))])]
  ""
  "
{
  rtx insns = gen_trunc_call_rtl (operands[0], operands[1], operands[2]);
  rtx first = XVECEXP (insns, 0, 0);
  rtx last = XVECEXP (insns, 0, XVECLEN (insns, 0) - 1);

  REG_NOTES (first) = gen_rtx (INSN_LIST, REG_LIBCALL, last,
			       REG_NOTES (first));
  REG_NOTES (last) = gen_rtx (INSN_LIST, REG_RETVAL, first, REG_NOTES (last));

  emit_insn (insns);
  DONE;
}")

(define_expand "trunc_call_rtl"
  [(set (reg:DF 33) (match_operand:DF 1 "gpc_reg_operand" ""))
   (use (reg:DF 33))
   (parallel [(set (reg:SI 3)
		   (call (mem:SI (match_operand 2 "" "")) (const_int 0)))
	      (clobber (scratch:SI))])
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(reg:SI 3))]
  ""
  "
{ 
  rs6000_trunc_used = 1;
}")

;; Define the DImode operations that can be done in a small number
;; of instructions.
(define_insn "adddi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
		 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  ""
  "a %L0,%L1,%L2\;ae %0,%1,%2")

(define_insn "subdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(minus:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		  (match_operand:DI 2 "gpc_reg_operand" "r")))]
  ""
  "sf %L0,%L2,%L1\;sfe %0,%2,%1")

(define_insn "negdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  ""
  "sfi %L0,%L1,0\;sfze %0,%1")

(define_insn "mulsidi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))
   (clobber (match_scratch:SI 3 "=q"))]
  ""
  "mul %0,%1,%2\;mfmq %L0")

;; If operands 0 and 2 are in the same register, we have a problem.  But
;; operands 0 and 1 (the usual case) can be in the same register.  That's
;; why we have the strange constraints below.
(define_insn "ashldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,&r")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  ""
  "@
   sli %0,%L1,%h2\;cal %L0,0(0)
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2")

(define_insn "lshrdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r,r,&r")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  ""
  "@
   cal %0,0(0)\;s%A2i %L0,%1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2")

;; Shift by a variable amount is too complex to be worth open-coding.  We
;; just handle shifts by constants.

(define_expand "ashrdi3"
  [(parallel [(set (match_operand:DI 0 "gpc_reg_operand" "=")
		   (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "general_operand" "")))
	      (clobber (match_scratch:SI 3 ""))])]
  ""
  "
{ if (GET_CODE (operands[2]) != CONST_INT)
    FAIL;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "const_int_operand" "M,i")))
   (clobber (match_scratch:SI 3 "=X,q"))]
  ""
  "@
   srai %0,%1,31\;srai %L0,%1,%h2
   sraiq %0,%1,%h2\;srliq %L0,%L1,%h2")

;; Now define ways of moving data around.
;;
;; For SI, we special-case integers that can't be loaded in one insn.  We
;; do the load 16-bits at a time.  We could do this by loading from memory,
;; and this is even supposed to be faster, but it is simpler not to get
;; integers in the TOC.
(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	(match_operand:SI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (SImode, operands[1]);

  if (CONSTANT_P (operands[1]) && GET_CODE (operands[1]) != CONST_INT)
    operands[1] = force_const_mem (SImode, operands[1]);

  if (GET_CODE (operands[1]) == CONST_INT
      && (unsigned) (INTVAL (operands[1]) + 0x8000) >= 0x10000
      && (INTVAL (operands[1]) & 0xffff) != 0)
    {
      emit_move_insn (operands[0],
		      gen_rtx (CONST_INT, VOIDmode,
			       INTVAL (operands[1]) & 0xffff0000));
      emit_insn (gen_iorsi3 (operands[0], operands[0],
			     gen_rtx (CONST_INT, VOIDmode,
				      INTVAL (operands[1]) & 0xffff)));
      DONE;
    }
}")

(define_insn ""
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,r,m,r,r,r,*c*q,*l")
	(match_operand:SI 1 "input_operand" "r,m,r,I,J,*h,r,r"))]
  "gpc_reg_operand (operands[0], SImode)
   || gpc_reg_operand (operands[1], SImode)"
  "@
   ai %0,%1,0
   l%U1%X1 %0,%1
   st%U0%X0 %1,%0
   cal %0,%1(0)
   cau %0,0,%u1
   mf%1 %0
   mt%0 %1
   mt%0 %1"
  [(set_attr "type" "*,load,*,*,*,*,*,mtlr")])

;; Split a load of a large constant into the appropriate two-insn
;; sequence.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_operand:SI 1 "const_int_operand" ""))]
  "(unsigned) (INTVAL (operands[1]) + 0x8000) >= 0x10000
   && (INTVAL (operands[1]) & 0xffff) != 0"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ior:SI (match_dup 0)
		(match_dup 3)))]
  "
{
  operands[2] = gen_rtx (CONST_INT, VOIDmode,
			 INTVAL (operands[1]) & 0xffff0000);
  operands[3] = gen_rtx (CONST_INT, VOIDmode, INTVAL (operands[1]) & 0xffff);
}")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r") (match_dup 1))]
  ""
  "ai. %0,%1,0"
  [(set_attr "type" "compare")])

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_operand" "")
	(match_operand:HI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (HImode, operands[1]);

  if (CONSTANT_P (operands[1]) && GET_CODE (operands[1]) != CONST_INT)
    operands[1] = force_const_mem (HImode, operands[1]);
}")

(define_insn ""
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,r,m,r,r,*h")
	(match_operand:HI 1 "input_operand" "r,m,r,i,*h,r"))]
  "gpc_reg_operand (operands[0], HImode)
   || gpc_reg_operand (operands[1], HImode)"
  "@
   oril %0,%1,0
   lhz%U1%X1 %0,%1
   sth%U0%X0 %1,%0
   cal %0,%w1(0)
   mf%1 %0
   mt%0 %1"
  [(set_attr "type" "*,load,*,*,*,*")])

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "any_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[0]) != REG)
    operands[1] = force_reg (QImode, operands[1]);

  if (CONSTANT_P (operands[1]) && GET_CODE (operands[1]) != CONST_INT)
    operands[1] = force_const_mem (QImode, operands[1]);
}")

(define_insn ""
  [(set (match_operand:QI 0 "nonimmediate_operand" "=r,r,m,r,r,*h")
	(match_operand:QI 1 "input_operand" "r,m,r,i,*h,r"))]
  "gpc_reg_operand (operands[0], QImode)
   || gpc_reg_operand (operands[1], QImode)"
  "@
   oril %0,%1,0
   lbz%U1%X1 %0,%1
   stb%U0%X0 %1,%0
   cal %0,%1(0)
   mf%1 %0
   mt%0 %1"
  [(set_attr "type" "*,load,*,*,*,*")])

;; Here is how to move condition codes around.  When we store CC data in
;; an integer register or memory, we store just the high-order 4 bits.
;; This lets us not shift in the most common case of CR0.
(define_expand "movcc"
  [(set (match_operand:CC 0 "nonimmediate_operand" "")
	(match_operand:CC 1 "nonimmediate_operand" ""))]
  ""
  "")

(define_insn ""
  [(set (match_operand:CC 0 "nonimmediate_operand" "=y,x,y,r,r,r,r,m")
	(match_operand:CC 1 "nonimmediate_operand" "y,r,r,x,y,r,m,r"))]
  "register_operand (operands[0], CCmode)
   || register_operand (operands[1], CCmode)"
  "@
   mcrf %0,%1
   mtcrf 128,%1
   rlinm %1,%1,%F0,0,31\;mtcrf %R0,%1\;rlinm %1,%1,%f0,0,31
   mfcr %0
   mfcr %0\;rlinm %0,%0,%f1,0,3
   ai %0,%1,0
   l%U1%X1 %0,%1
   st%U0%U1 %1,%0"
  [(set_attr "type" "*,*,*,compare,*,*,load,*")])

;; For floating-point, we normally deal with the floating-point registers.
;; The sole exception is that parameter passing can produce floating-point
;; values in fixed-point registers.  Unless the value is a simple constant
;; or already in memory, we deal with this by allocating memory and copying
;; the value explicitly via that memory location.
(define_expand "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
	(match_operand:SF 1 "any_operand" ""))]
  ""
  "
{
  /* If we are called from reload, we might be getting a SUBREG of a hard
     reg.  So expand it.  */
  if (GET_CODE (operands[0]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[0])) == REG
      && REGNO (SUBREG_REG (operands[0])) < FIRST_PSEUDO_REGISTER)
    operands[0] = alter_subreg (operands[0]);
  if (GET_CODE (operands[1]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[1])) == REG
      && REGNO (SUBREG_REG (operands[1])) < FIRST_PSEUDO_REGISTER)
    operands[1] = alter_subreg (operands[1]);

  /* If we are being called from reload, it is possible that operands[1]
     is a hard non-fp register.  So handle those cases.  */
  if (reload_in_progress && GET_CODE (operands[1]) == REG
      && REGNO (operands[1]) < 32)
    {
      rtx stack_slot;

      /* Remember that we only see a pseudo here if it didn't get a hard
	 register, so it is memory.  */
      if (GET_CODE (operands[0]) == MEM
	  || (GET_CODE (operands[0]) == REG
	      && (REGNO (operands[0]) < 32
		  || REGNO (operands[0]) >= FIRST_PSEUDO_REGISTER))
	  || (GET_CODE (operands[0]) == REG && REGNO (operands[0]) < 32))
	{
	  emit_move_insn (operand_subword (operands[0], 0, 0, SFmode),
			  operand_subword (operands[1], 0, 0, SFmode));
	  DONE;
	}

      stack_slot = gen_rtx (MEM, SFmode, plus_constant (stack_pointer_rtx, 4));
      emit_move_insn (stack_slot, operands[1]);
      emit_move_insn (operands[0], stack_slot);
      DONE;
    }

  if (GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (SFmode, operands[1]);

  if (GET_CODE (operands[0]) == REG && REGNO (operands[0]) < 32)
    {
      rtx stack_slot;

      if (GET_CODE (operands[1]) == MEM
#if HOST_FLOAT_FORMAT == TARGET_FLOAT_FORMAT && ! defined(REAL_IS_NOT_DOUBLE)
	  || GET_CODE (operands[1]) == CONST_DOUBLE
#endif
	  || (GET_CODE (operands[1]) == REG && REGNO (operands[1]) < 32)
	  || (reload_in_progress && GET_CODE (operands[1]) == REG
	      && REGNO (operands[1]) >= FIRST_PSEUDO_REGISTER))
	{
	  emit_move_insn (operand_subword (operands[0], 0, 0, SFmode),
			  operand_subword (operands[1], 0, 0, SFmode));
	  DONE;
	}

      if (reload_in_progress)
	stack_slot = gen_rtx (MEM, SFmode,
			      plus_constant (stack_pointer_rtx, 4));
      else
	stack_slot = assign_stack_temp (SFmode, 4, 0);
      emit_move_insn (stack_slot, operands[1]);
      emit_move_insn (operands[0], stack_slot);
      DONE;
    }

  if (CONSTANT_P (operands[1]))
    {
      operands[1] = force_const_mem (SFmode, operands[1]);
      if (! memory_address_p (SFmode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], SFmode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=r,r")
	(match_operand:SF 1 "mem_or_easy_const_operand" "G,m"))]
  "REGNO (operands[0]) <= 31"
  "@
   #
   l%U1%X1 %0,%1"
  [(set_attr "type" "*,load")])

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(match_operand:SF 1 "easy_fp_constant" ""))]
  "reload_completed && REGNO (operands[0]) <= 31"
  [(set (match_dup 2) (match_dup 3))]
  "
{ operands[2] = operand_subword (operands[0], 0, 0, SFmode);
  operands[3] = operand_subword (operands[1], 0, 0, SFmode); }")
  
(define_insn ""
  [(set (match_operand:SF 0 "fp_reg_or_mem_operand" "=f,f,m")
	(match_operand:SF 1 "input_operand" "f,m,f"))]
  "gpc_reg_operand (operands[0], SFmode)
   || gpc_reg_operand (operands[1], SFmode)"
  "@
   fmr %0,%1
   lfs%U1%X1 %0,%1
   frsp %1,%1\;stfs%U0%X0 %1,%0"
  [(set_attr "type" "fp,load,*")])

(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "any_operand" ""))]
  ""
  "
{
  /* If we are called from reload, we might be getting a SUBREG of a hard
     reg.  So expand it.  */
  if (GET_CODE (operands[0]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[0])) == REG
      && REGNO (SUBREG_REG (operands[0])) < FIRST_PSEUDO_REGISTER)
    operands[0] = alter_subreg (operands[0]);
  if (GET_CODE (operands[1]) == SUBREG
      && GET_CODE (SUBREG_REG (operands[1])) == REG
      && REGNO (SUBREG_REG (operands[1])) < FIRST_PSEUDO_REGISTER)
    operands[1] = alter_subreg (operands[1]);

  /* If we are being called from reload, it is possible that operands[1]
     is a hard non-fp register.  So handle those cases.  */
  if (reload_in_progress && GET_CODE (operands[1]) == REG
      && REGNO (operands[1]) < 32)
    {
      rtx stack_slot;

      /* Remember that we only see a pseudo here if it didn't get a hard
	 register, so it is memory.  */
      if (GET_CODE (operands[0]) == MEM
	  || (GET_CODE (operands[0]) == REG
	      && (REGNO (operands[0]) < 32
		  || REGNO (operands[0]) >= FIRST_PSEUDO_REGISTER)))
	{
	  emit_move_insn (operand_subword (operands[0], 0, 0, DFmode),
			  operand_subword (operands[1], 0, 0, DFmode));
	  emit_move_insn (operand_subword (operands[0], 1, 0, DFmode),
			  operand_subword (operands[1], 1, 0, DFmode));
	  DONE;
	}

      stack_slot = gen_rtx (MEM, DFmode, plus_constant (stack_pointer_rtx, 8));
      emit_move_insn (stack_slot, operands[1]);
      emit_move_insn (operands[0], stack_slot);
      DONE;
    }

  if (GET_CODE (operands[0]) == MEM)
    {
      if (GET_CODE (operands[1]) == MEM)
	{
	  emit_move_insn (operand_subword (operands[0], 0, 0, DFmode),
			  operand_subword (operands[1], 0, 0, DFmode));
	  emit_move_insn (operand_subword (operands[0], 1, 0, DFmode),
			  operand_subword (operands[1], 1, 0, DFmode));
	  DONE;
	}
      
      operands[1] = force_reg (DFmode, operands[1]);
    }

  if (GET_CODE (operands[0]) == REG && REGNO (operands[0]) < 32)
    {
      rtx stack_slot;

      if (GET_CODE (operands[1]) == MEM
#if HOST_FLOAT_FORMAT == TARGET_FLOAT_FORMAT && ! defined(REAL_IS_NOT_DOUBLE)
	  || GET_CODE (operands[1]) == CONST_DOUBLE
#endif
	  || (GET_CODE (operands[1]) == REG && REGNO (operands[1]) < 32)
	  || (reload_in_progress && GET_CODE (operands[1]) == REG
	      && REGNO (operands[1]) >= FIRST_PSEUDO_REGISTER))
	{
	  emit_move_insn (operand_subword (operands[0], 0, 0, DFmode),
			  operand_subword (operands[1], 0, 0, DFmode));
	  emit_move_insn (operand_subword (operands[0], 1, 0, DFmode),
			  operand_subword (operands[1], 1, 0, DFmode));
	  DONE;
	}

      if (reload_in_progress)
	stack_slot = gen_rtx (MEM, DFmode,
			      plus_constant (stack_pointer_rtx, 8));
      else
	stack_slot = assign_stack_temp (DFmode, 8, 0);
      emit_move_insn (stack_slot, operands[1]);
      emit_move_insn (operands[0], stack_slot);
      DONE;
    }

  if (CONSTANT_P (operands[1]))
    {
      operands[1] = force_const_mem (DFmode, operands[1]);
      if (! memory_address_p (DFmode, XEXP (operands[1], 0))
	  && ! reload_in_progress)
	operands[1] = change_address (operands[1], DFmode,
				      XEXP (operands[1], 0));
    }
}")

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=r,r")
	(match_operand:DF 1 "mem_or_easy_const_operand" "G,m"))]
  "REGNO (operands[0]) <= 31"
  "@
   #
   l %0,%1\;l %L0,%L1"
  [(set_attr "type" "*,load")])

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "easy_fp_constant" ""))]
  "reload_completed && REGNO (operands[0]) <= 31"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 5))]
  "
{ operands[2] = operand_subword (operands[0], 0, 0, DFmode);
  operands[3] = operand_subword (operands[1], 0, 0, DFmode);
  operands[4] = operand_subword (operands[0], 1, 0, DFmode);
  operands[5] = operand_subword (operands[1], 1, 0, DFmode); }")
  
(define_insn ""
  [(set (match_operand:DF 0 "fp_reg_or_mem_operand" "=f,f,m")
	(match_operand:DF 1 "fp_reg_or_mem_operand" "f,m,f"))]
  "gpc_reg_operand (operands[0], DFmode)
   || gpc_reg_operand (operands[1], DFmode)"
  "@
   fmr %0,%1
   lfd%U1%X1 %0,%1
   stfd%U0%X0 %1,%0"
  [(set_attr "type" "fp,load,*")])

;; Next come the multi-word integer load and store and the load and store
;; multiple insns.
(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
	(match_operand:DI 1 "general_operand" ""))]
  ""
  "
{
  if (GET_CODE (operands[1]) == CONST_DOUBLE
      || GET_CODE (operands[1]) == CONST_INT)
    {
      emit_move_insn (operand_subword (operands[0], 0, 0, DImode),
		      operand_subword (operands[1], 0, 0, DImode));
      emit_move_insn (operand_subword (operands[0], 1, 0, DImode),
		      operand_subword (operands[1], 1, 0, DImode));
      DONE;
    }

  if (GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (DImode, operands[1]);
}")

(define_insn ""
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,m")
	(match_operand:DI 1 "input_operand" "r,m,r"))]
  "gpc_reg_operand (operands[0], DImode)
   || gpc_reg_operand (operands[1], DImode)"
  "*
{
  switch (which_alternative)
    {
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"oril %L0,%L1,0\;oril %0,%1,0\";
      else
	return \"oril %0,%1,0\;oril %L0,%L1,0\";
    case 1:
      /* If the low-address word is used in the address, we must load it
	 last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is known to be
	 dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands [1], 0))
	return \"l %L0,%L1\;l %0,%1\";
      else
	return \"l%U1 %0,%1\;l %L0,%L1\";
    case 2:
      return \"st%U0 %1,%0\;st %L1,%L0\";
    }
}"
  [(set_attr "type" "*,load,*")])

;; TImode is similar, except that we usually want to compute the address into
;; a register and use lsi/stsi (the exception is during reload).  MQ is also
;; clobbered in stsi, so we need a SCRATCH for it.
(define_expand "movti"
  [(parallel [(set (match_operand:TI 0 "general_operand" "")
		   (match_operand:TI 1 "general_operand" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
  if (GET_CODE (operands[0]) == MEM)
    operands[1] = force_reg (TImode, operands[1]);

  if (GET_CODE (operands[0]) == MEM
      && GET_CODE (XEXP (operands[0], 0)) != REG
      && ! reload_in_progress)
    operands[0] = change_address (operands[0], TImode,
				  copy_addr_to_reg (XEXP (operands[0], 0)));

  if (GET_CODE (operands[1]) == MEM
      && GET_CODE (XEXP (operands[1], 0)) != REG
      && ! reload_in_progress)
    operands[1] = change_address (operands[1], TImode,
				  copy_addr_to_reg (XEXP (operands[1], 0)));
}")

;; We say that MQ is clobbered in the last alternative because the first
;; alternative would never get used otherwise since it would need a reload
;; while the 2nd alternative would not.  We put memory cases first so they
;; are preferred.  Otherwise, we'd try to reload the output instead of
;; giving the SCRATCH mq.
(define_insn ""
  [(set (match_operand:TI 0 "reg_or_mem_operand" "=Q,m,r,r,r")
	(match_operand:TI 1 "reg_or_mem_operand" "r,r,r,Q,m"))
   (clobber (match_scratch:SI 2 "=q,q#X,X,X,X"))]
  "gpc_reg_operand (operands[0], TImode)
   || gpc_reg_operand (operands[1], TImode)"
  "*
{
  switch (which_alternative)
    {
    case 0:
      return \"stsi %1,%P0,16\";

    case 1:
      return \"st%U0 %1,%0\;st %L1,%L0\;st %Y1,%Y0\;st %Z1,%Z0\";

    case 2:
      /* Normally copy registers with lowest numbered register copied first.
	 But copy in the other order if the first register of the output
	 is the second, third, or fourth register in the input.  */
      if (REGNO (operands[0]) >= REGNO (operands[1]) + 1
	  && REGNO (operands[0]) <= REGNO (operands[1]) + 3)
	return \"oril %Z0,%Z1,0\;oril %Y0,%Y1,0\;oril %L0,%L1,0\;oril %0,%1,0\";
      else
	return \"oril %0,%1,0\;oril %L0,%L1,0\;oril %Y0,%Y1,0\;oril %Z0,%Z1,0\";
    case 3:
      /* If the address is not used in the output, we can use lsi.  Otherwise,
	 fall through to generating four loads.  */
      if (! reg_overlap_mentioned_p (operands[0], operands[1]))
	return \"lsi %0,%P1,16\";
      /* ... fall through ... */
    case 4:
      /* If the address register is the same as the register for the lowest-
	 addressed word, load it last.  Similarly for the next two words.
	 Otherwise load lowest address to highest.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands[1], 0))
	return \"l %L0,%L1\;l %Y0,%Y1\;l %Z0,%Z1\;l %0,%1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 1,
				  REGNO (operands[0]) + 2, operands[1], 0))
	return \"l %0,%1\;l %Y0,%Y1\;l %Z0,%Z1\;l %L0,%L1\";
      else if (refers_to_regno_p (REGNO (operands[0]) + 2,
				  REGNO (operands[0]) + 3, operands[1], 0))
	return \"l %0,%1\;l %L0,%L1\;l %Z0,%Z1\;l %Y0,%Y1\";
      else
	return \"l%U1 %0,%1\;l %L0,%L1\;l %Y0,%Y1\;l %Z0,%Z1\";
    }
}"
  [(set_attr "type" "*,load,load,*,*")])

(define_expand "load_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (use (match_operand:SI 2 "" ""))])]
  ""
  "
{
  int regno;
  int count;
  rtx from;
  int i;

  /* Support only loading a constant number of fixed-point registers from
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[1]) != MEM
      || GET_CODE (operands[0]) != REG
      || REGNO (operands[0]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[0]);

  operands[3] = gen_rtx (PARALLEL, VOIDmode, rtvec_alloc (count));
  from = force_reg (SImode, XEXP (operands[1], 0));

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx (SET, VOIDmode, gen_rtx (REG, SImode, regno + i),
		 gen_rtx (MEM, SImode, plus_constant (from, i * 4)));
}")

(define_insn ""
  [(match_parallel 0 "load_multiple_operation"
		   [(set (match_operand:SI 1 "gpc_reg_operand" "=r")
			 (match_operand:SI 2 "indirect_operand" "Q"))])]
  ""
  "*
{
  /* We have to handle the case where the pseudo used to contain the address
     is assigned to one of the output registers.  In that case, do the
     lsi, but then load the correct value.  This is a bit of a mess, but is
     the best we can do.  */
  static char result[100];
  char newload[40];
  int i;

  strcpy (result, \"lsi %1,%P2,%N0\");
  for (i = 0; i < XVECLEN (operands[0], 0); i++)
    if (refers_to_regno_p (REGNO (operands[1]) + i,
			   REGNO (operands[1]) + i + 1, operands[2], 0))
      {
	sprintf (newload, \"\;l %d,%d(%d)\",
		 REGNO (operands[1]) + i,
		 i * 4, REGNO (XEXP (operands[2], 0)));
	strcat (result, newload);
      }

  return result;
}"
  [(set_attr "type" "load")])

(define_expand "store_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (clobber (scratch:SI))
		     (use (match_operand:SI 2 "" ""))])]
  ""
  "
{
  int regno;
  int count;
  rtx to;
  int i;

  /* Support only storing a constant number of fixed-point registers to
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[0]) != MEM
      || GET_CODE (operands[1]) != REG
      || REGNO (operands[1]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[1]);

  operands[3] = gen_rtx (PARALLEL, VOIDmode, rtvec_alloc (count + 1));
  to = force_reg (SImode, XEXP (operands[0], 0));

  XVECEXP (operands[3], 0, 0)
    = gen_rtx (SET, VOIDmode, gen_rtx (MEM, SImode, to), operands[1]);
  XVECEXP (operands[3], 0, 1) = gen_rtx (CLOBBER, VOIDmode,
						  gen_rtx (SCRATCH, SImode));

  for (i = 1; i < count; i++)
    XVECEXP (operands[3], 0, i + 1)
      = gen_rtx (SET, VOIDmode,
		 gen_rtx (MEM, SImode, plus_constant (to, i * 4)),
		 gen_rtx (REG, SImode, regno + i));
}")

(define_insn ""
  [(match_parallel 0 "store_multiple_operation"
		   [(set (match_operand:SI 1 "indirect_operand" "=Q")
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (clobber (match_scratch:SI 3 "=q"))])]
  ""
  "stsi %2,%P1,%O0")

;; Define insns that do load or store with update.  Some of these we can 
;; get by using pre-decrement or pre-increment, but the hardware can also
;; do cases where the increment is not the size of the object.
;;
;; In all these cases, we use operands 0 and 1 for the register being
;; incremented because those are the operands that local-alloc will
;; tie and these are the pair most likely to be tieable (and the ones
;; that will benefit the most).

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lux %3,%0,%2
   lu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   stux %3,%0,%2
   stu %3,%2(%0)")

(define_insn ""
  [(set (match_operand:HI 3 "gpc_reg_operand" "=r,r")
	(mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(sign_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lhaux %3,%0,%2
   lhau %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:HI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   sthux %3,%0,%2
   sthu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (match_operand:QI 3 "gpc_reg_operand" "=r,r")
	(mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:QI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   stbux %3,%0,%2
   stbu %3,%2(%0)")

(define_insn ""
  [(set (match_operand:SF 3 "gpc_reg_operand" "=f,f")
	(mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lfsux %3,%0,%2
   lfsu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   frsp %3,%3\;stfsux %3,%0,%2
   frsp %3,%3\;stfsu %3,%2(%0)")

(define_insn ""
  [(set (match_operand:DF 3 "gpc_reg_operand" "=f,f")
	(mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   lfdux %3,%0,%2
   lfdu %3,%2(%0)"
  [(set_attr "type" "load,load")])

(define_insn ""
  [(set (mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:DF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   stfdux %3,%0,%2
   stfdu %3,%2(%0)")

;; Next come insns related to the calling sequence.
;;
;; First, an insn to allocate new stack space for dynamic use (e.g., alloca).
;; We move the back-chain and decrement the stack pointer.  

(define_expand "allocate_stack"
  [(set (reg:SI 1)
	(minus:SI (reg:SI 1) (match_operand:SI 0 "reg_or_short_operand" "")))]
  ""
  "
{ rtx chain = gen_reg_rtx (SImode);
  rtx stack_bot = gen_rtx (MEM, Pmode, stack_pointer_rtx);

  emit_move_insn (chain, stack_bot);
  emit_insn (gen_subsi3 (stack_pointer_rtx, stack_pointer_rtx, operands[0]));
  emit_move_insn (stack_bot, chain);
  DONE;
}")

;; These patterns say how to save and restore the stack pointer.  We need not
;; save the stack pointer at function level since we are careful to
;; preserve the backchain.  At block level, we have to restore the backchain
;; when we restore the stack pointer.
;;
;; For nonlocal gotos, we must save both the stack pointer and its
;; backchain and restore both.  Note that in the nonlocal case, the
;; save area is a memory location.

(define_expand "save_stack_function"
  [(use (const_int 0))]
  ""
  "")

(define_expand "restore_stack_function"
  [(use (const_int 0))]
  ""
  "")

(define_expand "restore_stack_block"
  [(set (match_dup 2) (mem:SI (match_operand:SI 0 "register_operand" "")))
   (set (match_dup 0) (match_operand:SI 1 "register_operand" ""))
   (set (mem:SI (match_dup 0)) (match_dup 2))]
  ""
  "
{ operands[2] = gen_reg_rtx (SImode); }")

(define_expand "save_stack_nonlocal"
  [(match_operand:DI 0 "memory_operand" "")
   (match_operand:SI 1 "register_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (SImode);

  /* Copy the backchain to the first word, sp to the second.  */
  emit_move_insn (temp, gen_rtx (MEM, SImode, operands[1]));
  emit_move_insn (operand_subword (operands[0], 0, 0, DImode), temp);
  emit_move_insn (operand_subword (operands[0], 1, 0, DImode), operands[1]);
  DONE;
}")
		  
(define_expand "restore_stack_nonlocal"
  [(match_operand:SI 0 "register_operand" "")
   (match_operand:DI 1 "memory_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (SImode);

  /* Restore the backchain from the first word, sp from the second.  */
  emit_move_insn (temp, operand_subword (operands[1], 0, 0, DImode));
  emit_move_insn (operands[0], operand_subword (operands[1], 1, 0, DImode));
  emit_move_insn (gen_rtx (MEM, SImode, operands[0]), temp);
  DONE;
}")

;; A function pointer is a pointer to a data area whose first word contains
;; the actual address of the function, whose second word contains a pointer
;; to its TOC, and whose third word contains a value to place in the static
;; chain register (r11).  Note that if we load the static chain, our 
;; "trampoline" need not have any executable code.
;;
;; operands[0] is an SImode pseudo in which we place the address of the
;; 	       function.
;; operands[1] is the address of data area of the function to call

(define_expand "call_via_ptr"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(mem:SI (match_operand:SI 1 "gpc_reg_operand" "")))
   (set (mem:SI (plus:SI (reg:SI 1) (const_int 20)))
	(reg:SI 2))
   (set (reg:SI 2)
	(mem:SI (plus:SI (match_dup 1)
			 (const_int 4))))
   (set (reg:SI 11)
	(mem:SI (plus:SI (match_dup 1)
			 (const_int 8))))
   (use (reg:SI 2))
   (use (reg:SI 11))]
  ""
  "")

(define_expand "call"
  [(parallel [(call (mem:SI (match_operand:SI 0 "address_operand" ""))
		    (match_operand 1 "" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
  if (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != CONST_INT)
    abort ();

  operands[0] = XEXP (operands[0], 0);
  if (GET_CODE (operands[0]) != SYMBOL_REF)
    {
      rtx temp = gen_reg_rtx (SImode);

      emit_insn (gen_call_via_ptr (temp, force_reg (SImode, operands[0])));
      operands[0] = temp;
    }
}")

(define_expand "call_value"
  [(parallel [(set (match_operand 0 "" "")
		   (call (mem:SI (match_operand:SI 1 "address_operand" ""))
			 (match_operand 2 "" "")))
	      (clobber (scratch:SI))])]
  ""
  "
{
  if (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != CONST_INT)
    abort ();

  operands[1] = XEXP (operands[1], 0);
  if (GET_CODE (operands[1]) != SYMBOL_REF)
    {
      rtx temp = gen_reg_rtx (SImode);

      emit_insn (gen_call_via_ptr (temp, force_reg (SImode, operands[1])));
      operands[1] = temp;
    }
}")

(define_insn ""
  [(call (mem:SI (match_operand:SI 0 "call_operand" "l,s"))
	 (match_operand 1 "" "fg,fg"))
   (clobber (match_scratch:SI 2 "=l,l"))]
  ""
  "@
   brl\;l 2,20(1)
   bl %z0\;cror 15,15,15")

(define_insn ""
  [(set (match_operand 0 "" "=fg,fg")
	(call (mem:SI (match_operand:SI 1 "call_operand" "l,s"))
	      (match_operand 2 "" "fg,fg")))
   (clobber (match_scratch:SI 3 "=l,l"))]
  ""
  "@
   brl\;l 2,20(1)
   bl %z1\;cror 15,15,15")

;; Compare insns are next.  Note that the RS/6000 has two types of compares,
;; signed & unsigned, and one type of branch.  
;;
;; Start with the DEFINE_EXPANDs to generate the rtl for compares, scc
;; insns, and branches.  We store the operands of compares until we see
;; how it is used.
(define_expand "cmpsi"
  [(set (cc0)
        (compare (match_operand:SI 0 "gpc_reg_operand" "")
  		 (match_operand:SI 1 "reg_or_short_operand" "")))]
  ""
  "
{
  /* Take care of the possibility that operands[1] might be negative but
     this might be a logical operation.  That insn doesn't exist.  */
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) < 0)
    operands[1] = force_reg (SImode, operands[1]);

  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 0;
  DONE;
}")

(define_expand "cmpsf"
  [(set (cc0) (compare (match_operand:SF 0 "gpc_reg_operand" "")
		       (match_operand:SF 1 "gpc_reg_operand" "")))]
  ""
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "cmpdf"
  [(set (cc0) (compare (match_operand:DF 0 "gpc_reg_operand" "")
		       (match_operand:DF 1 "gpc_reg_operand" "")))]
  ""
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "beq"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (eq (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bne"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ne (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "blt"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (lt (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bgt"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (gt (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "ble"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (le (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bge"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ge (match_dup 2)
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "bgtu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (gtu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bltu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (ltu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bgeu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (geu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "bleu"
  [(set (match_dup 2) (match_dup 1))
   (set (pc)
	(if_then_else (leu (match_dup 2)
			   (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

;; For SNE, we would prefer that the xor/abs sequence be used for integers.
;; For SEQ, likewise, except that comparisons with zero should be done
;; with an scc insns.  However, due to the order that combine see the
;; resulting insns, we must, in fact, allow SEQ for integers.  Fail in
;; the cases we don't want to handle.
(define_expand "seq"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(eq:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sne"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ne:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ if (! rs6000_compare_fp_p)
    FAIL;

  operands[1] = gen_rtx (COMPARE, CCFPmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCFPmode);
}")

;; A > 0 is best done using the portable sequence, so fail in that case.
(define_expand "sgt"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gt:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

;; A < 0 is best done in the portable way for A an integer.
(define_expand "slt"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(lt:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sge"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ge:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;
  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

;; A <= 0 is best done the portable way for A an integer.
(define_expand "sle"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(le:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ enum machine_mode mode = rs6000_compare_fp_p ? CCFPmode : CCmode;

  if (! rs6000_compare_fp_p && rs6000_compare_op1 == const0_rtx)
    FAIL;

  operands[1] = gen_rtx (COMPARE, mode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (mode);
}")

(define_expand "sgtu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gtu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sltu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ltu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sgeu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(geu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

(define_expand "sleu"
  [(set (match_dup 2) (match_dup 1))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(leu:SI (match_dup 2) (const_int 0)))]
  ""
  "
{ operands[1] = gen_rtx (COMPARE, CCUNSmode,
			 rs6000_compare_op0, rs6000_compare_op1);
  operands[2] = gen_reg_rtx (CCUNSmode);
}")

;; Here are the actual compare insns.
(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "cmp%I2 %0,%1,%2"
  [(set_attr "type" "compare")])

;; If we are comparing a register for equality with a large constant,
;; we can do this with an XOR followed by a compare.  But we need a scratch
;; register for the result of the XOR.

(define_split
  [(set (match_operand:CC 0 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "non_short_cint_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "find_single_use (operands[0], insn, 0)
   && (GET_CODE (*find_single_use (operands[0], insn, 0)) == EQ
       || GET_CODE (*find_single_use (operands[0], insn, 0)) == NE)"
  [(set (match_dup 3) (xor:SI (match_dup 1) (match_dup 4)))
   (set (match_dup 0) (compare:CC (match_dup 3) (match_dup 5)))]
  "
{
  /* Get the constant we are comparing against, C,  and see what it looks like
     sign-extended to 16 bits.  Then see what constant could be XOR'ed
     with C to get the sign-extended value.  */

  int c = INTVAL (operands[2]);
  int sextc = (c << 16) >> 16;
  int xorv = c ^ sextc;

  operands[4] = gen_rtx (CONST_INT, VOIDmode, xorv);
  operands[5] = gen_rtx (CONST_INT, VOIDmode, sextc);
}")

(define_insn ""
  [(set (match_operand:CCUNS 0 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_u_short_operand" "rI")))]
  ""
  "cmpl%I2 %0,%1,%W2"
  [(set_attr "type" "compare")])

;; The following two insns don't exist as single insns, but if we provide
;; them, we can swap an add and compare, which will enable us to overlap more
;; of the required delay between a compare and branch.  We generate code for
;; them by splitting.

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#")
   
(define_insn ""
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "u_short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#")
   
(define_split
  [(set (match_operand:CC 3 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CC (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_split
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "")
		       (match_operand:SI 2 "u_short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CCUNS (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_insn ""
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:SF 1 "gpc_reg_operand" "f")
		      (match_operand:SF 2 "gpc_reg_operand" "f")))]
  ""
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

(define_insn ""
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:DF 1 "gpc_reg_operand" "f")
		      (match_operand:DF 2 "gpc_reg_operand" "f")))]
  ""
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

;; Now we have the scc insns.  We can do some combinations because of the
;; way the machine works.
;;
;; Note that this is probably faster if we can put an insn between the
;; mfcr and rlinm, but this is tricky.  Let's leave it for now.  In most
;; cases the insns below which don't use an intermediate CR field will
;; be used instead.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))]
  ""
  "%D1mfcr %0\;rlinm %0,%0,%J1,31,31")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y")
					(const_int 0)])
		    (const_int 0)))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r")
	(match_op_dup 1 [(match_dup 2) (const_int 0)]))]
  ""
  "%D1mfcr %3\;rlinm. %3,%3,%J1,30,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				      [(match_operand 2 "cc_reg_operand" "y")
				       (const_int 0)])
		   (match_operand:SI 3 "const_int_operand" "n")))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[4] = gen_rtx (CONST_INT, VOIDmode, count);
  operands[5] = gen_rtx (CONST_INT, VOIDmode, put_bit);

  return \"%D1mfcr %0\;rlinm %0,%0,%4,%5,%5\";
}")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y")
					(const_int 0)])
		    (match_operand:SI 3 "const_int_operand" "n"))
	 (const_int 0)))
   (set (match_operand:SI 4 "gpc_reg_operand" "=r")
	(ashift:SI (match_op_dup 1 [(match_dup 2) (const_int 0)])
		   (match_dup 3)))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[5] = gen_rtx (CONST_INT, VOIDmode, count);
  operands[6] = gen_rtx (CONST_INT, VOIDmode, put_bit);

  return \"%D1mfcr %4\;rlinm. %4,%4,%5,%6,%6\";
}"
  [(set_attr "type" "delayed_compare")])

;; If we are comparing the result of two comparisons, this can be done
;; using creqv or crxor.

(define_insn ""
  [(set (match_operand:CCEQ 0 "cc_reg_operand" "=y")
	(compare:CCEQ (match_operator 1 "scc_comparison_operator"
			      [(match_operand 2 "cc_reg_operand" "y")
			       (const_int 0)])
		      (match_operator 3 "scc_comparison_operator"
			      [(match_operand 4 "cc_reg_operand" "y")
			       (const_int 0)])))]
  "REGNO (operands[2]) != REGNO (operands[4])"
  "*
{
  enum rtx_code code1, code2;

  code1 = GET_CODE (operands[1]);
  code2 = GET_CODE (operands[3]);

  if ((code1 == EQ || code1 == LT || code1 == GT
       || code1 == LTU || code1 == GTU
       || (code1 != NE && GET_MODE (operands[2]) == CCFPmode))
      !=
      (code2 == EQ || code2 == LT || code2 == GT
       || code2 == LTU || code2 == GTU
       || (code2 != NE && GET_MODE (operands[4]) == CCFPmode)))
    return \"%C1%C3crxor %E0,%j1,%j3\";
  else
    return \"%C1%C3creqv %E0,%j1,%j3\";
}")

;; There is a 3 cycle delay between consecutive mfcr instructions
;; so it is useful to combine 2 scc instructions to use only one mfcr.

(define_peephole
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r")
	(match_operator:SI 4 "scc_comparison_operator"
			   [(match_operand 5 "cc_reg_operand" "y")
			    (const_int 0)]))]
   "REGNO (operands[2]) != REGNO (operands[5])"
   "%D1%D4mfcr %3\;rlinm %0,%3,%J1,31,31\;rlinm %3,%3,%J4,31,31")

;; There are some scc insns that can be done directly, without a compare.
;; These are faster because they don't involve the communications between
;; the FXU and branch units.   In fact, we will be replacing all of the
;; integer scc insns here or in the portable methods in emit_store_flag.
;;
;; Also support (neg (scc ..)) since that construct is used to replace
;; branches, (plus (scc ..) ..) since that construct is common and
;; takes no more insns than scc, and (and (neg (scc ..)) ..) in the
;; cases where it is no more expensive than (neg (scc ..)).

;; Have reload force a constant into a register for the simple insns that
;; otherwise won't accept constants.  We do this because it is faster than
;; the cmp/mfcr sequence we would otherwise generate.

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
	       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I")))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r"))]
  ""
  "@
   xor %0,%1,%2\;sfi %3,%0,0\;ae %0,%3,%0
   sfi %3,%1,0\;ae %0,%3,%1
   xoril %0,%1,%b2\;sfi %3,%0,0\;ae %0,%3,%0
   xoriu %0,%1,%u2\;sfi %3,%0,0\;ae %0,%3,%0
   sfi %0,%1,%2\;sfi %3,%0,0\;ae %0,%3,%0")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC 
	 (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r"))]
  ""
  "@
   xor %0,%1,%2\;sfi %3,%0,0\;ae. %0,%3,%0
   sfi %3,%1,0\;ae. %0,%3,%1
   xoril %0,%1,%b2\;sfi %3,%0,0\;ae. %0,%3,%0
   xoriu %0,%1,%u2\;sfi %3,%0,0\;ae. %0,%3,%0
   sfi %0,%1,%2\;sfi %3,%0,0\;ae. %0,%3,%0"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(plus:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
			(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;sfi %4,%4,0\;aze %0,%3
   sfi %4,%1,0\;aze %0,%3
   xoril %4,%1,%b2\;sfi %4,%4,0\;aze %0,%3
   xoriu %4,%1,%u2\;sfi %4,%4,0\;aze %0,%3
   sfi %4,%1,%2\;sfi %4,%4,0\;aze %0,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC 
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;sfi %4,%4,0\;aze. %4,%3
   sfi %4,%1,0\;aze. %0,%3
   xoril %4,%1,%b2\;sfi %4,%4,0\;aze. %4,%3
   xoriu %4,%1,%u2\;sfi %4,%4,0\;aze. %4,%3
   sfi %4,%1,%2\;sfi %4,%4,0\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x,x,x,x")
	(compare:CC 
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(plus:SI (eq:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r"))]
  ""
  "@
   xor %4,%1,%2\;sfi %4,%4,0\;aze. %0,%3
   sfi %4,%1,0\;aze. %4,%3
   xoril %4,%1,%b2\;sfi %4,%4,0\;aze. %0,%3
   xoriu %4,%1,%u2\;sfi %4,%4,0\;aze. %0,%3
   sfi %4,%1,%2\;sfi %4,%4,0\;aze. %0,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(neg:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r,r")
		       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,J,I"))))]
  ""
  "@
   xor %0,%1,%2\;ai %0,%0,-1\;sfe %0,%0,%0
   ai %0,%1,-1\;sfe %0,%0,%0
   xoril %0,%1,%b2\;ai %0,%0,-1\;sfe %0,%0,%0
   xoriu %0,%1,%u2\;ai %0,%0,-1\;sfe %0,%0,%0
   sfi %0,%1,%2\;ai %0,%0,-1\;sfe %0,%0,%0")

;; This is what (plus (ne X (const_int 0)) Y) looks like.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lshiftrt:SI
		  (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		  (const_int 31))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "ai %3,%1,-1\;aze %0,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "ai %3,%1,-1\;aze. %3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lshiftrt:SI (neg:SI (abs:SI (match_dup 1))) (const_int 31))
		 (match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "ai %3,%1,-1\;aze. %0,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
	       (match_operand:SI 2 "reg_or_short_operand" "r,O")))
   (clobber (match_scratch:SI 3 "=r,X"))]
  ""
  "@
   doz %3,%2,%1\;sfi %0,%3,0\;ae %0,%0,%3
   ai %0,%1,-1\;aze %0,%0\;sri %0,%0,31")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x")
	(compare:CC
	 (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_short_operand" "r,O"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(le:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,X"))]
  ""
  "@
   doz %3,%2,%1\;sfi %0,%3,0\;ae. %0,%0,%3
   ai %0,%1,-1\;aze %0,%0\;sri. %0,%0,31"
  [(set_attr "type" "delayed_compare,compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,O"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   doz %4,%2,%1\;sfi %4,%4,0\;aze %0,%3
   srai %4,%1,31\;sf %4,%1,%4\;aze %0,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   doz %4,%2,%1\;sfi %4,%4,0\;aze. %4,%3
   srai %4,%1,31\;sf %4,%1,%4\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (le:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   doz %4,%2,%1\;sfi %4,%4,0\;aze. %0,%3
   srai %4,%1,31\;sf %4,%1,%4\;aze. %0,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		       (match_operand:SI 2 "reg_or_short_operand" "r,O"))))]
  ""
  "@
   doz %0,%2,%1\;ai %0,%0,-1\;sfe %0,%0,%0
   ai %0,%1,-1\;aze %0,%0\;srai %0,%0,31")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "sf%I2 %0,%1,%2\;cal %0,0(0)\;ae %0,%0,%0")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(leu:SI (match_dup 1) (match_dup 2)))]
   ""
  "sf%I2 %0,%1,%2\;cal %0,0(0)\;ae. %0,%0,%0"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "sf%I2 %4,%1,%2\;aze %0,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "sf%I2 %4,%1,%2\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (leu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "sf%I2 %4,%1,%2\;aze. %0,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "sf%I2 %0,%1,%2\;sfe %0,%0,%0\;nand %0,%0,%0")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI
		 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI")))
		(match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "sf%I2 %4,%1,%2\;sfe %4,%4,%4\;andc %0,%3,%4")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "sf%I2 %4,%1,%2\;sfe %4,%4,%4\;andc. %4,%3,%4"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI (leu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "sf%I2 %4,%1,%2\;sfe %4,%4,%4\;andc. %0,%3,%4"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "doz%I2 %0,%1,%2\;nabs %0,%0\;sri %0,%0,31")

(define_insn ""
  [(set (match_operand:SI 3 "cc_reg_operand" "=x")
	(compare:CC
	 (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lt:SI (match_dup 1) (match_dup 2)))]
  ""
  "doz%I2 %0,%1,%2\;nabs %0,%0\;sri. %0,%0,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz%I2 %4,%1,%2\;ai %4,%4,-1\;aze %0,%3")

(define_insn ""
  [(set (match_operand:SI 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz%I2 %4,%1,%2\;ai %4,%4,-1\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz%I2 %4,%1,%2\;ai %4,%4,-1\;aze. %0,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "doz%I2 %0,%1,%2\;nabs %0,%0\;srai %0,%0,31")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  ""
  "@
   sf %0,%2,%1\;sfe %0,%0,%0\;neg %0,%0
   ai %0,%1,%n2\;sfe %0,%0,%0\;neg %0,%0")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC
	 (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ltu:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   sf %0,%2,%1\;sfe %0,%0,%0\;neg. %0,%0
   ai %0,%1,%n2\;sfe %0,%0,%0\;neg. %0,%0"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,r,P,P"))
		 (match_operand:SI 3 "reg_or_short_operand" "r,I,r,I")))
   (clobber (match_scratch:SI 4 "=&r,r,&r,r"))]
  ""
  "@
  sf %4,%2,%1\;sfe %4,%4,%4\;sf%I3 %0,%4,%3
  sf %4,%2,%1\;sfe %4,%4,%4\;sf%I3 %0,%4,%3
  ai %4,%1,%n2\;sfe %4,%4,%4\;sf%I3 %0,%4,%3
  ai %4,%1,%n2\;sfe %4,%4,%4\;sf%I3 %0,%4,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,r,P,P"))
		  (match_operand:SI 3 "reg_or_short_operand" "r,I,r,I"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,r,&r,r"))]
  ""
  "@
   sf %4,%2,%1\;sfe %4,%4,%4\;sf%I3. %4,%4,%3
   sf %4,%2,%1\;sfe %4,%4,%4\;sf%I3. %4,%4,%3
   ai %4,%1,%n2\;sfe %4,%4,%4\;sf%I3. %4,%4,%3
   ai %4,%1,%n2\;sfe %4,%4,%4\;sf%I3. %4,%4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x,x,x")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,r,P,P"))
		  (match_operand:SI 3 "reg_or_short_operand" "r,I,r,I"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(plus:SI (ltu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,r,&r,r"))]
  ""
  "@
   sf %4,%2,%1\;sfe %4,%4,%4\;sf%I3. %0,%4,%3
   sf %4,%2,%1\;sfe %4,%4,%4\;sf%I3. %0,%4,%3
   ai %4,%1,%n2\;sfe %4,%4,%4\;sf%I3. %0,%4,%3
   ai %4,%1,%n2\;sfe %4,%4,%4\;sf%I3. %0,%4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))))]
  ""
  "@
   sf %0,%2,%1\;sfe %0,%0,%0
   ai %0,%1,%n2\;sfe %0,%0,%0")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "doz%I2 %3,%1,%2\;sfi %0,%3,0\;ae %0,%0,%3")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ge:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r"))]
  ""
  "doz%I2 %3,%1,%2\;sfi %0,%3,0\;ae. %0,%0,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz%I2 %4,%1,%2\;sfi %4,%4,0\;aze %0,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz%I2 %4,%1,%2\;sfi %4,%4,0\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (ge:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz%I2 %4,%1,%2\;sfi %4,%4,0\;aze. %0,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "doz%I2 %0,%1,%2\;ai %0,%0,-1\;sfe %0,%0,%0")

;; This is (and (neg (ge X (const_int 0))) Y).
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI
		 (lshiftrt:SI
		  (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		  (const_int 31)))
		(match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "srai %3,%1,31\;andc %0,%2,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (lshiftrt:SI
		   (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 31)))
		 (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "srai %3,%1,31\;andc. %3,%2,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (and:SI (neg:SI
		  (lshiftrt:SI
		   (not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 31)))
		 (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (neg:SI (lshiftrt:SI (not:SI (match_dup 1))
				     (const_int 31)))
		(match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "srai %3,%1,31\;andc. %0,%2,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  ""
  "@
   sf %0,%2,%1\;cal %0,0(0)\;ae %0,%0,%0
   ai %0,%1,%n2\;cal %0,0(0)\;ae %0,%0,%0")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x")
	(compare:CC
	 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(geu:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   sf %0,%2,%1\;cal %0,0(0)\;ae. %0,%0,%0
   ai %0,%1,%n2\;cal %0,0(0)\;ae. %0,%0,%0"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   sf %4,%2,%1\;aze %0,%3
   ai %4,%1,%n2\;aze %0,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   sf %4,%2,%1\;aze. %4,%3
   ai %4,%1,%n2\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (geu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   sf %4,%2,%1\;aze. %0,%3
   ai %4,%1,%n2\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,I"))))]
  ""
  "@
   sf %0,%2,%1\;sfe %0,%0,%0\;nand %0,%0,%0
   sfi %0,%1,-1\;a%I2 %0,%0,%2\;sfe %0,%0,%0")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (neg:SI
		 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		(match_operand:SI 3 "gpc_reg_operand" "r,r")))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   sf %4,%2,%1\;sfe %4,%4,%4\;andc %0,%3,%4
   ai %4,%1,%n2\;sfe %4,%4,%4\;andc %0,%3,%4")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   sf %4,%2,%1\;sfe %4,%4,%4\;andc. %4,%3,%4
   ai %4,%1,%n2\;sfe %4,%4,%4\;andc. %4,%3,%4"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (neg:SI (geu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  ""
  "@
   sf %4,%2,%1\;sfe %4,%4,%4\;andc. %0,%3,%4
   ai %4,%1,%n2\;sfe %4,%4,%4\;andc. %0,%3,%4"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (const_int 0)))]
  ""
  "sfi %0,%1,0\;ame %0,%0\;sri %0,%0,31")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(const_int 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_dup 1) (const_int 0)))]
  ""
  "sfi %0,%1,0\;ame %0,%0\;sri. %0,%0,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "r")))]
  ""
  "doz %0,%2,%1\;nabs %0,%0\;sri %0,%0,31")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_dup 1) (match_dup 2)))]
  ""
  "doz %0,%2,%1\;nabs %0,%0\;sri. %0,%0,31"
  [(set_attr "type" "delayed_compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(const_int 0))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "a %3,%1,%1\;sfe %3,%1,%3\;aze %0,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "a %3,%1,%1\;sfe %3,%1,%3\;aze. %0,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_dup 1) (const_int 0)) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r"))]
  ""
  "a %3,%1,%1\;sfe %3,%1,%3\;aze. %3,%2"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "r"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz %4,%2,%1\;ai %4,%4,-1\;aze %0,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz %4,%2,%1\;ai %4,%4,-1\;aze. %4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (gt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r"))]
  ""
  "doz %4,%2,%1\;ai %4,%4,-1\;aze. %0,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (const_int 0))))]
  ""
  "sfi %0,%1,0\;ame %0,%0\;srai %0,%0,31")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "r"))))]
  ""
  "doz %0,%2,%1\;nabs %0,%0\;srai %0,%0,31")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "sf%I2 %0,%1,%2\;sfe %0,%0,%0\;neg %0,%0")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x")
	(compare:CC
	 (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gtu:SI (match_dup 1) (match_dup 2)))]
  ""
  "sf%I2 %0,%1,%2\;sfe %0,%0,%0\;neg. %0,%0"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "I,r,rI"))
		 (match_operand:SI 3 "reg_or_short_operand" "r,r,I")))
   (clobber (match_scratch:SI 4 "=&r,&r,&r"))]
  ""
  "@
   ai %4,%1,%k2\;aze %0,%3
   sf%I2 %4,%1,%2\;sfe %4,%4,%4\;sf%I3 %0,%4,%3
   sf%I2 %4,%1,%2\;sfe %4,%4,%4\;sf%I3 %0,%4,%3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r,rI"))
		  (match_operand:SI 3 "reg_or_short_operand" "r,r,I"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r"))]
  ""
  "@
   ai %4,%1,%k2\;aze. %0,%3
   sf%I2 %4,%1,%2\;sfe %4,%4,%4\;sf%I3. %0,%4,%3
   sf%I2 %4,%1,%2\;sfe %4,%4,%4\;sf%I3. %0,%4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:CC 5 "cc_reg_operand" "=x,x,x")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r,rI"))
		  (match_operand:SI 3 "reg_or_short_operand" "r,r,I"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(plus:SI (gtu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r"))]
  ""
  "@
   ai %4,%1,%k2\;aze. %0,%3
   sf%I2 %4,%1,%2\;sfe %4,%4,%4\;sf%I3. %0,%4,%3
   sf%I2 %4,%1,%2\;sfe %4,%4,%4\;sf%I3. %0,%4,%3"
  [(set_attr "type" "compare")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  ""
  "sf%I2 %0,%1,%2\;sfe %0,%0,%0")

;; Define both directions of branch and return.  If we need a reload
;; register, we'd rather use CR0 since it is much easier to copy a
;; register CC value to there.

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "%C1bc %t1,%j1,%0")

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (return)
		      (pc)))]
  "direct_return ()"
  "%C0bcr %t0,%j0")

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "%C1bc %T1,%j1,%0")

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "x,?y")
				       (const_int 0)])
		      (pc)
		      (return)))]
  "direct_return ()"
  "%C0bcr %T0,%j0")

;; Unconditional branch and return.

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "b %l0")

(define_insn "return"
  [(return)]
  "direct_return ()"
  "br")

(define_insn "indirect_jump"
  [(set (pc) (match_operand:SI 0 "register_operand" "c,l"))]
  ""
  "@
   bctr
   br")

;; Table jump for switch statements:
(define_expand "tablejump"
  [(set (match_dup 3)
	(plus:SI (match_operand:SI 0 "" "")
		 (match_dup 2)))
   (parallel [(set (pc) (match_dup 3))
	      (use (label_ref (match_operand 1 "" "")))])]
  ""
  "
{ operands[0] = force_reg (SImode, operands[0]);
  operands[2] = force_reg (SImode, gen_rtx (LABEL_REF, VOIDmode, operands[1]));
  operands[3] = gen_reg_rtx (SImode);
}")

(define_insn ""
  [(set (pc)
	(match_operand:SI 0 "register_operand" "c,l"))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "@
   bctr
   br")

(define_insn "nop"
  [(const_int 0)]
  ""
  "cror 0,0,0")

;; Define the subtract-one-and-jump insns. 
;; We need to be able to do this for any operand, including MEM, or we
;; will cause reload to blow up since we don't allow output reloads on
;; JUMP_INSNs. 
(define_insn ""
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "0,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))
   (set (match_operand:SI 0 "register_operand" "=c,*r,m*q*c*l")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "@
   bdn %l2
   #
   #")
			       
;; Similar, but we can use GE since we have a REG_NOTES.
(define_insn ""
  [(set (pc)
	(if_then_else (ge (match_operand:SI 1 "register_operand" "0,*r,*r")
			  (const_int 0))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))
   (set (match_operand:SI 0 "register_operand" "=c,*r,m*q*c*l")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&X"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  "find_reg_note (insn, REG_NONNEG, 0)"
  "@
   bdn %l2
   #
   #")
			       
(define_insn ""
  [(set (pc)
	(if_then_else (eq (match_operand:SI 1 "register_operand" "0,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 2 "" ""))
		      (pc)))
   (set (match_operand:SI 0 "register_operand" "=c,*r,m*q*c*l")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,r"))]
  ""
  "@
   bdz %l2
   #
   #")

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1) (const_int -1))
			       (const_int 0)))
	      (set (match_dup 0) (plus:SI (match_dup 1) (const_int -1)))])
   (set (pc) (if_then_else (match_dup 7) (match_dup 5) (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "general_operand" "")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed && ! gpc_reg_operand (operands[0], SImode)"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1) (const_int -1))
			       (const_int 0)))
	      (set (match_dup 4) (plus:SI (match_dup 1) (const_int -1)))])
   (set (match_dup 0) (match_dup 4))
   (set (pc) (if_then_else (match_dup 7) (match_dup 5) (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")
