/* Copyright (C) 2000  Free Software Foundation

   This file is part of libgcj.

This software is copyrighted work licensed under the terms of the
Libgcj License.  Please consult the file "LIBGCJ_LICENSE" for
details.  */

/* This is a base class that handles aliasing issues for
   UnicodeToBytes to BytesToUnicode.  */

package gnu.gcj.convert;

import java.util.Hashtable;

public abstract class IOConverter
{
  // Map encoding aliases to our canonical form.
  static private Hashtable hash = new Hashtable ();

  static
  {
    // Manually maintained aliases.  Note that the value must be our
    // canonical name.
    hash.put ("ISO-Latin-1", "8859_1");
    // All aliases after this point are automatically generated by the
    // `encodings.pl' script.  Run it to make any corrections.
    hash.put ("ISO_8859-1:1987", "8859_1");
    hash.put ("iso-ir-100", "8859_1");
    hash.put ("ISO_8859-1", "8859_1");
    hash.put ("ISO-8859-1", "8859_1");
    hash.put ("latin1", "8859_1");
    hash.put ("l1", "8859_1");
    hash.put ("IBM819", "8859_1");
    hash.put ("CP819", "8859_1");
    hash.put ("csISOLatin1", "8859_1");
    hash.put ("UTF-8", "UTF8");
    hash.put ("Shift_JIS", "SJIS");
    hash.put ("MS_Kanji", "SJIS");
    hash.put ("csShiftJIS", "SJIS");
    hash.put ("Extended_UNIX_Code_Packed_Format_for_Japanese", "EUCJIS");
    hash.put ("csEUCPkdFmtJapanese", "EUCJIS");
    hash.put ("EUC-JP", "EUCJIS");
  }

  // Turn an alias into the canonical form.
  protected static final String canonicalize (String name)
  {
    String c = (String) hash.get (name);
    return c == null ? name : c;
  }
}
