// java-insns.h - Instruction encodings. This is -*- c++ -*-

/* Copyright (C) 1999  Cygnus Solutions

   This file is part of libgcj.

This software is copyrighted work licensed under the terms of the
Libgcj License.  Please consult the file "LIBGCJ_LICENSE" for
details.  */

static const int op_nop = 0x00;
static const int op_aconst_null = 0x01;
static const int op_iconst_m1 = 0x02;
static const int op_iconst_0 = 0x03;
static const int op_iconst_1 = 0x04;
static const int op_iconst_2 = 0x05;
static const int op_iconst_3 = 0x06;
static const int op_iconst_4 = 0x07;
static const int op_iconst_5 = 0x08;
static const int op_lconst_0 = 0x09;
static const int op_lconst_1 = 0x0a;
static const int op_fconst_0 = 0x0b;
static const int op_fconst_1 = 0x0c;
static const int op_fconst_2 = 0x0d;
static const int op_dconst_0 = 0x0e;
static const int op_dconst_1 = 0x0f;
static const int op_bipush = 0x10;
static const int op_sipush = 0x11;
static const int op_ldc = 0x12;
static const int op_ldc_w = 0x13;
static const int op_ldc2_w = 0x14;
static const int op_iload = 0x15;
static const int op_lload = 0x16;
static const int op_fload = 0x17;
static const int op_dload = 0x18;
static const int op_aload = 0x19;
static const int op_iload_0 = 0x1a;
static const int op_iload_1 = 0x1b;
static const int op_iload_2 = 0x1c;
static const int op_iload_3 = 0x1d;
static const int op_lload_0 = 0x1e;
static const int op_lload_1 = 0x1f;
static const int op_lload_2 = 0x20;
static const int op_lload_3 = 0x21;
static const int op_fload_0 = 0x22;
static const int op_fload_1 = 0x23;
static const int op_fload_2 = 0x24;
static const int op_fload_3 = 0x25;
static const int op_dload_0 = 0x26;
static const int op_dload_1 = 0x27;
static const int op_dload_2 = 0x28;
static const int op_dload_3 = 0x29;
static const int op_aload_0 = 0x2a;
static const int op_aload_1 = 0x2b;
static const int op_aload_2 = 0x2c;
static const int op_aload_3 = 0x2d;
static const int op_iaload = 0x2e;
static const int op_laload = 0x2f;
static const int op_faload = 0x30;
static const int op_daload = 0x31;
static const int op_aaload = 0x32;
static const int op_baload = 0x33;
static const int op_caload = 0x34;
static const int op_saload = 0x35;
static const int op_istore = 0x36;
static const int op_lstore = 0x37;
static const int op_fstore = 0x38;
static const int op_dstore = 0x39;
static const int op_astore = 0x3a;
static const int op_istore_0 = 0x3b;
static const int op_istore_1 = 0x3c;
static const int op_istore_2 = 0x3d;
static const int op_istore_3 = 0x3e;
static const int op_lstore_0 = 0x3f;
static const int op_lstore_1 = 0x40;
static const int op_lstore_2 = 0x41;
static const int op_lstore_3 = 0x42;
static const int op_fstore_0 = 0x43;
static const int op_fstore_1 = 0x44;
static const int op_fstore_2 = 0x45;
static const int op_fstore_3 = 0x46;
static const int op_dstore_0 = 0x47;
static const int op_dstore_1 = 0x48;
static const int op_dstore_2 = 0x49;
static const int op_dstore_3 = 0x4a;
static const int op_astore_0 = 0x4b;
static const int op_astore_1 = 0x4c;
static const int op_astore_2 = 0x4d;
static const int op_astore_3 = 0x4e;
static const int op_iastore = 0x4f;
static const int op_lastore = 0x50;
static const int op_fastore = 0x51;
static const int op_dastore = 0x52;
static const int op_aastore = 0x53;
static const int op_bastore = 0x54;
static const int op_castore = 0x55;
static const int op_sastore = 0x56;
static const int op_pop = 0x57;
static const int op_pop2 = 0x58;
static const int op_dup = 0x59;
static const int op_dup_x1 = 0x5a;
static const int op_dup_x2 = 0x5b;
static const int op_dup2 = 0x5c;
static const int op_dup2_x1 = 0x5d;
static const int op_dup2_x2 = 0x5e;
static const int op_swap = 0x5f;
static const int op_iadd = 0x60;
static const int op_ladd = 0x61;
static const int op_fadd = 0x62;
static const int op_dadd = 0x63;
static const int op_isub = 0x64;
static const int op_lsub = 0x65;
static const int op_fsub = 0x66;
static const int op_dsub = 0x67;
static const int op_imul = 0x68;
static const int op_lmul = 0x69;
static const int op_fmul = 0x6a;
static const int op_dmul = 0x6b;
static const int op_idiv = 0x6c;
static const int op_ldiv = 0x6d;
static const int op_fdiv = 0x6e;
static const int op_ddiv = 0x6f;
static const int op_irem = 0x70;
static const int op_lrem = 0x71;
static const int op_frem = 0x72;
static const int op_drem = 0x73;
static const int op_ineg = 0x74;
static const int op_lneg = 0x75;
static const int op_fneg = 0x76;
static const int op_dneg = 0x77;
static const int op_ishl = 0x78;
static const int op_lshl = 0x79;
static const int op_ishr = 0x7a;
static const int op_lshr = 0x7b;
static const int op_iushr = 0x7c;
static const int op_lushr = 0x7d;
static const int op_iand = 0x7e;
static const int op_land = 0x7f;
static const int op_ior = 0x80;
static const int op_lor = 0x81;
static const int op_ixor = 0x82;
static const int op_lxor = 0x83;
static const int op_iinc = 0x84;
static const int op_i2l = 0x85;
static const int op_i2f = 0x86;
static const int op_i2d = 0x87;
static const int op_l2i = 0x88;
static const int op_l2f = 0x89;
static const int op_l2d = 0x8a;
static const int op_f2i = 0x8b;
static const int op_f2l = 0x8c;
static const int op_f2d = 0x8d;
static const int op_d2i = 0x8e;
static const int op_d2l = 0x8f;
static const int op_d2f = 0x90;
static const int op_i2b = 0x91;
static const int op_i2c = 0x92;
static const int op_i2s = 0x93;
static const int op_lcmp = 0x94;
static const int op_fcmpl = 0x95;
static const int op_fcmpg = 0x96;
static const int op_dcmpl = 0x97;
static const int op_dcmpg = 0x98;
static const int op_ifeq = 0x99;
static const int op_ifne = 0x9a;
static const int op_iflt = 0x9b;
static const int op_ifge = 0x9c;
static const int op_ifgt = 0x9d;
static const int op_ifle = 0x9e;
static const int op_if_icmpeq = 0x9f;
static const int op_if_icmpne = 0xa0;
static const int op_if_icmplt = 0xa1;
static const int op_if_icmpge = 0xa2;
static const int op_if_icmpgt = 0xa3;
static const int op_if_icmple = 0xa4;
static const int op_if_acmpeq = 0xa5;
static const int op_if_acmpne = 0xa6;
static const int op_goto = 0xa7; 
static const int op_jsr = 0xa8;
static const int op_ret = 0xa9;
static const int op_tableswitch = 0xaa;
static const int op_lookupswitch = 0xab;
static const int op_ireturn = 0xac;
static const int op_lreturn = 0xad;
static const int op_freturn = 0xae;
static const int op_dreturn = 0xaf;
static const int op_areturn = 0xb0;
static const int op_return = 0xb1;
static const int op_getstatic = 0xb2;
static const int op_putstatic = 0xb3;
static const int op_getfield = 0xb4;
static const int op_putfield = 0xb5;
static const int op_invokevirtual = 0xb6;
static const int op_invokespecial = 0xb7;
static const int op_invokestatic = 0xb8;
static const int op_invokeinterface = 0xb9;
static const int op_xxxunusedxxx1 = 0xba;
static const int op_new = 0xbb;
static const int op_newarray = 0xbc;
static const int op_anewarray = 0xbd;
static const int op_arraylength = 0xbe;
static const int op_athrow = 0xbf;
static const int op_checkcast = 0xc0;
static const int op_instanceof = 0xc1;
static const int op_monitorenter = 0xc2;
static const int op_monitorexit = 0xc3;
static const int op_wide = 0xc4;
static const int op_multianewarray = 0xc5;
static const int op_ifnull = 0xc6;
static const int op_ifnonnull = 0xc7;
static const int op_goto_w = 0xc8;
static const int op_jsr_w = 0xc9;

// new opcodes

static const int op_putfield_1 = 0xca;
static const int op_putfield_2 = 0xcb;
static const int op_putfield_4 = 0xcc;
static const int op_putfield_8 = 0xcd;
static const int op_putfield_a = 0xce;

static const int op_putstatic_1 = 0xcf;
static const int op_putstatic_2 = 0xd0;
static const int op_putstatic_4 = 0xd1;
static const int op_putstatic_8 = 0xd2;
static const int op_putstatic_a = 0xd3;

static const int op_getfield_1 = 0xd4;
static const int op_getfield_2s = 0xd5;
static const int op_getfield_2u = 0xd6;
static const int op_getfield_4 = 0xd7;
static const int op_getfield_8 = 0xd8;
static const int op_getfield_a = 0xd9;

static const int op_getstatic_1 = 0xda;
static const int op_getstatic_2s = 0xdb;
static const int op_getstatic_2u = 0xdc;
static const int op_getstatic_4 = 0xdd;
static const int op_getstatic_8 = 0xde;
static const int op_getstatic_a = 0xdf;





