% 导入数据表
file_data = xlsread('D:\Desktop\ptq_result.xlsx','Sheet','B4:E46');
js_flops = file_data(:,1); 
js_param = file_data(:,2);
ptq_acc  = file_data(:,3);
acc_loss = file_data(:,4);

% 定义颜色向量和每个数据点所属的类别
colors = ['r', 'g', 'm'];
class = [ones(16,1); 2*ones(6,1); 3*ones(21,1)];

% 指定拟合模型
rational_model = fittype('(p1*js_flops.^2 + p2*js_flops + p3) / (q1*js_flops.^2 + q2*js_flops + q3)', 'independent', 'js_flops', 'coefficients', {'p1', 'p2', 'p3', 'q1', 'q2', 'q3'});

% 进行拟合
[fitresult,gof] = fit(js_param, acc_loss, rational_model);

% 可视化数据点和拟合曲线
scatter(js_param(1:15), acc_loss(1:15), [], colors(1), 'filled');
hold on;
scatter(js_param(16:22), acc_loss(16:22), [], colors(2), 'filled');
scatter(js_param(23:43), acc_loss(23:43), [], colors(3), 'filled');
plot(fitresult,'k',js_param,acc_loss);
xlabel('js\_param');
ylabel('acc\_loss');
legend('INT', 'POT', 'FLOAT','ALL', 'Rational-Fit', 'Location', 'Northeast');
% 获取评价指标
SSE=gof.sse;
R_square = gof.rsquare; 
RMSE = gof.rmse; 

% 将拟合公式和 R 方显示在图上
text(0.65, 0.2, sprintf('Goodness of fit:\n SSE:%.4f\n R-square:%.4f\n RMSE:%.4f', SSE, R_square, RMSE), 'Units', 'normalized', 'FontSize', 11);

hold off;