## Naive MIA 

#### update 2023.5.24

1\. 思路

   （1）一共需要训练3个模型，分别是Target Model， Shadow Model，Attack Model. 其中Target Model是被攻击的模型。

   （2）假设攻击者已知Target Model的结构并了解其训练所用的数据集的特征，于是Shadow Model采用与Target Model相同的结构。将数据集切分，分别用于Target Model和Shadow Model的训练和测试。

   （3）在训练和测试Target Model和Shadow Model时，我们可以分别构建Attack Model的测试集和训练集。Attack Model的输入是Target Model或Shadow Model对一个图片输入的输出向量，输出是该图片是否属于Target Model或Shadow Model的训练集。我们构造Shadow Model就是为了构建Attack Model的训练集（因为我们作为攻击者，只知道Shadow Model的训练集，测试集是什么，而不知道Target Model的），Target Model的输出向量和训练集、测试集可以作为Attack Model的测试集，检验攻击成果。

   （4）Attack Model是一个二分类网络，由若干FC，ReLU，BN层组成

   （5）最终输出攻击的成功率 （即Attack Model的acc）和一些统计信息

2\. 代码文件说明

   attack.py: 
   核心文件，``get_cmd_arguments()``负责了读取各种参数配置
   ``split_dataset()``将数据集切分
   ``get_data_loader()``构造data loader
   `` attack_inference``负责Attack Model的推理
   ``create_attack()``负责的工作较多，包括训练Target Model，训练Shadow Model，通过``train_model()``在训练中构造Attack Model的数据集（也可以load训练好的模型权值后通过``prepare_attack_data`构造）.    训练Attack Model，并测试。

   model.py : 
   支持的各种模型结构，目前用到的包括ResNet18，50，152，MobileNetV2

   train.py：
   ``prepare_attack_data()``构建Attack Model训练/测试所用的数据集，attack_X是Target Model或Shadow Model的输出，attack_Y是Target Model或Shadow Model是否为其训练集数据
   ```train_per_epoch()```负责Target Model或Shadow Model每个epoch的训练

   ``val_per_epoch()``负责Target Model或Shadow Model每个epoch的测试/验证

   ``train_attack_model()``负责训练Attack Model的训练

   ``train_model()``负责组织训练模型，调用上述函数  

   

   其余程序文件的含义与之前用到的基本相同

3\. 结果

   - 先后分别在CIFAR10和CIFAR100上尝试了对ResNet18，50，152，MobileNetV2的攻击，在CIFAR100上一般能比CIFAR10上取得更好的结果，原因可能是CIFAR100数据集每类数据图片更少，更难训练，更容易过拟合，因此对MIA更脆弱。

     只有对使用CIFAR10训练的MobileNetV2的攻击取得了相对显著的结果(Attack Model acc=61.57%)，其余情况下，Attack Model的acc均在52%~56%，考虑到二分类问题随机情况下也有50%的acc，攻击效果不是很显著。

   - 具体数据

     Target Model和Shadow Model的optimizer是Adam，Attack Model的optimizer是SGD，lr_scheduler都是CosineAnnealingLR

     * ResNet18 + CIFAR10：

     ```
     Validation Accuracy for the Best Attack Model is: 54.40 %
     ----Attack Model Testing----
     Y:tensor([1, 1, 1,  ..., 0, 0, 0])
     Length of Attack Model test dataset : [30000]
     Attack Test Accuracy is  : 53.26%
     ---Detailed Results----
                   precision    recall  f1-score   support
     
       Non-Member       0.55      0.38      0.45     15000
           Member       0.52      0.69      0.59     15000
     
         accuracy                           0.53     30000
        macro avg       0.54      0.53      0.52     30000
     weighted avg       0.54      0.53      0.52     30000
     ```

     * ResNet50 + CIFAR10：

     ```
     Validation Accuracy for the Best Attack Model is: 55.70 %
     ----Attack Model Testing----
     Y:tensor([1, 1, 1,  ..., 0, 0, 0])
     Length of Attack Model test dataset : [30000]
     Attack Test Accuracy is  : 52.20%
     ---Detailed Results----
                   precision    recall  f1-score   support
     
       Non-Member       0.52      0.47      0.49     15000
           Member       0.52      0.58      0.55     15000
     
         accuracy                           0.52     30000
        macro avg       0.52      0.52      0.52     30000
     weighted avg       0.52      0.52      0.52     30000
     ```

     * ResNet152 + CIFAR10

     ```
     ----Attack Model Testing----
     Y:tensor([1, 1, 1,  ..., 0, 0, 0])
     Length of Attack Model test dataset : [30000]
     Attack Test Accuracy is  : 52.50%
     ---Detailed Results----
                   precision    recall  f1-score   support
     
       Non-Member       0.54      0.37      0.44     15000
           Member       0.52      0.68      0.59     15000
     
         accuracy                           0.53     30000
        macro avg       0.53      0.53      0.51     30000
     weighted avg       0.53      0.53      0.51     30000
     ```

     * MobileNetV2 + CIFAR10

     ```
     Validation Accuracy for the Best Attack Model is: 65.20 %
     ----Attack Model Testing----
     Y:tensor([1, 1, 1,  ..., 0, 0, 0])
     Length of Attack Model test dataset : [30000]
     Attack Test Accuracy is  : 61.57%
     ---Detailed Results----
                   precision    recall  f1-score   support
     
       Non-Member       0.63      0.57      0.60     15000
           Member       0.61      0.66      0.63     15000
     
         accuracy                           0.62     30000
        macro avg       0.62      0.62      0.61     30000
     weighted avg       0.62      0.62      0.61     30000
     ```

     * ResNet50 + CIFAR100：

     ```
     ----Attack Model Testing----
     Y:tensor([1, 1, 1,  ..., 0, 0, 0])
     Length of Attack Model test dataset : [30000]
     Attack Test Accuracy is  : 54.30%
     ---Detailed Results----
                   precision    recall  f1-score   support
     
       Non-Member       0.54      0.61      0.57     15000
           Member       0.55      0.47      0.51     15000
     
         accuracy                           0.54     30000
        macro avg       0.54      0.54      0.54     30000
     weighted avg       0.54      0.54      0.54     30000
     ```

     * ResNet152  + CIFAR100：

     ```
     Attack Test Accuracy is  : 56.11%
     ---Detailed Results----
                   precision    recall  f1-score   support
     
       Non-Member       0.56      0.60      0.58     15000
           Member       0.57      0.52      0.54     15000
     
         accuracy                           0.56     30000
        macro avg       0.56      0.56      0.56     30000
     weighted avg       0.56      0.56      0.56     30000
     ```

     * MobileNetV2 + CIFAR100：

     ```
     Validation Accuracy for the Best Attack Model is: 55.50 %
     ----Attack Model Testing----
     Y:tensor([1, 1, 1,  ..., 0, 0, 0])
     Length of Attack Model test dataset : [30000]
     Attack Test Accuracy is  : 51.33%
     ---Detailed Results----
                   precision    recall  f1-score   support
     
       Non-Member       0.51      0.52      0.52     15000
           Member       0.51      0.51      0.51     15000
     
         accuracy                           0.51     30000
        macro avg       0.51      0.51      0.51     30000
     weighted avg       0.51      0.51      0.51     30000
     ```

     

4\. 问题及改进方向

   Q1：大部分情况下攻击效果较差

   A1：尝试换一种MIA攻击方式，尝试Loss Trajectory MIA。之后再仔细检查下有无代码问题。

   Q2：对于CIFAR100，Target Model和Shadow Model的训练效果差

   A2：因为CIFAR100每类的训练数据本来就比较少，还分别拆分给了Target Model和Shadow Model的train set和test set，导致训练数据过少，因此模型训练效果较差。可以考虑调整训练策略，或是**改用CINIC-10数据集**，CINIC-10 是 CIFAR-10 通过添加下采样的 ImageNet 图像扩展得到，有 270,000 张图像，是 CIFAR 的 4.5 倍，图像大小与 CIFAR 中的一样，不需要对代码进行大量修改，不过有一点问题是图像来源于 CIFAR 和 ImageNet，这些图像的分布不一定相同，可能不利于训练。

   Q3：如何把量化也考虑进来

   A3：我认为主要取决于我们假设的攻击情景是怎样的。

   如果认为攻击者不知道要攻击的模型是全精度的还是量化后的，那么就会采用全精度的Shadow Model，进而根据Shadow Model训练好Attack Model。我们只需要把Target Model进行相应的量化，而后再根据其输出构造Attack Model的test set，就可以将量化考虑进来了。

   如果认为攻击者知道要攻击的模型是量化的，同时还知道是用的什么量化数据表示方式、位宽等，那么会比较麻烦。简单的方法是还是训练一个全精度的Shadow Model然后量化，之后再构造Attack Model的训练集。其余步骤于上一个情况相同。可能会取得更好的攻击效果(因为是根据量化后的Shadow Model构建的Attack Model的训练集，Attack Model更能适应量化模型的output). 复杂的方法是引入QAT，但QAT目前在ResNet系列和MobileNetV2上还比较难训练起来。

   