# conv: 'C',''/'B'/'BR',qi,in_ch,out_ch,kernel_size,stirde,padding,bias
# relu: 'R'
# inception: 'Inc'
# maxpool: 'MP',kernel_size,stride,padding
# adaptiveavgpool: 'AAP',output_size
# flatten: 'FT'
# dropout: 'D'

# class 10
AlexNet_cfg_table = [
    ['C','',True,3,32,3,1,1,True],
    ['R'],
    ['MP',2,2,0],
    ['C','',False,32,64,3,1,1,True],
    ['R'],
    ['MP',2,2,0],
    ['C','',False,64,128,3,1,1,True],
    ['R'],
    ['C','',False,128,256,3,1,1,True],
    ['R'],
    ['C','',False,256,256,3,1,1,True],
    ['R'],
    ['MP',3,2,0],
    ['FT'],
    ['D',0.5],
    ['FC',2304,1024,True],
    ['R'],
    ['D',0.5],
    ['FC',1024,512,True],
    ['R'],
    ['FC',512,10,True]
]
AlexNet_BN_cfg_table = [
    ['C','BR',True,3,32,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,32,64,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,64,128,3,1,1,True],
    ['C','BR',False,128,256,3,1,1,True],
    ['C','BR',False,256,256,3,1,1,True],
    ['MP',3,2,0],
    ['FT'],
    ['D',0.5],
    ['FC',2304,1024,True],
    ['R'],
    ['D',0.5],
    ['FC',1024,512,True],
    ['R'],
    ['FC',512,10,True]
]
VGG_16_cfg_table = [
    ['C','BR',True,3,64,3,1,1,True],
    ['C','BR',False,64,64,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,64,128,3,1,1,True],
    ['C','BR',False,128,128,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,128,256,3,1,1,True],
    ['C','BR',False,256,256,3,1,1,True],
    ['C','BR',False,256,256,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,256,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['MP',2,2,0],
    ['FT'],
    ['FC',512,4096,True],
    ['R'],
    ['D',0.5],
    ['FC',4096,4096,True],
    ['R'],
    ['D',0.5],
    ['FC',4096,10,True]
]
VGG_19_cfg_table = [
    ['C','BR',True,3,64,3,1,1,True],
    ['C','BR',False,64,64,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,64,128,3,1,1,True],
    ['C','BR',False,128,128,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,128,256,3,1,1,True],
    ['C','BR',False,256,256,3,1,1,True],
    ['C','BR',False,256,256,3,1,1,True],
    ['C','BR',False,256,256,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,256,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['MP',2,2,0],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['C','BR',False,512,512,3,1,1,True],
    ['MP',2,2,0],
    ['FT'],
    ['FC',512,4096,True],
    ['R'],
    ['D',0.5],
    ['FC',4096,4096,True],
    ['R'],
    ['D',0.5],
    ['FC',4096,10,True]
]
Inception_BN_cfg_table = [
    ['C','',True,3,64,3,1,1,True],
    ['R'],
    ['C','',False,64,64,3,1,1,True],
    ['R'],
    ['Inc',0],
    ['Inc',1],
    ['MP',3,2,1],
    ['Inc',2],
    ['Inc',3],
    ['Inc',4],
    ['Inc',5],
    ['Inc',6],
    ['MP',3,2,1],
    ['Inc',7],
    ['Inc',8],
    ['AAP',1],
    ['C','',False,1024,10,1,1,0,True],
    ['FT']
]

model_cfg_table = {
    'AlexNet'       : AlexNet_cfg_table,
    'AlexNet_BN'    : AlexNet_BN_cfg_table,
    'VGG_16'        : VGG_16_cfg_table,
    'VGG_19'        : VGG_19_cfg_table,
    'Inception_BN'  : Inception_BN_cfg_table
}


inc_ch_table=[
    [64,  64, 96,128, 16, 32, 32],#3a
    [256,128,128,192, 32, 96, 64],#3b
    [480,192, 96,208, 16, 48, 64],#4a
    [512,160,112,224, 24, 64, 64],#4b
    [512,128,128,256, 24, 64, 64],#4c
    [512,112,144,288, 32, 64, 64],#4d
    [528,256,160,320, 32,128,128],#4e
    [832,256,160,320, 32,128,128],#5a
    [832,384,192,384, 48,128,128] #5b
]

# br0,br1,br2,br3 <- br1x1,br3x3,br5x5,brM
# 这里的第2,3个参数是channel中的索引
# 对于cfg拓展，可以认为'C'有'BR'参数，且bias为false。这里的一个项根据量化后可融合结构指定
inc_cfg_table = [
    [['C',0,1,1,1,0]],
    [['C',0,2,1,1,0],
     ['C',2,3,3,1,1]],
    [['C',0,4,1,1,0],
     ['C',4,5,5,1,2]],
    [['MP',3,1,1],
     ['R'],
     ['C',0,6,1,1,0]]
]